/*
 * Decompiled with CFR 0.152.
 */
package com.esproc.jdbc;

import com.esproc.jdbc.Blob;
import com.esproc.jdbc.Clob;
import com.esproc.jdbc.JDBCMessage;
import com.esproc.jdbc.JDBCUtil;
import com.esproc.jdbc.ResultSetMetaData;
import com.scudata.common.Logger;
import com.scudata.dm.BaseRecord;
import com.scudata.dm.DataStruct;
import com.scudata.dm.Param;
import com.scudata.dm.ParamList;
import com.scudata.dm.Sequence;
import com.scudata.dm.Table;
import com.scudata.dm.cursor.ICursor;
import com.scudata.util.Variant;
import java.io.ByteArrayInputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Array;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Map;

public class ResultSet
implements java.sql.ResultSet,
Externalizable {
    private static final long serialVersionUID = 1L;
    private ArrayList<ArrayList<Object>> dataArray;
    private ResultSetMetaData rsmd;
    private int currentRow;
    private ArrayList<Object> curRowData;
    private Statement stat;
    private ICursor cursor;
    private int fetchSize;
    private Sequence cache;
    private int cacheStart;
    public static final byte GET_EMPTY_RESULT = 0;
    public static final byte GET_PROCEDURES = 1;
    public static final byte GET_PROCEDURE_COLUMNS = 2;
    public static final byte GET_SCHEMAS = 3;
    public static final byte GET_TABLES = 4;
    public static final byte GET_COLUMNS = 5;
    public static final byte GET_CATALOGS = 6;
    public static final byte GET_TABLE_TYPES = 7;
    public static final byte GET_IMPORTED_KEYS = 8;
    public static final byte GET_EXPORTED_KEYS = 9;
    public static final byte GET_PRIMARY_KEYS = 10;

    public ResultSet() {
        this.dataArray = null;
        this.rsmd = null;
        this.currentRow = 0;
        this.curRowData = null;
        this.fetchSize = 102400;
        this.cache = null;
        this.cacheStart = 0;
    }

    public ResultSet(byte type) throws SQLException {
        this(type, null);
    }

    public ResultSet(byte type, ArrayList<Object> infos) throws SQLException {
        block12: {
            Table t;
            block18: {
                Table t2;
                block17: {
                    Table t3;
                    block16: {
                        Table t4;
                        block15: {
                            Table t5;
                            block14: {
                                block13: {
                                    Table t6;
                                    block11: {
                                        Table t7;
                                        this.dataArray = null;
                                        this.rsmd = null;
                                        this.currentRow = 0;
                                        this.curRowData = null;
                                        this.fetchSize = 102400;
                                        this.cache = null;
                                        this.cacheStart = 0;
                                        JDBCUtil.log("ResultSet(" + type + ",ArrayList<Object> infos)");
                                        this.rsmd = new ResultSetMetaData(type);
                                        this.dataArray = new ArrayList();
                                        if (type != 1) break block11;
                                        if (infos == null || (t7 = (Table)infos.get(0)) == null) break block12;
                                        int i = 1;
                                        int len = t7.length();
                                        while (i <= len) {
                                            BaseRecord record = t7.getRecord(i);
                                            ArrayList<Object> list = new ArrayList<Object>(this.rsmd.getColumnCount());
                                            list.add(null);
                                            list.add(null);
                                            list.add(record.getFieldValue("PROCEDURE_NAME"));
                                            list.add(null);
                                            list.add(null);
                                            list.add(null);
                                            list.add(null);
                                            list.add(null);
                                            list.add(record.getFieldValue("PROCEDURE_FILE"));
                                            this.dataArray.add(list);
                                            ++i;
                                        }
                                        break block12;
                                    }
                                    if (type != 2) break block13;
                                    if (infos == null || (t6 = (Table)infos.get(0)) == null) break block12;
                                    int r = 1;
                                    int len = t6.length();
                                    while (r <= len) {
                                        BaseRecord record = t6.getRecord(r);
                                        Object splName = record.getFieldValue("PROCEDURE_NAME");
                                        ParamList pl = (ParamList)record.getFieldValue("PARAM_LIST");
                                        int i = 0;
                                        int count = pl.count();
                                        while (i < count) {
                                            Param param = pl.get(i);
                                            ArrayList<Object> list = new ArrayList<Object>(this.rsmd.getColumnCount());
                                            list.add(null);
                                            list.add(null);
                                            list.add(splName);
                                            list.add(param.getName());
                                            list.add(1);
                                            list.add(2000);
                                            list.add("JAVA_OBJECT");
                                            list.add(null);
                                            list.add(null);
                                            list.add(null);
                                            list.add(null);
                                            list.add(1);
                                            list.add(null);
                                            Object defVal = param.getValue();
                                            list.add(Variant.toString(defVal));
                                            list.add(null);
                                            list.add(null);
                                            list.add(null);
                                            list.add(null);
                                            list.add("YES");
                                            list.add(null);
                                            this.dataArray.add(list);
                                            ++i;
                                        }
                                        ++r;
                                    }
                                    break block12;
                                }
                                if (type != 7) break block14;
                                ArrayList<String> list = new ArrayList<String>(this.rsmd.getColumnCount());
                                list.add("TABLE");
                                this.dataArray.add(list);
                                break block12;
                            }
                            if (type != 4) break block15;
                            if (infos == null || (t5 = (Table)infos.get(0)) == null) break block12;
                            int i = 1;
                            int len = t5.length();
                            while (i <= len) {
                                ArrayList<Object> list = new ArrayList<Object>(this.rsmd.getColumnCount());
                                list.add(null);
                                list.add(null);
                                list.add(t5.getRecord(i).getFieldValue("TABLE_NAME"));
                                list.add("TABLE");
                                list.add(null);
                                list.add(null);
                                list.add(null);
                                list.add(null);
                                list.add(null);
                                list.add(null);
                                this.dataArray.add(list);
                                ++i;
                            }
                            break block12;
                        }
                        if (type != 5) break block16;
                        if (infos == null || (t4 = (Table)infos.get(0)) == null) break block12;
                        int i = 1;
                        int len = t4.length();
                        while (i <= len) {
                            BaseRecord record = t4.getRecord(i);
                            byte colType = ((Number)record.getFieldValue("DATA_TYPE")).byteValue();
                            int sqlType = JDBCUtil.getSQLTypeByType(colType);
                            ArrayList<Object> list = new ArrayList<Object>(this.rsmd.getColumnCount());
                            list.add(null);
                            list.add(null);
                            list.add(record.getFieldValue("TABLE_NAME"));
                            list.add(record.getFieldValue("COLUMN_NAME"));
                            list.add(sqlType);
                            list.add(JDBCUtil.getTypeName(sqlType));
                            if (sqlType == 12) {
                                list.add(Integer.MAX_VALUE);
                            } else {
                                list.add(null);
                            }
                            list.add(0);
                            list.add(0);
                            list.add(0);
                            list.add(1);
                            list.add(null);
                            list.add(null);
                            list.add(sqlType);
                            list.add(0);
                            list.add(Integer.MAX_VALUE);
                            list.add(i);
                            list.add("YES");
                            list.add(null);
                            list.add(null);
                            list.add(null);
                            list.add(null);
                            list.add("NO");
                            list.add("NO");
                            this.dataArray.add(list);
                            ++i;
                        }
                        break block12;
                    }
                    if (type != 8) break block17;
                    if (infos == null || (t3 = (Table)infos.get(0)) == null) break block12;
                    int i = 1;
                    int len = t3.length();
                    while (i <= len) {
                        BaseRecord record = t3.getRecord(i);
                        ArrayList<Object> list = new ArrayList<Object>(this.rsmd.getColumnCount());
                        list.add(record.getFieldValue("PKTABLE_CAT"));
                        list.add(record.getFieldValue("PKTABLE_SCHEM"));
                        list.add(record.getFieldValue("PKTABLE_NAME"));
                        list.add(record.getFieldValue("PKCOLUMN_NAME"));
                        list.add(record.getFieldValue("FKTABLE_CAT"));
                        list.add(record.getFieldValue("FKTABLE_SCHEM"));
                        list.add(record.getFieldValue("FKTABLE_NAME"));
                        list.add(record.getFieldValue("FKCOLUMN_NAME"));
                        list.add(null);
                        list.add(null);
                        list.add(null);
                        list.add(record.getFieldValue("FK_NAME"));
                        list.add(null);
                        list.add(null);
                        this.dataArray.add(list);
                        ++i;
                    }
                    break block12;
                }
                if (type != 9) break block18;
                if (infos == null || (t2 = (Table)infos.get(0)) == null) break block12;
                int i = 1;
                int len = t2.length();
                while (i <= len) {
                    BaseRecord record = t2.getRecord(i);
                    ArrayList<Object> list = new ArrayList<Object>(this.rsmd.getColumnCount());
                    list.add(record.getFieldValue("PKTABLE_CAT"));
                    list.add(record.getFieldValue("PKTABLE_SCHEM"));
                    list.add(record.getFieldValue("PKTABLE_NAME"));
                    list.add(record.getFieldValue("PKCOLUMN_NAME"));
                    list.add(record.getFieldValue("FKTABLE_CAT"));
                    list.add(record.getFieldValue("FKTABLE_SCHEM"));
                    list.add(record.getFieldValue("FKTABLE_NAME"));
                    list.add(record.getFieldValue("FKCOLUMN_NAME"));
                    list.add(null);
                    list.add(null);
                    list.add(null);
                    list.add(record.getFieldValue("FK_NAME"));
                    list.add(null);
                    list.add(null);
                    this.dataArray.add(list);
                    ++i;
                }
                break block12;
            }
            if (type == 10 && infos != null && (t = (Table)infos.get(0)) != null) {
                int i = 1;
                int len = t.length();
                while (i <= len) {
                    BaseRecord record = t.getRecord(i);
                    ArrayList<Object> list = new ArrayList<Object>(this.rsmd.getColumnCount());
                    list.add(record.getFieldValue("TABLE_CAT"));
                    list.add(record.getFieldValue("TABLE_SCHEM"));
                    list.add(record.getFieldValue("TABLE_NAME"));
                    list.add(record.getFieldValue("COLUMN_NAME"));
                    list.add(record.getFieldValue("KEY_SEQ"));
                    list.add(null);
                    this.dataArray.add(list);
                    ++i;
                }
            }
        }
    }

    public ResultSet(ArrayList<ArrayList<Object>> dataArray, ResultSetMetaData rsmd) throws SQLException {
        this.dataArray = null;
        this.rsmd = null;
        this.currentRow = 0;
        this.curRowData = null;
        this.fetchSize = 102400;
        this.cache = null;
        this.cacheStart = 0;
        JDBCUtil.log("ResultSet(ArrayList<ArrayList<Object>> dataArray,ResultSetMetaData rsmd)");
        this.dataArray = dataArray;
        this.rsmd = rsmd;
    }

    public void setStatement(Statement stat) throws SQLException {
        this.stat = stat;
        this.setFetchSize(stat.getFetchSize());
    }

    public ResultSet(ICursor cursor) throws SQLException {
        String[] fields;
        this.dataArray = null;
        this.rsmd = null;
        this.currentRow = 0;
        this.curRowData = null;
        this.fetchSize = 102400;
        this.cache = null;
        this.cacheStart = 0;
        JDBCUtil.log("ResultSet(ICursor cursor)");
        this.cursor = cursor;
        DataStruct ds = cursor.getDataStruct();
        this.cache = cursor.fetch(1);
        if (this.cache != null && this.cache.length() > 0) {
            String[] fields2 = this.cache.dataStruct().getFieldNames();
            int[] types = new int[fields2.length];
            Object seqi = this.cache.get(1);
            if (seqi != null && seqi instanceof BaseRecord) {
                BaseRecord r = (BaseRecord)this.cache.get(1);
                int j = 0;
                while (j < fields2.length) {
                    Object o = r.getFieldValue(fields2[j]);
                    types[j] = o == null ? 0 : JDBCUtil.getType(o, types[j]);
                    ++j;
                }
            }
            this.rsmd = new ResultSetMetaData(fields2, types);
        } else if (ds != null && ds.getFieldCount() > 0 && (fields = ds.getFieldNames()) != null) {
            int[] types = new int[fields.length];
            int j = 0;
            while (j < fields.length) {
                types[j] = 0;
                ++j;
            }
            this.rsmd = new ResultSetMetaData(fields, types);
        }
    }

    @Override
    public boolean next() throws SQLException {
        JDBCUtil.log("ResultSet.next():" + this.currentRow);
        return this.moveCursor(this.currentRow + 1);
    }

    private boolean moveCursor(int pos) {
        if (this.moveCursorImpl(pos)) {
            return true;
        }
        this.curRowData = null;
        return false;
    }

    private boolean moveCursorImpl(int pos) {
        if (this.cursor != null) {
            if (this.cache == null || this.cache.length() == 0) {
                return false;
            }
            if (pos < this.cacheStart) {
                Logger.error("The cursor may move only forward.");
                return false;
            }
            if (pos - 1 == this.cacheStart + this.cache.length()) {
                this.cacheStart += this.cache.length();
                this.cache = this.cursor.fetch(this.fetchSize);
                if (this.cache == null || this.cache.length() == 0) {
                    return false;
                }
            }
            if (this.cacheStart > pos - 1 || pos - 1 > this.cacheStart + this.cache.length()) {
                long skip1 = pos - this.cacheStart - this.cache.length() - 1;
                long skip2 = this.cursor.skip(skip1);
                if (skip2 == skip1) {
                    this.cacheStart = (int)((long)this.cacheStart + skip1);
                    this.cache = this.cursor.fetch(this.fetchSize);
                    if (this.cache == null || this.cache.length() == 0) {
                        return false;
                    }
                } else {
                    return false;
                }
            }
            this.curRowData = this.translateRow(this.cache.get(pos - this.cacheStart));
            this.currentRow = pos;
            return true;
        }
        if (this.dataArray == null) {
            return false;
        }
        if (this.dataArray.size() == pos - 1) {
            this.currentRow = pos;
        }
        if (this.dataArray.size() < pos) {
            return false;
        }
        this.curRowData = this.dataArray.get(pos - 1);
        this.currentRow = pos;
        return true;
    }

    private ArrayList<Object> translateRow(Object o) {
        if (o instanceof BaseRecord) {
            BaseRecord r = (BaseRecord)o;
            ArrayList<Object> al = new ArrayList<Object>();
            int i = 0;
            while (i < r.getFieldCount()) {
                al.add(r.getFieldValue(i));
                ++i;
            }
            return al;
        }
        return null;
    }

    @Override
    public void close() throws SQLException {
        JDBCUtil.log("ResultSet.close()");
        if (this.cursor != null) {
            this.cursor.close();
        }
        this.cache = null;
        this.dataArray = null;
    }

    @Override
    public boolean wasNull() throws SQLException {
        JDBCUtil.log("ResultSet.wasNull()");
        return false;
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        JDBCUtil.log("ResultSet.getString(" + columnIndex + ")");
        Object o = this.curRowData.get(columnIndex - 1);
        return o == null ? null : o.toString();
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        JDBCUtil.log("ResultSet.getBoolean(" + columnIndex + ")");
        return (Boolean)this.curRowData.get(columnIndex - 1);
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        JDBCUtil.log("ResultSet.getByte(" + columnIndex + ")");
        Object o = this.curRowData.get(columnIndex - 1);
        if (o instanceof Number) {
            return ((Number)o).byteValue();
        }
        return Byte.parseByte(o == null ? "0" : o.toString());
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        JDBCUtil.log("ResultSet.getShort(" + columnIndex + ")");
        Object o = this.curRowData.get(columnIndex - 1);
        if (o instanceof Number) {
            return ((Number)o).shortValue();
        }
        return Short.parseShort(o == null ? "0" : o.toString());
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        JDBCUtil.log("ResultSet.getInt(" + columnIndex + ")");
        Object o = this.curRowData.get(columnIndex - 1);
        if (o instanceof Number) {
            return ((Number)o).intValue();
        }
        return Integer.parseInt(o == null ? "0" : o.toString());
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        JDBCUtil.log("ResultSet.getLong(" + columnIndex + ")");
        Object o = this.curRowData.get(columnIndex - 1);
        if (o instanceof Number) {
            return ((Number)o).longValue();
        }
        return Long.parseLong(o == null ? "0" : o.toString());
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        JDBCUtil.log("ResultSet.getFloat(" + columnIndex + ")");
        Object o = this.curRowData.get(columnIndex - 1);
        if (o instanceof Number) {
            return ((Number)o).floatValue();
        }
        return Float.parseFloat(o == null ? "0" : o.toString());
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        JDBCUtil.log("ResultSet.getDouble(" + columnIndex + ")");
        Object o = this.curRowData.get(columnIndex - 1);
        if (o instanceof Number) {
            return ((Number)o).doubleValue();
        }
        return Double.parseDouble(o == null ? "0" : o.toString());
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        JDBCUtil.log("ResultSet.getBigDecimal(" + columnIndex + "," + scale + ")");
        Object obj = this.curRowData.get(columnIndex - 1);
        if (obj instanceof Double) {
            return new BigDecimal((Double)obj);
        }
        if (obj instanceof String) {
            return new BigDecimal((String)obj);
        }
        if (obj instanceof BigInteger) {
            return new BigDecimal((BigInteger)obj, scale);
        }
        if (obj instanceof BigDecimal) {
            return (BigDecimal)obj;
        }
        if (obj instanceof Long) {
            return new BigDecimal((Long)obj);
        }
        if (obj instanceof Float) {
            return new BigDecimal(((Float)obj).floatValue());
        }
        return null;
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        JDBCUtil.log("ResultSet.getBytes(" + columnIndex + ")");
        Object o = this.curRowData.get(columnIndex - 1);
        if (o == null) {
            return null;
        }
        if (o instanceof byte[]) {
            return (byte[])o;
        }
        if (o instanceof String) {
            return o.toString().getBytes();
        }
        return null;
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        JDBCUtil.log("ResultSet.getDate(" + columnIndex + ")");
        Object obj = this.curRowData.get(columnIndex - 1);
        if (obj != null) {
            if (obj instanceof Date) {
                return (Date)obj;
            }
            if (obj instanceof java.util.Date) {
                return new Date(((java.util.Date)obj).getTime());
            }
        }
        return null;
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        JDBCUtil.log("ResultSet.getTime(" + columnIndex + ")");
        Object obj = this.curRowData.get(columnIndex - 1);
        if (obj != null) {
            if (obj instanceof Time) {
                return (Time)obj;
            }
            if (obj instanceof java.util.Date) {
                return new Time(((java.util.Date)obj).getTime());
            }
        }
        return null;
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        JDBCUtil.log("ResultSet.getTimestamp(" + columnIndex + ")");
        Object obj = this.curRowData.get(columnIndex - 1);
        if (obj != null) {
            if (obj instanceof Timestamp) {
                return (Timestamp)obj;
            }
            if (obj instanceof java.util.Date) {
                return new Timestamp(((java.util.Date)obj).getTime());
            }
        }
        return null;
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        JDBCUtil.log("ResultSet.getAsciiStream(" + columnIndex + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "getAsciiStream(int columnIndex)"));
        return null;
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        JDBCUtil.log("ResultSet.getUnicodeStream(" + columnIndex + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "getUnicodeStream(int columnIndex)"));
        return null;
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        JDBCUtil.log("ResultSet.getBinaryStream(" + columnIndex + ")");
        Object o = this.curRowData.get(columnIndex - 1);
        if (o == null) {
            return null;
        }
        if (o instanceof InputStream) {
            return (InputStream)o;
        }
        if (o instanceof byte[]) {
            return new ByteArrayInputStream((byte[])o);
        }
        return null;
    }

    @Override
    public String getString(String columnName) throws SQLException {
        JDBCUtil.log("ResultSet.getString(" + columnName + ")");
        int columnIndex = this.findColumn(columnName);
        if (columnIndex == -1) {
            return null;
        }
        return this.getString(columnIndex);
    }

    @Override
    public boolean getBoolean(String columnName) throws SQLException {
        JDBCUtil.log("ResultSet.getBoolean(" + columnName + ")");
        int columnIndex = this.findColumn(columnName);
        if (columnIndex == -1) {
            return false;
        }
        return this.getBoolean(columnIndex);
    }

    @Override
    public byte getByte(String columnName) throws SQLException {
        JDBCUtil.log("ResultSet.getByte(" + columnName + ")");
        int columnIndex = this.findColumn(columnName);
        if (columnIndex == -1) {
            return -1;
        }
        return this.getByte(columnIndex);
    }

    @Override
    public short getShort(String columnName) throws SQLException {
        JDBCUtil.log("ResultSet.getShort(" + columnName + ")");
        int columnIndex = this.findColumn(columnName);
        if (columnIndex == -1) {
            return -1;
        }
        return this.getShort(columnIndex);
    }

    @Override
    public int getInt(String columnName) throws SQLException {
        JDBCUtil.log("ResultSet.getInt(" + columnName + ")");
        int columnIndex = this.findColumn(columnName);
        if (columnIndex == -1) {
            return -1;
        }
        return this.getInt(columnIndex);
    }

    @Override
    public long getLong(String columnName) throws SQLException {
        JDBCUtil.log("ResultSet.getLong(" + columnName + ")");
        int columnIndex = this.findColumn(columnName);
        if (columnIndex == -1) {
            return -1L;
        }
        return this.getLong(columnIndex);
    }

    @Override
    public float getFloat(String columnName) throws SQLException {
        JDBCUtil.log("ResultSet.getFloat(" + columnName + ")");
        int columnIndex = this.findColumn(columnName);
        if (columnIndex == -1) {
            return -1.0f;
        }
        return this.getFloat(columnIndex);
    }

    @Override
    public double getDouble(String columnName) throws SQLException {
        JDBCUtil.log("ResultSet.getDouble(" + columnName + ")");
        int columnIndex = this.findColumn(columnName);
        if (columnIndex == -1) {
            return -1.0;
        }
        return this.getDouble(columnIndex);
    }

    @Override
    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        JDBCUtil.log("ResultSet.getBigDecimal(" + columnName + "," + scale + ")");
        int columnIndex = this.findColumn(columnName);
        if (columnIndex == -1) {
            return null;
        }
        return this.getBigDecimal(columnIndex, scale);
    }

    @Override
    public byte[] getBytes(String columnName) throws SQLException {
        JDBCUtil.log("ResultSet.getBytes(" + columnName + ")");
        int columnIndex = this.findColumn(columnName);
        if (columnIndex == -1) {
            return null;
        }
        return this.getBytes(columnIndex);
    }

    @Override
    public Date getDate(String columnName) throws SQLException {
        JDBCUtil.log("ResultSet.getDate(" + columnName + ")");
        int columnIndex = this.findColumn(columnName);
        if (columnIndex == -1) {
            return null;
        }
        return this.getDate(columnIndex);
    }

    @Override
    public Time getTime(String columnName) throws SQLException {
        JDBCUtil.log("ResultSet.getTime(" + columnName + ")");
        int columnIndex = this.findColumn(columnName);
        if (columnIndex == -1) {
            return null;
        }
        return this.getTime(columnIndex);
    }

    @Override
    public Timestamp getTimestamp(String columnName) throws SQLException {
        JDBCUtil.log("ResultSet.getTimestamp(" + columnName + ")");
        int columnIndex = this.findColumn(columnName);
        if (columnIndex == -1) {
            return null;
        }
        return this.getTimestamp(columnIndex);
    }

    @Override
    public InputStream getAsciiStream(String columnName) throws SQLException {
        JDBCUtil.log("ResultSet.getAsciiStream(" + columnName + ")");
        int columnIndex = this.findColumn(columnName);
        if (columnIndex == -1) {
            return null;
        }
        return this.getAsciiStream(columnIndex);
    }

    @Override
    public InputStream getUnicodeStream(String columnName) throws SQLException {
        JDBCUtil.log("ResultSet.getUnicodeStream(" + columnName + ")");
        int columnIndex = this.findColumn(columnName);
        if (columnIndex == -1) {
            return null;
        }
        return this.getUnicodeStream(columnIndex);
    }

    @Override
    public InputStream getBinaryStream(String columnName) throws SQLException {
        JDBCUtil.log("ResultSet.getBinaryStream(" + columnName + ")");
        int columnIndex = this.findColumn(columnName);
        if (columnIndex == -1) {
            return null;
        }
        return this.getBinaryStream(columnIndex);
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        JDBCUtil.log("ResultSet.getWarnings()");
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        JDBCUtil.log("ResultSet.clearWarnings()");
    }

    @Override
    public String getCursorName() throws SQLException {
        JDBCUtil.log("ResultSet.getCursorName()");
        return null;
    }

    @Override
    public java.sql.ResultSetMetaData getMetaData() throws SQLException {
        JDBCUtil.log("ResultSet.getMetaData()");
        if (this.rsmd == null) {
            throw new SQLException("The result set has no data struct.");
        }
        return this.rsmd;
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        JDBCUtil.log("ResultSet.getObject(" + columnIndex + ")");
        return this.curRowData.get(columnIndex - 1);
    }

    @Override
    public Object getObject(String columnName) throws SQLException {
        JDBCUtil.log("ResultSet.getObject(" + columnName + ")");
        int columnIndex = this.findColumn(columnName);
        if (columnIndex == -1) {
            return null;
        }
        return this.getObject(columnIndex);
    }

    @Override
    public int findColumn(String columnName) throws SQLException {
        JDBCUtil.log("ResultSet.findColumn(" + columnName + ")");
        int i = 1;
        while (i <= this.rsmd.getColumnCount()) {
            String name = this.rsmd.getColumnName(i);
            if (name.equals(columnName)) {
                return i;
            }
            ++i;
        }
        throw new SQLException("No field name: " + columnName + " can be found.");
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        JDBCUtil.log("ResultSet.getCharacterStream(" + columnIndex + ")");
        Object o = this.curRowData.get(columnIndex - 1);
        if (o == null) {
            return null;
        }
        if (o instanceof Reader) {
            return (Reader)o;
        }
        return new StringReader(o.toString());
    }

    @Override
    public Reader getCharacterStream(String columnName) throws SQLException {
        JDBCUtil.log("ResultSet.getCharacterStream(" + columnName + ")");
        int columnIndex = this.findColumn(columnName);
        if (columnIndex == -1) {
            return null;
        }
        return this.getCharacterStream(columnIndex);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        JDBCUtil.log("ResultSet.getBigDecimal(" + columnIndex + ")");
        return this.getBigDecimal(columnIndex, 1);
    }

    @Override
    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        JDBCUtil.log("ResultSet.getBigDecimal(" + columnName + ")");
        int columnIndex = this.findColumn(columnName);
        if (columnIndex == -1) {
            return null;
        }
        return this.getBigDecimal(columnIndex);
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        JDBCUtil.log("ResultSet.isBeforeFirst()");
        return this.currentRow == 0;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        JDBCUtil.log("ResultSet.isAfterLast()");
        if (this.cursor != null) {
            if (this.cache == null || this.cache.length() == 0) {
                return true;
            }
            return this.currentRow == this.cacheStart + this.cache.length() + 1;
        }
        if (this.dataArray == null) {
            return true;
        }
        return this.currentRow == this.dataArray.size() + 1;
    }

    @Override
    public boolean isFirst() throws SQLException {
        JDBCUtil.log("ResultSet.isFirst()");
        return this.currentRow == 1;
    }

    @Override
    public boolean isLast() throws SQLException {
        JDBCUtil.log("ResultSet.isLast()");
        if (this.cursor != null) {
            if (this.cache == null || this.cache.length() == 0) {
                return false;
            }
            return this.currentRow == this.cacheStart + this.cache.length();
        }
        return this.dataArray != null && this.currentRow == this.dataArray.size();
    }

    @Override
    public void beforeFirst() throws SQLException {
        JDBCUtil.log("ResultSet.beforeFirst()");
        if (this.cursor != null) {
            Logger.error("The cursor may move only forward.");
            return;
        }
        if (this.dataArray != null) {
            this.currentRow = 0;
            this.curRowData = this.dataArray.get(this.currentRow);
        }
    }

    @Override
    public void afterLast() throws SQLException {
        JDBCUtil.log("ResultSet.afterLast()");
        if (this.cursor != null) {
            if (this.cache == null || this.cache.length() == 0) {
                return;
            }
            this.currentRow = this.cacheStart + this.cache.length();
            this.cacheStart = this.currentRow = (int)((long)this.currentRow + this.cursor.skip());
            return;
        }
        if (this.dataArray != null) {
            this.currentRow = this.dataArray.size() - 1;
            this.curRowData = this.dataArray.get(this.currentRow);
        }
    }

    @Override
    public boolean first() throws SQLException {
        JDBCUtil.log("ResultSet.first()");
        return this.moveCursor(1);
    }

    @Override
    public boolean last() throws SQLException {
        JDBCUtil.log("ResultSet.last()");
        if (this.cursor != null) {
            Sequence tmpCache;
            if (this.cache == null || this.cache.length() == 0) {
                return false;
            }
            this.currentRow += this.cache.length();
            while ((tmpCache = this.cursor.fetch(this.fetchSize)) != null) {
                this.cache = tmpCache;
                this.currentRow += this.cache.length();
            }
            this.cacheStart = this.currentRow - this.cache.length();
            return true;
        }
        if (this.dataArray == null) {
            return false;
        }
        this.currentRow = this.dataArray.size() - 1;
        this.curRowData = this.dataArray.get(this.currentRow);
        return true;
    }

    @Override
    public int getRow() throws SQLException {
        JDBCUtil.log("ResultSet.getRow()");
        return this.currentRow;
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        JDBCUtil.log("ResultSet.absolute(" + row + ")");
        return this.moveCursor(row);
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        JDBCUtil.log("ResultSet.relative(" + rows + ")");
        return this.moveCursor(this.currentRow + rows);
    }

    @Override
    public boolean previous() throws SQLException {
        JDBCUtil.log("ResultSet.previous()");
        return this.moveCursor(this.currentRow - 1);
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        JDBCUtil.log("ResultSet.setFetchDirection(" + direction + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "setFetchDirection(int direction)"));
    }

    @Override
    public int getFetchDirection() throws SQLException {
        JDBCUtil.log("ResultSet.getFetchDirection()");
        return 1000;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        JDBCUtil.log("ResultSet.setFetchSize(" + rows + ")");
        this.fetchSize = rows >= 1 ? rows : 102400;
    }

    @Override
    public int getFetchSize() throws SQLException {
        JDBCUtil.log("ResultSet.getFetchSize()");
        return this.fetchSize;
    }

    @Override
    public int getType() throws SQLException {
        JDBCUtil.log("ResultSet.getType()");
        return 1003;
    }

    @Override
    public int getConcurrency() throws SQLException {
        JDBCUtil.log("ResultSet.getConcurrency()");
        return 1007;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        JDBCUtil.log("ResultSet.rowUpdated()");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "rowUpdated()"));
        return false;
    }

    @Override
    public boolean rowInserted() throws SQLException {
        JDBCUtil.log("ResultSet.rowInserted()");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "rowInserted()"));
        return false;
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        JDBCUtil.log("ResultSet.rowDeleted()");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "rowDeleted()"));
        return false;
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        JDBCUtil.log("ResultSet.updateNull(" + columnIndex + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "updateNull(int columnIndex)"));
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        JDBCUtil.log("ResultSet.updateBoolean(" + columnIndex + "," + x + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "updateBoolean(int columnIndex, boolean x)"));
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        JDBCUtil.log("ResultSet.updateByte(" + columnIndex + "," + x + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "updateByte(int columnIndex, byte x)"));
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        JDBCUtil.log("ResultSet.updateShort(" + columnIndex + "," + x + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "updateShort(int columnIndex, short x)"));
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        JDBCUtil.log("ResultSet.updateInt(" + columnIndex + "," + x + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "updateInt(int columnIndex, int x)"));
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        JDBCUtil.log("ResultSet.updateLong(" + columnIndex + "," + x + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "updateLong(int columnIndex, long x)"));
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        JDBCUtil.log("ResultSet.updateFloat(" + columnIndex + "," + x + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "updateFloat(int columnIndex, float x)"));
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        JDBCUtil.log("ResultSet.updateDouble(" + columnIndex + "," + x + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "updateDouble(int columnIndex, double x)"));
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        JDBCUtil.log("ResultSet.updateBigDecimal(" + columnIndex + "," + x + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "updateBigDecimal(int columnIndex, BigDecimal x)"));
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        JDBCUtil.log("ResultSet.updateString(" + columnIndex + "," + x + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "updateString(int columnIndex, String x)"));
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        JDBCUtil.log("ResultSet.updateBytes(" + columnIndex + ", byte[] x)");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "updateBytes(int columnIndex, byte[] x)"));
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        JDBCUtil.log("ResultSet.updateDate(" + columnIndex + "," + x + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "updateDate(int columnIndex, Date x)"));
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        JDBCUtil.log("ResultSet.updateTime(" + columnIndex + "," + x + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "updateTime(int columnIndex, Time x)"));
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        JDBCUtil.log("ResultSet.updateTimestamp(" + columnIndex + "," + x + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "updateTimestamp(int columnIndex, Timestamp x)"));
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        JDBCUtil.log("ResultSet.updateAsciiStream(" + columnIndex + ",InputStream x," + length + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "updateAsciiStream(int columnIndex, InputStream x, int length)"));
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        JDBCUtil.log("ResultSet.updateBinaryStream(" + columnIndex + ",InputStream x," + length + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "updateBinaryStream(int columnIndex, InputStream x, int length)"));
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        JDBCUtil.log("ResultSet.updateCharacterStream(" + columnIndex + ",Reader x," + length + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "updateCharacterStream(int columnIndex, Reader x, int length)"));
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scaleOrLength) throws SQLException {
        JDBCUtil.log("ResultSet.updateObject(" + columnIndex + "," + x + "," + scaleOrLength + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "updateObject(int columnIndex, Object x, int scaleOrLength)"));
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        JDBCUtil.log("ResultSet.updateObject(" + columnIndex + "," + x + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "updateObject(int columnIndex, Object x)"));
    }

    @Override
    public void updateNull(String columnName) throws SQLException {
        JDBCUtil.log("ResultSet.updateNull(" + columnName + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "updateNull(String columnName)"));
    }

    @Override
    public void updateBoolean(String columnName, boolean x) throws SQLException {
        JDBCUtil.log("ResultSet.updateBoolean(" + columnName + "," + x + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "updateBoolean(String columnName, boolean x)"));
    }

    @Override
    public void updateByte(String columnName, byte x) throws SQLException {
        JDBCUtil.log("ResultSet.updateByte(" + columnName + "," + x + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "updateByte(String columnName, byte x)"));
    }

    @Override
    public void updateShort(String columnName, short x) throws SQLException {
        JDBCUtil.log("ResultSet.updateShort(" + columnName + "," + x + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "updateShort(String columnName, short x)"));
    }

    @Override
    public void updateInt(String columnName, int x) throws SQLException {
        JDBCUtil.log("ResultSet.updateInt(" + columnName + "," + x + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "updateInt(String columnName, int x)"));
    }

    @Override
    public void updateLong(String columnName, long x) throws SQLException {
        JDBCUtil.log("ResultSet.updateLong(" + columnName + "," + x + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "updateLong(String columnName, long x)"));
    }

    @Override
    public void updateFloat(String columnName, float x) throws SQLException {
        JDBCUtil.log("ResultSet.updateFloat(" + columnName + "," + x + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "updateFloat(String columnName, float x)"));
    }

    @Override
    public void updateDouble(String columnName, double x) throws SQLException {
        JDBCUtil.log("ResultSet.updateDouble(" + columnName + "," + x + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "updateDouble(String columnName, double x)"));
    }

    @Override
    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        JDBCUtil.log("ResultSet.updateBigDecimal(" + columnName + "," + x + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "updateBigDecimal(String columnName, BigDecimal x)"));
    }

    @Override
    public void updateString(String columnName, String x) throws SQLException {
        JDBCUtil.log("ResultSet.updateString(" + columnName + "," + x + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "updateString(String columnName, String x)"));
    }

    @Override
    public void updateBytes(String columnName, byte[] x) throws SQLException {
        JDBCUtil.log("ResultSet.updateBytes(" + columnName + ", byte[] x)");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "updateBytes(String columnName, byte[] x)"));
    }

    @Override
    public void updateDate(String columnName, Date x) throws SQLException {
        JDBCUtil.log("ResultSet.updateDate(" + columnName + "," + x + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "updateDate(String columnName, Date x)"));
    }

    @Override
    public void updateTime(String columnName, Time x) throws SQLException {
        JDBCUtil.log("ResultSet.updateTime(" + columnName + "," + x + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "updateTime(String columnName, Time x)"));
    }

    @Override
    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        JDBCUtil.log("ResultSet.updateTimestamp(" + columnName + "," + x + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "updateTimestamp(String columnName, Timestamp x)"));
    }

    @Override
    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        JDBCUtil.log("ResultSet.updateAsciiStream(" + columnName + ",InputStream x," + length + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "updateAsciiStream(String columnName, InputStream x, int length)"));
    }

    @Override
    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        JDBCUtil.log("ResultSet.updateBinaryStream(" + columnName + ",InputStream x," + length + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "updateBinaryStream(String columnName, InputStream x, int length)"));
    }

    @Override
    public void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        JDBCUtil.log("ResultSet.updateCharacterStream(" + columnName + ",Reader reader," + length + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "updateCharacterStream(String columnName, Reader reader, int length)"));
    }

    @Override
    public void updateObject(String columnName, Object x, int scaleOrLength) throws SQLException {
        JDBCUtil.log("ResultSet.updateObject(" + columnName + "," + x + "," + scaleOrLength + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "updateObject(String columnName, Object x, int scaleOrLength)"));
    }

    @Override
    public void updateObject(String columnName, Object x) throws SQLException {
        JDBCUtil.log("ResultSet.updateObject(" + columnName + "," + x + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "updateObject(String columnName, Object x)"));
    }

    @Override
    public void insertRow() throws SQLException {
        JDBCUtil.log("ResultSet.insertRow()");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "insertRow()"));
    }

    @Override
    public void updateRow() throws SQLException {
        JDBCUtil.log("ResultSet.updateRow()");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "updateRow()"));
    }

    @Override
    public void deleteRow() throws SQLException {
        JDBCUtil.log("ResultSet.deleteRow()");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "deleteRow()"));
    }

    @Override
    public void refreshRow() throws SQLException {
        JDBCUtil.log("ResultSet.refreshRow()");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "refreshRow()"));
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        JDBCUtil.log("ResultSet.cancelRowUpdates()");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "cancelRowUpdates()"));
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        JDBCUtil.log("ResultSet.moveToInsertRow()");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "moveToInsertRow()"));
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        JDBCUtil.log("ResultSet.moveToCurrentRow()");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "moveToCurrentRow()"));
    }

    @Override
    public Statement getStatement() throws SQLException {
        JDBCUtil.log("ResultSet.getStatement()");
        return this.stat;
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        JDBCUtil.log("ResultSet.getRef(" + columnIndex + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "getRef(int columnIndex)"));
        return null;
    }

    @Override
    public java.sql.Blob getBlob(int columnIndex) throws SQLException {
        JDBCUtil.log("ResultSet.getBlob(" + columnIndex + ")");
        byte[] bs = this.getBytes(columnIndex);
        if (bs == null) {
            return null;
        }
        return new Blob(bs);
    }

    @Override
    public java.sql.Clob getClob(int columnIndex) throws SQLException {
        JDBCUtil.log("ResultSet.getClob(" + columnIndex + ")");
        return new Clob(this.getString(columnIndex));
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        JDBCUtil.log("ResultSet.getArray(" + columnIndex + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "getArray(int columnIndex)"));
        return null;
    }

    @Override
    public Ref getRef(String colName) throws SQLException {
        JDBCUtil.log("ResultSet.getRef(" + colName + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "getRef(String colName)"));
        return null;
    }

    @Override
    public java.sql.Blob getBlob(String colName) throws SQLException {
        JDBCUtil.log("ResultSet.getBlob(" + colName + ")");
        byte[] bs = this.getBytes(colName);
        if (bs == null) {
            return null;
        }
        return new Blob(bs);
    }

    @Override
    public java.sql.Clob getClob(String colName) throws SQLException {
        JDBCUtil.log("ResultSet.getClob(" + colName + ")");
        return new Clob(this.getString(colName));
    }

    @Override
    public Array getArray(String colName) throws SQLException {
        JDBCUtil.log("ResultSet.getArray(" + colName + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "getArray(String colName)"));
        return null;
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        JDBCUtil.log("ResultSet.getDate(" + columnIndex + "," + cal + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "getDate(int columnIndex, Calendar cal)"));
        return null;
    }

    @Override
    public Date getDate(String columnName, Calendar cal) throws SQLException {
        JDBCUtil.log("ResultSet.getDate(" + columnName + "," + cal + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "getDate(String columnName, Calendar cal)"));
        return null;
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        JDBCUtil.log("ResultSet.getTime(" + columnIndex + "," + cal + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "getTime(int columnIndex, Calendar cal)"));
        return null;
    }

    @Override
    public Time getTime(String columnName, Calendar cal) throws SQLException {
        JDBCUtil.log("ResultSet.getTime(" + columnName + "," + cal + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "getTime(String columnName, Calendar cal)"));
        return null;
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        JDBCUtil.log("ResultSet.getTimestamp(" + columnIndex + "," + cal + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "getTimestamp(int columnIndex, Calendar cal)"));
        return null;
    }

    @Override
    public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        JDBCUtil.log("ResultSet.getTimestamp(" + columnName + "," + cal + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "getTimestamp(String columnName, Calendar cal)"));
        return null;
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        JDBCUtil.log("ResultSet.getURL(" + columnIndex + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "getURL(int columnIndex)"));
        return null;
    }

    @Override
    public URL getURL(String columnName) throws SQLException {
        JDBCUtil.log("ResultSet.getURL(" + columnName + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "getURL(String columnName)"));
        return null;
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        JDBCUtil.log("ResultSet.updateRef(" + columnIndex + ",Ref x)");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "updateRef(int columnIndex, Ref x)"));
    }

    @Override
    public void updateRef(String columnName, Ref x) throws SQLException {
        JDBCUtil.log("ResultSet.updateRef(" + columnName + ",Ref x)");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "updateRef(String columnName, Ref x)"));
    }

    @Override
    public void updateBlob(int columnIndex, java.sql.Blob x) throws SQLException {
        JDBCUtil.log("ResultSet.updateBlob(" + columnIndex + ",Blob x)");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "updateBlob(int columnIndex, Blob x)"));
    }

    @Override
    public void updateBlob(String columnName, java.sql.Blob x) throws SQLException {
        JDBCUtil.log("ResultSet.updateBlob(" + columnName + ",Blob x)");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "updateBlob(String columnName, Blob x)"));
    }

    @Override
    public void updateClob(int columnIndex, java.sql.Clob x) throws SQLException {
        JDBCUtil.log("ResultSet.updateClob(" + columnIndex + ",Clob x)");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "updateClob(int columnIndex, Clob x)"));
    }

    @Override
    public void updateClob(String columnName, java.sql.Clob x) throws SQLException {
        JDBCUtil.log("ResultSet.updateClob(" + columnName + ",Clob x)");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "updateClob(String columnName, Clob x)"));
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        JDBCUtil.log("ResultSet.updateArray(" + columnIndex + ",Array x)");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "updateArray(int columnIndex, Array x)"));
    }

    @Override
    public void updateArray(String columnName, Array x) throws SQLException {
        JDBCUtil.log("ResultSet.updateArray(" + columnName + ",Array x)");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "updateArray(String columnName, Array x)"));
    }

    @Override
    public int getHoldability() throws SQLException {
        JDBCUtil.log("ResultSet.getHoldability()");
        return 2;
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        JDBCUtil.log("ResultSet.getNCharacterStream(" + columnIndex + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "getNCharacterStream(int columnIndex)"));
        return null;
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        JDBCUtil.log("ResultSet.getNCharacterStream(" + columnLabel + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "getNCharacterStream(String columnLabel)"));
        return null;
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        JDBCUtil.log("ResultSet.getNClob(" + columnIndex + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "getNClob(int columnIndex)"));
        return null;
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        JDBCUtil.log("ResultSet.getNClob(" + columnLabel + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "getNClob(String columnLabel)"));
        return null;
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        JDBCUtil.log("ResultSet.getNString(" + columnIndex + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "getNString(int columnIndex)"));
        return null;
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        JDBCUtil.log("ResultSet.getNString(" + columnLabel + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "getNString(String columnLabel)"));
        return null;
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> type) throws SQLException {
        JDBCUtil.log("ResultSet.getObject(" + columnIndex + ",Map<String, Class<?>> type)");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "getObject(int columnIndex, Map<String, Class<?>> type)"));
        return null;
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        JDBCUtil.log("ResultSet.getObject(" + columnLabel + ",Map<String, Class<?>> type)");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "getObject(String columnLabel, Map<String, Class<?>> map)"));
        return null;
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        JDBCUtil.log("ResultSet.getRowId(" + columnIndex + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "getRowId(int columnIndex)"));
        return null;
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        JDBCUtil.log("ResultSet.getRowId(" + columnLabel + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "getRowId(String columnLabel)"));
        return null;
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        JDBCUtil.log("ResultSet.getSQLXML(" + columnIndex + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "getSQLXML(int columnIndex)"));
        return null;
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        JDBCUtil.log("ResultSet.getSQLXML(" + columnLabel + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "getSQLXML(String columnLabel)"));
        return null;
    }

    @Override
    public boolean isClosed() throws SQLException {
        JDBCUtil.log("ResultSet.isClosed()");
        return false;
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        JDBCUtil.log("ResultSet.updateAsciiStream(" + columnIndex + ",InputStream x)");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "updateAsciiStream(int columnIndex, InputStream x)"));
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        JDBCUtil.log("ResultSet.updateAsciiStream(" + columnLabel + ",InputStream x)");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "updateAsciiStream(String columnLabel, InputStream x)"));
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        JDBCUtil.log("ResultSet.updateAsciiStream(" + columnIndex + ",InputStream x," + length + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "updateAsciiStream(int columnIndex, InputStream x, long length)"));
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        JDBCUtil.log("ResultSet.updateAsciiStream(" + columnLabel + ",InputStream x," + length + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "updateAsciiStream(String columnLabel, InputStream x, long length)"));
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        JDBCUtil.log("ResultSet.updateBinaryStream(" + columnIndex + ",InputStream x)");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "updateBinaryStream(int columnIndex, InputStream x)"));
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        JDBCUtil.log("ResultSet.updateBinaryStream(" + columnLabel + ",InputStream x)");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "updateBinaryStream(String columnLabel, InputStream x)"));
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        JDBCUtil.log("ResultSet.updateBinaryStream(" + columnIndex + ",InputStream x," + length + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "updateBinaryStream(int columnIndex, InputStream x, long length)"));
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        JDBCUtil.log("ResultSet.updateBinaryStream(" + columnLabel + ",InputStream x," + length + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "updateBinaryStream(String columnLabel, InputStream x, long length)"));
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        JDBCUtil.log("ResultSet.updateBlob(" + columnIndex + ",InputStream inputStream)");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "updateBlob(int columnIndex, InputStream inputStream)"));
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        JDBCUtil.log("ResultSet.updateBlob(" + columnLabel + ",InputStream inputStream)");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "updateBlob(String columnLabel, InputStream inputStream)"));
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        JDBCUtil.log("ResultSet.updateBlob(" + columnIndex + ",InputStream inputStream," + length + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "updateBlob(int columnIndex, InputStream inputStream, long length)"));
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        JDBCUtil.log("ResultSet.updateBlob(" + columnLabel + ",InputStream inputStream," + length + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "updateBlob(int columnIndex, InputStream inputStream, long length)"));
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        JDBCUtil.log("ResultSet.updateCharacterStream(" + columnIndex + ",Reader x)");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "updateCharacterStream(int columnIndex, Reader x)"));
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        JDBCUtil.log("ResultSet.updateCharacterStream(" + columnLabel + ",Reader reader)");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "updateCharacterStream(String columnLabel, Reader reader)"));
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        JDBCUtil.log("ResultSet.updateCharacterStream(" + columnIndex + ",Reader reader," + length + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "updateCharacterStream(int columnIndex, Reader x, long length)"));
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        JDBCUtil.log("ResultSet.updateCharacterStream(" + columnLabel + ",Reader reader," + length + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "updateCharacterStream(String columnLabel, Reader reader, long length)"));
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        JDBCUtil.log("ResultSet.updateClob(" + columnIndex + ",Reader reader)");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "updateClob(int columnIndex, Reader reader)"));
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        JDBCUtil.log("ResultSet.updateClob(" + columnLabel + ",Reader reader)");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "updateClob(String columnLabel, Reader reader)"));
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        JDBCUtil.log("ResultSet.updateClob(" + columnIndex + ",Reader reader," + length + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "updateClob(int columnIndex, Reader reader, long length)"));
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        JDBCUtil.log("ResultSet.updateClob(" + columnLabel + ",Reader reader," + length + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "updateClob(String columnLabel, Reader reader, long length)"));
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        JDBCUtil.log("ResultSet.updateNCharacterStream(" + columnIndex + ",Reader reader)");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "updateNCharacterStream(int columnIndex, Reader x)"));
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        JDBCUtil.log("ResultSet.updateNCharacterStream(" + columnLabel + ",Reader reader)");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "updateNCharacterStream(String columnLabel, Reader reader)"));
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        JDBCUtil.log("ResultSet.updateNCharacterStream(" + columnIndex + ",Reader reader," + length + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "updateNCharacterStream(int columnIndex, Reader x, long length)"));
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        JDBCUtil.log("ResultSet.updateNCharacterStream(" + columnLabel + ",Reader reader," + length + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "updateNCharacterStream(String columnLabel, Reader reader, long length)"));
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        JDBCUtil.log("ResultSet.updateNClob(" + columnIndex + ",NClob nClob)");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "updateNClob(int columnIndex, NClob nClob)"));
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
        JDBCUtil.log("ResultSet.updateNClob(" + columnLabel + ",NClob nClob)");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "updateNClob(String columnLabel, NClob nClob)"));
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        JDBCUtil.log("ResultSet.updateNClob(" + columnIndex + ",Reader reader)");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "updateNClob(int columnIndex, Reader reader)"));
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        JDBCUtil.log("ResultSet.updateNClob(" + columnLabel + ",Reader reader)");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "updateNClob(String columnLabel, Reader reader)"));
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        JDBCUtil.log("ResultSet.updateNClob(" + columnIndex + ",Reader reader," + length + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "updateNClob(int columnIndex, Reader reader, long length)"));
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        JDBCUtil.log("ResultSet.updateNClob(" + columnLabel + ",Reader reader," + length + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "updateNClob(String columnLabel, Reader reader, long length)"));
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
        JDBCUtil.log("ResultSet.updateNString(" + columnIndex + "," + nString + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "updateNString(int columnIndex, String nString)"));
    }

    @Override
    public void updateNString(String columnLabel, String nString) throws SQLException {
        JDBCUtil.log("ResultSet.updateNString(" + columnLabel + "," + nString + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "updateNString(String columnLabel, String nString)"));
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        JDBCUtil.log("ResultSet.updateRowId(" + columnIndex + ",RowId x)");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "updateRowId(int columnIndex, RowId x)"));
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        JDBCUtil.log("ResultSet.updateRowId(" + columnLabel + ",RowId x)");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "updateRowId(String columnLabel, RowId x)"));
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        JDBCUtil.log("ResultSet.updateSQLXML(" + columnIndex + ",SQLXML xmlObject)");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "updateSQLXML(int columnIndex, SQLXML xmlObject)"));
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        JDBCUtil.log("ResultSet.updateSQLXML(" + columnLabel + ",SQLXML xmlObject)");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "updateSQLXML(String columnLabel, SQLXML xmlObject)"));
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        JDBCUtil.log("ResultSet.isWrapperFor(Class<?> iface)");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "isWrapperFor(Class<?> iface)"));
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        JDBCUtil.log("ResultSet.unwrap(Class<T> iface)");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "unwrap(Class<T> iface)"));
        return null;
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        JDBCUtil.log("ResultSet.getObject(" + columnIndex + ",Class<T> type)");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "getObject(int columnIndex, Class<T> type)"));
        return null;
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        JDBCUtil.log("ResultSet.getObject(" + columnLabel + ",Class<T> type)");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "getObject(String columnLabel, Class<T> type)"));
        return null;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        JDBCUtil.log("ResultSet.readExternal(ObjectInput in)");
        in.readByte();
        this.dataArray = JDBCUtil.readArrayList2(in);
        this.rsmd = (ResultSetMetaData)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        JDBCUtil.log("ResultSet.writeExternal(ObjectOutput out)");
        out.writeByte(1);
        JDBCUtil.writeArrayList2(out, this.dataArray);
        out.writeObject(this.rsmd);
    }
}

