/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.app.common;

import com.scudata.common.ArgumentTokenizer;
import com.scudata.common.StringUtils;
import java.awt.FontMetrics;
import java.util.ArrayList;

public class StringUtils2 {
    public static ArrayList<String> wrapExpString(String text, FontMetrics fm, float w, boolean wrapChar, int maxRowCount) {
        ArrayList<String> al = new ArrayList<String>();
        ArgumentTokenizer at = new ArgumentTokenizer(text, '\n', true, true, true, true);
        while (at.hasNext()) {
            String line = at.next();
            if (at.hasNext()) {
                line = String.valueOf(line) + "\n";
            }
            int len = line.length();
            String tmp = "";
            int i = 0;
            while (i < len) {
                char c = line.charAt(i);
                int wid = fm.stringWidth(tmp = String.valueOf(tmp) + String.valueOf(c));
                if ((float)wid > w) {
                    int cut = StringUtils2.cutLine(tmp, c, wrapChar);
                    al.add(tmp.substring(0, cut));
                    if (maxRowCount > 0 && al.size() > maxRowCount) {
                        return al;
                    }
                    tmp = tmp.substring(cut);
                }
                ++i;
            }
            al.add(tmp);
        }
        return al;
    }

    public static ArrayList<String> wrapString(String text, FontMetrics fm, float w, boolean wrapChar, int maxRowCount) {
        ArrayList<String> al = new ArrayList<String>();
        text = StringUtils.replace(text, "\r\n", "\n");
        text = StringUtils.replace(text, "\r", "\n");
        ArgumentTokenizer at = new ArgumentTokenizer(text, '\n', true, true, true, true);
        while (at.hasNext()) {
            String line = at.next();
            if (at.hasNext()) {
                line = String.valueOf(line) + "\n";
            }
            int len = line.length();
            String tmp = "";
            int i = 0;
            while (i < len) {
                char c = line.charAt(i);
                int wid = fm.stringWidth(tmp = String.valueOf(tmp) + String.valueOf(c));
                if ((float)wid > w) {
                    int cut = StringUtils2.cutLine(tmp, c, wrapChar);
                    al.add(tmp.substring(0, cut));
                    if (maxRowCount > 0 && al.size() > maxRowCount) {
                        return al;
                    }
                    tmp = tmp.substring(cut);
                }
                ++i;
            }
            al.add(tmp);
        }
        return al;
    }

    private static String replace(String src, String findString, String replaceString) {
        int i;
        int pos;
        if (src == null) {
            return src;
        }
        int len = src.length();
        if (len == 0) {
            return src;
        }
        if (findString == null) {
            return src;
        }
        int len1 = findString.length();
        if (len1 == 0) {
            return src;
        }
        if (replaceString == null) {
            return src;
        }
        int start = 0;
        StringBuffer sb = null;
        while ((pos = src.indexOf(findString, start)) >= 0) {
            if (sb == null) {
                sb = new StringBuffer(len + 100);
            }
            i = start;
            while (i < pos) {
                sb.append(src.charAt(i));
                ++i;
            }
            sb.append(replaceString);
            start = pos + len1;
        }
        if (sb != null) {
            i = start;
            while (i < len) {
                sb.append(src.charAt(i));
                ++i;
            }
        }
        if (sb != null) {
            return sb.toString();
        }
        return src;
    }

    private static int cutLine(String s, char c, boolean wrapChar) {
        int len = s.length() - 1;
        if (wrapChar) {
            return len;
        }
        if (c == '\u0000') {
            c = s.charAt(len);
        }
        boolean canBeHead = StringUtils2.canBeHead(c);
        boolean isEnglishChar = StringUtils2.isEnglishChar(c);
        if (!canBeHead && isEnglishChar) {
            int seek = len - 1;
            int loc = 0;
            boolean hasHead = StringUtils2.canBeHead(c);
            boolean letterbreak = false;
            while (seek >= 0 && loc == 0) {
                char seekChar = s.charAt(seek);
                if (!StringUtils2.isEnglishChar(seekChar)) {
                    letterbreak = true;
                    if (!hasHead) {
                        if (StringUtils2.canBeHead(seekChar)) {
                            hasHead = true;
                        }
                        --seek;
                        continue;
                    }
                    if (StringUtils2.canBeFoot(seekChar)) {
                        loc = seek + 1;
                        continue;
                    }
                    hasHead = StringUtils2.canBeHead(seekChar);
                    --seek;
                    continue;
                }
                if (letterbreak) {
                    loc = seek + 1;
                    continue;
                }
                hasHead = StringUtils2.canBeHead(seekChar);
                --seek;
            }
            if (loc > 0) {
                return loc;
            }
            return len;
        }
        if (!canBeHead) {
            int seek = len - 1;
            int loc = 0;
            boolean hasHead = false;
            while (seek >= 0 && loc == 0) {
                char seekChar = s.charAt(seek);
                if (!hasHead) {
                    if (StringUtils2.canBeHead(seekChar)) {
                        hasHead = true;
                    }
                    --seek;
                    continue;
                }
                if (StringUtils2.isEnglishChar(seekChar)) {
                    int eseek = seek;
                    boolean eng = true;
                    while (eng && seek > 0) {
                        eng = StringUtils2.isEnglishChar(s.charAt(--seek));
                    }
                    if (seek != 0) continue;
                    loc = eseek + 1;
                    continue;
                }
                if (StringUtils2.canBeFoot(seekChar)) {
                    loc = seek + 1;
                    continue;
                }
                --seek;
            }
            if (loc > 0) {
                return loc;
            }
            return len;
        }
        if (isEnglishChar) {
            int seek = len - 1;
            int loc = 0;
            boolean hasHead = StringUtils2.canBeHead(c);
            boolean letterbreak = false;
            while (seek >= 0 && loc == 0) {
                char seekChar = s.charAt(seek);
                if (!StringUtils2.isEnglishChar(seekChar)) {
                    letterbreak = true;
                    if (!hasHead) {
                        if (StringUtils2.canBeHead(seekChar)) {
                            hasHead = true;
                        }
                        --seek;
                        continue;
                    }
                    if (StringUtils2.canBeFoot(seekChar)) {
                        loc = seek + 1;
                        continue;
                    }
                    hasHead = StringUtils2.canBeHead(seekChar);
                    --seek;
                    continue;
                }
                if (letterbreak) {
                    loc = seek + 1;
                    continue;
                }
                hasHead = StringUtils2.canBeHead(seekChar);
                --seek;
            }
            if (loc > 0) {
                return loc;
            }
            return len;
        }
        return StringUtils2.seekCanBeFoot(s.substring(0, len), len);
    }

    private static int seekCanBeFoot(String s, int len) {
        if (len == -1) {
            len = s.length();
        }
        if (len <= 1) {
            return len;
        }
        int seek = len - 1;
        int loc = 0;
        while (seek >= 0 && loc == 0) {
            char seekChar = s.charAt(seek);
            if (StringUtils2.canBeFoot(seekChar)) {
                loc = seek + 1;
                continue;
            }
            --seek;
        }
        if (loc > 0) {
            return loc;
        }
        return len;
    }

    private static boolean canBeFoot(char c) {
        String cannotFoot = "([{\u00b7\u2018\u201c\u3008\u300a\u300c\u300e\u3010\u3014\u3016\uff08\uff0e\uff3b\uff5b\uffe1\uffe5";
        return cannotFoot.indexOf(c) < 0;
    }

    private static boolean canBeHead(char c) {
        String cannotHead = "%\uff05!),.:;?]}\u00a8\u00b7\u02c7\u02c9\u2015\u2016\u2019\u201d\u2026\u2236\u3001\u3002\u3003\u3005\u3009\u300b\u300d\u300f\u3011\u3015\u3017\uff01\uff02\uff07\uff09\uff0c\uff0e\uff1a\uff1b\uff1f\uff3d\uff40\uff5c\uff5d\uff5e\uffe0";
        return cannotHead.indexOf(c) < 0;
    }

    private static boolean isEnglishChar(char c) {
        return c <= '~' && c > ' ';
    }

    public static int getTextRowHeight(FontMetrics fm) {
        int textH;
        int tmpH = (int)Math.ceil((double)fm.getFont().getSize() * 1.28);
        if (tmpH < (textH = fm.getHeight())) {
            return textH;
        }
        int dh = tmpH - textH;
        if (dh % 2 == 0) {
            return tmpH;
        }
        return tmpH + 1;
    }
}

