/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.app.config;

import com.scudata.app.common.AppUtil;
import com.scudata.app.config.ConfigConsts;
import com.scudata.app.config.ConfigHandler;
import com.scudata.app.config.ConfigWriter;
import com.scudata.app.config.RaqsoftConfig;
import com.scudata.cellset.datamodel.PgmCellSet;
import com.scudata.common.ArgumentTokenizer;
import com.scudata.common.DBConfig;
import com.scudata.common.Escape;
import com.scudata.common.IOUtils;
import com.scudata.common.IPwd;
import com.scudata.common.ISessionFactory;
import com.scudata.common.JNDIConfig;
import com.scudata.common.Logger;
import com.scudata.common.Pwd;
import com.scudata.common.PwdUtils;
import com.scudata.common.RQException;
import com.scudata.common.SpringDBConfig;
import com.scudata.common.StringUtils;
import com.scudata.common.UUID;
import com.scudata.dm.Context;
import com.scudata.dm.Env;
import com.scudata.dm.JobSpace;
import com.scudata.dm.JobSpaceManager;
import com.scudata.dm.cursor.ICursor;
import com.scudata.expression.FunctionLib;
import com.scudata.resources.AppMessage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.servlet.ServletContext;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class ConfigUtil {
    public static final char MISSING_SEP = ',';
    public static final String FUNCTION_CONFIG_FILE = "functions.properties";

    public static RaqsoftConfig load(InputStream in) throws Exception {
        return ConfigUtil.load(in, false);
    }

    public static RaqsoftConfig load(InputStream in, boolean setConfig) throws Exception {
        return ConfigUtil.load(in, setConfig, false);
    }

    public static RaqsoftConfig load(InputStream in, boolean setConfig, boolean loadFromJDBC) throws Exception {
        return ConfigUtil.load(System.getProperty("start.home"), in, setConfig, loadFromJDBC);
    }

    public static RaqsoftConfig load(String home, InputStream in, boolean setConfig, boolean loadFromJDBC) throws Exception {
        if (in == null) {
            throw new RQException(AppMessage.get().getMessage("configutil.isnull"));
        }
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            SAXParser saxParser = spf.newSAXParser();
            XMLReader xmlReader = saxParser.getXMLReader();
            ConfigHandler handler = new ConfigHandler();
            xmlReader.setContentHandler(handler);
            xmlReader.parse(new InputSource(in));
            RaqsoftConfig config = handler.getRaqsoftConfig();
            if (setConfig) {
                ConfigUtil.setConfig(Env.getApplication(), home, config, true, true, loadFromJDBC);
            }
            return config;
        }
        catch (Exception ex) {
            throw new RQException(AppMessage.get().getMessage("configutil.esprocerror", ex.getMessage()), ex);
        }
    }

    public static String formatDate(long date) {
        Date d = new Date(date);
        SimpleDateFormat sdf = new SimpleDateFormat(Env.getDateFormat());
        return sdf.format(d);
    }

    public static RaqsoftConfig load(String filePath) throws Exception {
        return ConfigUtil.load(filePath, false);
    }

    public static RaqsoftConfig load(String filePath, boolean loadFromJDBC) throws Exception {
        return ConfigUtil.load(filePath, loadFromJDBC, true);
    }

    public static RaqsoftConfig load(String filePath, boolean loadFromJDBC, boolean setConfig) throws Exception {
        return ConfigUtil.load(System.getProperty("start.home"), filePath, loadFromJDBC, setConfig);
    }

    public static RaqsoftConfig load(String home, String filePath, boolean loadFromJDBC, boolean setConfig) throws Exception {
        InputStream in = ConfigUtil.getInputStream(home, filePath, null);
        RaqsoftConfig config = ConfigUtil.load(in);
        if (setConfig) {
            ConfigUtil.setConfig(Env.getApplication(), home, config, true, true, false);
        }
        return config;
    }

    public static void loadRuntime(RaqsoftConfig config, ServletContext appCtx, String home) throws Exception {
        ConfigUtil.setConfig(appCtx, home, config, true, true);
    }

    public static void setConfig(ServletContext appCtx, String home, RaqsoftConfig config, boolean setLogLevel, boolean loadExt) throws Exception {
        ConfigUtil.setConfig(appCtx, home, config, setLogLevel, loadExt, false);
    }

    public static void setConfig(ServletContext appCtx, String home, RaqsoftConfig config, boolean setLogLevel, boolean loadExt, boolean loadFromJDBC) throws Exception {
        ConfigUtil.setConfig(appCtx, home, config, setLogLevel, loadExt, loadFromJDBC, true);
    }

    public static Context setConfig(ServletContext appCtx, String home, RaqsoftConfig config, boolean setLogLevel, boolean loadExt, boolean loadFromJDBC, boolean calcInit) throws Exception {
        String jdbcLoad = config.getJdbcLoad();
        boolean loadRuntime = true;
        boolean loadServer = true;
        if (loadFromJDBC) {
            if (StringUtils.isValidString(jdbcLoad)) {
                if ((jdbcLoad = jdbcLoad.toLowerCase()).indexOf("runtime") > -1) {
                    loadRuntime = true;
                }
                if (jdbcLoad.indexOf("server") > -1) {
                    loadServer = true;
                }
            } else {
                loadRuntime = false;
                loadServer = false;
            }
        }
        Context ctx = new Context();
        List<String> autoConnectList = config.getAutoConnectList();
        boolean calcInitSpl = StringUtils.isValidString(config.getInitSpl());
        if (loadRuntime) {
            block82: {
                String customFunctionFile;
                String sCursorParallelNum;
                String sBufSize;
                List<String> splPathList;
                if (setLogLevel) {
                    String sType = config.getLogType();
                    try {
                        if (sType != null) {
                            Logger.setLogType(sType);
                        }
                    }
                    catch (Exception ex) {
                        Logger.error("Invalid " + ConfigConsts.LOG_TYPE + ":" + sType + ".");
                    }
                    String sLevel = config.getLogLevel();
                    try {
                        if (sLevel != null) {
                            Logger.setLevel(sLevel);
                        }
                    }
                    catch (Exception ex) {
                        Logger.error("Invalid " + ConfigConsts.LEVEL + ":" + sLevel + ".");
                    }
                }
                if (StringUtils.isValidString(config.getCharSet())) {
                    Env.setDefaultChartsetName(config.getCharSet());
                }
                if ((splPathList = config.getSplPathList()) == null || splPathList.isEmpty()) {
                    Env.setPaths(null);
                    Logger.debug("Spl path: null");
                } else {
                    String[] paths = new String[splPathList.size()];
                    int i = 0;
                    while (i < paths.length) {
                        if (splPathList.get(i) != null) {
                            paths[i] = IOUtils.getPath(home, splPathList.get(i));
                            Logger.debug("Spl path: " + paths[i]);
                        }
                        ++i;
                    }
                    Env.setPaths(paths);
                }
                if (StringUtils.isValidString(config.getDateFormat())) {
                    Env.setDateFormat(config.getDateFormat());
                }
                if (StringUtils.isValidString(config.getTimeFormat())) {
                    Env.setTimeFormat(config.getTimeFormat());
                }
                if (StringUtils.isValidString(config.getDateTimeFormat())) {
                    Env.setDateTimeFormat(config.getDateTimeFormat());
                }
                String mainPath = IOUtils.getPath(home, config.getMainPath());
                Env.setMainPath(mainPath);
                if (StringUtils.isValidString(mainPath)) {
                    File f = new File(mainPath);
                    if (!f.isDirectory() || !f.exists()) {
                        Logger.info("esProc main path [" + mainPath + "] not exist.");
                    } else {
                        Logger.debug("esProc main path: " + mainPath);
                    }
                } else {
                    Logger.debug("esProc main path: " + mainPath);
                }
                Object tmpPath = config.getTempPath();
                if (StringUtils.isValidString(tmpPath)) {
                    if (StringUtils.isValidString(mainPath)) {
                        tmpPath = IOUtils.getPath(mainPath, (String)tmpPath);
                    } else {
                        File tempDir = new File((String)tmpPath);
                        if (!tempDir.isAbsolute()) {
                            tmpPath = null;
                        }
                    }
                } else {
                    tmpPath = null;
                }
                Env.setTempPath((String)tmpPath);
                if (StringUtils.isValidString(tmpPath)) {
                    try {
                        File f = new File((String)tmpPath);
                        if (!f.exists()) {
                            f.mkdir();
                        }
                    }
                    catch (Exception ex) {
                        Logger.error("Make temp directory failed:" + ex.getMessage());
                    }
                }
                if (StringUtils.isValidString(sBufSize = config.getBufSize())) {
                    int bufSize = ConfigUtil.parseBufferSize(sBufSize);
                    if (bufSize == -1) {
                        Logger.info("The bufSize is empty.");
                    } else if (bufSize == -2) {
                        Logger.error("Invalid " + ConfigConsts.BUF_SIZE + ":" + sBufSize + ".");
                    } else {
                        Env.setFileBufSize(bufSize);
                    }
                }
                ConfigUtil.setEnvBlockSize(config.getBlockSize());
                String sParallelNum = config.getParallelNum();
                if (StringUtils.isValidString(sParallelNum)) {
                    try {
                        int paraNum = Integer.parseInt(sParallelNum);
                        Env.setParallelNum(paraNum);
                    }
                    catch (Exception ex) {
                        Logger.error("Invalid " + ConfigConsts.PARALLEL_NUM + ":" + sParallelNum);
                    }
                }
                if (StringUtils.isValidString(sCursorParallelNum = config.getCursorParallelNum())) {
                    try {
                        int cursorParaNum = Integer.parseInt(sCursorParallelNum);
                        Env.setCursorParallelNum(cursorParaNum);
                    }
                    catch (Exception ex) {
                        Logger.error("Invalid " + ConfigConsts.CURSOR_PARALLEL_NUM + ":" + sParallelNum);
                    }
                }
                String[] nullStrings = ConfigUtil.splitNullStrings(config.getNullStrings());
                Env.setNullStrings(nullStrings);
                String sFetchCount = config.getFetchCount();
                if (StringUtils.isValidString(sFetchCount)) {
                    try {
                        int fetchCount;
                        ICursor.FETCHCOUNT = fetchCount = Integer.parseInt(sFetchCount);
                    }
                    catch (Exception ex) {
                        Logger.error("Invalid " + ConfigConsts.FETCH_COUNT + ":" + sFetchCount);
                    }
                }
                if (StringUtils.isValidString(customFunctionFile = config.getCustomFunctionFile())) {
                    InputStream is = null;
                    try {
                        try {
                            is = ConfigUtil.getInputStream(home, customFunctionFile, appCtx);
                            if (is == null) {
                                Logger.error("File not found: " + customFunctionFile + ".");
                            } else {
                                FunctionLib.loadCustomFunctions(is);
                            }
                        }
                        catch (Exception ex) {
                            Logger.error("Failed to load " + customFunctionFile + ": " + ex.getMessage(), ex);
                            if (is != null) {
                                try {
                                    is.close();
                                }
                                catch (Exception exception) {}
                            }
                            break block82;
                        }
                    }
                    catch (Throwable throwable) {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        throw throwable;
                    }
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
            List<DBConfig> dbList = config.getDBList();
            DBConfig[] dbConfig = null;
            if (dbList != null) {
                int size = dbList.size();
                dbConfig = new DBConfig[size];
                int i = 0;
                while (i < size) {
                    DBConfig db;
                    dbConfig[i] = db = dbList.get(i);
                    String dbName = db.getName();
                    try {
                        ISessionFactory isf = db.createSessionFactory();
                        Env.setDBSessionFactory(dbName, isf);
                        if (calcInitSpl) {
                            ctx.setDBSessionFactory(dbName, isf);
                            if (autoConnectList != null && autoConnectList.contains(dbName)) {
                                ctx.setDBSession(dbName, isf.getSession());
                            }
                        }
                    }
                    catch (Throwable x) {
                        Logger.error("Create database factory [" + dbName + "] failed: " + x.getMessage());
                        x.printStackTrace();
                    }
                    ++i;
                }
            }
            if (loadExt) {
                ConfigUtil.loadExtLibs(home, config);
            }
        }
        if (loadServer) {
            List<SpringDBConfig> springDBList;
            List<JNDIConfig> jndiList = config.getJNDIList();
            if (jndiList != null) {
                for (JNDIConfig jndiConfig : jndiList) {
                    String jndiName = jndiConfig.getName();
                    if (!StringUtils.isValidString(jndiName)) continue;
                    try {
                        ISessionFactory jndisf = jndiConfig.createSessionFactory();
                        Env.setDBSessionFactory(jndiName, jndisf);
                        if (!calcInitSpl || autoConnectList == null || !autoConnectList.contains(jndiName)) continue;
                        ctx.setDBSessionFactory(jndiName, jndisf);
                        ctx.setDBSession(jndiName, jndisf.getSession());
                    }
                    catch (Exception ex) {
                        Logger.error(AppMessage.get().getMessage("configutil.errorjndi", jndiName, ex.getMessage()));
                    }
                }
            }
            if ((springDBList = config.getSpringDBList()) != null) {
                for (SpringDBConfig springDB : springDBList) {
                    String name = springDB.getName();
                    if (!StringUtils.isValidString(name)) continue;
                    try {
                        ISessionFactory sf = springDB.createSessionFactory();
                        Env.setDBSessionFactory(name, sf);
                        if (!calcInitSpl || autoConnectList == null || !autoConnectList.contains(name)) continue;
                        ctx.setDBSessionFactory(name, sf);
                        ctx.setDBSession(name, sf.getSession());
                    }
                    catch (Exception ex) {
                        Logger.error(AppMessage.get().getMessage("configutil.errorspringdb", name, ex.getMessage()));
                    }
                }
            }
        }
        if (calcInit && calcInitSpl) {
            ConfigUtil.calcInitSpl(config.getInitSpl(), ctx);
        }
        return ctx;
    }

    public static String[] splitNullStrings(String nullStrings) {
        if (StringUtils.isValidString(nullStrings)) {
            ArrayList<String> nsList = new ArrayList<String>();
            ArgumentTokenizer at = new ArgumentTokenizer(nullStrings, ',');
            while (at.hasNext()) {
                String exp = at.next();
                if (!StringUtils.isValidString(exp)) continue;
                nsList.add(exp);
                String esExp = Escape.removeEscAndQuote(exp, '\"');
                esExp = Escape.removeEscAndQuote(esExp, '\'');
                if (esExp.equalsIgnoreCase(exp)) continue;
                nsList.add(esExp);
            }
            if (nsList.isEmpty()) {
                return null;
            }
            String[] strs = new String[nsList.size()];
            int i = 0;
            int size = nsList.size();
            while (i < size) {
                strs[i] = (String)nsList.get(i);
                ++i;
            }
            return strs;
        }
        return null;
    }

    public static String getLanguageSuffix() {
        Locale local = Locale.getDefault();
        if (local.equals(Locale.PRC) || local.equals(Locale.CHINA) || local.equals(Locale.CHINESE) || local.equals(Locale.SIMPLIFIED_CHINESE) || local.getLanguage().equalsIgnoreCase("zh")) {
            return "_zh";
        }
        if (local.equals(Locale.TAIWAN) || local.equals(Locale.TRADITIONAL_CHINESE) || local.getLanguage().equalsIgnoreCase("tw")) {
            return "_zh_TW";
        }
        return "_en";
    }

    public static String calcInitSpl(String splPath, Context ctx) throws Exception {
        return ConfigUtil.calcInitSpl(splPath, ctx, true);
    }

    public static String calcInitSpl(String splPath, Context ctx, boolean closeSpace) throws Exception {
        if (!StringUtils.isValidString(splPath)) {
            return null;
        }
        if (ctx == null) {
            ctx = new Context();
        }
        String spaceId = UUID.randomUUID().toString();
        JobSpace jobSpace = JobSpaceManager.getSpace(spaceId);
        ctx.setJobSpace(jobSpace);
        try {
            PgmCellSet cellSet;
            try {
                cellSet = AppUtil.readCellSet(splPath);
            }
            catch (Exception e) {
                throw new RQException("Failed to read init spl: " + splPath, e);
            }
            cellSet.setContext(ctx);
            cellSet.run();
            String string = spaceId;
            return string;
        }
        finally {
            if (closeSpace) {
                JobSpaceManager.closeSpace(spaceId);
            }
        }
    }

    public static InputStream getInputStream(String home, String path) {
        return ConfigUtil.getInputStream(home, path, null);
    }

    public static InputStream getInputStream(String home, String path, ServletContext app) {
        ClassLoader cl;
        if (!StringUtils.isValidString(path)) {
            throw new RQException(AppMessage.get().getMessage("configutil.pathnull"));
        }
        InputStream in = null;
        try {
            if (IOUtils.isAbsolutePath(path)) {
                in = new FileInputStream(path);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (in == null) {
            String realPath = IOUtils.getPath(home, path);
            try {
                File f;
                if (StringUtils.isValidString(realPath) && (f = new File(realPath)).exists()) {
                    in = new FileInputStream(realPath);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (in == null && (cl = Thread.currentThread().getContextClassLoader()) != null) {
            try {
                in = cl.getResourceAsStream(path);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (in == null) {
            try {
                in = ConfigUtil.class.getResourceAsStream(path);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (in == null) {
            try {
                if (app != null) {
                    in = app.getResourceAsStream(path);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (in == null) {
            throw new RQException("Failed to get file: " + path);
        }
        return in;
    }

    public static void write(String filePath, RaqsoftConfig config) throws Exception {
        FileOutputStream fos = null;
        FilterOutputStream bos = null;
        try {
            fos = new FileOutputStream(filePath);
            bos = new BufferedOutputStream(fos);
            ConfigWriter cw = new ConfigWriter();
            cw.write(bos, config);
            ((BufferedOutputStream)bos).flush();
        }
        finally {
            if (fos != null) {
                fos.close();
            }
            if (bos != null) {
                bos.close();
            }
        }
    }

    public static void loadExtLibs(String home, RaqsoftConfig config) throws RQException {
        if (config == null) {
            return;
        }
        String extLibsPath = config.getExtLibsPath();
        List<String> extLibs = config.getImportLibs();
        if (!StringUtils.isValidString(extLibsPath)) {
            return;
        }
        if (extLibs == null || extLibs.isEmpty()) {
            return;
        }
        File extLibsDir = new File(extLibsPath = IOUtils.getPath(home, extLibsPath));
        if (!extLibsDir.exists() || !extLibsDir.isDirectory()) {
            throw new RQException(AppMessage.get().getMessage("configutil.noextpath", extLibsPath));
        }
        File[] subDirs = extLibsDir.listFiles();
        if (subDirs != null) {
            File[] fileArray = subDirs;
            int n = subDirs.length;
            int n2 = 0;
            while (n2 < n) {
                File sd = fileArray[n2];
                if (sd.isDirectory() && extLibs.contains(sd.getName())) {
                    FunctionLib.loadExtLibrary(sd);
                }
                ++n2;
            }
        }
    }

    public static String getJarPath(URL url, String clsPath) {
        int index;
        int pos;
        String realPath = url.getPath();
        try {
            realPath = URLDecoder.decode(realPath, "utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        realPath = realPath.trim();
        if (realPath.startsWith("jar:")) {
            realPath = realPath.substring(4);
        }
        if ((pos = realPath.indexOf("file:")) > -1) {
            realPath = realPath.substring(pos + 5);
        }
        if ((index = realPath.lastIndexOf(".jar!")) > -1) {
            realPath = realPath.substring(0, index + 4);
        }
        return realPath;
    }

    public static int parseBufferSize(String sNum) {
        if (sNum == null) {
            return -1;
        }
        if ((sNum = sNum.trim()).length() == 0) {
            return -1;
        }
        char lastChar = (sNum = sNum.toLowerCase()).charAt(sNum.length() - 1);
        if (lastChar == 'b') {
            sNum = sNum.substring(0, sNum.length() - 1);
            lastChar = sNum.charAt(sNum.length() - 1);
        }
        int buffer = -2;
        try {
            if (lastChar == 'k' || lastChar == 'm' || lastChar == 'g' || lastChar == 't') {
                String num = sNum.substring(0, sNum.length() - 1);
                float f = Float.parseFloat(num);
                if (lastChar != 'k') {
                    if (lastChar == 'm') {
                        f *= 1024.0f;
                    } else if (lastChar == 'g') {
                        f = f * 1024.0f * 1024.0f;
                    } else if (lastChar == 't') {
                        f = f * 1024.0f * 1024.0f * 1024.0f;
                    }
                }
                buffer = new Float(f * 1024.0f).intValue();
            } else {
                buffer = Integer.parseInt(sNum);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return buffer;
    }

    public static void setEnvBlockSize(String sBlockSize) {
        int blockSize = ConfigUtil.parseBufferSize(sBlockSize);
        if (blockSize == -1) {
            Logger.info("The block size is empty.");
        } else if (blockSize == -2) {
            Logger.info("Invalid " + ConfigConsts.BUF_SIZE + ":" + sBlockSize + ".");
        } else {
            if (blockSize < 4096) {
                Logger.info("The minimum block size is 4096b.");
                blockSize = 4096;
            } else if (blockSize % 4096 != 0) {
                Logger.info("The block size should be multiple of 4096b.");
                int size = blockSize / 4096;
                if (size < 1) {
                    size = 1;
                }
                blockSize = (size + 1) * 4096;
                Logger.info("The block size is set to " + blockSize + "b.");
            }
            Env.setBlockSize(blockSize);
        }
    }

    public static String getUnitBlockSize(int blockSize, String sBlockSize) {
        char unit = (sBlockSize = sBlockSize.trim().toLowerCase()).charAt(sBlockSize.length() - 1);
        if (unit == 'k') {
            return String.valueOf(blockSize / 1024) + "k";
        }
        if (unit == 'm') {
            return String.valueOf(blockSize / 0x100000) + "m";
        }
        if (unit == 'g') {
            return String.valueOf(blockSize / 0x40000000) + "g";
        }
        if (unit == 't') {
            return String.valueOf(blockSize / 0) + "t";
        }
        return String.valueOf(blockSize);
    }

    public static String getPath(String home, String path) {
        if (!StringUtils.isValidString(home) || !StringUtils.isValidString(path)) {
            return path;
        }
        File f = new File(path);
        if (!f.exists() && (f = new File(home, path)).exists()) {
            return f.getPath().replace('\\', '/');
        }
        return IOUtils.getPath(home, path);
    }

    public static void setPwdClass(String pwdClass) throws Exception {
        if (StringUtils.isValidString(pwdClass)) {
            IPwd pwdClz = (IPwd)Class.forName(pwdClass).newInstance();
            PwdUtils.set(pwdClz);
        } else {
            PwdUtils.set(new Pwd());
        }
    }
}

