/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.array;

import com.scudata.array.BoolArray;
import com.scudata.array.DateArray;
import com.scudata.array.DoubleArray;
import com.scudata.array.IArray;
import com.scudata.array.IntArray;
import com.scudata.array.LongArray;
import com.scudata.array.ObjectArray;
import com.scudata.array.StringArray;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Sequence;
import com.scudata.resources.EngineMessage;
import com.scudata.util.CursorUtil;
import com.scudata.util.Variant;
import java.util.Date;

public final class ArrayUtil {
    public static IArray newArray(Object value, int capacity) {
        if (value instanceof Integer) {
            IntArray result = new IntArray(capacity);
            result.pushInt((Integer)value);
            return result;
        }
        if (value instanceof Long) {
            LongArray result = new LongArray(capacity);
            result.pushLong((Long)value);
            return result;
        }
        if (value instanceof Double) {
            DoubleArray result = new DoubleArray(capacity);
            result.pushDouble((Double)value);
            return result;
        }
        if (value instanceof Date) {
            DateArray result = new DateArray(capacity);
            result.pushDate((Date)value);
            return result;
        }
        if (value instanceof String) {
            StringArray result = new StringArray(capacity);
            result.pushString((String)value);
            return result;
        }
        if (value instanceof Boolean) {
            BoolArray result = new BoolArray(capacity);
            result.pushBool((Boolean)value);
            return result;
        }
        ObjectArray result = new ObjectArray(capacity);
        result.push(value);
        return result;
    }

    public static BoolArray booleanValue(IArray array, boolean value) {
        if (value) {
            BoolArray result = array.isTrue();
            if (result == array) {
                return (BoolArray)result.dup();
            }
            return result;
        }
        return array.isFalse();
    }

    public static BoolArray calcRelationNull(boolean[] signs, int size, int relation) {
        int i;
        boolean[] resultDatas = new boolean[size + 1];
        if (relation == 1) {
            if (signs != null) {
                System.arraycopy(signs, 1, resultDatas, 1, size);
            }
        } else if (relation == 2) {
            if (signs == null) {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = true;
                    ++i;
                }
            } else {
                i = 1;
                while (i <= size) {
                    if (!signs[i]) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
            }
        } else if (relation == 3) {
            i = 1;
            while (i <= size) {
                resultDatas[i] = true;
                ++i;
            }
        } else if (relation != 4) {
            if (relation == 5) {
                if (signs != null) {
                    System.arraycopy(signs, 1, resultDatas, 1, size);
                }
            } else if (relation == 6) {
                if (signs == null) {
                    i = 1;
                    while (i <= size) {
                        resultDatas[i] = true;
                        ++i;
                    }
                } else {
                    i = 1;
                    while (i <= size) {
                        if (!signs[i]) {
                            resultDatas[i] = true;
                        }
                        ++i;
                    }
                }
            } else if (relation == 8) {
                if (signs == null) {
                    i = 1;
                    while (i <= size) {
                        resultDatas[i] = true;
                        ++i;
                    }
                } else {
                    i = 1;
                    while (i <= size) {
                        resultDatas[i] = !signs[i];
                        ++i;
                    }
                }
            }
        }
        BoolArray result = new BoolArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    public static BoolArray calcRelationNull(Object[] datas, int size, int relation) {
        int i;
        boolean[] resultDatas = new boolean[size + 1];
        if (relation == 1) {
            i = 1;
            while (i <= size) {
                if (datas[i] == null) {
                    resultDatas[i] = true;
                }
                ++i;
            }
        } else if (relation == 2) {
            i = 1;
            while (i <= size) {
                if (datas[i] != null) {
                    resultDatas[i] = true;
                }
                ++i;
            }
        } else if (relation == 3) {
            i = 1;
            while (i <= size) {
                resultDatas[i] = true;
                ++i;
            }
        } else if (relation != 4) {
            if (relation == 5) {
                i = 1;
                while (i <= size) {
                    if (datas[i] == null) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
            } else if (relation == 6) {
                i = 1;
                while (i <= size) {
                    if (datas[i] != null) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
            } else if (relation == 8) {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = datas[i] != null;
                    ++i;
                }
            }
        }
        BoolArray result = new BoolArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    public static BoolArray calcRelationNull(Object[] datas, int start, int end, int size, int relation) {
        int i;
        boolean[] resultDatas = new boolean[size + 1];
        if (relation == 1) {
            i = start;
            while (i <= end) {
                if (datas[i] == null) {
                    resultDatas[i] = true;
                }
                ++i;
            }
        } else if (relation == 2) {
            i = start;
            while (i <= end) {
                if (datas[i] != null) {
                    resultDatas[i] = true;
                }
                ++i;
            }
        } else if (relation == 3) {
            i = start;
            while (i <= end) {
                resultDatas[i] = true;
                ++i;
            }
        } else if (relation != 4) {
            if (relation == 5) {
                i = start;
                while (i <= end) {
                    if (datas[i] == null) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
            } else if (relation == 6) {
                i = start;
                while (i <= end) {
                    if (datas[i] != null) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
            } else if (relation == 8) {
                i = start;
                while (i <= end) {
                    resultDatas[i] = datas[i] != null;
                    ++i;
                }
            }
        }
        BoolArray result = new BoolArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void calcRelationsNull(boolean[] signs, int size, int relation, BoolArray result, boolean isAnd) {
        boolean[] resultDatas = result.getDatas();
        if (isAnd) {
            if (relation == 1) {
                if (signs == null) {
                    int i = 1;
                    while (i <= size) {
                        resultDatas[i] = false;
                        ++i;
                    }
                    return;
                } else {
                    int i = 1;
                    while (i <= size) {
                        if (!signs[i]) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                }
                return;
            } else if (relation == 2) {
                if (signs == null) return;
                int i = 1;
                while (i <= size) {
                    if (signs[i]) {
                        resultDatas[i] = false;
                    }
                    ++i;
                }
                return;
            } else {
                if (relation == 3) return;
                if (relation == 4) {
                    int i = 1;
                    while (i <= size) {
                        resultDatas[i] = false;
                        ++i;
                    }
                    return;
                } else if (relation == 5) {
                    if (signs == null) return;
                    int i = 1;
                    while (i <= size) {
                        if (!signs[i]) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                    return;
                } else {
                    if (relation != 6) throw new RuntimeException();
                    if (signs == null) return;
                    int i = 1;
                    while (i <= size) {
                        if (signs[i]) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                }
            }
            return;
        } else if (relation == 1) {
            if (signs == null) return;
            int i = 1;
            while (i <= size) {
                if (signs[i]) {
                    resultDatas[i] = true;
                }
                ++i;
            }
            return;
        } else if (relation == 2) {
            if (signs == null) {
                int i = 1;
                while (i <= size) {
                    resultDatas[i] = true;
                    ++i;
                }
                return;
            } else {
                int i = 1;
                while (i <= size) {
                    if (!signs[i]) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
            }
            return;
        } else if (relation == 3) {
            int i = 1;
            while (i <= size) {
                resultDatas[i] = true;
                ++i;
            }
            return;
        } else {
            if (relation == 4) return;
            if (relation == 5) {
                if (signs == null) return;
                int i = 1;
                while (i <= size) {
                    if (signs[i]) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
                return;
            } else {
                if (relation != 6) throw new RuntimeException();
                if (signs == null) {
                    int i = 1;
                    while (i <= size) {
                        resultDatas[i] = true;
                        ++i;
                    }
                    return;
                } else {
                    int i = 1;
                    while (i <= size) {
                        if (!signs[i]) {
                            resultDatas[i] = true;
                        }
                        ++i;
                    }
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void calcRelationsNull(Object[] datas, int size, int relation, BoolArray result, boolean isAnd) {
        boolean[] resultDatas = result.getDatas();
        if (isAnd) {
            if (relation == 1) {
                int i = 1;
                while (i <= size) {
                    if (datas[i] != null) {
                        resultDatas[i] = false;
                    }
                    ++i;
                }
                return;
            } else if (relation == 2) {
                int i = 1;
                while (i <= size) {
                    if (datas[i] == null) {
                        resultDatas[i] = false;
                    }
                    ++i;
                }
                return;
            } else {
                if (relation == 3) return;
                if (relation == 4) {
                    int i = 1;
                    while (i <= size) {
                        resultDatas[i] = false;
                        ++i;
                    }
                    return;
                } else if (relation == 5) {
                    int i = 1;
                    while (i <= size) {
                        if (datas[i] != null) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                    return;
                } else {
                    if (relation != 6) throw new RuntimeException();
                    int i = 1;
                    while (i <= size) {
                        if (datas[i] == null) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                }
            }
            return;
        } else if (relation == 1) {
            int i = 1;
            while (i <= size) {
                if (datas[i] == null) {
                    resultDatas[i] = true;
                }
                ++i;
            }
            return;
        } else if (relation == 2) {
            int i = 1;
            while (i <= size) {
                if (datas[i] != null) {
                    resultDatas[i] = true;
                }
                ++i;
            }
            return;
        } else if (relation == 3) {
            int i = 1;
            while (i <= size) {
                resultDatas[i] = true;
                ++i;
            }
            return;
        } else {
            if (relation == 4) return;
            if (relation == 5) {
                int i = 1;
                while (i <= size) {
                    if (datas[i] == null) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
                return;
            } else {
                if (relation != 6) throw new RuntimeException();
                int i = 1;
                while (i <= size) {
                    if (datas[i] != null) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
            }
        }
    }

    public static Object mod(Object o1, Object o2) {
        if (o1 instanceof Number) {
            if (o2 instanceof Number) {
                return Variant.mod((Number)o1, (Number)o2);
            }
            if (o2 instanceof Sequence) {
                Sequence seq1 = new Sequence(1);
                seq1.add(o1);
                return CursorUtil.xor(seq1, (Sequence)o2);
            }
            if (o2 == null) {
                return null;
            }
        } else {
            if (o1 instanceof Sequence) {
                if (o2 instanceof Sequence) {
                    return CursorUtil.xor((Sequence)o1, (Sequence)o2);
                }
                if (o2 == null) {
                    return o1;
                }
                Sequence seq2 = new Sequence(1);
                seq2.add(o2);
                return CursorUtil.xor((Sequence)o1, seq2);
            }
            if (o2 instanceof Sequence) {
                if (o1 == null) {
                    return o2;
                }
                Sequence seq1 = new Sequence(1);
                seq1.add(o1);
                return CursorUtil.xor(seq1, (Sequence)o2);
            }
            if (o1 == null) {
                if (o2 instanceof Sequence) {
                    return o2;
                }
                if (o2 instanceof Number) {
                    return null;
                }
                if (o2 == null) {
                    return null;
                }
            }
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(String.valueOf(Variant.getDataType(o1)) + mm.getMessage("Variant2.with") + Variant.getDataType(o2) + mm.getMessage("Variant2.illMod"));
    }

    public static Object intDivide(Object o1, Object o2) {
        if (o1 instanceof Number) {
            if (o2 instanceof Number) {
                return Variant.intDivide((Number)o1, (Number)o2);
            }
            if (o2 == null) {
                return null;
            }
        } else {
            if (o1 instanceof Sequence) {
                if (o2 instanceof Sequence) {
                    return ((Sequence)o1).diff((Sequence)o2, false);
                }
                if (o2 == null) {
                    return o1;
                }
                Sequence seq2 = new Sequence(1);
                seq2.add(o2);
                return ((Sequence)o1).diff(seq2, false);
            }
            if (o1 == null) {
                if (o2 instanceof Number) {
                    return null;
                }
                if (o2 == null) {
                    return null;
                }
            }
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(String.valueOf(Variant.getDataType(o1)) + mm.getMessage("Variant2.with") + Variant.getDataType(o2) + mm.getMessage("Variant2.illDivide"));
    }

    public static Object pos(IArray src, IArray array, String opt) {
        int subLen;
        int len = src.size();
        if (len < (subLen = array.size())) {
            return null;
        }
        boolean isSorted = false;
        boolean isIncre = false;
        boolean isContinuous = false;
        if (opt != null) {
            if (opt.indexOf(98) != -1) {
                isSorted = true;
            }
            if (opt.indexOf(105) != -1) {
                isIncre = true;
            }
            if (opt.indexOf(99) != -1) {
                isContinuous = true;
            }
        }
        if (isIncre) {
            Sequence result = new Sequence(subLen);
            IArray resultMems = result.getMems();
            if (isSorted) {
                int pos = 1;
                int t = 1;
                while (t <= subLen) {
                    pos = src.binarySearch(array.get(t), pos, len);
                    if (pos > 0) {
                        resultMems.add(pos);
                        ++pos;
                    } else {
                        return null;
                    }
                    ++t;
                }
            } else {
                int pos = 1;
                int t = 1;
                while (t <= subLen) {
                    pos = src.firstIndexOf(array.get(t), pos);
                    if (pos > 0) {
                        resultMems.add(pos);
                        ++pos;
                    } else {
                        return null;
                    }
                    ++t;
                }
            }
            return result;
        }
        if (isContinuous) {
            int maxCandidate = len - subLen + 1;
            if (isSorted) {
                Object o1 = array.get(1);
                int candidate = 1;
                block2: while (candidate <= maxCandidate) {
                    int result = Variant.compare(o1, src.get(candidate), true);
                    if (result > 0) {
                        ++candidate;
                        continue;
                    }
                    if (result == 0) {
                        int i = 2;
                        int j = candidate + 1;
                        while (i <= subLen) {
                            if (!Variant.isEquals(array.get(i), src.get(j))) {
                                ++candidate;
                                continue block2;
                            }
                            ++i;
                            ++j;
                        }
                        return candidate;
                    }
                    return null;
                }
            } else {
                int candidate = 1;
                while (candidate <= maxCandidate) {
                    block31: {
                        int i = 1;
                        int j = candidate;
                        while (i <= subLen) {
                            if (Variant.isEquals(array.get(i), src.get(j))) {
                                ++i;
                                ++j;
                                continue;
                            }
                            break block31;
                        }
                        return candidate;
                    }
                    ++candidate;
                }
            }
            return null;
        }
        Sequence result = new Sequence(subLen);
        IArray resultMems = result.getMems();
        if (isSorted) {
            int t = 1;
            while (t <= subLen) {
                int pos = src.binarySearch(array.get(t));
                if (pos <= 0) {
                    return null;
                }
                resultMems.add(pos);
                ++t;
            }
        } else {
            int t = 1;
            while (t <= subLen) {
                int pos = src.firstIndexOf(array.get(t), 1);
                if (pos <= 0) {
                    return null;
                }
                resultMems.add(pos);
                ++t;
            }
        }
        return result;
    }
}

