/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.array;

import com.scudata.array.ArrayUtil;
import com.scudata.array.ConstArray;
import com.scudata.array.DateArray;
import com.scudata.array.DoubleArray;
import com.scudata.array.IArray;
import com.scudata.array.IntArray;
import com.scudata.array.LongArray;
import com.scudata.array.ObjectArray;
import com.scudata.array.StringArray;
import com.scudata.common.ByteArrayInputRecord;
import com.scudata.common.ByteArrayOutputRecord;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Sequence;
import com.scudata.expression.Relation;
import com.scudata.resources.EngineMessage;
import com.scudata.thread.MultithreadUtil;
import com.scudata.util.Variant;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Comparator;
import java.util.Date;

public class BoolArray
implements IArray {
    private static final long serialVersionUID = 1L;
    private static final byte NULL_SIGN = 60;
    private boolean[] datas;
    private boolean[] signs;
    private int size;

    public BoolArray() {
        this.datas = new boolean[8];
    }

    public BoolArray(int initialCapacity) {
        this.datas = new boolean[++initialCapacity];
    }

    public BoolArray(boolean value, int size) {
        this.datas = new boolean[size + 1];
        boolean[] datas = this.datas;
        this.size = size;
        if (value) {
            int i = 1;
            while (i <= size) {
                datas[i] = true;
                ++i;
            }
        }
    }

    public BoolArray(boolean[] datas, int size) {
        this.datas = datas;
        this.size = size;
    }

    public BoolArray(boolean[] datas, boolean[] signs, int size) {
        this.datas = datas;
        this.signs = signs;
        this.size = size;
    }

    public boolean[] getDatas() {
        return this.datas;
    }

    public boolean[] getSigns() {
        return this.signs;
    }

    public void setSigns(boolean[] signs) {
        this.signs = signs;
    }

    @Override
    public String getDataType() {
        MessageManager mm = EngineMessage.get();
        return mm.getMessage("DataType.Boolean");
    }

    @Override
    public IArray dup() {
        int len = this.size + 1;
        boolean[] newDatas = new boolean[len];
        System.arraycopy(this.datas, 0, newDatas, 0, len);
        boolean[] newSigns = null;
        if (this.signs != null) {
            newSigns = new boolean[len];
            System.arraycopy(this.signs, 0, newSigns, 0, len);
        }
        return new BoolArray(newDatas, newSigns, this.size);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        int size = this.size;
        boolean[] datas = this.datas;
        boolean[] signs = this.signs;
        if (signs == null) {
            out.writeByte(1);
        } else {
            out.writeByte(61);
        }
        out.writeInt(size);
        int i = 1;
        while (i <= size) {
            out.writeBoolean(datas[i]);
            ++i;
        }
        if (signs != null) {
            i = 1;
            while (i <= size) {
                out.writeBoolean(signs[i]);
                ++i;
            }
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        byte sign = in.readByte();
        this.size = in.readInt();
        int len = this.size + 1;
        this.datas = new boolean[len];
        boolean[] datas = this.datas;
        int i = 1;
        while (i < len) {
            datas[i] = in.readBoolean();
            ++i;
        }
        if (sign > 60) {
            this.signs = new boolean[len];
            boolean[] signs = this.signs;
            int i2 = 1;
            while (i2 < len) {
                signs[i2] = in.readBoolean();
                ++i2;
            }
        }
    }

    @Override
    public byte[] serialize() throws IOException {
        ByteArrayOutputRecord out = new ByteArrayOutputRecord();
        int size = this.size;
        boolean[] datas = this.datas;
        boolean[] signs = this.signs;
        if (signs == null) {
            out.writeByte(1);
        } else {
            out.writeByte(61);
        }
        out.writeInt(size);
        int i = 1;
        while (i <= size) {
            out.writeBoolean(datas[i]);
            ++i;
        }
        if (signs != null) {
            i = 1;
            while (i <= size) {
                out.writeBoolean(signs[i]);
                ++i;
            }
        }
        return out.toByteArray();
    }

    @Override
    public void fillRecord(byte[] buf) throws IOException, ClassNotFoundException {
        ByteArrayInputRecord in = new ByteArrayInputRecord(buf);
        byte sign = in.readByte();
        this.size = in.readInt();
        int len = this.size + 1;
        this.datas = new boolean[len];
        boolean[] datas = this.datas;
        int i = 1;
        while (i < len) {
            datas[i] = in.readBoolean();
            ++i;
        }
        if (sign > 60) {
            this.signs = new boolean[len];
            boolean[] signs = this.signs;
            int i2 = 1;
            while (i2 < len) {
                signs[i2] = in.readBoolean();
                ++i2;
            }
        }
    }

    @Override
    public IArray newInstance(int count) {
        return new BoolArray(count);
    }

    @Override
    public void add(Object o) {
        if (o instanceof Boolean) {
            this.ensureCapacity(this.size + 1);
            this.datas[++this.size] = (Boolean)o;
        } else if (o == null) {
            this.ensureCapacity(this.size + 1);
            if (this.signs == null) {
                this.signs = new boolean[this.datas.length];
            }
            this.signs[++this.size] = true;
        } else {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("pdm.arrayTypeError", mm.getMessage("DataType.Boolean"), Variant.getDataType(o)));
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void addAll(IArray array) {
        block15: {
            block16: {
                size2 = array.size();
                if (size2 == 0) break block15;
                if (!(array instanceof BoolArray)) break block16;
                boolArray = (BoolArray)array;
                this.ensureCapacity(this.size + size2);
                System.arraycopy(boolArray.datas, 1, this.datas, this.size + 1, size2);
                if (boolArray.signs != null) {
                    if (this.signs == null) {
                        this.signs = new boolean[this.datas.length];
                    }
                    System.arraycopy(boolArray.signs, 1, this.signs, this.size + 1, size2);
                }
                this.size += size2;
                break block15;
            }
            if (!(array instanceof ConstArray)) ** GOTO lbl39
            obj = array.get(1);
            if (obj instanceof Boolean) {
                this.ensureCapacity(this.size + size2);
                v = (Boolean)obj;
                datas = this.datas;
                i = 0;
                while (i < size2) {
                    datas[++this.size] = v;
                    ++i;
                }
            } else if (obj == null) {
                this.ensureCapacity(this.size + size2);
                signs = this.signs;
                if (signs == null) {
                    this.signs = signs = new boolean[this.datas.length];
                }
                i = 0;
                while (i < size2) {
                    signs[++this.size] = true;
                    ++i;
                }
            } else {
                mm = EngineMessage.get();
                throw new RQException(mm.getMessage("pdm.arrayTypeError", mm.getMessage("DataType.Boolean"), array.getDataType()));
lbl39:
                // 1 sources

                this.ensureCapacity(this.size + size2);
                datas = this.datas;
                i = 1;
                while (i <= size2) {
                    obj = array.get(i);
                    if (obj instanceof Boolean) {
                        datas[++this.size] = (Boolean)obj;
                    } else if (obj == null) {
                        if (this.signs == null) {
                            this.signs = new boolean[datas.length];
                        }
                        this.signs[++this.size] = true;
                    } else {
                        mm = EngineMessage.get();
                        throw new RQException(mm.getMessage("pdm.arrayTypeError", mm.getMessage("DataType.Boolean"), Variant.getDataType(obj)));
                    }
                    ++i;
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void addAll(IArray array, int count) {
        block15: {
            block16: {
                if (count == 0) break block15;
                if (!(array instanceof BoolArray)) break block16;
                boolArray = (BoolArray)array;
                this.ensureCapacity(this.size + count);
                System.arraycopy(boolArray.datas, 1, this.datas, this.size + 1, count);
                if (boolArray.signs != null) {
                    if (this.signs == null) {
                        this.signs = new boolean[this.datas.length];
                    }
                    System.arraycopy(boolArray.signs, 1, this.signs, this.size + 1, count);
                }
                this.size += count;
                break block15;
            }
            if (!(array instanceof ConstArray)) ** GOTO lbl38
            obj = array.get(1);
            if (obj instanceof Boolean) {
                this.ensureCapacity(this.size + count);
                v = (Boolean)obj;
                datas = this.datas;
                i = 0;
                while (i < count) {
                    datas[++this.size] = v;
                    ++i;
                }
            } else if (obj == null) {
                this.ensureCapacity(this.size + count);
                signs = this.signs;
                if (signs == null) {
                    this.signs = signs = new boolean[this.datas.length];
                }
                i = 0;
                while (i < count) {
                    signs[++this.size] = true;
                    ++i;
                }
            } else {
                mm = EngineMessage.get();
                throw new RQException(mm.getMessage("pdm.arrayTypeError", mm.getMessage("DataType.Boolean"), array.getDataType()));
lbl38:
                // 1 sources

                this.ensureCapacity(this.size + count);
                datas = this.datas;
                i = 1;
                while (i <= count) {
                    obj = array.get(i);
                    if (obj instanceof Boolean) {
                        datas[++this.size] = (Boolean)obj;
                    } else if (obj == null) {
                        if (this.signs == null) {
                            this.signs = new boolean[datas.length];
                        }
                        this.signs[++this.size] = true;
                    } else {
                        mm = EngineMessage.get();
                        throw new RQException(mm.getMessage("pdm.arrayTypeError", mm.getMessage("DataType.Boolean"), Variant.getDataType(obj)));
                    }
                    ++i;
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void addAll(IArray array, int index, int count) {
        block10: {
            block9: {
                if (!(array instanceof BoolArray)) break block9;
                boolArray = (BoolArray)array;
                this.ensureCapacity(this.size + count);
                System.arraycopy(boolArray.datas, index, this.datas, this.size + 1, count);
                if (boolArray.signs != null) {
                    if (this.signs == null) {
                        this.signs = new boolean[this.datas.length];
                    }
                    System.arraycopy(boolArray.signs, index, this.signs, this.size + 1, count);
                }
                this.size += count;
                break block10;
            }
            if (!(array instanceof ConstArray)) ** GOTO lbl37
            obj = array.get(1);
            if (obj instanceof Boolean) {
                this.ensureCapacity(this.size + count);
                v = (Boolean)obj;
                datas = this.datas;
                i = 0;
                while (i < count) {
                    datas[++this.size] = v;
                    ++i;
                }
            } else if (obj == null) {
                this.ensureCapacity(this.size + count);
                signs = this.signs;
                if (signs == null) {
                    this.signs = signs = new boolean[this.datas.length];
                }
                i = 0;
                while (i < count) {
                    signs[++this.size] = true;
                    ++i;
                }
            } else {
                mm = EngineMessage.get();
                throw new RQException(mm.getMessage("pdm.arrayTypeError", mm.getMessage("DataType.Boolean"), array.getDataType()));
lbl37:
                // 1 sources

                mm = EngineMessage.get();
                throw new RQException(mm.getMessage("pdm.arrayTypeError", mm.getMessage("DataType.Boolean"), array.getDataType()));
            }
        }
    }

    @Override
    public void addAll(Object[] array) {
        Object[] objectArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            if (obj != null && !(obj instanceof Boolean)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(mm.getMessage("pdm.arrayTypeError", mm.getMessage("DataType.Boolean"), Variant.getDataType(obj)));
            }
            ++n2;
        }
        int size2 = array.length;
        this.ensureCapacity(this.size + size2);
        boolean[] datas = this.datas;
        boolean[] signs = this.signs;
        int i = 0;
        while (i < size2) {
            if (array[i] != null) {
                datas[++this.size] = (Boolean)array[i];
            } else {
                if (signs == null) {
                    this.signs = signs = new boolean[datas.length];
                }
                signs[++this.size] = true;
            }
            ++i;
        }
    }

    @Override
    public void insert(int index, Object o) {
        if (o instanceof Boolean) {
            this.ensureCapacity(this.size + 1);
            ++this.size;
            System.arraycopy(this.datas, index, this.datas, index + 1, this.size - index);
            if (this.signs != null) {
                System.arraycopy(this.signs, index, this.signs, index + 1, this.size - index);
            }
            this.datas[index] = (Boolean)o;
        } else if (o == null) {
            this.ensureCapacity(this.size + 1);
            ++this.size;
            System.arraycopy(this.datas, index, this.datas, index + 1, this.size - index);
            if (this.signs == null) {
                this.signs = new boolean[this.datas.length];
            } else {
                System.arraycopy(this.signs, index, this.signs, index + 1, this.size - index);
            }
            this.signs[index] = true;
        } else {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("pdm.arrayTypeError", mm.getMessage("DataType.Boolean"), Variant.getDataType(o)));
        }
    }

    @Override
    public void insertAll(int pos, IArray array) {
        if (array instanceof BoolArray) {
            int numNew = array.size();
            BoolArray boolArray = (BoolArray)array;
            this.ensureCapacity(this.size + numNew);
            System.arraycopy(this.datas, pos, this.datas, pos + numNew, this.size - pos + 1);
            if (this.signs != null) {
                System.arraycopy(this.signs, pos, this.signs, pos + numNew, this.size - pos + 1);
            }
            System.arraycopy(boolArray.datas, 1, this.datas, pos, numNew);
            if (boolArray.signs == null) {
                if (this.signs != null) {
                    boolean[] signs = this.signs;
                    int i = 0;
                    while (i < numNew) {
                        signs[pos + i] = false;
                        ++i;
                    }
                }
            } else {
                if (this.signs == null) {
                    this.signs = new boolean[this.datas.length];
                }
                System.arraycopy(boolArray.signs, 1, this.signs, pos, numNew);
            }
            this.size += numNew;
        } else {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("pdm.arrayTypeError", mm.getMessage("DataType.Boolean"), array.getDataType()));
        }
    }

    @Override
    public void insertAll(int pos, Object[] array) {
        boolean containNull = false;
        Object[] objectArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            if (obj == null) {
                containNull = true;
            } else if (!(obj instanceof Boolean)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(mm.getMessage("pdm.arrayTypeError", mm.getMessage("DataType.Boolean"), Variant.getDataType(obj)));
            }
            ++n2;
        }
        int numNew = array.length;
        this.ensureCapacity(this.size + numNew);
        boolean[] datas = this.datas;
        boolean[] signs = this.signs;
        System.arraycopy(datas, pos, datas, pos + numNew, this.size - pos + 1);
        if (signs != null) {
            System.arraycopy(signs, pos, signs, pos + numNew, this.size - pos + 1);
        }
        if (containNull) {
            if (signs == null) {
                this.signs = signs = new boolean[datas.length];
            }
            int i = 0;
            while (i < numNew) {
                if (array[i] == null) {
                    signs[pos + i] = true;
                } else {
                    datas[pos + i] = (Boolean)array[i];
                    signs[pos + i] = false;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < numNew) {
                datas[pos + i] = (Boolean)array[i];
                if (signs != null) {
                    signs[pos + i] = false;
                }
                ++i;
            }
        }
        this.size += numNew;
    }

    @Override
    public void push(Object o) {
        if (o instanceof Boolean) {
            this.datas[++this.size] = (Boolean)o;
        } else if (o == null) {
            if (this.signs == null) {
                this.signs = new boolean[this.datas.length];
            }
            this.signs[++this.size] = true;
        } else {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("pdm.arrayTypeError", mm.getMessage("DataType.Boolean"), Variant.getDataType(o)));
        }
    }

    @Override
    public void push(IArray array, int index) {
        if (array instanceof BoolArray) {
            if (array.isNull(index)) {
                if (this.signs == null) {
                    this.signs = new boolean[this.datas.length];
                }
                this.signs[++this.size] = true;
            } else {
                this.datas[++this.size] = ((BoolArray)array).getBool(index);
            }
        } else {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("pdm.arrayTypeError", mm.getMessage("DataType.Boolean"), array.getDataType()));
        }
    }

    @Override
    public void add(IArray array, int index) {
        if (array.isNull(index)) {
            this.ensureCapacity(this.size + 1);
            if (this.signs == null) {
                this.signs = new boolean[this.datas.length];
            }
            this.signs[++this.size] = true;
        } else if (array instanceof BoolArray) {
            this.ensureCapacity(this.size + 1);
            this.datas[++this.size] = ((BoolArray)array).getBool(index);
        } else {
            this.add(array.get(index));
        }
    }

    @Override
    public void set(int curIndex, IArray array, int index) {
        if (array.isNull(index)) {
            if (this.signs == null) {
                this.signs = new boolean[this.datas.length];
            }
            this.signs[curIndex] = true;
        } else if (array instanceof BoolArray) {
            this.datas[curIndex] = ((BoolArray)array).getBool(index);
        } else {
            this.set(curIndex, array.get(index));
        }
    }

    public void addBool(boolean b) {
        this.ensureCapacity(this.size + 1);
        this.datas[++this.size] = b;
    }

    public void push(boolean n) {
        this.datas[++this.size] = n;
    }

    public void pushBool(boolean n) {
        this.datas[++this.size] = n;
    }

    @Override
    public void pushNull() {
        if (this.signs == null) {
            this.signs = new boolean[this.datas.length];
        }
        this.signs[++this.size] = true;
    }

    @Override
    public Object get(int index) {
        if (this.signs == null || !this.signs[index]) {
            return this.datas[index];
        }
        return null;
    }

    public boolean getBool(int index) {
        return this.datas[index];
    }

    @Override
    public int getInt(int index) {
        throw new RuntimeException();
    }

    @Override
    public long getLong(int index) {
        throw new RuntimeException();
    }

    @Override
    public IArray get(int[] indexArray) {
        boolean[] datas = this.datas;
        boolean[] signs = this.signs;
        int len = indexArray.length;
        BoolArray result = new BoolArray(len);
        if (signs == null) {
            int[] nArray = indexArray;
            int n = indexArray.length;
            int n2 = 0;
            while (n2 < n) {
                int i = nArray[n2];
                result.pushBool(datas[i]);
                ++n2;
            }
        } else {
            int[] nArray = indexArray;
            int n = indexArray.length;
            int n3 = 0;
            while (n3 < n) {
                int i = nArray[n3];
                if (signs[i]) {
                    result.pushNull();
                } else {
                    result.pushBool(datas[i]);
                }
                ++n3;
            }
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public IArray get(int[] indexArray, int start, int end, boolean doCheck) {
        block11: {
            block10: {
                datas = this.datas;
                signs = this.signs;
                len = end - start + 1;
                result = new BoolArray(len);
                if (!doCheck) break block10;
                if (signs != null) ** GOTO lbl22
                while (start <= end) {
                    q = indexArray[start];
                    if (q > 0) {
                        result.pushBool(datas[q]);
                    } else {
                        result.pushNull();
                    }
                    ++start;
                }
                break block11;
lbl-1000:
                // 1 sources

                {
                    q = indexArray[start];
                    if (q < 1 || signs[q]) {
                        result.pushNull();
                    } else {
                        result.pushBool(datas[q]);
                    }
                    ++start;
lbl22:
                    // 2 sources

                    ** while (start <= end)
                }
lbl23:
                // 1 sources

                break block11;
            }
            if (signs != null) ** GOTO lbl37
            while (start <= end) {
                result.pushBool(datas[indexArray[start]]);
                ++start;
            }
            break block11;
lbl-1000:
            // 1 sources

            {
                q = indexArray[start];
                if (signs[q]) {
                    result.pushNull();
                } else {
                    result.pushBool(datas[q]);
                }
                ++start;
lbl37:
                // 2 sources

                ** while (start <= end)
            }
        }
        return result;
    }

    @Override
    public IArray get(IArray indexArray) {
        boolean[] datas = this.datas;
        boolean[] signs = this.signs;
        int len = indexArray.size();
        BoolArray result = new BoolArray(len);
        if (signs == null) {
            int i = 1;
            while (i <= len) {
                result.pushBool(datas[indexArray.getInt(i)]);
                ++i;
            }
        } else {
            int i = 1;
            while (i <= len) {
                int index = indexArray.getInt(i);
                if (signs[index]) {
                    result.pushNull();
                } else {
                    result.pushBool(datas[index]);
                }
                ++i;
            }
        }
        return result;
    }

    @Override
    public IArray get(int start, int end) {
        int newSize = end - start;
        boolean[] newDatas = new boolean[newSize + 1];
        System.arraycopy(this.datas, start, newDatas, 1, newSize);
        if (this.signs == null) {
            return new BoolArray(newDatas, null, newSize);
        }
        boolean[] newSigns = new boolean[newSize + 1];
        System.arraycopy(this.signs, start, newSigns, 1, newSize);
        return new BoolArray(newDatas, newSigns, newSize);
    }

    @Override
    public void ensureCapacity(int minCapacity) {
        int oldCapacity = this.datas.length;
        if (oldCapacity <= minCapacity) {
            int newCapacity;
            if (minCapacity < 8) {
                newCapacity = 8;
            } else {
                newCapacity = oldCapacity + (oldCapacity >> 1);
                if (newCapacity < 0) {
                    newCapacity = oldCapacity + 0xFFFFFFF;
                    if (newCapacity < 0) {
                        newCapacity = Integer.MAX_VALUE;
                    }
                } else if (newCapacity <= minCapacity) {
                    newCapacity = minCapacity + 1;
                }
            }
            boolean[] newDatas = new boolean[newCapacity];
            System.arraycopy(this.datas, 0, newDatas, 0, this.size + 1);
            this.datas = newDatas;
            if (this.signs != null) {
                boolean[] newSigns = new boolean[newCapacity];
                System.arraycopy(this.signs, 0, newSigns, 0, this.size + 1);
                this.signs = newSigns;
            }
        }
    }

    @Override
    public void trimToSize() {
        int newLen = this.size + 1;
        if (newLen < this.datas.length) {
            boolean[] newDatas = new boolean[newLen];
            System.arraycopy(this.datas, 0, newDatas, 0, newLen);
            this.datas = newDatas;
            if (this.signs != null) {
                boolean[] newSigns = new boolean[newLen];
                System.arraycopy(this.signs, 0, newSigns, 0, newLen);
                this.signs = newSigns;
            }
        }
    }

    @Override
    public boolean isNull(int index) {
        return this.signs != null && this.signs[index];
    }

    @Override
    public BoolArray isTrue() {
        if (this.signs == null) {
            if (this.isTemporary()) {
                return this;
            }
            boolean[] resultDatas = new boolean[this.size + 1];
            System.arraycopy(this.datas, 1, resultDatas, 1, this.size);
            BoolArray result = new BoolArray(resultDatas, this.size);
            result.setTemporary(true);
            return result;
        }
        int size = this.size;
        boolean[] resultDatas = new boolean[size + 1];
        System.arraycopy(this.datas, 1, resultDatas, 1, size);
        boolean[] signs = this.signs;
        int i = 1;
        while (i <= size) {
            if (signs[i]) {
                resultDatas[i] = false;
            }
            ++i;
        }
        BoolArray result = new BoolArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    @Override
    public BoolArray isFalse() {
        int i;
        int size = this.size;
        boolean[] datas = this.datas;
        boolean[] signs = this.signs;
        boolean[] resultDatas = new boolean[size + 1];
        if (signs == null) {
            i = 1;
            while (i <= size) {
                resultDatas[i] = !datas[i];
                ++i;
            }
        } else {
            i = 1;
            while (i <= size) {
                resultDatas[i] = signs[i] || !datas[i];
                ++i;
            }
        }
        BoolArray result = new BoolArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    @Override
    public boolean isTrue(int index) {
        return this.datas[index] && (this.signs == null || !this.signs[index]);
    }

    @Override
    public boolean isFalse(int index) {
        return !this.datas[index] || this.signs != null && this.signs[index];
    }

    @Override
    public boolean isTemporary() {
        return this.datas[0];
    }

    @Override
    public void setTemporary(boolean ifTemporary) {
        this.datas[0] = ifTemporary;
    }

    @Override
    public void removeLast() {
        if (this.signs != null) {
            this.signs[this.size] = false;
        }
        --this.size;
    }

    @Override
    public void remove(int index) {
        System.arraycopy(this.datas, index + 1, this.datas, index, this.size - index);
        if (this.signs != null) {
            System.arraycopy(this.signs, index + 1, this.signs, index, this.size - index);
            this.signs[this.size] = false;
        }
        --this.size;
    }

    @Override
    public void removeRange(int fromIndex, int toIndex) {
        System.arraycopy(this.datas, toIndex + 1, this.datas, fromIndex, this.size - toIndex);
        if (this.signs != null) {
            System.arraycopy(this.signs, toIndex + 1, this.signs, fromIndex, this.size - toIndex);
            int i = this.size - toIndex + fromIndex;
            while (i <= this.size) {
                this.signs[i] = false;
                ++i;
            }
        }
        this.size -= toIndex - fromIndex + 1;
    }

    @Override
    public void remove(int[] seqs) {
        int delCount = 0;
        boolean[] datas = this.datas;
        boolean[] signs = this.signs;
        int i = 0;
        int len = seqs.length;
        while (i < len) {
            int moveCount;
            int cur = seqs[i];
            if ((moveCount = ++i < len ? seqs[i] - cur - 1 : this.size - cur) > 0) {
                System.arraycopy(datas, cur + 1, datas, cur - delCount, moveCount);
                if (signs != null) {
                    System.arraycopy(signs, cur + 1, signs, cur - delCount, moveCount);
                }
            }
            ++delCount;
        }
        if (signs != null) {
            i = 0;
            int q = this.size;
            while (i < delCount) {
                signs[q - i] = false;
                ++i;
            }
        }
        this.size -= delCount;
    }

    @Override
    public void reserve(int start, int end) {
        int newSize = end - start + 1;
        System.arraycopy(this.datas, start, this.datas, 1, newSize);
        if (this.signs != null) {
            System.arraycopy(this.signs, start, this.signs, 1, newSize);
            int i = this.size;
            while (i > newSize) {
                this.signs[i] = false;
                --i;
            }
        }
        this.size = newSize;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public int count() {
        int size;
        boolean[] datas = this.datas;
        boolean[] signs = this.signs;
        int count = size = this.size;
        if (signs == null) {
            int i = 1;
            while (i <= size) {
                if (!datas[i]) {
                    --count;
                }
                ++i;
            }
        } else {
            int i = 1;
            while (i <= size) {
                if (signs[i] || !datas[i]) {
                    --count;
                }
                ++i;
            }
        }
        return count;
    }

    @Override
    public boolean containTrue() {
        boolean[] datas = this.datas;
        boolean[] signs = this.signs;
        int size = this.size;
        if (signs == null) {
            int i = 1;
            while (i <= size) {
                if (datas[i]) {
                    return true;
                }
                ++i;
            }
        } else {
            int i = 1;
            while (i <= size) {
                if (!signs[i] && datas[i]) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    @Override
    public Object ifn() {
        int size = this.size;
        if (size == 0) {
            return null;
        }
        boolean[] signs = this.signs;
        if (signs == null) {
            return this.datas[1];
        }
        int i = 1;
        while (i <= size) {
            if (!signs[i]) {
                return this.datas[i];
            }
            ++i;
        }
        return null;
    }

    public void set(int index, boolean b) {
        this.datas[index] = b;
        if (this.signs != null) {
            this.signs[index] = false;
        }
    }

    @Override
    public void set(int index, Object obj) {
        if (obj == null) {
            if (this.signs == null) {
                this.signs = new boolean[this.datas.length];
            }
            this.signs[index] = true;
        } else if (obj instanceof Boolean) {
            this.datas[index] = (Boolean)obj;
            if (this.signs != null) {
                this.signs[index] = false;
            }
        } else {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("pdm.arrayTypeError", mm.getMessage("DataType.Boolean"), Variant.getDataType(obj)));
        }
    }

    @Override
    public void clear() {
        this.signs = null;
        this.size = 0;
    }

    @Override
    public int binarySearch(Object elem) {
        if (elem instanceof Boolean) {
            int size = this.size;
            boolean[] datas = this.datas;
            boolean[] signs = this.signs;
            if (((Boolean)elem).booleanValue()) {
                if (size == 0) {
                    return -1;
                }
                if ((signs == null || !signs[size]) && datas[size]) {
                    return size;
                }
                return -size - 1;
            }
            if (size == 0) {
                return -1;
            }
            if (signs == null) {
                return datas[1] ? -1 : 1;
            }
            int i = 1;
            while (i <= size) {
                if (!signs[i]) {
                    return datas[i] ? -i : i;
                }
                ++i;
            }
            return -size - 1;
        }
        if (elem == null) {
            if (this.size > 0 && this.signs != null && this.signs[1]) {
                return 1;
            }
            return -1;
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("Variant2.illCompare", this.datas[1], elem, this.getDataType(), Variant.getDataType(elem)));
    }

    @Override
    public int binarySearch(Object elem, int start, int end) {
        if (elem instanceof Boolean) {
            boolean[] datas = this.datas;
            boolean[] signs = this.signs;
            if (((Boolean)elem).booleanValue()) {
                if (this.size == 0) {
                    return -1;
                }
                if ((signs == null || !signs[end]) && datas[end]) {
                    return end;
                }
                return -end - 1;
            }
            if (end == 0) {
                return -1;
            }
            if (signs == null) {
                return datas[start] ? -1 : start;
            }
            int i = start;
            while (i <= end) {
                if (!signs[i]) {
                    return datas[i] ? -i : i;
                }
                ++i;
            }
            return -end - 1;
        }
        if (elem == null) {
            if (end > 0 && this.signs != null && this.signs[start]) {
                return start;
            }
            return -1;
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("Variant2.illCompare", this.datas[1], elem, this.getDataType(), Variant.getDataType(elem)));
    }

    @Override
    public boolean contains(Object elem) {
        if (elem instanceof Boolean) {
            boolean v = (Boolean)elem;
            boolean[] datas = this.datas;
            boolean[] signs = this.signs;
            int size = this.size;
            if (signs == null) {
                int i = 1;
                while (i <= size) {
                    if (datas[i] == v) {
                        return true;
                    }
                    ++i;
                }
            } else {
                int i = 1;
                while (i <= size) {
                    if (!signs[i] && datas[i] == v) {
                        return true;
                    }
                    ++i;
                }
            }
            return false;
        }
        if (elem == null) {
            boolean[] signs = this.signs;
            if (signs == null) {
                return false;
            }
            int size = this.size;
            int i = 1;
            while (i <= size) {
                if (signs[i]) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        return false;
    }

    @Override
    public void contains(boolean isSorted, IArray array, BoolArray result) {
        int resultSize = result.size();
        if (isSorted) {
            int i = 1;
            while (i <= resultSize) {
                if (result.isTrue(i) && this.binarySearch(array.get(i)) < 1) {
                    result.set(i, false);
                }
                ++i;
            }
        } else {
            int i = 1;
            while (i <= resultSize) {
                if (result.isTrue(i) && !this.contains(array.get(i))) {
                    result.set(i, false);
                }
                ++i;
            }
        }
    }

    @Override
    public boolean objectContains(Object elem) {
        return false;
    }

    @Override
    public int firstIndexOf(Object elem, int start) {
        if (elem instanceof Boolean) {
            boolean v = (Boolean)elem;
            boolean[] datas = this.datas;
            boolean[] signs = this.signs;
            int size = this.size;
            if (signs == null) {
                int i = start;
                while (i <= size) {
                    if (datas[i] == v) {
                        return i;
                    }
                    ++i;
                }
            } else {
                int i = start;
                while (i <= size) {
                    if (!signs[i] && datas[i] == v) {
                        return i;
                    }
                    ++i;
                }
            }
            return 0;
        }
        if (elem == null) {
            boolean[] signs = this.signs;
            if (signs == null) {
                return 0;
            }
            int i = start;
            int size = this.size;
            while (i <= size) {
                if (signs[i]) {
                    return i;
                }
                ++i;
            }
            return 0;
        }
        return 0;
    }

    @Override
    public int lastIndexOf(Object elem, int start) {
        if (elem instanceof Boolean) {
            boolean v = (Boolean)elem;
            boolean[] datas = this.datas;
            boolean[] signs = this.signs;
            if (signs == null) {
                int i = start;
                while (i > 0) {
                    if (datas[i] == v) {
                        return i;
                    }
                    --i;
                }
            } else {
                int i = start;
                while (i > 0) {
                    if (!signs[i] && datas[i] == v) {
                        return i;
                    }
                    --i;
                }
            }
            return 0;
        }
        if (elem == null) {
            boolean[] signs = this.signs;
            if (signs == null) {
                return 0;
            }
            int i = start;
            while (i > 0) {
                if (signs[i]) {
                    return i;
                }
                --i;
            }
            return 0;
        }
        return 0;
    }

    @Override
    public IntArray indexOfAll(Object elem, int start, boolean isSorted, boolean isFromHead) {
        int size = this.size;
        boolean[] signs = this.signs;
        if (elem == null) {
            IntArray result = new IntArray(7);
            if (signs != null) {
                if (isSorted) {
                    if (isFromHead) {
                        int i = start;
                        while (i <= size) {
                            if (signs[i]) {
                                result.addInt(i);
                                ++i;
                                continue;
                            }
                            break;
                        }
                    } else {
                        int i = start;
                        while (i > 0) {
                            if (signs[i]) {
                                result.addInt(i);
                            }
                            --i;
                        }
                    }
                } else if (isFromHead) {
                    int i = start;
                    while (i <= size) {
                        if (signs[i]) {
                            result.addInt(i);
                        }
                        ++i;
                    }
                } else {
                    int i = start;
                    while (i > 0) {
                        if (signs[i]) {
                            result.addInt(i);
                        }
                        --i;
                    }
                }
            }
            return result;
        }
        if (!(elem instanceof Boolean)) {
            return new IntArray(1);
        }
        boolean b = (Boolean)elem;
        boolean[] datas = this.datas;
        IntArray result = new IntArray(7);
        if (isFromHead) {
            if (signs == null) {
                int i = start;
                while (i <= size) {
                    if (datas[i] == b) {
                        result.addInt(i);
                    }
                    ++i;
                }
            } else {
                int i = start;
                while (i <= size) {
                    if (!signs[i] && datas[i] == b) {
                        result.addInt(i);
                    }
                    ++i;
                }
            }
        } else if (signs == null) {
            int i = start;
            while (i > 0) {
                if (datas[i] == b) {
                    result.addInt(i);
                }
                --i;
            }
        } else {
            int i = start;
            while (i > 0) {
                if (!signs[i] && datas[i] == b) {
                    result.addInt(i);
                }
                --i;
            }
        }
        return result;
    }

    @Override
    public IArray abs() {
        MessageManager mm = EngineMessage.get();
        throw new RuntimeException(String.valueOf(this.getDataType()) + mm.getMessage("Variant2.illAbs"));
    }

    @Override
    public IArray negate() {
        MessageManager mm = EngineMessage.get();
        throw new RuntimeException(String.valueOf(this.getDataType()) + mm.getMessage("Variant2.illNegate"));
    }

    @Override
    public IArray not() {
        int i;
        boolean[] datas = this.datas;
        boolean[] signs = this.signs;
        int size = this.size;
        if (this.isTemporary()) {
            if (signs == null) {
                int i2 = 1;
                while (i2 <= size) {
                    datas[i2] = !datas[i2];
                    ++i2;
                }
            } else {
                this.signs = null;
                int i3 = 1;
                while (i3 <= size) {
                    datas[i3] = signs[i3] || !datas[i3];
                    ++i3;
                }
            }
            return this;
        }
        boolean[] newDatas = new boolean[size + 1];
        if (signs == null) {
            i = 1;
            while (i <= size) {
                newDatas[i] = !datas[i];
                ++i;
            }
        } else {
            i = 1;
            while (i <= size) {
                newDatas[i] = signs[i] || !datas[i];
                ++i;
            }
        }
        BoolArray result = new BoolArray(newDatas, size);
        result.setTemporary(true);
        return result;
    }

    @Override
    public boolean isNumberArray() {
        return false;
    }

    @Override
    public IArray memberAdd(IArray array) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(String.valueOf(this.getDataType()) + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illAdd"));
    }

    @Override
    public IArray memberAdd(Object value) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(String.valueOf(this.getDataType()) + mm.getMessage("Variant2.with") + Variant.getDataType(value) + mm.getMessage("Variant2.illAdd"));
    }

    @Override
    public IArray memberSubtract(IArray array) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(String.valueOf(this.getDataType()) + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illSubtract"));
    }

    @Override
    public IArray memberMultiply(IArray array) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(String.valueOf(this.getDataType()) + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illMultiply"));
    }

    @Override
    public IArray memberMultiply(Object value) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(String.valueOf(this.getDataType()) + mm.getMessage("Variant2.with") + Variant.getDataType(value) + mm.getMessage("Variant2.illMultiply"));
    }

    @Override
    public IArray memberDivide(IArray array) {
        if (array instanceof StringArray) {
            return this.memberDivide((StringArray)array);
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(String.valueOf(this.getDataType()) + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illDivide"));
    }

    private StringArray memberDivide(StringArray array) {
        int size = this.size;
        boolean[] d1 = this.datas;
        boolean[] s1 = this.signs;
        String[] d2 = array.getDatas();
        if (array.isTemporary()) {
            int i = 1;
            while (i <= size) {
                if (s1 == null || !s1[i]) {
                    d2[i] = d2[i] != null ? String.valueOf(d1[i]) + d2[i] : Boolean.toString(d1[i]);
                }
                ++i;
            }
            return array;
        }
        String[] resultDatas = new String[size + 1];
        int i = 1;
        while (i <= size) {
            if (d2[i] != null) {
                resultDatas[i] = s1 == null || !s1[i] ? String.valueOf(d1[i]) + d2[i] : d2[i];
            } else if (s1 == null || !s1[i]) {
                resultDatas[i] = Boolean.toString(d1[i]);
            }
            ++i;
        }
        StringArray result = new StringArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    @Override
    public IArray memberMod(IArray array) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(String.valueOf(this.getDataType()) + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illMod"));
    }

    @Override
    public IArray memberIntDivide(IArray array) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(String.valueOf(this.getDataType()) + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illDivide"));
    }

    @Override
    public BoolArray calcRelation(IArray array, int relation) {
        if (array instanceof BoolArray) {
            return this.calcRelation((BoolArray)array, relation);
        }
        if (array instanceof ConstArray) {
            return this.calcRelation(array.get(1), relation);
        }
        if (array instanceof IntArray) {
            return this.calcRelation((IntArray)array, relation);
        }
        if (array instanceof LongArray) {
            return this.calcRelation((LongArray)array, relation);
        }
        if (array instanceof DoubleArray) {
            return this.calcRelation((DoubleArray)array, relation);
        }
        if (array instanceof DateArray) {
            return this.calcRelation((DateArray)array, relation);
        }
        if (array instanceof StringArray) {
            return this.calcRelation((StringArray)array, relation);
        }
        if (array instanceof ObjectArray) {
            return this.calcRelation((ObjectArray)array, relation);
        }
        return array.calcRelation(this, Relation.getInverseRelation(relation));
    }

    @Override
    public BoolArray calcRelation(Object value, int relation) {
        if (value instanceof Boolean) {
            return this.calcRelation((Boolean)value, relation);
        }
        if (value == null) {
            return this.calcRelationNull(relation);
        }
        int size = this.size;
        boolean[] d1 = this.datas;
        boolean[] s1 = this.signs;
        boolean b = Variant.isTrue(value);
        if (relation == 7) {
            BoolArray result;
            boolean[] resultDatas;
            if (this.isTemporary()) {
                resultDatas = d1;
                result = this;
                this.signs = null;
            } else {
                resultDatas = new boolean[size + 1];
                result = new BoolArray(resultDatas, size);
                result.setTemporary(true);
            }
            if (!b) {
                int i = 1;
                while (i <= size) {
                    resultDatas[i] = false;
                    ++i;
                }
            } else if (s1 == null) {
                if (resultDatas != d1) {
                    System.arraycopy(d1, 1, resultDatas, 1, size);
                }
            } else {
                int i = 1;
                while (i <= size) {
                    resultDatas[i] = !s1[i] && d1[i];
                    ++i;
                }
            }
            return result;
        }
        if (relation == 8) {
            BoolArray result;
            boolean[] resultDatas;
            if (this.isTemporary()) {
                resultDatas = d1;
                result = this;
                this.signs = null;
            } else {
                resultDatas = new boolean[size + 1];
                result = new BoolArray(resultDatas, size);
                result.setTemporary(true);
            }
            if (b) {
                int i = 1;
                while (i <= size) {
                    resultDatas[i] = true;
                    ++i;
                }
            } else if (s1 == null) {
                if (resultDatas != d1) {
                    System.arraycopy(d1, 1, resultDatas, 1, size);
                }
            } else {
                int i = 1;
                while (i <= size) {
                    resultDatas[i] = !s1[i] && d1[i];
                    ++i;
                }
            }
            return result;
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("Variant2.illCompare", this.get(1), value, this.getDataType(), Variant.getDataType(value)));
    }

    private BoolArray calcRelation(BoolArray array, int relation) {
        BoolArray result;
        boolean[] resultDatas;
        int size = this.size;
        boolean[] d1 = this.datas;
        boolean[] s1 = this.signs;
        boolean[] d2 = array.datas;
        boolean[] s2 = array.signs;
        if (this.isTemporary()) {
            resultDatas = d1;
            result = this;
            result.signs = null;
        } else if (array.isTemporary()) {
            resultDatas = d2;
            result = array;
            result.signs = null;
        } else {
            resultDatas = new boolean[size + 1];
            result = new BoolArray(resultDatas, size);
            result.setTemporary(true);
        }
        if (relation == 1) {
            if (s1 == null) {
                if (s2 == null) {
                    int i = 1;
                    while (i <= size) {
                        resultDatas[i] = d1[i] == d2[i];
                        ++i;
                    }
                } else {
                    int i = 1;
                    while (i <= size) {
                        resultDatas[i] = s2[i] ? false : d1[i] == d2[i];
                        ++i;
                    }
                }
            } else if (s2 == null) {
                int i = 1;
                while (i <= size) {
                    resultDatas[i] = s1[i] ? false : d1[i] == d2[i];
                    ++i;
                }
            } else {
                int i = 1;
                while (i <= size) {
                    resultDatas[i] = s1[i] ? s2[i] : (s2[i] ? false : d1[i] == d2[i]);
                    ++i;
                }
            }
        } else if (relation == 2) {
            if (s1 == null) {
                if (s2 == null) {
                    int i = 1;
                    while (i <= size) {
                        resultDatas[i] = Variant.compare(d1[i], d2[i]) > 0;
                        ++i;
                    }
                } else {
                    int i = 1;
                    while (i <= size) {
                        resultDatas[i] = s2[i] ? true : Variant.compare(d1[i], d2[i]) > 0;
                        ++i;
                    }
                }
            } else if (s2 == null) {
                int i = 1;
                while (i <= size) {
                    resultDatas[i] = s1[i] ? false : Variant.compare(d1[i], d2[i]) > 0;
                    ++i;
                }
            } else {
                int i = 1;
                while (i <= size) {
                    resultDatas[i] = s1[i] ? false : (s2[i] ? true : Variant.compare(d1[i], d2[i]) > 0);
                    ++i;
                }
            }
        } else if (relation == 3) {
            if (s1 == null) {
                if (s2 == null) {
                    int i = 1;
                    while (i <= size) {
                        resultDatas[i] = Variant.compare(d1[i], d2[i]) >= 0;
                        ++i;
                    }
                } else {
                    int i = 1;
                    while (i <= size) {
                        resultDatas[i] = s2[i] ? true : Variant.compare(d1[i], d2[i]) >= 0;
                        ++i;
                    }
                }
            } else if (s2 == null) {
                int i = 1;
                while (i <= size) {
                    resultDatas[i] = s1[i] ? false : Variant.compare(d1[i], d2[i]) >= 0;
                    ++i;
                }
            } else {
                int i = 1;
                while (i <= size) {
                    resultDatas[i] = s1[i] ? s2[i] : (s2[i] ? true : Variant.compare(d1[i], d2[i]) >= 0);
                    ++i;
                }
            }
        } else if (relation == 4) {
            if (s1 == null) {
                if (s2 == null) {
                    int i = 1;
                    while (i <= size) {
                        resultDatas[i] = Variant.compare(d1[i], d2[i]) < 0;
                        ++i;
                    }
                } else {
                    int i = 1;
                    while (i <= size) {
                        resultDatas[i] = s2[i] ? false : Variant.compare(d1[i], d2[i]) < 0;
                        ++i;
                    }
                }
            } else if (s2 == null) {
                int i = 1;
                while (i <= size) {
                    resultDatas[i] = s1[i] ? true : Variant.compare(d1[i], d2[i]) < 0;
                    ++i;
                }
            } else {
                int i = 1;
                while (i <= size) {
                    resultDatas[i] = s1[i] ? !s2[i] : (s2[i] ? false : Variant.compare(d1[i], d2[i]) < 0);
                    ++i;
                }
            }
        } else if (relation == 5) {
            if (s1 == null) {
                if (s2 == null) {
                    int i = 1;
                    while (i <= size) {
                        resultDatas[i] = Variant.compare(d1[i], d2[i]) <= 0;
                        ++i;
                    }
                } else {
                    int i = 1;
                    while (i <= size) {
                        resultDatas[i] = s2[i] ? false : Variant.compare(d1[i], d2[i]) <= 0;
                        ++i;
                    }
                }
            } else if (s2 == null) {
                int i = 1;
                while (i <= size) {
                    resultDatas[i] = s1[i] ? true : Variant.compare(d1[i], d2[i]) <= 0;
                    ++i;
                }
            } else {
                int i = 1;
                while (i <= size) {
                    resultDatas[i] = s1[i] ? true : (s2[i] ? false : Variant.compare(d1[i], d2[i]) <= 0);
                    ++i;
                }
            }
        } else if (relation == 6) {
            if (s1 == null) {
                if (s2 == null) {
                    int i = 1;
                    while (i <= size) {
                        resultDatas[i] = d1[i] ^ d2[i];
                        ++i;
                    }
                } else {
                    int i = 1;
                    while (i <= size) {
                        resultDatas[i] = s2[i] ? true : d1[i] ^ d2[i];
                        ++i;
                    }
                }
            } else if (s2 == null) {
                int i = 1;
                while (i <= size) {
                    resultDatas[i] = s1[i] ? true : d1[i] ^ d2[i];
                    ++i;
                }
            } else {
                int i = 1;
                while (i <= size) {
                    resultDatas[i] = s1[i] ? !s2[i] : (s2[i] ? true : d1[i] ^ d2[i]);
                    ++i;
                }
            }
        } else if (relation == 7) {
            if (s1 == null) {
                if (s2 == null) {
                    int i = 1;
                    while (i <= size) {
                        resultDatas[i] = d1[i] && d2[i];
                        ++i;
                    }
                } else {
                    int i = 1;
                    while (i <= size) {
                        resultDatas[i] = d1[i] && !s2[i] && d2[i];
                        ++i;
                    }
                }
            } else if (s2 == null) {
                int i = 1;
                while (i <= size) {
                    resultDatas[i] = !s1[i] && d1[i] && d2[i];
                    ++i;
                }
            } else {
                int i = 1;
                while (i <= size) {
                    resultDatas[i] = !s1[i] && d1[i] && !s2[i] && d2[i];
                    ++i;
                }
            }
        } else if (s1 == null) {
            if (s2 == null) {
                int i = 1;
                while (i <= size) {
                    resultDatas[i] = d1[i] || d2[i];
                    ++i;
                }
            } else {
                int i = 1;
                while (i <= size) {
                    resultDatas[i] = d1[i] || !s2[i] && d2[i];
                    ++i;
                }
            }
        } else if (s2 == null) {
            int i = 1;
            while (i <= size) {
                resultDatas[i] = !s1[i] && d1[i] || d2[i];
                ++i;
            }
        } else {
            int i = 1;
            while (i <= size) {
                resultDatas[i] = !s1[i] && d1[i] || !s2[i] && d2[i];
                ++i;
            }
        }
        return result;
    }

    private BoolArray calcRelation(boolean[] s2, int relation) {
        int i;
        int size = this.size;
        boolean[] d1 = this.datas;
        boolean[] s1 = this.signs;
        if (this.isTemporary()) {
            if (relation == 7) {
                if (s1 == null) {
                    if (s2 != null) {
                        int i2 = 1;
                        while (i2 <= size) {
                            if (s2[i2]) {
                                d1[i2] = false;
                            }
                            ++i2;
                        }
                    }
                } else if (s2 == null) {
                    int i3 = 1;
                    while (i3 <= size) {
                        if (s1[i3]) {
                            d1[i3] = false;
                        }
                        ++i3;
                    }
                } else {
                    int i4 = 1;
                    while (i4 <= size) {
                        if (s1[i4] || s2[i4]) {
                            d1[i4] = false;
                        }
                        ++i4;
                    }
                }
            } else if (s2 == null) {
                int i5 = 1;
                while (i5 <= size) {
                    d1[i5] = true;
                    ++i5;
                }
            } else if (s1 == null) {
                int i6 = 1;
                while (i6 <= size) {
                    if (!s2[i6]) {
                        d1[i6] = true;
                    }
                    ++i6;
                }
            } else {
                int i7 = 1;
                while (i7 <= size) {
                    if (!s2[i7]) {
                        d1[i7] = true;
                    } else if (s1[i7]) {
                        d1[i7] = false;
                    }
                    ++i7;
                }
            }
            this.signs = null;
            return this;
        }
        boolean[] resultDatas = new boolean[size + 1];
        if (relation == 7) {
            if (s1 == null) {
                if (s2 == null) {
                    System.arraycopy(d1, 1, resultDatas, 1, size);
                } else {
                    i = 1;
                    while (i <= size) {
                        resultDatas[i] = d1[i] && !s2[i];
                        ++i;
                    }
                }
            } else if (s2 == null) {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = !s1[i] && d1[i];
                    ++i;
                }
            } else {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = !s2[i] && !s1[i] && d1[i];
                    ++i;
                }
            }
        } else if (s2 == null) {
            i = 1;
            while (i <= size) {
                resultDatas[i] = true;
                ++i;
            }
        } else if (s1 == null) {
            i = 1;
            while (i <= size) {
                resultDatas[i] = d1[i] || !s2[i];
                ++i;
            }
        } else {
            i = 1;
            while (i <= size) {
                resultDatas[i] = !s2[i] || !s1[i] && d1[i];
                ++i;
            }
        }
        BoolArray result = new BoolArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    protected BoolArray calcRelation(IntArray array, int relation) {
        if (relation != 7 && relation != 8) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("Variant2.illCompare", this.get(1), array.get(1), this.getDataType(), array.getDataType()));
        }
        return this.calcRelation(array.getSigns(), relation);
    }

    protected BoolArray calcRelation(LongArray array, int relation) {
        if (relation != 7 && relation != 8) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("Variant2.illCompare", this.get(1), array.get(1), this.getDataType(), array.getDataType()));
        }
        return this.calcRelation(array.getSigns(), relation);
    }

    protected BoolArray calcRelation(DoubleArray array, int relation) {
        if (relation != 7 && relation != 8) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("Variant2.illCompare", this.get(1), array.get(1), this.getDataType(), array.getDataType()));
        }
        return this.calcRelation(array.getSigns(), relation);
    }

    BoolArray calcRelation(DateArray array, int relation) {
        int size = this.size;
        boolean[] d1 = this.datas;
        boolean[] s1 = this.signs;
        Date[] d2 = array.getDatas();
        if (relation == 7) {
            BoolArray result;
            boolean[] resultDatas;
            if (this.isTemporary()) {
                resultDatas = d1;
                result = this;
                this.signs = null;
            } else {
                resultDatas = new boolean[size + 1];
                result = new BoolArray(resultDatas, size);
                result.setTemporary(true);
            }
            if (s1 == null) {
                int i = 1;
                while (i <= size) {
                    resultDatas[i] = d1[i] && Variant.isTrue(d2[i]);
                    ++i;
                }
            } else {
                int i = 1;
                while (i <= size) {
                    resultDatas[i] = !s1[i] && d1[i] && Variant.isTrue(d2[i]);
                    ++i;
                }
            }
            return result;
        }
        if (relation == 8) {
            BoolArray result;
            boolean[] resultDatas;
            if (this.isTemporary()) {
                resultDatas = d1;
                result = this;
                this.signs = null;
            } else {
                resultDatas = new boolean[size + 1];
                result = new BoolArray(resultDatas, size);
                result.setTemporary(true);
            }
            if (s1 == null) {
                int i = 1;
                while (i <= size) {
                    resultDatas[i] = d1[i] || Variant.isTrue(d2[i]);
                    ++i;
                }
            } else {
                int i = 1;
                while (i <= size) {
                    resultDatas[i] = !s1[i] && d1[i] || Variant.isTrue(d2[i]);
                    ++i;
                }
            }
            return result;
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("Variant2.illCompare", this.get(1), array.get(1), this.getDataType(), array.getDataType()));
    }

    BoolArray calcRelation(StringArray array, int relation) {
        int size = this.size;
        boolean[] d1 = this.datas;
        boolean[] s1 = this.signs;
        String[] d2 = array.getDatas();
        if (relation == 7) {
            BoolArray result;
            boolean[] resultDatas;
            if (this.isTemporary()) {
                resultDatas = d1;
                result = this;
                this.signs = null;
            } else {
                resultDatas = new boolean[size + 1];
                result = new BoolArray(resultDatas, size);
                result.setTemporary(true);
            }
            if (s1 == null) {
                int i = 1;
                while (i <= size) {
                    resultDatas[i] = d1[i] && Variant.isTrue(d2[i]);
                    ++i;
                }
            } else {
                int i = 1;
                while (i <= size) {
                    resultDatas[i] = !s1[i] && d1[i] && Variant.isTrue(d2[i]);
                    ++i;
                }
            }
            return result;
        }
        if (relation == 8) {
            BoolArray result;
            boolean[] resultDatas;
            if (this.isTemporary()) {
                resultDatas = d1;
                result = this;
                this.signs = null;
            } else {
                resultDatas = new boolean[size + 1];
                result = new BoolArray(resultDatas, size);
                result.setTemporary(true);
            }
            if (s1 == null) {
                int i = 1;
                while (i <= size) {
                    resultDatas[i] = d1[i] || Variant.isTrue(d2[i]);
                    ++i;
                }
            } else {
                int i = 1;
                while (i <= size) {
                    resultDatas[i] = !s1[i] && d1[i] || Variant.isTrue(d2[i]);
                    ++i;
                }
            }
            return result;
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("Variant2.illCompare", this.get(1), array.get(1), this.getDataType(), array.getDataType()));
    }

    private static int compare(boolean b1, Object o2) {
        if (o2 instanceof Boolean) {
            return Variant.compare(b1, (Boolean)o2);
        }
        if (o2 == null) {
            return 1;
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("Variant2.illCompare", b1, o2, mm.getMessage("DataType.Boolean"), Variant.getDataType(o2)));
    }

    BoolArray calcRelation(ObjectArray array, int relation) {
        BoolArray result;
        boolean[] resultDatas;
        int size = this.size;
        boolean[] d1 = this.datas;
        boolean[] s1 = this.signs;
        Object[] d2 = array.getDatas();
        if (this.isTemporary()) {
            resultDatas = d1;
            result = this;
            this.signs = null;
        } else {
            resultDatas = new boolean[size + 1];
            result = new BoolArray(resultDatas, size);
            result.setTemporary(true);
        }
        if (relation == 1) {
            if (s1 == null) {
                int i = 1;
                while (i <= size) {
                    resultDatas[i] = BoolArray.compare(d1[i], d2[i]) == 0;
                    ++i;
                }
            } else {
                int i = 1;
                while (i <= size) {
                    resultDatas[i] = s1[i] ? d2[i] == null : BoolArray.compare(d1[i], d2[i]) == 0;
                    ++i;
                }
            }
        } else if (relation == 2) {
            if (s1 == null) {
                int i = 1;
                while (i <= size) {
                    resultDatas[i] = BoolArray.compare(d1[i], d2[i]) > 0;
                    ++i;
                }
            } else {
                int i = 1;
                while (i <= size) {
                    resultDatas[i] = s1[i] ? false : BoolArray.compare(d1[i], d2[i]) > 0;
                    ++i;
                }
            }
        } else if (relation == 3) {
            if (s1 == null) {
                int i = 1;
                while (i <= size) {
                    resultDatas[i] = BoolArray.compare(d1[i], d2[i]) >= 0;
                    ++i;
                }
            } else {
                int i = 1;
                while (i <= size) {
                    resultDatas[i] = s1[i] ? d2[i] == null : BoolArray.compare(d1[i], d2[i]) >= 0;
                    ++i;
                }
            }
        } else if (relation == 4) {
            if (s1 == null) {
                int i = 1;
                while (i <= size) {
                    resultDatas[i] = BoolArray.compare(d1[i], d2[i]) < 0;
                    ++i;
                }
            } else {
                int i = 1;
                while (i <= size) {
                    resultDatas[i] = s1[i] ? d2[i] != null : BoolArray.compare(d1[i], d2[i]) < 0;
                    ++i;
                }
            }
        } else if (relation == 5) {
            if (s1 == null) {
                int i = 1;
                while (i <= size) {
                    resultDatas[i] = BoolArray.compare(d1[i], d2[i]) <= 0;
                    ++i;
                }
            } else {
                int i = 1;
                while (i <= size) {
                    resultDatas[i] = s1[i] ? true : BoolArray.compare(d1[i], d2[i]) <= 0;
                    ++i;
                }
            }
        } else if (relation == 6) {
            if (s1 == null) {
                int i = 1;
                while (i <= size) {
                    resultDatas[i] = BoolArray.compare(d1[i], d2[i]) != 0;
                    ++i;
                }
            } else {
                int i = 1;
                while (i <= size) {
                    resultDatas[i] = s1[i] ? d2[i] != null : BoolArray.compare(d1[i], d2[i]) != 0;
                    ++i;
                }
            }
        } else if (relation == 7) {
            if (s1 == null) {
                int i = 1;
                while (i <= size) {
                    resultDatas[i] = d1[i] && Variant.isTrue(d2[i]);
                    ++i;
                }
            } else {
                int i = 1;
                while (i <= size) {
                    resultDatas[i] = !s1[i] && d1[i] && Variant.isTrue(d2[i]);
                    ++i;
                }
            }
        } else if (s1 == null) {
            int i = 1;
            while (i <= size) {
                resultDatas[i] = d1[i] || Variant.isTrue(d2[i]);
                ++i;
            }
        } else {
            int i = 1;
            while (i <= size) {
                resultDatas[i] = !s1[i] && d1[i] || Variant.isTrue(d2[i]);
                ++i;
            }
        }
        return result;
    }

    private BoolArray calcRelation(boolean value, int relation) {
        BoolArray result;
        block31: {
            boolean[] s1;
            boolean[] d1;
            int size;
            block41: {
                boolean[] resultDatas;
                block40: {
                    block37: {
                        block39: {
                            block38: {
                                block36: {
                                    block35: {
                                        block34: {
                                            block33: {
                                                block32: {
                                                    block30: {
                                                        size = this.size;
                                                        d1 = this.datas;
                                                        s1 = this.signs;
                                                        if (this.isTemporary()) {
                                                            resultDatas = d1;
                                                            result = this;
                                                            result.signs = null;
                                                        } else {
                                                            resultDatas = new boolean[size + 1];
                                                            result = new BoolArray(resultDatas, size);
                                                            result.setTemporary(true);
                                                        }
                                                        if (relation != 1) break block30;
                                                        if (s1 == null) {
                                                            int i = 1;
                                                            while (i <= size) {
                                                                resultDatas[i] = Variant.compare(d1[i], value) == 0;
                                                                ++i;
                                                            }
                                                        } else {
                                                            int i = 1;
                                                            while (i <= size) {
                                                                resultDatas[i] = s1[i] ? false : Variant.compare(d1[i], value) == 0;
                                                                ++i;
                                                            }
                                                        }
                                                        break block31;
                                                    }
                                                    if (relation != 2) break block32;
                                                    if (s1 == null) {
                                                        int i = 1;
                                                        while (i <= size) {
                                                            resultDatas[i] = Variant.compare(d1[i], value) > 0;
                                                            ++i;
                                                        }
                                                    } else {
                                                        int i = 1;
                                                        while (i <= size) {
                                                            resultDatas[i] = s1[i] ? false : Variant.compare(d1[i], value) > 0;
                                                            ++i;
                                                        }
                                                    }
                                                    break block31;
                                                }
                                                if (relation != 3) break block33;
                                                if (s1 == null) {
                                                    int i = 1;
                                                    while (i <= size) {
                                                        resultDatas[i] = Variant.compare(d1[i], value) >= 0;
                                                        ++i;
                                                    }
                                                } else {
                                                    int i = 1;
                                                    while (i <= size) {
                                                        resultDatas[i] = s1[i] ? false : Variant.compare(d1[i], value) >= 0;
                                                        ++i;
                                                    }
                                                }
                                                break block31;
                                            }
                                            if (relation != 4) break block34;
                                            if (s1 == null) {
                                                int i = 1;
                                                while (i <= size) {
                                                    resultDatas[i] = Variant.compare(d1[i], value) < 0;
                                                    ++i;
                                                }
                                            } else {
                                                int i = 1;
                                                while (i <= size) {
                                                    resultDatas[i] = s1[i] ? true : Variant.compare(d1[i], value) < 0;
                                                    ++i;
                                                }
                                            }
                                            break block31;
                                        }
                                        if (relation != 5) break block35;
                                        if (s1 == null) {
                                            int i = 1;
                                            while (i <= size) {
                                                resultDatas[i] = Variant.compare(d1[i], value) <= 0;
                                                ++i;
                                            }
                                        } else {
                                            int i = 1;
                                            while (i <= size) {
                                                resultDatas[i] = s1[i] ? true : Variant.compare(d1[i], value) <= 0;
                                                ++i;
                                            }
                                        }
                                        break block31;
                                    }
                                    if (relation != 6) break block36;
                                    if (s1 == null) {
                                        int i = 1;
                                        while (i <= size) {
                                            resultDatas[i] = Variant.compare(d1[i], value) != 0;
                                            ++i;
                                        }
                                    } else {
                                        int i = 1;
                                        while (i <= size) {
                                            resultDatas[i] = s1[i] ? true : Variant.compare(d1[i], value) != 0;
                                            ++i;
                                        }
                                    }
                                    break block31;
                                }
                                if (relation != 7) break block37;
                                if (value) break block38;
                                int i = 1;
                                while (i <= size) {
                                    resultDatas[i] = false;
                                    ++i;
                                }
                                break block31;
                            }
                            if (s1 != null) break block39;
                            if (resultDatas == d1) break block31;
                            System.arraycopy(d1, 1, resultDatas, 1, size);
                            break block31;
                        }
                        int i = 1;
                        while (i <= size) {
                            resultDatas[i] = !s1[i] && d1[i];
                            ++i;
                        }
                        break block31;
                    }
                    if (!value) break block40;
                    int i = 1;
                    while (i <= size) {
                        resultDatas[i] = true;
                        ++i;
                    }
                    break block31;
                }
                if (s1 != null) break block41;
                if (resultDatas == d1) break block31;
                System.arraycopy(d1, 1, resultDatas, 1, size);
                break block31;
            }
            int i = 1;
            while (i <= size) {
                resultDatas[i] = !s1[i] && d1[i];
                ++i;
            }
        }
        return result;
    }

    private BoolArray calcRelationNull(int relation) {
        BoolArray result;
        block18: {
            boolean[] signs;
            boolean[] datas;
            int size;
            block26: {
                boolean[] resultDatas;
                block25: {
                    block24: {
                        block22: {
                            block23: {
                                block21: {
                                    block20: {
                                        block19: {
                                            block16: {
                                                block17: {
                                                    size = this.size;
                                                    datas = this.datas;
                                                    signs = this.signs;
                                                    if (this.isTemporary()) {
                                                        resultDatas = datas;
                                                        result = this;
                                                        result.signs = null;
                                                    } else {
                                                        resultDatas = new boolean[size + 1];
                                                        result = new BoolArray(resultDatas, size);
                                                        result.setTemporary(true);
                                                    }
                                                    if (relation != 1) break block16;
                                                    if (signs == null) break block17;
                                                    System.arraycopy(signs, 1, resultDatas, 1, size);
                                                    break block18;
                                                }
                                                if (resultDatas != datas) break block18;
                                                int i = 1;
                                                while (i <= size) {
                                                    resultDatas[i] = false;
                                                    ++i;
                                                }
                                                break block18;
                                            }
                                            if (relation != 2) break block19;
                                            if (signs == null) {
                                                int i = 1;
                                                while (i <= size) {
                                                    resultDatas[i] = true;
                                                    ++i;
                                                }
                                            } else {
                                                int i = 1;
                                                while (i <= size) {
                                                    resultDatas[i] = !signs[i];
                                                    ++i;
                                                }
                                            }
                                            break block18;
                                        }
                                        if (relation != 3) break block20;
                                        int i = 1;
                                        while (i <= size) {
                                            resultDatas[i] = true;
                                            ++i;
                                        }
                                        break block18;
                                    }
                                    if (relation != 4) break block21;
                                    if (resultDatas != datas) break block18;
                                    int i = 1;
                                    while (i <= size) {
                                        resultDatas[i] = false;
                                        ++i;
                                    }
                                    break block18;
                                }
                                if (relation != 5) break block22;
                                if (signs == null) break block23;
                                System.arraycopy(signs, 1, resultDatas, 1, size);
                                break block18;
                            }
                            if (resultDatas != datas) break block18;
                            int i = 1;
                            while (i <= size) {
                                resultDatas[i] = false;
                                ++i;
                            }
                            break block18;
                        }
                        if (relation != 6) break block24;
                        if (signs == null) {
                            int i = 1;
                            while (i <= size) {
                                resultDatas[i] = true;
                                ++i;
                            }
                        } else {
                            int i = 1;
                            while (i <= size) {
                                resultDatas[i] = !signs[i];
                                ++i;
                            }
                        }
                        break block18;
                    }
                    if (relation != 7) break block25;
                    if (resultDatas != datas) break block18;
                    int i = 1;
                    while (i <= size) {
                        resultDatas[i] = false;
                        ++i;
                    }
                    break block18;
                }
                if (signs != null) break block26;
                if (resultDatas == datas) break block18;
                System.arraycopy(datas, 1, resultDatas, 1, size);
                break block18;
            }
            int i = 1;
            while (i <= size) {
                resultDatas[i] = !signs[i] && datas[i];
                ++i;
            }
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public int compareTo(IArray array) {
        block27: {
            block26: {
                size1 = this.size;
                size2 = array.size();
                d1 = this.datas;
                s1 = this.signs;
                size = size1;
                result = 0;
                if (size1 < size2) {
                    result = -1;
                } else if (size1 > size2) {
                    result = 1;
                    size = size2;
                }
                if (!(array instanceof BoolArray)) break block26;
                array2 = (BoolArray)array;
                d2 = array2.datas;
                s2 = array2.signs;
                i = 1;
                while (i <= size) {
                    if (s1 != null && s1[i]) ** GOTO lbl26
                    if (s2 == null || !s2[i]) {
                        cmp = Variant.compare(d1[i], d2[i]);
                        if (cmp != 0) {
                            return cmp;
                        }
                    } else {
                        return 1;
lbl26:
                        // 1 sources

                        if (s2 == null || !s2[i]) {
                            return -1;
                        }
                    }
                    ++i;
                }
                break block27;
            }
            if (!(array instanceof ConstArray)) ** GOTO lbl59
            value = array.get(1);
            if (value instanceof Boolean) {
                d2 = (Boolean)value;
                i = 1;
                while (i <= size) {
                    if (s1 == null || !s1[i]) {
                        cmp = Variant.compare(d1[i], d2);
                        if (cmp != 0) {
                            return cmp;
                        }
                    } else {
                        return -1;
                    }
                    ++i;
                }
            } else if (value == null) {
                if (s1 == null) {
                    return 1;
                }
                i = 1;
                while (i <= size) {
                    if (!s1[i]) {
                        return 1;
                    }
                    ++i;
                }
            } else {
                mm = EngineMessage.get();
                throw new RQException(mm.getMessage("Variant2.illCompare", this.get(1), value, this.getDataType(), array.getDataType()));
lbl59:
                // 1 sources

                if (array instanceof ObjectArray) {
                    array2 = (ObjectArray)array;
                    d2 = array2.getDatas();
                    i = 1;
                    while (i <= size) {
                        if (s1 == null || !s1[i]) {
                            cmp = BoolArray.compare(d1[i], d2[i]);
                            if (cmp != 0) {
                                return cmp;
                            }
                        } else if (d2[i] != null) {
                            return -1;
                        }
                        ++i;
                    }
                } else {
                    mm = EngineMessage.get();
                    throw new RQException(mm.getMessage("Variant2.illCompare", this.get(1), array.get(1), this.getDataType(), array.getDataType()));
                }
            }
        }
        return result;
    }

    @Override
    public int memberCompare(int index1, int index2) {
        if (this.signs == null) {
            return Variant.compare(this.datas[index1], this.datas[index2]);
        }
        if (this.signs[index1]) {
            return this.signs[index2] ? 0 : -1;
        }
        if (this.signs[index2]) {
            return 1;
        }
        return Variant.compare(this.datas[index1], this.datas[index2]);
    }

    @Override
    public boolean isMemberEquals(int index1, int index2) {
        if (this.signs == null) {
            return this.datas[index1] == this.datas[index2];
        }
        if (this.signs[index1]) {
            return this.signs[index2];
        }
        if (this.signs[index2]) {
            return false;
        }
        return this.datas[index1] == this.datas[index2];
    }

    @Override
    public boolean isEquals(int curIndex, IArray array, int index) {
        if (this.isNull(curIndex)) {
            return array.isNull(index);
        }
        if (array.isNull(index)) {
            return false;
        }
        if (array instanceof BoolArray) {
            return this.datas[curIndex] == ((BoolArray)array).getBool(index);
        }
        Object obj = array.get(index);
        return obj instanceof Boolean && (Boolean)obj == this.datas[curIndex];
    }

    @Override
    public boolean isEquals(int curIndex, Object value) {
        if (value instanceof Boolean) {
            if (this.signs == null || !this.signs[curIndex]) {
                return this.datas[curIndex] == (Boolean)value;
            }
            return false;
        }
        if (value == null) {
            return this.signs != null && this.signs[curIndex];
        }
        return false;
    }

    @Override
    public int compareTo(int curIndex, IArray array, int index) {
        if (this.isNull(curIndex)) {
            return array.isNull(index) ? 0 : -1;
        }
        if (array.isNull(index)) {
            return 1;
        }
        if (array instanceof BoolArray) {
            return Variant.compare(this.datas[curIndex], ((BoolArray)array).getBool(index));
        }
        return BoolArray.compare(this.datas[curIndex], array.get(index));
    }

    @Override
    public int compareTo(int curIndex, Object value) {
        if (this.isNull(curIndex)) {
            return value == null ? 0 : -1;
        }
        if (value == null) {
            return 1;
        }
        return BoolArray.compare(this.datas[curIndex], value);
    }

    @Override
    public int hashCode(int index) {
        if (this.signs == null || !this.signs[index]) {
            return Boolean.hashCode(this.datas[index]);
        }
        return 0;
    }

    @Override
    public Object sum() {
        return null;
    }

    @Override
    public Object average() {
        return null;
    }

    @Override
    public Object max() {
        int size = this.size;
        if (size == 0) {
            return null;
        }
        boolean[] datas = this.datas;
        boolean[] signs = this.signs;
        if (signs == null) {
            int i = 1;
            while (i <= size) {
                if (datas[i]) {
                    return Boolean.TRUE;
                }
                ++i;
            }
            return Boolean.FALSE;
        }
        int i = 1;
        while (i <= size) {
            if (!signs[i] && datas[i]) {
                return Boolean.TRUE;
            }
            ++i;
        }
        return Boolean.FALSE;
    }

    @Override
    public Object min() {
        int size = this.size;
        if (size == 0) {
            return null;
        }
        boolean[] datas = this.datas;
        boolean[] signs = this.signs;
        if (signs == null) {
            int i = 1;
            while (i <= size) {
                if (!datas[i]) {
                    return Boolean.FALSE;
                }
                ++i;
            }
            return Boolean.TRUE;
        }
        int i = 1;
        while (i <= size) {
            if (!signs[i] && !datas[i]) {
                return Boolean.FALSE;
            }
            ++i;
        }
        return Boolean.TRUE;
    }

    @Override
    public void calcRelations(IArray array, int relation, BoolArray result, boolean isAnd) {
        if (array != this) {
            if (array instanceof BoolArray) {
                this.calcRelations((BoolArray)array, relation, result, isAnd);
            } else if (array instanceof ConstArray) {
                this.calcRelations(array.get(1), relation, result, isAnd);
            } else if (array instanceof ObjectArray) {
                this.calcRelations((ObjectArray)array, relation, result, isAnd);
            } else {
                MessageManager mm = EngineMessage.get();
                throw new RQException(mm.getMessage("Variant2.illCompare", this.get(1), array.get(1), this.getDataType(), array.getDataType()));
            }
        }
    }

    @Override
    public void calcRelations(Object value, int relation, BoolArray result, boolean isAnd) {
        if (value instanceof Boolean) {
            this.calcRelations((Boolean)value, relation, result, isAnd);
        } else if (value == null) {
            ArrayUtil.calcRelationsNull(this.signs, this.size, relation, result, isAnd);
        } else {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("Variant2.illCompare", this.get(1), value, this.getDataType(), Variant.getDataType(value)));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void calcRelations(BoolArray array, int relation, BoolArray result, boolean isAnd) {
        int size = this.size;
        boolean[] d1 = this.datas;
        boolean[] s1 = this.signs;
        boolean[] d2 = array.datas;
        boolean[] s2 = array.signs;
        boolean[] resultDatas = result.getDatas();
        if (isAnd) {
            if (relation == 1) {
                if (s1 == null) {
                    if (s2 == null) {
                        int i = 1;
                        while (i <= size) {
                            if (resultDatas[i] && d1[i] != d2[i]) {
                                resultDatas[i] = false;
                            }
                            ++i;
                        }
                        return;
                    } else {
                        int i = 1;
                        while (i <= size) {
                            if (resultDatas[i] && (s2[i] || d1[i] != d2[i])) {
                                resultDatas[i] = false;
                            }
                            ++i;
                        }
                    }
                    return;
                } else if (s2 == null) {
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && (s1[i] || d1[i] != d2[i])) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                    return;
                } else {
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && (s1[i] != s2[i] || !s1[i] && d1[i] != d2[i])) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                }
                return;
            } else if (relation == 2) {
                if (s1 == null) {
                    if (s2 == null) {
                        int i = 1;
                        while (i <= size) {
                            if (resultDatas[i] && Variant.compare(d1[i], d2[i]) <= 0) {
                                resultDatas[i] = false;
                            }
                            ++i;
                        }
                        return;
                    } else {
                        int i = 1;
                        while (i <= size) {
                            if (resultDatas[i] && !s2[i] && Variant.compare(d1[i], d2[i]) <= 0) {
                                resultDatas[i] = false;
                            }
                            ++i;
                        }
                    }
                    return;
                } else if (s2 == null) {
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && (s1[i] || Variant.compare(d1[i], d2[i]) <= 0)) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                    return;
                } else {
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && (s1[i] || !s2[i] && Variant.compare(d1[i], d2[i]) <= 0)) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                }
                return;
            } else if (relation == 3) {
                if (s1 == null) {
                    if (s2 == null) {
                        int i = 1;
                        while (i <= size) {
                            if (resultDatas[i] && Variant.compare(d1[i], d2[i]) < 0) {
                                resultDatas[i] = false;
                            }
                            ++i;
                        }
                        return;
                    } else {
                        int i = 1;
                        while (i <= size) {
                            if (resultDatas[i] && !s2[i] && Variant.compare(d1[i], d2[i]) < 0) {
                                resultDatas[i] = false;
                            }
                            ++i;
                        }
                    }
                    return;
                } else if (s2 == null) {
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && (s1[i] || Variant.compare(d1[i], d2[i]) < 0)) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                    return;
                } else {
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && !s2[i] && (s1[i] || Variant.compare(d1[i], d2[i]) < 0)) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                }
                return;
            } else if (relation == 4) {
                if (s1 == null) {
                    if (s2 == null) {
                        int i = 1;
                        while (i <= size) {
                            if (resultDatas[i] && Variant.compare(d1[i], d2[i]) >= 0) {
                                resultDatas[i] = false;
                            }
                            ++i;
                        }
                        return;
                    } else {
                        int i = 1;
                        while (i <= size) {
                            if (resultDatas[i] && (s2[i] || Variant.compare(d1[i], d2[i]) >= 0)) {
                                resultDatas[i] = false;
                            }
                            ++i;
                        }
                    }
                    return;
                } else if (s2 == null) {
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && !s1[i] && Variant.compare(d1[i], d2[i]) >= 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                    return;
                } else {
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && (s2[i] || !s1[i] && Variant.compare(d1[i], d2[i]) >= 0)) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                }
                return;
            } else if (relation == 5) {
                if (s1 == null) {
                    if (s2 == null) {
                        int i = 1;
                        while (i <= size) {
                            if (resultDatas[i] && Variant.compare(d1[i], d2[i]) > 0) {
                                resultDatas[i] = false;
                            }
                            ++i;
                        }
                        return;
                    } else {
                        int i = 1;
                        while (i <= size) {
                            if (resultDatas[i] && (s2[i] || Variant.compare(d1[i], d2[i]) > 0)) {
                                resultDatas[i] = false;
                            }
                            ++i;
                        }
                    }
                    return;
                } else if (s2 == null) {
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && !s1[i] && Variant.compare(d1[i], d2[i]) > 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                    return;
                } else {
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && !s1[i] && (s2[i] || Variant.compare(d1[i], d2[i]) > 0)) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                }
                return;
            } else {
                if (relation != 6) throw new RuntimeException();
                if (s1 == null) {
                    if (s2 == null) {
                        int i = 1;
                        while (i <= size) {
                            if (resultDatas[i] && d1[i] == d2[i]) {
                                resultDatas[i] = false;
                            }
                            ++i;
                        }
                        return;
                    } else {
                        int i = 1;
                        while (i <= size) {
                            if (resultDatas[i] && !s2[i] && d1[i] == d2[i]) {
                                resultDatas[i] = false;
                            }
                            ++i;
                        }
                    }
                    return;
                } else if (s2 == null) {
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && !s1[i] && d1[i] == d2[i]) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                    return;
                } else {
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && s1[i] == s2[i] && (s1[i] || d1[i] == d2[i])) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                }
            }
            return;
        } else if (relation == 1) {
            if (s1 == null) {
                if (s2 == null) {
                    int i = 1;
                    while (i <= size) {
                        if (!resultDatas[i] && d1[i] == d2[i]) {
                            resultDatas[i] = true;
                        }
                        ++i;
                    }
                    return;
                } else {
                    int i = 1;
                    while (i <= size) {
                        if (!resultDatas[i] && !s2[i] && d1[i] == d2[i]) {
                            resultDatas[i] = true;
                        }
                        ++i;
                    }
                }
                return;
            } else if (s2 == null) {
                int i = 1;
                while (i <= size) {
                    if (!resultDatas[i] && !s1[i] && d1[i] == d2[i]) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
                return;
            } else {
                int i = 1;
                while (i <= size) {
                    if (!resultDatas[i] && (s1[i] ? s2[i] : !s2[i] && d1[i] == d2[i])) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
            }
            return;
        } else if (relation == 2) {
            if (s1 == null) {
                if (s2 == null) {
                    int i = 1;
                    while (i <= size) {
                        if (!resultDatas[i] && Variant.compare(d1[i], d2[i]) > 0) {
                            resultDatas[i] = true;
                        }
                        ++i;
                    }
                    return;
                } else {
                    int i = 1;
                    while (i <= size) {
                        if (!resultDatas[i] && (s2[i] || Variant.compare(d1[i], d2[i]) > 0)) {
                            resultDatas[i] = true;
                        }
                        ++i;
                    }
                }
                return;
            } else if (s2 == null) {
                int i = 1;
                while (i <= size) {
                    if (!resultDatas[i] && !s1[i] && Variant.compare(d1[i], d2[i]) > 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
                return;
            } else {
                int i = 1;
                while (i <= size) {
                    if (!(resultDatas[i] || s1[i] || !s2[i] && Variant.compare(d1[i], d2[i]) <= 0)) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
            }
            return;
        } else if (relation == 3) {
            if (s1 == null) {
                if (s2 == null) {
                    int i = 1;
                    while (i <= size) {
                        if (!resultDatas[i] && Variant.compare(d1[i], d2[i]) >= 0) {
                            resultDatas[i] = true;
                        }
                        ++i;
                    }
                    return;
                } else {
                    int i = 1;
                    while (i <= size) {
                        if (!resultDatas[i] && (s2[i] || Variant.compare(d1[i], d2[i]) >= 0)) {
                            resultDatas[i] = true;
                        }
                        ++i;
                    }
                }
                return;
            } else if (s2 == null) {
                int i = 1;
                while (i <= size) {
                    if (!resultDatas[i] && !s1[i] && Variant.compare(d1[i], d2[i]) >= 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
                return;
            } else {
                int i = 1;
                while (i <= size) {
                    if (!resultDatas[i] && (s2[i] || !s1[i] && Variant.compare(d1[i], d2[i]) >= 0)) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
            }
            return;
        } else if (relation == 4) {
            if (s1 == null) {
                if (s2 == null) {
                    int i = 1;
                    while (i <= size) {
                        if (!resultDatas[i] && Variant.compare(d1[i], d2[i]) < 0) {
                            resultDatas[i] = true;
                        }
                        ++i;
                    }
                    return;
                } else {
                    int i = 1;
                    while (i <= size) {
                        if (!resultDatas[i] && !s2[i] && Variant.compare(d1[i], d2[i]) < 0) {
                            resultDatas[i] = true;
                        }
                        ++i;
                    }
                }
                return;
            } else if (s2 == null) {
                int i = 1;
                while (i <= size) {
                    if (!resultDatas[i] && (s1[i] || Variant.compare(d1[i], d2[i]) < 0)) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
                return;
            } else {
                int i = 1;
                while (i <= size) {
                    if (!(resultDatas[i] || s2[i] || !s1[i] && Variant.compare(d1[i], d2[i]) >= 0)) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
            }
            return;
        } else if (relation == 5) {
            if (s1 == null) {
                if (s2 == null) {
                    int i = 1;
                    while (i <= size) {
                        if (!resultDatas[i] && Variant.compare(d1[i], d2[i]) <= 0) {
                            resultDatas[i] = true;
                        }
                        ++i;
                    }
                    return;
                } else {
                    int i = 1;
                    while (i <= size) {
                        if (!resultDatas[i] && !s2[i] && Variant.compare(d1[i], d2[i]) <= 0) {
                            resultDatas[i] = true;
                        }
                        ++i;
                    }
                }
                return;
            } else if (s2 == null) {
                int i = 1;
                while (i <= size) {
                    if (!resultDatas[i] && (s1[i] || Variant.compare(d1[i], d2[i]) <= 0)) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
                return;
            } else {
                int i = 1;
                while (i <= size) {
                    if (!resultDatas[i] && (s1[i] || !s2[i] && Variant.compare(d1[i], d2[i]) <= 0)) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
            }
            return;
        } else {
            if (relation != 6) throw new RuntimeException();
            if (s1 == null) {
                if (s2 == null) {
                    int i = 1;
                    while (i <= size) {
                        if (!resultDatas[i] && d1[i] != d2[i]) {
                            resultDatas[i] = true;
                        }
                        ++i;
                    }
                    return;
                } else {
                    int i = 1;
                    while (i <= size) {
                        if (!resultDatas[i] && (s2[i] || d1[i] != d2[i])) {
                            resultDatas[i] = true;
                        }
                        ++i;
                    }
                }
                return;
            } else if (s2 == null) {
                int i = 1;
                while (i <= size) {
                    if (!resultDatas[i] && (s1[i] || d1[i] != d2[i])) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
                return;
            } else {
                int i = 1;
                while (i <= size) {
                    if (!resultDatas[i] && (s1[i] ? !s2[i] : s2[i] || d1[i] != d2[i])) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void calcRelations(boolean value, int relation, BoolArray result, boolean isAnd) {
        int size = this.size;
        boolean[] d1 = this.datas;
        boolean[] s1 = this.signs;
        boolean[] resultDatas = result.getDatas();
        if (isAnd) {
            if (relation == 1) {
                if (s1 == null) {
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && d1[i] != value) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                    return;
                } else {
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && (s1[i] || d1[i] != value)) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                }
                return;
            } else if (relation == 2) {
                if (s1 == null) {
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && Variant.compare(d1[i], value) <= 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                    return;
                } else {
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && (s1[i] || Variant.compare(d1[i], value) <= 0)) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                }
                return;
            } else if (relation == 3) {
                if (s1 == null) {
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && Variant.compare(d1[i], value) < 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                    return;
                } else {
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && (s1[i] || Variant.compare(d1[i], value) < 0)) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                }
                return;
            } else if (relation == 4) {
                if (s1 == null) {
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && Variant.compare(d1[i], value) >= 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                    return;
                } else {
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && !s1[i] && Variant.compare(d1[i], value) >= 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                }
                return;
            } else if (relation == 5) {
                if (s1 == null) {
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && Variant.compare(d1[i], value) > 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                    return;
                } else {
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && !s1[i] && Variant.compare(d1[i], value) > 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                }
                return;
            } else {
                if (relation != 6) throw new RuntimeException();
                if (s1 == null) {
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && d1[i] == value) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                    return;
                } else {
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && !s1[i] && d1[i] == value) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                }
            }
            return;
        } else if (relation == 1) {
            if (s1 == null) {
                int i = 1;
                while (i <= size) {
                    if (!resultDatas[i] && d1[i] == value) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
                return;
            } else {
                int i = 1;
                while (i <= size) {
                    if (!resultDatas[i] && !s1[i] && d1[i] == value) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
            }
            return;
        } else if (relation == 2) {
            if (s1 == null) {
                int i = 1;
                while (i <= size) {
                    if (!resultDatas[i] && Variant.compare(d1[i], value) > 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
                return;
            } else {
                int i = 1;
                while (i <= size) {
                    if (!resultDatas[i] && !s1[i] && Variant.compare(d1[i], value) > 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
            }
            return;
        } else if (relation == 3) {
            if (s1 == null) {
                int i = 1;
                while (i <= size) {
                    if (!resultDatas[i] && Variant.compare(d1[i], value) >= 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
                return;
            } else {
                int i = 1;
                while (i <= size) {
                    if (!resultDatas[i] && !s1[i] && Variant.compare(d1[i], value) >= 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
            }
            return;
        } else if (relation == 4) {
            if (s1 == null) {
                int i = 1;
                while (i <= size) {
                    if (!resultDatas[i] && Variant.compare(d1[i], value) < 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
                return;
            } else {
                int i = 1;
                while (i <= size) {
                    if (!resultDatas[i] && (s1[i] || Variant.compare(d1[i], value) < 0)) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
            }
            return;
        } else if (relation == 5) {
            if (s1 == null) {
                int i = 1;
                while (i <= size) {
                    if (!resultDatas[i] && Variant.compare(d1[i], value) <= 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
                return;
            } else {
                int i = 1;
                while (i <= size) {
                    if (!resultDatas[i] && (s1[i] || Variant.compare(d1[i], value) <= 0)) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
            }
            return;
        } else {
            if (relation != 6) throw new RuntimeException();
            if (s1 == null) {
                int i = 1;
                while (i <= size) {
                    if (!resultDatas[i] && d1[i] != value) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
                return;
            } else {
                int i = 1;
                while (i <= size) {
                    if (!resultDatas[i] && (s1[i] || d1[i] != value)) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void calcRelations(ObjectArray array, int relation, BoolArray result, boolean isAnd) {
        int size = this.size;
        boolean[] d1 = this.datas;
        boolean[] s1 = this.signs;
        Object[] d2 = array.getDatas();
        boolean[] resultDatas = result.getDatas();
        if (isAnd) {
            if (relation == 1) {
                if (s1 == null) {
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && BoolArray.compare(d1[i], d2[i]) != 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                    return;
                } else {
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && (s1[i] ? d2[i] != null : BoolArray.compare(d1[i], d2[i]) != 0)) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                }
                return;
            } else if (relation == 2) {
                if (s1 == null) {
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && BoolArray.compare(d1[i], d2[i]) <= 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                    return;
                } else {
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && (s1[i] || BoolArray.compare(d1[i], d2[i]) <= 0)) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                }
                return;
            } else if (relation == 3) {
                if (s1 == null) {
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && BoolArray.compare(d1[i], d2[i]) < 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                    return;
                } else {
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && (s1[i] ? d2[i] != null : BoolArray.compare(d1[i], d2[i]) < 0)) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                }
                return;
            } else if (relation == 4) {
                if (s1 == null) {
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && BoolArray.compare(d1[i], d2[i]) >= 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                    return;
                } else {
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && (s1[i] ? d2[i] == null : BoolArray.compare(d1[i], d2[i]) >= 0)) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                }
                return;
            } else if (relation == 5) {
                if (s1 == null) {
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && BoolArray.compare(d1[i], d2[i]) > 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                    return;
                } else {
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && !s1[i] && BoolArray.compare(d1[i], d2[i]) > 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                }
                return;
            } else {
                if (relation != 6) throw new RuntimeException();
                if (s1 == null) {
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && BoolArray.compare(d1[i], d2[i]) == 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                    return;
                } else {
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && (s1[i] ? d2[i] == null : BoolArray.compare(d1[i], d2[i]) == 0)) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                }
            }
            return;
        } else if (relation == 1) {
            if (s1 == null) {
                int i = 1;
                while (i <= size) {
                    if (!resultDatas[i] && BoolArray.compare(d1[i], d2[i]) == 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
                return;
            } else {
                int i = 1;
                while (i <= size) {
                    if (!resultDatas[i] && (s1[i] ? d2[i] == null : BoolArray.compare(d1[i], d2[i]) == 0)) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
            }
            return;
        } else if (relation == 2) {
            if (s1 == null) {
                int i = 1;
                while (i <= size) {
                    if (!resultDatas[i] && BoolArray.compare(d1[i], d2[i]) > 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
                return;
            } else {
                int i = 1;
                while (i <= size) {
                    if (!resultDatas[i] && !s1[i] && BoolArray.compare(d1[i], d2[i]) > 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
            }
            return;
        } else if (relation == 3) {
            if (s1 == null) {
                int i = 1;
                while (i <= size) {
                    if (!resultDatas[i] && BoolArray.compare(d1[i], d2[i]) >= 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
                return;
            } else {
                int i = 1;
                while (i <= size) {
                    if (!resultDatas[i] && (d2[i] == null || !s1[i] && BoolArray.compare(d1[i], d2[i]) >= 0)) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
            }
            return;
        } else if (relation == 4) {
            if (s1 == null) {
                int i = 1;
                while (i <= size) {
                    if (!resultDatas[i] && BoolArray.compare(d1[i], d2[i]) < 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
                return;
            } else {
                int i = 1;
                while (i <= size) {
                    if (!resultDatas[i] && d2[i] != null && (s1[i] || BoolArray.compare(d1[i], d2[i]) < 0)) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
            }
            return;
        } else if (relation == 5) {
            if (s1 == null) {
                int i = 1;
                while (i <= size) {
                    if (!resultDatas[i] && BoolArray.compare(d1[i], d2[i]) <= 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
                return;
            } else {
                int i = 1;
                while (i <= size) {
                    if (!resultDatas[i] && (s1[i] || BoolArray.compare(d1[i], d2[i]) <= 0)) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
            }
            return;
        } else {
            if (relation != 6) throw new RuntimeException();
            if (s1 == null) {
                int i = 1;
                while (i <= size) {
                    if (!resultDatas[i] && BoolArray.compare(d1[i], d2[i]) != 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
                return;
            } else {
                int i = 1;
                while (i <= size) {
                    if (!resultDatas[i] && (s1[i] ? d2[i] != null : BoolArray.compare(d1[i], d2[i]) != 0)) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
            }
        }
    }

    @Override
    public IArray bitwiseAnd(IArray array) {
        MessageManager mm = EngineMessage.get();
        throw new RQException("and" + mm.getMessage("function.paramTypeError"));
    }

    @Override
    public IArray bitwiseOr(IArray array) {
        MessageManager mm = EngineMessage.get();
        throw new RQException("or" + mm.getMessage("function.paramTypeError"));
    }

    @Override
    public IArray bitwiseXOr(IArray array) {
        MessageManager mm = EngineMessage.get();
        throw new RQException("xor" + mm.getMessage("function.paramTypeError"));
    }

    @Override
    public IArray bitwiseNot() {
        MessageManager mm = EngineMessage.get();
        throw new RQException("not" + mm.getMessage("function.paramTypeError"));
    }

    @Override
    public IArray select(IArray signArray) {
        int size = signArray.size();
        boolean[] d1 = this.datas;
        boolean[] s1 = this.signs;
        boolean[] resultDatas = new boolean[size + 1];
        int resultSize = 0;
        if (s1 == null) {
            if (signArray instanceof BoolArray) {
                BoolArray array = (BoolArray)signArray;
                boolean[] d2 = array.getDatas();
                boolean[] s2 = array.getSigns();
                if (s2 == null) {
                    int i = 1;
                    while (i <= size) {
                        if (d2[i]) {
                            resultDatas[++resultSize] = d1[i];
                        }
                        ++i;
                    }
                } else {
                    int i = 1;
                    while (i <= size) {
                        if (!s2[i] && d2[i]) {
                            resultDatas[++resultSize] = d1[i];
                        }
                        ++i;
                    }
                }
            } else {
                int i = 1;
                while (i <= size) {
                    if (signArray.isTrue(i)) {
                        resultDatas[++resultSize] = d1[i];
                    }
                    ++i;
                }
            }
            return new BoolArray(resultDatas, null, resultSize);
        }
        boolean[] resultSigns = new boolean[size + 1];
        int i = 1;
        while (i <= size) {
            if (signArray.isTrue(i)) {
                ++resultSize;
                if (s1[i]) {
                    resultSigns[resultSize] = true;
                } else {
                    resultDatas[resultSize] = d1[i];
                }
            }
            ++i;
        }
        return new BoolArray(resultDatas, resultSigns, resultSize);
    }

    @Override
    public IArray select(int start, int end, IArray signArray) {
        boolean[] d1 = this.datas;
        boolean[] s1 = this.signs;
        boolean[] resultDatas = new boolean[end - start + 1];
        int resultSize = 0;
        if (s1 == null) {
            if (signArray instanceof BoolArray) {
                BoolArray array = (BoolArray)signArray;
                boolean[] d2 = array.getDatas();
                boolean[] s2 = array.getSigns();
                if (s2 == null) {
                    int i = start;
                    while (i < end) {
                        if (d2[i]) {
                            resultDatas[++resultSize] = d1[i];
                        }
                        ++i;
                    }
                } else {
                    int i = start;
                    while (i < end) {
                        if (!s2[i] && d2[i]) {
                            resultDatas[++resultSize] = d1[i];
                        }
                        ++i;
                    }
                }
            } else {
                int i = start;
                while (i < end) {
                    if (signArray.isTrue(i)) {
                        resultDatas[++resultSize] = d1[i];
                    }
                    ++i;
                }
            }
            return new BoolArray(resultDatas, null, resultSize);
        }
        boolean[] resultSigns = new boolean[end - start + 1];
        int i = start;
        while (i < end) {
            if (signArray.isTrue(i)) {
                ++resultSize;
                if (s1[i]) {
                    resultSigns[resultSize] = true;
                } else {
                    resultDatas[resultSize] = d1[i];
                }
            }
            ++i;
        }
        return new BoolArray(resultDatas, resultSigns, resultSize);
    }

    @Override
    public IArray memberAdd(int curIndex, IArray array, int index) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(String.valueOf(this.getDataType()) + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illAdd"));
    }

    @Override
    public Object[] toArray() {
        int size = this.size;
        boolean[] datas = this.datas;
        boolean[] signs = this.signs;
        Object[] result = new Object[size];
        if (signs == null) {
            int i = 1;
            while (i <= size) {
                result[i - 1] = datas[i];
                ++i;
            }
        } else {
            int i = 1;
            while (i <= size) {
                if (!signs[i]) {
                    result[i - 1] = datas[i];
                }
                ++i;
            }
        }
        return result;
    }

    @Override
    public void toArray(Object[] result) {
        int size = this.size;
        boolean[] datas = this.datas;
        boolean[] signs = this.signs;
        if (signs == null) {
            int i = 1;
            while (i <= size) {
                result[i - 1] = datas[i];
                ++i;
            }
        } else {
            int i = 1;
            while (i <= size) {
                if (!signs[i]) {
                    result[i - 1] = datas[i];
                }
                ++i;
            }
        }
    }

    @Override
    public IArray split(int pos) {
        int size = this.size;
        boolean[] signs = this.signs;
        int resultSize = size - pos + 1;
        boolean[] resultDatas = new boolean[resultSize + 1];
        System.arraycopy(this.datas, pos, resultDatas, 1, resultSize);
        if (signs == null) {
            this.size = pos - 1;
            return new BoolArray(resultDatas, null, resultSize);
        }
        boolean[] resultSigns = new boolean[resultSize + 1];
        System.arraycopy(signs, pos, resultSigns, 1, resultSize);
        int i = pos;
        while (i <= size) {
            signs[i] = false;
            ++i;
        }
        this.size = pos - 1;
        return new BoolArray(resultDatas, resultSigns, resultSize);
    }

    @Override
    public IArray split(int from, int to) {
        int oldSize = this.size;
        boolean[] datas = this.datas;
        boolean[] signs = this.signs;
        int resultSize = to - from + 1;
        boolean[] resultDatas = new boolean[resultSize + 1];
        System.arraycopy(datas, from, resultDatas, 1, resultSize);
        System.arraycopy(datas, to + 1, datas, from, oldSize - to);
        this.size -= resultSize;
        if (signs == null) {
            return new BoolArray(resultDatas, null, resultSize);
        }
        boolean[] resultSigns = new boolean[resultSize + 1];
        System.arraycopy(signs, from, resultSigns, 1, resultSize);
        System.arraycopy(signs, to + 1, signs, from, oldSize - to);
        return new BoolArray(resultDatas, resultSigns, resultSize);
    }

    @Override
    public void sort() {
        int size = this.size;
        boolean[] datas = this.datas;
        boolean[] signs = this.signs;
        if (signs == null) {
            int trueCount = 0;
            int i = 1;
            while (i <= size) {
                if (datas[i]) {
                    ++trueCount;
                }
                ++i;
            }
            int falseCount = size - trueCount;
            int i2 = 1;
            while (i2 <= falseCount) {
                datas[i2] = false;
                ++i2;
            }
            i2 = falseCount + 1;
            while (i2 <= size) {
                datas[i2] = true;
                ++i2;
            }
        } else {
            int nullCount = 0;
            int trueCount = 0;
            int i = 1;
            while (i <= size) {
                if (signs[i]) {
                    signs[i] = false;
                    ++nullCount;
                } else if (datas[i]) {
                    ++trueCount;
                }
                ++i;
            }
            i = 1;
            while (i <= nullCount) {
                signs[i] = true;
                ++i;
            }
            int falseEnd = size - trueCount;
            int i3 = nullCount + 1;
            while (i3 <= falseEnd) {
                datas[i3] = false;
                ++i3;
            }
            i3 = falseEnd + 1;
            while (i3 <= size) {
                datas[i3] = true;
                ++i3;
            }
        }
    }

    @Override
    public void sort(Comparator<Object> comparator) {
        int size = this.size;
        boolean[] datas = this.datas;
        boolean[] signs = this.signs;
        Object[] values = new Boolean[size + 1];
        if (signs == null) {
            int i = 1;
            while (i <= size) {
                values[i] = datas[i];
                ++i;
            }
            MultithreadUtil.sort(values, 1, size + 1, comparator);
            i = 1;
            while (i <= size) {
                datas[i] = (Boolean)values[i];
                ++i;
            }
        } else {
            int i = 1;
            while (i <= size) {
                if (!signs[i]) {
                    values[i] = datas[i];
                }
                ++i;
            }
            MultithreadUtil.sort(values, 1, size + 1, comparator);
            i = 1;
            while (i <= size) {
                if (values[i] != null) {
                    datas[i] = (Boolean)values[i];
                    signs[i] = false;
                } else {
                    signs[i] = true;
                }
                ++i;
            }
        }
    }

    @Override
    public boolean hasRecord() {
        return false;
    }

    @Override
    public boolean isPmt(boolean isPure) {
        return false;
    }

    @Override
    public IArray rvs() {
        int size = this.size;
        boolean[] datas = this.datas;
        boolean[] signs = this.signs;
        boolean[] resultDatas = new boolean[size + 1];
        if (signs == null) {
            int i = 1;
            int q = size;
            while (i <= size) {
                resultDatas[i] = datas[q--];
                ++i;
            }
            return new BoolArray(resultDatas, null, size);
        }
        boolean[] resultSigns = new boolean[size + 1];
        int i = 1;
        int q = size;
        while (i <= size) {
            if (signs[q]) {
                resultSigns[i] = true;
            } else {
                resultDatas[i] = datas[q];
            }
            ++i;
            --q;
        }
        return new BoolArray(resultDatas, resultSigns, size);
    }

    @Override
    public IntArray ptop(int count, boolean isAll, boolean isLast, boolean ignoreNull) {
        throw new RuntimeException();
    }

    @Override
    public IntArray ptopRank(int count, boolean ignoreNull, boolean iopt) {
        throw new RuntimeException();
    }

    @Override
    public void setSize(int size) {
        this.size = size;
    }

    @Override
    public ObjectArray toObjectArray() {
        int size = this.size;
        boolean[] datas = this.datas;
        boolean[] signs = this.signs;
        Object[] resultDatas = new Object[size + 1];
        if (signs == null) {
            int i = 1;
            while (i <= size) {
                resultDatas[i] = datas[i];
                ++i;
            }
        } else {
            int i = 1;
            while (i <= size) {
                if (!signs[i]) {
                    resultDatas[i] = datas[i];
                }
                ++i;
            }
        }
        return new ObjectArray(resultDatas, size);
    }

    @Override
    public IArray toPureArray() {
        return this;
    }

    @Override
    public IArray reserve(boolean refOrigin) {
        if (this.isTemporary()) {
            this.setTemporary(false);
            return this;
        }
        if (refOrigin) {
            return this;
        }
        return this.dup();
    }

    @Override
    public IArray combine(IArray signArray, IArray other) {
        IArray result;
        if (other instanceof ConstArray) {
            return this.combine(signArray, ((ConstArray)other).getData());
        }
        int size = this.size;
        boolean[] datas = this.datas;
        boolean[] signs = this.signs;
        if (other instanceof BoolArray) {
            BoolArray otherArray = (BoolArray)other;
            if (this.isTemporary()) {
                result = this;
                int i = 1;
                while (i <= size) {
                    if (signArray.isFalse(i)) {
                        if (otherArray.isNull(i)) {
                            if (signs == null) {
                                this.signs = signs = new boolean[size + 1];
                            }
                            signs[i] = true;
                        } else {
                            datas[i] = otherArray.getBool(i);
                            if (signs != null) {
                                signs[i] = false;
                            }
                        }
                    }
                    ++i;
                }
            } else {
                BoolArray resultArray;
                result = resultArray = new BoolArray(size);
                if (signs == null) {
                    int i = 1;
                    while (i <= size) {
                        if (signArray.isTrue(i)) {
                            resultArray.pushBool(datas[i]);
                        } else if (otherArray.isNull(i)) {
                            resultArray.pushNull();
                        } else {
                            resultArray.pushBool(otherArray.getBool(i));
                        }
                        ++i;
                    }
                } else {
                    int i = 1;
                    while (i <= size) {
                        if (signArray.isTrue(i)) {
                            if (signs[i]) {
                                resultArray.pushNull();
                            } else {
                                resultArray.pushBool(datas[i]);
                            }
                        } else if (otherArray.isNull(i)) {
                            resultArray.pushNull();
                        } else {
                            resultArray.pushBool(otherArray.getBool(i));
                        }
                        ++i;
                    }
                }
            }
        } else {
            Object[] resultDatas = new Object[size + 1];
            if (signs == null) {
                int i = 1;
                while (i <= size) {
                    resultDatas[i] = signArray.isTrue(i) ? Boolean.valueOf(datas[i]) : other.get(i);
                    ++i;
                }
            } else {
                int i = 1;
                while (i <= size) {
                    if (signArray.isTrue(i)) {
                        if (!signs[i]) {
                            resultDatas[i] = datas[i];
                        }
                    } else {
                        resultDatas[i] = other.get(i);
                    }
                    ++i;
                }
            }
            result = new ObjectArray(resultDatas, size);
        }
        result.setTemporary(true);
        return result;
    }

    @Override
    public IArray combine(IArray signArray, Object value) {
        IArray result;
        int size = this.size;
        boolean[] datas = this.datas;
        boolean[] signs = this.signs;
        if (value instanceof Boolean) {
            boolean v = (Boolean)value;
            if (this.isTemporary()) {
                result = this;
                if (signs == null) {
                    int i = 1;
                    while (i <= size) {
                        if (signArray.isFalse(i)) {
                            datas[i] = v;
                        }
                        ++i;
                    }
                } else {
                    int i = 1;
                    while (i <= size) {
                        if (signArray.isFalse(i)) {
                            datas[i] = v;
                            signs[i] = false;
                        }
                        ++i;
                    }
                }
            } else {
                boolean[] resultDatas = new boolean[size + 1];
                boolean[] resultSigns = null;
                if (signs == null) {
                    int i = 1;
                    while (i <= size) {
                        resultDatas[i] = signArray.isTrue(i) ? datas[i] : v;
                        ++i;
                    }
                } else {
                    resultSigns = new boolean[size + 1];
                    int i = 1;
                    while (i <= size) {
                        if (signArray.isTrue(i)) {
                            if (signs[i]) {
                                resultSigns[i] = true;
                            } else {
                                resultDatas[i] = datas[i];
                            }
                        } else {
                            resultDatas[i] = v;
                        }
                        ++i;
                    }
                }
                result = new BoolArray(resultDatas, resultSigns, size);
            }
        } else if (value == null) {
            if (this.isTemporary()) {
                result = this;
                if (signs == null) {
                    this.signs = signs = new boolean[size + 1];
                }
                int i = 1;
                while (i <= size) {
                    if (signArray.isFalse(i)) {
                        signs[i] = true;
                    }
                    ++i;
                }
            } else {
                boolean[] resultSigns = new boolean[size + 1];
                boolean[] resultDatas = new boolean[size + 1];
                int i = 1;
                while (i <= size) {
                    if (signArray.isTrue(i) && (signs == null || !signs[i])) {
                        resultDatas[i] = datas[i];
                    } else {
                        resultSigns[i] = true;
                    }
                    ++i;
                }
                result = new BoolArray(resultDatas, resultSigns, size);
            }
        } else {
            Object[] resultDatas = new Object[size + 1];
            if (signs == null) {
                int i = 1;
                while (i <= size) {
                    resultDatas[i] = signArray.isTrue(i) ? Boolean.valueOf(datas[i]) : value;
                    ++i;
                }
            } else {
                int i = 1;
                while (i <= size) {
                    if (signArray.isTrue(i)) {
                        if (!signs[i]) {
                            resultDatas[i] = datas[i];
                        }
                    } else {
                        resultDatas[i] = value;
                    }
                    ++i;
                }
            }
            result = new ObjectArray(resultDatas, size);
        }
        result.setTemporary(true);
        return result;
    }

    @Override
    public Object pos(IArray array, String opt) {
        if (array instanceof BoolArray) {
            BoolArray boolArray = (BoolArray)array;
            int len = this.size;
            int subLen = boolArray.size;
            if (len < subLen) {
                return null;
            }
            boolean isSorted = false;
            boolean isIncre = false;
            boolean isContinuous = false;
            if (opt != null) {
                if (opt.indexOf(98) != -1) {
                    isSorted = true;
                }
                if (opt.indexOf(105) != -1) {
                    isIncre = true;
                }
                if (opt.indexOf(99) != -1) {
                    isContinuous = true;
                }
            }
            if (isIncre) {
                IntArray result = new IntArray(subLen);
                if (isSorted) {
                    int pos = 1;
                    int t = 1;
                    while (t <= subLen) {
                        pos = this.binarySearch(boolArray.get(t), pos, len);
                        if (pos > 0) {
                            result.pushInt(pos);
                            ++pos;
                        } else {
                            return null;
                        }
                        ++t;
                    }
                } else {
                    int pos = 1;
                    int t = 1;
                    while (t <= subLen) {
                        pos = this.firstIndexOf(boolArray.get(t), pos);
                        if (pos > 0) {
                            result.pushInt(pos);
                            ++pos;
                        } else {
                            return null;
                        }
                        ++t;
                    }
                }
                return new Sequence(result);
            }
            if (isContinuous) {
                int maxCandidate = len - subLen + 1;
                if (isSorted) {
                    int candidate = 1;
                    block2: while (candidate <= maxCandidate) {
                        int result = this.compareTo(candidate, boolArray, 1);
                        if (result < 0) {
                            ++candidate;
                            continue;
                        }
                        if (result == 0) {
                            int i = 2;
                            int j = candidate + 1;
                            while (i <= subLen) {
                                if (!this.isEquals(j, boolArray, i)) {
                                    ++candidate;
                                    continue block2;
                                }
                                ++i;
                                ++j;
                            }
                            return candidate;
                        }
                        return null;
                    }
                } else {
                    int candidate = 1;
                    while (candidate <= maxCandidate) {
                        block32: {
                            int i = 1;
                            int j = candidate;
                            while (i <= subLen) {
                                if (this.isEquals(j, boolArray, i)) {
                                    ++i;
                                    ++j;
                                    continue;
                                }
                                break block32;
                            }
                            return candidate;
                        }
                        ++candidate;
                    }
                }
                return null;
            }
            IntArray result = new IntArray(subLen);
            if (isSorted) {
                int t = 1;
                while (t <= subLen) {
                    int pos = this.binarySearch(boolArray.get(t));
                    if (pos <= 0) {
                        return null;
                    }
                    result.pushInt(pos);
                    ++t;
                }
            } else {
                int t = 1;
                while (t <= subLen) {
                    int pos = this.firstIndexOf(boolArray.get(t), 1);
                    if (pos <= 0) {
                        return null;
                    }
                    result.pushInt(pos);
                    ++t;
                }
            }
            return new Sequence(result);
        }
        return ArrayUtil.pos(this, array, opt);
    }

    @Override
    public int bit1() {
        MessageManager mm = EngineMessage.get();
        throw new RQException("bit1" + mm.getMessage("function.paramTypeError"));
    }

    @Override
    public int bit1(IArray array) {
        MessageManager mm = EngineMessage.get();
        throw new RQException("bit1" + mm.getMessage("function.paramTypeError"));
    }

    public boolean hasSigns() {
        return this.signs != null;
    }

    @Override
    public int getNextEqualCount(int index) {
        boolean[] datas = this.datas;
        boolean[] signs = this.signs;
        int size = this.size;
        int count = 1;
        if (signs == null) {
            if (datas[index]) {
                ++index;
                while (index <= size) {
                    if (datas[index]) {
                        ++count;
                        ++index;
                        continue;
                    }
                    break;
                }
            } else {
                ++index;
                while (index <= size) {
                    if (!datas[index]) {
                        ++count;
                        ++index;
                        continue;
                    }
                    break;
                }
            }
        } else if (signs[index]) {
            ++index;
            while (index <= size) {
                if (signs[index]) {
                    ++count;
                    ++index;
                    continue;
                }
                break;
            }
        } else if (datas[index]) {
            ++index;
            while (index <= size) {
                if (!signs[index] && datas[index]) {
                    ++count;
                    ++index;
                    continue;
                }
                break;
            }
        } else {
            ++index;
            while (index <= size) {
                if (!signs[index] && !datas[index]) {
                    ++count;
                    ++index;
                    continue;
                }
                break;
            }
        }
        return count;
    }
}

