/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.array;

import com.scudata.array.ArrayUtil;
import com.scudata.array.BoolArray;
import com.scudata.array.ConstArray;
import com.scudata.array.IArray;
import com.scudata.array.IntArray;
import com.scudata.array.ObjectArray;
import com.scudata.common.ByteArrayInputRecord;
import com.scudata.common.ByteArrayOutputRecord;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.SerialBytes;
import com.scudata.resources.EngineMessage;
import com.scudata.thread.MultithreadUtil;
import com.scudata.util.HashUtil;
import com.scudata.util.Variant;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Comparator;

public class SerialBytesArray
implements IArray {
    private static final long NULL = 0L;
    private long[] datas1;
    private long[] datas2;
    private int size;

    public SerialBytesArray() {
        this(8);
    }

    public SerialBytesArray(int initialCapacity) {
        this.datas1 = new long[++initialCapacity];
        this.datas2 = new long[initialCapacity];
    }

    public SerialBytesArray(long[] datas1, long[] datas2, int size) {
        this.datas1 = datas1;
        this.datas2 = datas2;
        this.size = size;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        int size = this.size;
        long[] datas1 = this.datas1;
        long[] datas2 = this.datas2;
        out.writeInt(size);
        int i = 1;
        while (i <= size) {
            out.writeLong(datas1[i]);
            ++i;
        }
        i = 1;
        while (i <= size) {
            out.writeLong(datas2[i]);
            ++i;
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.size = in.readInt();
        int len = this.size + 1;
        this.datas1 = new long[len];
        long[] datas = this.datas1;
        int i = 1;
        while (i < len) {
            datas[i] = in.readLong();
            ++i;
        }
        this.datas2 = new long[len];
        datas = this.datas2;
        i = 1;
        while (i < len) {
            datas[i] = in.readLong();
            ++i;
        }
    }

    @Override
    public byte[] serialize() throws IOException {
        ByteArrayOutputRecord out = new ByteArrayOutputRecord();
        int size = this.size;
        long[] datas1 = this.datas1;
        long[] datas2 = this.datas2;
        out.writeInt(size);
        int i = 1;
        while (i <= size) {
            out.writeLong(datas1[i]);
            ++i;
        }
        i = 1;
        while (i <= size) {
            out.writeLong(datas2[i]);
            ++i;
        }
        return out.toByteArray();
    }

    @Override
    public void fillRecord(byte[] bytes) throws IOException, ClassNotFoundException {
        ByteArrayInputRecord in = new ByteArrayInputRecord(bytes);
        this.size = in.readInt();
        int len = this.size + 1;
        this.datas1 = new long[len];
        long[] datas = this.datas1;
        int i = 1;
        while (i < len) {
            datas[i] = in.readLong();
            ++i;
        }
        this.datas2 = new long[len];
        datas = this.datas2;
        i = 1;
        while (i < len) {
            datas[i] = in.readLong();
            ++i;
        }
    }

    @Override
    public String getDataType() {
        MessageManager mm = EngineMessage.get();
        return mm.getMessage("DataType.SerialBytes");
    }

    public void add(long value1, long value2) {
        int newSize = this.size + 1;
        this.ensureCapacity(newSize);
        this.datas1[newSize] = value1;
        this.datas2[newSize] = value1;
        this.size = newSize;
    }

    @Override
    public void add(Object o) {
        if (o instanceof SerialBytes) {
            this.ensureCapacity(this.size + 1);
            ++this.size;
            SerialBytes sb = (SerialBytes)o;
            this.datas1[this.size] = sb.getValue1();
            this.datas2[this.size] = sb.getValue2();
        } else if (o == null) {
            this.ensureCapacity(this.size + 1);
            ++this.size;
            this.datas1[this.size] = 0L;
            this.datas2[this.size] = 0L;
        } else {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("pdm.arrayTypeError", mm.getMessage("DataType.SerialBytes"), Variant.getDataType(o)));
        }
    }

    @Override
    public void addAll(Object[] array) {
        Object[] objectArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            if (obj != null && !(obj instanceof SerialBytes)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(mm.getMessage("pdm.arrayTypeError", mm.getMessage("DataType.SerialBytes"), Variant.getDataType(obj)));
            }
            ++n2;
        }
        int size2 = array.length;
        int size = this.size;
        this.ensureCapacity(size + size2);
        long[] datas1 = this.datas1;
        long[] datas2 = this.datas2;
        int i = 0;
        while (i < size2) {
            ++size;
            if (array[i] != null) {
                SerialBytes sb = (SerialBytes)array[i];
                datas1[size] = sb.getValue1();
                datas2[size] = sb.getValue2();
            } else {
                datas1[size] = 0L;
                datas2[size] = 0L;
            }
            ++i;
        }
        this.size = size;
    }

    @Override
    public void addAll(IArray array) {
        int size2 = array.size();
        if (size2 != 0) {
            if (array instanceof SerialBytesArray) {
                this.ensureCapacity(this.size + size2);
                SerialBytesArray sba = (SerialBytesArray)array;
                System.arraycopy(sba.datas1, 1, this.datas1, this.size + 1, size2);
                System.arraycopy(sba.datas2, 1, this.datas2, this.size + 1, size2);
                this.size += size2;
            } else {
                int size = this.size;
                this.ensureCapacity(size + size2);
                long[] datas1 = this.datas1;
                long[] datas2 = this.datas2;
                int i = 1;
                while (i <= size2) {
                    ++size;
                    Object obj = array.get(i);
                    if (obj instanceof SerialBytes) {
                        SerialBytes sb = (SerialBytes)array.get(i);
                        datas1[size] = sb.getValue1();
                        datas2[size] = sb.getValue2();
                    } else if (obj == null) {
                        datas1[size] = 0L;
                        datas2[size] = 0L;
                    } else {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException(mm.getMessage("pdm.arrayTypeError", mm.getMessage("DataType.SerialBytes"), Variant.getDataType(obj)));
                    }
                    ++i;
                }
                this.size = size;
            }
        }
    }

    @Override
    public void addAll(IArray array, int count) {
        if (count != 0) {
            if (array instanceof SerialBytesArray) {
                this.ensureCapacity(this.size + count);
                SerialBytesArray sba = (SerialBytesArray)array;
                System.arraycopy(sba.datas1, 1, this.datas1, this.size + 1, count);
                System.arraycopy(sba.datas2, 1, this.datas2, this.size + 1, count);
                this.size += count;
            } else {
                int size = this.size;
                this.ensureCapacity(size + count);
                long[] datas1 = this.datas1;
                long[] datas2 = this.datas2;
                int i = 1;
                while (i <= count) {
                    ++size;
                    Object obj = array.get(i);
                    if (obj instanceof SerialBytes) {
                        SerialBytes sb = (SerialBytes)obj;
                        datas1[size] = sb.getValue1();
                        datas2[size] = sb.getValue2();
                    } else if (obj == null) {
                        datas1[size] = 0L;
                        datas2[size] = 0L;
                    } else {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException(mm.getMessage("pdm.arrayTypeError", mm.getMessage("DataType.SerialBytes"), Variant.getDataType(obj)));
                    }
                    ++i;
                }
                this.size = size;
            }
        }
    }

    @Override
    public void addAll(IArray array, int index, int count) {
        if (array instanceof SerialBytesArray) {
            this.ensureCapacity(this.size + count);
            SerialBytesArray sba = (SerialBytesArray)array;
            System.arraycopy(sba.datas1, index, this.datas1, this.size + 1, count);
            System.arraycopy(sba.datas2, index, this.datas2, this.size + 1, count);
            this.size += count;
        } else {
            int size = this.size;
            this.ensureCapacity(size + count);
            long[] datas1 = this.datas1;
            long[] datas2 = this.datas2;
            int i = 1;
            while (i <= count) {
                ++size;
                Object obj = array.get(index);
                if (obj instanceof SerialBytes) {
                    SerialBytes sb = (SerialBytes)obj;
                    datas1[size] = sb.getValue1();
                    datas2[size] = sb.getValue2();
                } else if (obj == null) {
                    datas1[size] = 0L;
                    datas2[size] = 0L;
                } else {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(mm.getMessage("pdm.arrayTypeError", mm.getMessage("DataType.SerialBytes"), Variant.getDataType(obj)));
                }
                ++i;
                ++index;
            }
            this.size = size;
        }
    }

    @Override
    public void insert(int index, Object o) {
        if (o instanceof SerialBytes) {
            this.ensureCapacity(this.size + 1);
            ++this.size;
            System.arraycopy(this.datas1, index, this.datas1, index + 1, this.size - index);
            System.arraycopy(this.datas2, index, this.datas2, index + 1, this.size - index);
            SerialBytes sb = (SerialBytes)o;
            this.datas1[index] = sb.getValue1();
            this.datas2[index] = sb.getValue2();
        } else if (o == null) {
            this.ensureCapacity(this.size + 1);
            ++this.size;
            System.arraycopy(this.datas1, index, this.datas1, index + 1, this.size - index);
            System.arraycopy(this.datas2, index, this.datas2, index + 1, this.size - index);
            this.datas1[index] = 0L;
            this.datas2[index] = 0L;
        } else {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("pdm.arrayTypeError", mm.getMessage("DataType.Long"), Variant.getDataType(o)));
        }
    }

    public void insert(int index, long value1, long value2) {
        this.ensureCapacity(this.size + 1);
        ++this.size;
        System.arraycopy(this.datas1, index, this.datas1, index + 1, this.size - index);
        System.arraycopy(this.datas2, index, this.datas2, index + 1, this.size - index);
        this.datas1[index] = value1;
        this.datas2[index] = value2;
    }

    @Override
    public void insertAll(int pos, IArray array) {
        if (array instanceof SerialBytesArray) {
            int numNew = array.size();
            SerialBytesArray sbArray = (SerialBytesArray)array;
            this.ensureCapacity(this.size + numNew);
            System.arraycopy(this.datas1, pos, this.datas1, pos + numNew, this.size - pos + 1);
            System.arraycopy(this.datas2, pos, this.datas2, pos + numNew, this.size - pos + 1);
            System.arraycopy(sbArray.datas1, 1, this.datas1, pos, numNew);
            System.arraycopy(sbArray.datas2, 1, this.datas2, pos, numNew);
            this.size += numNew;
        } else {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("pdm.arrayTypeError", mm.getMessage("DataType.SerialBytes"), array.getDataType()));
        }
    }

    @Override
    public void insertAll(int pos, Object[] array) {
        Object[] objectArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            if (obj != null && !(obj instanceof SerialBytes)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(mm.getMessage("pdm.arrayTypeError", mm.getMessage("DataType.SerialBytes"), Variant.getDataType(obj)));
            }
            ++n2;
        }
        int numNew = array.length;
        this.ensureCapacity(this.size + numNew);
        long[] datas1 = this.datas1;
        long[] datas2 = this.datas2;
        System.arraycopy(datas1, pos, datas1, pos + numNew, this.size - pos + 1);
        System.arraycopy(datas2, pos, datas2, pos + numNew, this.size - pos + 1);
        int i = 0;
        while (i < numNew) {
            if (array[i] != null) {
                SerialBytes sb = (SerialBytes)array[i];
                datas1[pos] = sb.getValue1();
                datas2[pos] = sb.getValue2();
            } else {
                datas1[pos] = 0L;
                datas2[pos] = 0L;
            }
            ++i;
            ++pos;
        }
        this.size += numNew;
    }

    public void push(long value1, long value2) {
        ++this.size;
        this.datas1[this.size] = value1;
        this.datas2[this.size] = value1;
    }

    @Override
    public void push(Object o) {
        if (o instanceof SerialBytes) {
            ++this.size;
            SerialBytes sb = (SerialBytes)o;
            this.datas1[this.size] = sb.getValue1();
            this.datas2[this.size] = sb.getValue2();
        } else if (o == null) {
            ++this.size;
            this.datas1[this.size] = 0L;
            this.datas2[this.size] = 0L;
        } else {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("pdm.arrayTypeError", mm.getMessage("DataType.SerialBytes"), Variant.getDataType(o)));
        }
    }

    @Override
    public void pushNull() {
        ++this.size;
        this.datas1[this.size] = 0L;
        this.datas2[this.size] = 0L;
    }

    @Override
    public void push(IArray array, int index) {
        if (array instanceof SerialBytesArray) {
            SerialBytesArray sba = (SerialBytesArray)array;
            ++this.size;
            this.datas1[this.size] = sba.datas1[index];
            this.datas2[this.size] = sba.datas2[index];
        } else {
            this.push(array.get(index));
        }
    }

    @Override
    public void add(IArray array, int index) {
        if (array instanceof SerialBytesArray) {
            SerialBytesArray sba = (SerialBytesArray)array;
            this.ensureCapacity(this.size + 1);
            ++this.size;
            this.datas1[this.size] = sba.datas1[index];
            this.datas2[this.size] = sba.datas2[index];
        } else {
            this.add(array.get(index));
        }
    }

    @Override
    public void set(int curIndex, IArray array, int index) {
        if (array instanceof SerialBytesArray) {
            SerialBytesArray sba = (SerialBytesArray)array;
            this.datas1[curIndex] = sba.datas1[index];
            this.datas2[curIndex] = sba.datas2[index];
        } else {
            this.set(curIndex, array.get(index));
        }
    }

    @Override
    public Object get(int index) {
        if (this.datas1[index] != 0L || this.datas2[index] != 0L) {
            return new SerialBytes(this.datas1[index], this.datas2[index]);
        }
        return null;
    }

    @Override
    public IArray get(int[] indexArray) {
        long[] datas1 = this.datas1;
        long[] datas2 = this.datas2;
        int len = indexArray.length;
        long[] resultDatas1 = new long[len + 1];
        long[] resultDatas2 = new long[len + 1];
        int seq = 1;
        int[] nArray = indexArray;
        int n = indexArray.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            resultDatas1[seq] = datas1[i];
            resultDatas2[seq] = datas2[i];
            ++seq;
            ++n2;
        }
        return new SerialBytesArray(resultDatas1, resultDatas2, len);
    }

    @Override
    public IArray get(int[] indexArray, int start, int end, boolean doCheck) {
        long[] datas1 = this.datas1;
        long[] datas2 = this.datas2;
        int len = end - start + 1;
        long[] resultDatas1 = new long[len + 1];
        long[] resultDatas2 = new long[len + 1];
        if (doCheck) {
            int seq = 1;
            while (start <= end) {
                int index = indexArray[start];
                if (index > 0) {
                    resultDatas1[seq] = datas1[index];
                    resultDatas2[seq] = datas2[index];
                } else {
                    resultDatas1[seq] = 0L;
                    resultDatas2[seq] = 0L;
                }
                ++start;
                ++seq;
            }
        } else {
            int seq = 1;
            while (start <= end) {
                resultDatas1[seq] = datas1[indexArray[start]];
                resultDatas2[seq] = datas2[indexArray[start]];
                ++start;
                ++seq;
            }
        }
        return new SerialBytesArray(resultDatas1, resultDatas2, len);
    }

    @Override
    public IArray get(int start, int end) {
        int newSize = end - start;
        long[] newDatas1 = new long[newSize + 1];
        long[] newDatas2 = new long[newSize + 1];
        System.arraycopy(this.datas1, start, newDatas1, 1, newSize);
        System.arraycopy(this.datas2, start, newDatas2, 1, newSize);
        return new SerialBytesArray(newDatas1, newDatas2, newSize);
    }

    @Override
    public IArray get(IArray indexArray) {
        long[] datas1 = this.datas1;
        long[] datas2 = this.datas2;
        int len = indexArray.size();
        long[] resultDatas1 = new long[len + 1];
        long[] resultDatas2 = new long[len + 1];
        int i = 1;
        while (i <= len) {
            if (indexArray.isNull(i)) {
                resultDatas1[i] = 0L;
                resultDatas2[i] = 0L;
            } else {
                resultDatas1[i] = datas1[indexArray.getInt(i)];
                resultDatas2[i] = datas2[indexArray.getInt(i)];
            }
            ++i;
        }
        return new SerialBytesArray(resultDatas1, resultDatas2, len);
    }

    @Override
    public int getInt(int index) {
        throw new RuntimeException();
    }

    @Override
    public long getLong(int index) {
        throw new RuntimeException();
    }

    @Override
    public void ensureCapacity(int minCapacity) {
        int oldCapacity = this.datas1.length;
        if (oldCapacity <= minCapacity) {
            int newCapacity;
            if (minCapacity < 8) {
                newCapacity = 8;
            } else {
                newCapacity = oldCapacity + (oldCapacity >> 1);
                if (newCapacity < 0) {
                    newCapacity = oldCapacity + 0xFFFFFFF;
                    if (newCapacity < 0) {
                        newCapacity = Integer.MAX_VALUE;
                    }
                } else if (newCapacity <= minCapacity) {
                    newCapacity = minCapacity + 1;
                }
            }
            long[] newDatas1 = new long[newCapacity];
            long[] newDatas2 = new long[newCapacity];
            System.arraycopy(this.datas1, 0, newDatas1, 0, this.size + 1);
            System.arraycopy(this.datas2, 0, newDatas2, 0, this.size + 1);
            this.datas1 = newDatas1;
            this.datas2 = newDatas2;
        }
    }

    @Override
    public boolean isNull(int index) {
        return this.datas1[index] == 0L && this.datas2[index] == 0L;
    }

    @Override
    public BoolArray isTrue() {
        int size = this.size;
        long[] datas1 = this.datas1;
        long[] datas2 = this.datas2;
        boolean[] resultDatas = new boolean[size + 1];
        int i = 1;
        while (i <= size) {
            if (datas1[i] != 0L || datas2[i] != 0L) {
                resultDatas[i] = true;
            }
            ++i;
        }
        BoolArray result = new BoolArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    @Override
    public BoolArray isFalse() {
        int size = this.size;
        long[] datas1 = this.datas1;
        long[] datas2 = this.datas2;
        boolean[] resultDatas = new boolean[size + 1];
        int i = 1;
        while (i <= size) {
            if (datas1[i] == 0L && datas2[i] == 0L) {
                resultDatas[i] = true;
            }
            ++i;
        }
        BoolArray result = new BoolArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    @Override
    public boolean isTrue(int index) {
        return this.datas1[index] != 0L || this.datas2[index] != 0L;
    }

    @Override
    public boolean isFalse(int index) {
        return this.datas1[index] == 0L && this.datas2[index] == 0L;
    }

    @Override
    public boolean isTemporary() {
        return this.datas1[0] == 1L;
    }

    @Override
    public void setTemporary(boolean ifTemporary) {
        this.datas1[0] = ifTemporary ? 1 : 0;
    }

    @Override
    public void removeLast() {
        --this.size;
    }

    @Override
    public void remove(int index) {
        System.arraycopy(this.datas1, index + 1, this.datas1, index, this.size - index);
        System.arraycopy(this.datas2, index + 1, this.datas2, index, this.size - index);
        --this.size;
    }

    @Override
    public void remove(int[] seqs) {
        int delCount = 0;
        long[] datas1 = this.datas1;
        long[] datas2 = this.datas2;
        int i = 0;
        int len = seqs.length;
        while (i < len) {
            int moveCount;
            int cur = seqs[i];
            if ((moveCount = ++i < len ? seqs[i] - cur - 1 : this.size - cur) > 0) {
                System.arraycopy(datas1, cur + 1, datas1, cur - delCount, moveCount);
                System.arraycopy(datas2, cur + 1, datas2, cur - delCount, moveCount);
            }
            ++delCount;
        }
        this.size -= delCount;
    }

    @Override
    public void removeRange(int fromIndex, int toIndex) {
        System.arraycopy(this.datas1, toIndex + 1, this.datas1, fromIndex, this.size - toIndex);
        System.arraycopy(this.datas2, toIndex + 1, this.datas2, fromIndex, this.size - toIndex);
        this.size -= toIndex - fromIndex + 1;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void setSize(int size) {
        this.size = size;
    }

    @Override
    public int count() {
        int size;
        long[] datas1 = this.datas1;
        long[] datas2 = this.datas2;
        int count = size = this.size;
        int i = 1;
        while (i <= size) {
            if (datas1[i] == 0L && datas2[i] == 0L) {
                --count;
            }
            ++i;
        }
        return count;
    }

    @Override
    public boolean containTrue() {
        long[] datas1 = this.datas1;
        long[] datas2 = this.datas2;
        int size = this.size;
        int i = 1;
        while (i <= size) {
            if (datas1[i] != 0L || datas2[i] != 0L) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public Object ifn() {
        long[] datas1 = this.datas1;
        long[] datas2 = this.datas2;
        int size = this.size;
        int i = 1;
        while (i <= size) {
            if (datas1[i] != 0L || datas2[i] != 0L) {
                new SerialBytes(datas1[i], datas2[i]);
            }
            ++i;
        }
        return null;
    }

    @Override
    public void set(int index, Object obj) {
        if (obj instanceof SerialBytes) {
            SerialBytes sb = (SerialBytes)obj;
            this.datas1[index] = sb.getValue1();
            this.datas2[index] = sb.getValue2();
        } else if (obj == null) {
            this.datas1[index] = 0L;
            this.datas2[index] = 0L;
        } else {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("pdm.arrayTypeError", mm.getMessage("DataType.SerialBytes"), Variant.getDataType(obj)));
        }
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    @Override
    public int binarySearch(Object elem) {
        return this.binarySearch(elem, 1, this.size);
    }

    public int binarySearch(long value1, long value2, int start, int end) {
        long[] datas1 = this.datas1;
        long[] datas2 = this.datas2;
        int low = start;
        int high = end;
        while (low <= high) {
            int mid = low + high >> 1;
            int cmp = SerialBytes.compare(datas1[mid], datas2[mid], value1, value2);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -low;
    }

    private int descBinarySearch(long value1, long value2) {
        long[] datas1 = this.datas1;
        long[] datas2 = this.datas2;
        int low = 1;
        int high = this.size;
        while (low <= high) {
            int mid = low + high >> 1;
            int cmp = SerialBytes.compare(datas1[mid], datas2[mid], value1, value2);
            if (cmp < 0) {
                high = mid - 1;
                continue;
            }
            if (cmp > 0) {
                low = mid + 1;
                continue;
            }
            return mid;
        }
        return -low;
    }

    @Override
    public int binarySearch(Object elem, int start, int end) {
        if (elem instanceof SerialBytes) {
            SerialBytes sb = (SerialBytes)elem;
            long value1 = sb.getValue1();
            long value2 = sb.getValue2();
            long[] datas1 = this.datas1;
            long[] datas2 = this.datas2;
            int low = start;
            int high = end;
            while (low <= high) {
                int mid = low + high >> 1;
                int cmp = SerialBytes.compare(datas1[mid], datas2[mid], value1, value2);
                if (cmp < 0) {
                    low = mid + 1;
                    continue;
                }
                if (cmp > 0) {
                    high = mid - 1;
                    continue;
                }
                return mid;
            }
            return -low;
        }
        if (elem == null) {
            if (end > 0 && this.datas1[start] == 0L && this.datas1[end] == 0L) {
                return start;
            }
            return -1;
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("Variant2.illCompare", this.get(1), elem, this.getDataType(), Variant.getDataType(elem)));
    }

    public boolean contains(long value1, long value2) {
        long[] datas1 = this.datas1;
        long[] datas2 = this.datas2;
        int size = this.size;
        int i = 1;
        while (i <= size) {
            if (datas1[i] == value1 && datas2[i] == value2) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean contains(Object elem) {
        if (elem instanceof SerialBytes) {
            SerialBytes sb = (SerialBytes)elem;
            long value1 = sb.getValue1();
            long value2 = sb.getValue2();
            long[] datas1 = this.datas1;
            long[] datas2 = this.datas2;
            int size = this.size;
            int i = 1;
            while (i <= size) {
                if (datas1[i] == value1 && datas2[i] == value2) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        if (elem == null) {
            long[] datas1 = this.datas1;
            long[] datas2 = this.datas2;
            int size = this.size;
            int i = 1;
            while (i <= size) {
                if (datas1[i] == 0L && datas2[i] == 0L) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        return false;
    }

    @Override
    public void contains(boolean isSorted, IArray array, BoolArray result) {
        int resultSize = result.size();
        if (array instanceof SerialBytesArray) {
            SerialBytesArray sba = (SerialBytesArray)array;
            long[] datas1 = sba.datas1;
            long[] datas2 = sba.datas2;
            int size = this.size;
            if (isSorted) {
                int i = 1;
                while (i <= resultSize) {
                    if (result.isTrue(i) && this.binarySearch(datas1[i], datas2[i], 1, size) < 1) {
                        result.set(i, false);
                    }
                    ++i;
                }
            } else {
                int i = 1;
                while (i <= resultSize) {
                    if (result.isTrue(i) && !this.contains(datas1[i], datas2[i])) {
                        result.set(i, false);
                    }
                    ++i;
                }
            }
        } else if (isSorted) {
            int i = 1;
            while (i <= resultSize) {
                if (result.isTrue(i) && this.binarySearch(array.get(i)) < 1) {
                    result.set(i, false);
                }
                ++i;
            }
        } else {
            int i = 1;
            while (i <= resultSize) {
                if (result.isTrue(i) && !this.contains(array.get(i))) {
                    result.set(i, false);
                }
                ++i;
            }
        }
    }

    @Override
    public boolean objectContains(Object elem) {
        return false;
    }

    @Override
    public int firstIndexOf(Object elem, int start) {
        if (elem instanceof SerialBytes) {
            SerialBytes sb = (SerialBytes)elem;
            long value1 = sb.getValue1();
            long value2 = sb.getValue2();
            long[] datas1 = this.datas1;
            long[] datas2 = this.datas2;
            int size = this.size;
            int i = start;
            while (i <= size) {
                if (datas1[i] == value1 && datas2[i] == value2) {
                    return i;
                }
                ++i;
            }
            return 0;
        }
        if (elem == null) {
            long[] datas1 = this.datas1;
            long[] datas2 = this.datas2;
            int size = this.size;
            int i = start;
            while (i <= size) {
                if (datas1[i] == 0L && datas2[i] == 0L) {
                    return i;
                }
                ++i;
            }
            return 0;
        }
        return 0;
    }

    @Override
    public int lastIndexOf(Object elem, int start) {
        if (elem instanceof SerialBytes) {
            SerialBytes sb = (SerialBytes)elem;
            long value1 = sb.getValue1();
            long value2 = sb.getValue2();
            long[] datas1 = this.datas1;
            long[] datas2 = this.datas2;
            int i = start;
            while (i > 0) {
                if (datas1[i] == value1 && datas2[i] == value2) {
                    return i;
                }
                --i;
            }
            return 0;
        }
        if (elem == null) {
            long[] datas1 = this.datas1;
            long[] datas2 = this.datas2;
            int i = start;
            while (i > 0) {
                if (datas1[i] == 0L && datas2[i] == 0L) {
                    return i;
                }
                --i;
            }
            return 0;
        }
        return 0;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public IntArray indexOfAll(Object elem, int start, boolean isSorted, boolean isFromHead) {
        block28: {
            block29: {
                block30: {
                    size = this.size;
                    datas1 = this.datas1;
                    datas2 = this.datas2;
                    if (!(elem instanceof SerialBytes)) break block28;
                    sb = (SerialBytes)elem;
                    value1 = sb.getValue1();
                    value2 = sb.getValue2();
                    if (!isSorted) break block29;
                    end = size;
                    if (!isFromHead) {
                        end = start;
                        start = 1;
                    }
                    if ((index = this.binarySearch(sb, start, end)) < 1) {
                        return new IntArray(1);
                    }
                    first = index;
                    while (first > start && datas1[first - 1] == value1 && datas2[first - 1] == value2) {
                        --first;
                    }
                    last = index;
                    while (last < end && datas1[last + 1] == value1 && datas2[last + 1] == value2) {
                        ++last;
                    }
                    result = new IntArray(last - first + 1);
                    if (!isFromHead) ** GOTO lbl32
                    while (first <= last) {
                        result.pushInt(first);
                        ++first;
                    }
                    break block30;
lbl-1000:
                    // 1 sources

                    {
                        result.pushInt(last);
                        --last;
lbl32:
                        // 2 sources

                        ** while (last >= first)
                    }
                }
                return result;
            }
            result = new IntArray(7);
            if (isFromHead) {
                i = start;
                while (i <= size) {
                    if (datas1[i] == value1 && datas2[i] == value2) {
                        result.addInt(i);
                    }
                    ++i;
                }
            } else {
                i = start;
                while (i > 0) {
                    if (datas1[i] == value1 && datas2[i] == value2) {
                        result.addInt(i);
                    }
                    --i;
                }
            }
            return result;
        }
        if (elem == null) {
            result = new IntArray(7);
            if (isSorted) {
                if (isFromHead) {
                    i = start;
                    while (i <= size) {
                        if (datas1[i] == 0L && datas2[i] == 0L) {
                            result.addInt(i);
                            ++i;
                            continue;
                        }
                        break;
                    }
                } else {
                    i = start;
                    while (i > 0) {
                        if (datas1[i] == 0L && datas2[i] == 0L) {
                            result.addInt(i);
                        }
                        --i;
                    }
                }
            } else if (isFromHead) {
                i = start;
                while (i <= size) {
                    if (datas1[i] == 0L && datas2[i] == 0L) {
                        result.addInt(i);
                    }
                    ++i;
                }
            } else {
                i = start;
                while (i > 0) {
                    if (datas1[i] == 0L && datas2[i] == 0L) {
                        result.addInt(i);
                    }
                    --i;
                }
            }
            return result;
        }
        return new IntArray(1);
    }

    @Override
    public IArray dup() {
        int len = this.size + 1;
        long[] newDatas1 = new long[len];
        long[] newDatas2 = new long[len];
        System.arraycopy(this.datas1, 0, newDatas1, 0, len);
        System.arraycopy(this.datas2, 0, newDatas2, 0, len);
        return new SerialBytesArray(newDatas1, newDatas2, this.size);
    }

    @Override
    public IArray newInstance(int count) {
        return new SerialBytesArray(count);
    }

    @Override
    public IArray abs() {
        MessageManager mm = EngineMessage.get();
        throw new RuntimeException(String.valueOf(this.getDataType()) + mm.getMessage("Variant2.illAbs"));
    }

    @Override
    public IArray negate() {
        MessageManager mm = EngineMessage.get();
        throw new RuntimeException(String.valueOf(this.getDataType()) + mm.getMessage("Variant2.illNegate"));
    }

    @Override
    public IArray not() {
        long[] datas1 = this.datas1;
        long[] datas2 = this.datas2;
        int size = this.size;
        boolean[] newDatas = new boolean[size + 1];
        int i = 1;
        while (i <= size) {
            newDatas[i] = datas1[i] == 0L && datas2[i] == 0L;
            ++i;
        }
        BoolArray result = new BoolArray(newDatas, size);
        result.setTemporary(true);
        return result;
    }

    @Override
    public boolean isNumberArray() {
        return false;
    }

    @Override
    public IArray memberAdd(IArray array) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(String.valueOf(this.getDataType()) + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illAdd"));
    }

    @Override
    public IArray memberAdd(Object value) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(String.valueOf(this.getDataType()) + mm.getMessage("Variant2.with") + Variant.getDataType(value) + mm.getMessage("Variant2.illAdd"));
    }

    @Override
    public IArray memberAdd(int curIndex, IArray array, int index) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(String.valueOf(this.getDataType()) + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illAdd"));
    }

    @Override
    public IArray memberSubtract(IArray array) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(String.valueOf(this.getDataType()) + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illSubtract"));
    }

    @Override
    public IArray memberMultiply(IArray array) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(String.valueOf(this.getDataType()) + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illMultiply"));
    }

    @Override
    public IArray memberMultiply(Object value) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(String.valueOf(this.getDataType()) + mm.getMessage("Variant2.with") + Variant.getDataType(value) + mm.getMessage("Variant2.illMultiply"));
    }

    @Override
    public IArray memberDivide(IArray array) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(String.valueOf(this.getDataType()) + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illDivide"));
    }

    @Override
    public IArray memberMod(IArray array) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(String.valueOf(this.getDataType()) + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illMod"));
    }

    @Override
    public IArray memberIntDivide(IArray array) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(String.valueOf(this.getDataType()) + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illDivide"));
    }

    @Override
    public BoolArray calcRelation(IArray array, int relation) {
        if (array instanceof SerialBytesArray) {
            return this.calcRelation((SerialBytesArray)array, relation);
        }
        if (array instanceof ConstArray) {
            return this.calcRelation(array.get(1), relation);
        }
        if (array instanceof ObjectArray) {
            return this.calcRelation((ObjectArray)array, relation);
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("Variant2.illCompare", this.get(1), array.get(1), this.getDataType(), array.getDataType()));
    }

    @Override
    public BoolArray calcRelation(Object value, int relation) {
        if (value instanceof SerialBytes) {
            int i;
            int size = this.size;
            long[] datas1 = this.datas1;
            long[] datas2 = this.datas2;
            SerialBytes sb = (SerialBytes)value;
            long value1 = sb.getValue1();
            long value2 = sb.getValue2();
            boolean[] resultDatas = new boolean[size + 1];
            if (relation == 1) {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = SerialBytes.compare(datas1[i], datas2[i], value1, value2) == 0;
                    ++i;
                }
            } else if (relation == 2) {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = SerialBytes.compare(datas1[i], datas2[i], value1, value2) > 0;
                    ++i;
                }
            } else if (relation == 3) {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = SerialBytes.compare(datas1[i], datas2[i], value1, value2) >= 0;
                    ++i;
                }
            } else if (relation == 4) {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = SerialBytes.compare(datas1[i], datas2[i], value1, value2) < 0;
                    ++i;
                }
            } else if (relation == 5) {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = SerialBytes.compare(datas1[i], datas2[i], value1, value2) <= 0;
                    ++i;
                }
            } else if (relation == 6) {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = SerialBytes.compare(datas1[i], datas2[i], value1, value2) != 0;
                    ++i;
                }
            } else if (relation == 7) {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = !(datas1[i] == 0L && datas2[i] == 0L || value1 == 0L && value2 == 0L);
                    ++i;
                }
            } else {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = datas1[i] != 0L || datas2[i] != 0L || value1 != 0L || value2 != 0L;
                    ++i;
                }
            }
            BoolArray result = new BoolArray(resultDatas, size);
            result.setTemporary(true);
            return result;
        }
        if (value == null) {
            int i;
            boolean[] resultDatas = new boolean[this.size + 1];
            long[] datas1 = this.datas1;
            long[] datas2 = this.datas2;
            if (relation == 1) {
                i = 1;
                while (i <= this.size) {
                    if (datas1[i] == 0L && datas2[i] == 0L) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
            } else if (relation == 2) {
                i = 1;
                while (i <= this.size) {
                    if (datas1[i] == 0L || datas2[i] == 0L) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
            } else if (relation == 3) {
                i = 1;
                while (i <= this.size) {
                    resultDatas[i] = true;
                    ++i;
                }
            } else if (relation != 4) {
                if (relation == 5) {
                    i = 1;
                    while (i <= this.size) {
                        if (datas1[i] == 0L && datas2[i] == 0L) {
                            resultDatas[i] = true;
                        }
                        ++i;
                    }
                } else if (relation == 6) {
                    i = 1;
                    while (i <= this.size) {
                        if (datas1[i] != 0L || datas2[i] != 0L) {
                            resultDatas[i] = true;
                        }
                        ++i;
                    }
                } else if (relation == 8) {
                    i = 1;
                    while (i <= this.size) {
                        if (datas1[i] != 0L || datas2[i] != 0L) {
                            resultDatas[i] = true;
                        }
                        ++i;
                    }
                }
            }
            BoolArray result = new BoolArray(resultDatas, this.size);
            result.setTemporary(true);
            return result;
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("Variant2.illCompare", this.get(1), value, this.getDataType(), Variant.getDataType(value)));
    }

    private BoolArray calcRelation(SerialBytesArray other, int relation) {
        int i;
        int size = this.size;
        long[] datas1 = this.datas1;
        long[] datas2 = this.datas2;
        long[] otherDatas1 = other.datas1;
        long[] otherDatas2 = other.datas2;
        boolean[] resultDatas = new boolean[size + 1];
        if (relation == 1) {
            i = 1;
            while (i <= size) {
                resultDatas[i] = SerialBytes.compare(datas1[i], datas2[i], otherDatas1[i], otherDatas2[i]) == 0;
                ++i;
            }
        } else if (relation == 2) {
            i = 1;
            while (i <= size) {
                resultDatas[i] = SerialBytes.compare(datas1[i], datas2[i], otherDatas1[i], otherDatas2[i]) > 0;
                ++i;
            }
        } else if (relation == 3) {
            i = 1;
            while (i <= size) {
                resultDatas[i] = SerialBytes.compare(datas1[i], datas2[i], otherDatas1[i], otherDatas2[i]) >= 0;
                ++i;
            }
        } else if (relation == 4) {
            i = 1;
            while (i <= size) {
                resultDatas[i] = SerialBytes.compare(datas1[i], datas2[i], otherDatas1[i], otherDatas2[i]) < 0;
                ++i;
            }
        } else if (relation == 5) {
            i = 1;
            while (i <= size) {
                resultDatas[i] = SerialBytes.compare(datas1[i], datas2[i], otherDatas1[i], otherDatas2[i]) <= 0;
                ++i;
            }
        } else if (relation == 6) {
            i = 1;
            while (i <= size) {
                resultDatas[i] = SerialBytes.compare(datas1[i], datas2[i], otherDatas1[i], otherDatas2[i]) != 0;
                ++i;
            }
        } else if (relation == 7) {
            i = 1;
            while (i <= size) {
                resultDatas[i] = !(datas1[i] == 0L && datas2[i] == 0L || otherDatas1[i] == 0L && otherDatas2[i] == 0L);
                ++i;
            }
        } else {
            i = 1;
            while (i <= size) {
                resultDatas[i] = datas1[i] != 0L || datas2[i] != 0L || otherDatas1[i] != 0L || otherDatas2[i] != 0L;
                ++i;
            }
        }
        BoolArray result = new BoolArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    protected BoolArray calcRelation(ObjectArray array, int relation) {
        int i;
        int size = this.size;
        Object[] d2 = array.getDatas();
        boolean[] resultDatas = new boolean[size + 1];
        if (relation == 1) {
            i = 1;
            while (i <= size) {
                resultDatas[i] = this.compareTo(i, d2[i]) == 0;
                ++i;
            }
        } else if (relation == 2) {
            i = 1;
            while (i <= size) {
                resultDatas[i] = this.compareTo(i, d2[i]) > 0;
                ++i;
            }
        } else if (relation == 3) {
            i = 1;
            while (i <= size) {
                resultDatas[i] = this.compareTo(i, d2[i]) >= 0;
                ++i;
            }
        } else if (relation == 4) {
            i = 1;
            while (i <= size) {
                resultDatas[i] = this.compareTo(i, d2[i]) < 0;
                ++i;
            }
        } else if (relation == 5) {
            i = 1;
            while (i <= size) {
                resultDatas[i] = this.compareTo(i, d2[i]) <= 0;
                ++i;
            }
        } else if (relation == 6) {
            i = 1;
            while (i <= size) {
                resultDatas[i] = this.compareTo(i, d2[i]) != 0;
                ++i;
            }
        } else if (relation == 7) {
            i = 1;
            while (i <= size) {
                resultDatas[i] = this.isTrue(i) && Variant.isTrue(d2[i]);
                ++i;
            }
        } else {
            i = 1;
            while (i <= size) {
                resultDatas[i] = this.isTrue(i) || Variant.isTrue(d2[i]);
                ++i;
            }
        }
        BoolArray result = new BoolArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    @Override
    public void calcRelations(IArray array, int relation, BoolArray result, boolean isAnd) {
        if (array instanceof SerialBytesArray) {
            this.calcRelations((SerialBytesArray)array, relation, result, isAnd);
        } else if (array instanceof ConstArray) {
            this.calcRelations(array.get(1), relation, result, isAnd);
        } else if (array instanceof ObjectArray) {
            this.calcRelations((ObjectArray)array, relation, result, isAnd);
        } else {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("Variant2.illCompare", this.get(1), array.get(1), this.getDataType(), array.getDataType()));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void calcRelations(Object value, int relation, BoolArray result, boolean isAnd) {
        if (value instanceof SerialBytes) {
            int size = this.size;
            long[] datas1 = this.datas1;
            long[] datas2 = this.datas2;
            SerialBytes sb = (SerialBytes)value;
            long value1 = sb.getValue1();
            long value2 = sb.getValue2();
            boolean[] resultDatas = result.getDatas();
            if (isAnd) {
                if (relation == 1) {
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && SerialBytes.compare(datas1[i], datas2[i], value1, value2) != 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                    return;
                } else if (relation == 2) {
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && SerialBytes.compare(datas1[i], datas2[i], value1, value2) <= 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                    return;
                } else if (relation == 3) {
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && SerialBytes.compare(datas1[i], datas2[i], value1, value2) < 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                    return;
                } else if (relation == 4) {
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && SerialBytes.compare(datas1[i], datas2[i], value1, value2) >= 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                    return;
                } else if (relation == 5) {
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && SerialBytes.compare(datas1[i], datas2[i], value1, value2) > 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                    return;
                } else {
                    if (relation != 6) throw new RuntimeException();
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && SerialBytes.compare(datas1[i], datas2[i], value1, value2) == 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                }
                return;
            } else if (relation == 1) {
                int i = 1;
                while (i <= size) {
                    if (!resultDatas[i] && SerialBytes.compare(datas1[i], datas2[i], value1, value2) == 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
                return;
            } else if (relation == 2) {
                int i = 1;
                while (i <= size) {
                    if (!resultDatas[i] && SerialBytes.compare(datas1[i], datas2[i], value1, value2) > 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
                return;
            } else if (relation == 3) {
                int i = 1;
                while (i <= size) {
                    if (!resultDatas[i] && SerialBytes.compare(datas1[i], datas2[i], value1, value2) >= 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
                return;
            } else if (relation == 4) {
                int i = 1;
                while (i <= size) {
                    if (!resultDatas[i] && SerialBytes.compare(datas1[i], datas2[i], value1, value2) < 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
                return;
            } else if (relation == 5) {
                int i = 1;
                while (i <= size) {
                    if (!resultDatas[i] && SerialBytes.compare(datas1[i], datas2[i], value1, value2) <= 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
                return;
            } else {
                if (relation != 6) throw new RuntimeException();
                int i = 1;
                while (i <= size) {
                    if (!resultDatas[i] && SerialBytes.compare(datas1[i], datas2[i], value1, value2) != 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
            }
            return;
        } else if (value == null) {
            long[] datas1 = this.datas1;
            long[] datas2 = this.datas2;
            boolean[] resultDatas = result.getDatas();
            if (isAnd) {
                if (relation == 1) {
                    int i = 1;
                    while (i <= this.size) {
                        if (datas1[i] != 0L || datas2[i] != 0L) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                    return;
                } else if (relation == 2) {
                    int i = 1;
                    while (i <= this.size) {
                        if (datas1[i] == 0L && datas2[i] == 0L) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                    return;
                } else {
                    if (relation == 3) return;
                    if (relation == 4) {
                        int i = 1;
                        while (i <= this.size) {
                            resultDatas[i] = false;
                            ++i;
                        }
                        return;
                    } else if (relation == 5) {
                        int i = 1;
                        while (i <= this.size) {
                            if (datas1[i] != 0L || datas2[i] != 0L) {
                                resultDatas[i] = false;
                            }
                            ++i;
                        }
                        return;
                    } else {
                        if (relation != 6) throw new RuntimeException();
                        int i = 1;
                        while (i <= this.size) {
                            if (datas1[i] == 0L && datas2[i] == 0L) {
                                resultDatas[i] = false;
                            }
                            ++i;
                        }
                    }
                }
                return;
            } else if (relation == 1) {
                int i = 1;
                while (i <= this.size) {
                    if (datas1[i] == 0L && datas2[i] == 0L) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
                return;
            } else if (relation == 2) {
                int i = 1;
                while (i <= this.size) {
                    if (datas1[i] != 0L || datas2[i] != 0L) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
                return;
            } else if (relation == 3) {
                int i = 1;
                while (i <= this.size) {
                    resultDatas[i] = true;
                    ++i;
                }
                return;
            } else {
                if (relation == 4) return;
                if (relation == 5) {
                    int i = 1;
                    while (i <= this.size) {
                        if (datas1[i] == 0L && datas2[i] == 0L) {
                            resultDatas[i] = true;
                        }
                        ++i;
                    }
                    return;
                } else {
                    if (relation != 6) throw new RuntimeException();
                    int i = 1;
                    while (i <= this.size) {
                        if (datas1[i] != 0L || datas2[i] != 0L) {
                            resultDatas[i] = true;
                        }
                        ++i;
                    }
                }
            }
            return;
        } else {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("Variant2.illCompare", this.get(1), value, this.getDataType(), Variant.getDataType(value)));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void calcRelations(SerialBytesArray other, int relation, BoolArray result, boolean isAnd) {
        int size = this.size;
        long[] datas1 = this.datas1;
        long[] datas2 = this.datas2;
        long[] otherDatas1 = other.datas1;
        long[] otherDatas2 = other.datas2;
        boolean[] resultDatas = result.getDatas();
        if (isAnd) {
            if (relation == 1) {
                int i = 1;
                while (i <= size) {
                    if (resultDatas[i] && SerialBytes.compare(datas1[i], datas2[i], otherDatas1[i], otherDatas2[i]) != 0) {
                        resultDatas[i] = false;
                    }
                    ++i;
                }
                return;
            } else if (relation == 2) {
                int i = 1;
                while (i <= size) {
                    if (resultDatas[i] && SerialBytes.compare(datas1[i], datas2[i], otherDatas1[i], otherDatas2[i]) <= 0) {
                        resultDatas[i] = false;
                    }
                    ++i;
                }
                return;
            } else if (relation == 3) {
                int i = 1;
                while (i <= size) {
                    if (resultDatas[i] && SerialBytes.compare(datas1[i], datas2[i], otherDatas1[i], otherDatas2[i]) < 0) {
                        resultDatas[i] = false;
                    }
                    ++i;
                }
                return;
            } else if (relation == 4) {
                int i = 1;
                while (i <= size) {
                    if (resultDatas[i] && SerialBytes.compare(datas1[i], datas2[i], otherDatas1[i], otherDatas2[i]) >= 0) {
                        resultDatas[i] = false;
                    }
                    ++i;
                }
                return;
            } else if (relation == 5) {
                int i = 1;
                while (i <= size) {
                    if (resultDatas[i] && SerialBytes.compare(datas1[i], datas2[i], otherDatas1[i], otherDatas2[i]) > 0) {
                        resultDatas[i] = false;
                    }
                    ++i;
                }
                return;
            } else {
                if (relation != 6) throw new RuntimeException();
                int i = 1;
                while (i <= size) {
                    if (resultDatas[i] && SerialBytes.compare(datas1[i], datas2[i], otherDatas1[i], otherDatas2[i]) == 0) {
                        resultDatas[i] = false;
                    }
                    ++i;
                }
            }
            return;
        } else if (relation == 1) {
            int i = 1;
            while (i <= size) {
                if (!resultDatas[i] && SerialBytes.compare(datas1[i], datas2[i], otherDatas1[i], otherDatas2[i]) == 0) {
                    resultDatas[i] = true;
                }
                ++i;
            }
            return;
        } else if (relation == 2) {
            int i = 1;
            while (i <= size) {
                if (!resultDatas[i] && SerialBytes.compare(datas1[i], datas2[i], otherDatas1[i], otherDatas2[i]) > 0) {
                    resultDatas[i] = true;
                }
                ++i;
            }
            return;
        } else if (relation == 3) {
            int i = 1;
            while (i <= size) {
                if (!resultDatas[i] && SerialBytes.compare(datas1[i], datas2[i], otherDatas1[i], otherDatas2[i]) >= 0) {
                    resultDatas[i] = true;
                }
                ++i;
            }
            return;
        } else if (relation == 4) {
            int i = 1;
            while (i <= size) {
                if (!resultDatas[i] && SerialBytes.compare(datas1[i], datas2[i], otherDatas1[i], otherDatas2[i]) < 0) {
                    resultDatas[i] = true;
                }
                ++i;
            }
            return;
        } else if (relation == 5) {
            int i = 1;
            while (i <= size) {
                if (!resultDatas[i] && SerialBytes.compare(datas1[i], datas2[i], otherDatas1[i], otherDatas2[i]) <= 0) {
                    resultDatas[i] = true;
                }
                ++i;
            }
            return;
        } else {
            if (relation != 6) throw new RuntimeException();
            int i = 1;
            while (i <= size) {
                if (!resultDatas[i] && SerialBytes.compare(datas1[i], datas2[i], otherDatas1[i], otherDatas2[i]) != 0) {
                    resultDatas[i] = true;
                }
                ++i;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void calcRelations(ObjectArray array, int relation, BoolArray result, boolean isAnd) {
        int size = this.size;
        Object[] d2 = array.getDatas();
        boolean[] resultDatas = result.getDatas();
        if (isAnd) {
            if (relation == 1) {
                int i = 1;
                while (i <= size) {
                    if (resultDatas[i] && this.compareTo(i, d2[i]) != 0) {
                        resultDatas[i] = false;
                    }
                    ++i;
                }
                return;
            } else if (relation == 2) {
                int i = 1;
                while (i <= size) {
                    if (resultDatas[i] && this.compareTo(i, d2[i]) <= 0) {
                        resultDatas[i] = false;
                    }
                    ++i;
                }
                return;
            } else if (relation == 3) {
                int i = 1;
                while (i <= size) {
                    if (resultDatas[i] && this.compareTo(i, d2[i]) < 0) {
                        resultDatas[i] = false;
                    }
                    ++i;
                }
                return;
            } else if (relation == 4) {
                int i = 1;
                while (i <= size) {
                    if (resultDatas[i] && this.compareTo(i, d2[i]) >= 0) {
                        resultDatas[i] = false;
                    }
                    ++i;
                }
                return;
            } else if (relation == 5) {
                int i = 1;
                while (i <= size) {
                    if (resultDatas[i] && this.compareTo(i, d2[i]) > 0) {
                        resultDatas[i] = false;
                    }
                    ++i;
                }
                return;
            } else {
                if (relation != 6) throw new RuntimeException();
                int i = 1;
                while (i <= size) {
                    if (resultDatas[i] && this.compareTo(i, d2[i]) == 0) {
                        resultDatas[i] = false;
                    }
                    ++i;
                }
            }
            return;
        } else if (relation == 1) {
            int i = 1;
            while (i <= size) {
                if (!resultDatas[i] && this.compareTo(i, d2[i]) == 0) {
                    resultDatas[i] = true;
                }
                ++i;
            }
            return;
        } else if (relation == 2) {
            int i = 1;
            while (i <= size) {
                if (!resultDatas[i] && this.compareTo(i, d2[i]) > 0) {
                    resultDatas[i] = true;
                }
                ++i;
            }
            return;
        } else if (relation == 3) {
            int i = 1;
            while (i <= size) {
                if (!resultDatas[i] && this.compareTo(i, d2[i]) >= 0) {
                    resultDatas[i] = true;
                }
                ++i;
            }
            return;
        } else if (relation == 4) {
            int i = 1;
            while (i <= size) {
                if (!resultDatas[i] && this.compareTo(i, d2[i]) < 0) {
                    resultDatas[i] = true;
                }
                ++i;
            }
            return;
        } else if (relation == 5) {
            int i = 1;
            while (i <= size) {
                if (!resultDatas[i] && this.compareTo(i, d2[i]) <= 0) {
                    resultDatas[i] = true;
                }
                ++i;
            }
            return;
        } else {
            if (relation != 6) throw new RuntimeException();
            int i = 1;
            while (i <= size) {
                if (!resultDatas[i] && this.compareTo(i, d2[i]) != 0) {
                    resultDatas[i] = true;
                }
                ++i;
            }
        }
    }

    @Override
    public IArray bitwiseAnd(IArray array) {
        MessageManager mm = EngineMessage.get();
        throw new RQException("and" + mm.getMessage("function.paramTypeError"));
    }

    @Override
    public IArray bitwiseOr(IArray array) {
        MessageManager mm = EngineMessage.get();
        throw new RQException("or" + mm.getMessage("function.paramTypeError"));
    }

    @Override
    public IArray bitwiseXOr(IArray array) {
        MessageManager mm = EngineMessage.get();
        throw new RQException("xor" + mm.getMessage("function.paramTypeError"));
    }

    @Override
    public IArray bitwiseNot() {
        MessageManager mm = EngineMessage.get();
        throw new RQException("not" + mm.getMessage("function.paramTypeError"));
    }

    @Override
    public int memberCompare(int index1, int index2) {
        return SerialBytes.compare(this.datas1[index1], this.datas2[index1], this.datas1[index2], this.datas2[index2]);
    }

    @Override
    public boolean isMemberEquals(int index1, int index2) {
        return this.datas1[index1] == this.datas1[index2] && this.datas2[index1] == this.datas2[index2];
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public int compareTo(IArray array) {
        block18: {
            block17: {
                size1 = this.size;
                size2 = array.size();
                datas1 = this.datas1;
                datas2 = this.datas2;
                size = size1;
                result = 0;
                if (size1 < size2) {
                    result = -1;
                } else if (size1 > size2) {
                    result = 1;
                    size = size2;
                }
                if (!(array instanceof SerialBytesArray)) break block17;
                other = (SerialBytesArray)array;
                otherDatas1 = other.datas1;
                otherDatas2 = other.datas2;
                i = 1;
                while (i <= size) {
                    cmp = SerialBytes.compare(datas1[i], datas2[i], otherDatas1[i], otherDatas2[i]);
                    if (cmp != 0) {
                        return cmp;
                    }
                    ++i;
                }
                break block18;
            }
            if (!(array instanceof ConstArray)) ** GOTO lbl50
            value = array.get(1);
            if (value instanceof SerialBytes) {
                sb = (SerialBytes)value;
                value1 = sb.getValue1();
                value2 = sb.getValue2();
                i = 1;
                while (i <= size) {
                    cmp = SerialBytes.compare(datas1[i], datas2[i], value1, value2);
                    if (cmp != 0) {
                        return cmp;
                    }
                    ++i;
                }
            } else if (value == null) {
                i = 1;
                while (i <= size) {
                    if (datas1[i] != 0L || datas2[i] != 0L) {
                        return 1;
                    }
                    ++i;
                }
            } else {
                mm = EngineMessage.get();
                throw new RQException(mm.getMessage("Variant2.illCompare", this.get(1), value, this.getDataType(), array.getDataType()));
lbl50:
                // 1 sources

                if (array instanceof ObjectArray) {
                    array2 = (ObjectArray)array;
                    d2 = array2.getDatas();
                    i = 1;
                    while (i <= size) {
                        cmp = this.compareTo(i, d2[i]);
                        if (cmp != 0) {
                            return cmp;
                        }
                        ++i;
                    }
                } else {
                    mm = EngineMessage.get();
                    throw new RQException(mm.getMessage("Variant2.illCompare", this.get(1), array.get(1), this.getDataType(), array.getDataType()));
                }
            }
        }
        return result;
    }

    @Override
    public int hashCode(int index) {
        return HashUtil.hashCode(this.datas1[index] + this.datas2[index]);
    }

    @Override
    public Object sum() {
        return null;
    }

    @Override
    public Object average() {
        return null;
    }

    @Override
    public Object max() {
        int size = this.size;
        if (size == 0) {
            return null;
        }
        long[] datas1 = this.datas1;
        long[] datas2 = this.datas2;
        long max1 = datas1[1];
        long max2 = datas2[1];
        int i = 2;
        while (i <= size) {
            if (SerialBytes.compare(max1, max2, datas1[i], datas2[i]) < 0) {
                max1 = datas1[i];
                max2 = datas2[i];
            }
            ++i;
        }
        if (max1 != 0L || max2 != 0L) {
            return new SerialBytes(max1, max2);
        }
        return null;
    }

    @Override
    public Object min() {
        int size = this.size;
        if (size == 0) {
            return null;
        }
        long[] datas1 = this.datas1;
        long[] datas2 = this.datas2;
        long min1 = 0L;
        long min2 = 0L;
        int i = 1;
        while (i <= size) {
            if (datas1[i] != 0L || datas2[i] != 0L) {
                min1 = datas1[i];
                min2 = datas2[i];
                break;
            }
            ++i;
        }
        ++i;
        while (i <= size) {
            if ((datas1[i] != 0L || datas2[i] != 0L) && SerialBytes.compare(min1, min2, datas1[i], datas2[i]) > 0) {
                min1 = datas1[i];
                min2 = datas2[i];
            }
            ++i;
        }
        if (min1 != 0L || min2 != 0L) {
            return new SerialBytes(min1, min2);
        }
        return null;
    }

    @Override
    public void reserve(int start, int end) {
        int newSize = end - start + 1;
        System.arraycopy(this.datas1, start, this.datas1, 1, newSize);
        System.arraycopy(this.datas2, start, this.datas2, 1, newSize);
        this.size = newSize;
    }

    @Override
    public Object[] toArray() {
        int size = this.size;
        long[] datas1 = this.datas1;
        long[] datas2 = this.datas2;
        Object[] result = new Object[size];
        int i = 1;
        while (i <= size) {
            if (datas1[i] != 0L || datas2[i] != 0L) {
                result[i - 1] = new SerialBytes(datas1[i], datas2[i]);
            }
            ++i;
        }
        return result;
    }

    @Override
    public void toArray(Object[] result) {
        int size = this.size;
        long[] datas1 = this.datas1;
        long[] datas2 = this.datas2;
        int i = 1;
        while (i <= size) {
            result[i - 1] = datas1[i] != 0L || datas2[i] != 0L ? new SerialBytes(datas1[i], datas2[i]) : null;
            ++i;
        }
    }

    @Override
    public IArray split(int pos) {
        long[] datas1 = this.datas1;
        long[] datas2 = this.datas2;
        int size = this.size;
        int resultSize = size - pos + 1;
        long[] resultDatas1 = new long[resultSize + 1];
        long[] resultDatas2 = new long[resultSize + 1];
        System.arraycopy(datas1, pos, resultDatas1, 1, resultSize);
        System.arraycopy(datas2, pos, resultDatas2, 1, resultSize);
        this.size = pos - 1;
        return new SerialBytesArray(resultDatas1, resultDatas2, resultSize);
    }

    @Override
    public IArray split(int from, int to) {
        int oldSize = this.size;
        long[] datas1 = this.datas1;
        long[] datas2 = this.datas2;
        int resultSize = to - from + 1;
        long[] resultDatas1 = new long[resultSize + 1];
        long[] resultDatas2 = new long[resultSize + 1];
        System.arraycopy(datas1, from, resultDatas1, 1, resultSize);
        System.arraycopy(datas2, from, resultDatas2, 1, resultSize);
        System.arraycopy(datas1, to + 1, datas1, from, oldSize - to);
        System.arraycopy(datas2, to + 1, datas2, from, oldSize - to);
        this.size -= resultSize;
        return new SerialBytesArray(resultDatas1, resultDatas2, resultSize);
    }

    @Override
    public void trimToSize() {
        int newLen = this.size + 1;
        if (newLen < this.datas1.length) {
            long[] newDatas1 = new long[newLen];
            long[] newDatas2 = new long[newLen];
            System.arraycopy(this.datas1, 0, newDatas1, 0, newLen);
            System.arraycopy(this.datas2, 0, newDatas2, 0, newLen);
            this.datas1 = newDatas1;
            this.datas2 = newDatas2;
        }
    }

    @Override
    public IArray select(IArray signArray) {
        int size = signArray.size();
        long[] datas1 = this.datas1;
        long[] datas2 = this.datas2;
        long[] newDatas1 = new long[size + 1];
        long[] newDatas2 = new long[size + 1];
        int count = 0;
        if (signArray instanceof BoolArray) {
            BoolArray array = (BoolArray)signArray;
            boolean[] d2 = array.getDatas();
            boolean[] s2 = array.getSigns();
            if (s2 == null) {
                int i = 1;
                while (i <= size) {
                    if (d2[i]) {
                        newDatas1[++count] = datas1[i];
                        newDatas2[count] = datas2[i];
                    }
                    ++i;
                }
            } else {
                int i = 1;
                while (i <= size) {
                    if (!s2[i] && d2[i]) {
                        newDatas1[++count] = datas1[i];
                        newDatas2[count] = datas2[i];
                    }
                    ++i;
                }
            }
        } else {
            int i = 1;
            while (i <= size) {
                if (signArray.isTrue(i)) {
                    newDatas1[++count] = datas1[i];
                    newDatas2[count] = datas2[i];
                }
                ++i;
            }
        }
        return new SerialBytesArray(newDatas1, newDatas2, count);
    }

    @Override
    public IArray select(int start, int end, IArray signArray) {
        long[] datas1 = this.datas1;
        long[] datas2 = this.datas2;
        long[] newDatas1 = new long[end - start + 1];
        long[] newDatas2 = new long[end - start + 1];
        int count = 0;
        if (signArray instanceof BoolArray) {
            BoolArray array = (BoolArray)signArray;
            boolean[] d2 = array.getDatas();
            boolean[] s2 = array.getSigns();
            if (s2 == null) {
                int i = start;
                while (i < end) {
                    if (d2[i]) {
                        newDatas1[++count] = datas1[i];
                        newDatas2[count] = datas2[i];
                    }
                    ++i;
                }
            } else {
                int i = start;
                while (i < end) {
                    if (!s2[i] && d2[i]) {
                        newDatas1[++count] = datas1[i];
                        newDatas2[count] = datas2[i];
                    }
                    ++i;
                }
            }
        } else {
            int i = start;
            while (i < end) {
                if (signArray.isTrue(i)) {
                    newDatas1[++count] = datas1[i];
                    newDatas2[count] = datas2[i];
                }
                ++i;
            }
        }
        return new SerialBytesArray(newDatas1, newDatas2, count);
    }

    @Override
    public boolean isEquals(int curIndex, IArray array, int index) {
        if (array instanceof SerialBytesArray) {
            SerialBytesArray sba = (SerialBytesArray)array;
            return this.datas1[curIndex] == sba.datas1[index] && this.datas2[curIndex] == sba.datas2[index];
        }
        return this.isEquals(curIndex, array.get(index));
    }

    @Override
    public boolean isEquals(int curIndex, Object value) {
        if (value instanceof SerialBytes) {
            SerialBytes sb = (SerialBytes)value;
            return this.datas1[curIndex] == sb.getValue1() && this.datas2[curIndex] == sb.getValue2();
        }
        if (value == null) {
            return this.datas1[curIndex] == 0L && this.datas2[curIndex] == 0L;
        }
        return false;
    }

    @Override
    public int compareTo(int curIndex, IArray array, int index) {
        if (array instanceof SerialBytesArray) {
            SerialBytesArray sba = (SerialBytesArray)array;
            return SerialBytes.compare(this.datas1[curIndex], this.datas2[curIndex], sba.datas1[index], sba.datas2[index]);
        }
        return this.compareTo(curIndex, array.get(index));
    }

    @Override
    public int compareTo(int curIndex, Object value) {
        if (value instanceof SerialBytes) {
            SerialBytes sb = (SerialBytes)value;
            return SerialBytes.compare(this.datas1[curIndex], this.datas2[curIndex], sb.getValue1(), sb.getValue2());
        }
        if (value == null) {
            return this.datas1[curIndex] != 0L || this.datas2[curIndex] != 0L ? 1 : 0;
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("Variant2.illCompare", this.get(curIndex), value, mm.getMessage("DataType.SerialBytes"), Variant.getDataType(value)));
    }

    @Override
    public void sort() {
        Object[] sbs = new SerialBytes[this.size];
        this.toArray(sbs);
        MultithreadUtil.sort(sbs);
        int i = 0;
        long[] datas1 = this.datas1;
        long[] datas2 = this.datas2;
        Object[] objectArray = sbs;
        int n = sbs.length;
        int n2 = 0;
        while (n2 < n) {
            Object sb = objectArray[n2];
            ++i;
            if (sb == null) {
                datas1[i] = 0L;
                datas2[i] = 0L;
            } else {
                datas1[i] = ((SerialBytes)sb).getValue1();
                datas2[i] = ((SerialBytes)sb).getValue2();
            }
            ++n2;
        }
    }

    @Override
    public void sort(Comparator<Object> comparator) {
        Object[] sbs = new SerialBytes[this.size];
        this.toArray(sbs);
        MultithreadUtil.sort(sbs, comparator);
        int i = 0;
        long[] datas1 = this.datas1;
        long[] datas2 = this.datas2;
        Object[] objectArray = sbs;
        int n = sbs.length;
        int n2 = 0;
        while (n2 < n) {
            Object sb = objectArray[n2];
            ++i;
            if (sb == null) {
                datas1[i] = 0L;
                datas2[i] = 0L;
            } else {
                datas1[i] = ((SerialBytes)sb).getValue1();
                datas2[i] = ((SerialBytes)sb).getValue2();
            }
            ++n2;
        }
    }

    @Override
    public boolean hasRecord() {
        return false;
    }

    @Override
    public boolean isPmt(boolean isPure) {
        return false;
    }

    @Override
    public IArray rvs() {
        int size = this.size;
        long[] datas1 = this.datas1;
        long[] datas2 = this.datas2;
        long[] resultDatas1 = new long[size + 1];
        long[] resultDatas2 = new long[size + 1];
        int i = 1;
        int q = size;
        while (i <= size) {
            resultDatas1[i] = datas1[q];
            resultDatas2[i] = datas2[q];
            ++i;
            --q;
        }
        return new SerialBytesArray(resultDatas1, resultDatas2, size);
    }

    @Override
    public IntArray ptop(int count, boolean isAll, boolean isLast, boolean ignoreNull) {
        int size = this.size;
        if (size == 0) {
            return new IntArray(0);
        }
        long[] datas1 = this.datas1;
        long[] datas2 = this.datas2;
        if (ignoreNull) {
            if (count == 1) {
                long minValue1 = 0L;
                long minValue2 = 0L;
                if (isAll) {
                    IntArray result = new IntArray(8);
                    int i = 1;
                    while (i <= size) {
                        if (datas1[i] != 0L || datas2[i] != 0L) {
                            minValue1 = datas1[i];
                            minValue2 = datas2[i];
                            result.addInt(i);
                            break;
                        }
                        ++i;
                    }
                    ++i;
                    while (i <= size) {
                        if (datas1[i] != 0L || datas2[i] != 0L) {
                            int cmp = SerialBytes.compare(datas1[i], datas2[i], minValue1, minValue2);
                            if (cmp < 0) {
                                minValue1 = datas1[i];
                                minValue2 = datas2[i];
                                result.clear();
                                result.addInt(i);
                            } else if (cmp == 0) {
                                result.addInt(i);
                            }
                        }
                        ++i;
                    }
                    return result;
                }
                if (isLast) {
                    int i = size;
                    int pos = 0;
                    while (i > 0) {
                        if (datas1[i] != 0L || datas2[i] != 0L) {
                            minValue1 = datas1[i];
                            minValue2 = datas2[i];
                            pos = i;
                            break;
                        }
                        --i;
                    }
                    --i;
                    while (i > 0) {
                        if ((datas1[i] != 0L || datas2[i] != 0L) && SerialBytes.compare(datas1[i], datas2[i], minValue1, minValue2) < 0) {
                            minValue1 = datas1[i];
                            minValue2 = datas2[i];
                            pos = i;
                        }
                        --i;
                    }
                    IntArray result = new IntArray(1);
                    if (pos != 0) {
                        result.pushInt(pos);
                    }
                    return result;
                }
                int i = 1;
                int pos = 0;
                while (i <= size) {
                    if (datas1[i] != 0L || datas2[i] != 0L) {
                        minValue1 = datas1[i];
                        minValue2 = datas2[i];
                        pos = i;
                        break;
                    }
                    ++i;
                }
                ++i;
                while (i <= size) {
                    if ((datas1[i] != 0L || datas2[i] != 0L) && SerialBytes.compare(datas1[i], datas2[i], minValue1, minValue2) < 0) {
                        minValue1 = datas1[i];
                        minValue2 = datas2[i];
                        pos = i;
                    }
                    ++i;
                }
                IntArray result = new IntArray(1);
                if (pos != 0) {
                    result.pushInt(pos);
                }
                return result;
            }
            if (count > 1) {
                int next = count + 1;
                SerialBytesArray valueArray = new SerialBytesArray(next);
                IntArray posArray = new IntArray(next);
                int i = 1;
                while (i <= size) {
                    if (datas1[i] != 0L || datas2[i] != 0L) {
                        int index = valueArray.binarySearch(datas1[i], datas2[i], 1, valueArray.size);
                        if (index < 1) {
                            index = -index;
                        }
                        if (index <= count) {
                            valueArray.insert(index, datas1[i], datas2[i]);
                            posArray.insertInt(index, i);
                            if (valueArray.size() == next) {
                                valueArray.removeLast();
                                posArray.removeLast();
                            }
                        }
                    }
                    ++i;
                }
                return posArray;
            }
            if (count == -1) {
                long maxValue1 = 0L;
                long maxValue2 = 0L;
                if (isAll) {
                    IntArray result = new IntArray(8);
                    int i = 1;
                    while (i <= size) {
                        if (datas1[i] != 0L || datas2[i] != 0L) {
                            maxValue1 = datas1[i];
                            maxValue2 = datas2[i];
                            result.addInt(i);
                            break;
                        }
                        ++i;
                    }
                    ++i;
                    while (i <= size) {
                        if (datas1[i] != 0L || datas2[i] != 0L) {
                            int cmp = SerialBytes.compare(datas1[i], datas2[i], maxValue1, maxValue2);
                            if (cmp > 0) {
                                maxValue1 = datas1[i];
                                maxValue2 = datas2[i];
                                result.clear();
                                result.addInt(i);
                            } else if (cmp == 0) {
                                result.addInt(i);
                            }
                        }
                        ++i;
                    }
                    return result;
                }
                if (isLast) {
                    int i = size;
                    int pos = 0;
                    while (i > 0) {
                        if (datas1[i] != 0L || datas2[i] != 0L) {
                            maxValue1 = datas1[i];
                            maxValue2 = datas2[i];
                            pos = i;
                            break;
                        }
                        --i;
                    }
                    --i;
                    while (i > 0) {
                        if ((datas1[i] != 0L || datas2[i] != 0L) && SerialBytes.compare(datas1[i], datas2[i], maxValue1, maxValue2) > 0) {
                            maxValue1 = datas1[i];
                            maxValue2 = datas2[i];
                            pos = i;
                        }
                        --i;
                    }
                    IntArray result = new IntArray(1);
                    if (pos != 0) {
                        result.pushInt(pos);
                    }
                    return result;
                }
                int i = 1;
                int pos = 0;
                while (i <= size) {
                    if (datas1[i] != 0L || datas2[i] != 0L) {
                        maxValue1 = datas1[i];
                        maxValue2 = datas2[i];
                        pos = i;
                        break;
                    }
                    ++i;
                }
                ++i;
                while (i <= size) {
                    if ((datas1[i] != 0L || datas2[i] != 0L) && SerialBytes.compare(datas1[i], datas2[i], maxValue1, maxValue2) > 0) {
                        maxValue1 = datas1[i];
                        maxValue2 = datas2[i];
                        pos = i;
                    }
                    ++i;
                }
                IntArray result = new IntArray(1);
                if (pos != 0) {
                    result.pushInt(pos);
                }
                return result;
            }
            if (count < -1) {
                count = -count;
                int next = count + 1;
                SerialBytesArray valueArray = new SerialBytesArray(next);
                IntArray posArray = new IntArray(next);
                int i = 1;
                while (i <= size) {
                    if (datas1[i] != 0L || datas2[i] != 0L) {
                        int index = valueArray.descBinarySearch(datas1[i], datas2[i]);
                        if (index < 1) {
                            index = -index;
                        }
                        if (index <= count) {
                            valueArray.insert(index, datas1[i], datas2[i]);
                            posArray.insertInt(index, i);
                            if (valueArray.size() == next) {
                                valueArray.remove(next);
                                posArray.remove(next);
                            }
                        }
                    }
                    ++i;
                }
                return posArray;
            }
            return new IntArray(1);
        }
        if (count == 1) {
            if (isAll) {
                IntArray result = new IntArray(8);
                result.addInt(1);
                long minValue1 = datas1[1];
                long minValue2 = datas2[1];
                int i = 2;
                while (i <= size) {
                    int cmp = SerialBytes.compare(datas1[i], datas2[i], minValue1, minValue2);
                    if (cmp < 0) {
                        minValue1 = datas1[i];
                        minValue2 = datas2[i];
                        result.clear();
                        result.addInt(i);
                    } else if (cmp == 0) {
                        result.addInt(i);
                    }
                    ++i;
                }
                return result;
            }
            if (isLast) {
                long minValue1 = datas1[size];
                long minValue2 = datas2[size];
                int pos = size;
                int i = size - 1;
                while (i > 0) {
                    if (SerialBytes.compare(datas1[i], datas2[i], minValue1, minValue2) < 0) {
                        minValue1 = datas1[i];
                        minValue2 = datas2[i];
                        pos = i;
                    }
                    --i;
                }
                IntArray result = new IntArray(1);
                result.pushInt(pos);
                return result;
            }
            long minValue1 = datas1[1];
            long minValue2 = datas2[1];
            int pos = 1;
            int i = 2;
            while (i <= size) {
                if (SerialBytes.compare(datas1[i], datas2[i], minValue1, minValue2) < 0) {
                    minValue1 = datas1[i];
                    minValue2 = datas2[i];
                    pos = i;
                }
                ++i;
            }
            IntArray result = new IntArray(1);
            result.pushInt(pos);
            return result;
        }
        if (count > 1) {
            int next = count + 1;
            SerialBytesArray valueArray = new SerialBytesArray(next);
            IntArray posArray = new IntArray(next);
            int i = 1;
            while (i <= size) {
                int index = valueArray.binarySearch(datas1[i], datas2[i], 1, valueArray.size);
                if (index < 1) {
                    index = -index;
                }
                if (index <= count) {
                    valueArray.insert(index, datas1[i], datas2[i]);
                    posArray.insertInt(index, i);
                    if (valueArray.size() == next) {
                        valueArray.removeLast();
                        posArray.removeLast();
                    }
                }
                ++i;
            }
            return posArray;
        }
        if (count == -1) {
            if (isAll) {
                IntArray result = new IntArray(8);
                long maxValue1 = datas1[1];
                long maxValue2 = datas2[1];
                result.addInt(1);
                int i = 2;
                while (i <= size) {
                    int cmp = SerialBytes.compare(datas1[i], datas2[i], maxValue1, maxValue2);
                    if (cmp > 0) {
                        maxValue1 = datas1[i];
                        maxValue2 = datas2[i];
                        result.clear();
                        result.addInt(i);
                    } else if (cmp == 0) {
                        result.addInt(i);
                    }
                    ++i;
                }
                return result;
            }
            if (isLast) {
                long maxValue1 = datas1[size];
                long maxValue2 = datas2[size];
                int pos = size;
                int i = size - 1;
                while (i > 0) {
                    if (SerialBytes.compare(datas1[i], datas2[i], maxValue1, maxValue2) > 0) {
                        maxValue1 = datas1[i];
                        maxValue2 = datas2[i];
                        pos = i;
                    }
                    --i;
                }
                IntArray result = new IntArray(1);
                result.pushInt(pos);
                return result;
            }
            long maxValue1 = datas1[1];
            long maxValue2 = datas2[1];
            int pos = 1;
            int i = 2;
            while (i <= size) {
                if (SerialBytes.compare(datas1[i], datas2[i], maxValue1, maxValue2) > 0) {
                    maxValue1 = datas1[i];
                    maxValue2 = datas2[i];
                    pos = i;
                }
                ++i;
            }
            IntArray result = new IntArray(1);
            result.pushInt(pos);
            return result;
        }
        if (count < -1) {
            count = -count;
            int next = count + 1;
            SerialBytesArray valueArray = new SerialBytesArray(next);
            IntArray posArray = new IntArray(next);
            int i = 1;
            while (i <= size) {
                int index = valueArray.descBinarySearch(datas1[i], datas2[i]);
                if (index < 1) {
                    index = -index;
                }
                if (index <= count) {
                    valueArray.insert(index, datas1[i], datas2[i]);
                    posArray.insertInt(index, i);
                    if (valueArray.size() == next) {
                        valueArray.remove(next);
                        posArray.remove(next);
                    }
                }
                ++i;
            }
            return posArray;
        }
        return new IntArray(1);
    }

    @Override
    public IntArray ptopRank(int count, boolean ignoreNull, boolean iopt) {
        throw new RuntimeException();
    }

    @Override
    public ObjectArray toObjectArray() {
        int size = this.size;
        long[] datas1 = this.datas1;
        long[] datas2 = this.datas2;
        Object[] resultDatas = new Object[size + 1];
        int i = 1;
        while (i <= size) {
            if (datas1[i] != 0L || datas2[i] != 0L) {
                resultDatas[i] = new SerialBytes(datas1[i], datas2[i]);
            }
            ++i;
        }
        return new ObjectArray(resultDatas, size);
    }

    @Override
    public IArray toPureArray() {
        return this;
    }

    @Override
    public IArray reserve(boolean refOrigin) {
        if (this.isTemporary()) {
            this.setTemporary(false);
            return this;
        }
        if (refOrigin) {
            return this;
        }
        return this.dup();
    }

    @Override
    public IArray combine(IArray signArray, IArray other) {
        if (other instanceof ConstArray) {
            return this.combine(signArray, ((ConstArray)other).getData());
        }
        int size = this.size;
        long[] datas1 = this.datas1;
        long[] datas2 = this.datas2;
        if (other instanceof SerialBytesArray) {
            SerialBytesArray sba = (SerialBytesArray)other;
            long[] otherDatas1 = sba.datas1;
            long[] otherDatas2 = sba.datas2;
            if (this.isTemporary()) {
                int i = 1;
                while (i <= size) {
                    if (signArray.isFalse(i)) {
                        datas1[i] = otherDatas1[i];
                        datas2[i] = otherDatas2[i];
                    }
                    ++i;
                }
                return this;
            }
            long[] resultDatas1 = new long[size + 1];
            long[] resultDatas2 = new long[size + 1];
            System.arraycopy(datas1, 1, resultDatas1, 1, size);
            System.arraycopy(datas2, 1, resultDatas2, 1, size);
            int i = 1;
            while (i <= size) {
                if (signArray.isFalse(i)) {
                    resultDatas1[i] = otherDatas1[i];
                    resultDatas2[i] = otherDatas2[i];
                }
                ++i;
            }
            SerialBytesArray result = new SerialBytesArray(resultDatas1, resultDatas2, size);
            result.setTemporary(true);
            return result;
        }
        Object[] resultDatas = new Object[size + 1];
        int i = 1;
        while (i <= size) {
            resultDatas[i] = signArray.isFalse(i) ? other.get(i) : this.get(i);
            ++i;
        }
        ObjectArray result = new ObjectArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    @Override
    public IArray combine(IArray signArray, Object value) {
        int size = this.size;
        long[] datas1 = this.datas1;
        long[] datas2 = this.datas2;
        if (value instanceof SerialBytes || value == null) {
            long value1 = 0L;
            long value2 = 0L;
            if (value != null) {
                SerialBytes sb = (SerialBytes)value;
                value1 = sb.getValue1();
                value2 = sb.getValue2();
            }
            if (this.isTemporary()) {
                int i = 1;
                while (i <= size) {
                    if (signArray.isFalse(i)) {
                        datas1[i] = value1;
                        datas2[i] = value2;
                    }
                    ++i;
                }
                return this;
            }
            long[] resultDatas1 = new long[size + 1];
            long[] resultDatas2 = new long[size + 1];
            System.arraycopy(datas1, 1, resultDatas1, 1, size);
            System.arraycopy(datas2, 1, resultDatas2, 1, size);
            int i = 1;
            while (i <= size) {
                if (signArray.isFalse(i)) {
                    resultDatas1[i] = value1;
                    resultDatas2[i] = value2;
                }
                ++i;
            }
            SerialBytesArray result = new SerialBytesArray(resultDatas1, resultDatas2, size);
            result.setTemporary(true);
            return result;
        }
        Object[] resultDatas = new Object[size + 1];
        int i = 1;
        while (i <= size) {
            resultDatas[i] = signArray.isFalse(i) ? value : this.get(i);
            ++i;
        }
        ObjectArray result = new ObjectArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    public long[] getDatas1() {
        return this.datas1;
    }

    public long[] getDatas2() {
        return this.datas2;
    }

    public long getData1(int index) {
        return this.datas1[index];
    }

    public long getData2(int index) {
        return this.datas2[index];
    }

    @Override
    public Object pos(IArray array, String opt) {
        return ArrayUtil.pos(this, array, opt);
    }

    @Override
    public int bit1() {
        MessageManager mm = EngineMessage.get();
        throw new RQException("bit1" + mm.getMessage("function.paramTypeError"));
    }

    @Override
    public int bit1(IArray array) {
        MessageManager mm = EngineMessage.get();
        throw new RQException("bit1" + mm.getMessage("function.paramTypeError"));
    }

    @Override
    public int getNextEqualCount(int index) {
        long[] datas1 = this.datas1;
        long[] datas2 = this.datas2;
        int size = this.size;
        int count = 1;
        long value1 = datas1[index];
        long value2 = datas2[index];
        ++index;
        while (index <= size) {
            if (datas1[index] != value1 || datas2[index] != value2) break;
            ++count;
            ++index;
        }
        return count;
    }
}

