/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.array;

import com.scudata.array.ArrayUtil;
import com.scudata.array.BoolArray;
import com.scudata.array.ConstArray;
import com.scudata.array.DateArray;
import com.scudata.array.DoubleArray;
import com.scudata.array.IArray;
import com.scudata.array.IntArray;
import com.scudata.array.LongArray;
import com.scudata.array.NumberArray;
import com.scudata.array.ObjectArray;
import com.scudata.common.ByteArrayInputRecord;
import com.scudata.common.ByteArrayOutputRecord;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.expression.Relation;
import com.scudata.resources.EngineMessage;
import com.scudata.thread.MultithreadUtil;
import com.scudata.util.Variant;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Comparator;

public class StringArray
implements IArray {
    private static final long serialVersionUID = 1L;
    private static String TEMP = new String("");
    private String[] datas;
    private int size;

    public StringArray() {
        this.datas = new String[8];
    }

    public StringArray(int initialCapacity) {
        this.datas = new String[++initialCapacity];
    }

    public StringArray(String[] datas, int size) {
        this.datas = datas;
        this.size = size;
    }

    public static boolean isEquals(String d1, String d2) {
        if (d1 == d2) {
            return true;
        }
        if (d1 == null) {
            return false;
        }
        if (d2 == null) {
            return false;
        }
        return d1.equals(d2);
    }

    public static int compare(String d1, String d2) {
        if (d1 == null) {
            return d2 == null ? 0 : -1;
        }
        if (d2 == null) {
            return 1;
        }
        int cmp = d1.compareTo(d2);
        return cmp < 0 ? -1 : (cmp > 0 ? 1 : 0);
    }

    private static int compare(String d1, Object d2) {
        if (d2 instanceof String) {
            if (d1 == null) {
                return -1;
            }
            int cmp = d1.compareTo((String)d2);
            return cmp < 0 ? -1 : (cmp > 0 ? 1 : 0);
        }
        if (d2 == null) {
            return d1 == null ? 0 : 1;
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("Variant2.illCompare", d1, d2, mm.getMessage("DataType.String"), Variant.getDataType(d2)));
    }

    public String[] getDatas() {
        return this.datas;
    }

    @Override
    public String getDataType() {
        MessageManager mm = EngineMessage.get();
        return mm.getMessage("DataType.String");
    }

    @Override
    public IArray dup() {
        int len = this.size + 1;
        String[] newDatas = new String[len];
        System.arraycopy(this.datas, 0, newDatas, 0, len);
        return new StringArray(newDatas, this.size);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        int size = this.size;
        String[] datas = this.datas;
        out.writeByte(1);
        out.writeInt(size);
        int i = 1;
        while (i <= size) {
            out.writeObject(datas[i]);
            ++i;
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        in.readByte();
        this.size = in.readInt();
        int len = this.size + 1;
        this.datas = new String[len];
        String[] datas = this.datas;
        int i = 1;
        while (i < len) {
            datas[i] = (String)in.readObject();
            ++i;
        }
    }

    @Override
    public byte[] serialize() throws IOException {
        ByteArrayOutputRecord out = new ByteArrayOutputRecord();
        int size = this.size;
        String[] datas = this.datas;
        out.writeByte(1);
        out.writeInt(size);
        int i = 1;
        while (i <= size) {
            out.writeString(datas[i]);
            ++i;
        }
        return out.toByteArray();
    }

    @Override
    public void fillRecord(byte[] buf) throws IOException, ClassNotFoundException {
        ByteArrayInputRecord in = new ByteArrayInputRecord(buf);
        in.readByte();
        this.size = in.readInt();
        int len = this.size + 1;
        this.datas = new String[len];
        String[] datas = this.datas;
        int i = 1;
        while (i < len) {
            datas[i] = in.readString();
            ++i;
        }
    }

    @Override
    public IArray newInstance(int count) {
        return new StringArray(count);
    }

    @Override
    public void add(Object o) {
        if (o instanceof String) {
            this.ensureCapacity(this.size + 1);
            this.datas[++this.size] = (String)o;
        } else if (o == null) {
            this.ensureCapacity(this.size + 1);
            this.datas[++this.size] = null;
        } else {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("pdm.arrayTypeError", mm.getMessage("DataType.String"), Variant.getDataType(o)));
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void addAll(IArray array) {
        block11: {
            block12: {
                size2 = array.size();
                if (size2 == 0) break block11;
                if (!(array instanceof StringArray)) break block12;
                stringArray = (StringArray)array;
                this.ensureCapacity(this.size + size2);
                System.arraycopy(stringArray.datas, 1, this.datas, this.size + 1, size2);
                this.size += size2;
                break block11;
            }
            if (!(array instanceof ConstArray)) ** GOTO lbl33
            obj = array.get(1);
            if (obj instanceof String) {
                this.ensureCapacity(this.size + size2);
                v = (String)obj;
                datas = this.datas;
                i = 0;
                while (i < size2) {
                    datas[++this.size] = v;
                    ++i;
                }
            } else if (obj == null) {
                this.ensureCapacity(this.size + size2);
                datas = this.datas;
                i = 0;
                while (i < size2) {
                    datas[++this.size] = null;
                    ++i;
                }
            } else {
                mm = EngineMessage.get();
                throw new RQException(mm.getMessage("pdm.arrayTypeError", mm.getMessage("DataType.String"), array.getDataType()));
lbl33:
                // 1 sources

                this.ensureCapacity(this.size + size2);
                datas = this.datas;
                i = 1;
                while (i <= size2) {
                    obj = array.get(i);
                    if (obj instanceof String) {
                        datas[++this.size] = (String)obj;
                    } else if (obj == null) {
                        datas[++this.size] = null;
                    } else {
                        mm = EngineMessage.get();
                        throw new RQException(mm.getMessage("pdm.arrayTypeError", mm.getMessage("DataType.String"), Variant.getDataType(obj)));
                    }
                    ++i;
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void addAll(IArray array, int count) {
        block11: {
            block12: {
                if (count == 0) break block11;
                if (!(array instanceof StringArray)) break block12;
                stringArray = (StringArray)array;
                this.ensureCapacity(this.size + count);
                System.arraycopy(stringArray.datas, 1, this.datas, this.size + 1, count);
                this.size += count;
                break block11;
            }
            if (!(array instanceof ConstArray)) ** GOTO lbl32
            obj = array.get(1);
            if (obj instanceof String) {
                this.ensureCapacity(this.size + count);
                v = (String)obj;
                datas = this.datas;
                i = 0;
                while (i < count) {
                    datas[++this.size] = v;
                    ++i;
                }
            } else if (obj == null) {
                this.ensureCapacity(this.size + count);
                datas = this.datas;
                i = 0;
                while (i < count) {
                    datas[++this.size] = null;
                    ++i;
                }
            } else {
                mm = EngineMessage.get();
                throw new RQException(mm.getMessage("pdm.arrayTypeError", mm.getMessage("DataType.String"), array.getDataType()));
lbl32:
                // 1 sources

                this.ensureCapacity(this.size + count);
                datas = this.datas;
                i = 1;
                while (i <= count) {
                    obj = array.get(i);
                    if (obj instanceof String) {
                        datas[++this.size] = (String)obj;
                    } else if (obj == null) {
                        datas[++this.size] = null;
                    } else {
                        mm = EngineMessage.get();
                        throw new RQException(mm.getMessage("pdm.arrayTypeError", mm.getMessage("DataType.String"), Variant.getDataType(obj)));
                    }
                    ++i;
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void addAll(IArray array, int index, int count) {
        block7: {
            block6: {
                if (!(array instanceof StringArray)) break block6;
                stringArray = (StringArray)array;
                this.ensureCapacity(this.size + count);
                System.arraycopy(stringArray.datas, index, this.datas, this.size + 1, count);
                this.size += count;
                break block7;
            }
            if (!(array instanceof ConstArray)) ** GOTO lbl31
            obj = array.get(1);
            if (obj instanceof String) {
                this.ensureCapacity(this.size + count);
                v = (String)obj;
                datas = this.datas;
                i = 0;
                while (i < count) {
                    datas[++this.size] = v;
                    ++i;
                }
            } else if (obj == null) {
                this.ensureCapacity(this.size + count);
                datas = this.datas;
                i = 0;
                while (i < count) {
                    datas[++this.size] = null;
                    ++i;
                }
            } else {
                mm = EngineMessage.get();
                throw new RQException(mm.getMessage("pdm.arrayTypeError", mm.getMessage("DataType.String"), array.getDataType()));
lbl31:
                // 1 sources

                mm = EngineMessage.get();
                throw new RQException(mm.getMessage("pdm.arrayTypeError", mm.getMessage("DataType.String"), array.getDataType()));
            }
        }
    }

    @Override
    public void addAll(Object[] array) {
        Object[] objectArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            if (obj != null && !(obj instanceof String)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(mm.getMessage("pdm.arrayTypeError", mm.getMessage("DataType.String"), Variant.getDataType(obj)));
            }
            ++n2;
        }
        int size2 = array.length;
        this.ensureCapacity(this.size + size2);
        String[] datas = this.datas;
        int i = 0;
        while (i < size2) {
            datas[++this.size] = (String)array[i];
            ++i;
        }
    }

    @Override
    public void insert(int index, Object o) {
        if (o instanceof String) {
            this.ensureCapacity(this.size + 1);
            ++this.size;
            System.arraycopy(this.datas, index, this.datas, index + 1, this.size - index);
            this.datas[index] = (String)o;
        } else if (o == null) {
            this.ensureCapacity(this.size + 1);
            ++this.size;
            System.arraycopy(this.datas, index, this.datas, index + 1, this.size - index);
            this.datas[index] = null;
        } else {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("pdm.arrayTypeError", mm.getMessage("DataType.String"), Variant.getDataType(o)));
        }
    }

    @Override
    public void insertAll(int pos, IArray array) {
        if (array instanceof StringArray) {
            int numNew = array.size();
            StringArray stringArray = (StringArray)array;
            this.ensureCapacity(this.size + numNew);
            System.arraycopy(this.datas, pos, this.datas, pos + numNew, this.size - pos + 1);
            System.arraycopy(stringArray.datas, 1, this.datas, pos, numNew);
            this.size += numNew;
        } else {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("pdm.arrayTypeError", mm.getMessage("DataType.String"), array.getDataType()));
        }
    }

    @Override
    public void insertAll(int pos, Object[] array) {
        Object[] objectArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            if (obj != null && !(obj instanceof String)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(mm.getMessage("pdm.arrayTypeError", mm.getMessage("DataType.String"), Variant.getDataType(obj)));
            }
            ++n2;
        }
        int numNew = array.length;
        this.ensureCapacity(this.size + numNew);
        System.arraycopy(this.datas, pos, this.datas, pos + numNew, this.size - pos + 1);
        System.arraycopy(array, 0, this.datas, pos, numNew);
        this.size += numNew;
    }

    public void push(String str) {
        this.datas[++this.size] = str;
    }

    public void pushString(String str) {
        this.datas[++this.size] = str;
    }

    @Override
    public void push(Object o) {
        if (o instanceof String) {
            this.datas[++this.size] = (String)o;
        } else if (o == null) {
            this.datas[++this.size] = null;
        } else {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("pdm.arrayTypeError", mm.getMessage("DataType.String"), Variant.getDataType(o)));
        }
    }

    @Override
    public void pushNull() {
        this.datas[++this.size] = null;
    }

    @Override
    public void push(IArray array, int index) {
        this.push(array.get(index));
    }

    @Override
    public void add(IArray array, int index) {
        this.add(array.get(index));
    }

    @Override
    public void set(int curIndex, IArray array, int index) {
        this.set(curIndex, array.get(index));
    }

    @Override
    public Object get(int index) {
        return this.datas[index];
    }

    public String getString(int index) {
        return this.datas[index];
    }

    @Override
    public int getInt(int index) {
        throw new RuntimeException();
    }

    @Override
    public long getLong(int index) {
        throw new RuntimeException();
    }

    @Override
    public IArray get(int[] indexArray) {
        String[] datas = this.datas;
        int len = indexArray.length;
        StringArray result = new StringArray(len);
        int[] nArray = indexArray;
        int n = indexArray.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            result.pushString(datas[i]);
            ++n2;
        }
        return result;
    }

    @Override
    public IArray get(int[] indexArray, int start, int end, boolean doCheck) {
        String[] datas = this.datas;
        int len = end - start + 1;
        String[] resultDatas = new String[len + 1];
        if (doCheck) {
            int i = 1;
            while (start <= end) {
                int q = indexArray[start];
                if (q > 0) {
                    resultDatas[i] = datas[q];
                }
                ++start;
                ++i;
            }
        } else {
            int i = 1;
            while (start <= end) {
                resultDatas[i++] = datas[indexArray[start]];
                ++start;
            }
        }
        return new StringArray(resultDatas, len);
    }

    @Override
    public IArray get(IArray indexArray) {
        String[] datas = this.datas;
        int len = indexArray.size();
        StringArray result = new StringArray(len);
        int i = 1;
        while (i <= len) {
            if (indexArray.isNull(i)) {
                result.pushNull();
            } else {
                result.pushString(datas[indexArray.getInt(i)]);
            }
            ++i;
        }
        return result;
    }

    @Override
    public IArray get(int start, int end) {
        int newSize = end - start;
        String[] newDatas = new String[newSize + 1];
        System.arraycopy(this.datas, start, newDatas, 1, newSize);
        return new StringArray(newDatas, newSize);
    }

    @Override
    public void ensureCapacity(int minCapacity) {
        int oldCapacity = this.datas.length;
        if (oldCapacity <= minCapacity) {
            int newCapacity;
            if (minCapacity < 8) {
                newCapacity = 8;
            } else {
                newCapacity = oldCapacity + (oldCapacity >> 1);
                if (newCapacity < 0) {
                    newCapacity = oldCapacity + 0xFFFFFFF;
                    if (newCapacity < 0) {
                        newCapacity = Integer.MAX_VALUE;
                    }
                } else if (newCapacity <= minCapacity) {
                    newCapacity = minCapacity + 1;
                }
            }
            String[] newDatas = new String[newCapacity];
            System.arraycopy(this.datas, 0, newDatas, 0, this.size + 1);
            this.datas = newDatas;
        }
    }

    @Override
    public void trimToSize() {
        int newLen = this.size + 1;
        if (newLen < this.datas.length) {
            String[] newDatas = new String[newLen];
            System.arraycopy(this.datas, 0, newDatas, 0, newLen);
            this.datas = newDatas;
        }
    }

    @Override
    public boolean isNull(int index) {
        return this.datas[index] == null;
    }

    @Override
    public BoolArray isTrue() {
        int size = this.size;
        String[] datas = this.datas;
        boolean[] resultDatas = new boolean[size + 1];
        int i = 1;
        while (i <= size) {
            resultDatas[i] = datas[i] != null;
            ++i;
        }
        BoolArray result = new BoolArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    @Override
    public BoolArray isFalse() {
        int size = this.size;
        String[] datas = this.datas;
        boolean[] resultDatas = new boolean[size + 1];
        int i = 1;
        while (i <= size) {
            resultDatas[i] = datas[i] == null;
            ++i;
        }
        BoolArray result = new BoolArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    @Override
    public boolean isTrue(int index) {
        return this.datas[index] != null;
    }

    @Override
    public boolean isFalse(int index) {
        return this.datas[index] == null;
    }

    @Override
    public boolean isTemporary() {
        return this.datas[0] != null;
    }

    @Override
    public void setTemporary(boolean ifTemporary) {
        this.datas[0] = ifTemporary ? TEMP : null;
    }

    @Override
    public void removeLast() {
        this.datas[this.size--] = null;
    }

    @Override
    public void remove(int index) {
        System.arraycopy(this.datas, index + 1, this.datas, index, this.size - index);
        this.datas[this.size--] = null;
    }

    @Override
    public void removeRange(int fromIndex, int toIndex) {
        System.arraycopy(this.datas, toIndex + 1, this.datas, fromIndex, this.size - toIndex);
        int newSize = this.size - (toIndex - fromIndex + 1);
        while (this.size != newSize) {
            this.datas[this.size--] = null;
        }
    }

    @Override
    public void remove(int[] seqs) {
        int delCount = 0;
        String[] datas = this.datas;
        int i = 0;
        int len = seqs.length;
        while (i < len) {
            int moveCount;
            int cur = seqs[i];
            if ((moveCount = ++i < len ? seqs[i] - cur - 1 : this.size - cur) > 0) {
                System.arraycopy(datas, cur + 1, datas, cur - delCount, moveCount);
            }
            ++delCount;
        }
        i = 0;
        int q = this.size;
        while (i < delCount) {
            datas[q - i] = null;
            ++i;
        }
        this.size -= delCount;
    }

    @Override
    public void reserve(int start, int end) {
        int newSize = end - start + 1;
        System.arraycopy(this.datas, start, this.datas, 1, newSize);
        int i = this.size;
        while (i > newSize) {
            this.datas[i] = null;
            --i;
        }
        this.size = newSize;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public int count() {
        int size;
        String[] datas = this.datas;
        int count = size = this.size;
        int i = 1;
        while (i <= size) {
            if (datas[i] == null) {
                --count;
            }
            ++i;
        }
        return count;
    }

    @Override
    public boolean containTrue() {
        int size = this.size;
        if (size == 0) {
            return false;
        }
        String[] datas = this.datas;
        int i = 1;
        while (i <= size) {
            if (datas[i] != null) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public Object ifn() {
        int size = this.size;
        String[] datas = this.datas;
        int i = 1;
        while (i <= size) {
            if (datas[i] != null) {
                return datas[i];
            }
            ++i;
        }
        return null;
    }

    @Override
    public void set(int index, Object obj) {
        if (obj instanceof String) {
            this.datas[index] = (String)obj;
        } else if (obj == null) {
            this.datas[index] = null;
        } else {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("pdm.arrayTypeError", mm.getMessage("DataType.String"), Variant.getDataType(obj)));
        }
    }

    @Override
    public void clear() {
        String[] datas = this.datas;
        int size = this.size;
        this.size = 0;
        while (size > 0) {
            datas[size--] = null;
        }
    }

    @Override
    public int binarySearch(Object elem) {
        if (elem instanceof String) {
            String v = (String)elem;
            String[] datas = this.datas;
            int low = 1;
            int high = this.size;
            while (low <= high) {
                int mid = low + high >> 1;
                int cmp = StringArray.compare(datas[mid], v);
                if (cmp < 0) {
                    low = mid + 1;
                    continue;
                }
                if (cmp > 0) {
                    high = mid - 1;
                    continue;
                }
                return mid;
            }
            return -low;
        }
        if (elem == null) {
            if (this.size > 0 && this.datas[1] == null) {
                return 1;
            }
            return -1;
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("Variant2.illCompare", this.datas[1], elem, this.getDataType(), Variant.getDataType(elem)));
    }

    private int descBinarySearch(String elem) {
        String[] datas = this.datas;
        int low = 1;
        int high = this.size;
        while (low <= high) {
            int mid = low + high >> 1;
            int cmp = StringArray.compare(datas[mid], elem);
            if (cmp < 0) {
                high = mid - 1;
                continue;
            }
            if (cmp > 0) {
                low = mid + 1;
                continue;
            }
            return mid;
        }
        return -low;
    }

    @Override
    public int binarySearch(Object elem, int start, int end) {
        if (elem instanceof String) {
            String v = (String)elem;
            String[] datas = this.datas;
            int low = start;
            int high = end;
            while (low <= high) {
                int mid = low + high >> 1;
                int cmp = StringArray.compare(datas[mid], v);
                if (cmp < 0) {
                    low = mid + 1;
                    continue;
                }
                if (cmp > 0) {
                    high = mid - 1;
                    continue;
                }
                return mid;
            }
            return -low;
        }
        if (elem == null) {
            if (end > 0 && this.datas[start] == null) {
                return start;
            }
            return -1;
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("Variant2.illCompare", this.datas[1], elem, this.getDataType(), Variant.getDataType(elem)));
    }

    @Override
    public boolean contains(Object elem) {
        if (elem instanceof String) {
            String v = (String)elem;
            String[] datas = this.datas;
            int size = this.size;
            int i = 1;
            while (i <= size) {
                if (datas[i] != null && datas[i].equals(v)) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        if (elem == null) {
            int size = this.size;
            String[] datas = this.datas;
            int i = 1;
            while (i <= size) {
                if (datas[i] == null) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        return false;
    }

    @Override
    public void contains(boolean isSorted, IArray array, BoolArray result) {
        int resultSize = result.size();
        if (isSorted) {
            int i = 1;
            while (i <= resultSize) {
                if (result.isTrue(i) && this.binarySearch(array.get(i)) < 1) {
                    result.set(i, false);
                }
                ++i;
            }
        } else {
            int i = 1;
            while (i <= resultSize) {
                if (result.isTrue(i) && !this.contains(array.get(i))) {
                    result.set(i, false);
                }
                ++i;
            }
        }
    }

    @Override
    public boolean objectContains(Object elem) {
        String[] datas = this.datas;
        int i = 1;
        int size = this.size;
        while (i <= size) {
            if (datas[i] == elem) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public int firstIndexOf(Object elem, int start) {
        if (elem instanceof String) {
            String v = (String)elem;
            String[] datas = this.datas;
            int size = this.size;
            int i = start;
            while (i <= size) {
                if (datas[i] != null && datas[i].equals(v)) {
                    return i;
                }
                ++i;
            }
            return 0;
        }
        if (elem == null) {
            int size = this.size;
            String[] datas = this.datas;
            int i = start;
            while (i <= size) {
                if (datas[i] == null) {
                    return i;
                }
                ++i;
            }
            return 0;
        }
        return 0;
    }

    @Override
    public int lastIndexOf(Object elem, int start) {
        if (elem instanceof String) {
            String v = (String)elem;
            String[] datas = this.datas;
            int i = start;
            while (i > 0) {
                if (datas[i] != null && datas[i].equals(v)) {
                    return i;
                }
                --i;
            }
            return 0;
        }
        if (elem == null) {
            String[] datas = this.datas;
            int i = start;
            while (i > 0) {
                if (datas[i] == null) {
                    return i;
                }
                --i;
            }
            return 0;
        }
        return 0;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public IntArray indexOfAll(Object elem, int start, boolean isSorted, boolean isFromHead) {
        block29: {
            block30: {
                size = this.size;
                datas = this.datas;
                if (elem == null) {
                    result = new IntArray(7);
                    if (isSorted) {
                        if (isFromHead) {
                            i = start;
                            while (i <= size) {
                                if (datas[i] == null) {
                                    result.addInt(i);
                                    ++i;
                                    continue;
                                }
                                break;
                            }
                        } else {
                            i = start;
                            while (i > 0) {
                                if (datas[i] == null) {
                                    result.addInt(i);
                                }
                                --i;
                            }
                        }
                    } else if (isFromHead) {
                        i = start;
                        while (i <= size) {
                            if (datas[i] == null) {
                                result.addInt(i);
                            }
                            ++i;
                        }
                    } else {
                        i = start;
                        while (i > 0) {
                            if (datas[i] == null) {
                                result.addInt(i);
                            }
                            --i;
                        }
                    }
                    return result;
                }
                if (!(elem instanceof String)) {
                    return new IntArray(1);
                }
                str = (String)elem;
                if (!isSorted) break block29;
                end = size;
                if (!isFromHead) {
                    end = start;
                    start = 1;
                }
                if ((index = this.binarySearch(str, start, end)) < 1) {
                    return new IntArray(1);
                }
                first = index;
                while (first > start && StringArray.compare(datas[first - 1], str) == 0) {
                    --first;
                }
                last = index;
                while (last < end && StringArray.compare(datas[last + 1], str) == 0) {
                    ++last;
                }
                result = new IntArray(last - first + 1);
                if (!isFromHead) ** GOTO lbl65
                while (first <= last) {
                    result.pushInt(first);
                    ++first;
                }
                break block30;
lbl-1000:
                // 1 sources

                {
                    result.pushInt(last);
                    --last;
lbl65:
                    // 2 sources

                    ** while (last >= first)
                }
            }
            return result;
        }
        result = new IntArray(7);
        if (isFromHead) {
            i = start;
            while (i <= size) {
                if (StringArray.compare(datas[i], str) == 0) {
                    result.addInt(i);
                }
                ++i;
            }
        } else {
            i = start;
            while (i > 0) {
                if (StringArray.compare(datas[i], str) == 0) {
                    result.addInt(i);
                }
                --i;
            }
        }
        return result;
    }

    @Override
    public IArray abs() {
        MessageManager mm = EngineMessage.get();
        throw new RuntimeException(String.valueOf(this.getDataType()) + mm.getMessage("Variant2.illAbs"));
    }

    @Override
    public IArray negate() {
        int size = this.size;
        String[] datas = this.datas;
        if (this.isTemporary()) {
            int i = 1;
            while (i <= size) {
                if (datas[i] != null) {
                    datas[i] = Variant.negate(datas[i]);
                }
                ++i;
            }
            return this;
        }
        String[] newDatas = new String[size + 1];
        int i = 1;
        while (i <= size) {
            if (datas[i] != null) {
                newDatas[i] = Variant.negate(datas[i]);
            }
            ++i;
        }
        StringArray result = new StringArray(newDatas, size);
        result.setTemporary(true);
        return result;
    }

    @Override
    public IArray not() {
        String[] datas = this.datas;
        int size = this.size;
        boolean[] newDatas = new boolean[size + 1];
        int i = 1;
        while (i <= size) {
            newDatas[i] = datas[i] == null;
            ++i;
        }
        BoolArray result = new BoolArray(newDatas, size);
        result.setTemporary(true);
        return result;
    }

    @Override
    public boolean isNumberArray() {
        return false;
    }

    @Override
    public IArray memberAdd(IArray array) {
        if (array instanceof StringArray) {
            return this.memberAdd((StringArray)array);
        }
        if (array instanceof ConstArray) {
            return this.memberAdd(array.get(1));
        }
        if (array instanceof ObjectArray) {
            int size = this.size;
            String[] d1 = this.datas;
            Object[] d2 = ((ObjectArray)array).getDatas();
            Object[] resultDatas = new Object[size + 1];
            int i = 1;
            while (i <= size) {
                resultDatas[i] = Variant.add(d1[i], d2[i]);
                ++i;
            }
            ObjectArray result = new ObjectArray(resultDatas, size);
            result.setTemporary(true);
            return result;
        }
        if (array instanceof NumberArray) {
            return this.memberAdd((NumberArray)array);
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(String.valueOf(this.getDataType()) + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illAdd"));
    }

    @Override
    public IArray memberAdd(Object value) {
        if (value == null) {
            return this;
        }
        int size = this.size;
        String[] datas = this.datas;
        if (value instanceof String) {
            String str = (String)value;
            if (this.isTemporary()) {
                int i = 1;
                while (i <= size) {
                    if (datas[i] != null) {
                        int n = i;
                        datas[n] = String.valueOf(datas[n]) + str;
                    } else {
                        datas[i] = str;
                    }
                    ++i;
                }
                return this;
            }
            String[] newDatas = new String[size + 1];
            int i = 1;
            while (i <= size) {
                newDatas[i] = datas[i] != null ? String.valueOf(datas[i]) + str : str;
                ++i;
            }
            StringArray result = new StringArray(newDatas, size);
            result.setTemporary(true);
            return result;
        }
        if (value instanceof Number) {
            Number n2 = (Number)value;
            Object[] resultDatas = new Object[size + 1];
            int i = 1;
            while (i <= size) {
                Number n1;
                resultDatas[i] = datas[i] != null ? (Number)((n1 = Variant.parseNumber(datas[i])) == null ? (Number)n2 : (Number)Variant.addNum(n1, n2)) : (Number)n2;
                ++i;
            }
            ObjectArray result = new ObjectArray(resultDatas, size);
            result.setTemporary(true);
            return result;
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(String.valueOf(this.getDataType()) + mm.getMessage("Variant2.with") + Variant.getDataType(value) + mm.getMessage("Variant2.illAdd"));
    }

    private StringArray memberAdd(StringArray array) {
        StringArray result;
        String[] newDatas;
        int size = this.size;
        String[] d1 = this.datas;
        String[] d2 = array.datas;
        if (this.isTemporary()) {
            newDatas = d1;
            result = this;
        } else if (array.isTemporary()) {
            newDatas = d2;
            result = array;
        } else {
            newDatas = new String[size + 1];
            result = new StringArray(newDatas, size);
        }
        int i = 1;
        while (i <= size) {
            newDatas[i] = d1[i] != null ? (d2[i] != null ? String.valueOf(d1[i]) + d2[i] : d1[i]) : d2[i];
            ++i;
        }
        return result;
    }

    public ObjectArray memberAdd(NumberArray array) {
        int size = this.size;
        String[] datas = this.datas;
        Object[] resultDatas = new Object[size + 1];
        int i = 1;
        while (i <= size) {
            Number n1;
            resultDatas[i] = datas[i] != null ? ((n1 = Variant.parseNumber(datas[i])) == null ? array.get(i) : Variant.addNum(n1, (Number)array.get(i))) : array.get(i);
            ++i;
        }
        ObjectArray result = new ObjectArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    @Override
    public IArray memberSubtract(IArray array) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(String.valueOf(this.getDataType()) + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illSubtract"));
    }

    @Override
    public IArray memberMultiply(IArray array) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(String.valueOf(this.getDataType()) + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illMultiply"));
    }

    @Override
    public IArray memberMultiply(Object value) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(String.valueOf(this.getDataType()) + mm.getMessage("Variant2.with") + Variant.getDataType(value) + mm.getMessage("Variant2.illMultiply"));
    }

    @Override
    public IArray memberDivide(IArray array) {
        if (array instanceof StringArray) {
            return this.memberDivide((StringArray)array);
        }
        if (array instanceof IntArray) {
            return this.memberDivide((IntArray)array);
        }
        if (array instanceof LongArray) {
            return this.memberDivide((LongArray)array);
        }
        if (array instanceof DoubleArray) {
            return this.memberDivide((DoubleArray)array);
        }
        if (array instanceof ConstArray) {
            return this.memberDivide(array.get(1));
        }
        if (array instanceof BoolArray) {
            return this.memberDivide((BoolArray)array);
        }
        int size = this.size;
        String[] datas = this.datas;
        if (this.isTemporary()) {
            int i = 1;
            while (i <= size) {
                if (!array.isNull(i)) {
                    if (datas[i] != null) {
                        int n = i;
                        datas[n] = String.valueOf(datas[n]) + array.get(i);
                    } else {
                        datas[i] = array.get(i).toString();
                    }
                }
                ++i;
            }
            return this;
        }
        String[] resultDatas = new String[size + 1];
        int i = 1;
        while (i <= size) {
            if (datas[i] != null) {
                resultDatas[i] = !array.isNull(i) ? String.valueOf(datas[i]) + array.get(i) : datas[i];
            } else if (!array.isNull(i)) {
                resultDatas[i] = array.get(i).toString();
            }
            ++i;
        }
        StringArray result = new StringArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    private StringArray memberDivide(Object value) {
        if (value == null) {
            return this;
        }
        String str = value.toString();
        int size = this.size;
        String[] datas = this.datas;
        if (this.isTemporary()) {
            int i = 1;
            while (i <= size) {
                if (datas[i] != null) {
                    int n = i;
                    datas[n] = String.valueOf(datas[n]) + str;
                } else {
                    datas[i] = str;
                }
                ++i;
            }
            return this;
        }
        String[] resultDatas = new String[size + 1];
        int i = 1;
        while (i <= size) {
            resultDatas[i] = datas[i] != null ? String.valueOf(datas[i]) + str : str;
            ++i;
        }
        StringArray result = new StringArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    private StringArray memberDivide(StringArray array) {
        int size = this.size;
        String[] d1 = this.datas;
        String[] d2 = array.datas;
        if (this.isTemporary()) {
            int i = 1;
            while (i <= size) {
                if (d2[i] != null) {
                    if (d1[i] != null) {
                        int n = i;
                        d1[n] = String.valueOf(d1[n]) + d2[i];
                    } else {
                        d1[i] = d2[i];
                    }
                }
                ++i;
            }
            return this;
        }
        if (array.isTemporary()) {
            int i = 1;
            while (i <= size) {
                if (d1[i] != null) {
                    d2[i] = d2[i] != null ? String.valueOf(d1[i]) + d2[i] : d1[i];
                }
                ++i;
            }
            return array;
        }
        String[] resultDatas = new String[size + 1];
        int i = 1;
        while (i <= size) {
            resultDatas[i] = d1[i] != null ? (d2[i] != null ? String.valueOf(d1[i]) + d2[i] : d1[i]) : d2[i];
            ++i;
        }
        StringArray result = new StringArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    private StringArray memberDivide(IntArray array) {
        int size = this.size;
        String[] d1 = this.datas;
        int[] d2 = array.getDatas();
        boolean[] s2 = array.getSigns();
        if (this.isTemporary()) {
            int i = 1;
            while (i <= size) {
                if (s2 == null || !s2[i]) {
                    if (d1[i] != null) {
                        int n = i;
                        d1[n] = String.valueOf(d1[n]) + d2[i];
                    } else {
                        d1[i] = Integer.toString(d2[i]);
                    }
                }
                ++i;
            }
            return this;
        }
        String[] resultDatas = new String[size + 1];
        int i = 1;
        while (i <= size) {
            if (d1[i] != null) {
                resultDatas[i] = s2 == null || !s2[i] ? String.valueOf(d1[i]) + d2[i] : d1[i];
            } else if (s2 == null || !s2[i]) {
                resultDatas[i] = Integer.toString(d2[i]);
            }
            ++i;
        }
        StringArray result = new StringArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    private StringArray memberDivide(LongArray array) {
        int size = this.size;
        String[] d1 = this.datas;
        long[] d2 = array.getDatas();
        boolean[] s2 = array.getSigns();
        if (this.isTemporary()) {
            int i = 1;
            while (i <= size) {
                if (s2 == null || !s2[i]) {
                    if (d1[i] != null) {
                        int n = i;
                        d1[n] = String.valueOf(d1[n]) + d2[i];
                    } else {
                        d1[i] = Long.toString(d2[i]);
                    }
                }
                ++i;
            }
            return this;
        }
        String[] resultDatas = new String[size + 1];
        int i = 1;
        while (i <= size) {
            if (d1[i] != null) {
                resultDatas[i] = s2 == null || !s2[i] ? String.valueOf(d1[i]) + d2[i] : d1[i];
            } else if (s2 == null || !s2[i]) {
                resultDatas[i] = Long.toString(d2[i]);
            }
            ++i;
        }
        StringArray result = new StringArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    private StringArray memberDivide(DoubleArray array) {
        int size = this.size;
        String[] d1 = this.datas;
        double[] d2 = array.getDatas();
        boolean[] s2 = array.getSigns();
        if (this.isTemporary()) {
            int i = 1;
            while (i <= size) {
                if (s2 == null || !s2[i]) {
                    if (d1[i] != null) {
                        int n = i;
                        d1[n] = String.valueOf(d1[n]) + d2[i];
                    } else {
                        d1[i] = Double.toString(d2[i]);
                    }
                }
                ++i;
            }
            return this;
        }
        String[] resultDatas = new String[size + 1];
        int i = 1;
        while (i <= size) {
            if (d1[i] != null) {
                resultDatas[i] = s2 == null || !s2[i] ? String.valueOf(d1[i]) + d2[i] : d1[i];
            } else if (s2 == null || !s2[i]) {
                resultDatas[i] = Double.toString(d2[i]);
            }
            ++i;
        }
        StringArray result = new StringArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    private StringArray memberDivide(BoolArray array) {
        int size = this.size;
        String[] d1 = this.datas;
        boolean[] d2 = array.getDatas();
        boolean[] s2 = array.getSigns();
        if (this.isTemporary()) {
            int i = 1;
            while (i <= size) {
                if (s2 == null || !s2[i]) {
                    if (d1[i] != null) {
                        int n = i;
                        d1[n] = String.valueOf(d1[n]) + d2[i];
                    } else {
                        d1[i] = Boolean.toString(d2[i]);
                    }
                }
                ++i;
            }
            return this;
        }
        String[] resultDatas = new String[size + 1];
        int i = 1;
        while (i <= size) {
            if (d1[i] != null) {
                resultDatas[i] = s2 == null || !s2[i] ? String.valueOf(d1[i]) + d2[i] : d1[i];
            } else if (s2 == null || !s2[i]) {
                resultDatas[i] = Boolean.toString(d2[i]);
            }
            ++i;
        }
        StringArray result = new StringArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    @Override
    public IArray memberMod(IArray array) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(String.valueOf(this.getDataType()) + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illMod"));
    }

    @Override
    public IArray memberIntDivide(IArray array) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(String.valueOf(this.getDataType()) + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illDivide"));
    }

    @Override
    public BoolArray calcRelation(IArray array, int relation) {
        if (array instanceof StringArray) {
            return this.calcRelation((StringArray)array, relation);
        }
        if (array instanceof ConstArray) {
            return this.calcRelation(array.get(1), relation);
        }
        if (array instanceof ObjectArray) {
            return this.calcRelation((ObjectArray)array, relation);
        }
        if (array instanceof BoolArray) {
            return ((BoolArray)array).calcRelation(this, Relation.getInverseRelation(relation));
        }
        if (array instanceof IntArray) {
            return ((IntArray)array).calcRelation(this, Relation.getInverseRelation(relation));
        }
        if (array instanceof LongArray) {
            return ((LongArray)array).calcRelation(this, Relation.getInverseRelation(relation));
        }
        if (array instanceof DoubleArray) {
            return ((DoubleArray)array).calcRelation(this, Relation.getInverseRelation(relation));
        }
        if (array instanceof DateArray) {
            return ((DateArray)array).calcRelation(this, Relation.getInverseRelation(relation));
        }
        return array.calcRelation(this, Relation.getInverseRelation(relation));
    }

    @Override
    public BoolArray calcRelation(Object value, int relation) {
        if (value instanceof String) {
            return this.calcRelation((String)value, relation);
        }
        if (value == null) {
            return ArrayUtil.calcRelationNull(this.datas, this.size, relation);
        }
        boolean b = Variant.isTrue(value);
        int size = this.size;
        String[] datas = this.datas;
        if (relation == 7) {
            BoolArray result;
            if (!b) {
                result = new BoolArray(false, size);
            } else {
                boolean[] resultDatas = new boolean[size + 1];
                int i = 1;
                while (i <= size) {
                    resultDatas[i] = datas[i] != null;
                    ++i;
                }
                result = new BoolArray(resultDatas, size);
            }
            result.setTemporary(true);
            return result;
        }
        if (relation == 8) {
            BoolArray result;
            if (b) {
                result = new BoolArray(true, size);
            } else {
                boolean[] resultDatas = new boolean[size + 1];
                int i = 1;
                while (i <= size) {
                    resultDatas[i] = datas[i] != null;
                    ++i;
                }
                result = new BoolArray(resultDatas, size);
            }
            result.setTemporary(true);
            return result;
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("Variant2.illCompare", this.get(1), value, this.getDataType(), Variant.getDataType(value)));
    }

    private BoolArray calcRelation(String value, int relation) {
        int i;
        int size = this.size;
        String[] d1 = this.datas;
        boolean[] resultDatas = new boolean[size + 1];
        if (relation == 1) {
            i = 1;
            while (i <= size) {
                resultDatas[i] = StringArray.isEquals(d1[i], value);
                ++i;
            }
        } else if (relation == 2) {
            i = 1;
            while (i <= size) {
                resultDatas[i] = StringArray.compare(d1[i], value) > 0;
                ++i;
            }
        } else if (relation == 3) {
            i = 1;
            while (i <= size) {
                resultDatas[i] = StringArray.compare(d1[i], value) >= 0;
                ++i;
            }
        } else if (relation == 4) {
            i = 1;
            while (i <= size) {
                resultDatas[i] = StringArray.compare(d1[i], value) < 0;
                ++i;
            }
        } else if (relation == 5) {
            i = 1;
            while (i <= size) {
                resultDatas[i] = StringArray.compare(d1[i], value) <= 0;
                ++i;
            }
        } else if (relation == 6) {
            i = 1;
            while (i <= size) {
                resultDatas[i] = StringArray.compare(d1[i], value) != 0;
                ++i;
            }
        } else if (relation == 7) {
            i = 1;
            while (i <= size) {
                resultDatas[i] = d1[i] != null;
                ++i;
            }
        } else {
            i = 1;
            while (i <= size) {
                resultDatas[i] = true;
                ++i;
            }
        }
        BoolArray result = new BoolArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    private BoolArray calcRelation(StringArray array, int relation) {
        int i;
        int size = this.size;
        String[] d1 = this.datas;
        String[] d2 = array.datas;
        boolean[] resultDatas = new boolean[size + 1];
        if (relation == 1) {
            i = 1;
            while (i <= size) {
                resultDatas[i] = StringArray.compare(d1[i], d2[i]) == 0;
                ++i;
            }
        } else if (relation == 2) {
            i = 1;
            while (i <= size) {
                resultDatas[i] = StringArray.compare(d1[i], d2[i]) > 0;
                ++i;
            }
        } else if (relation == 3) {
            i = 1;
            while (i <= size) {
                resultDatas[i] = StringArray.compare(d1[i], d2[i]) >= 0;
                ++i;
            }
        } else if (relation == 4) {
            i = 1;
            while (i <= size) {
                resultDatas[i] = StringArray.compare(d1[i], d2[i]) < 0;
                ++i;
            }
        } else if (relation == 5) {
            i = 1;
            while (i <= size) {
                resultDatas[i] = StringArray.compare(d1[i], d2[i]) <= 0;
                ++i;
            }
        } else if (relation == 6) {
            i = 1;
            while (i <= size) {
                resultDatas[i] = StringArray.compare(d1[i], d2[i]) != 0;
                ++i;
            }
        } else if (relation == 7) {
            i = 1;
            while (i <= size) {
                resultDatas[i] = d1[i] != null && d2[i] != null;
                ++i;
            }
        } else {
            i = 1;
            while (i <= size) {
                resultDatas[i] = d1[i] != null || d2[i] != null;
                ++i;
            }
        }
        BoolArray result = new BoolArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    protected BoolArray calcRelation(ObjectArray array, int relation) {
        int i;
        int size = this.size;
        String[] d1 = this.datas;
        Object[] d2 = array.getDatas();
        boolean[] resultDatas = new boolean[size + 1];
        if (relation == 1) {
            i = 1;
            while (i <= size) {
                resultDatas[i] = StringArray.compare(d1[i], d2[i]) == 0;
                ++i;
            }
        } else if (relation == 2) {
            i = 1;
            while (i <= size) {
                resultDatas[i] = StringArray.compare(d1[i], d2[i]) > 0;
                ++i;
            }
        } else if (relation == 3) {
            i = 1;
            while (i <= size) {
                resultDatas[i] = StringArray.compare(d1[i], d2[i]) >= 0;
                ++i;
            }
        } else if (relation == 4) {
            i = 1;
            while (i <= size) {
                resultDatas[i] = StringArray.compare(d1[i], d2[i]) < 0;
                ++i;
            }
        } else if (relation == 5) {
            i = 1;
            while (i <= size) {
                resultDatas[i] = StringArray.compare(d1[i], d2[i]) <= 0;
                ++i;
            }
        } else if (relation == 6) {
            i = 1;
            while (i <= size) {
                resultDatas[i] = StringArray.compare(d1[i], d2[i]) != 0;
                ++i;
            }
        } else if (relation == 7) {
            i = 1;
            while (i <= size) {
                resultDatas[i] = d1[i] != null && Variant.isTrue(d2[i]);
                ++i;
            }
        } else {
            i = 1;
            while (i <= size) {
                resultDatas[i] = d1[i] != null || Variant.isTrue(d2[i]);
                ++i;
            }
        }
        BoolArray result = new BoolArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public int compareTo(IArray array) {
        block18: {
            block17: {
                size1 = this.size;
                size2 = array.size();
                d1 = this.datas;
                size = size1;
                result = 0;
                if (size1 < size2) {
                    result = -1;
                } else if (size1 > size2) {
                    result = 1;
                    size = size2;
                }
                if (!(array instanceof StringArray)) break block17;
                array2 = (StringArray)array;
                d2 = array2.datas;
                i = 1;
                while (i <= size) {
                    cmp = StringArray.compare(d1[i], d2[i]);
                    if (cmp != 0) {
                        return cmp;
                    }
                    ++i;
                }
                break block18;
            }
            if (!(array instanceof ConstArray)) ** GOTO lbl46
            value = array.get(1);
            if (value instanceof String) {
                d2 = (String)value;
                i = 1;
                while (i <= size) {
                    cmp = StringArray.compare(d1[i], d2);
                    if (cmp != 0) {
                        return cmp;
                    }
                    ++i;
                }
            } else if (value == null) {
                i = 1;
                while (i <= size) {
                    if (d1[i] != null) {
                        return 1;
                    }
                    ++i;
                }
            } else {
                mm = EngineMessage.get();
                throw new RQException(mm.getMessage("Variant2.illCompare", this.get(1), value, this.getDataType(), array.getDataType()));
lbl46:
                // 1 sources

                if (array instanceof ObjectArray) {
                    array2 = (ObjectArray)array;
                    d2 = array2.getDatas();
                    i = 1;
                    while (i <= size) {
                        cmp = StringArray.compare(d1[i], d2[i]);
                        if (cmp != 0) {
                            return cmp;
                        }
                        ++i;
                    }
                } else {
                    mm = EngineMessage.get();
                    throw new RQException(mm.getMessage("Variant2.illCompare", this.get(1), array.get(1), this.getDataType(), array.getDataType()));
                }
            }
        }
        return result;
    }

    @Override
    public int memberCompare(int index1, int index2) {
        return StringArray.compare(this.datas[index1], this.datas[index2]);
    }

    @Override
    public boolean isMemberEquals(int index1, int index2) {
        if (this.datas[index1] == null) {
            return this.datas[index2] == null;
        }
        if (this.datas[index2] == null) {
            return false;
        }
        return this.datas[index1].equals(this.datas[index2]);
    }

    @Override
    public boolean isEquals(int curIndex, IArray array, int index) {
        Object value = array.get(index);
        if (value instanceof String) {
            return ((String)value).equals(this.datas[curIndex]);
        }
        if (value == null) {
            return this.datas[curIndex] == null;
        }
        return false;
    }

    @Override
    public boolean isEquals(int curIndex, Object value) {
        if (value instanceof String) {
            return ((String)value).equals(this.datas[curIndex]);
        }
        if (value == null) {
            return this.datas[curIndex] == null;
        }
        return false;
    }

    @Override
    public int compareTo(int curIndex, IArray array, int index) {
        return StringArray.compare(this.datas[curIndex], array.get(index));
    }

    @Override
    public int compareTo(int curIndex, Object value) {
        return StringArray.compare(this.datas[curIndex], value);
    }

    @Override
    public int hashCode(int index) {
        if (this.datas[index] != null) {
            return this.datas[index].hashCode();
        }
        return 0;
    }

    @Override
    public Object sum() {
        int size = this.size;
        if (size < 1) {
            return null;
        }
        String[] datas = this.datas;
        String result = datas[1];
        int i = 2;
        while (i <= size) {
            if (datas[i] != null) {
                result = result == null ? datas[i] : String.valueOf(result) + datas[i];
            }
            ++i;
        }
        return result;
    }

    @Override
    public Object average() {
        return null;
    }

    @Override
    public Object max() {
        int size = this.size;
        if (size == 0) {
            return null;
        }
        String[] datas = this.datas;
        String max = null;
        int i = 1;
        while (i <= size) {
            if (datas[i] != null) {
                max = datas[i];
                break;
            }
            ++i;
        }
        ++i;
        while (i <= size) {
            if (datas[i] != null && max.compareTo(datas[i]) < 0) {
                max = datas[i];
            }
            ++i;
        }
        return max;
    }

    @Override
    public Object min() {
        int size = this.size;
        if (size == 0) {
            return null;
        }
        String[] datas = this.datas;
        String min = null;
        int i = 1;
        while (i <= size) {
            if (datas[i] != null) {
                min = datas[i];
                break;
            }
            ++i;
        }
        ++i;
        while (i <= size) {
            if (datas[i] != null && min.compareTo(datas[i]) > 0) {
                min = datas[i];
            }
            ++i;
        }
        return min;
    }

    @Override
    public void calcRelations(IArray array, int relation, BoolArray result, boolean isAnd) {
        if (array instanceof StringArray) {
            this.calcRelations((StringArray)array, relation, result, isAnd);
        } else if (array instanceof ConstArray) {
            this.calcRelations(array.get(1), relation, result, isAnd);
        } else if (array instanceof ObjectArray) {
            this.calcRelations((ObjectArray)array, relation, result, isAnd);
        } else {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("Variant2.illCompare", this.get(1), array.get(1), this.getDataType(), array.getDataType()));
        }
    }

    @Override
    public void calcRelations(Object value, int relation, BoolArray result, boolean isAnd) {
        if (value instanceof String) {
            this.calcRelations((String)value, relation, result, isAnd);
        } else if (value == null) {
            ArrayUtil.calcRelationsNull(this.datas, this.size, relation, result, isAnd);
        } else {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("Variant2.illCompare", this.get(1), value, this.getDataType(), Variant.getDataType(value)));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void calcRelations(String value, int relation, BoolArray result, boolean isAnd) {
        int size = this.size;
        String[] d1 = this.datas;
        boolean[] resultDatas = result.getDatas();
        if (isAnd) {
            if (relation == 1) {
                int i = 1;
                while (i <= size) {
                    if (resultDatas[i] && StringArray.compare(d1[i], value) != 0) {
                        resultDatas[i] = false;
                    }
                    ++i;
                }
                return;
            } else if (relation == 2) {
                int i = 1;
                while (i <= size) {
                    if (resultDatas[i] && StringArray.compare(d1[i], value) <= 0) {
                        resultDatas[i] = false;
                    }
                    ++i;
                }
                return;
            } else if (relation == 3) {
                int i = 1;
                while (i <= size) {
                    if (resultDatas[i] && StringArray.compare(d1[i], value) < 0) {
                        resultDatas[i] = false;
                    }
                    ++i;
                }
                return;
            } else if (relation == 4) {
                int i = 1;
                while (i <= size) {
                    if (resultDatas[i] && StringArray.compare(d1[i], value) >= 0) {
                        resultDatas[i] = false;
                    }
                    ++i;
                }
                return;
            } else if (relation == 5) {
                int i = 1;
                while (i <= size) {
                    if (resultDatas[i] && StringArray.compare(d1[i], value) > 0) {
                        resultDatas[i] = false;
                    }
                    ++i;
                }
                return;
            } else {
                if (relation != 6) throw new RuntimeException();
                int i = 1;
                while (i <= size) {
                    if (resultDatas[i] && StringArray.compare(d1[i], value) == 0) {
                        resultDatas[i] = false;
                    }
                    ++i;
                }
            }
            return;
        } else if (relation == 1) {
            int i = 1;
            while (i <= size) {
                if (!resultDatas[i] && StringArray.compare(d1[i], value) == 0) {
                    resultDatas[i] = true;
                }
                ++i;
            }
            return;
        } else if (relation == 2) {
            int i = 1;
            while (i <= size) {
                if (!resultDatas[i] && StringArray.compare(d1[i], value) > 0) {
                    resultDatas[i] = true;
                }
                ++i;
            }
            return;
        } else if (relation == 3) {
            int i = 1;
            while (i <= size) {
                if (!resultDatas[i] && StringArray.compare(d1[i], value) >= 0) {
                    resultDatas[i] = true;
                }
                ++i;
            }
            return;
        } else if (relation == 4) {
            int i = 1;
            while (i <= size) {
                if (!resultDatas[i] && StringArray.compare(d1[i], value) < 0) {
                    resultDatas[i] = true;
                }
                ++i;
            }
            return;
        } else if (relation == 5) {
            int i = 1;
            while (i <= size) {
                if (!resultDatas[i] && StringArray.compare(d1[i], value) <= 0) {
                    resultDatas[i] = true;
                }
                ++i;
            }
            return;
        } else {
            if (relation != 6) throw new RuntimeException();
            int i = 1;
            while (i <= size) {
                if (!resultDatas[i] && StringArray.compare(d1[i], value) != 0) {
                    resultDatas[i] = true;
                }
                ++i;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void calcRelations(StringArray array, int relation, BoolArray result, boolean isAnd) {
        int size = this.size;
        String[] d1 = this.datas;
        String[] d2 = array.datas;
        boolean[] resultDatas = result.getDatas();
        if (isAnd) {
            if (relation == 1) {
                int i = 1;
                while (i <= size) {
                    if (resultDatas[i] && StringArray.compare(d1[i], d2[i]) != 0) {
                        resultDatas[i] = false;
                    }
                    ++i;
                }
                return;
            } else if (relation == 2) {
                int i = 1;
                while (i <= size) {
                    if (resultDatas[i] && StringArray.compare(d1[i], d2[i]) <= 0) {
                        resultDatas[i] = false;
                    }
                    ++i;
                }
                return;
            } else if (relation == 3) {
                int i = 1;
                while (i <= size) {
                    if (resultDatas[i] && StringArray.compare(d1[i], d2[i]) < 0) {
                        resultDatas[i] = false;
                    }
                    ++i;
                }
                return;
            } else if (relation == 4) {
                int i = 1;
                while (i <= size) {
                    if (resultDatas[i] && StringArray.compare(d1[i], d2[i]) >= 0) {
                        resultDatas[i] = false;
                    }
                    ++i;
                }
                return;
            } else if (relation == 5) {
                int i = 1;
                while (i <= size) {
                    if (resultDatas[i] && StringArray.compare(d1[i], d2[i]) > 0) {
                        resultDatas[i] = false;
                    }
                    ++i;
                }
                return;
            } else {
                if (relation != 6) throw new RuntimeException();
                int i = 1;
                while (i <= size) {
                    if (resultDatas[i] && StringArray.compare(d1[i], d2[i]) == 0) {
                        resultDatas[i] = false;
                    }
                    ++i;
                }
            }
            return;
        } else if (relation == 1) {
            int i = 1;
            while (i <= size) {
                if (!resultDatas[i] && StringArray.compare(d1[i], d2[i]) == 0) {
                    resultDatas[i] = true;
                }
                ++i;
            }
            return;
        } else if (relation == 2) {
            int i = 1;
            while (i <= size) {
                if (!resultDatas[i] && StringArray.compare(d1[i], d2[i]) > 0) {
                    resultDatas[i] = true;
                }
                ++i;
            }
            return;
        } else if (relation == 3) {
            int i = 1;
            while (i <= size) {
                if (!resultDatas[i] && StringArray.compare(d1[i], d2[i]) >= 0) {
                    resultDatas[i] = true;
                }
                ++i;
            }
            return;
        } else if (relation == 4) {
            int i = 1;
            while (i <= size) {
                if (!resultDatas[i] && StringArray.compare(d1[i], d2[i]) < 0) {
                    resultDatas[i] = true;
                }
                ++i;
            }
            return;
        } else if (relation == 5) {
            int i = 1;
            while (i <= size) {
                if (!resultDatas[i] && StringArray.compare(d1[i], d2[i]) <= 0) {
                    resultDatas[i] = true;
                }
                ++i;
            }
            return;
        } else {
            if (relation != 6) throw new RuntimeException();
            int i = 1;
            while (i <= size) {
                if (!resultDatas[i] && StringArray.compare(d1[i], d2[i]) != 0) {
                    resultDatas[i] = true;
                }
                ++i;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void calcRelations(ObjectArray array, int relation, BoolArray result, boolean isAnd) {
        int size = this.size;
        String[] d1 = this.datas;
        Object[] d2 = array.getDatas();
        boolean[] resultDatas = result.getDatas();
        if (isAnd) {
            if (relation == 1) {
                int i = 1;
                while (i <= size) {
                    if (resultDatas[i] && StringArray.compare(d1[i], d2[i]) != 0) {
                        resultDatas[i] = false;
                    }
                    ++i;
                }
                return;
            } else if (relation == 2) {
                int i = 1;
                while (i <= size) {
                    if (resultDatas[i] && StringArray.compare(d1[i], d2[i]) <= 0) {
                        resultDatas[i] = false;
                    }
                    ++i;
                }
                return;
            } else if (relation == 3) {
                int i = 1;
                while (i <= size) {
                    if (resultDatas[i] && StringArray.compare(d1[i], d2[i]) < 0) {
                        resultDatas[i] = false;
                    }
                    ++i;
                }
                return;
            } else if (relation == 4) {
                int i = 1;
                while (i <= size) {
                    if (resultDatas[i] && StringArray.compare(d1[i], d2[i]) >= 0) {
                        resultDatas[i] = false;
                    }
                    ++i;
                }
                return;
            } else if (relation == 5) {
                int i = 1;
                while (i <= size) {
                    if (resultDatas[i] && StringArray.compare(d1[i], d2[i]) > 0) {
                        resultDatas[i] = false;
                    }
                    ++i;
                }
                return;
            } else {
                if (relation != 6) throw new RuntimeException();
                int i = 1;
                while (i <= size) {
                    if (resultDatas[i] && StringArray.compare(d1[i], d2[i]) == 0) {
                        resultDatas[i] = false;
                    }
                    ++i;
                }
            }
            return;
        } else if (relation == 1) {
            int i = 1;
            while (i <= size) {
                if (!resultDatas[i] && StringArray.compare(d1[i], d2[i]) == 0) {
                    resultDatas[i] = true;
                }
                ++i;
            }
            return;
        } else if (relation == 2) {
            int i = 1;
            while (i <= size) {
                if (!resultDatas[i] && StringArray.compare(d1[i], d2[i]) > 0) {
                    resultDatas[i] = true;
                }
                ++i;
            }
            return;
        } else if (relation == 3) {
            int i = 1;
            while (i <= size) {
                if (!resultDatas[i] && StringArray.compare(d1[i], d2[i]) >= 0) {
                    resultDatas[i] = true;
                }
                ++i;
            }
            return;
        } else if (relation == 4) {
            int i = 1;
            while (i <= size) {
                if (!resultDatas[i] && StringArray.compare(d1[i], d2[i]) < 0) {
                    resultDatas[i] = true;
                }
                ++i;
            }
            return;
        } else if (relation == 5) {
            int i = 1;
            while (i <= size) {
                if (!resultDatas[i] && StringArray.compare(d1[i], d2[i]) <= 0) {
                    resultDatas[i] = true;
                }
                ++i;
            }
            return;
        } else {
            if (relation != 6) throw new RuntimeException();
            int i = 1;
            while (i <= size) {
                if (!resultDatas[i] && StringArray.compare(d1[i], d2[i]) != 0) {
                    resultDatas[i] = true;
                }
                ++i;
            }
        }
    }

    @Override
    public IArray bitwiseAnd(IArray array) {
        MessageManager mm = EngineMessage.get();
        throw new RQException("and" + mm.getMessage("function.paramTypeError"));
    }

    @Override
    public IArray bitwiseOr(IArray array) {
        MessageManager mm = EngineMessage.get();
        throw new RQException("or" + mm.getMessage("function.paramTypeError"));
    }

    @Override
    public IArray bitwiseXOr(IArray array) {
        MessageManager mm = EngineMessage.get();
        throw new RQException("xor" + mm.getMessage("function.paramTypeError"));
    }

    @Override
    public IArray bitwiseNot() {
        MessageManager mm = EngineMessage.get();
        throw new RQException("not" + mm.getMessage("function.paramTypeError"));
    }

    @Override
    public IArray select(IArray signArray) {
        int size = signArray.size();
        String[] d1 = this.datas;
        String[] resultDatas = new String[size + 1];
        int count = 0;
        if (signArray instanceof BoolArray) {
            BoolArray array = (BoolArray)signArray;
            boolean[] d2 = array.getDatas();
            boolean[] s2 = array.getSigns();
            if (s2 == null) {
                int i = 1;
                while (i <= size) {
                    if (d2[i]) {
                        resultDatas[++count] = d1[i];
                    }
                    ++i;
                }
            } else {
                int i = 1;
                while (i <= size) {
                    if (!s2[i] && d2[i]) {
                        resultDatas[++count] = d1[i];
                    }
                    ++i;
                }
            }
        } else {
            int i = 1;
            while (i <= size) {
                if (signArray.isTrue(i)) {
                    resultDatas[++count] = d1[i];
                }
                ++i;
            }
        }
        return new StringArray(resultDatas, count);
    }

    @Override
    public IArray select(int start, int end, IArray signArray) {
        String[] d1 = this.datas;
        String[] resultDatas = new String[end - start + 1];
        int count = 0;
        if (signArray instanceof BoolArray) {
            BoolArray array = (BoolArray)signArray;
            boolean[] d2 = array.getDatas();
            boolean[] s2 = array.getSigns();
            if (s2 == null) {
                int i = start;
                while (i < end) {
                    if (d2[i]) {
                        resultDatas[++count] = d1[i];
                    }
                    ++i;
                }
            } else {
                int i = start;
                while (i < end) {
                    if (!s2[i] && d2[i]) {
                        resultDatas[++count] = d1[i];
                    }
                    ++i;
                }
            }
        } else {
            int i = start;
            while (i < end) {
                if (signArray.isTrue(i)) {
                    resultDatas[++count] = d1[i];
                }
                ++i;
            }
        }
        return new StringArray(resultDatas, count);
    }

    @Override
    public IArray memberAdd(int curIndex, IArray array, int index) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(String.valueOf(this.getDataType()) + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illAdd"));
    }

    @Override
    public Object[] toArray() {
        Object[] result = new Object[this.size];
        System.arraycopy(this.datas, 1, result, 0, this.size);
        return result;
    }

    @Override
    public void toArray(Object[] result) {
        System.arraycopy(this.datas, 1, result, 0, this.size);
    }

    @Override
    public IArray split(int pos) {
        String[] datas = this.datas;
        int size = this.size;
        int resultSize = size - pos + 1;
        String[] resultDatas = new String[resultSize + 1];
        System.arraycopy(datas, pos, resultDatas, 1, resultSize);
        int i = pos;
        while (i <= size) {
            datas[i] = null;
            ++i;
        }
        this.size = pos - 1;
        return new StringArray(resultDatas, resultSize);
    }

    @Override
    public IArray split(int from, int to) {
        String[] datas = this.datas;
        int oldSize = this.size;
        int resultSize = to - from + 1;
        String[] resultDatas = new String[resultSize + 1];
        System.arraycopy(datas, from, resultDatas, 1, resultSize);
        System.arraycopy(datas, to + 1, datas, from, oldSize - to);
        this.size -= resultSize;
        int i = this.size + 1;
        while (i <= oldSize) {
            datas[i] = null;
            ++i;
        }
        return new StringArray(resultDatas, resultSize);
    }

    @Override
    public void sort() {
        MultithreadUtil.sort(this.datas, 1, this.size + 1);
    }

    @Override
    public void sort(Comparator<Object> comparator) {
        MultithreadUtil.sort(this.datas, 1, this.size + 1, comparator);
    }

    @Override
    public boolean hasRecord() {
        return false;
    }

    @Override
    public boolean isPmt(boolean isPure) {
        return false;
    }

    @Override
    public IArray rvs() {
        int size = this.size;
        String[] datas = this.datas;
        String[] resultDatas = new String[size + 1];
        int i = 1;
        int q = size;
        while (i <= size) {
            resultDatas[i] = datas[q--];
            ++i;
        }
        return new StringArray(resultDatas, size);
    }

    @Override
    public IntArray ptop(int count, boolean isAll, boolean isLast, boolean ignoreNull) {
        int size = this.size;
        if (size == 0) {
            return new IntArray(0);
        }
        String[] datas = this.datas;
        if (ignoreNull) {
            if (count == 1) {
                String minValue = null;
                if (isAll) {
                    IntArray result = new IntArray(8);
                    int i = 1;
                    while (i <= size) {
                        if (datas[i] != null) {
                            minValue = datas[i];
                            result.addInt(i);
                            break;
                        }
                        ++i;
                    }
                    ++i;
                    while (i <= size) {
                        if (datas[i] != null) {
                            int cmp = datas[i].compareTo(minValue);
                            if (cmp < 0) {
                                minValue = datas[i];
                                result.clear();
                                result.addInt(i);
                            } else if (cmp == 0) {
                                result.addInt(i);
                            }
                        }
                        ++i;
                    }
                    return result;
                }
                if (isLast) {
                    int i = size;
                    int pos = 0;
                    while (i > 0) {
                        if (datas[i] != null) {
                            minValue = datas[i];
                            pos = i;
                            break;
                        }
                        --i;
                    }
                    --i;
                    while (i > 0) {
                        if (datas[i] != null && datas[i].compareTo(minValue) < 0) {
                            minValue = datas[i];
                            pos = i;
                        }
                        --i;
                    }
                    IntArray result = new IntArray(1);
                    if (pos != 0) {
                        result.pushInt(pos);
                    }
                    return result;
                }
                int i = 1;
                int pos = 0;
                while (i <= size) {
                    if (datas[i] != null) {
                        minValue = datas[i];
                        pos = i;
                        break;
                    }
                    ++i;
                }
                ++i;
                while (i <= size) {
                    if (datas[i] != null && datas[i].compareTo(minValue) < 0) {
                        minValue = datas[i];
                        pos = i;
                    }
                    ++i;
                }
                IntArray result = new IntArray(1);
                if (pos != 0) {
                    result.pushInt(pos);
                }
                return result;
            }
            if (count > 1) {
                int next = count + 1;
                StringArray valueArray = new StringArray(next);
                IntArray posArray = new IntArray(next);
                int i = 1;
                while (i <= size) {
                    if (datas[i] != null) {
                        int index = valueArray.binarySearch(datas[i]);
                        if (index < 1) {
                            index = -index;
                        }
                        if (index <= count) {
                            valueArray.insert(index, datas[i]);
                            posArray.insertInt(index, i);
                            if (valueArray.size() == next) {
                                valueArray.removeLast();
                                posArray.removeLast();
                            }
                        }
                    }
                    ++i;
                }
                return posArray;
            }
            if (count == -1) {
                String maxValue = null;
                if (isAll) {
                    IntArray result = new IntArray(8);
                    int i = 1;
                    while (i <= size) {
                        if (datas[i] != null) {
                            maxValue = datas[i];
                            result.addInt(i);
                            break;
                        }
                        ++i;
                    }
                    ++i;
                    while (i <= size) {
                        if (datas[i] != null) {
                            int cmp = datas[i].compareTo(maxValue);
                            if (cmp > 0) {
                                maxValue = datas[i];
                                result.clear();
                                result.addInt(i);
                            } else if (cmp == 0) {
                                result.addInt(i);
                            }
                        }
                        ++i;
                    }
                    return result;
                }
                if (isLast) {
                    int i = size;
                    int pos = 0;
                    while (i > 0) {
                        if (datas[i] != null) {
                            maxValue = datas[i];
                            pos = i;
                            break;
                        }
                        --i;
                    }
                    --i;
                    while (i > 0) {
                        if (datas[i] != null && datas[i].compareTo(maxValue) > 0) {
                            maxValue = datas[i];
                            pos = i;
                        }
                        --i;
                    }
                    IntArray result = new IntArray(1);
                    if (pos != 0) {
                        result.pushInt(pos);
                    }
                    return result;
                }
                int i = 1;
                int pos = 0;
                while (i <= size) {
                    if (datas[i] != null) {
                        maxValue = datas[i];
                        pos = i;
                        break;
                    }
                    ++i;
                }
                ++i;
                while (i <= size) {
                    if (datas[i] != null && datas[i].compareTo(maxValue) > 0) {
                        maxValue = datas[i];
                        pos = i;
                    }
                    ++i;
                }
                IntArray result = new IntArray(1);
                if (pos != 0) {
                    result.pushInt(pos);
                }
                return result;
            }
            if (count < -1) {
                count = -count;
                int next = count + 1;
                StringArray valueArray = new StringArray(next);
                IntArray posArray = new IntArray(next);
                int i = 1;
                while (i <= size) {
                    if (datas[i] != null) {
                        int index = valueArray.descBinarySearch(datas[i]);
                        if (index < 1) {
                            index = -index;
                        }
                        if (index <= count) {
                            valueArray.insert(index, datas[i]);
                            posArray.insertInt(index, i);
                            if (valueArray.size() == next) {
                                valueArray.remove(next);
                                posArray.remove(next);
                            }
                        }
                    }
                    ++i;
                }
                return posArray;
            }
            return new IntArray(1);
        }
        if (count == 1) {
            if (isAll) {
                IntArray result = new IntArray(8);
                result.addInt(1);
                String minValue = datas[1];
                int i = 2;
                while (i <= size) {
                    int cmp = StringArray.compare(datas[i], minValue);
                    if (cmp < 0) {
                        minValue = datas[i];
                        result.clear();
                        result.addInt(i);
                    } else if (cmp == 0) {
                        result.addInt(i);
                    }
                    ++i;
                }
                return result;
            }
            if (isLast) {
                String minValue = datas[size];
                int pos = size;
                int i = size - 1;
                while (i > 0) {
                    if (StringArray.compare(datas[i], minValue) < 0) {
                        minValue = datas[i];
                        pos = i;
                    }
                    --i;
                }
                IntArray result = new IntArray(1);
                result.pushInt(pos);
                return result;
            }
            String minValue = datas[1];
            int pos = 1;
            int i = 2;
            while (i <= size) {
                if (StringArray.compare(datas[i], minValue) < 0) {
                    minValue = datas[i];
                    pos = i;
                }
                ++i;
            }
            IntArray result = new IntArray(1);
            result.pushInt(pos);
            return result;
        }
        if (count > 1) {
            int next = count + 1;
            StringArray valueArray = new StringArray(next);
            IntArray posArray = new IntArray(next);
            int i = 1;
            while (i <= size) {
                int index = valueArray.binarySearch(datas[i]);
                if (index < 1) {
                    index = -index;
                }
                if (index <= count) {
                    valueArray.insert(index, datas[i]);
                    posArray.insertInt(index, i);
                    if (valueArray.size() == next) {
                        valueArray.removeLast();
                        posArray.removeLast();
                    }
                }
                ++i;
            }
            return posArray;
        }
        if (count == -1) {
            if (isAll) {
                IntArray result = new IntArray(8);
                String maxValue = datas[1];
                result.addInt(1);
                int i = 2;
                while (i <= size) {
                    int cmp = StringArray.compare(datas[i], maxValue);
                    if (cmp > 0) {
                        maxValue = datas[i];
                        result.clear();
                        result.addInt(i);
                    } else if (cmp == 0) {
                        result.addInt(i);
                    }
                    ++i;
                }
                return result;
            }
            if (isLast) {
                String maxValue = datas[size];
                int pos = size;
                int i = size - 1;
                while (i > 0) {
                    if (StringArray.compare(datas[i], maxValue) > 0) {
                        maxValue = datas[i];
                        pos = i;
                    }
                    --i;
                }
                IntArray result = new IntArray(1);
                result.pushInt(pos);
                return result;
            }
            String maxValue = datas[1];
            int pos = 1;
            int i = 2;
            while (i <= size) {
                if (StringArray.compare(datas[i], maxValue) > 0) {
                    maxValue = datas[i];
                    pos = i;
                }
                ++i;
            }
            IntArray result = new IntArray(1);
            result.pushInt(pos);
            return result;
        }
        if (count < -1) {
            count = -count;
            int next = count + 1;
            StringArray valueArray = new StringArray(next);
            IntArray posArray = new IntArray(next);
            int i = 1;
            while (i <= size) {
                int index = valueArray.descBinarySearch(datas[i]);
                if (index < 1) {
                    index = -index;
                }
                if (index <= count) {
                    valueArray.insert(index, datas[i]);
                    posArray.insertInt(index, i);
                    if (valueArray.size() == next) {
                        valueArray.remove(next);
                        posArray.remove(next);
                    }
                }
                ++i;
            }
            return posArray;
        }
        return new IntArray(1);
    }

    @Override
    public IntArray ptopRank(int count, boolean ignoreNull, boolean iopt) {
        int size = this.size;
        if (size == 0 || count == 0) {
            return new IntArray(0);
        }
        String[] datas = this.datas;
        if (count > 0) {
            int next = count + 1;
            StringArray valueArray = new StringArray(next);
            IntArray posArray = new IntArray(next);
            if (iopt) {
                int curCount = 0;
                int i = 1;
                while (i <= size) {
                    int curSize;
                    if (datas[i] != null) {
                        if (curCount < count) {
                            int index = valueArray.binarySearch(datas[i]);
                            if (index < 1) {
                                ++curCount;
                                index = -index;
                            }
                            valueArray.insert(index, datas[i]);
                            posArray.insertInt(index, i);
                        } else {
                            curSize = valueArray.size();
                            int cmp = this.compareTo(i, valueArray, curSize);
                            if (cmp < 0) {
                                int index = valueArray.binarySearch(datas[i]);
                                if (index < 1) {
                                    index = -index;
                                    String value = valueArray.getString(curSize);
                                    valueArray.removeLast();
                                    posArray.removeLast();
                                    int j = curSize - 1;
                                    while (j >= count) {
                                        if (valueArray.getString(j).compareTo(value) != 0) break;
                                        valueArray.removeLast();
                                        posArray.removeLast();
                                        --j;
                                    }
                                }
                                valueArray.insert(index, datas[i]);
                                posArray.insertInt(index, i);
                            } else if (cmp == 0) {
                                valueArray.add(datas[i]);
                                posArray.addInt(i);
                            }
                        }
                    } else if (!ignoreNull) {
                        if (curCount < count) {
                            if (curCount == 0 || !valueArray.isNull(1)) {
                                ++curCount;
                            }
                            valueArray.insert(1, null);
                            posArray.insertInt(1, i);
                        } else if (valueArray.isNull(1)) {
                            valueArray.add(datas[i]);
                            posArray.addInt(i);
                        } else {
                            curSize = valueArray.size();
                            String value = valueArray.getString(curSize);
                            valueArray.removeLast();
                            posArray.removeLast();
                            int j = curSize - 1;
                            while (j >= count) {
                                if (valueArray.getString(j).compareTo(value) != 0) break;
                                valueArray.removeLast();
                                posArray.removeLast();
                                --j;
                            }
                            valueArray.insert(1, null);
                            posArray.insertInt(1, i);
                        }
                    }
                    ++i;
                }
            } else {
                int i = 1;
                while (i <= size) {
                    int curSize;
                    if (datas[i] != null) {
                        curSize = valueArray.size();
                        if (curSize < count) {
                            int index = valueArray.binarySearch(datas[i]);
                            if (index < 1) {
                                index = -index;
                            }
                            valueArray.insert(index, datas[i]);
                            posArray.insertInt(index, i);
                        } else {
                            int cmp = this.compareTo(i, valueArray, curSize);
                            if (cmp < 0) {
                                int index = valueArray.binarySearch(datas[i]);
                                if (index < 1) {
                                    index = -index;
                                }
                                valueArray.insert(index, datas[i]);
                                posArray.insertInt(index, i);
                                if (valueArray.memberCompare(count, curSize + 1) != 0) {
                                    String value = valueArray.getString(curSize + 1);
                                    valueArray.removeLast();
                                    posArray.removeLast();
                                    int j = curSize;
                                    while (j > count) {
                                        if (valueArray.getString(j).compareTo(value) == 0) {
                                            valueArray.removeLast();
                                            posArray.removeLast();
                                            --j;
                                            continue;
                                        }
                                        break;
                                    }
                                }
                            } else if (cmp == 0) {
                                valueArray.add(datas[i]);
                                posArray.addInt(i);
                            }
                        }
                    } else if (!ignoreNull) {
                        curSize = valueArray.size();
                        if (curSize < count) {
                            valueArray.insert(1, null);
                            posArray.insertInt(1, i);
                        } else if (valueArray.isNull(curSize)) {
                            valueArray.add(datas[i]);
                            posArray.addInt(i);
                        } else {
                            valueArray.insert(1, null);
                            posArray.insertInt(1, i);
                            if (valueArray.memberCompare(count, curSize + 1) != 0) {
                                String value = valueArray.getString(curSize + 1);
                                valueArray.removeLast();
                                posArray.removeLast();
                                int j = curSize;
                                while (j > count) {
                                    if (valueArray.getString(j).compareTo(value) == 0) {
                                        valueArray.removeLast();
                                        posArray.removeLast();
                                        --j;
                                        continue;
                                    }
                                    break;
                                }
                            }
                        }
                    }
                    ++i;
                }
            }
            return posArray;
        }
        count = -count;
        int next = count + 1;
        StringArray valueArray = new StringArray(next);
        IntArray posArray = new IntArray(next);
        if (iopt) {
            int curCount = 0;
            int i = 1;
            while (i <= size) {
                if (datas[i] != null) {
                    if (curCount < count) {
                        int index = valueArray.descBinarySearch(datas[i]);
                        if (index < 1) {
                            ++curCount;
                            index = -index;
                        }
                        valueArray.insert(index, datas[i]);
                        posArray.insertInt(index, i);
                    } else {
                        int curSize = valueArray.size();
                        int cmp = this.compareTo(i, valueArray, curSize);
                        if (cmp > 0) {
                            int index = valueArray.descBinarySearch(datas[i]);
                            if (index < 1) {
                                index = -index;
                                String value = valueArray.getString(curSize);
                                valueArray.removeLast();
                                posArray.removeLast();
                                int j = curSize - 1;
                                while (j >= count) {
                                    if (valueArray.getString(j).compareTo(value) != 0) break;
                                    valueArray.removeLast();
                                    posArray.removeLast();
                                    --j;
                                }
                            }
                            valueArray.insert(index, datas[i]);
                            posArray.insertInt(index, i);
                        } else if (cmp == 0) {
                            valueArray.add(datas[i]);
                            posArray.addInt(i);
                        }
                    }
                }
                ++i;
            }
        } else {
            int i = 1;
            while (i <= size) {
                if (datas[i] != null) {
                    int curSize = valueArray.size();
                    if (curSize < count) {
                        int index = valueArray.descBinarySearch(datas[i]);
                        if (index < 1) {
                            index = -index;
                        }
                        valueArray.insert(index, datas[i]);
                        posArray.insertInt(index, i);
                    } else {
                        int cmp = this.compareTo(i, valueArray, curSize);
                        if (cmp > 0) {
                            int index = valueArray.descBinarySearch(datas[i]);
                            if (index < 1) {
                                index = -index;
                            }
                            valueArray.insert(index, datas[i]);
                            posArray.insertInt(index, i);
                            if (valueArray.memberCompare(count, curSize + 1) != 0) {
                                String value = valueArray.getString(curSize + 1);
                                valueArray.removeLast();
                                posArray.removeLast();
                                int j = curSize;
                                while (j > count) {
                                    if (valueArray.getString(j).compareTo(value) == 0) {
                                        valueArray.removeLast();
                                        posArray.removeLast();
                                        --j;
                                        continue;
                                    }
                                    break;
                                }
                            }
                        } else if (cmp == 0) {
                            valueArray.add(datas[i]);
                            posArray.addInt(i);
                        }
                    }
                }
                ++i;
            }
        }
        return posArray;
    }

    @Override
    public void setSize(int size) {
        this.size = size;
    }

    @Override
    public ObjectArray toObjectArray() {
        Object[] resultDatas = new Object[this.size + 1];
        System.arraycopy(this.datas, 1, resultDatas, 1, this.size);
        return new ObjectArray(resultDatas, this.size);
    }

    @Override
    public IArray toPureArray() {
        return this;
    }

    @Override
    public IArray reserve(boolean refOrigin) {
        if (this.isTemporary()) {
            this.setTemporary(false);
            return this;
        }
        if (refOrigin) {
            return this;
        }
        return this.dup();
    }

    @Override
    public IArray combine(IArray signArray, IArray other) {
        if (other instanceof ConstArray) {
            return this.combine(signArray, ((ConstArray)other).getData());
        }
        int size = this.size;
        String[] datas = this.datas;
        if (other instanceof StringArray) {
            String[] otherDatas = ((StringArray)other).getDatas();
            if (this.isTemporary()) {
                int i = 1;
                while (i <= size) {
                    if (signArray.isFalse(i)) {
                        datas[i] = otherDatas[i];
                    }
                    ++i;
                }
                return this;
            }
            String[] resultDatas = new String[size + 1];
            System.arraycopy(datas, 1, resultDatas, 1, size);
            int i = 1;
            while (i <= size) {
                if (signArray.isFalse(i)) {
                    resultDatas[i] = otherDatas[i];
                }
                ++i;
            }
            StringArray result = new StringArray(resultDatas, size);
            result.setTemporary(true);
            return result;
        }
        Object[] resultDatas = new Object[size + 1];
        System.arraycopy(datas, 1, resultDatas, 1, size);
        int i = 1;
        while (i <= size) {
            if (signArray.isFalse(i)) {
                resultDatas[i] = other.get(i);
            }
            ++i;
        }
        ObjectArray result = new ObjectArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    @Override
    public IArray combine(IArray signArray, Object value) {
        int size = this.size;
        String[] datas = this.datas;
        if (value instanceof String || value == null) {
            String str = (String)value;
            if (this.isTemporary()) {
                int i = 1;
                while (i <= size) {
                    if (signArray.isFalse(i)) {
                        datas[i] = str;
                    }
                    ++i;
                }
                return this;
            }
            String[] resultDatas = new String[size + 1];
            System.arraycopy(datas, 1, resultDatas, 1, size);
            int i = 1;
            while (i <= size) {
                if (signArray.isFalse(i)) {
                    resultDatas[i] = str;
                }
                ++i;
            }
            StringArray result = new StringArray(resultDatas, size);
            result.setTemporary(true);
            return result;
        }
        Object[] resultDatas = new Object[size + 1];
        System.arraycopy(datas, 1, resultDatas, 1, size);
        int i = 1;
        while (i <= size) {
            if (signArray.isFalse(i)) {
                resultDatas[i] = value;
            }
            ++i;
        }
        ObjectArray result = new ObjectArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    @Override
    public Object pos(IArray array, String opt) {
        return ArrayUtil.pos(this, array, opt);
    }

    @Override
    public int bit1() {
        MessageManager mm = EngineMessage.get();
        throw new RQException("bit1" + mm.getMessage("function.paramTypeError"));
    }

    @Override
    public int bit1(IArray array) {
        MessageManager mm = EngineMessage.get();
        throw new RQException("bit1" + mm.getMessage("function.paramTypeError"));
    }

    @Override
    public int getNextEqualCount(int index) {
        String[] datas = this.datas;
        int size = this.size;
        int count = 1;
        String value = datas[index];
        if (value == null) {
            ++index;
            while (index <= size) {
                if (datas[index] == null) {
                    ++count;
                    ++index;
                    continue;
                }
                break;
            }
        } else {
            ++index;
            while (index <= size) {
                if (datas[index] != null && datas[index].equals(value)) {
                    ++count;
                    ++index;
                    continue;
                }
                break;
            }
        }
        return count;
    }
}

