/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.cellset;

import com.scudata.common.CellLocation;
import com.scudata.common.Sentence;
import com.scudata.dm.KeyWord;

public final class CellRefUtil {
    public static final String ERRORREF = "#REF!";

    public static boolean isRowChar(char c) {
        return c >= '0' && c <= '9';
    }

    public static boolean isColChar(char c) {
        return c >= 'A' && c <= 'Z';
    }

    public static boolean isPrevDot(String str, int pos) {
        --pos;
        while (pos >= 0) {
            char c = str.charAt(pos);
            if (c == '.') {
                return true;
            }
            if (!Character.isWhitespace(c)) {
                return false;
            }
            --pos;
        }
        return false;
    }

    public static String changeRow(int cellRow, int rowBase, int rowIncrement, int oldRowCount) {
        if (rowBase != -1) {
            if (rowIncrement < 0 && cellRow >= rowBase && cellRow <= rowBase - rowIncrement - 1) {
                return null;
            }
            if (cellRow >= rowBase) {
                cellRow += rowIncrement;
            }
        }
        return CellLocation.toRow(cellRow);
    }

    public static String changeCol(int cellCol, int colBase, int colIncrement, int oldColCount) {
        if (colBase != -1) {
            if (colIncrement < 0 && cellCol >= colBase && cellCol <= colBase - colIncrement - 1) {
                return null;
            }
            if (cellCol >= colBase) {
                cellCol += colIncrement;
            }
        }
        return CellLocation.toCol(cellCol);
    }

    public static String changeRow(int cellRow, int rowIncrement, int rowCount) {
        if ((cellRow += rowIncrement) <= 0 || cellRow > rowCount) {
            return null;
        }
        return CellLocation.toRow(cellRow);
    }

    public static String changeCol(int cellCol, int colIncrement, int colCount) {
        if (cellCol <= 0 || cellCol > colCount) {
            return null;
        }
        if ((cellCol += colIncrement) <= 0 || cellCol > colCount) {
            return null;
        }
        return CellLocation.toCol(cellCol);
    }

    public static String relativeRegulateString(String str, int rowBase, int rowIncrement, int colBase, int colIncrement, int oldRowCount, int oldColCount, boolean[] error) {
        error[0] = false;
        if (str == null || str.length() == 0 || str.startsWith(ERRORREF)) {
            return str;
        }
        StringBuffer strNew = null;
        int len = str.length();
        int idx = 0;
        while (idx < len) {
            String strRow;
            String strCol;
            int row;
            int col;
            String strRow2;
            char ch = str.charAt(idx);
            if (ch == '\'' || ch == '\"') {
                int tmp = Sentence.scanQuotation(str, idx);
                if (tmp < 0) {
                    if (strNew == null) break;
                    strNew.append(str.substring(idx));
                    break;
                }
                ++tmp;
                if (strNew != null) {
                    strNew.append(str.substring(idx, tmp));
                }
                idx = tmp;
                continue;
            }
            if (KeyWord.isSymbol(ch) || ch == '#') {
                if (strNew != null) {
                    strNew.append(ch);
                }
                ++idx;
                continue;
            }
            int last = KeyWord.scanId(str, idx + 1);
            if (last - idx < 2 || !CellRefUtil.isColChar(ch) && ch != '$' || CellRefUtil.isPrevDot(str, idx)) {
                if (strNew != null) {
                    strNew.append(str.substring(idx, last));
                }
                idx = last;
                continue;
            }
            int macroIndex = -1;
            int numIndex = -1;
            for (int i = idx + 1; i < last; ++i) {
                char tmp = str.charAt(i);
                if (tmp == '$') {
                    macroIndex = i;
                    numIndex = i + 1;
                    break;
                }
                if (CellRefUtil.isRowChar(tmp)) {
                    numIndex = i;
                    break;
                }
                if (!CellRefUtil.isColChar(tmp)) break;
            }
            if (numIndex == -1) {
                if (strNew != null) {
                    strNew.append(str.substring(idx, last));
                }
                idx = last;
                continue;
            }
            if (ch == '$') {
                if (macroIndex == -1) {
                    CellLocation lct = CellLocation.parse(str.substring(idx + 1, last));
                    if (lct == null || lct.getRow() > oldRowCount || lct.getCol() > oldColCount) {
                        if (strNew != null) {
                            strNew.append(str.substring(idx, last));
                        }
                    } else {
                        String strCol2 = CellRefUtil.changeCol(lct.getCol(), colBase, colIncrement, oldColCount);
                        if (strCol2 == null) {
                            error[0] = true;
                            return ERRORREF + str;
                        }
                        strRow2 = CellRefUtil.changeRow(lct.getRow(), rowBase, rowIncrement, oldRowCount);
                        if (strRow2 == null) {
                            error[0] = true;
                            return ERRORREF + str;
                        }
                        if (strNew == null) {
                            strNew = new StringBuffer(64);
                            strNew.append(str.substring(0, idx));
                        }
                        strNew.append('$');
                        strNew.append(strCol2);
                        strNew.append(strRow2);
                    }
                } else {
                    col = CellLocation.parseCol(str.substring(idx + 1, macroIndex));
                    row = CellLocation.parseRow(str.substring(numIndex, last));
                    if (col == -1 || row == -1 || row > oldRowCount || col > oldColCount) {
                        if (strNew != null) {
                            strNew.append(str.substring(idx, last));
                        }
                    } else {
                        strCol = CellRefUtil.changeCol(col, colBase, colIncrement, oldColCount);
                        if (strCol == null) {
                            error[0] = true;
                            return ERRORREF + str;
                        }
                        strRow = CellRefUtil.changeRow(row, rowBase, rowIncrement, oldRowCount);
                        if (strRow == null) {
                            error[0] = true;
                            return ERRORREF + str;
                        }
                        if (strNew == null) {
                            strNew = new StringBuffer(64);
                            strNew.append(str.substring(0, idx));
                        }
                        strNew.append('$');
                        strNew.append(strCol);
                        strNew.append('$');
                        strNew.append(strRow);
                    }
                }
            } else if (macroIndex == -1) {
                CellLocation lct = CellLocation.parse(str.substring(idx, last));
                if (lct == null || lct.getRow() > oldRowCount || lct.getCol() > oldColCount) {
                    if (strNew != null) {
                        strNew.append(str.substring(idx, last));
                    }
                } else {
                    String strCol3 = CellRefUtil.changeCol(lct.getCol(), colBase, colIncrement, oldColCount);
                    if (strCol3 == null) {
                        error[0] = true;
                        return ERRORREF + str;
                    }
                    strRow2 = CellRefUtil.changeRow(lct.getRow(), rowBase, rowIncrement, oldRowCount);
                    if (strRow2 == null) {
                        error[0] = true;
                        return ERRORREF + str;
                    }
                    if (strNew == null) {
                        strNew = new StringBuffer(64);
                        strNew.append(str.substring(0, idx));
                    }
                    strNew.append(strCol3);
                    strNew.append(strRow2);
                }
            } else {
                col = CellLocation.parseCol(str.substring(idx, macroIndex));
                row = CellLocation.parseRow(str.substring(numIndex, last));
                if (col == -1 || row == -1 || row > oldRowCount || col > oldColCount) {
                    if (strNew != null) {
                        strNew.append(str.substring(idx, last));
                    }
                } else {
                    strCol = CellRefUtil.changeCol(col, colBase, colIncrement, oldColCount);
                    if (strCol == null) {
                        error[0] = true;
                        return ERRORREF + str;
                    }
                    strRow = CellRefUtil.changeRow(row, rowBase, rowIncrement, oldRowCount);
                    if (strRow == null) {
                        error[0] = true;
                        return ERRORREF + str;
                    }
                    if (strNew == null) {
                        strNew = new StringBuffer(64);
                        strNew.append(str.substring(0, idx));
                    }
                    strNew.append(strCol);
                    strNew.append('$');
                    strNew.append(strRow);
                }
            }
            idx = last;
        }
        return strNew == null ? str : strNew.toString();
    }

    public static int adjustRowReference(int r, int[] rows, boolean isInsert) {
        int count = rows.length;
        for (int i = 0; i < count; ++i) {
            if (rows[i] > r) {
                return isInsert ? r + i : r - i;
            }
            if (rows[i] != r) continue;
            return isInsert ? r + i + 1 : -1;
        }
        return isInsert ? r + count : r - count;
    }

    public static String exchangeCellString(String str, CellLocation lct1, CellLocation lct2) {
        if (str == null || str.length() == 0 || str.startsWith(ERRORREF)) {
            return str;
        }
        StringBuffer strNew = null;
        int len = str.length();
        int idx = 0;
        while (idx < len) {
            int row;
            int col;
            char ch = str.charAt(idx);
            if (ch == '\'' || ch == '\"') {
                int tmp = Sentence.scanQuotation(str, idx);
                if (tmp < 0) {
                    if (strNew == null) break;
                    strNew.append(str.substring(idx));
                    break;
                }
                ++tmp;
                if (strNew != null) {
                    strNew.append(str.substring(idx, tmp));
                }
                idx = tmp;
                continue;
            }
            if (KeyWord.isSymbol(ch) || ch == '#') {
                if (strNew != null) {
                    strNew.append(ch);
                }
                ++idx;
                continue;
            }
            int last = KeyWord.scanId(str, idx + 1);
            if (last - idx < 2 || !CellRefUtil.isColChar(ch) && ch != '$' || CellRefUtil.isPrevDot(str, idx)) {
                if (strNew != null) {
                    strNew.append(str.substring(idx, last));
                }
                idx = last;
                continue;
            }
            int macroIndex = -1;
            int numIndex = -1;
            for (int i = idx + 1; i < last; ++i) {
                char tmp = str.charAt(i);
                if (tmp == '$') {
                    macroIndex = i;
                    numIndex = i + 1;
                    break;
                }
                if (CellRefUtil.isRowChar(tmp)) {
                    numIndex = i;
                    break;
                }
                if (!CellRefUtil.isColChar(tmp)) break;
            }
            if (numIndex == -1) {
                if (strNew != null) {
                    strNew.append(str.substring(idx, last));
                }
                idx = last;
                continue;
            }
            if (ch == '$') {
                if (macroIndex == -1) {
                    CellLocation lct = CellLocation.parse(str.substring(idx + 1, last));
                    if (lct1.equals(lct)) {
                        if (strNew == null) {
                            strNew = new StringBuffer(64);
                            strNew.append(str.substring(0, idx));
                        }
                        strNew.append('$');
                        strNew.append(lct2.toString());
                    } else if (lct2.equals(lct)) {
                        if (strNew == null) {
                            strNew = new StringBuffer(64);
                            strNew.append(str.substring(0, idx));
                        }
                        strNew.append('$');
                        strNew.append(lct1.toString());
                    } else if (strNew != null) {
                        strNew.append(str.substring(idx, last));
                    }
                } else {
                    col = CellLocation.parseCol(str.substring(idx + 1, macroIndex));
                    row = CellLocation.parseRow(str.substring(numIndex, last));
                    if (col == lct1.getCol() && row == lct1.getRow()) {
                        if (strNew == null) {
                            strNew = new StringBuffer(64);
                            strNew.append(str.substring(0, idx));
                        }
                        strNew.append('$');
                        strNew.append(CellLocation.toCol(lct2.getCol()));
                        strNew.append('$');
                        strNew.append(CellLocation.toRow(lct2.getRow()));
                    } else if (col == lct2.getCol() && row == lct2.getRow()) {
                        if (strNew == null) {
                            strNew = new StringBuffer(64);
                            strNew.append(str.substring(0, idx));
                        }
                        strNew.append('$');
                        strNew.append(CellLocation.toCol(lct1.getCol()));
                        strNew.append('$');
                        strNew.append(CellLocation.toRow(lct1.getRow()));
                    } else if (strNew != null) {
                        strNew.append(str.substring(idx, last));
                    }
                }
            } else if (macroIndex == -1) {
                CellLocation lct = CellLocation.parse(str.substring(idx, last));
                if (lct1.equals(lct)) {
                    if (strNew == null) {
                        strNew = new StringBuffer(64);
                        strNew.append(str.substring(0, idx));
                    }
                    strNew.append(lct2.toString());
                } else if (lct2.equals(lct)) {
                    if (strNew == null) {
                        strNew = new StringBuffer(64);
                        strNew.append(str.substring(0, idx));
                    }
                    strNew.append(lct1.toString());
                } else if (strNew != null) {
                    strNew.append(str.substring(idx, last));
                }
            } else {
                col = CellLocation.parseCol(str.substring(idx, macroIndex));
                row = CellLocation.parseRow(str.substring(numIndex, last));
                if (col == lct1.getCol() && row == lct1.getRow()) {
                    if (strNew == null) {
                        strNew = new StringBuffer(64);
                        strNew.append(str.substring(0, idx));
                    }
                    strNew.append(CellLocation.toCol(lct2.getCol()));
                    strNew.append('$');
                    strNew.append(CellLocation.toRow(lct2.getRow()));
                } else if (col == lct2.getCol() && row == lct2.getRow()) {
                    if (strNew == null) {
                        strNew = new StringBuffer(64);
                        strNew.append(str.substring(0, idx));
                    }
                    strNew.append(CellLocation.toCol(lct1.getCol()));
                    strNew.append('$');
                    strNew.append(CellLocation.toRow(lct1.getRow()));
                } else if (strNew != null) {
                    strNew.append(str.substring(idx, last));
                }
            }
            idx = last;
        }
        return strNew == null ? str : strNew.toString();
    }
}

