/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.cellset.graph.config;

import com.scudata.common.ArgumentTokenizer;
import com.scudata.common.GMBase;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

public class Palette {
    public static final byte PATTERN_DEFAULT = 0;
    public static final byte PATTERN_H_THIN_LINE = 1;
    public static final byte PATTERN_H_THICK_LINE = 2;
    public static final byte PATTERN_V_THIN_LINE = 3;
    public static final byte PATTERN_V_THICK_LINE = 4;
    public static final byte PATTERN_THIN_SLASH = 5;
    public static final byte PATTERN_THICK_SLASH = 6;
    public static final byte PATTERN_THIN_BACKSLASH = 7;
    public static final byte PATTERN_THICK_BACKSLASH = 8;
    public static final byte PATTERN_THIN_GRID = 9;
    public static final byte PATTERN_THICK_GRID = 10;
    public static final byte PATTERN_THIN_BEVEL_GRID = 11;
    public static final byte PATTERN_THICK_BEVEL_GRID = 12;
    public static final byte PATTERN_DOT_1 = 13;
    public static final byte PATTERN_DOT_2 = 14;
    public static final byte PATTERN_DOT_3 = 15;
    public static final byte PATTERN_DOT_4 = 16;
    public static final byte PATTERN_SQUARE_FLOOR = 17;
    public static final byte PATTERN_DIAMOND_FLOOR = 18;
    public static final byte PATTERN_BRICK_WALL = 19;
    private int[] _$5 = null;
    private byte[] _$4 = null;
    private int _$3 = 0;
    private static Palette _$2 = Palette._$1();
    private static Map _$1 = Palette._$2();

    public Palette() {
        this(20);
    }

    public Palette(int capacity) {
        this._$5 = new int[capacity];
        this._$4 = new byte[capacity];
    }

    public void ensureCapacity(int mincap) {
        int[] colors = this._$5;
        if (mincap > colors.length) {
            int newcap = colors.length * 3 / 2 + 1;
            this._$5 = new int[newcap < mincap ? mincap : newcap];
            System.arraycopy(colors, 0, this._$5, 0, this._$3);
            this._$4 = new byte[newcap < mincap ? mincap : newcap];
            System.arraycopy(this._$4, 0, this._$4, 0, this._$3);
        }
    }

    public int getColor(int index) {
        if (this._$5.length == 0) {
            return _$2.getColor(index);
        }
        int p = index < this._$5.length ? index : index % this._$5.length;
        return this._$5[p];
    }

    public static byte[] listPatterns() {
        byte[] patterns = new byte[20];
        for (int b = 0; b <= 19; b = (int)((byte)(b + 1))) {
            patterns[b] = b;
        }
        return patterns;
    }

    public static int getPatternsCount() {
        return 20;
    }

    public byte getPattern(int index) {
        if (this._$4.length == 0) {
            return 0;
        }
        int p = index < this._$4.length ? index : index % this._$4.length;
        return this._$4[p];
    }

    public static Paint getPatternPaint(Color backColor, byte pattern) {
        TexturePaint paint = null;
        int x = 0;
        int y = 0;
        Graphics tempG = null;
        Color cb = backColor;
        Color cf = Color.black;
        switch (pattern) {
            case 1: {
                Rectangle rect = new Rectangle(x + 1, y + 1, 6, 6);
                BufferedImage tempbi = new BufferedImage(6, 6, 1);
                tempG = (Graphics2D)tempbi.getGraphics();
                tempG.setColor(cb);
                tempG.fillRect(0, 0, 6, 6);
                tempG.setColor(cf);
                ((Graphics2D)tempG).setStroke(new BasicStroke(0.1f));
                tempG.drawLine(0, 1, 6, 1);
                tempG.drawLine(0, 3, 6, 3);
                tempG.drawLine(0, 5, 6, 5);
                paint = new TexturePaint(tempbi, rect);
                break;
            }
            case 2: {
                Rectangle rect = new Rectangle(x + 1, y + 1, 6, 6);
                BufferedImage tempbi = new BufferedImage(6, 6, 1);
                tempG = (Graphics2D)tempbi.getGraphics();
                tempG.setColor(cb);
                tempG.fillRect(0, 0, 6, 6);
                tempG.setColor(cf);
                ((Graphics2D)tempG).setStroke(new BasicStroke(1.5f));
                tempG.drawLine(0, 2, 6, 2);
                tempG.drawLine(0, 5, 6, 5);
                paint = new TexturePaint(tempbi, rect);
                break;
            }
            case 3: {
                Rectangle rect = new Rectangle(x + 1, y + 1, 6, 6);
                BufferedImage tempbi = new BufferedImage(6, 6, 1);
                tempG = (Graphics2D)tempbi.getGraphics();
                tempG.setColor(cb);
                tempG.fillRect(0, 0, 6, 6);
                tempG.setColor(cf);
                ((Graphics2D)tempG).setStroke(new BasicStroke(0.1f));
                tempG.drawLine(1, 0, 1, 6);
                tempG.drawLine(3, 0, 3, 6);
                tempG.drawLine(5, 0, 5, 6);
                paint = new TexturePaint(tempbi, rect);
                break;
            }
            case 4: {
                Rectangle rect = new Rectangle(x + 1, y + 1, 6, 6);
                BufferedImage tempbi = new BufferedImage(6, 6, 1);
                tempG = (Graphics2D)tempbi.getGraphics();
                tempG.setColor(cb);
                tempG.fillRect(0, 0, 6, 6);
                tempG.setColor(cf);
                ((Graphics2D)tempG).setStroke(new BasicStroke(1.5f));
                tempG.drawLine(2, 0, 2, 6);
                tempG.drawLine(5, 0, 5, 6);
                paint = new TexturePaint(tempbi, rect);
                break;
            }
            case 5: {
                Rectangle rect = new Rectangle(x + 1, y + 1, 3, 3);
                BufferedImage tempbi = new BufferedImage(3, 3, 1);
                tempG = (Graphics2D)tempbi.getGraphics();
                tempG.setColor(cb);
                tempG.fillRect(0, 0, 3, 3);
                tempG.setColor(cf);
                ((Graphics2D)tempG).setStroke(new BasicStroke(0.1f));
                tempG.drawLine(0, 0, 3, 3);
                paint = new TexturePaint(tempbi, rect);
                break;
            }
            case 6: {
                Rectangle rect = new Rectangle(x + 1, y + 1, 4, 4);
                BufferedImage tempbi = new BufferedImage(4, 4, 1);
                tempG = (Graphics2D)tempbi.getGraphics();
                Palette.setGraphAntiAliasing((Graphics2D)tempG);
                tempG.setColor(cb);
                tempG.fillRect(0, 0, 4, 4);
                tempG.setColor(cf);
                ((Graphics2D)tempG).setStroke(new BasicStroke(1.5f, 2, 2, 10.0f, null, 0.0f));
                tempG.drawLine(0, 0, 4, 4);
                tempG.drawLine(3, -1, 5, 1);
                tempG.drawLine(-1, 3, 1, 5);
                paint = new TexturePaint(tempbi, rect);
                break;
            }
            case 7: {
                Rectangle rect = new Rectangle(x + 1, y + 1, 3, 3);
                BufferedImage tempbi = new BufferedImage(3, 3, 1);
                tempG = (Graphics2D)tempbi.getGraphics();
                tempG.setColor(cb);
                tempG.fillRect(0, 0, 3, 3);
                tempG.setColor(cf);
                ((Graphics2D)tempG).setStroke(new BasicStroke(0.1f));
                tempG.drawLine(2, 0, -1, 3);
                paint = new TexturePaint(tempbi, rect);
                break;
            }
            case 8: {
                Rectangle rect = new Rectangle(x + 1, y + 1, 4, 4);
                BufferedImage tempbi = new BufferedImage(4, 4, 1);
                tempG = (Graphics2D)tempbi.getGraphics();
                Palette.setGraphAntiAliasing((Graphics2D)tempG);
                tempG.setColor(cb);
                tempG.fillRect(0, 0, 4, 4);
                tempG.setColor(cf);
                ((Graphics2D)tempG).setStroke(new BasicStroke(1.5f, 2, 2, 10.0f, null, 0.0f));
                tempG.drawLine(4, 0, 0, 4);
                tempG.drawLine(-1, 1, 1, -1);
                tempG.drawLine(3, 5, 5, 3);
                paint = new TexturePaint(tempbi, rect);
                break;
            }
            case 9: {
                Rectangle rect = new Rectangle(x + 1, y + 1, 3, 3);
                BufferedImage tempbi = new BufferedImage(3, 3, 1);
                tempG = (Graphics2D)tempbi.getGraphics();
                tempG.setColor(cb);
                tempG.fillRect(0, 0, 3, 3);
                tempG.setColor(cf);
                ((Graphics2D)tempG).setStroke(new BasicStroke(0.1f, 2, 0, 10.0f, null, 0.0f));
                tempG.drawLine(1, 0, 1, 3);
                tempG.drawLine(0, 1, 3, 1);
                paint = new TexturePaint(tempbi, rect);
                break;
            }
            case 10: {
                Rectangle rect = new Rectangle(x + 1, y + 1, 5, 5);
                BufferedImage tempbi = new BufferedImage(5, 5, 1);
                tempG = (Graphics2D)tempbi.getGraphics();
                tempG.setColor(cb);
                tempG.fillRect(0, 0, 5, 5);
                tempG.setColor(cf);
                ((Graphics2D)tempG).setStroke(new BasicStroke(1.5f, 2, 0, 10.0f, null, 0.0f));
                tempG.drawLine(3, 0, 3, 5);
                tempG.drawLine(0, 3, 5, 3);
                paint = new TexturePaint(tempbi, rect);
                break;
            }
            case 11: {
                Rectangle rect = new Rectangle(x + 1, y + 1, 5, 5);
                BufferedImage tempbi = new BufferedImage(5, 5, 1);
                tempG = (Graphics2D)tempbi.getGraphics();
                tempG.setColor(cb);
                tempG.fillRect(0, 0, 5, 5);
                tempG.setColor(cf);
                ((Graphics2D)tempG).setStroke(new BasicStroke(0.5f, 2, 0, 10.0f, null, 0.0f));
                tempG.drawLine(0, 0, 5, 5);
                tempG.drawLine(0, 5, 5, 0);
                paint = new TexturePaint(tempbi, rect);
                break;
            }
            case 12: {
                Rectangle rect = new Rectangle(x + 1, y + 1, 6, 6);
                BufferedImage tempbi = new BufferedImage(6, 6, 1);
                tempG = (Graphics2D)tempbi.getGraphics();
                Palette.setGraphAntiAliasing((Graphics2D)tempG);
                tempG.setColor(cb);
                tempG.fillRect(0, 0, 6, 6);
                tempG.setColor(cf);
                ((Graphics2D)tempG).setStroke(new BasicStroke(1.5f, 2, 2, 10.0f, null, 0.0f));
                tempG.drawLine(0, 0, 6, 6);
                tempG.drawLine(0, 6, 6, 0);
                paint = new TexturePaint(tempbi, rect);
                break;
            }
            case 13: {
                Rectangle rect = new Rectangle(x, y, 12, 12);
                BufferedImage tempbi = new BufferedImage(12, 12, 1);
                tempG = (Graphics2D)tempbi.getGraphics();
                Palette.setGraphAntiAliasing((Graphics2D)tempG);
                tempG.setColor(cb);
                tempG.fillRect(0, 0, 12, 12);
                tempG.setColor(cf);
                ((Graphics2D)tempG).setStroke(new BasicStroke(1.0f, 2, 2, 10.0f, null, 0.0f));
                tempG.drawLine(2, 3, 2, 3);
                tempG.drawLine(8, 9, 8, 9);
                paint = new TexturePaint(tempbi, rect);
                break;
            }
            case 14: {
                Rectangle rect = new Rectangle(x, y, 12, 12);
                BufferedImage tempbi = new BufferedImage(12, 12, 1);
                tempG = (Graphics2D)tempbi.getGraphics();
                tempG.setColor(cb);
                tempG.fillRect(0, 0, 12, 12);
                tempG.setColor(cf);
                ((Graphics2D)tempG).setStroke(new BasicStroke(1.0f, 2, 2, 10.0f, null, 0.0f));
                tempG.drawLine(2, 3, 2, 3);
                tempG.drawLine(6, 11, 6, 11);
                tempG.drawLine(10, 7, 10, 7);
                paint = new TexturePaint(tempbi, rect);
                break;
            }
            case 15: {
                Rectangle rect = new Rectangle(x, y, 9, 9);
                BufferedImage tempbi = new BufferedImage(9, 9, 1);
                tempG = (Graphics2D)tempbi.getGraphics();
                Palette.setGraphAntiAliasing((Graphics2D)tempG);
                tempG.setColor(cb);
                tempG.fillRect(0, 0, 9, 9);
                tempG.setColor(cf);
                ((Graphics2D)tempG).setStroke(new BasicStroke(1.0f, 2, 2, 10.0f, null, 0.0f));
                tempG.drawLine(2, 2, 2, 2);
                tempG.drawLine(5, 8, 5, 8);
                tempG.drawLine(8, 5, 8, 5);
                paint = new TexturePaint(tempbi, rect);
                break;
            }
            case 16: {
                Rectangle rect = new Rectangle(x, y, 4, 4);
                BufferedImage tempbi = new BufferedImage(4, 4, 1);
                tempG = (Graphics2D)tempbi.getGraphics();
                tempG.setColor(cb);
                tempG.fillRect(0, 0, 4, 4);
                tempG.setColor(cf);
                ((Graphics2D)tempG).setStroke(new BasicStroke(1.0f, 2, 2, 10.0f, null, 0.0f));
                tempG.drawLine(1, 3, 1, 3);
                tempG.drawLine(3, 1, 3, 1);
                paint = new TexturePaint(tempbi, rect);
                break;
            }
            case 17: {
                Rectangle rect = new Rectangle(0, 0, 8, 8);
                BufferedImage tempbi = new BufferedImage(8, 8, 1);
                tempG = (Graphics2D)tempbi.getGraphics();
                tempG.setColor(cb);
                tempG.fillRect(0, 0, 8, 8);
                tempG.setColor(cf);
                tempG.fillRect(0, 0, 4, 4);
                tempG.fillRect(4, 4, 4, 4);
                paint = new TexturePaint(tempbi, rect);
                break;
            }
            case 18: {
                Rectangle rect = new Rectangle(x + 1, y + 1, 8, 8);
                BufferedImage tempbi = new BufferedImage(8, 8, 1);
                tempG = (Graphics2D)tempbi.getGraphics();
                tempG.setColor(cb);
                tempG.fillRect(0, 0, 8, 8);
                tempG.setColor(cf);
                int[] xs = new int[]{4, 0, 4, 8};
                int[] ys = new int[]{0, 4, 8, 4};
                tempG.fillPolygon(xs, ys, 4);
                paint = new TexturePaint(tempbi, rect);
                break;
            }
            case 19: {
                Rectangle rect = new Rectangle(x + 1, y + 1, 12, 12);
                BufferedImage tempbi = new BufferedImage(12, 12, 1);
                tempG = (Graphics2D)tempbi.getGraphics();
                tempG.setColor(cb);
                tempG.fillRect(0, 0, 12, 12);
                ((Graphics2D)tempG).setStroke(new BasicStroke(0.1f));
                tempG.setColor(cf);
                tempG.drawLine(0, 0, 12, 0);
                tempG.drawLine(0, 3, 12, 3);
                tempG.drawLine(0, 6, 12, 6);
                tempG.drawLine(0, 9, 12, 9);
                tempG.drawLine(2, 0, 2, 3);
                tempG.drawLine(8, 3, 8, 6);
                tempG.drawLine(2, 6, 2, 9);
                tempG.drawLine(8, 9, 8, 12);
                paint = new TexturePaint(tempbi, rect);
            }
        }
        if (tempG != null) {
            tempG.dispose();
        }
        return paint;
    }

    protected static void setGraphAntiAliasing(Graphics2D g) {
        g.setStroke(new BasicStroke(1.0f, 1, 1, 0.1f));
    }

    public void addColor(int color) {
        this.ensureCapacity(this._$3 + 1);
        this._$5[this._$3++] = color;
    }

    public void addColor(int index, int color) {
        this.ensureCapacity(this._$3 + 1);
        int[] colors = this._$5;
        int numtomove = this._$3 - index;
        System.arraycopy(colors, index, colors, index + 1, numtomove);
        colors[index] = color;
        ++this._$3;
    }

    public int size() {
        return this._$3;
    }

    public void trimToSize() {
        int[] colors = this._$5;
        if (this._$3 < colors.length) {
            this._$5 = new int[this._$3];
            System.arraycopy(colors, 0, this._$5, 0, this._$3);
            this._$4 = new byte[this._$3];
            System.arraycopy(this._$4, 0, this._$4, 0, this._$3);
        }
    }

    public void clear() {
        this._$3 = 0;
    }

    public static Palette readColor(String color) {
        if (color == null || color.trim().length() == 0) {
            return null;
        }
        _$1 = Palette._$2();
        return (Palette)_$1.get(color);
    }

    public static Map loadPalettes(Properties fileProperty) {
        HashMap<String, Palette> map = new HashMap<String, Palette>();
        Enumeration<Object> keys = fileProperty.keys();
        while (keys.hasMoreElements()) {
            String name = (String)keys.nextElement();
            ArgumentTokenizer st = new ArgumentTokenizer(fileProperty.getProperty(name), ',');
            int count = st.countTokens();
            Palette pl = new Palette(count);
            pl._$3 = 0;
            while (st.hasNext()) {
                StringTokenizer define = new StringTokenizer(st.next(), "@");
                pl._$5[pl._$3] = Integer.parseInt(define.nextToken());
                if (define.hasMoreTokens()) {
                    pl._$4[pl._$3] = Byte.parseByte(define.nextToken());
                }
                ++pl._$3;
            }
            map.put(name, pl);
        }
        return map;
    }

    private static Map _$2() {
        HashMap all = new HashMap();
        try {
            Properties config = new Properties();
            InputStream is = null;
            String relativePath = "config/color.properties";
            File f = new File(GMBase.getAbsolutePath(relativePath));
            is = f.exists() ? new FileInputStream(f) : Palette.class.getResourceAsStream(relativePath);
            if (is == null) {
                is = Palette.class.getResourceAsStream("/config/color.properties");
            }
            if (is == null) {
                return all;
            }
            config.load(is);
            return Palette.loadPalettes(config);
        }
        catch (Exception e) {
            e.printStackTrace();
            return all;
        }
    }

    public static Palette getDefaultPalette() {
        return _$2;
    }

    private static Palette _$1() {
        int size = 7;
        Palette pl = new Palette(size);
        pl.addColor(6003669);
        pl.addColor(10865488);
        pl.addColor(16775954);
        pl.addColor(15963941);
        pl.addColor(14895944);
        pl.addColor(9398455);
        pl.addColor(9554923);
        return pl;
    }

    private static int _$1(int r, int g, int b, int a) {
        return (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }
}

