/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.cellset.graph.draw;

import com.scudata.cellset.graph.draw.DrawBase;
import com.scudata.cellset.graph.draw.DrawLine;
import com.scudata.cellset.graph.draw.ExtGraphCategory;
import com.scudata.cellset.graph.draw.ExtGraphProperty;
import com.scudata.cellset.graph.draw.ExtGraphSery;
import com.scudata.cellset.graph.draw.GraphParam;
import com.scudata.cellset.graph.draw.ValueLabel;
import com.scudata.chart.Utils;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

public class DrawArea
extends DrawBase {
    public void draw(StringBuffer htmlLink) {
        DrawArea.drawing(this, htmlLink);
    }

    public static void drawing(DrawBase db, StringBuffer htmlLink) {
        double y;
        double x;
        GraphParam gp = db.gp;
        ExtGraphProperty egp = db.egp;
        Graphics2D g = db.g;
        ArrayList<ValueLabel> labelList = db.labelList;
        int VALUE_RADIUS = db.VALUE_RADIUS;
        gp.coorWidth = 0;
        db.initGraphInset();
        db.createCoorValue();
        db.drawLegend(htmlLink);
        db.drawTitle();
        db.drawLabel();
        db.keepGraphSpace();
        db.adjustCoorInset();
        gp.graphRect = new Rectangle2D.Double(gp.leftInset, gp.topInset, gp.graphWidth - gp.leftInset - gp.rightInset, gp.graphHeight - gp.topInset - gp.bottomInset);
        if (gp.graphRect.width < 10.0 || gp.graphRect.height < 10.0) {
            return;
        }
        if (gp.coorWidth < 0 || gp.coorWidth > 10000) {
            gp.coorWidth = 0;
        }
        double seriesWidth = gp.graphRect.width / ((double)(gp.catNum + 1) * gp.categorySpan / 100.0 + (double)gp.coorWidth / 200.0 + (double)(gp.catNum * gp.serNum));
        double coorWidth = seriesWidth * ((double)gp.coorWidth / 200.0);
        double categorySpan = seriesWidth * (gp.categorySpan / 100.0);
        double tmpInt = (double)(gp.catNum + 1) * categorySpan + coorWidth + (double)(gp.catNum * gp.serNum) * seriesWidth;
        gp.graphRect.x += (gp.graphRect.width - tmpInt) / 2.0;
        gp.graphRect.width = tmpInt;
        double dely = (gp.graphRect.height - coorWidth) / (double)gp.tickNum;
        tmpInt = dely * (double)gp.tickNum + coorWidth;
        gp.graphRect.y += (gp.graphRect.height - tmpInt) / 2.0;
        gp.graphRect.height = tmpInt;
        gp.gRect1 = (Rectangle2D.Double)gp.graphRect.clone();
        gp.gRect2 = (Rectangle2D.Double)gp.graphRect.clone();
        gp.gRect1.y += coorWidth;
        gp.gRect1.width -= coorWidth;
        gp.gRect1.height -= coorWidth;
        gp.gRect2.x += coorWidth;
        gp.gRect2.width -= coorWidth;
        gp.gRect2.height -= coorWidth;
        db.drawGraphRect();
        for (int i = 0; i <= gp.tickNum; ++i) {
            db.drawGridLine(dely, i);
            Number coory = (Number)gp.coorValue.get(i);
            String scoory = db.getFormattedValue(coory.doubleValue());
            x = gp.gRect1.x - (double)gp.tickLen;
            y = gp.gRect1.y + gp.gRect1.height - (double)i * dely;
            gp.GFV_YLABEL.outText(x, y, scoory);
            if (coory.doubleValue() != gp.baseValue + gp.minValue) continue;
            gp.valueBaseLine = gp.gRect1.y + gp.gRect1.height - (double)i * dely;
        }
        db.drawWarnLine();
        if (gp.graphTransparent) {
            g.setComposite(AlphaComposite.getInstance(3, 0.6f));
        }
        Point2D.Double[] headPoint = new Point2D.Double[gp.serNum];
        ArrayList cats = egp.getCategories();
        int cc = cats.size();
        for (int i = 0; i < cc; ++i) {
            Color c;
            boolean vis;
            ExtGraphCategory egc = (ExtGraphCategory)cats.get(i);
            double posx = DrawLine.getPosX(gp, i, cc, categorySpan, seriesWidth);
            boolean valvis = i % (gp.graphXInterval + 1) == 0;
            boolean bl = vis = valvis && !gp.isDrawTable;
            if (vis) {
                c = egp.getAxisColor(1);
                Utils.setStroke(g, c, 1, 1.0f);
                db.drawLine(posx, gp.gRect1.y + gp.gRect1.height, posx, gp.gRect1.y + gp.gRect1.height + (double)gp.tickLen, c);
                db.drawGridLineCategoryV(posx);
            }
            String value = egc.getNameString();
            x = posx;
            y = gp.gRect1.y + gp.gRect1.height + (double)gp.tickLen;
            gp.GFV_XLABEL.outText(x, y, value, vis);
            for (int j = 0; j < gp.serNum; ++j) {
                boolean vis2;
                ExtGraphSery egs = egc.getExtGraphSery(gp.serNames.get(j));
                if (egs.isNull()) continue;
                double val = egs.getValue();
                double tmp = val - gp.baseValue;
                double len = dely * (double)gp.tickNum * (tmp - gp.minValue) / (gp.maxValue * gp.coorScale);
                if (gp.isDrawTable) {
                    posx = db.getDataTableX(i);
                }
                Point2D.Double endPoint = egs.isNull() ? null : new Point2D.Double(posx, gp.valueBaseLine - len);
                if (headPoint[j] != null && endPoint != null) {
                    double[] ptx1 = new double[]{headPoint[j].x, headPoint[j].x, endPoint.x, endPoint.x};
                    double[] pty1 = new double[]{headPoint[j].y, headPoint[j].y, endPoint.y, endPoint.y};
                    g.setColor(db.getColor(j));
                    DrawArea._$1(db, ptx1, pty1, 4);
                    db.drawPolygon(ptx1, pty1, 4, egp.getAxisColor(5));
                    double[] ptx2 = new double[]{headPoint[j].x, headPoint[j].x, endPoint.x, endPoint.x};
                    double[] pty2 = new double[]{headPoint[j].y, gp.valueBaseLine, gp.valueBaseLine, endPoint.y};
                    db.setPaint(headPoint[j].x, headPoint[j].y, endPoint.x - headPoint[j].x, endPoint.y - gp.valueBaseLine, j, true);
                    DrawArea._$1(db, ptx2, pty2, 4);
                    if (seriesWidth > 3.0) {
                        db.drawPolygon(ptx2, pty2, 4, egp.getAxisColor(5));
                    }
                }
                if (gp.dispValueOntop && !egs.isNull() && valvis) {
                    String sval = db.getDispValue(egc, egs, gp.serNum);
                    x = endPoint.x;
                    y = endPoint.y;
                    c = !gp.isMultiSeries ? db.getColor(i) : db.getColor(j);
                    ValueLabel vl = new ValueLabel(sval, new Point2D.Double(x, y - (double)VALUE_RADIUS), c);
                    labelList.add(vl);
                }
                boolean bl2 = vis2 = i % (gp.graphXInterval + 1) == 0;
                if (!egs.isNull() && gp.drawLineDot && vis2) {
                    double ww;
                    double xx = endPoint.x - (double)VALUE_RADIUS;
                    double yy = endPoint.y - (double)VALUE_RADIUS;
                    double hh = ww = (double)(2 * VALUE_RADIUS);
                    if (!gp.isMultiSeries) {
                        db.setPaint(xx, yy, ww, hh, db.getColor(i), true);
                    } else {
                        db.setPaint(xx, yy, ww, hh, db.getColor(j), true);
                    }
                    db.fillRect(xx, yy, ww, hh);
                    db.drawRect(xx, yy, ww, hh, egp.getAxisColor(5));
                    db.htmlLink(xx, yy, ww, hh, htmlLink, egc.getNameString(), egs);
                }
                headPoint[j] = endPoint;
            }
        }
        db.outLabels();
        db.drawLine(gp.gRect1.x, gp.valueBaseLine, gp.gRect1.x + gp.gRect1.width, gp.valueBaseLine, egp.getAxisColor(1));
        db.drawLine(gp.gRect1.x + gp.gRect1.width, gp.valueBaseLine, gp.gRect1.x + gp.gRect1.width + coorWidth, gp.valueBaseLine - coorWidth, egp.getAxisColor(1));
    }

    private static void _$1(DrawBase db, double[] x, double[] y, int n) {
        ExtGraphProperty egp = db.egp;
        Graphics2D g = db.g;
        if (egp.isDrawShade()) {
            Color c = g.getColor();
            Paint p = g.getPaint();
            double[] xx = new double[n];
            double[] yy = new double[n];
            for (int i = 0; i < n; ++i) {
                xx[i] = x[i] + (double)db.SHADE_SPAN;
                yy[i] = y[i] + (double)db.SHADE_SPAN;
            }
            g.setColor(Color.lightGray);
            Utils.fillPolygon(g, xx, yy);
            g.setColor(c);
            g.setPaint(p);
        }
        Utils.fillPolygon(g, x, y);
    }
}

