/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.cellset.graph.draw;

import com.scudata.cellset.graph.draw.DrawBase;
import com.scudata.cellset.graph.draw.DrawLine;
import com.scudata.cellset.graph.draw.ExtGraphCategory;
import com.scudata.cellset.graph.draw.ExtGraphProperty;
import com.scudata.cellset.graph.draw.ExtGraphSery;
import com.scudata.cellset.graph.draw.GraphParam;
import com.scudata.cellset.graph.draw.ValueLabel;
import com.scudata.chart.Utils;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

public class DrawArea3D
extends DrawBase {
    public void draw(StringBuffer htmlLink) {
        DrawArea3D.drawing(this, htmlLink);
    }

    public static void drawing(DrawBase db, StringBuffer htmlLink) {
        Point2D.Double p;
        GraphParam gp = db.gp;
        ExtGraphProperty egp = db.egp;
        Graphics2D g = db.g;
        ArrayList<ValueLabel> labelList = db.labelList;
        int VALUE_RADIUS = db.VALUE_RADIUS;
        db.initGraphInset();
        db.createCoorValue();
        db.drawLegend(htmlLink);
        db.drawTitle();
        db.drawLabel();
        db.keepGraphSpace();
        db.adjustCoorInset();
        gp.graphRect = new Rectangle2D.Double(gp.leftInset, gp.topInset, gp.graphWidth - gp.leftInset - gp.rightInset, gp.graphHeight - gp.topInset - gp.bottomInset);
        if (gp.graphRect.width < 10.0 || gp.graphRect.height < 10.0) {
            return;
        }
        if (gp.coorWidth < 0 || gp.coorWidth > 10000) {
            gp.coorWidth = 0;
        }
        double seriesWidth = gp.graphRect.width / ((double)(gp.catNum + 1) * gp.categorySpan / 100.0 + (double)gp.coorWidth / 200.0 + (double)(gp.catNum * gp.serNum));
        double coorWidth = seriesWidth * ((double)gp.coorWidth / 200.0);
        double categorySpan = seriesWidth * (gp.categorySpan / 100.0);
        double tmpInt = (double)(gp.catNum + 1) * categorySpan + coorWidth + (double)(gp.catNum * gp.serNum) * seriesWidth;
        gp.graphRect.x += (gp.graphRect.width - tmpInt) / 2.0;
        gp.graphRect.width = tmpInt;
        double dely = (gp.graphRect.height - coorWidth) / (double)gp.tickNum;
        tmpInt = dely * (double)gp.tickNum + coorWidth;
        gp.graphRect.y += (gp.graphRect.height - tmpInt) / 2.0;
        gp.graphRect.height = tmpInt;
        gp.gRect1 = (Rectangle2D.Double)gp.graphRect.clone();
        gp.gRect2 = (Rectangle2D.Double)gp.graphRect.clone();
        gp.gRect1.y += coorWidth;
        gp.gRect1.width -= coorWidth;
        gp.gRect1.height -= coorWidth;
        gp.gRect2.x += coorWidth;
        gp.gRect2.width -= coorWidth;
        gp.gRect2.height -= coorWidth;
        db.drawGraphRect();
        for (int i = 0; i <= gp.tickNum; ++i) {
            db.drawGridLine(dely, i);
            Number coory = (Number)gp.coorValue.get(i);
            String scoory = db.getFormattedValue(coory.doubleValue());
            p = db._$3((double)i * dely);
            gp.GFV_YLABEL.outText(p.x - (double)gp.tickLen, p.y, scoory);
            if (coory.doubleValue() != gp.baseValue + gp.minValue) continue;
            gp.valueBaseLine = gp.gRect1.y + gp.gRect1.height - (double)i * dely;
        }
        db.drawWarnLine();
        if (gp.graphTransparent) {
            g.setComposite(AlphaComposite.getInstance(3, 0.6f));
        }
        Point2D.Double[] prePoints1 = new Point2D.Double[gp.serNum];
        Point2D.Double[] prePoints2 = new Point2D.Double[gp.serNum];
        ArrayList cats = egp.categories;
        int cc = cats.size();
        for (int i = 0; i < cc; ++i) {
            Color c;
            ExtGraphCategory egc = (ExtGraphCategory)cats.get(i);
            double posx = DrawLine.getPosX(gp, i, cc, categorySpan, seriesWidth);
            double delx = posx - gp.gRect1.x;
            boolean vis = i % (gp.graphXInterval + 1) == 0;
            p = db._$2(delx);
            if (vis) {
                c = egp.getAxisColor(1);
                Utils.setStroke(g, c, 1, 1.0f);
                db.drawLine(p.x, p.y, p.x, p.y + (double)gp.tickLen, c);
                db.drawGridLineCategoryV(gp.gRect2.x + delx);
            }
            String value = egc.getNameString();
            gp.GFV_XLABEL.outText(p.x, p.y + (double)gp.tickLen, value, vis);
            for (int j = 0; j < gp.serNum; ++j) {
                double[] pty1;
                double[] ptx1;
                Point2D.Double pt2;
                Point2D.Double pt1;
                ExtGraphSery egs = egc.getExtGraphSery(gp.serNames.get(j));
                if (egs.isNull()) continue;
                double val = egs.getValue();
                double tmp = val - gp.baseValue;
                double len = dely * (double)gp.tickNum * (tmp - gp.minValue) / (gp.maxValue * gp.coorScale);
                if (egs.isNull()) {
                    pt1 = null;
                    pt2 = null;
                } else {
                    pt1 = new Point2D.Double(posx, gp.valueBaseLine - len);
                    pt2 = new Point2D.Double(posx + coorWidth, gp.valueBaseLine - len - coorWidth);
                }
                if (gp.coorWidth == 0) {
                    if (gp.serNum == 1) {
                        g.setColor(db.getColor(i));
                    } else {
                        g.setColor(db.getColor(j));
                    }
                    db.fillRect(pt1.x - 2.0, pt1.y - 2.0, 4.0, 4.0);
                    db.fillRect(pt2.x - 2.0, pt2.y - 2.0, 4.0, 4.0);
                    if (seriesWidth > 3.0) {
                        db.drawRect(pt1.x - 2.0, pt1.y - 2.0, 4.0, 4.0, egp.getAxisColor(5));
                        db.drawRect(pt2.x - 2.0, pt2.y - 2.0, 4.0, 4.0, egp.getAxisColor(5));
                    }
                }
                if (i > 0 && prePoints1[j] != null && pt1 != null) {
                    ptx1 = new double[]{prePoints1[j].x, prePoints2[j].x, pt2.x, pt1.x};
                    pty1 = new double[]{prePoints1[j].y, prePoints2[j].y, pt2.y, pt1.y};
                    g.setColor(Color.gray);
                    Utils.fillPolygon(g, ptx1, pty1);
                    g.setColor(db.getColor(j));
                    Utils.fillPolygon(g, ptx1, pty1);
                    if (gp.coorWidth != 0) {
                        g.setColor(gp.coorColor);
                    } else {
                        g.setColor(db.getColor(j));
                    }
                    if (seriesWidth > 3.0) {
                        Utils.drawPolygon(g, ptx1, pty1);
                    }
                    double[] ptx2 = new double[]{prePoints1[j].x, prePoints1[j].x, pt1.x, pt1.x};
                    double[] pty2 = new double[]{prePoints1[j].y, gp.valueBaseLine, gp.valueBaseLine, pt1.y};
                    db.setPaint(prePoints1[j].x, prePoints1[j].y, pt1.x - prePoints1[j].x, pt1.y - gp.valueBaseLine, j, true);
                    Utils.fillPolygon(g, ptx2, pty2);
                    if (gp.coorWidth != 0) {
                        g.setColor(gp.coorColor);
                    } else {
                        g.setColor(db.getColor(j));
                    }
                    if (seriesWidth > 3.0) {
                        Utils.drawPolygon(g, ptx2, pty2);
                    }
                }
                if (gp.dispValueOntop && !egs.isNull() && vis) {
                    String sval = db.getDispValue(egc, egs, gp.serNum);
                    double x = pt1.x;
                    double y = pt1.y;
                    c = !gp.isMultiSeries ? db.getColor(i) : db.getColor(j);
                    ValueLabel vl = new ValueLabel(sval, new Point2D.Double(x, y - (double)VALUE_RADIUS), c);
                    labelList.add(vl);
                }
                if (!egs.isNull() && gp.drawLineDot && vis) {
                    if (gp.serNum == 1) {
                        g.setColor(db.getColor(i));
                    } else {
                        g.setColor(db.getColor(j));
                    }
                    db.fillRect(pt1.x - (double)VALUE_RADIUS, pt1.y - (double)VALUE_RADIUS, VALUE_RADIUS * 2, VALUE_RADIUS * 2);
                    db.fillRect(pt2.x - (double)VALUE_RADIUS, pt2.y - (double)VALUE_RADIUS, VALUE_RADIUS * 2, VALUE_RADIUS * 2);
                    if (seriesWidth > 3.0) {
                        db.drawRect(pt1.x - (double)VALUE_RADIUS, pt1.y - (double)VALUE_RADIUS, VALUE_RADIUS * 2, VALUE_RADIUS * 2, egp.getAxisColor(5));
                        db.drawRect(pt2.x - (double)VALUE_RADIUS, pt2.y - (double)VALUE_RADIUS, VALUE_RADIUS * 2, VALUE_RADIUS * 2, egp.getAxisColor(5));
                        db.htmlLink(pt2.x - (double)VALUE_RADIUS, pt2.y - (double)VALUE_RADIUS, VALUE_RADIUS * 2, VALUE_RADIUS * 2, htmlLink, egc.getNameString(), egs);
                    }
                }
                prePoints1[j] = pt1;
                prePoints2[j] = pt2;
                if (!(len >= 0.0) || i != gp.catNum - 1) continue;
                ptx1 = new double[]{prePoints1[j].x, prePoints1[j].x, prePoints2[j].x, prePoints2[j].x};
                pty1 = new double[]{prePoints1[j].y, gp.valueBaseLine, gp.valueBaseLine - coorWidth, prePoints2[j].y};
                g.setColor(Color.gray);
                Utils.fillPolygon(g, ptx1, pty1);
                g.setColor(db.getColor(j).darker());
                Utils.fillPolygon(g, ptx1, pty1);
                if (gp.coorWidth != 0) {
                    g.setColor(gp.coorColor);
                } else {
                    g.setColor(db.getColor(j));
                }
                if (!(seriesWidth > 3.0)) continue;
                Utils.drawPolygon(g, ptx1, pty1);
            }
        }
        db.outLabels();
        db.drawLine(gp.gRect1.x, gp.valueBaseLine, gp.gRect1.x + gp.gRect1.width, gp.valueBaseLine, egp.getAxisColor(1));
        db.drawLine(gp.gRect1.x + gp.gRect1.width, gp.valueBaseLine, gp.gRect1.x + gp.gRect1.width + coorWidth, gp.valueBaseLine - coorWidth, egp.getAxisColor(1));
    }
}

