/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.cellset.graph.draw;

import com.scudata.cellset.graph.draw.DrawBase;
import com.scudata.cellset.graph.draw.ExtGraphCategory;
import com.scudata.cellset.graph.draw.ExtGraphProperty;
import com.scudata.cellset.graph.draw.ExtGraphSery;
import com.scudata.cellset.graph.draw.GraphParam;
import com.scudata.cellset.graph.draw.ValueLabel;
import com.scudata.chart.Utils;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

public class DrawCol
extends DrawBase {
    public void draw(StringBuffer htmlLink) {
        DrawCol.drawing(this, htmlLink);
    }

    public static int drawing(DrawBase db, StringBuffer htmlLink) {
        double y;
        double x;
        double seriesWidth;
        double categorySpan;
        GraphParam gp = db.gp;
        ExtGraphProperty egp = db.egp;
        Graphics2D g = db.g;
        ArrayList<ValueLabel> labelList = db.labelList;
        gp.coorWidth = 0;
        db.initGraphInset();
        String sval = "";
        db.createCoorValue();
        db.drawLegend(htmlLink);
        db.drawTitle();
        db.drawLabel();
        db.keepGraphSpace();
        db.adjustCoorInset();
        gp.graphRect = new Rectangle2D.Double(gp.leftInset, gp.topInset, gp.graphWidth - gp.leftInset - gp.rightInset, gp.graphHeight - gp.topInset - gp.bottomInset);
        if (gp.graphRect.width < 10.0 || gp.graphRect.height < 10.0) {
            return -1;
        }
        if (gp.coorWidth < 0 || gp.coorWidth > 10000) {
            gp.coorWidth = 0;
        }
        if (gp.barDistance > 0.0) {
            double maxCatSpan = (gp.graphRect.width - (double)((float)(gp.serNum * gp.catNum) * 1.0f)) / (double)((float)gp.catNum + 1.0f);
            categorySpan = gp.barDistance <= maxCatSpan ? gp.barDistance : maxCatSpan;
            seriesWidth = (gp.graphRect.width - (double)(gp.catNum + 1) * categorySpan) / (double)(gp.serNum * gp.catNum);
        } else {
            seriesWidth = gp.graphRect.width / ((double)(gp.catNum + 1) * gp.categorySpan / 100.0 + (double)gp.coorWidth / 200.0 + (double)(gp.catNum * gp.serNum));
            categorySpan = seriesWidth * (gp.categorySpan / 100.0);
        }
        double coorWidth = seriesWidth * ((double)gp.coorWidth / 200.0);
        double dely = (gp.graphRect.height - coorWidth) / (double)gp.tickNum;
        gp.gRect1 = (Rectangle2D.Double)gp.graphRect.clone();
        gp.gRect2 = (Rectangle2D.Double)gp.graphRect.clone();
        db.drawGraphRect();
        for (int i = 0; i <= gp.tickNum; ++i) {
            db.drawGridLine(dely, i);
            Number coory = (Number)gp.coorValue.get(i);
            String scoory = db.getFormattedValue(coory.doubleValue());
            x = gp.gRect1.x - (double)gp.tickLen;
            y = gp.gRect1.y + gp.gRect1.height - (double)i * dely;
            gp.GFV_YLABEL.outText(x, y, scoory);
            if (coory.doubleValue() != gp.baseValue + gp.minValue) continue;
            gp.valueBaseLine = gp.gRect1.y + gp.gRect1.height - (double)i * dely;
        }
        db.drawWarnLine();
        ArrayList cats = egp.categories;
        for (int i = 0; i < gp.catNum; ++i) {
            Color c;
            boolean vis;
            ExtGraphCategory egc = (ExtGraphCategory)cats.get(i);
            double delx = (double)(i + 1) * categorySpan + (double)i * seriesWidth * (double)gp.serNum + seriesWidth * (double)gp.serNum / 2.0;
            boolean valvis = i % (gp.graphXInterval + 1) == 0;
            boolean bl = vis = valvis && !gp.isDrawTable;
            if (vis) {
                c = egp.getAxisColor(1);
                Utils.setStroke(g, c, 1, 1.0f);
                db.drawLine(gp.gRect1.x + delx, gp.gRect1.y + gp.gRect1.height, gp.gRect1.x + delx, gp.gRect1.y + gp.gRect1.height + (double)gp.tickLen, c);
                db.drawGridLineCategoryV(gp.gRect1.x + delx);
            }
            String value = egc.getNameString();
            x = gp.gRect1.x + delx;
            y = gp.gRect1.y + gp.gRect1.height + (double)gp.tickLen;
            gp.GFV_XLABEL.outText(x, y, value, vis);
            for (int j = 0; j < gp.serNum; ++j) {
                float bw;
                int bs;
                Color bc;
                Color tmpc;
                ExtGraphSery egs = egc.getExtGraphSery(gp.serNames.get(j));
                if (egs.isNull()) continue;
                double val = egs.getValue();
                double tmp = val - gp.baseValue;
                double len = dely * (double)gp.tickNum * (tmp - gp.minValue) / (gp.maxValue * gp.coorScale);
                double lb = gp.isDrawTable && gp.serNum == 1 ? (double)db.getDataTableX(i) - seriesWidth / 2.0 : gp.gRect1.x + (double)(i + 1) * categorySpan + (double)(i * gp.serNum + j) * seriesWidth;
                if (len >= 0.0) {
                    tmpc = !gp.isMultiSeries ? db.getColor(i) : db.getColor(j);
                    bc = egp.getAxisColor(5);
                    bs = 1;
                    bw = 1.0f;
                    Utils.draw2DRect(g, lb, gp.valueBaseLine - len, seriesWidth, len, bc, bs, bw, egp.isDrawShade(), egp.isRaisedBorder(), db.getTransparent(), db.getChartColor(tmpc), true);
                    db.htmlLink(lb, gp.valueBaseLine - len, seriesWidth, len, htmlLink, egc.getNameString(), egs);
                } else {
                    tmpc = !gp.isMultiSeries ? db.getColor(i) : db.getColor(j);
                    bc = egp.getAxisColor(5);
                    bs = 1;
                    bw = 1.0f;
                    Utils.draw2DRect(g, lb, gp.valueBaseLine, seriesWidth, Math.abs(len), bc, bs, bw, egp.isDrawShade(), egp.isRaisedBorder(), db.getTransparent(), db.getChartColor(tmpc), true);
                    db.htmlLink(lb, gp.valueBaseLine, seriesWidth, Math.abs(len), htmlLink, egc.getNameString(), egs);
                }
                if (!gp.dispValueOntop || egs.isNull() || !valvis) continue;
                sval = db.getDispValue(egc, egs, gp.serNum);
                x = lb + seriesWidth / 2.0;
                y = gp.valueBaseLine - len;
                c = !gp.isMultiSeries ? db.getColor(i) : db.getColor(j);
                ValueLabel vl = len < 0.0 ? new ValueLabel(sval, new Point2D.Double(x, y), c, 2) : new ValueLabel(sval, new Point2D.Double(x, y), c, 1);
                labelList.add(vl);
            }
        }
        db.outLabels();
        db.drawLine(gp.gRect1.x, gp.valueBaseLine, gp.gRect1.x + gp.gRect1.width, gp.valueBaseLine, egp.getAxisColor(1));
        db.drawLine(gp.gRect1.x + gp.gRect1.width, gp.valueBaseLine, gp.gRect1.x + gp.gRect1.width + coorWidth, gp.valueBaseLine - coorWidth, egp.getAxisColor(1));
        if (!gp.isMultiSeries) {
            return gp.catNum;
        }
        return gp.serNum;
    }
}

