/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.cellset.graph.draw;

import com.scudata.cellset.graph.draw.DrawBase;
import com.scudata.cellset.graph.draw.ExtGraphCategory;
import com.scudata.cellset.graph.draw.ExtGraphProperty;
import com.scudata.cellset.graph.draw.ExtGraphSery;
import com.scudata.cellset.graph.draw.GraphParam;
import com.scudata.cellset.graph.draw.ValueLabel;
import com.scudata.chart.Utils;
import com.scudata.common.StringUtils;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Vector;

public class DrawColStacked
extends DrawBase {
    public void draw(StringBuffer htmlLink) {
        DrawColStacked.drawing(this, htmlLink);
    }

    public static int drawing(DrawBase db, StringBuffer htmlLink) {
        return DrawColStacked.drawing(db, htmlLink, false);
    }

    public static int drawing(DrawBase db, StringBuffer htmlLink, boolean is2Y) {
        double y;
        double x;
        double seriesWidth;
        double categorySpan;
        GraphParam gp = db.gp;
        ExtGraphProperty egp = db.egp;
        Graphics2D g = db.g;
        gp.maxValue = gp.maxPositive;
        gp.minValue = gp.minNegative;
        gp.coorWidth = 0;
        db.initGraphInset();
        db.createCoorValue();
        db.drawLegend(htmlLink);
        db.drawTitle();
        db.drawLabel();
        db.keepGraphSpace();
        db.adjustCoorInset();
        gp.graphRect = new Rectangle2D.Double(gp.leftInset, gp.topInset, gp.graphWidth - gp.leftInset - gp.rightInset, gp.graphHeight - gp.topInset - gp.bottomInset);
        if (gp.graphRect.width < 10.0 || gp.graphRect.height < 10.0) {
            return -1;
        }
        if (gp.coorWidth < 0 || gp.coorWidth > 10000) {
            gp.coorWidth = 0;
        }
        ArrayList tmpCat = null;
        if (is2Y) {
            tmpCat = egp.category2;
            egp.category2 = null;
        }
        int serNum = 1;
        if (egp.category2 != null) {
            serNum = 2;
        }
        if (gp.barDistance > 0.0) {
            double maxCatSpan = (gp.graphRect.width - (double)((float)(serNum * gp.catNum) * 1.0f)) / (double)((float)gp.catNum + 1.0f);
            categorySpan = gp.barDistance <= maxCatSpan ? gp.barDistance : maxCatSpan;
            seriesWidth = (gp.graphRect.width - (double)(gp.catNum + 1) * categorySpan) / (double)(serNum * gp.catNum);
        } else {
            seriesWidth = gp.graphRect.width / ((double)(gp.catNum + 1) * gp.categorySpan / 100.0 + (double)gp.coorWidth / 200.0 + (double)(gp.catNum * serNum));
            categorySpan = seriesWidth * (gp.categorySpan / 100.0);
        }
        double coorWidth = seriesWidth * ((double)gp.coorWidth / 200.0);
        double dely = (gp.graphRect.height - coorWidth) / (double)gp.tickNum;
        gp.gRect1 = (Rectangle2D.Double)gp.graphRect.clone();
        gp.gRect2 = (Rectangle2D.Double)gp.graphRect.clone();
        db.drawGraphRect();
        for (int i = 0; i <= gp.tickNum; ++i) {
            db.drawGridLine(dely, i);
            Number coory = (Number)gp.coorValue.get(i);
            String scoory = db.getFormattedValue(coory.doubleValue());
            x = gp.gRect1.x - (double)gp.tickLen;
            y = gp.gRect1.y + gp.gRect1.height - (double)i * dely;
            gp.GFV_YLABEL.outText(x, y, scoory);
            if (coory.doubleValue() != gp.baseValue + gp.minValue) continue;
            gp.valueBaseLine = gp.gRect1.y + gp.gRect1.height - (double)i * dely;
        }
        db.drawWarnLine();
        ArrayList cats = egp.categories;
        int cc = cats.size();
        for (int i = 0; i < cc; ++i) {
            double lb;
            boolean vis;
            ExtGraphCategory egc = (ExtGraphCategory)cats.get(i);
            double delx = (double)(i + 1) * categorySpan + (double)i * seriesWidth * (double)serNum + seriesWidth * (double)serNum / 2.0;
            boolean valvis = i % (gp.graphXInterval + 1) == 0;
            boolean bl = vis = valvis && !gp.isDrawTable;
            if (vis) {
                Color c = egp.getAxisColor(1);
                Utils.setStroke(g, c, 1, 1.0f);
                db.drawLine(gp.gRect1.x + delx, gp.gRect1.y + gp.gRect1.height, gp.gRect1.x + delx, gp.gRect1.y + gp.gRect1.height + (double)gp.tickLen, c);
                db.drawGridLineCategoryV(gp.gRect1.x + delx);
            }
            String value = egc.getNameString();
            x = gp.gRect1.x + delx;
            y = gp.gRect1.y + gp.gRect1.height + (double)gp.tickLen;
            gp.GFV_XLABEL.outText(x, y, value, vis);
            double positiveBase = gp.valueBaseLine;
            double negativeBase = gp.valueBaseLine;
            if (egp.category2 == null) {
                lb = gp.isDrawTable ? (double)db.getDataTableX(i) - seriesWidth / 2.0 : gp.gRect1.x + (double)(i + 1) * categorySpan + (double)i * seriesWidth;
                DrawColStacked._$1(0, gp.serNames, egc, dely, db, lb, positiveBase, seriesWidth, htmlLink, negativeBase, coorWidth, valvis);
                continue;
            }
            lb = gp.isDrawTable ? (double)db.getDataTableX(i) - seriesWidth : gp.gRect1.x + (double)(i + 1) * categorySpan + (double)(i * serNum + 0) * seriesWidth;
            DrawColStacked._$1(0, gp.serNames, egc, dely, db, lb, positiveBase, seriesWidth, htmlLink, negativeBase, coorWidth, valvis);
            lb = gp.isDrawTable ? (double)db.getDataTableX(i) : gp.gRect1.x + (double)(i + 1) * categorySpan + (double)(i * serNum + 1) * seriesWidth;
            egc = (ExtGraphCategory)egp.category2.get(i);
            DrawColStacked._$1(gp.serNames.size(), gp.serNames2, egc, dely, db, lb, positiveBase, seriesWidth, htmlLink, negativeBase, coorWidth, valvis);
        }
        db.outLabels();
        db.drawLine(gp.gRect1.x, gp.valueBaseLine, gp.gRect1.x + gp.gRect1.width, gp.valueBaseLine, egp.getAxisColor(1));
        db.drawLine(gp.gRect1.x + gp.gRect1.width, gp.valueBaseLine, gp.gRect1.x + gp.gRect1.width + coorWidth, gp.valueBaseLine - coorWidth, egp.getAxisColor(1));
        if (is2Y) {
            egp.category2 = tmpCat;
        }
        return gp.serNum;
    }

    private static void _$1(int serNumBase, Vector serNames, ExtGraphCategory egc, double dely, DrawBase db, double dlb, double positiveBase, double seriesWidth, StringBuffer htmlLink, double negativeBase, double coorWidth, boolean vis) {
        GraphParam gp = db.gp;
        ExtGraphProperty egp = db.egp;
        Graphics2D g = db.g;
        ArrayList<ValueLabel> labelList = db.labelList;
        double lb = Math.round(dlb);
        int bs = 1;
        float bw = 1.0f;
        int serNum = serNames.size();
        for (int j = 0; j < serNum; ++j) {
            String sval;
            double val;
            double tmp;
            double len;
            ExtGraphSery egs = egc.getExtGraphSery(serNames.get(j));
            if (egs.isNull() || (len = (double)Math.round(dely * (double)gp.tickNum * ((tmp = (val = egs.getValue())) - gp.minValue) / (gp.maxValue * gp.coorScale))) == 0.0) continue;
            Color bc = egp.getAxisColor(5);
            Color tmpc = db.getColor(j + serNumBase);
            if (len > 0.0) {
                Utils.draw2DRect(g, lb, positiveBase - len, seriesWidth, len, bc, bs, bw, egp.isDrawShade(), egp.isRaisedBorder(), db.getTransparent(), db.getChartColor(tmpc), true);
                db.htmlLink(lb, positiveBase - len, seriesWidth, len, htmlLink, egc.getNameString(), egs);
            } else {
                Utils.draw2DRect(g, lb, negativeBase, seriesWidth, Math.abs(len), bc, bs, bw, egp.isDrawShade(), egp.isRaisedBorder(), db.getTransparent(), db.getChartColor(tmpc), true);
                db.htmlLink(lb, negativeBase, seriesWidth, Math.abs(len), htmlLink, egc.getNameString(), egs);
            }
            if (len > 0.0) {
                double[] ptx1 = new double[]{lb, lb + coorWidth, lb + coorWidth + seriesWidth, lb + seriesWidth};
                double[] pty1 = new double[]{positiveBase - len, positiveBase - len - coorWidth, positiveBase - len - coorWidth, positiveBase - len};
                g.setColor(db.getColor(j + serNumBase));
                Shape poly = Utils.newPolygon2D(ptx1, pty1);
                g.fill(poly);
                db.drawPolygon(ptx1, pty1, 4, egp.getAxisColor(5));
            }
            double temp = 0.0;
            temp = len > 0.0 ? positiveBase : negativeBase;
            double[] ptx2 = new double[]{lb + seriesWidth, lb + seriesWidth, lb + seriesWidth + coorWidth, lb + seriesWidth + coorWidth};
            double[] pty2 = new double[]{temp, temp - len, temp - len - coorWidth, temp - coorWidth};
            Color clr = db.getColor(j + serNumBase);
            clr = clr.darker();
            g.setColor(clr);
            Shape poly = Utils.newPolygon2D(ptx2, pty2);
            g.fill(poly);
            db.drawPolygon(ptx2, pty2, 4, egp.getAxisColor(5));
            String percentFmt = null;
            if (vis && (gp.dispValueType == 3 || gp.dispValueType == 6)) {
                percentFmt = StringUtils.isValidString(gp.dataMarkFormat) ? gp.dataMarkFormat : "0.00%";
            }
            ValueLabel vl = null;
            double x = lb + seriesWidth / 2.0;
            if (len > 0.0) {
                sval = null;
                if (percentFmt != null) {
                    sval = db.getFormattedValue(egs.getValue() / egc.getPositiveSumSeries(), percentFmt);
                    if (egc != null && gp.dispValueType == 6) {
                        sval = DrawColStacked.getDispName(egc, egs, serNum) + "," + sval;
                    }
                } else if (egc != null && gp.dispValueType != 1) {
                    sval = db.getDispValue(egc, egs, gp.serNum);
                }
                if (StringUtils.isValidString(sval)) {
                    vl = new ValueLabel(sval, new Point2D.Double(x, positiveBase - len / 2.0), gp.GFV_VALUE.color, 5);
                }
                positiveBase -= len;
            } else {
                sval = null;
                if (percentFmt != null) {
                    sval = db.getFormattedValue(egs.getValue() / egc.getNegativeSumSeries(), percentFmt);
                    if (egc != null && gp.dispValueType == 6) {
                        sval = DrawColStacked.getDispName(egc, egs, serNum) + "," + sval;
                    }
                } else if (egc != null && gp.dispValueType != 1) {
                    sval = db.getDispValue(egc, egs, gp.serNum);
                }
                if (StringUtils.isValidString(sval)) {
                    vl = new ValueLabel(sval, new Point2D.Double(x, negativeBase - len / 2.0), gp.GFV_VALUE.color, 5);
                }
                negativeBase -= len;
            }
            if (vl == null) continue;
            labelList.add(vl);
        }
        if (gp.dispStackSumValue && vis) {
            double y;
            double x;
            double val = db.getScaledValue(egc.getPositiveSumSeries(), true);
            ValueLabel vl = null;
            if (val > 0.0) {
                String sval = db.getFormattedValue(val);
                x = lb + seriesWidth / 2.0;
                y = positiveBase - 3.0;
                vl = new ValueLabel(sval, new Point2D.Double(x, y), gp.GFV_VALUE.color, gp.GFV_VALUE._$3);
            }
            if ((val = db.getScaledValue(egc.getNegativeSumSeries(), true)) < 0.0) {
                String sval = db.getFormattedValue(val);
                x = lb + seriesWidth / 2.0;
                y = negativeBase + 3.0;
                vl = new ValueLabel(sval, new Point2D.Double(x, y), gp.GFV_VALUE.color, 2);
            }
            if (vl != null) {
                labelList.add(vl);
            }
        }
    }
}

