/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.cellset.graph.draw;

import com.scudata.cellset.graph.draw.DrawBase;
import com.scudata.cellset.graph.draw.ExtGraphCategory;
import com.scudata.cellset.graph.draw.ExtGraphProperty;
import com.scudata.cellset.graph.draw.ExtGraphSery;
import com.scudata.cellset.graph.draw.GraphParam;
import com.scudata.cellset.graph.draw.ValuePoint;
import com.scudata.chart.Utils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Arc2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

public class DrawRadar
extends DrawBase {
    public void draw(StringBuffer htmlLink) {
        DrawRadar.drawing(this, htmlLink);
    }

    public static void drawing(DrawBase db, StringBuffer htmlLink) {
        double y;
        double x;
        double tmpInt;
        GraphParam gp = db.gp;
        ExtGraphProperty egp = db.egp;
        Graphics2D g = db.g;
        int VALUE_RADIUS = db.VALUE_RADIUS;
        ArrayList<ValuePoint> pointList = db.pointList;
        double thick = 2.5;
        db.initGraphInset();
        db.createCoorValue();
        db.drawLegend(htmlLink);
        db.drawTitle();
        db.drawLabel();
        db.keepGraphSpace();
        double tmpInt1 = gp.graphWidth - gp.leftInset - gp.rightInset;
        double tmpInt2 = gp.graphHeight - gp.topInset - gp.bottomInset;
        if (tmpInt1 < tmpInt2) {
            tmpInt = tmpInt1;
            gp.topInset = (int)((double)gp.topInset + (tmpInt2 - tmpInt1) / 2.0);
        } else {
            tmpInt = tmpInt2;
            gp.leftInset = (int)((double)gp.leftInset + (tmpInt1 - tmpInt2) / 2.0);
        }
        gp.graphRect = new Rectangle2D.Double(gp.leftInset, gp.topInset, tmpInt, tmpInt);
        double r = tmpInt / 2.0;
        double cx = (double)gp.leftInset + r;
        double cy = (double)gp.topInset + r;
        if (gp.graphRect.width < 10.0 || gp.graphRect.height < 10.0) {
            return;
        }
        gp.gRect1 = (Rectangle2D.Double)gp.graphRect.clone();
        gp.gRect2 = (Rectangle2D.Double)gp.graphRect.clone();
        Color backColor = gp.graphBackColor;
        Color foreColor = egp.getAxisColor(0);
        int style = 0;
        float weight = (float)thick;
        Rectangle2D.Double ellipseBounds = new Rectangle2D.Double(cx - r, cy - r, 2.0 * r, 2.0 * r);
        double startAngle = 0.0;
        double extentAngle = 360.0;
        Utils.draw2DPie(g, ellipseBounds, startAngle, extentAngle, foreColor, style, weight, db.getTransparent(), db.getChartColor(backColor), 1);
        Arc2D.Double a2dd = null;
        a2dd = new Arc2D.Double(cx - r, cy - r, 2.0 * r, 2.0 * r, 0.0, 360.0, 1);
        g.setStroke(new BasicStroke(weight));
        db.drawShape(a2dd, foreColor);
        tmpInt = gp.catNum;
        double deltaAngle = 360.0 / tmpInt;
        ArrayList cats = egp.categories;
        int cc = cats.size();
        for (int i = 0; i < cc; ++i) {
            ExtGraphCategory egc = (ExtGraphCategory)cats.get(i);
            String cat = egc.getNameString();
            double angle = deltaAngle * (double)i + 90.0;
            double rAngle = Math.toRadians(angle);
            double x2 = cx + (r + thick) * Math.cos(rAngle);
            double y2 = cy - (r + thick) * Math.sin(rAngle);
            g.setStroke(new BasicStroke(1.0f));
            db.drawLine(cx, cy, x2, y2, egp.getAxisColor(6));
            db.drawOutCircleText(gp.GFV_XLABEL, cat, angle, x2, y2);
        }
        double deltaR = r / (double)gp.tickNum;
        BasicStroke gridStroke = db.getLineStroke(gp.gridLineStyle, 0.1f);
        for (int i = 0; i < gp.tickNum; ++i) {
            double dr = (double)i * deltaR;
            x = cx - dr;
            y = cy - dr;
            g.setColor(gp.gridColor);
            if (gridStroke != null) {
                g.setStroke(gridStroke);
                g.drawOval((int)x, (int)y, (int)dr * 2, (int)dr * 2);
            }
            Number coory = (Number)gp.coorValue.get(i);
            if (i == 0) {
                gp.baseValue = coory.doubleValue();
            }
            String scoory = db.getFormattedValue(coory.doubleValue());
            x = cx;
            y = cy - dr;
            gp.GFV_YLABEL.outText(x, y, scoory);
        }
        Point2D.Double[] prePoints = new Point2D.Double[gp.serNum];
        Point2D.Double[] lastPoint = new Point2D.Double[gp.serNum];
        Point2D.Double[] startPoints = new Point2D.Double[gp.serNum];
        for (int i = 0; i < cc; ++i) {
            ExtGraphCategory egc = (ExtGraphCategory)cats.get(i);
            for (int j = 0; j < gp.serNum; ++j) {
                ExtGraphSery egs = egc.getExtGraphSery(gp.serNames.get(j));
                double val = egs.getValue();
                double tmp = val - gp.baseValue;
                double len = deltaR * (double)gp.tickNum * (tmp - gp.minValue) / (gp.maxValue * gp.coorScale);
                double angle = deltaAngle * (double)i + 90.0;
                double rAngle = Math.toRadians(angle);
                r = len;
                x = cx + r * Math.cos(rAngle);
                y = cy - r * Math.sin(rAngle);
                Point2D.Double pt = egs.isNull() ? null : new Point2D.Double(x, y);
                if (gp.drawLineDot && pt != null) {
                    double ww;
                    backColor = db.getColor(j);
                    double xx = pt.x - (double)VALUE_RADIUS;
                    double yy = pt.y - (double)VALUE_RADIUS;
                    double hh = ww = (double)(2 * VALUE_RADIUS);
                    ValuePoint vp = new ValuePoint(pt, backColor);
                    pointList.add(vp);
                    db.htmlLink(xx, yy, ww, hh, htmlLink, egc.getNameString(), egs);
                }
                if (i == 0) {
                    startPoints[j] = pt;
                } else if (i == gp.catNum - 1) {
                    g.setColor(db.getColor(j));
                    g.setStroke(new BasicStroke(1.0f));
                    db.drawLine(prePoints[j], pt);
                    db.drawLine(startPoints[j], pt);
                } else {
                    g.setColor(db.getColor(j));
                    g.setStroke(new BasicStroke(1.0f));
                    if (egp.isIgnoreNull()) {
                        db.drawLine(lastPoint[j], pt);
                    } else {
                        db.drawLine(prePoints[j], pt);
                    }
                }
                prePoints[j] = pt;
                if (pt == null) continue;
                lastPoint[j] = pt;
            }
        }
        db.outPoints();
        db.outLabels();
    }
}

