/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.cellset.graph.draw;

import com.scudata.cellset.graph.draw.DrawBase;
import com.scudata.chart.Utils;
import com.scudata.common.Logger;
import com.scudata.common.StringUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;

public class GraphFontView {
    public static final byte FONT_TITLE = 0;
    public static final byte FONT_LEGEND = 1;
    public static final byte FONT_XLABEL = 2;
    public static final byte FONT_YLABEL = 3;
    public static final byte FONT_XTITLE = 4;
    public static final byte FONT_YTITLE = 5;
    public static final byte FONT_VALUE = 6;
    public static final byte TEXT_FIXED = 0;
    public static final byte TEXT_ON_TOP = 1;
    public static final byte TEXT_ON_BOTTOM = 2;
    public static final byte TEXT_ON_LEFT = 3;
    public static final byte TEXT_ON_RIGHT = 4;
    public static final byte TEXT_ON_CENTER = 5;
    DrawBase _$4;
    public String text = "";
    public String text2 = "";
    public Font font;
    public Color color;
    public boolean vertical = false;
    public int angle;
    byte _$3 = 0;
    private boolean _$2 = true;
    ArrayList _$1 = new ArrayList();

    public GraphFontView(DrawBase drawBase) {
        this._$4 = drawBase;
        this._$2 = drawBase.egp.isShowOverlapText();
    }

    public static byte reverseDirection(byte direction) {
        switch (direction) {
            case 0: {
                return 0;
            }
            case 5: {
                return 5;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 4;
            }
        }
        return 3;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public void setIntersect(boolean allowIntersect) {
        this._$2 = allowIntersect;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setVertical(boolean vertical) {
        this.vertical = vertical;
    }

    public void setAngle(int angle) {
        if (Math.abs(angle) > 90) {
            int tmp = Math.abs(angle) % 90;
            Logger.warn("Rotate angle must between [0,90], " + tmp + " will be used instead of " + angle);
            this.angle = tmp;
        } else {
            this.angle = angle;
        }
    }

    public void setText(String text) {
        if (text == null) {
            return;
        }
        if (this._$4.egp.is2YGraph()) {
            int pos = -1;
            if (pos < 0) {
                pos = text.indexOf(59);
            }
            if (pos < 0) {
                this.text = text;
            } else {
                this.text = text.substring(0, pos);
                this.text2 = text.substring(pos + 1);
            }
        } else {
            this.text = text;
        }
    }

    public void setTextPosition(byte pos) {
        this._$3 = pos;
    }

    public void outText(double x, double y) {
        this.outText(x, y, this.text);
    }

    public void outText(double x, double y, String text, boolean visible) {
        if (visible) {
            this.outText(x, y, text);
        }
    }

    public void outText(double x, double y, String text, boolean visible, byte direction) {
        if (visible) {
            this.outText(x, y, text, direction);
        }
    }

    public boolean outText(double x, double y, String text) {
        return this.outText(x, y, text, this._$3);
    }

    private Rectangle _$1(Rectangle newRect) {
        for (int i = this._$1.size() - 1; i >= 0; --i) {
            Rectangle rect = (Rectangle)this._$1.get(i);
            if (!rect.intersects(newRect)) continue;
            return rect;
        }
        return null;
    }

    public boolean outText(double x, double y, String text, Color tmpColor) {
        return this.outText(x, y, text, this._$3, tmpColor);
    }

    public boolean outText(double x, double y, String text, byte direction) {
        return this.outText(x, y, text, direction, this.color);
    }

    public boolean outText(double x, double y, String text, byte direction, Color textColor) {
        if (text == null || text.trim().length() == 0) {
            return false;
        }
        if (this.font.getSize() == 0) {
            return false;
        }
        Rectangle TA = this.getTextSize(text);
        if (this.vertical || this.angle == 0) {
            TA = this.getTextSize(text);
        }
        FontMetrics fm = this._$4.g.getFontMetrics(this.font);
        Point rop = this._$1((int)x, (int)y, direction, TA, fm, text);
        TA.x = rop.x;
        TA.y = rop.y;
        if (textColor != this.color) {
            Rectangle rect = this._$1(TA);
            if (rect != null) {
                TA.y = TA.y <= rect.y ? rect.y - rect.height : rop.y + rect.height + this._$4.VALUE_RADIUS + 2;
            }
        } else if (!this._$2 && this._$1(TA) != null) {
            return false;
        }
        if (!this._$1.contains(TA)) {
            this._$1.add(TA);
        }
        this._$4.g.setColor(textColor);
        this._$4.g.setFont(this.font);
        Composite com = this._$4.g.getComposite();
        Utils.setGraphAntiAliasingOff(this._$4.g);
        x = TA.x;
        y = TA.y;
        if (this.vertical) {
            for (int i = 0; i < text.length(); ++i) {
                String ch = text.substring(i, i + 1);
                if ("()[]{}".indexOf(ch) >= 0) {
                    AffineTransform at = this._$4.g.getTransform();
                    double yy = y + (double)(i * (fm.getAscent() + 2));
                    yy = "([{".indexOf(ch) >= 0 ? (yy -= (double)(fm.getAscent() / 2)) : (yy -= (double)fm.getAscent());
                    AffineTransform at1 = AffineTransform.getTranslateInstance(x + 2.0, yy);
                    this._$4.g.transform(at1);
                    double rotateAngle = Math.toRadians(90.0);
                    AffineTransform at2 = AffineTransform.getRotateInstance(rotateAngle, 0.0, 0.0);
                    this._$4.g.transform(at2);
                    this._$4.g.setStroke(new BasicStroke(1.0f));
                    this._$4.g.drawString(ch, 0, 0);
                    this._$4.g.setTransform(at);
                    continue;
                }
                this._$4.g.drawString(ch, (int)x, (int)(y + (double)(i * (fm.getAscent() + 2))));
            }
        } else if (this.angle == 0) {
            this._$4.g.drawString(text, (int)x, (int)y);
        } else {
            double rotateAngle = Math.toRadians(-this.angle);
            AffineTransform at = this._$4.g.getTransform();
            AffineTransform at1 = AffineTransform.getRotateInstance(rotateAngle, x, y);
            this._$4.g.transform(at1);
            this._$4.g.setStroke(new BasicStroke(1.0f));
            this._$4.g.drawString(text, (int)x, (int)y);
            this._$4.g.setTransform(at);
        }
        Utils.setGraphAntiAliasingOn(this._$4.g);
        this._$4.g.setComposite(com);
        this._$4.g.setStroke(new BasicStroke(1.0E-5f));
        return true;
    }

    private Point _$1(int x, int y, byte direction, Rectangle TA, FontMetrics fm, String text) {
        if (direction == 0) {
            return new Point(x, y);
        }
        if (this.vertical) {
            switch (direction) {
                case 2: {
                    x -= TA.width / 2;
                    break;
                }
                case 1: {
                    x -= TA.width / 2;
                    y -= TA.height;
                    break;
                }
                case 3: {
                    x -= TA.width;
                    y -= TA.height / 2;
                    break;
                }
                case 4: {
                    y -= TA.height / 2;
                    break;
                }
                case 5: {
                    x -= TA.width / 2;
                    y -= TA.height / 2;
                }
            }
            y += fm.getAscent() + 2;
        } else if (this.angle == 0) {
            switch (direction) {
                case 2: {
                    x -= TA.width / 2;
                    y += TA.height;
                    break;
                }
                case 1: {
                    x -= TA.width / 2;
                    break;
                }
                case 3: {
                    x -= TA.width;
                    y += TA.height / 2;
                    break;
                }
                case 4: {
                    y += TA.height / 2;
                    break;
                }
                case 5: {
                    x -= TA.width / 2;
                    y += TA.height / 2;
                }
            }
        } else if (this.angle == 90) {
            switch (direction) {
                case 2: {
                    x += TA.width / 2;
                    y += TA.height;
                    break;
                }
                case 1: {
                    x += TA.width / 2;
                    break;
                }
                case 3: {
                    y += TA.height / 2;
                    break;
                }
                case 4: {
                    x += TA.width;
                    y += TA.height / 2;
                    break;
                }
                case 5: {
                    x += TA.width / 2;
                    y += TA.height / 2;
                }
            }
        } else {
            double rotateAngle = Math.toRadians(this.angle);
            FontMetrics tfm = this._$4.g.getFontMetrics(this.font);
            int tw = tfm.stringWidth(text);
            int th = tfm.getAscent();
            double dotLeft = (double)th * Math.sin(rotateAngle);
            double dotRight = (double)tw * Math.cos(rotateAngle);
            double halfW = TA.width / 2;
            double halfH = TA.height / 2;
            switch (direction) {
                case 2: {
                    x = (int)((double)x - dotRight);
                    y += TA.height;
                    break;
                }
                case 1: {
                    break;
                }
                case 3: {
                    x = (int)((double)x - dotRight);
                    y = (int)((double)y + halfH);
                    break;
                }
                case 4: {
                    x = (int)((double)x + dotLeft);
                    y = (int)((double)y + halfH);
                    break;
                }
                case 5: {
                    x = (int)((double)x - (halfW - dotLeft));
                    y = (int)((double)y + halfH);
                }
            }
        }
        int gap = 2;
        switch (direction) {
            case 2: {
                y += gap;
                break;
            }
            case 1: {
                y -= gap;
                break;
            }
            case 3: {
                x -= gap;
                break;
            }
            case 4: {
                x += gap;
            }
        }
        return new Point(x, y);
    }

    public Rectangle getTextSize() {
        return this.getTextSize(this.text);
    }

    public Rectangle getTextSize(String text) {
        if (text == null) {
            return new Rectangle();
        }
        if (this.vertical) {
            return this._$3(text);
        }
        if (this.angle % 180 == 0) {
            return this._$2(text);
        }
        return this._$1(text);
    }

    private Rectangle _$3(String text) {
        if (!StringUtils.isValidString(text)) {
            text = "A";
        }
        Rectangle area = new Rectangle();
        FontMetrics fm = this._$4.g.getFontMetrics(this.font);
        int hh = fm.getAscent() + 2;
        area.width = fm.stringWidth(text.substring(0, 1));
        area.height = hh * text.length();
        return area;
    }

    private Rectangle _$2(String text) {
        Rectangle area = new Rectangle();
        FontMetrics fm = this._$4.g.getFontMetrics(this.font);
        int hw = fm.stringWidth(text);
        int hh = fm.getAscent();
        area.width = hw;
        area.height = hh - fm.getLeading() - 2;
        return area;
    }

    private Rectangle _$1(String text) {
        if (!StringUtils.isValidString(text)) {
            text = "A";
        }
        Rectangle area = new Rectangle();
        FontMetrics fm = this._$4.g.getFontMetrics(this.font);
        int hw = fm.stringWidth(text);
        int hh = fm.getAscent();
        double djx = Math.sqrt(hw * hw + hh * hh);
        double textAngle = Math.atan((float)hh / ((float)hw * 1.0f));
        double tmpAngle = textAngle + Math.toRadians(this.angle);
        int ah = (int)(djx * Math.sin(tmpAngle));
        tmpAngle = Math.toRadians(this.angle) - textAngle;
        int aw = (int)(djx * Math.cos(tmpAngle));
        if (aw == 0) {
            aw = fm.stringWidth(text.substring(0, 1));
        }
        if (ah == 0) {
            ah = hh;
        }
        area.width = Math.abs(aw);
        area.height = Math.abs(ah);
        return area;
    }
}

