/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.chart;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;

public class Ball {
    public int bsize;
    public float x;
    public float y;
    public float Vx = 0.1f;
    public float Vy = 0.05f;
    public int nImgs = 5;
    public BufferedImage[] imgs;
    public int index = (int)(Math.random() * (double)(this.nImgs - 1));
    private final float inelasticity = 0.96f;
    private final float Ax = 0.0f;
    private final float Ay = 2.0E-4f;
    private final float Ar = 0.9f;
    private final int UP = 0;
    private final int DOWN = 1;
    private int indexDirection = 0;
    private boolean collision_x;
    private boolean collision_y;
    private float jitter;
    private Color color;
    private boolean isSelected;

    public Ball(Color color, int bsize) {
        this.color = color;
        this.makeImages(bsize);
    }

    public void makeImages(int bsize) {
        bsize = 230;
        this.bsize = bsize * 2;
        int R = bsize;
        byte[] data = new byte[R * 2 * R * 2];
        int maxr = 0;
        int Y = 2 * R;
        while (--Y >= 0) {
            int x0 = (int)(Math.sqrt(R * R - (Y - R) * (Y - R)) + 0.5);
            int p = Y * (R * 2) + R - x0;
            int X = -x0;
            while (X < x0) {
                int x = X + 15;
                int y = Y - R + 15;
                int r = (int)(Math.sqrt(x * x + y * y) + 0.5);
                if (r > maxr) {
                    maxr = r;
                }
                data[p++] = r <= 0 ? (byte)1 : (byte)r;
                ++X;
            }
        }
        this.imgs = new BufferedImage[this.nImgs];
        int bg = 255;
        int count = 256;
        byte[] red = new byte[count];
        red[0] = (byte)bg;
        byte[] green = new byte[count];
        green[0] = (byte)bg;
        byte[] blue = new byte[count];
        blue[0] = (byte)bg;
        int r = 0;
        while (r < this.imgs.length) {
            float b = 0.5f + ((float)r + 1.0f) / (float)this.imgs.length / 2.0f;
            int i = maxr;
            while (i >= 1) {
                float d = (float)i / (float)maxr;
                int index = i--;
                red[index] = (byte)this.blend(this.blend(this.color.getRed(), 255, d), bg, b);
                green[index] = (byte)this.blend(this.blend(this.color.getGreen(), 255, d), bg, b);
                blue[index] = (byte)this.blend(this.blend(this.color.getBlue(), 255, d), bg, b);
            }
            if (maxr > 255) {
                maxr = 255;
            }
            IndexColorModel icm = new IndexColorModel(8, maxr + 1, red, green, blue, 0);
            DataBufferByte dbb = new DataBufferByte(data, data.length);
            int[] bandOffsets = new int[1];
            WritableRaster wr = Raster.createInterleavedRaster(dbb, R * 2, R * 2, R * 2, 1, bandOffsets, null);
            this.imgs[r] = new BufferedImage(icm, wr, icm.isAlphaPremultiplied(), null);
            ++r;
        }
    }

    private final int blend(int fg, int bg, float fgfactor) {
        return (int)((float)bg + (float)(fg - bg) * fgfactor);
    }

    public void step(long deltaT, int w, int h) {
        this.collision_x = false;
        this.collision_y = false;
        this.jitter = (float)Math.random() * 0.01f - 0.005f;
        this.x = (float)((double)this.x + ((double)(this.Vx * (float)deltaT) + 0.0 * (double)deltaT * (double)deltaT));
        this.y = (float)((double)this.y + ((double)(this.Vy * (float)deltaT) + (double)1.0E-4f * (double)deltaT * (double)deltaT));
        if (this.x <= 0.0f) {
            this.x = 0.0f;
            this.Vx = -this.Vx * 0.96f + this.jitter;
            this.collision_x = true;
        }
        if (this.x + (float)this.bsize >= (float)w) {
            this.x = w - this.bsize;
            this.Vx = -this.Vx * 0.96f + this.jitter;
            this.collision_x = true;
        }
        if (this.y <= 0.0f) {
            this.y = 0.0f;
            this.Vy = -this.Vy * 0.96f + this.jitter;
            this.collision_y = true;
        }
        if (this.y + (float)this.bsize >= (float)h) {
            this.y = h - this.bsize;
            this.Vx *= 0.96f;
            this.Vy = -this.Vy * 0.96f + this.jitter;
            this.collision_y = true;
        }
        this.Vy += 2.0E-4f * (float)deltaT;
        this.Vx += 0.0f * (float)deltaT;
        if (this.indexDirection == 0) {
            ++this.index;
        }
        if (this.indexDirection == 1) {
            --this.index;
        }
        if (this.index + 1 == this.nImgs) {
            this.indexDirection = 1;
        }
        if (this.index == 0) {
            this.indexDirection = 0;
        }
    }
}

