/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.chart;

import com.scudata.chart.ICoor;
import com.scudata.chart.element.EnumAxis;
import com.scudata.chart.element.NumericAxis;
import com.scudata.chart.element.TickAxis;
import java.awt.geom.Point2D;

public class CartesianCoor
implements ICoor {
    TickAxis a1;
    TickAxis a2;

    @Override
    public void setAxis1(TickAxis axis) {
        this.a1 = axis;
    }

    @Override
    public TickAxis getAxis1() {
        return this.a1;
    }

    public TickAxis getXAxis() {
        if (this.a1.getLocation() == 1) {
            return this.a1;
        }
        return this.a2;
    }

    @Override
    public void setAxis2(TickAxis axis) {
        this.a2 = axis;
    }

    @Override
    public TickAxis getAxis2() {
        return this.a2;
    }

    public TickAxis getYAxis() {
        if (this.a1.getLocation() == 2) {
            return this.a1;
        }
        return this.a2;
    }

    @Override
    public Point2D getNumericPoint(Object val1, Object val2) {
        double i1 = this.a1.getValueLen(val1);
        double i2 = this.a2.getValueLen(val2);
        return new Point2D.Double(i1, i2);
    }

    @Override
    public Point2D getScreenPoint(Point2D numericPoint) {
        double y;
        double x;
        double i1 = numericPoint.getX();
        double i2 = numericPoint.getY();
        if (this.getXAxis() == this.a1) {
            x = this.a1.getLeftX() + i1;
            y = this.a2.getBottomY() - i2;
        } else {
            x = this.a2.getLeftX() + i2;
            y = this.a1.getBottomY() - i1;
        }
        return new Point2D.Double(x, y);
    }

    @Override
    public Point2D getScreenPoint(Object val1, Object val2) {
        return this.getScreenPoint(this.getNumericPoint(val1, val2));
    }

    public int get3DShift() {
        boolean is3D;
        boolean bl = is3D = this.a1.is3D || this.a2.is3D;
        if (!is3D) {
            return 0;
        }
        int maxShift = 60;
        EnumAxis ea = this.getEnumAxis();
        int shift = ea == null ? (int)this.a1.getEngine().getYPixel(this.a1.threeDThickRatio) : (int)(ea.getSeriesWidth() * ea.threeDThickRatio);
        return Math.min(shift, maxShift);
    }

    protected static TickAxis getAxis(ICoor coor, Class axisType) {
        TickAxis axis = coor.getAxis1();
        if (axisType.isInstance(axis)) {
            return axis;
        }
        axis = coor.getAxis2();
        if (axisType.isInstance(axis)) {
            return axis;
        }
        return null;
    }

    @Override
    public NumericAxis getNumericAxis() {
        TickAxis axis = CartesianCoor.getAxis(this, NumericAxis.class);
        if (axis != null) {
            return (NumericAxis)axis;
        }
        return null;
    }

    @Override
    public EnumAxis getEnumAxis() {
        TickAxis axis = CartesianCoor.getAxis(this, EnumAxis.class);
        if (axis != null) {
            return (EnumAxis)axis;
        }
        return null;
    }

    public String toString() {
        return "CartesianCoor Axis1:" + this.a1.getName() + " Axis2:" + this.a2.getName();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CartesianCoor) {
            CartesianCoor cc = (CartesianCoor)obj;
            return cc.a1.equals(this.a1) && cc.a2.equals(this.a2);
        }
        return false;
    }

    @Override
    public boolean isPolarCoor() {
        return false;
    }

    @Override
    public boolean isCartesianCoor() {
        return true;
    }

    @Override
    public boolean isEnumBased() {
        TickAxis ta = this.getAxis1();
        return ta.isEnumAxis();
    }
}

