/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.chart;

import java.awt.Color;

public class CubeColor {
    Color f1 = new Color(204, 213, 194);
    Color f2 = new Color(116, 126, 104);
    Color t1 = new Color(225, 230, 218);
    Color t2 = new Color(146, 158, 130);
    Color r1 = new Color(106, 115, 93);
    Color r2 = new Color(83, 90, 73);
    private Color origin = null;
    float f1s = 0.55f;
    float f2s = 0.65f;
    float t1s = 0.35f;
    float t2s = 0.85f;
    float r1s = 0.75f;
    float r2s = 0.35f;

    public CubeColor() {
    }

    public CubeColor(Color c1) {
        this.origin = c1;
        if (c1 != null) {
            this.f1 = this.getLight(this.f1s);
            this.f2 = this.getDark(this.f2s);
            this.t1 = this.getLight(this.t1s);
            this.t2 = this.getDark(this.t2s);
            this.r1 = this.getDark(this.r1s);
            this.r2 = this.getDark(this.r2s);
        } else {
            this.f1 = null;
            this.f2 = null;
            this.t1 = null;
            this.t2 = null;
            this.r1 = null;
            this.r2 = null;
        }
    }

    public Color getOrigin() {
        return this.origin;
    }

    public Color getF1() {
        return this.f1;
    }

    public Color getRelativeBrighter(String relative, int degree) {
        float deltaFactor = (float)degree * 0.05f;
        if (relative.equalsIgnoreCase("F1")) {
            return this.getLight(this.f1s - deltaFactor);
        }
        if (relative.equalsIgnoreCase("T1")) {
            return this.getLight(this.t1s - deltaFactor);
        }
        float tmpFactor = relative.equalsIgnoreCase("F2") ? this.f2s : (relative.equalsIgnoreCase("T2") ? this.t2s : (relative.equalsIgnoreCase("R1") ? this.r1s : this.r2s));
        return this.getDark(tmpFactor + deltaFactor);
    }

    public Color getRelativeDarker(String relative, int degree) {
        float deltaFactor = (float)degree * 0.05f;
        if (relative.equalsIgnoreCase("F1")) {
            return this.getLight(this.f1s + deltaFactor);
        }
        if (relative.equalsIgnoreCase("T1")) {
            return this.getLight(this.t1s + deltaFactor);
        }
        float tmpFactor = relative.equalsIgnoreCase("F2") ? this.f2s : (relative.equalsIgnoreCase("T2") ? this.t2s : (relative.equalsIgnoreCase("R1") ? this.r1s : this.r2s));
        return this.getDark(tmpFactor - deltaFactor);
    }

    public Color getF2() {
        return this.f2;
    }

    public Color getT1() {
        return this.t1;
    }

    public Color getT2() {
        return this.t2;
    }

    public Color getR1() {
        return this.r1;
    }

    public Color getR2() {
        return this.r2;
    }

    public Color getDark(float intensity) {
        return CubeColor.getDarkColor(this.origin, intensity);
    }

    public static Color getDazzelColor(Color origin) {
        CubeColor cc = new CubeColor(origin);
        if (cc.getT1().equals(origin)) {
            return cc.getT2();
        }
        if (cc.getR2().equals(origin)) {
            return cc.getR1();
        }
        return origin;
    }

    public static Color getDarkColor(Color sourceHexColor, float intensity) {
        intensity = intensity > 1.0f || intensity < 0.0f ? 1.0f : intensity;
        int _local2 = CubeColor.noAlphaRGB(sourceHexColor.getRGB());
        double _local3 = Math.floor(_local2 / 65536);
        double _local4 = Math.floor(((double)_local2 - _local3 * 65536.0) / 256.0);
        double _local5 = (double)_local2 - _local3 * 65536.0 - _local4 * 256.0;
        int r = (int)(_local3 * (double)intensity);
        int g = (int)(_local4 * (double)intensity);
        int b = (int)(_local5 * (double)intensity);
        return new Color(r, g, b);
    }

    public static int noAlphaRGB(int rgba) {
        int tmp = 0xFFFFFF;
        return tmp & rgba;
    }

    public Color getLight(float intensity) {
        return CubeColor.getLightColor(this.origin, intensity);
    }

    public static Color getLightColor(Color sourceHexColor, float intensity) {
        intensity = intensity > 1.0f || intensity < 0.0f ? 1.0f : intensity;
        int _local2 = CubeColor.noAlphaRGB(sourceHexColor.getRGB());
        double _local3 = Math.floor(_local2 / 65536);
        double _local4 = Math.floor(((double)_local2 - _local3 * 65536.0) / 256.0);
        double _local5 = (double)_local2 - _local3 * 65536.0 - _local4 * 256.0;
        int r = (int)(256.0 - (256.0 - _local3) * (double)intensity);
        int g = (int)(256.0 - (256.0 - _local4) * (double)intensity);
        int b = (int)(256.0 - (256.0 - _local5) * (double)intensity);
        return new Color(r, g, b);
    }

    public static void main(String[] args) {
        CubeColor cc = new CubeColor(new Color(255, 255, 255));
        System.out.println(cc.getF1());
        System.out.println(cc.getF2());
        System.out.println(cc.getT1());
        System.out.println(cc.getT2());
        System.out.println(cc.getR1());
        System.out.println(cc.getR2());
    }
}

