/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.chart;

import com.scudata.app.common.AppUtil;
import com.scudata.cellset.graph.IRedraw;
import com.scudata.chart.CartesianCoor;
import com.scudata.chart.DataElement;
import com.scudata.chart.ICoor;
import com.scudata.chart.IElement;
import com.scudata.chart.ObjectElement;
import com.scudata.chart.PolarCoor;
import com.scudata.chart.Utils;
import com.scudata.chart.edit.ElementInfo;
import com.scudata.chart.edit.ElementLib;
import com.scudata.chart.element.BackGround;
import com.scudata.chart.element.EnumAxis;
import com.scudata.chart.element.IMapAxis;
import com.scudata.chart.element.Legend;
import com.scudata.chart.element.TickAxis;
import com.scudata.chart.element.TimeAxis;
import com.scudata.common.ImageUtils;
import com.scudata.common.Logger;
import com.scudata.common.StringUtils;
import com.scudata.dm.Sequence;
import com.scudata.expression.ChartParam;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.Path2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;

public class Engine
implements IRedraw {
    private ArrayList<IElement> elements;
    private ArrayList<TickAxis> axisList = new ArrayList();
    private ArrayList<ICoor> coorList = new ArrayList();
    private ArrayList<DataElement> dataList = new ArrayList();
    private ArrayList<TimeAxis> timeList = new ArrayList();
    private transient ArrayList<Shape> allShapes = new ArrayList();
    private transient ArrayList<String> allLinks = new ArrayList();
    private transient ArrayList<String> allTitles = new ArrayList();
    private transient ArrayList<String> allTargets = new ArrayList();
    private transient int w;
    private transient int h;
    private transient Graphics2D g;
    private transient ArrayList textAreas = new ArrayList();
    private transient StringBuffer html;
    private transient double t_maxDate = 0.0;
    private transient double t_minDate = 9.223372036854776E18;

    public Engine() {
    }

    public void setElements(ArrayList<IElement> ies) {
        this.elements = ies;
    }

    public void setAxisList(ArrayList<TickAxis> tas) {
        this.axisList = tas;
    }

    public void setCoorList(ArrayList<ICoor> ics) {
        this.coorList = ics;
    }

    public void setDataList(ArrayList<DataElement> des) {
        this.dataList = des;
    }

    public void setTimeList(ArrayList<TimeAxis> tas) {
        this.timeList = tas;
    }

    public TimeAxis getTimeAxis(String name) {
        int i = 0;
        while (i < this.timeList.size()) {
            TimeAxis axis = this.timeList.get(i);
            if (axis.getName().equals(name)) {
                return axis;
            }
            ++i;
        }
        return null;
    }

    public ArrayList<Shape> getShapes() {
        return this.allShapes;
    }

    public Engine getFrameEngine(int frameCount, int frameIndex) {
        Engine e = this.clone();
        ArrayList<DataElement> des = new ArrayList<DataElement>();
        double timeSlice = (this.t_maxDate - this.t_minDate) * 1.0 / (double)frameCount;
        double frameTime = this.t_minDate + timeSlice * (double)frameIndex;
        for (DataElement de : this.dataList) {
            String timeAxis = de.getAxisTimeName();
            TimeAxis ta = e.getTimeAxis(timeAxis);
            if (ta.displayMark) {
                des.add(ta.getMarkElement(frameTime));
            }
            if (StringUtils.isValidString(timeAxis)) {
                e.elements.remove(de);
                des.add(de.getFrame(frameTime));
                continue;
            }
            des.add(de);
        }
        e.setDataList(des);
        return e;
    }

    public ArrayList<String> getLinks() {
        return this.allLinks;
    }

    public String getHtmlLinks() {
        return this.generateHyperLinks(true);
    }

    private ArrayList<Point> getShapeOutline(Shape shape) {
        FlatteningPathIterator iter = new FlatteningPathIterator(shape.getPathIterator(new AffineTransform()), 1.0);
        ArrayList<Point> points = new ArrayList<Point>();
        float[] coords = new float[6];
        while (!iter.isDone()) {
            iter.currentSegment(coords);
            int x = (int)coords[0];
            int y = (int)coords[1];
            points.add(new Point(x, y));
            iter.next();
        }
        return points;
    }

    private String getRectCoords(Rectangle rect) {
        int x = rect.x;
        int y = rect.y;
        int w = rect.width;
        int h = rect.height;
        int minimum = 10;
        if (w < minimum) {
            w = minimum;
        }
        if (h < minimum) {
            h = minimum;
        }
        String coords = String.valueOf(x) + "," + y + "," + (x + w) + "," + (y + h);
        return coords;
    }

    private String getPolyCoords(Shape shape) {
        StringBuffer buf = new StringBuffer();
        ArrayList<Point> polyPoints = this.getShapeOutline(shape);
        int i = 0;
        while (i < polyPoints.size()) {
            Point p = polyPoints.get(i);
            if (i > 0) {
                buf.append(",");
            }
            buf.append(String.valueOf(p.getX()) + "," + p.getY());
            ++i;
        }
        return buf.toString();
    }

    private String dealSpecialChar(String str) {
        return str;
    }

    private String getLinkHtml(String link, String shape, String coords, String title, Object target) {
        StringBuffer sb = new StringBuffer(128);
        sb.append("<area shape=\"").append(shape).append("\" coords=\"");
        sb.append(coords);
        if (StringUtils.isValidString(link)) {
            link = this.dealSpecialChar(link);
            sb.append("\" href=\"").append(link).append("\" target=\"").append(target);
        }
        if (StringUtils.isValidString(title)) {
            title = this.dealSpecialChar(title);
            sb.append("\" title=\"").append(title);
        }
        sb.append("\">\n");
        return sb.toString();
    }

    private String getLinkSvg(String link, String shape, String coords, String title, Object target) {
        StringBuffer sb = new StringBuffer(128);
        link = this.dealSpecialChar(link);
        sb.append("<a xlink:href=\"").append(link);
        sb.append("\" target=\"");
        sb.append(target);
        sb.append("\">\n");
        sb.append("<");
        sb.append(shape);
        sb.append(" ");
        sb.append(coords);
        sb.append("/>\n");
        sb.append("</a>");
        return sb.toString();
    }

    private String generateHyperLinks(boolean isHtml) {
        if (this.allLinks.isEmpty()) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < this.allShapes.size()) {
            String coords;
            String shape;
            String link = this.allLinks.get(i);
            Shape s = this.allShapes.get(i);
            String target = this.allTargets.get(i);
            String title = this.allTitles.get(i);
            if (isHtml) {
                if (s instanceof Rectangle) {
                    shape = "rect";
                    coords = this.getRectCoords((Rectangle)s);
                } else {
                    shape = "poly";
                    coords = this.getPolyCoords(s);
                }
                buf.append(this.getLinkHtml(link, shape, coords, title, target));
            } else {
                String style = " style=\"fill-opacity:0;stroke-width:0\"";
                if (s instanceof Rectangle) {
                    Rectangle r = (Rectangle)s;
                    shape = "rect";
                    coords = "x=\"" + r.x + "\" y=\"" + r.y + "\" width=\"" + r.width + "\" height=\"" + r.height + "\"" + style;
                } else {
                    shape = "polygon";
                    coords = "points=\"" + this.getPolyCoords(s) + "\"" + style;
                }
                buf.append(this.getLinkSvg(link, shape, coords, title, target));
            }
            ++i;
        }
        return buf.toString();
    }

    public boolean intersectTextArea(Rectangle rect) {
        int size = this.textAreas.size();
        int i = 0;
        while (i < size) {
            Rectangle tmp = (Rectangle)this.textAreas.get(i);
            if (tmp.intersects(rect)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void addTextArea(Rectangle rect) {
        this.textAreas.add(rect);
    }

    private IElement getElement(Sequence chartParams) {
        ChartParam cp = (ChartParam)chartParams.get(1);
        ElementInfo ei = ElementLib.getElementInfo(cp.getName());
        if (ei == null) {
            throw new RuntimeException("Unknown chart element: " + cp.getName());
        }
        ObjectElement oe = ei.getInstance();
        oe.loadProperties(chartParams);
        return oe;
    }

    public Engine(Sequence chartElements) {
        int size = chartElements.length();
        this.elements = new ArrayList();
        int i = 1;
        while (i <= size) {
            Sequence chartParams = (Sequence)chartElements.get(i);
            IElement e = this.getElement(chartParams);
            this.elements.add(e);
            ++i;
        }
        this.prepare();
    }

    public ArrayList<TickAxis> getAxisList() {
        return this.axisList;
    }

    public ArrayList<DataElement> getDataList() {
        return this.dataList;
    }

    public ArrayList<ICoor> getCoorList() {
        return this.coorList;
    }

    public TickAxis getAxisByName(String name) {
        int i = 0;
        while (i < this.axisList.size()) {
            TickAxis axis = this.axisList.get(i);
            if (axis.getName().equals(name)) {
                return axis;
            }
            ++i;
        }
        return null;
    }

    public IMapAxis getMapAxisByName(String name) {
        int i = 0;
        while (i < this.elements.size()) {
            IMapAxis ma;
            IElement e = this.elements.get(i);
            if (e instanceof IMapAxis && (ma = (IMapAxis)((Object)e)).getName().equals(name)) {
                return ma;
            }
            ++i;
        }
        return null;
    }

    private ArrayList<DataElement> getDataElementsOnAxis(String axis) {
        ArrayList<DataElement> al = new ArrayList<DataElement>();
        int size = this.dataList.size();
        int i = 0;
        while (i < size) {
            DataElement de = this.dataList.get(i);
            if (!de.isPhysicalCoor() && (de.getAxis1Name().equals(axis) || de.getAxis2Name().equals(axis))) {
                al.add(de);
            }
            ++i;
        }
        return al;
    }

    private ArrayList<DataElement> getDataElementsOnTime(String axis) {
        ArrayList<DataElement> al = new ArrayList<DataElement>();
        int size = this.dataList.size();
        int i = 0;
        while (i < size) {
            DataElement de = this.dataList.get(i);
            if (de.getAxisTimeName().equals(axis)) {
                al.add(de);
            }
            ++i;
        }
        return al;
    }

    private void prepare() {
        ArrayList<DataElement> al;
        TickAxis axis;
        IElement e;
        ArrayList<Legend> legends = new ArrayList<Legend>();
        int i = 0;
        while (i < this.elements.size()) {
            block34: {
                block33: {
                    e = this.elements.get(i);
                    e.setEngine(this);
                    if (!(e instanceof TickAxis)) break block33;
                    if (this.axisList.contains(e)) break block34;
                    this.axisList.add((TickAxis)e);
                }
                if (e instanceof Legend) {
                    legends.add((Legend)e);
                }
                if (e instanceof TimeAxis) {
                    this.timeList.add((TimeAxis)e);
                }
            }
            ++i;
        }
        i = 0;
        while (i < this.elements.size()) {
            e = this.elements.get(i);
            if (e instanceof DataElement) {
                DataElement de = (DataElement)e;
                this.dataList.add(de);
                if (!de.isPhysicalCoor()) {
                    String name1 = de.getAxis1Name();
                    String deName = de.getClass().getName();
                    int lastDot = deName.lastIndexOf(".");
                    deName = "Data element " + deName.substring(lastDot + 1);
                    if (!StringUtils.isValidString(name1)) {
                        throw new RuntimeException(String.valueOf(deName) + "'s property axis1 is not valid.");
                    }
                    String name2 = de.getAxis2Name();
                    if (!StringUtils.isValidString(name2)) {
                        throw new RuntimeException(String.valueOf(deName) + "'s property axis2 is not valid.");
                    }
                    TickAxis axis1 = this.getAxisByName(name1);
                    if (axis1 == null) {
                        throw new RuntimeException(String.valueOf(deName) + "'s axis1: " + name1 + " is not defined.");
                    }
                    TickAxis axis2 = this.getAxisByName(name2);
                    if (axis2 == null) {
                        throw new RuntimeException(String.valueOf(deName) + "'s axis2: " + name2 + " is not defined.");
                    }
                    int L1 = axis1.getLocation();
                    int L2 = axis2.getLocation();
                    ICoor coor = null;
                    RuntimeException re = new RuntimeException("Axis " + name1 + " and " + name2 + " can not construct a coordinate system.");
                    switch (L1) {
                        case 1: {
                            if (L2 != 2) {
                                throw re;
                            }
                            coor = new CartesianCoor();
                            break;
                        }
                        case 2: {
                            if (L2 != 1) {
                                throw re;
                            }
                            coor = new CartesianCoor();
                            break;
                        }
                        case 3: {
                            if (L2 != 4) {
                                throw re;
                            }
                            coor = new PolarCoor();
                            break;
                        }
                        case 4: {
                            if (L2 != 3) {
                                throw re;
                            }
                            coor = new PolarCoor();
                        }
                    }
                    coor.setAxis1(axis1);
                    coor.setAxis2(axis2);
                    if (!this.coorList.contains(coor)) {
                        this.coorList.add(coor);
                    }
                }
            }
            ++i;
        }
        i = 0;
        while (i < this.dataList.size()) {
            DataElement de = this.dataList.get(i);
            de.prepare();
            ++i;
        }
        i = 0;
        while (i < this.axisList.size()) {
            axis = this.axisList.get(i);
            if (axis instanceof EnumAxis) {
                al = this.getDataElementsOnAxis(axis.getName());
                axis.prepare(al);
                if (legends.size() == 1) {
                    Sequence seq = ((EnumAxis)axis).series;
                    if (seq == null || seq.length() == 0) {
                        seq = ((EnumAxis)axis).categories;
                    }
                    Legend legend = (Legend)legends.get(0);
                    if (legend.legendText.getLength() == 0) {
                        legend.legendText.setValue(seq);
                    }
                }
            }
            ++i;
        }
        i = 0;
        while (i < this.axisList.size()) {
            axis = this.axisList.get(i);
            if (!(axis instanceof EnumAxis)) {
                al = this.getDataElementsOnAxis(axis.getName());
                axis.prepare(al);
            }
            ++i;
        }
        i = 0;
        while (i < this.timeList.size()) {
            TimeAxis ta = this.timeList.get(i);
            al = this.getDataElementsOnTime(ta.getName());
            ta.prepare(al);
            this.t_maxDate = Math.max(ta.getMaxDate(), this.t_maxDate);
            this.t_minDate = Math.min(ta.getMinDate(), this.t_minDate);
            ++i;
        }
    }

    public ArrayList<IElement> getElements() {
        return this.elements;
    }

    public boolean isAnimate() {
        return !this.timeList.isEmpty();
    }

    private byte[] generateSVG(int w, int h) throws Exception {
        Object batikDom = Class.forName("org.apache.batik.dom.GenericDOMImplementation").newInstance();
        DOMImplementation domImpl = (DOMImplementation)AppUtil.invokeMethod(batikDom, "getDOMImplementation", new Object[0]);
        String svgNS = "http://www.w3.org/2000/svg";
        Document document = domImpl.createDocument(svgNS, "svg", null);
        Class<?> cls = Class.forName("org.apache.batik.svggen.SVGGraphics2D");
        Constructor<?> con = cls.getConstructor(Document.class);
        Object g2d = con.newInstance(document);
        this.draw((Graphics2D)g2d, 0, 0, w, h, null);
        boolean useCSS = true;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)baos, "UTF-8");
        AppUtil.invokeMethod(g2d, "stream", new Object[]{out, new Boolean(useCSS)}, new Class[]{Writer.class, Boolean.TYPE});
        ((Writer)out).flush();
        ((Writer)out).close();
        baos.close();
        byte[] bs = baos.toByteArray();
        String buf = new String(bs, "UTF-8");
        int n = buf.lastIndexOf("<svg");
        StringBuffer sb = new StringBuffer();
        sb.append(buf.substring(0, n + 4));
        String view = " width=\"" + w + "\" height=\"" + h + "\" ";
        sb.append(view);
        sb.append(buf.substring(n + 5));
        bs = sb.toString().getBytes("UTF-8");
        String links = this.generateHyperLinks(false);
        if (links != null) {
            buf = new String(bs, "UTF-8");
            n = buf.lastIndexOf("</svg");
            sb = new StringBuffer();
            sb.append(buf.substring(0, n));
            sb.append(links);
            sb.append("</svg>");
            bs = sb.toString().getBytes("UTF-8");
        }
        return bs;
    }

    public static byte[] getImageBytes(BufferedImage bi, byte imageFmt) throws Exception {
        byte[] bytes = null;
        switch (imageFmt) {
            case 2: {
                bytes = ImageUtils.writeGIF(bi);
                break;
            }
            case 1: {
                bytes = ImageUtils.writeJPEG(bi);
                break;
            }
            case 3: {
                bytes = ImageUtils.writePNG(bi);
                break;
            }
            case 6: {
                bytes = ImageUtils.writeGIF(bi);
            }
        }
        return bytes;
    }

    public BufferedImage calcBufferedImage(int w, int h, byte imageFmt) {
        BufferedImage bi = null;
        if (imageFmt == 2 || imageFmt == 3) {
            bi = new BufferedImage(w, h, 2);
        } else if (imageFmt == 1) {
            bi = new BufferedImage(w, h, 1);
        } else {
            imageFmt = (byte)3;
            bi = new BufferedImage(w, h, 2);
        }
        Graphics2D lg = (Graphics2D)bi.getGraphics();
        Utils.setIsGif(imageFmt == 2);
        if (imageFmt != 3 && imageFmt == 1) {
            lg.setColor(Color.white);
            lg.fillRect(0, 0, w, h);
        }
        this.draw(lg, 0, 0, w, h, null);
        return bi;
    }

    public byte[] calcImageBytes(int w, int h, byte imageFmt) {
        Graphics lg = null;
        try {
            int[] wh;
            if (w + h == 0 && (wh = this.getBackOrginalWH()) != null) {
                w = wh[0];
                h = wh[1];
            }
            if (imageFmt == 5) {
                byte[] byArray = this.generateSVG(w, h);
                return byArray;
            }
            BufferedImage bi = this.calcBufferedImage(w, h, imageFmt);
            byte[] byArray = Engine.getImageBytes(bi, imageFmt);
            return byArray;
        }
        catch (Exception x) {
            throw new RuntimeException(x);
        }
        finally {
            if (lg != null) {
                lg.dispose();
            }
        }
    }

    public int[] getBackOrginalWH() {
        int size = this.elements.size();
        int i = 0;
        while (i < size) {
            IElement e = this.elements.get(i);
            if (e instanceof BackGround) {
                BackGround bg = (BackGround)e;
                return bg.getOrginalWH();
            }
            ++i;
        }
        return null;
    }

    @Override
    public void repaint(Graphics2D g, int w, int h) {
        this.draw(g, 0, 0, w, h, null);
    }

    public void draw(Graphics2D g, int x, int y, int w, int h, StringBuffer html) {
        IElement e;
        long b = System.currentTimeMillis();
        this.g = g;
        this.w = w;
        this.h = h;
        this.html = html;
        if (x + y != 0) {
            g.translate(x, y);
        }
        Utils.setGraphAntiAliasingOn(g);
        this.textAreas.clear();
        ArrayList<IElement> bufElements = new ArrayList<IElement>();
        bufElements.addAll(this.elements);
        int size = bufElements.size();
        int i = 0;
        while (i < size) {
            e = this.elements.get(i);
            e.beforeDraw();
            ++i;
        }
        i = 0;
        while (i < size) {
            e = this.elements.get(i);
            if (e instanceof BackGround) {
                e.drawBack();
                bufElements.remove(e);
            }
            ++i;
        }
        this.drawElements(this.getAxisList());
        bufElements.removeAll(this.getAxisList());
        this.drawElements(this.getDataList());
        ArrayList<DataElement> des = this.getDataList();
        int i2 = 0;
        while (i2 < des.size()) {
            DataElement de = des.get(i2);
            ArrayList<Shape> ss = de.getShapes();
            if (ss != null) {
                this.allShapes.addAll(de.getShapes());
                ArrayList<String> links = de.getLinks();
                this.allLinks.addAll(links);
                this.allTitles.addAll(de.getTitles());
                this.allTargets.addAll(de.getTargets());
            }
            ++i2;
        }
        bufElements.removeAll(this.getDataList());
        this.drawElements(bufElements);
        if (x + y != 0) {
            g.translate(-x, -y);
        }
        long e2 = System.currentTimeMillis();
        Logger.debug("Calc chart last time: " + (e2 - b) + " ms");
    }

    private void drawElements(ArrayList als) {
        IElement e;
        int size = als.size();
        int i = 0;
        while (i < size) {
            e = (IElement)als.get(i);
            e.drawBack();
            ++i;
        }
        i = 0;
        while (i < size) {
            e = (IElement)als.get(i);
            e.draw();
            ++i;
        }
        i = 0;
        while (i < size) {
            e = (IElement)als.get(i);
            e.drawFore();
            ++i;
        }
    }

    public Graphics2D getGraphics() {
        return this.g;
    }

    public int getW() {
        return this.w;
    }

    public int getH() {
        return this.h;
    }

    public double getXPixel(double val) {
        return this.getPixel(val, this.getW());
    }

    public double getYPixel(double val) {
        return this.getPixel(val, this.getH());
    }

    private double getPixel(double val, double length) {
        if (val > 1.0) {
            return val;
        }
        if (val >= 0.0) {
            return length * val;
        }
        if (val > -1.0) {
            val = length * val;
        }
        return length + val;
    }

    public StringBuffer getHtml() {
        return this.html;
    }

    public Engine clone() {
        Engine e = new Engine();
        e.elements = (ArrayList)this.elements.clone();
        e.axisList = (ArrayList)this.axisList.clone();
        e.coorList = (ArrayList)this.coorList.clone();
        e.dataList = (ArrayList)this.dataList.clone();
        e.timeList = (ArrayList)this.timeList.clone();
        for (IElement ie : e.elements) {
            ie.setEngine(e);
        }
        return e;
    }

    public static void main(String[] args) {
        BufferedImage bi = new BufferedImage(633, 450, 1);
        Graphics2D g = bi.createGraphics();
        g.setColor(Color.white);
        g.fillRect(0, 0, 633, 450);
        Utils.setGraphAntiAliasingOn(g);
        Path2D.Double p = new Path2D.Double();
        ((Path2D)p).moveTo(10.0, 10.0);
        ((Path2D)p).lineTo(20.0, 10.0);
        ((Path2D)p).lineTo(20.0, 20.0);
        p.closePath();
        g.setColor(Color.black);
        g.draw(p);
        int angle = 90;
        int x = 100;
        int y = 100;
        g.drawOval(x, y, 3, 3);
        String text = "Text";
        g.drawString(text, x, y);
        double rotateAngle = Math.toRadians(-angle);
        AffineTransform at = g.getTransform();
        AffineTransform at1 = AffineTransform.getRotateInstance(rotateAngle, x, y);
        g.transform(at1);
        g.setStroke(new BasicStroke(1.0f));
        g.setColor(Color.red);
        g.drawString(text, x, y);
        g.dispose();
        try {
            FileOutputStream os = new FileOutputStream("E:/test.jpg");
            ImageUtils.writeJPEG(bi, os);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        g.dispose();
        System.out.println("OK");
    }
}

