/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.chart;

import com.scudata.cellset.graph.config.Palette;
import com.scudata.chart.ChartColor;
import com.scudata.chart.Engine;
import com.scudata.chart.Utils;
import com.scudata.chart.element.IMapAxis;
import com.scudata.common.GMBase;
import com.scudata.common.Logger;
import com.scudata.dm.Sequence;
import com.scudata.util.Variant;
import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import java.util.StringTokenizer;

public class Para {
    private transient String name;
    private transient byte legendProperty = 0;
    private Object value = null;
    private String axis = null;
    private transient Engine e = null;
    private static transient ArrayList<Color> defPalette = null;
    private static String[] hexColors = new String[]{"AFD8F8", "F6BD0F", "8BBA00", "FF8E46", "008E8E", "D64646", "8E468E", "588526", "B3AA00", "008ED6", "9D080D", "A186BE", "CC6600", "FDC689", "ABA000", "F26D7D", "FFF200", "0054A6", "F7941C", "CC3300", "006600", "663300", "6DCFF6"};
    private static ArrayList<Color> hexPalette = null;

    public Para() {
    }

    public Para(Object value) {
        this.value = value;
    }

    public Para(byte legendProperty) {
        this.legendProperty = legendProperty;
    }

    public Para(Object value, byte legendProperty) {
        this.value = value;
        this.legendProperty = legendProperty;
    }

    public Para(Object value, String axis, String name) {
        Sequence seq;
        this.name = name;
        Object tmp = value;
        if (tmp instanceof Sequence && (tmp = Utils.sequenceToChartColor(seq = (Sequence)tmp)) == null) {
            tmp = value;
        }
        this.value = tmp;
        this.axis = axis;
    }

    public void setLegendProperty(byte p) {
        this.legendProperty = p;
    }

    public byte getLegendProperty() {
        return this.legendProperty;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public void setEngine(Engine e) {
        this.e = e;
    }

    public int getLength() {
        return this.sequenceValue().length();
    }

    public boolean hasGradientColor() {
        if (this.value == null || !(this.value instanceof Sequence)) {
            return this.chartColorValue().isGradient();
        }
        Sequence seq = (Sequence)this.value;
        int len = seq.length();
        int i = 1;
        while (i <= len) {
            ChartColor cc = this.chartColorValue(i);
            if (cc.isGradient()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Object objectValue(int pos) {
        Object val;
        if (this.value instanceof Sequence) {
            Sequence seq = (Sequence)this.value;
            if ((pos %= seq.length()) == 0) {
                pos = seq.length();
            }
            val = seq.get(pos);
        } else {
            val = this.value instanceof Color ? new Integer(((Color)this.value).getRGB()) : this.value;
        }
        if (this.axis == null || this.e == null) {
            return val;
        }
        IMapAxis im = this.e.getMapAxisByName(this.axis);
        if (im == null) {
            return val;
        }
        if (this.legendProperty == 0) {
            throw new RuntimeException("Property " + this.name + " does not support legend mapping.");
        }
        return im.getMapValue(val, this.legendProperty);
    }

    public int intValue() {
        return this.intValue(0);
    }

    public int intValue(int pos) {
        Object val = this.objectValue(pos);
        if (val == null) {
            return 0;
        }
        if (val instanceof Number) {
            return ((Number)val).intValue();
        }
        return Integer.parseInt(val.toString());
    }

    public float floatValue() {
        return this.floatValue(0);
    }

    public float floatValue(int pos) {
        Object val = this.objectValue(pos);
        if (val == null) {
            return 0.0f;
        }
        if (val instanceof Number) {
            return ((Number)val).floatValue();
        }
        return Float.parseFloat(val.toString());
    }

    public double doubleValue() {
        return this.doubleValue(0);
    }

    public double doubleValue(int pos) {
        Object val = this.objectValue(pos);
        if (val == null) {
            return 0.0;
        }
        if (val instanceof Number) {
            return ((Number)val).doubleValue();
        }
        return Double.parseDouble(val.toString());
    }

    public Date dateValue() {
        return this.dateValue(0);
    }

    public Date dateValue(int pos) {
        Object val = this.objectValue(pos);
        if (val == null) {
            return null;
        }
        if (val instanceof Date) {
            return (Date)val;
        }
        if ((val = Variant.parseDate(val.toString())) instanceof Date) {
            return (Date)val;
        }
        return null;
    }

    public boolean booleanValue() {
        return this.booleanValue(0);
    }

    public boolean booleanValue(int pos) {
        Object val = this.objectValue(pos);
        if (val == null) {
            return false;
        }
        if (val instanceof Boolean) {
            return (Boolean)val;
        }
        return Boolean.valueOf(val.toString());
    }

    public ChartColor chartColorValue() {
        return this.chartColorValue(1);
    }

    public ChartColor chartColorValue(int pos) {
        Object val = this.objectValue(pos);
        if (val instanceof Sequence) {
            val = Utils.sequenceToChartColor((Sequence)val);
        }
        if (val == null) {
            val = Para.defColorValue(pos);
        }
        ChartColor cc = val instanceof ChartColor ? ((ChartColor)val).deepClone() : (val instanceof Color ? new ChartColor((Color)val) : new ChartColor(Integer.parseInt(val.toString())));
        return cc;
    }

    public String stringValue() {
        return this.stringValue(0);
    }

    public String stringValue(int pos) {
        Object val = this.objectValue(pos);
        if (val == null) {
            return null;
        }
        return Variant.toString(val);
    }

    public static Color defColorValue(int pos) {
        --pos;
        ArrayList<Color> palette = Para.getHexPalette();
        return palette.get(pos %= palette.size());
    }

    public static Object cycleValue(ArrayList values, int pos) {
        return values.get(pos %= values.size());
    }

    public Color colorValueNullAsDef(int pos) {
        Color c = this.colorValue(pos);
        if (c == null) {
            return Para.defColorValue(pos);
        }
        return c;
    }

    public Color colorValue(int pos) {
        Object val = this.objectValue(pos);
        if (val == null) {
            return null;
        }
        if (val instanceof Color) {
            return (Color)val;
        }
        if (val instanceof ChartColor) {
            return ((ChartColor)val).getColor1();
        }
        if (val instanceof Sequence) {
            ChartColor cc = ChartColor.getInstance((Sequence)val);
            return cc.getColor1();
        }
        int ci = Integer.parseInt(val.toString());
        if (ci == 0xFFFFFF) {
            return null;
        }
        return new Color(ci);
    }

    public Sequence sequenceValue() {
        if (this.value instanceof Sequence) {
            return (Sequence)this.value;
        }
        Sequence seq = new Sequence();
        if (this.value != null) {
            seq.add(this.value);
        }
        return seq;
    }

    public static ArrayList<Color> getHexPalette() {
        if (hexPalette == null) {
            hexPalette = Para.loadConfigFile();
            if (hexPalette != null) {
                return hexPalette;
            }
            hexPalette = new ArrayList();
            int i = 0;
            while (i < hexColors.length) {
                String tmp = hexColors[i];
                int r = Integer.parseInt(tmp.substring(0, 2), 16);
                int g = Integer.parseInt(tmp.substring(2, 4), 16);
                int b = Integer.parseInt(tmp.substring(4, 6), 16);
                hexPalette.add(new Color(r, g, b));
                ++i;
            }
        }
        return hexPalette;
    }

    public static ArrayList<Color> getDefPalette() {
        if (defPalette == null) {
            defPalette = Para.loadConfigFile();
            if (defPalette != null) {
                return defPalette;
            }
            defPalette = new ArrayList();
            defPalette.add(new Color(128, 128, 0, 255));
            defPalette.add(new Color(255, 128, 0, 255));
            defPalette.add(new Color(192, 255, 0, 255));
            defPalette.add(new Color(0, 0, 128, 255));
            defPalette.add(new Color(128, 0, 128, 255));
            defPalette.add(new Color(255, 0, 128, 255));
            defPalette.add(new Color(0, 128, 128, 255));
            defPalette.add(new Color(128, 128, 128, 255));
            defPalette.add(new Color(0, 255, 255, 255));
            defPalette.add(new Color(192, 192, 192, 255));
            defPalette.add(new Color(255, 128, 128, 255));
            defPalette.add(new Color(0, 255, 128, 255));
            defPalette.add(new Color(192, 255, 128, 255));
            defPalette.add(new Color(255, 255, 0, 255));
            defPalette.add(new Color(255, 255, 128, 255));
            defPalette.add(new Color(128, 0, 255, 255));
            defPalette.add(new Color(255, 0, 255, 255));
            defPalette.add(new Color(0, 128, 255, 255));
            defPalette.add(new Color(128, 128, 255, 255));
            defPalette.add(new Color(255, 128, 255, 255));
            defPalette.add(new Color(192, 255, 255, 255));
            defPalette.add(new Color(255, 0, 0, 255));
            defPalette.add(new Color(0, 255, 0, 255));
            defPalette.add(new Color(0, 0, 255, 255));
            defPalette.add(new Color(0, 128, 0, 255));
            defPalette.add(new Color(255, 255, 255, 255));
        }
        return defPalette;
    }

    private static ArrayList<Color> loadConfigFile() {
        String obj;
        String name;
        block8: {
            InputStream is;
            Properties config;
            block7: {
                config = new Properties();
                is = null;
                name = "/chartcolor.properties";
                String relativePath = "config" + name;
                File f = new File(GMBase.getAbsolutePath(relativePath));
                is = f.exists() ? new FileInputStream(f) : Palette.class.getResourceAsStream(relativePath);
                if (is == null) {
                    is = Palette.class.getResourceAsStream("/config" + name);
                }
                if (is != null) break block7;
                return null;
            }
            config.load(is);
            obj = config.getProperty("default");
            if (obj != null) break block8;
            return null;
        }
        try {
            if (obj.startsWith("[")) {
                obj = obj.substring(1, obj.length() - 1);
            }
            StringTokenizer st = new StringTokenizer(obj, ",");
            ArrayList<Color> colors = new ArrayList<Color>();
            while (st.hasMoreElements()) {
                String tmp = st.nextToken();
                int value = Integer.parseInt(tmp);
                Color c = new Color(value);
                colors.add(c);
            }
            Logger.debug("Load " + name + " OK.");
            return colors;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) {
        Para.getHexPalette();
    }
}

