/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.chart;

import com.scudata.chart.CartesianCoor;
import com.scudata.chart.ICoor;
import com.scudata.chart.element.EnumAxis;
import com.scudata.chart.element.NumericAxis;
import com.scudata.chart.element.TickAxis;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class PolarCoor
implements ICoor {
    TickAxis a1;
    TickAxis a2;

    @Override
    public void setAxis1(TickAxis axis) {
        this.a1 = axis;
    }

    @Override
    public TickAxis getAxis1() {
        return this.a1;
    }

    public TickAxis getPolarAxis() {
        if (this.a1.getLocation() == 3) {
            return this.a1;
        }
        return this.a2;
    }

    @Override
    public void setAxis2(TickAxis axis) {
        this.a2 = axis;
    }

    @Override
    public TickAxis getAxis2() {
        return this.a2;
    }

    public TickAxis getAngleAxis() {
        if (this.a1.getLocation() == 4) {
            return this.a1;
        }
        return this.a2;
    }

    public Point2D getPolarPoint(Object val1, Object val2) {
        return this.getNumericPoint(val1, val2);
    }

    @Override
    public Point2D getNumericPoint(Object val1, Object val2) {
        double a;
        double r;
        double i1 = this.a1.getValueLen(val1);
        double i2 = this.a2.getValueLen(val2);
        if (this.getPolarAxis() == this.a1) {
            r = i1;
            a = i2;
        } else {
            r = i2;
            a = i1;
        }
        return new Point2D.Double(r, a);
    }

    @Override
    public Point2D getScreenPoint(Point2D numericPoint) {
        TickAxis polarAxis = this.getPolarAxis();
        TickAxis angleAxis = this.getAngleAxis();
        double r = numericPoint.getX();
        double a = numericPoint.getY() + angleAxis.getBottomY();
        double radAngle = a * Math.PI / 180.0;
        double x = polarAxis.getLeftX() + r * Math.cos(radAngle);
        double y = polarAxis.getBottomY() - r * Math.sin(radAngle);
        return new Point2D.Double(x, y);
    }

    @Override
    public Point2D getScreenPoint(Object val1, Object val2) {
        Point2D nDot = this.getNumericPoint(val1, val2);
        return this.getScreenPoint(nDot);
    }

    public Rectangle2D getEllipseBounds(double polarLen) {
        double w;
        TickAxis polarAxis = this.getPolarAxis();
        double x = polarAxis.getLeftX() - polarLen;
        double y = polarAxis.getBottomY() - polarLen;
        double h = w = polarLen * 2.0;
        Rectangle2D.Double ellipseBounds = new Rectangle2D.Double(x, y, w, h);
        return ellipseBounds;
    }

    public boolean equals(Object another) {
        if (another instanceof PolarCoor) {
            PolarCoor apc = (PolarCoor)another;
            return apc.getPolarAxis() == this.getPolarAxis() && apc.getAngleAxis() == this.getAngleAxis();
        }
        return false;
    }

    @Override
    public NumericAxis getNumericAxis() {
        TickAxis axis = CartesianCoor.getAxis(this, NumericAxis.class);
        if (axis != null) {
            return (NumericAxis)axis;
        }
        return null;
    }

    @Override
    public EnumAxis getEnumAxis() {
        TickAxis axis = CartesianCoor.getAxis(this, EnumAxis.class);
        if (axis != null) {
            return (EnumAxis)axis;
        }
        return null;
    }

    public String toString() {
        return "PolarCoor Axis1:" + this.a1.getName() + " Axis2:" + this.a2.getName();
    }

    @Override
    public boolean isPolarCoor() {
        return true;
    }

    @Override
    public boolean isCartesianCoor() {
        return false;
    }

    @Override
    public boolean isEnumBased() {
        TickAxis ta = this.getAxis1();
        return ta.isEnumAxis();
    }
}

