/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.chart;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.datamatrix.encoder.SymbolShapeHint;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.scudata.cellset.graph.draw.Desc3DRect;
import com.scudata.chart.Ball;
import com.scudata.chart.ChartColor;
import com.scudata.chart.Code128ABC;
import com.scudata.chart.CubeColor;
import com.scudata.chart.DataElement;
import com.scudata.chart.Engine;
import com.scudata.chart.IElement;
import com.scudata.chart.Para;
import com.scudata.chart.PolarCoor;
import com.scudata.chart.element.Column;
import com.scudata.chart.element.Text;
import com.scudata.chart.resources.ChartMessage;
import com.scudata.common.Escape;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.common.Sentence;
import com.scudata.common.StringUtils;
import com.scudata.dm.FileObject;
import com.scudata.dm.Sequence;
import com.scudata.expression.Expression;
import com.scudata.expression.IParam;
import com.scudata.expression.ParamParser;
import com.scudata.util.Variant;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;

public class Utils {
    public static int SHADE_SPAN = 3;
    private static ArrayList globalFonts = new ArrayList();
    private static int[] shadowColors = new int[]{203, 208, 198, 201, 205, 196, 181, 186, 178, 155, 158, 151, 135, 138, 131};
    static MessageManager mm = ChartMessage.get();
    private static ArrayList solidStrokes = null;
    private static ArrayList dashedStrokes = null;
    private static ArrayList dottedStrokes = null;
    private static ArrayList dotdashStrokes = null;
    private static ArrayList doubleStrokes = null;
    private static ThreadLocal<Boolean> tlIsGif = new ThreadLocal<Boolean>(){

        @Override
        protected synchronized Boolean initialValue() {
            return Boolean.FALSE;
        }
    };

    private static Shape getLine1ShapeArea(double shift, Point2D b, Point2D e, float weight) {
        double x1 = b.getX() + shift;
        double y1 = b.getY() + shift;
        double x2 = e.getX() + shift;
        double y2 = e.getY() + shift;
        double P2e = Math.abs(y2 - y1);
        double P1e = Math.abs(x2 - x1);
        double P1P2 = Math.sqrt(P2e * P2e + P1e * P1e);
        double AP1 = weight / 2.0f;
        double sina2 = P1e / P1P2;
        double Af = AP1 * sina2;
        double cosa2 = P2e / P1P2;
        double fP1 = AP1 * cosa2;
        Point2D.Double A = new Point2D.Double(x1 - fP1, y1 - Af);
        Point2D.Double D = new Point2D.Double(x1 + fP1, y1 + Af);
        Point2D.Double B = new Point2D.Double(x2 - fP1, y2 - Af);
        Point2D.Double C = new Point2D.Double(x2 + fP1, y2 + Af);
        Shape polygon = Utils.newPolygon2DShape(new double[]{((Point2D)A).getX(), ((Point2D)B).getX(), ((Point2D)C).getX(), ((Point2D)D).getX()}, new double[]{((Point2D)A).getY(), ((Point2D)B).getY(), ((Point2D)C).getY(), ((Point2D)D).getY()});
        return polygon;
    }

    public static Shape drawLine1(Graphics2D g, Point2D b, Point2D e, int style, float weight) {
        if (b == null || e == null) {
            return null;
        }
        double shift = weight / 2.0f + 1.0f;
        if (shift < 2.0) {
            shift = 2.0;
        }
        Shape s = Utils.getLine1ShapeArea(shift, b, e, weight);
        double x1 = b.getX() + shift;
        double y1 = b.getY() + shift;
        double x2 = e.getX() + shift;
        double y2 = e.getY() + shift;
        double P2e = Math.abs(y2 - y1);
        double P1e = Math.abs(x2 - x1);
        double P1P2 = Math.sqrt(P2e * P2e + P1e * P1e);
        double AP1 = weight / 2.0f;
        double sina2 = P1e / P1P2;
        double Af = AP1 * sina2;
        double cosa2 = P2e / P1P2;
        double fP1 = AP1 * cosa2;
        Point2D.Double A = new Point2D.Double(x1 - fP1, y1 - Af);
        Point2D.Double D = new Point2D.Double(x1 + fP1, y1 + Af);
        Color bright = new Color(243, 248, 239);
        Color dark = Utils.getShadeColor(1);
        GradientPaint gp = new GradientPaint(A, dark, D, bright);
        g.setPaint(gp);
        Utils.setTransparent(g, 0.8f);
        g.fill(s);
        Utils.setTransparent(g, 1.0f);
        return Utils.getLine1ShapeArea(0.0, b, e, weight);
    }

    public static void drawLine2(Graphics2D g, Point2D b, Point2D e, Color color, int style, float weight) {
        if (b == null || e == null) {
            return;
        }
        if (Utils.setStroke(g, color, style, weight)) {
            Utils.drawLine(g, b, e);
        }
    }

    public static String xToChinese(double dd) {
        try {
            String s = "\u96f6\u58f9\u8d30\u53c1\u8086\u4f0d\u9646\u67d2\u634c\u7396";
            String s1 = "\u5341\u767e\u5343\u4e07\u5341\u767e\u5343\u4ebf\u5341\u767e\u5343\u4e07";
            StringBuffer k = new StringBuffer();
            String m = String.valueOf(Math.round(dd));
            int j = m.length();
            while (j >= 1) {
                char n = s.charAt(Integer.parseInt(m.substring(m.length() - j, m.length() - j + 1)));
                if (n != '\u96f6' || k.charAt(k.length() - 1) != '\u96f6') {
                    k.append(n);
                    if (n != '\u96f6') {
                        int u = j - 2;
                        if (u >= 0) {
                            k.append(s1.charAt(u));
                        }
                        if (u > 3 && u < 7) {
                            k.append('\u4e07');
                        }
                        if (u > 7) {
                            k.append('\u4ebf');
                        }
                    }
                }
                --j;
            }
            if (k.length() > 0 && k.charAt(k.length() - 1) == '\u96f6') {
                k.deleteCharAt(k.length() - 1);
            }
            if (k.length() > 0 && k.charAt(0) == '\u58f9') {
                k.deleteCharAt(0);
            }
            return k.toString();
        }
        catch (Exception x) {
            DecimalFormat df = new DecimalFormat("###,#.#");
            return df.format(dd);
        }
    }

    public static boolean sort(AbstractList list, boolean ascend) {
        Object o;
        int i = 0;
        while (i < list.size()) {
            o = list.get(i);
            if (o != null && !(o instanceof Comparable)) {
                return false;
            }
            ++i;
        }
        i = 0;
        while (i < list.size() - 1) {
            int j = i + 1;
            while (j < list.size()) {
                boolean lb_exchange;
                Comparable ci = (Comparable)list.get(i);
                Comparable cj = (Comparable)list.get(j);
                if (ascend) {
                    lb_exchange = ci == null || cj == null ? cj == null : ci.compareTo(cj) > 0;
                } else if (ci == null || cj == null) {
                    lb_exchange = ci == null;
                } else {
                    boolean bl = lb_exchange = ci.compareTo(cj) < 0;
                }
                if (lb_exchange) {
                    o = list.get(i);
                    Object o2 = list.get(j);
                    list.set(i, o2);
                    list.set(j, o);
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    public static synchronized void fillRadioGradientShape(Graphics2D g, Shape s, Color c1, Color c2, float transparent) {
        Utils.setTransparent(g, transparent);
        g.setColor(Utils.getShadeColor(1));
        g.fill(s);
        Utils.setTransparent(g, 1.0f);
    }

    private static synchronized Paint getGradientPaint(double x, double y, double width, double height, Color color1, Color color2, int angle) {
        double x1 = 0.0;
        double y1 = 0.0;
        double x2 = 0.0;
        double y2 = 0.0;
        double h = 0.0;
        h = height;
        double antiAngleLen = Math.sqrt(width * width + h * h);
        double rad = (double)angle * Math.PI / 180.0;
        if (angle >= 0 && angle <= 90) {
            if (angle == 0) {
                x1 = x;
                y1 = y + h / 2.0;
                x2 = x + width;
                y2 = y1;
            } else if (angle == 90) {
                x1 = x + width / 2.0;
                y1 = y + h;
                x2 = x1;
                y2 = y;
            } else {
                x1 = x;
                y1 = y + h;
                x2 = x1 + antiAngleLen * Math.cos(rad);
                y2 = y1 - antiAngleLen * Math.sin(rad);
            }
        } else if (angle > 90 && angle <= 180) {
            if (angle == 180) {
                x1 = x + width;
                y1 = y + h / 2.0;
                x2 = x;
                y2 = y1;
            } else {
                x1 = x + width;
                y1 = y + h;
                x2 = x1 + antiAngleLen * Math.cos(rad);
                y2 = y1 - antiAngleLen * Math.sin(rad);
            }
        } else if (angle > 180 && angle <= 270) {
            if (angle == 270) {
                x1 = x + width / 2.0;
                y1 = y;
                x2 = x1;
                y2 = y + h;
            } else {
                x1 = x + width;
                y1 = y;
                x2 = x1 + antiAngleLen * Math.cos(rad);
                y2 = y1 - antiAngleLen * Math.sin(rad);
            }
        } else if (angle > 270 && angle <= 360) {
            if (angle == 360) {
                x1 = x;
                y1 = y + h / 2.0;
                x2 = x + width;
                y2 = y1;
            } else {
                x1 = x;
                y1 = y;
                x2 = x1 + antiAngleLen * Math.cos(rad);
                y2 = y1 - antiAngleLen * Math.sin(rad);
            }
        }
        return new GradientPaint((int)x1, (int)y1, color1, (int)x2, (int)y2, color2, false);
    }

    public static boolean setPaint(Graphics2D g, double x, double y, double width, double height, ChartColor cc) {
        Rectangle2D.Double rect = null;
        BufferedImage tempbi = null;
        Graphics tempG = null;
        Paint paint = null;
        int pattern = cc.getType();
        Color c1 = cc.getColor1();
        if (c1 == null) {
            return false;
        }
        Color c2 = cc.getColor2();
        if (c2 == null) {
            return false;
        }
        switch (pattern) {
            case 0: {
                if (cc.isGradient()) {
                    paint = Utils.getGradientPaint(x, y, width, height, c1, c2, cc.getAngle());
                    break;
                }
                g.setColor(c1);
                return true;
            }
            case 1: {
                rect = new Rectangle2D.Double(x + 1.0, y + 1.0, 6.0, 6.0);
                tempbi = new BufferedImage(6, 6, 1);
                tempG = (Graphics2D)tempbi.getGraphics();
                tempG.setColor(c1);
                tempG.fillRect(0, 0, 6, 6);
                tempG.setColor(c2);
                ((Graphics2D)tempG).setStroke(new BasicStroke(0.1f));
                tempG.drawLine(0, 1, 6, 1);
                tempG.drawLine(0, 3, 6, 3);
                tempG.drawLine(0, 5, 6, 5);
                paint = new TexturePaint(tempbi, rect);
                break;
            }
            case 2: {
                rect = new Rectangle2D.Double(x + 1.0, y + 1.0, 6.0, 6.0);
                tempbi = new BufferedImage(6, 6, 1);
                tempG = (Graphics2D)tempbi.getGraphics();
                tempG.setColor(c1);
                tempG.fillRect(0, 0, 6, 6);
                tempG.setColor(c2);
                ((Graphics2D)tempG).setStroke(new BasicStroke(1.5f));
                tempG.drawLine(0, 2, 6, 2);
                tempG.drawLine(0, 5, 6, 5);
                paint = new TexturePaint(tempbi, rect);
                break;
            }
            case 3: {
                rect = new Rectangle2D.Double(x + 1.0, y + 1.0, 6.0, 6.0);
                tempbi = new BufferedImage(6, 6, 1);
                tempG = (Graphics2D)tempbi.getGraphics();
                tempG.setColor(c1);
                tempG.fillRect(0, 0, 6, 6);
                tempG.setColor(c2);
                ((Graphics2D)tempG).setStroke(new BasicStroke(0.1f));
                tempG.drawLine(1, 0, 1, 6);
                tempG.drawLine(3, 0, 3, 6);
                tempG.drawLine(5, 0, 5, 6);
                paint = new TexturePaint(tempbi, rect);
                break;
            }
            case 4: {
                rect = new Rectangle2D.Double(x + 1.0, y + 1.0, 6.0, 6.0);
                tempbi = new BufferedImage(6, 6, 1);
                tempG = (Graphics2D)tempbi.getGraphics();
                tempG.setColor(c1);
                tempG.fillRect(0, 0, 6, 6);
                tempG.setColor(c2);
                ((Graphics2D)tempG).setStroke(new BasicStroke(1.5f));
                tempG.drawLine(2, 0, 2, 6);
                tempG.drawLine(5, 0, 5, 6);
                paint = new TexturePaint(tempbi, rect);
                break;
            }
            case 5: {
                rect = new Rectangle2D.Double(x + 1.0, y + 1.0, 3.0, 3.0);
                tempbi = new BufferedImage(3, 3, 1);
                tempG = (Graphics2D)tempbi.getGraphics();
                tempG.setColor(c1);
                tempG.fillRect(0, 0, 3, 3);
                tempG.setColor(c2);
                ((Graphics2D)tempG).setStroke(new BasicStroke(0.1f));
                tempG.drawLine(0, 0, 3, 3);
                paint = new TexturePaint(tempbi, rect);
                break;
            }
            case 6: {
                rect = new Rectangle2D.Double(x + 1.0, y + 1.0, 4.0, 4.0);
                tempbi = new BufferedImage(4, 4, 1);
                tempG = (Graphics2D)tempbi.getGraphics();
                Utils.setGraphAntiAliasingOn((Graphics2D)tempG);
                tempG.setColor(c1);
                tempG.fillRect(0, 0, 4, 4);
                tempG.setColor(c2);
                ((Graphics2D)tempG).setStroke(new BasicStroke(1.5f, 2, 2, 10.0f, null, 0.0f));
                tempG.drawLine(0, 0, 4, 4);
                tempG.drawLine(3, -1, 5, 1);
                tempG.drawLine(-1, 3, 1, 5);
                paint = new TexturePaint(tempbi, rect);
                break;
            }
            case 7: {
                rect = new Rectangle2D.Double(x + 1.0, y + 1.0, 3.0, 3.0);
                tempbi = new BufferedImage(3, 3, 1);
                tempG = (Graphics2D)tempbi.getGraphics();
                tempG.setColor(c1);
                tempG.fillRect(0, 0, 3, 3);
                tempG.setColor(c2);
                ((Graphics2D)tempG).setStroke(new BasicStroke(0.1f));
                tempG.drawLine(2, 0, -1, 3);
                paint = new TexturePaint(tempbi, rect);
                break;
            }
            case 8: {
                rect = new Rectangle2D.Double(x + 1.0, y + 1.0, 4.0, 4.0);
                tempbi = new BufferedImage(4, 4, 1);
                tempG = (Graphics2D)tempbi.getGraphics();
                Utils.setGraphAntiAliasingOn((Graphics2D)tempG);
                tempG.setColor(c1);
                tempG.fillRect(0, 0, 4, 4);
                tempG.setColor(c2);
                ((Graphics2D)tempG).setStroke(new BasicStroke(1.5f, 2, 2, 10.0f, null, 0.0f));
                tempG.drawLine(4, 0, 0, 4);
                tempG.drawLine(-1, 1, 1, -1);
                tempG.drawLine(3, 5, 5, 3);
                paint = new TexturePaint(tempbi, rect);
                break;
            }
            case 9: {
                rect = new Rectangle2D.Double(x + 1.0, y + 1.0, 3.0, 3.0);
                tempbi = new BufferedImage(3, 3, 1);
                tempG = (Graphics2D)tempbi.getGraphics();
                tempG.setColor(c1);
                tempG.fillRect(0, 0, 3, 3);
                tempG.setColor(c2);
                ((Graphics2D)tempG).setStroke(new BasicStroke(0.1f, 2, 0, 10.0f, null, 0.0f));
                tempG.drawLine(1, 0, 1, 3);
                tempG.drawLine(0, 1, 3, 1);
                paint = new TexturePaint(tempbi, rect);
                break;
            }
            case 10: {
                rect = new Rectangle2D.Double(x + 1.0, y + 1.0, 5.0, 5.0);
                tempbi = new BufferedImage(5, 5, 1);
                tempG = (Graphics2D)tempbi.getGraphics();
                tempG.setColor(c1);
                tempG.fillRect(0, 0, 5, 5);
                tempG.setColor(c2);
                ((Graphics2D)tempG).setStroke(new BasicStroke(1.5f, 2, 0, 10.0f, null, 0.0f));
                tempG.drawLine(3, 0, 3, 5);
                tempG.drawLine(0, 3, 5, 3);
                paint = new TexturePaint(tempbi, rect);
                break;
            }
            case 11: {
                rect = new Rectangle2D.Double(x + 1.0, y + 1.0, 5.0, 5.0);
                tempbi = new BufferedImage(5, 5, 1);
                tempG = (Graphics2D)tempbi.getGraphics();
                tempG.setColor(c1);
                tempG.fillRect(0, 0, 5, 5);
                tempG.setColor(c2);
                ((Graphics2D)tempG).setStroke(new BasicStroke(0.5f, 2, 0, 10.0f, null, 0.0f));
                tempG.drawLine(0, 0, 5, 5);
                tempG.drawLine(0, 5, 5, 0);
                paint = new TexturePaint(tempbi, rect);
                break;
            }
            case 12: {
                rect = new Rectangle2D.Double(x + 1.0, y + 1.0, 6.0, 6.0);
                tempbi = new BufferedImage(6, 6, 1);
                tempG = (Graphics2D)tempbi.getGraphics();
                Utils.setGraphAntiAliasingOn((Graphics2D)tempG);
                tempG.setColor(c1);
                tempG.fillRect(0, 0, 6, 6);
                tempG.setColor(c2);
                ((Graphics2D)tempG).setStroke(new BasicStroke(1.5f, 2, 2, 10.0f, null, 0.0f));
                tempG.drawLine(0, 0, 6, 6);
                tempG.drawLine(0, 6, 6, 0);
                paint = new TexturePaint(tempbi, rect);
                break;
            }
            case 13: {
                rect = new Rectangle2D.Double(x, y, 12.0, 12.0);
                tempbi = new BufferedImage(12, 12, 1);
                tempG = (Graphics2D)tempbi.getGraphics();
                Utils.setGraphAntiAliasingOn((Graphics2D)tempG);
                tempG.setColor(c1);
                tempG.fillRect(0, 0, 12, 12);
                tempG.setColor(c2);
                ((Graphics2D)tempG).setStroke(new BasicStroke(1.0f, 2, 2, 10.0f, null, 0.0f));
                tempG.drawLine(2, 3, 2, 3);
                tempG.drawLine(8, 9, 8, 9);
                paint = new TexturePaint(tempbi, rect);
                break;
            }
            case 14: {
                rect = new Rectangle2D.Double(x, y, 12.0, 12.0);
                tempbi = new BufferedImage(12, 12, 1);
                tempG = (Graphics2D)tempbi.getGraphics();
                tempG.setColor(c1);
                tempG.fillRect(0, 0, 12, 12);
                tempG.setColor(c2);
                ((Graphics2D)tempG).setStroke(new BasicStroke(1.0f, 2, 2, 10.0f, null, 0.0f));
                tempG.drawLine(2, 3, 2, 3);
                tempG.drawLine(6, 11, 6, 11);
                tempG.drawLine(10, 7, 10, 7);
                paint = new TexturePaint(tempbi, rect);
                break;
            }
            case 15: {
                rect = new Rectangle2D.Double(x, y, 9.0, 9.0);
                tempbi = new BufferedImage(9, 9, 1);
                tempG = (Graphics2D)tempbi.getGraphics();
                Utils.setGraphAntiAliasingOn((Graphics2D)tempG);
                tempG.setColor(c1);
                tempG.fillRect(0, 0, 9, 9);
                tempG.setColor(c2);
                ((Graphics2D)tempG).setStroke(new BasicStroke(1.0f, 2, 2, 10.0f, null, 0.0f));
                tempG.drawLine(2, 2, 2, 2);
                tempG.drawLine(5, 8, 5, 8);
                tempG.drawLine(8, 5, 8, 5);
                paint = new TexturePaint(tempbi, rect);
                break;
            }
            case 16: {
                rect = new Rectangle2D.Double(x, y, 4.0, 4.0);
                tempbi = new BufferedImage(4, 4, 1);
                tempG = (Graphics2D)tempbi.getGraphics();
                tempG.setColor(c1);
                tempG.fillRect(0, 0, 4, 4);
                tempG.setColor(c2);
                ((Graphics2D)tempG).setStroke(new BasicStroke(1.0f, 2, 2, 10.0f, null, 0.0f));
                tempG.drawLine(1, 3, 1, 3);
                tempG.drawLine(3, 1, 3, 1);
                paint = new TexturePaint(tempbi, rect);
                break;
            }
            case 17: {
                rect = new Rectangle2D.Double(0.0, 0.0, 8.0, 8.0);
                tempbi = new BufferedImage(8, 8, 1);
                tempG = (Graphics2D)tempbi.getGraphics();
                tempG.setColor(c1);
                tempG.fillRect(0, 0, 8, 8);
                tempG.setColor(c2);
                tempG.fillRect(0, 0, 4, 4);
                tempG.fillRect(4, 4, 4, 4);
                paint = new TexturePaint(tempbi, rect);
                break;
            }
            case 18: {
                rect = new Rectangle2D.Double(x + 1.0, y + 1.0, 8.0, 8.0);
                tempbi = new BufferedImage(8, 8, 1);
                tempG = (Graphics2D)tempbi.getGraphics();
                tempG.setColor(c1);
                tempG.fillRect(0, 0, 8, 8);
                tempG.setColor(c2);
                int[] nArray = new int[4];
                nArray[0] = 4;
                nArray[2] = 4;
                nArray[3] = 8;
                int[] xs = nArray;
                int[] nArray2 = new int[4];
                nArray2[1] = 4;
                nArray2[2] = 8;
                nArray2[3] = 4;
                int[] ys = nArray2;
                tempG.fillPolygon(xs, ys, 4);
                paint = new TexturePaint(tempbi, rect);
                break;
            }
            case 19: {
                rect = new Rectangle2D.Double(x + 1.0, y + 1.0, 12.0, 12.0);
                tempbi = new BufferedImage(12, 12, 1);
                tempG = (Graphics2D)tempbi.getGraphics();
                tempG.setColor(c1);
                tempG.fillRect(0, 0, 12, 12);
                ((Graphics2D)tempG).setStroke(new BasicStroke(0.1f));
                tempG.setColor(c2);
                tempG.drawLine(0, 0, 12, 0);
                tempG.drawLine(0, 3, 12, 3);
                tempG.drawLine(0, 6, 12, 6);
                tempG.drawLine(0, 9, 12, 9);
                tempG.drawLine(2, 0, 2, 3);
                tempG.drawLine(8, 3, 8, 6);
                tempG.drawLine(2, 6, 2, 9);
                tempG.drawLine(8, 9, 8, 12);
                paint = new TexturePaint(tempbi, rect);
            }
        }
        g.setPaint(paint);
        if (tempG != null) {
            tempG.dispose();
        }
        return true;
    }

    public static boolean setStroke(Graphics2D g, Color c, int style, float weight) {
        BasicStroke stroke;
        float w2 = weight;
        if (w2 == 0.0f) {
            return false;
        }
        if (w2 < 1.0f) {
            w2 = 1.0f;
        }
        if (c != null) {
            g.setColor(c);
        }
        ListIterator li = null;
        switch (style &= 0xF) {
            case 1: {
                if (solidStrokes == null) {
                    solidStrokes = new ArrayList();
                } else {
                    li = solidStrokes.listIterator();
                    while (li.hasNext()) {
                        BasicStroke bs = (BasicStroke)li.next();
                        if (bs.getLineWidth() != weight) continue;
                        g.setStroke(bs);
                        return true;
                    }
                }
                stroke = new BasicStroke(weight);
                g.setStroke(stroke);
                solidStrokes.add(stroke);
                break;
            }
            case 2: {
                if (dashedStrokes == null) {
                    dashedStrokes = new ArrayList();
                } else {
                    li = dashedStrokes.listIterator();
                    while (li.hasNext()) {
                        BasicStroke bs = (BasicStroke)li.next();
                        if (bs.getLineWidth() != weight) continue;
                        g.setStroke(bs);
                        return true;
                    }
                }
                float[] dashes1 = new float[]{6.0f * w2, 6.0f * w2};
                stroke = new BasicStroke(weight, 2, 2, 10.0f, dashes1, 0.0f);
                g.setStroke(stroke);
                dashedStrokes.add(stroke);
                break;
            }
            case 3: {
                if (dottedStrokes == null) {
                    dottedStrokes = new ArrayList();
                } else {
                    li = dottedStrokes.listIterator();
                    while (li.hasNext()) {
                        BasicStroke bs = (BasicStroke)li.next();
                        if (bs.getLineWidth() != weight) continue;
                        g.setStroke(bs);
                        return true;
                    }
                }
                float[] dashes2 = new float[]{w2, 3.0f * w2};
                stroke = new BasicStroke(weight, 2, 2, 10.0f, dashes2, 0.0f);
                g.setStroke(stroke);
                dottedStrokes.add(stroke);
                break;
            }
            case 5: {
                if (dotdashStrokes == null) {
                    dotdashStrokes = new ArrayList();
                } else {
                    li = dotdashStrokes.listIterator();
                    while (li.hasNext()) {
                        BasicStroke bs = (BasicStroke)li.next();
                        if (bs.getLineWidth() != weight) continue;
                        g.setStroke(bs);
                        return true;
                    }
                }
                float[] lp1 = new float[]{6.0f * w2, 2.0f * w2, w2, 2.0f * w2};
                stroke = new BasicStroke(weight, 2, 2, 10.0f, lp1, 0.0f);
                g.setStroke(stroke);
                dotdashStrokes.add(stroke);
                break;
            }
            case 4: {
                if (doubleStrokes == null) {
                    doubleStrokes = new ArrayList();
                } else {
                    li = doubleStrokes.listIterator();
                    while (li.hasNext()) {
                        BasicStroke bs = (BasicStroke)li.next();
                        if (bs.getLineWidth() != weight) continue;
                        g.setStroke(bs);
                        return true;
                    }
                }
                float[] dashes3 = new float[]{w2, 2.0f * w2, w2, 2.0f * w2, 8.0f * w2, 2.0f * w2};
                stroke = new BasicStroke(weight, 2, 2, 10.0f, dashes3, 0.0f);
                g.setStroke(stroke);
                doubleStrokes.add(stroke);
                break;
            }
            default: {
                return false;
            }
        }
        g.setStroke(stroke);
        return true;
    }

    public static int getArrow(int style) {
        return style & 0xF00;
    }

    public static void drawLineArrow(Graphics2D g, double dx, double dy, double radian, int style) {
        if ((style = Utils.getArrow(style)) == 0) {
            return;
        }
        int x = (int)dx;
        int y = (int)dy;
        AffineTransform at = g.getTransform();
        AffineTransform at1 = AffineTransform.getRotateInstance(radian, x, y);
        g.transform(at1);
        switch (style) {
            case 0: {
                break;
            }
            case 256: {
                int[] xs_arr = new int[]{(x += 8) - 8, x - 12, x, x - 12};
                int[] ys_arr = new int[]{y, y - 4, y, y + 4};
                g.fillPolygon(xs_arr, ys_arr, 4);
                break;
            }
            case 1536: {
                int[] xl_arr = new int[]{x -= 8, x + 12, x + 8, x + 12};
                int[] yl_arr = new int[]{y, y - 4, y, y + 4};
                g.fillPolygon(xl_arr, yl_arr, 4);
                break;
            }
            case 512: {
                int[] xs_bot = new int[]{(x += 8) - 8, x - 12, x, x - 12};
                int[] ys_bot = new int[]{y, y - 4, y, y + 4};
                g.fillPolygon(xs_bot, ys_bot, 4);
                int[] xs_bot2 = new int[]{x - 14, x - 18, x - 6, x - 18};
                int[] ys_bot2 = new int[]{y, y - 4, y, y + 4};
                g.fillPolygon(xs_bot2, ys_bot2, 4);
                break;
            }
            case 768: {
                int r_h = 4;
                int cdy = (int)((double)r_h * 1.732);
                int cdx = 3 * r_h;
                int[] xs_heart = new int[]{(x += cdx) - cdx, x - cdx, x};
                int[] ys_heart = new int[]{y - cdy, y + cdy, y};
                g.fillPolygon(xs_heart, ys_heart, 3);
                int d2y = (int)((double)r_h * 1.732 / 2.0);
                int d2x = 3 * r_h;
                g.fillOval(x - d2x - r_h, y - d2y - r_h, 2 * r_h - 1, 2 * r_h - 1);
                g.fillOval(x - d2x - r_h, y + d2y - r_h, 2 * r_h - 1, 2 * r_h - 1);
                break;
            }
            case 1024: {
                g.fillOval((x += 8) - 8, y - 4, 8, 8);
                break;
            }
            case 1280: {
                int[] xs_dia = new int[]{(x += 14) - 14, x - 7, x, x - 7};
                int[] ys_dia = new int[]{y, y - 4, y, y + 4};
                g.fillPolygon(xs_dia, ys_dia, 4);
            }
        }
        g.setTransform(at);
    }

    public static boolean isVertical(int fontStyle) {
        return (fontStyle & 8) != 0;
    }

    public static boolean isUnderline(int fontStyle) {
        return (fontStyle & 4) != 0;
    }

    public static boolean isBold(int fontStyle) {
        return (fontStyle & 1) != 0;
    }

    public static Rectangle getTextSize(String text, Graphics g, int fontStyle, int angle, Font font) {
        boolean vertical = Utils.isVertical(fontStyle);
        return Utils.getTextSize(text, g, vertical, angle, font);
    }

    public static Rectangle getTextSize(String text, Graphics g, boolean vertical, int angle, Font font) {
        if (text == null) {
            return new Rectangle();
        }
        Rectangle rect = null;
        rect = vertical ? Utils.getVerticalArea(text, g, angle, font) : (angle == 0 ? Utils.getHorizonArea(text, g, font) : Utils.getRotationArea(text, g, angle, font));
        if (rect.width < 0) {
            rect.width = -rect.width;
        }
        if (rect.height < 0) {
            rect.height = -rect.height;
        }
        return rect;
    }

    private static String getChar(String text) {
        int i = 0;
        while (i < text.length()) {
            char c = text.charAt(i);
            if (c > '\u00ff') {
                return "\u6c49";
            }
            ++i;
        }
        return "A";
    }

    public static Rectangle getVerticalArea(String text, Graphics g, int angle, Font font) {
        if (!StringUtils.isValidString(text)) {
            text = "A";
        }
        Rectangle area = new Rectangle();
        if (angle == 0) {
            FontMetrics fm = g.getFontMetrics(font);
            int hh = fm.getAscent();
            area.width = fm.stringWidth(Utils.getChar(text));
            area.height = hh * text.length();
        } else {
            if ((angle %= 360) < 0) {
                angle += 360;
            }
            Rectangle area0 = Utils.getVerticalArea(text, g, 0, font);
            double sin = Math.sin((double)angle * Math.PI / 180.0);
            double cos = Math.cos((double)angle * Math.PI / 180.0);
            if (sin < 0.0) {
                sin = -sin;
            }
            if (cos < 0.0) {
                cos = -cos;
            }
            int aw = (int)((double)area0.height * sin + (double)area0.width * cos);
            int ah = (int)((double)area0.width * sin + (double)area0.height * cos);
            area.width = aw;
            area.height = ah;
        }
        return area;
    }

    public static Rectangle getHorizonArea(String text, Graphics g, Font font) {
        Rectangle area = new Rectangle();
        FontMetrics fm = g.getFontMetrics(font);
        int hw = fm.stringWidth(text);
        int hh = fm.getAscent() + fm.getDescent();
        area.width = hw;
        area.height = hh;
        return area;
    }

    public static Rectangle getRotationArea(String text, Graphics g, int angle, Font font) {
        Rectangle area = new Rectangle();
        if ((angle %= 360) < 0) {
            angle += 360;
        }
        Rectangle area0 = Utils.getTextSize(text, g, 0, 0, font);
        double sin = Math.sin((double)angle * Math.PI / 180.0);
        double cos = Math.cos((double)angle * Math.PI / 180.0);
        if (sin < 0.0) {
            sin = -sin;
        }
        if (cos < 0.0) {
            cos = -cos;
        }
        int aw = (int)((double)area0.height * sin + (double)area0.width * cos);
        int ah = (int)((double)area0.width * sin + (double)area0.height * cos);
        area.width = aw;
        area.height = ah;
        return area;
    }

    public static void drawText(Graphics2D g, String txt, double dx, double dy, Font font, Color c, int fontStyle, int angle, int location) {
        Utils.drawText(g, txt, dx, dy, font, c, null, fontStyle, angle, location);
    }

    public static void drawText(Graphics2D g, String txt, double dx, double dy, Font font, Color c, Color backC, int fontStyle, int angle, int location) {
        Utils.drawText(null, txt, dx, dy, font, c, backC, fontStyle, angle, location, true, g);
    }

    public static void drawText(Engine e, String txt, double dx, double dy, Font font, Color c, int fontStyle, int angle, int location, boolean allowIntersect) {
        Utils.drawText(e, txt, dx, dy, font, c, null, fontStyle, angle, location, allowIntersect);
    }

    public static void drawText(Engine e, String txt, double dx, double dy, Font font, Color c, Color backC, int fontStyle, int angle, int location, boolean allowIntersect) {
        Utils.drawText(e, txt, dx, dy, font, c, backC, fontStyle, angle, location, allowIntersect, e.getGraphics());
    }

    public static Point getRealDrawPoint(Rectangle posDesc, int location, boolean isImage) {
        Rectangle rect = posDesc;
        int xloc = rect.x;
        int yloc = rect.y;
        yloc = location == 8 || location == 10 || location == 12 ? (isImage ? (yloc -= rect.height) : (yloc += rect.height)) : (location == 16 || location == 18 || location == 20 ? (isImage ? (yloc -= rect.height / 2) : (yloc += rect.height / 2)) : --yloc);
        xloc = location == 12 || location == 20 || location == 36 ? (xloc -= rect.width) : (location == 10 || location == 18 || location == 34 ? (xloc -= rect.width / 2) : ++xloc);
        return new Point(xloc, yloc);
    }

    public static void drawText(Engine e, String txt, double dx, double dy, Font font, Color c, Color backC, int fontStyle, int angle, int location, boolean allowIntersect, Graphics2D g) {
        if (txt == null || txt.trim().length() < 1 || font.getSize() == 0) {
            return;
        }
        int x = (int)dx;
        int y = (int)dy;
        boolean vertical = Utils.isVertical(fontStyle);
        FontMetrics fm = g.getFontMetrics(font);
        Rectangle rect = Utils.getTextSize(txt, (Graphics)g, vertical, angle, font);
        rect.x = x;
        rect.y = y;
        if (e != null) {
            if (!allowIntersect && e.intersectTextArea(rect)) {
                return;
            }
            e.addTextArea(rect);
        }
        g.setFont(font);
        g.setColor(c);
        Point drawPoint = Utils.getRealDrawPoint(rect, location, false);
        int xloc = drawPoint.x;
        int yloc = drawPoint.y;
        Utils.setGraphAntiAliasingOff(g);
        if (!vertical) {
            if (angle != 0) {
                AffineTransform at = g.getTransform();
                Rectangle rect2 = Utils.getTextSize(txt, (Graphics)g, vertical, 0, font);
                rect2.setLocation(xloc, yloc - rect2.height);
                int delx = 0;
                int dely = 0;
                if ((angle %= 360) < 0) {
                    angle += 360;
                }
                if (angle >= 0 && angle < 90) {
                    delx = 0;
                    dely = (int)((double)rect2.width * Math.sin((double)angle * Math.PI / 180.0));
                } else if (angle < 180) {
                    dely = rect.height;
                    delx = (int)((double)rect2.width * Math.cos((double)angle * Math.PI / 180.0));
                } else if (angle < 270) {
                    delx = -rect.width;
                    dely = (int)((double)(-rect2.height) * Math.sin((double)angle * Math.PI / 180.0));
                } else {
                    dely = 0;
                    delx = (int)((double)rect2.height * Math.sin((double)angle * Math.PI / 180.0));
                }
                AffineTransform at1 = AffineTransform.getRotateInstance((double)angle * Math.PI / 180.0, xloc - delx, yloc - dely);
                g.transform(at1);
                if (backC != null) {
                    g.setColor(backC);
                    g.fillRect(xloc - delx, yloc - dely - fm.getAscent(), rect2.width, rect2.height);
                }
                g.setColor(c);
                g.drawString(txt, xloc - delx, yloc - dely);
                g.setTransform(at);
            } else {
                if (backC != null) {
                    g.setColor(backC);
                    g.fillRect(xloc, yloc - fm.getAscent(), rect.width, rect.height);
                }
                g.setColor(c);
                g.drawString(txt, xloc, yloc);
            }
        } else {
            int length;
            AffineTransform at = g.getTransform();
            Rectangle rect2 = Utils.getTextSize(txt, (Graphics)g, vertical, 0, font);
            rect2.setLocation(xloc, yloc - rect2.height);
            Rectangle rect3 = Utils.getTextSize(txt.substring(0, 1), (Graphics)g, vertical, 0, font);
            int delx = 0;
            int dely = 0;
            if ((angle %= 360) < 0) {
                angle += 360;
            }
            if (angle >= 0 && angle < 90) {
                delx = 0;
                dely = (int)((double)rect2.width * Math.sin((double)angle * Math.PI / 180.0));
            } else if (angle < 180) {
                dely = rect.height;
                delx = (int)((double)rect2.width * Math.cos((double)angle * Math.PI / 180.0));
            } else if (angle < 270) {
                delx = -rect.width;
                dely = (int)((double)(-rect2.height) * Math.sin((double)angle * Math.PI / 180.0));
            } else {
                dely = 0;
                delx = (int)((double)(-rect2.height) * Math.cos((double)angle * Math.PI / 180.0));
            }
            AffineTransform at1 = AffineTransform.getRotateInstance((double)angle * Math.PI / 180.0, xloc - delx, yloc - dely);
            g.transform(at1);
            int i = length = txt.length();
            while (i > 0) {
                g.drawString(txt.substring(i - 1, i), xloc - delx, yloc - dely - rect3.height * (length - i));
                --i;
            }
            g.setTransform(at);
        }
        if (Utils.isUnderline(fontStyle) && !vertical && angle == 0) {
            Utils.setStroke(g, null, 1, 0.5f);
            Utils.drawLine(g, xloc, yloc + 2, xloc + rect.width, yloc + 2);
        }
        Utils.setGraphAntiAliasingOn(g);
    }

    public static synchronized Font getFont(String fontName, int fontStyle, int fontSize) {
        Font f;
        if (fontName == null || fontName.trim().length() < 1) {
            fontName = "dialog";
        }
        ListIterator li = globalFonts.listIterator();
        fontStyle &= 3;
        while (li.hasNext()) {
            f = (Font)li.next();
            if (!f.getFontName().equalsIgnoreCase(fontName) || f.getStyle() != fontStyle || f.getSize() != fontSize) continue;
            return f;
        }
        f = new Font(fontName, fontStyle, fontSize);
        globalFonts.add(f);
        return f;
    }

    public static int getAngleTextLocation(double angle) {
        if (angle == 0.0) {
            return 16;
        }
        if (angle < 90.0) {
            return 32;
        }
        if (angle == 90.0) {
            return 34;
        }
        if (angle < 180.0) {
            return 36;
        }
        if (angle == 180.0) {
            return 20;
        }
        if (angle < 270.0) {
            return 12;
        }
        if (angle == 270.0) {
            return 10;
        }
        if (angle < 360.0) {
            return 8;
        }
        if (angle == 360.0) {
            return 16;
        }
        return 0;
    }

    public static boolean isStackedGraph(ArrayList dataElements) {
        int i = 0;
        while (i < dataElements.size()) {
            DataElement de = (DataElement)dataElements.get(i);
            if (de instanceof Column && ((Column)de).isStacked()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String format(double o, String format) {
        return Utils.format(new Double(o), format);
    }

    public static String format(Object o, String format) {
        if (o instanceof Date) {
            SimpleDateFormat sdf = new SimpleDateFormat(format);
            return sdf.format(o);
        }
        if (o instanceof Number) {
            DecimalFormat nf = new DecimalFormat(format);
            return nf.format(o);
        }
        if (o instanceof ArrayList) {
            ArrayList series = (ArrayList)o;
            StringBuffer sb = new StringBuffer();
            int i = 0;
            int size = series.size();
            while (i <= size) {
                if (i > 1) {
                    sb.append(',');
                }
                sb.append(Utils.format(series.get(i), format));
                ++i;
            }
            return sb.toString();
        }
        return Variant.toString(o);
    }

    public static void drawRect(Graphics2D g, double x, double y, double w, double h) {
        Rectangle2D.Double rect = new Rectangle2D.Double(x, y, w, h);
        g.draw(rect);
    }

    public static void fillRect(Graphics2D g, double x, double y, double w, double h) {
        Rectangle2D.Double rect = new Rectangle2D.Double(x, y, w, h);
        g.fill(rect);
    }

    public static void fillPolygon(Graphics2D g, double[] x, double[] y) {
        Shape s = Utils.newPolygon2D(x, y);
        g.fill(s);
    }

    public static void drawPolygon(Graphics2D g, double[] x, double[] y) {
        Shape s = Utils.newPolygon2D(x, y);
        g.draw(s);
    }

    public static void fill(Graphics2D g, Shape shape, float transparent, Color c) {
        if (c == null) {
            return;
        }
        g.setColor(c);
        Utils.setTransparent(g, transparent);
        g.fill(shape);
        Utils.setTransparent(g, 1.0f);
    }

    public static void fillPaint(Graphics2D g, Shape shape, float transparent) {
        Utils.setTransparent(g, transparent);
        g.fill(shape);
        Utils.setTransparent(g, 1.0f);
    }

    public static void setTransparent(Graphics2D g, float transparent) {
        if (transparent > 1.0f) {
            transparent = 1.0f;
        } else if (transparent < 0.0f) {
            transparent = 0.0f;
        }
        g.setComposite(AlphaComposite.getInstance(3, transparent));
    }

    public static void drawLine(Graphics2D g, Point2D b, Point2D e) {
        Utils.drawLine(g, b, e, 0);
    }

    public static void drawLine(Graphics2D g, Point2D b, Point2D e, int arrow) {
        if (b == null || e == null) {
            return;
        }
        Utils.drawLine(g, b.getX(), b.getY(), e.getX(), e.getY(), arrow);
    }

    public static void draw2DRect(Graphics2D g, double x, double y, double w, double h, Color borderColor, int borderStyle, float borderWeight, boolean drawShade, boolean convexEdge, float transparent, ChartColor fillColor, boolean isVertical) {
        if (drawShade && fillColor.getColor1() != null) {
            Utils.drawRectShadow(g, x, y, w, h);
        }
        Utils.setTransparent(g, transparent);
        if (fillColor.getType() != 0) {
            Utils.setPaint(g, x, y, w, h, fillColor);
            Utils.fillRect(g, x, y, w, h);
        } else if (fillColor.getColor1() != null) {
            if (fillColor.isDazzle()) {
                double y2;
                double x2;
                double y1;
                double x1;
                CubeColor ccr = new CubeColor(fillColor.getColor1());
                Color c1 = ccr.getR1();
                Color c2 = ccr.getT1();
                if (isVertical) {
                    x1 = x;
                    y1 = y;
                    x2 = x1 + w / 2.0;
                    y2 = y1;
                } else {
                    x1 = x;
                    y1 = y;
                    x2 = x1;
                    y2 = y1 + h / 2.0;
                }
                if (c1 != null && c2 != null) {
                    GradientPaint paint = new GradientPaint((int)x1, (int)y1, c1, (int)x2, (int)y2, c2, true);
                    g.setPaint(paint);
                    Utils.fillRect(g, x1, y1, w, h);
                }
            } else if (fillColor.isGradient()) {
                if (Utils.setPaint(g, x, y, w, h, fillColor)) {
                    Utils.fillRect(g, x, y, w, h);
                }
            } else {
                if (convexEdge) {
                    Color change = CubeColor.getDazzelColor(fillColor.getColor1());
                    g.setColor(change);
                } else {
                    g.setColor(fillColor.getColor1());
                }
                Utils.fillRect(g, x, y, w, h);
            }
        }
        Utils.setTransparent(g, 1.0f);
        if (convexEdge && !fillColor.isGradient() && w > 10.0 && h > 10.0) {
            Utils.drawRaisedBorder(g, x, y, w, h, fillColor.getColor1());
        }
        if (Utils.setStroke(g, borderColor, borderStyle, borderWeight)) {
            if (borderColor != null) {
                g.setColor(borderColor);
            }
            Utils.drawRect(g, x, y, w, h);
        }
        Utils.setTransparent(g, transparent);
    }

    public static Path2D getPath2D(ArrayList<Point2D> points, boolean closePath) {
        Path2D.Double path2D = new Path2D.Double();
        int i = 0;
        while (i < points.size()) {
            Point2D p = points.get(i);
            if (i == 0) {
                path2D.moveTo(p.getX(), p.getY());
            } else {
                path2D.lineTo(p.getX(), p.getY());
            }
            ++i;
        }
        if (points.size() > 0 && closePath) {
            path2D.closePath();
        }
        return path2D;
    }

    public static Shape newPolygon2D(double[] x, double[] y) {
        return Utils.newPolygon2DShape(x, y);
    }

    public static Shape newPolygon2DShape(double[] x, double[] y) {
        Path2D.Double polygon2D = new Path2D.Double();
        polygon2D.moveTo(x[0], y[0]);
        int i = 1;
        while (i < x.length) {
            polygon2D.lineTo(x[i], y[i]);
            ++i;
        }
        polygon2D.closePath();
        return polygon2D;
    }

    private static void drawRaisedBorder(Graphics2D g, double x, double y, double w, double h, Color borderColor) {
        Color tmp;
        Color dazzel = CubeColor.getDazzelColor(borderColor);
        CubeColor ccr = new CubeColor(dazzel);
        int d = 5;
        int i = 0;
        while (i < d) {
            tmp = ccr.getLight((float)(i + 1) * 0.2f);
            Utils.setStroke(g, tmp, 1, 1.0f);
            Utils.drawLine(g, x + (double)i, y + (double)i, x + (double)i, y + h - (double)i);
            Utils.drawLine(g, x + (double)i, y + (double)i, x + w - (double)i, y + (double)i);
            ++i;
        }
        i = 0;
        while (i < d) {
            tmp = ccr.getDark((float)(i + 1) * 0.2f);
            Utils.setStroke(g, tmp, 1, 1.0f);
            Utils.drawLine(g, x + w - (double)i, y + (double)i, x + w - (double)i, y + h - (double)i);
            Utils.drawLine(g, x + (double)i, y + h - (double)i, x + w - (double)i, y + h - (double)i);
            ++i;
        }
    }

    public static int drawRectShadow(Graphics2D g, double x, double y, double w, double h) {
        if (w == 0.0 || h == 0.0) {
            return 0;
        }
        int dShadow = 4;
        w -= (double)dShadow;
        h -= (double)dShadow;
        int z = 0;
        Color cz = new Color(shadowColors[z * 3], shadowColors[z * 3 + 1], shadowColors[z * 3 + 2]);
        z = 1;
        cz = new Color(shadowColors[z * 3], shadowColors[z * 3 + 1], shadowColors[z * 3 + 2]);
        Utils.setStroke(g, cz, 1, 1.0f);
        double x1 = x + w + (double)dShadow;
        double y1 = y - 1.0;
        double x2 = x1;
        double y2 = y + h - 1.0;
        Utils.drawLine(g, x1, y1, x2, y2);
        x1 = x + w + 3.0;
        y1 = y - 2.0;
        x2 = x1;
        y2 = y1;
        Utils.drawLine(g, x1, y1, x2, y2);
        z = 2;
        cz = new Color(shadowColors[z * 3], shadowColors[z * 3 + 1], shadowColors[z * 3 + 2]);
        Utils.setStroke(g, cz, 1, 1.0f);
        x1 = x + 1.0;
        y1 = y - 2.0;
        x2 = x + w + 2.0;
        y2 = y1;
        Utils.drawLine(g, x1, y1, x2, y2);
        x1 = x + w + 3.0;
        y1 = y - 1.0;
        x2 = x1;
        y2 = y + h - 1.0;
        Utils.drawLine(g, x1, y1, x2, y2);
        z = 3;
        cz = new Color(shadowColors[z * 3], shadowColors[z * 3 + 1], shadowColors[z * 3 + 2]);
        Utils.setStroke(g, cz, 1, 1.0f);
        x1 = x + 1.0;
        y1 = y - 1.0;
        x2 = x + w + 2.0;
        y2 = y1;
        Utils.drawLine(g, x1, y1, x2, y2);
        x1 = x + w + 2.0;
        y1 = y - 1.0;
        x2 = x1;
        y2 = y + h - 1.0;
        Utils.drawLine(g, x1, y1, x2, y2);
        z = 4;
        cz = new Color(shadowColors[z * 3], shadowColors[z * 3 + 1], shadowColors[z * 3 + 2]);
        Utils.setStroke(g, cz, 1, 2.0f);
        x1 = x + w;
        y1 = y;
        Utils.fillRect(g, x1, y1, 2.0, h);
        return dShadow;
    }

    public static double getPlatformH(double coorShift) {
        double h = coorShift;
        if (h < 2.0) {
            h = 2.0;
        }
        if (h > 6.0) {
            h = 10.0;
        }
        return h;
    }

    public static Desc3DRect get3DRect(double x, double y, double w, double h, Color borderColor, int borderStyle, float borderWeight, boolean drawShade, boolean convexEdge, float transparent, ChartColor fillColor, boolean isVertical, double coorShift) {
        Desc3DRect d3 = new Desc3DRect();
        d3.x = x;
        d3.y = y;
        d3.w = w;
        d3.h = h;
        d3.borderColor = borderColor;
        d3.borderStyle = borderStyle;
        d3.borderWeight = borderWeight;
        d3.drawShade = drawShade;
        d3.convexEdge = convexEdge;
        d3.transparent = transparent;
        d3.fillColor = fillColor;
        d3.isVertical = isVertical;
        d3.coorShift = coorShift;
        return d3;
    }

    public static void draw3DRect(Graphics2D g, Desc3DRect d3) {
        Utils.draw3DRect(g, d3.x, d3.y, d3.w, d3.h, d3.borderColor, d3.borderStyle, d3.borderWeight, d3.drawShade, d3.convexEdge, d3.transparent, d3.fillColor, d3.isVertical, d3.coorShift);
    }

    public static void draw3DRect(Graphics2D g, double x, double y, double w, double h, Color borderColor, int borderStyle, float borderWeight, boolean drawShade, boolean convexEdge, float transparent, ChartColor fillColor, boolean isVertical, double coorShift) {
        Shape poly;
        if (drawShade && fillColor.getColor1() != null) {
            Utils.drawRectShadow(g, x + coorShift, y - coorShift, w, h);
        }
        CubeColor ccr = new CubeColor(fillColor.getColor1());
        if (transparent < 1.0f) {
            Utils.fill(g, new Rectangle2D.Double(x + coorShift, y - coorShift, w, h), transparent, fillColor.getColor1());
            if (Utils.setStroke(g, borderColor, borderStyle, borderWeight) && borderColor != null) {
                Utils.drawRect(g, x + coorShift, y - coorShift, w, h);
            }
            double[] xPointsB = new double[]{x, x + w, x + w + coorShift, x + coorShift};
            double[] yPointsB = new double[]{y + h, y + h, y + h - coorShift, y + h - coorShift};
            poly = Utils.newPolygon2D(xPointsB, yPointsB);
            Utils.fill(g, poly, transparent, fillColor.getColor1());
            if (Utils.setStroke(g, borderColor, borderStyle, borderWeight) && borderColor != null) {
                g.draw(poly);
            }
            double[] xPointsL = new double[]{x, x, x + coorShift, x + coorShift};
            double[] yPointsL = new double[]{y, y + h, y + h - coorShift, y - coorShift};
            poly = Utils.newPolygon2D(xPointsL, yPointsL);
            Utils.fill(g, poly, transparent, fillColor.getColor1());
            if (Utils.setStroke(g, borderColor, borderStyle, borderWeight) && borderColor != null) {
                g.draw(poly);
            }
        }
        double[] xPointsR = new double[]{x + w, x + w, x + w + coorShift, x + w + coorShift};
        double[] yPointsR = new double[]{y, y + h, y + h - coorShift, y - coorShift};
        poly = Utils.newPolygon2D(xPointsR, yPointsR);
        Rectangle bound = poly.getBounds();
        if (fillColor.isGradient()) {
            ChartColor tmpcc = new ChartColor();
            tmpcc.setGradient(true);
            tmpcc.setAngle(270);
            if (isVertical) {
                tmpcc.setColor1(ccr.getR1());
                tmpcc.setColor2(ccr.getR2());
            } else {
                tmpcc.setColor1(ccr.getT1());
                tmpcc.setColor2(ccr.getT2());
            }
            if (Utils.setPaint(g, bound.x, bound.y, bound.width, bound.height, tmpcc)) {
                Utils.fillPaint(g, poly, transparent);
            }
        } else {
            Utils.fill(g, poly, transparent, ccr.getR1());
        }
        if (Utils.setStroke(g, borderColor, borderStyle, borderWeight) && borderColor != null) {
            g.draw(poly);
        }
        double[] xPointsT = new double[]{x, x + w, x + w + coorShift, x + coorShift};
        double[] yPointsT = new double[]{y, y, y - coorShift, y - coorShift};
        poly = Utils.newPolygon2D(xPointsT, yPointsT);
        bound = poly.getBounds();
        if (fillColor.isGradient()) {
            ChartColor tmpcc = new ChartColor();
            tmpcc.setGradient(true);
            tmpcc.setAngle(180);
            if (isVertical) {
                tmpcc.setColor1(ccr.getT1());
                tmpcc.setColor2(ccr.getT2());
            } else {
                tmpcc.setColor1(ccr.getR1());
                tmpcc.setColor2(ccr.getR2());
            }
            if (Utils.setPaint(g, bound.x, bound.y, bound.width, bound.height, tmpcc)) {
                Utils.fillPaint(g, poly, transparent);
            }
        } else {
            Utils.fill(g, poly, transparent, ccr.getT2());
        }
        if (Utils.setStroke(g, borderColor, borderStyle, borderWeight) && borderColor != null) {
            g.draw(poly);
        }
        boolean isSet = false;
        if (fillColor.isDazzle()) {
            ChartColor tmpcc = new ChartColor();
            if (isVertical) {
                tmpcc.setColor1(ccr.getF1());
                tmpcc.setColor2(ccr.getF2());
                tmpcc.setAngle(270);
            } else {
                tmpcc.setColor1(ccr.getF1());
                tmpcc.setColor2(ccr.getF2());
                tmpcc.setAngle(180);
            }
            isSet = Utils.setPaint(g, x, y, w, h, tmpcc);
        } else {
            isSet = Utils.setPaint(g, x, y, w, h, fillColor);
        }
        if (isSet) {
            Utils.fillPaint(g, new Rectangle2D.Double(x, y, w, h), transparent);
        }
        if (convexEdge && !fillColor.isGradient() && w > 10.0 && h > 10.0) {
            Utils.drawRaisedBorder(g, x, y, w, h, fillColor.getColor1());
        }
        if (Utils.setStroke(g, borderColor, borderStyle, borderWeight) && borderColor != null) {
            Utils.drawRect(g, x, y, w, h);
        }
    }

    private static Color getShadeColor(int z) {
        if (z > 4) {
            z = 4;
        }
        return new Color(shadowColors[z * 3], shadowColors[z * 3 + 1], shadowColors[z * 3 + 2]);
    }

    private static Rectangle2D getSmallerBounds(Rectangle2D orginal, int deltaSize) {
        double h;
        if (deltaSize == 0) {
            return orginal;
        }
        double x = orginal.getX();
        double y = orginal.getY();
        double w = orginal.getWidth();
        if (w >= (h = orginal.getHeight())) {
            double scale = h / w;
            w -= (double)(deltaSize * 2);
            h -= (double)(deltaSize * 2) * scale;
            x += (double)deltaSize;
            y += (double)deltaSize * scale;
        } else {
            double scale = w / h;
            w -= (double)(deltaSize * 2) * scale;
            h -= (double)(deltaSize * 2);
            x += (double)deltaSize * scale;
            y += (double)deltaSize;
        }
        return new Rectangle2D.Double(x, y, w, h);
    }

    public static void draw2DPie(Graphics2D g, Rectangle2D ellipseBounds, double startAngle, double extentAngle, Color borderColor, int borderStyle, float borderWeight, float transparent, ChartColor fillColor, int dazzelCount) {
        Utils.draw2DArc(g, ellipseBounds, startAngle, extentAngle, borderColor, borderStyle, borderWeight, transparent, fillColor, dazzelCount, 2);
    }

    public static void draw2DArc(Graphics2D g, Rectangle2D ellipseBounds, double startAngle, double extentAngle, Color borderColor, int borderStyle, float borderWeight, float transparent, ChartColor fillColor, int dazzelCount, int arcType) {
        Arc2D.Double arc = new Arc2D.Double(ellipseBounds, startAngle, extentAngle, arcType);
        Rectangle rect = ellipseBounds.getBounds();
        ChartColor cc = fillColor;
        if (cc.isDazzle()) {
            Color dazzel = CubeColor.getDazzelColor(cc.getColor1());
            CubeColor ccr = new CubeColor(dazzel);
            if (dazzelCount > 10) {
                dazzelCount = 10;
            }
            int k = 0;
            while (k < dazzelCount) {
                Rectangle2D tmpBounds = Utils.getSmallerBounds(ellipseBounds, k);
                Arc2D.Double tmpArc = new Arc2D.Double(tmpBounds, startAngle, extentAngle, arcType);
                Color tmp = ccr.getDark(0.5f + (float)k * 0.07f);
                rect = tmpBounds.getBounds();
                if (k == dazzelCount - 1) {
                    if (ccr.getF2() != null && ccr.getF1() != null) {
                        GradientPaint gp = new GradientPaint(rect.x, rect.y + rect.height, ccr.getF2(), rect.x + rect.width / 2, rect.y + rect.height / 2, ccr.getF1(), true);
                        g.setPaint(gp);
                        Utils.fillPaint(g, tmpArc, transparent);
                    }
                } else {
                    Utils.fill(g, tmpArc, transparent, tmp);
                }
                ++k;
            }
        } else if (cc.color1 != null && Utils.setPaint(g, rect.x, rect.y, rect.width, rect.height, cc)) {
            Utils.fillPaint(g, arc, transparent);
        }
        if (Utils.setStroke(g, borderColor, borderStyle, borderWeight)) {
            g.draw(arc);
        }
    }

    public static void drawLine(Graphics2D g, double x1, double y1, double x2, double y2) {
        Utils.drawLine(g, x1, y1, x2, y2, 0);
    }

    public static void drawLine(Graphics2D g, double x1, double y1, double x2, double y2, int arrow) {
        Line2D.Double line = new Line2D.Double(x1, y1, x2, y2);
        g.draw(line);
        if (arrow == 256 || arrow == 1536) {
            double radian = Math.atan2(y2 - y1, x2 - x1);
            double x = x2;
            double y = y2;
            if (arrow == 1536) {
                x = x1;
                y = y1;
            }
            Utils.drawLineArrow(g, x, y, radian, arrow);
        }
    }

    public static void setColor(Graphics2D g, Color c) {
        if (c != null) {
            g.setColor(c);
        }
    }

    private static boolean setPointPaint(Graphics2D g, ChartColor cc, Shape pShape) {
        if (cc.getColor1() == null) {
            return false;
        }
        Rectangle2D bound = pShape.getBounds2D();
        boolean isCircle = pShape instanceof Ellipse2D.Double;
        if (cc.isDazzle()) {
            Paint paint = null;
            if (isCircle) {
                Ball ball = new Ball(cc.getColor1(), 0);
                double L = 2.0;
                double x = bound.getX() - L;
                double y = bound.getY() - L;
                double w = bound.getWidth() + L * 2.0;
                double h = bound.getHeight() + L * 2.0;
                Rectangle2D.Double bd = new Rectangle2D.Double(x, y, w, h);
                paint = new TexturePaint(ball.imgs[4], bd);
            } else {
                CubeColor cuc = new CubeColor(cc.getColor1());
                paint = new GradientPaint((int)bound.getX(), (int)(bound.getY() + bound.getHeight()), cuc.getF2(), (int)(bound.getX() + bound.getWidth() / 2.0), (int)(bound.getY() + bound.getHeight() / 2.0), cuc.getF1(), true);
            }
            g.setPaint(paint);
        } else {
            Utils.setPaint(g, (int)bound.getX(), (int)bound.getY(), (int)bound.getWidth(), (int)bound.getHeight(), cc);
        }
        return true;
    }

    private static Shape getCPoint1ShapeArea(int shape, double x, double y, double radiusx, double radiusy) {
        Shape pShape = null;
        switch (shape) {
            case 0: {
                break;
            }
            case 1: {
                pShape = new Ellipse2D.Double(x - radiusx, y - radiusy, radiusx * 2.0, radiusy * 2.0);
                break;
            }
            case 2: {
                pShape = new Rectangle2D.Double(x - radiusx, y - radiusy, radiusx * 2.0, radiusy * 2.0);
                break;
            }
            case 3: {
                double[] xs_tr = new double[]{x - radiusx * Math.cos(Math.toRadians(30.0)), x, x + radiusx * Math.cos(Math.toRadians(30.0))};
                double[] ys_tr = new double[]{y + radiusy / 2.0, y - radiusy, y + radiusy / 2.0};
                pShape = Utils.newPolygon2DShape(xs_tr, ys_tr);
                break;
            }
            case 4: {
                pShape = new Rectangle2D.Double(x - radiusx, y - radiusy * 7.0 / 10.0, radiusx * 2.0, radiusy * 7.0 / 5.0);
                break;
            }
            case 5: {
                pShape = new Ellipse2D.Double(x - radiusx, y - radiusy, radiusx * 2.0, radiusy * 2.0);
                break;
            }
            case 6: {
                double[] xs_di = new double[]{x - radiusx, x, x + radiusx, x};
                double[] ys_di = new double[]{y, y - radiusy, y, y + radiusy};
                pShape = Utils.newPolygon2DShape(xs_di, ys_di);
                break;
            }
            case 7: {
                pShape = new Rectangle2D.Double(x - radiusx, y - radiusy, radiusx * 2.0, radiusy * 2.0);
                break;
            }
            case 8: {
                pShape = new Rectangle2D.Double(x - radiusx, y - radiusy, radiusx * 2.0, radiusy * 2.0);
                break;
            }
            case 9: {
                pShape = new Ellipse2D.Double(x - radiusx, y - radiusy, radiusx * 2.0, radiusy * 2.0);
                break;
            }
            case 10: {
                pShape = new Rectangle2D.Double(x - radiusx, y - radiusy, radiusx * 2.0, radiusy * 2.0);
                break;
            }
            case 11: {
                double delta = radiusx * Math.cos(Math.toRadians(30.0));
                double[] xs_dtr1 = new double[]{x - delta, x, x + delta};
                double[] ys_dtr1 = new double[]{y + radiusy / 2.0, y - radiusy, y + radiusy / 2.0};
                pShape = Utils.newPolygon2DShape(xs_dtr1, ys_dtr1);
                break;
            }
            case 12: {
                pShape = new Rectangle2D.Double(x - radiusx, y - radiusy * 7.0 / 10.0, radiusx * 2.0, radiusy * 7.0 / 5.0);
                break;
            }
            case 13: {
                double[] xs_ddi2 = new double[]{x - radiusx, x, x + radiusx, x};
                double[] ys_ddi2 = new double[]{y, y - radiusy, y, y + radiusy};
                pShape = Utils.newPolygon2DShape(xs_ddi2, ys_ddi2);
                break;
            }
            case 14: {
                pShape = new Ellipse2D.Double(x - radiusx, y - radiusy, radiusx * 2.0, radiusy * 2.0);
                break;
            }
            case 15: {
                pShape = new Rectangle2D.Double(x - radiusx, y - radiusy, radiusx * 2.0, radiusy * 2.0);
                break;
            }
            case 16: {
                double[] xs_trp = new double[]{x - radiusx * Math.cos(Math.toRadians(30.0)), x, x + radiusx * Math.cos(Math.toRadians(30.0))};
                double[] ys_trp = new double[]{y + radiusy / 2.0, y - radiusy, y + radiusy / 2.0};
                pShape = Utils.newPolygon2DShape(xs_trp, ys_trp);
                break;
            }
            case 17: {
                pShape = new Rectangle2D.Double(x - radiusx, y - radiusy * 7.0 / 10.0, radiusx * 2.0, radiusy * 7.0 / 5.0);
                break;
            }
            case 18: {
                double[] xs_dip = new double[]{x - radiusx, x, x + radiusx, x};
                double[] ys_dip = new double[]{y, y - radiusy, y, y + radiusy};
                pShape = Utils.newPolygon2DShape(xs_dip, ys_dip);
            }
        }
        return pShape;
    }

    public static Shape drawCartesianPoint1(Graphics2D g, Point2D point, int shape, double radiusx, double radiusy, double rw, int style, float weight, float transparent) {
        double x = point.getX();
        double y = point.getY();
        if (radiusx == 0.0 && radiusy == 0.0) {
            radiusx = rw;
            radiusy = rw;
        }
        if (radiusx + radiusy == 0.0) {
            return null;
        }
        if (radiusx == 0.0) {
            Point2D.Double p1 = new Point2D.Double(x, y - radiusy);
            Point2D.Double p2 = new Point2D.Double(x, y + radiusy);
            return Utils.drawLine1(g, p1, p2, style, weight);
        }
        if (radiusy == 0.0) {
            Point2D.Double p1 = new Point2D.Double(x - radiusx, y);
            Point2D.Double p2 = new Point2D.Double(x + radiusx, y);
            return Utils.drawLine1(g, p1, p2, style, weight);
        }
        Shape linkShape = null;
        Shape pShape = null;
        int shadowShift = (int)(radiusx * 0.2);
        if (shadowShift < SHADE_SPAN) {
            shadowShift = SHADE_SPAN;
        }
        linkShape = Utils.getCPoint1ShapeArea(shape, x, y, radiusx, radiusy);
        pShape = Utils.getCPoint1ShapeArea(shape, x += (double)shadowShift, y += (double)shadowShift, radiusx, radiusy);
        if (pShape != null) {
            Utils.fillRadioGradientShape(g, pShape, Color.darkGray, Color.white, transparent / 2.0f);
        }
        return linkShape;
    }

    private static Shape getLouKongShape(Shape outer, Shape inner) {
        Area area = new Area(outer);
        Area sArea = new Area(inner);
        area.subtract(sArea);
        return area;
    }

    public static Shape drawCartesianPoint2(Graphics2D g, Point2D point, int shape, double radiusx, double radiusy, double rw, int style, float weight, ChartColor ccr, Color foreColor, float transparent) {
        double x = point.getX();
        double y = point.getY();
        if (rw == 0.0 && (rw = (double)(weight / 2.0f + 1.0f)) < 4.0) {
            rw = 3.0;
        }
        if (radiusx == 0.0 && radiusy == 0.0) {
            radiusx = rw;
            radiusy = rw;
        }
        if (radiusx == radiusy) {
            weight = 1.0f;
        }
        if (radiusx == 0.0) {
            Point2D.Double p1 = new Point2D.Double(x, y - radiusy);
            Point2D.Double p2 = new Point2D.Double(x, y + radiusy);
            Utils.drawLine2(g, p1, p2, ccr.color1, style, weight);
            return new Rectangle((int)(x - 2.0), (int)(y - radiusy), 4, (int)(2.0 * radiusy));
        }
        if (radiusy == 0.0) {
            Point2D.Double p1 = new Point2D.Double(x - radiusx, y);
            Point2D.Double p2 = new Point2D.Double(x + radiusx, y);
            Utils.drawLine2(g, p1, p2, ccr.color1, style, weight);
            return new Rectangle((int)(x - radiusx), (int)(y - 2.0), (int)(2.0 * radiusx), 4);
        }
        Shape fillShape = null;
        ArrayList<Shape> drawShapes = new ArrayList<Shape>();
        switch (shape) {
            case 0: {
                break;
            }
            case 1: {
                fillShape = new Ellipse2D.Double(x - radiusx, y - radiusy, radiusx * 2.0, radiusy * 2.0);
                break;
            }
            case 19: {
                fillShape = new Ellipse2D.Double(x - radiusx, y - radiusy, radiusx * 2.0, radiusy * 2.0);
                g.setColor(foreColor);
                Utils.fillPaint(g, fillShape, transparent);
                return fillShape;
            }
            case 2: {
                fillShape = new Rectangle2D.Double(x - radiusx, y - radiusy, radiusx * 2.0, radiusy * 2.0);
                break;
            }
            case 3: {
                double[] xs_tr = new double[]{x - radiusx * Math.cos(Math.toRadians(30.0)), x, x + radiusx * Math.cos(Math.toRadians(30.0))};
                double[] ys_tr = new double[]{y + radiusy / 2.0, y - radiusy, y + radiusy / 2.0};
                fillShape = Utils.newPolygon2DShape(xs_tr, ys_tr);
                break;
            }
            case 4: {
                fillShape = new Rectangle2D.Double(x - radiusx, y - radiusy * 7.0 / 10.0, radiusx * 2.0, radiusy * 7.0 / 5.0);
                break;
            }
            case 5: {
                fillShape = new Ellipse2D.Double(x - radiusx, y - radiusy, radiusx * 2.0, radiusy * 2.0);
                if (!Utils.setStroke(g, foreColor, style, weight)) break;
                double deltax = radiusx * Math.cos(Math.toRadians(45.0));
                double deltay = radiusy * Math.cos(Math.toRadians(45.0));
                drawShapes.add(new Line2D.Double(x, y - radiusy, x, y + radiusy));
                drawShapes.add(new Line2D.Double(x - deltax, y - deltay, x + deltax, y + deltay));
                drawShapes.add(new Line2D.Double(x - deltax, y + deltay, x + deltax, y - deltay));
                break;
            }
            case 6: {
                double[] xs_di = new double[]{x - radiusx, x, x + radiusx, x};
                double[] ys_di = new double[]{y, y - radiusy, y, y + radiusy};
                fillShape = Utils.newPolygon2DShape(xs_di, ys_di);
                break;
            }
            case 7: {
                fillShape = new Rectangle2D.Double(x - radiusx, y - radiusy, radiusx * 2.0, radiusy * 2.0);
                if (!Utils.setStroke(g, foreColor, style, weight)) break;
                double deltax = radiusx * Math.cos(Math.toRadians(45.0));
                double deltay = radiusy * Math.cos(Math.toRadians(45.0));
                drawShapes.add(new Line2D.Double(x - deltax, y - deltay, x + deltax, y + deltay));
                drawShapes.add(new Line2D.Double(x - deltax, y + deltay, x + deltax, y - deltay));
                break;
            }
            case 8: {
                fillShape = new Rectangle2D.Double(x - radiusx, y - radiusy, radiusx * 2.0, radiusy * 2.0);
                if (!Utils.setStroke(g, foreColor, style, weight)) break;
                drawShapes.add(new Line2D.Double(x - radiusx, y, x + radiusx, y));
                drawShapes.add(new Line2D.Double(x, y + radiusy, x, y - radiusy));
                break;
            }
            case 9: {
                Shape outerShape = new Ellipse2D.Double(x - radiusx, y - radiusy, radiusx * 2.0, radiusy * 2.0);
                Shape innerShape = new Ellipse2D.Double(x - radiusx / 2.0, y - radiusy / 2.0, radiusx, radiusy);
                fillShape = Utils.getLouKongShape(outerShape, innerShape);
                break;
            }
            case 10: {
                Shape outerShape = new Rectangle2D.Double(x - radiusx, y - radiusy, radiusx * 2.0, radiusy * 2.0);
                Shape innerShape = new Rectangle2D.Double(x - radiusx / 2.0, y - radiusy / 2.0, radiusx, radiusy);
                fillShape = Utils.getLouKongShape(outerShape, innerShape);
                break;
            }
            case 11: {
                double delta = radiusx * Math.cos(Math.toRadians(30.0));
                double[] xs_dtr1 = new double[]{x - delta, x, x + delta};
                double[] ys_dtr1 = new double[]{y + radiusy / 2.0, y - radiusy, y + radiusy / 2.0};
                Shape outerShape = Utils.newPolygon2DShape(xs_dtr1, ys_dtr1);
                double[] xs_dtr2 = new double[]{x - radiusx / 2.0 * Math.cos(Math.toRadians(30.0)), x, x + radiusx / 2.0 * Math.cos(Math.toRadians(30.0))};
                double[] ys_dtr2 = new double[]{y + radiusy / 4.0, y - radiusy / 2.0, y + radiusy / 4.0};
                Shape innerShape = Utils.newPolygon2DShape(xs_dtr2, ys_dtr2);
                fillShape = Utils.getLouKongShape(outerShape, innerShape);
                break;
            }
            case 12: {
                Shape outerShape = new Rectangle2D.Double(x - radiusx, y - radiusy * 7.0 / 10.0, radiusx * 2.0, radiusy * 7.0 / 5.0);
                Shape innerShape = new Rectangle2D.Double(x - radiusx / 2.0, y - radiusy * 7.0 / 20.0, radiusx, radiusy * 7.0 / 10.0);
                fillShape = Utils.getLouKongShape(outerShape, innerShape);
                break;
            }
            case 13: {
                double[] xs_ddi2 = new double[]{x - radiusx, x, x + radiusx, x};
                double[] ys_ddi2 = new double[]{y, y - radiusy, y, y + radiusy};
                Shape outerShape = Utils.newPolygon2DShape(xs_ddi2, ys_ddi2);
                double[] xs_ddi1 = new double[]{x - radiusx / 2.0, x, x + radiusx / 2.0, x};
                double[] ys_ddi1 = new double[]{y, y - radiusy / 2.0, y, y + radiusy / 2.0};
                Shape innerShape = Utils.newPolygon2DShape(xs_ddi1, ys_ddi1);
                fillShape = Utils.getLouKongShape(outerShape, innerShape);
                break;
            }
            case 14: {
                fillShape = new Ellipse2D.Double(x - radiusx, y - radiusy, radiusx * 2.0, radiusy * 2.0);
                if (!Utils.setStroke(g, foreColor, style, weight)) break;
                drawShapes.add(fillShape);
                drawShapes.add(new Line2D.Double(x, y - radiusy, x, y + radiusy));
                drawShapes.add(new Line2D.Double(x - radiusx, y, x + radiusx, y));
                break;
            }
            case 15: {
                fillShape = new Rectangle2D.Double(x - radiusx, y - radiusy, radiusx * 2.0, radiusy * 2.0);
                if (!Utils.setStroke(g, foreColor, style, weight)) break;
                drawShapes.add(fillShape);
                drawShapes.add(new Line2D.Double(x, y - radiusy, x, y + radiusy));
                drawShapes.add(new Line2D.Double(x - radiusx, y, x + radiusx, y));
                break;
            }
            case 16: {
                double[] xs_trp = new double[]{x - radiusx * Math.cos(Math.toRadians(30.0)), x, x + radiusx * Math.cos(Math.toRadians(30.0))};
                double[] ys_trp = new double[]{y + radiusy / 2.0, y - radiusy, y + radiusy / 2.0};
                fillShape = Utils.newPolygon2DShape(xs_trp, ys_trp);
                if (!Utils.setStroke(g, foreColor, style, weight)) break;
                drawShapes.add(fillShape);
                drawShapes.add(new Line2D.Double(x, y - radiusy, x, y + radiusy / 2.0));
                drawShapes.add(new Line2D.Double(x - radiusx * Math.tan(Math.toRadians(30.0)), y, x + radiusx * Math.tan(Math.toRadians(30.0)), y));
                break;
            }
            case 17: {
                fillShape = new Rectangle2D.Double(x - radiusx, y - radiusy * 7.0 / 10.0, radiusx * 2.0, radiusy * 7.0 / 5.0);
                if (!Utils.setStroke(g, foreColor, style, weight)) break;
                drawShapes.add(fillShape);
                drawShapes.add(new Line2D.Double(x, y - radiusy * 7.0 / 10.0, x, y + radiusy * 7.0 / 10.0));
                drawShapes.add(new Line2D.Double(x - radiusx, y, x + radiusx, y));
                break;
            }
            case 18: {
                double[] xs_dip = new double[]{x - radiusx, x, x + radiusx, x};
                double[] ys_dip = new double[]{y, y - radiusy, y, y + radiusy};
                fillShape = Utils.newPolygon2DShape(xs_dip, ys_dip);
                if (!Utils.setStroke(g, foreColor, style, weight)) break;
                drawShapes.add(fillShape);
                drawShapes.add(new Line2D.Double(x - radiusx, y, x + radiusx, y));
                drawShapes.add(new Line2D.Double(x, y - radiusy, x, y + radiusy));
            }
        }
        if (fillShape != null) {
            if (Utils.setPointPaint(g, ccr, fillShape)) {
                Utils.fillPaint(g, fillShape, transparent);
            }
            if (Utils.setStroke(g, foreColor, style, weight)) {
                if (drawShapes.isEmpty()) {
                    g.draw(fillShape);
                } else {
                    int i = 0;
                    while (i < drawShapes.size()) {
                        Shape s = (Shape)drawShapes.get(i);
                        g.draw(s);
                        ++i;
                    }
                }
            }
        }
        return fillShape;
    }

    private static Shape getPPoint1ShapeArea(int shape, PolarCoor pc, double r, double a, double radiusR, double radiusA, int shadowShift) {
        Shape pShape = null;
        switch (shape) {
            case 0: {
                break;
            }
            case 2: 
            case 4: {
                Rectangle2D bound = pc.getEllipseBounds(r + radiusR);
                Arc2D.Double arc = new Arc2D.Double(bound.getX() + (double)shadowShift, bound.getY() + (double)shadowShift, bound.getWidth(), bound.getHeight(), a - radiusA, radiusA * 2.0, 2);
                Area bigArea = new Area(arc);
                if (r > radiusR) {
                    bound = pc.getEllipseBounds(r - radiusR);
                    arc = new Arc2D.Double(bound.getX() + (double)shadowShift, bound.getY() + (double)shadowShift, bound.getWidth(), bound.getHeight(), a - radiusA - 5.0, radiusA * 2.0 + 10.0, 2);
                    Area sArea = new Area(arc);
                    bigArea.subtract(sArea);
                }
                pShape = bigArea;
                break;
            }
            case 6: {
                double[] xs_di = new double[4];
                double[] ys_di = new double[4];
                Point2D.Double polarDot = new Point2D.Double(r + radiusR, a);
                Point2D p1 = pc.getScreenPoint(polarDot);
                xs_di[0] = p1.getX();
                ys_di[0] = p1.getY();
                polarDot = new Point2D.Double(r, a + radiusA);
                p1 = pc.getScreenPoint(polarDot);
                xs_di[1] = p1.getX();
                ys_di[1] = p1.getY();
                polarDot = new Point2D.Double(r - radiusR, a);
                p1 = pc.getScreenPoint(polarDot);
                xs_di[2] = p1.getX();
                ys_di[2] = p1.getY();
                polarDot = new Point2D.Double(r, a - radiusA);
                p1 = pc.getScreenPoint(polarDot);
                xs_di[3] = p1.getX();
                ys_di[3] = p1.getY();
                pShape = Utils.newPolygon2DShape(xs_di, ys_di);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                throw new RuntimeException("Unsupportted dot shape:" + shape + " in polar coordinate system.");
            }
        }
        return pShape;
    }

    public static Shape drawPolarPoint1(Graphics2D g, Point2D point, int shape, double radiusR, double radiusA, double rw, int style, float weight, PolarCoor pc, float transparent) {
        if (radiusR == 0.0 && radiusA == 0.0) {
            return Utils.drawCartesianPoint1(g, point, shape, 0.0, 0.0, rw, style, weight, transparent);
        }
        double r = point.getX();
        double a = point.getY();
        int shadowShift = (int)(radiusR * 0.2);
        int dLinkShift = 1;
        if (shadowShift < SHADE_SPAN) {
            shadowShift = SHADE_SPAN;
        }
        if (radiusR == 0.0) {
            Color dark = Utils.getShadeColor(1);
            Rectangle2D bound = pc.getEllipseBounds(r);
            Arc2D.Double arc = new Arc2D.Double(bound.getX() + (double)shadowShift, bound.getY() + (double)shadowShift, bound.getWidth(), bound.getHeight(), a - radiusA, radiusA * 2.0, 0);
            if (Utils.setStroke(g, dark, style, weight)) {
                g.draw(arc);
            }
            arc = new Arc2D.Double(bound.getX() - (double)dLinkShift, bound.getY() - (double)dLinkShift, bound.getWidth() + (double)(dLinkShift * 2), bound.getHeight() + (double)(dLinkShift * 2), a - radiusA, radiusA * 2.0, 2);
            Arc2D.Double arcSmall = new Arc2D.Double(bound.getX() + (double)dLinkShift, bound.getY() + (double)dLinkShift, bound.getWidth() - (double)(dLinkShift * 2), bound.getHeight() - (double)(dLinkShift * 2), a - radiusA - 10.0, radiusA * 2.0 + 5.0, 2);
            Area arcArea = new Area(arc);
            Area arcSmallArea = new Area(arcSmall);
            arcArea.subtract(arcSmallArea);
            return arcArea;
        }
        if (radiusA == 0.0) {
            Point2D.Double polarDot = new Point2D.Double(r + radiusR, a);
            Point2D p1 = pc.getScreenPoint(polarDot);
            polarDot = new Point2D.Double(r - radiusR, a);
            Point2D p2 = pc.getScreenPoint(polarDot);
            return Utils.drawLine1(g, p1, p2, style, weight);
        }
        Shape pShape = Utils.getPPoint1ShapeArea(shape, pc, r, a, radiusR, radiusA, shadowShift);
        if (pShape != null) {
            Utils.fillRadioGradientShape(g, pShape, Color.darkGray, Color.white, transparent / 2.0f);
        }
        Shape linkShape = Utils.getPPoint1ShapeArea(shape, pc, r, a, radiusR, radiusA, 0);
        return linkShape;
    }

    public static void drawPolarPoint2(Graphics2D g, Point2D point, int shape, double radiusR, double radiusA, double rw, int style, float weight, PolarCoor pc, ChartColor ccr, Color foreColor, float transparent) {
        if (radiusR == 0.0 && radiusA == 0.0) {
            point = pc.getScreenPoint(point);
            Utils.drawCartesianPoint2(g, point, shape, 0.0, 0.0, rw, style, weight, ccr, foreColor, transparent);
            return;
        }
        double r = point.getX();
        double a = point.getY();
        if (radiusR == 0.0) {
            Rectangle2D bound = pc.getEllipseBounds(r);
            Arc2D.Double arc = new Arc2D.Double(bound.getX(), bound.getY(), bound.getWidth(), bound.getHeight(), a - radiusA, radiusA * 2.0, 0);
            if (Utils.setStroke(g, foreColor, style, weight)) {
                g.draw(arc);
            }
            return;
        }
        if (radiusA == 0.0) {
            Point2D.Double polarDot = new Point2D.Double(r + radiusR, a);
            Point2D p1 = pc.getScreenPoint(polarDot);
            polarDot = new Point2D.Double(r - radiusR, a);
            Point2D p2 = pc.getScreenPoint(polarDot);
            Utils.drawLine2(g, p1, p2, foreColor, style, weight);
            return;
        }
        Shape pShape = null;
        switch (shape) {
            case 0: {
                break;
            }
            case 2: 
            case 4: {
                Rectangle2D bigBounds = pc.getEllipseBounds(r + radiusR);
                Rectangle2D smallBounds = pc.getEllipseBounds(r - radiusR);
                Utils.draw2DRing(g, bigBounds, smallBounds, a - radiusA, radiusA * 2.0, foreColor, style, weight, transparent, ccr);
                return;
            }
            case 6: {
                double[] xs_di = new double[4];
                double[] ys_di = new double[4];
                Point2D.Double polarDot = new Point2D.Double(r + radiusR, a);
                Point2D p1 = pc.getScreenPoint(polarDot);
                xs_di[0] = p1.getX();
                ys_di[0] = p1.getY();
                polarDot = new Point2D.Double(r, a + radiusA);
                p1 = pc.getScreenPoint(polarDot);
                xs_di[1] = p1.getX();
                ys_di[1] = p1.getY();
                polarDot = new Point2D.Double(r - radiusR, a);
                p1 = pc.getScreenPoint(polarDot);
                xs_di[2] = p1.getX();
                ys_di[2] = p1.getY();
                polarDot = new Point2D.Double(r, a - radiusA);
                p1 = pc.getScreenPoint(polarDot);
                xs_di[3] = p1.getX();
                ys_di[3] = p1.getY();
                pShape = Utils.newPolygon2DShape(xs_di, ys_di);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                throw new RQException("Unsupportted dot shape:" + shape + " in polar coordinate system.");
            }
        }
        if (pShape != null) {
            Rectangle bd = pShape.getBounds();
            if (Utils.setPointPaint(g, ccr, pShape)) {
                g.fill(pShape);
            }
            if (Utils.setStroke(g, foreColor, style, weight)) {
                g.draw(pShape);
            }
        }
    }

    public static void setParamsEngine(IElement chartElement) {
        try {
            Field[] fields = chartElement.getClass().getFields();
            int size = fields.length;
            int i = 0;
            while (i < size) {
                Field f = fields[i];
                Object param = f.get(chartElement);
                if (param instanceof Para) {
                    ((Para)param).setEngine(chartElement.getEngine());
                }
                ++i;
            }
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    public static void setIsGif(boolean isGif) {
        tlIsGif.set(isGif);
    }

    public static boolean isGif() {
        return tlIsGif.get();
    }

    public static void setGraphAntiAliasingOn(Graphics2D g) {
        if (Utils.isGif()) {
            Utils.setGraphAntiAliasingOff(g);
            return;
        }
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    }

    public static void setGraphAntiAliasingOff(Graphics2D g) {
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
    }

    public static ChartColor sequenceToChartColor(Sequence seq) {
        if (seq.length() < 1) {
            return null;
        }
        Object prefix = seq.get(1);
        if (StringUtils.isValidString(prefix) && (prefix = Escape.removeEscAndQuote((String)prefix)).equals("ChartColor")) {
            return ChartColor.getInstance(seq);
        }
        return null;
    }

    public static Object parseCategory(Object data) {
        if (data == null) {
            return null;
        }
        if (!(data instanceof String)) {
            return data;
        }
        String val = (String)data;
        int commaIndex = val.indexOf(",");
        if (commaIndex > -1) {
            return val.substring(0, commaIndex);
        }
        return val;
    }

    public static Object parseSeries(Object data) {
        if (data == null) {
            return null;
        }
        if (!(data instanceof String)) {
            return data;
        }
        String val = (String)data;
        int commaIndex = val.indexOf(",");
        if (commaIndex > -1) {
            return val.substring(commaIndex + 1);
        }
        if (val.indexOf(",") > -1) {
            StringTokenizer st = new StringTokenizer(val, ",");
            st.nextToken();
            String ser = st.nextToken();
            return ser;
        }
        return null;
    }

    public static int indexOf(Sequence enumData, String catName, String serName) {
        if (catName == null) {
            return 0;
        }
        String tmp = catName;
        if (serName != null) {
            tmp = String.valueOf(tmp) + "," + serName;
        }
        return enumData.firstIndexOf(tmp);
    }

    public static double sumCategory(String catName, Sequence enumData, Sequence numData) {
        double sum = 0.0;
        int size = enumData.length();
        int i = 1;
        while (i <= size) {
            double d;
            Object enumObj = enumData.get(i);
            Object cat = Utils.parseCategory(enumObj);
            if (catName.equals(cat) && (d = ((Number)numData.get(i)).doubleValue()) > 0.0) {
                sum += d;
            }
            ++i;
        }
        return sum;
    }

    public static void drawCylinderTop(Graphics2D g, Arc2D.Double topOval, Color bc, int bs, float bw, float transparent, ChartColor chartColor, boolean isVertical) {
        Rectangle bound = topOval.getBounds();
        CubeColor ccr = new CubeColor(chartColor.getColor1());
        if (chartColor.isDazzle()) {
            if (ccr.getT1() != null && ccr.getT2() != null) {
                GradientPaint gp = isVertical ? new GradientPaint(bound.x, bound.y, ccr.getT2(), bound.x + bound.width / 2, bound.y + bound.height / 2, ccr.getT1(), true) : new GradientPaint(bound.x + bound.width, bound.y, ccr.getT2(), bound.x + bound.width / 2, bound.y + bound.height / 2, ccr.getT1(), true);
                g.setPaint(gp);
                Utils.fillPaint(g, topOval, transparent);
            }
        } else if (chartColor.isGradient()) {
            ChartColor tmpcc = new ChartColor();
            tmpcc.setAngle(180);
            tmpcc.setGradient(true);
            tmpcc.setColor1(ccr.getT1());
            tmpcc.setColor2(ccr.getT2());
            if (Utils.setPaint(g, bound.x, bound.y, bound.width, bound.height, tmpcc)) {
                Utils.fillPaint(g, topOval, transparent);
            }
        } else {
            Utils.fill(g, topOval, transparent, ccr.getOrigin());
        }
        if (Utils.setStroke(g, bc, bs, bw)) {
            g.draw(topOval);
        }
    }

    public static void drawCylinderFront(Graphics2D g, Area front, Color bc, int bs, float bw, float transparent, ChartColor chartColor, boolean isVertical) {
        Utils.drawCylinderFront(g, front, bc, bs, bw, transparent, chartColor, isVertical, null, false);
    }

    public static void drawCylinderFront(Graphics2D g, Area front, Color bc, int bs, float bw, float transparent, ChartColor chartColor, boolean isVertical, Rectangle2D shinningRange, boolean isCurve) {
        CubeColor ccr = new CubeColor(chartColor.getColor1());
        Rectangle bound = front.getBounds();
        if (chartColor.isDazzle()) {
            GradientPaint paint;
            Color c2;
            Color c1;
            double y2;
            double x2;
            double y1;
            double x1;
            Rectangle2D r2d = shinningRange;
            if (r2d == null) {
                r2d = bound.getBounds2D();
            }
            Area tmp = isVertical ? new Area(new Rectangle2D.Double(r2d.getX(), r2d.getY(), r2d.getWidth() * 2.0 / 3.0, r2d.getHeight())) : new Area(new Rectangle2D.Double(r2d.getX(), r2d.getY(), r2d.getWidth(), r2d.getHeight() * 2.0 / 3.0));
            Area leftOrTop = (Area)front.clone();
            leftOrTop.intersect(tmp);
            if (!leftOrTop.isEmpty()) {
                bound = tmp.getBounds();
                if (isVertical) {
                    x1 = bound.x;
                    y1 = bound.y;
                    x2 = bound.x + bound.width / 2;
                    y2 = y1;
                } else {
                    x1 = bound.x;
                    y1 = bound.y;
                    x2 = x1;
                    y2 = y1 + (double)(bound.height / 2);
                }
                if (isCurve) {
                    c1 = ccr.getRelativeBrighter("T2", 1);
                    c2 = ccr.getRelativeBrighter("T1", 1);
                } else {
                    c1 = ccr.getT2();
                    c2 = ccr.getT1();
                }
                if (c1 != null && c2 != null) {
                    paint = new GradientPaint((int)x1, (int)y1, c1, (int)x2, (int)y2, c2, true);
                    g.setPaint(paint);
                    Utils.fillPaint(g, leftOrTop, transparent);
                }
            }
            Area rightOrBottom = (Area)front.clone();
            if (isVertical) {
                double d = r2d.getWidth() * 2.0 / 3.0;
                tmp = new Area(new Rectangle2D.Double(r2d.getX() + d - 1.0, r2d.getY(), (double)r2d.getBounds().width - d + 1.0, r2d.getHeight()));
            } else {
                double d = r2d.getHeight() * 2.0 / 3.0;
                tmp = new Area(new Rectangle2D.Double(r2d.getX(), r2d.getY() + d - 1.0, r2d.getWidth(), (double)r2d.getBounds().height - d + 1.0));
            }
            rightOrBottom.intersect(tmp);
            if (!rightOrBottom.isEmpty()) {
                bound = tmp.getBounds();
                if (isVertical) {
                    x1 = bound.x;
                    y1 = bound.y;
                    x2 = (float)bound.x + (float)bound.width * 0.6f;
                    y2 = y1;
                } else {
                    x1 = bound.x;
                    y1 = bound.y;
                    x2 = x1;
                    y2 = (float)bound.y + (float)bound.height * 0.6f;
                }
                if (isCurve) {
                    c1 = ccr.getRelativeBrighter("T2", 1);
                    c2 = ccr.getRelativeBrighter("F2", 1);
                } else {
                    c1 = ccr.getT2();
                    c2 = ccr.getF2();
                }
                if (c1 != null && c2 != null) {
                    paint = new GradientPaint((int)x1, (int)y1, c1, (int)x2, (int)y2, c2, false);
                    g.setPaint(paint);
                    Utils.fillPaint(g, rightOrBottom, transparent);
                }
            }
        } else if (Utils.setPaint(g, bound.x, bound.y, bound.width, bound.height, chartColor)) {
            Utils.fillPaint(g, front, transparent);
        }
        if (Utils.setStroke(g, bc, bs, bw)) {
            g.draw(front);
        }
    }

    public static void drawPolarPointText(Engine e, String txt, PolarCoor pc, Point2D txtPolarPoint, String fontName, int fontStyle, int fontSize, Color c, boolean textOverlapping) {
        Utils.drawPolarPointText(e, txt, pc, txtPolarPoint, fontName, fontStyle, fontSize, c, textOverlapping, 0);
    }

    public static void drawPolarPointText(Engine e, String txt, PolarCoor pc, Point2D txtPolarPoint, String fontName, int fontStyle, int fontSize, Color c, boolean textOverlapping, int specifiedLocation) {
        if (!StringUtils.isValidString(txt)) {
            return;
        }
        double angle = txtPolarPoint.getY();
        int locationType = 18;
        locationType = specifiedLocation > 0 ? specifiedLocation : Utils.getAngleTextLocation(angle);
        Font font = Utils.getFont(fontName, fontStyle, fontSize);
        Point2D txtP = pc.getScreenPoint(txtPolarPoint);
        Utils.drawText(e, txt, txtP.getX(), txtP.getY(), font, c, null, fontStyle, 0, locationType, textOverlapping);
    }

    public static Shape draw2DRing(Graphics2D g, Rectangle2D bigBounds, Rectangle2D smallBounds, double start, double extent, Color borderColor, int borderStyle, float borderWeight, float transparent, ChartColor fillColor) {
        return Utils.draw2DRing(g, bigBounds, smallBounds, start, extent, borderColor, borderStyle, borderWeight, transparent, fillColor, false);
    }

    public static Shape draw2DRing(Graphics2D g, Rectangle2D bigBounds, Rectangle2D smallBounds, double start, double extent, Color borderColor, int borderStyle, float borderWeight, float transparent, ChartColor fillColor, boolean fillAsPie) {
        float weight;
        int style;
        double x = (bigBounds.getX() + smallBounds.getX()) / 2.0;
        double y = (bigBounds.getY() + smallBounds.getY()) / 2.0;
        double w = (bigBounds.getWidth() + smallBounds.getWidth()) / 2.0;
        double h = (bigBounds.getHeight() + smallBounds.getHeight()) / 2.0;
        Rectangle2D.Double midBounds = new Rectangle2D.Double(x, y, w, h);
        Arc2D.Double smallSector = new Arc2D.Double(smallBounds, start - 5.0, extent + 10.0, 2);
        Arc2D.Double bigSector = new Arc2D.Double(bigBounds, start, extent, 2);
        Area ring = new Area(bigSector);
        ring.subtract(new Area(smallSector));
        Rectangle rect = bigBounds.getBounds();
        ChartColor cc = fillColor;
        double endAngle = start + extent;
        if (cc.isDazzle()) {
            Color dazzel = CubeColor.getDazzelColor(cc.getColor1());
            CubeColor ccr = new CubeColor(dazzel);
            if (fillAsPie) {
                if (ccr.getF1() != null && ccr.getF2() != null) {
                    GradientPaint gp = new GradientPaint(rect.x, rect.y + rect.height, ccr.getF2(), rect.x + rect.width / 2, rect.y + rect.height / 2, ccr.getF1(), true);
                    g.setPaint(gp);
                    Utils.fillPaint(g, ring, transparent);
                }
            } else {
                double dAngle = 3.0;
                double sAngle = start;
                while (sAngle <= endAngle) {
                    smallSector = new Arc2D.Double(smallBounds, sAngle - 5.0, dAngle + 10.0, 2);
                    double tmps = sAngle;
                    double tmpa = dAngle;
                    if (tmps != start) {
                        tmps -= dAngle;
                        tmpa += dAngle * 2.0;
                    }
                    if (tmps + tmpa > endAngle) {
                        tmpa = endAngle - tmps;
                    }
                    bigSector = new Arc2D.Double(bigBounds, tmps, tmpa, 2);
                    Area dRing = new Area(bigSector);
                    dRing.subtract(new Area(smallSector));
                    smallSector = new Arc2D.Double(smallBounds, sAngle, dAngle / 2.0, 2);
                    bigSector = new Arc2D.Double(midBounds, sAngle, dAngle / 2.0, 2);
                    Point2D dp1 = smallSector.getEndPoint();
                    Point2D dp2 = bigSector.getEndPoint();
                    if (ccr.getF1() != null && ccr.getF2() != null) {
                        g.setPaint(new GradientPaint(dp1, ccr.getF2(), dp2, ccr.getF1(), true));
                        g.fill(dRing);
                    }
                    sAngle += dAngle;
                }
            }
        } else if (Utils.setPaint(g, rect.x, rect.y, rect.width, rect.height, fillColor)) {
            Utils.fillPaint(g, ring, transparent);
        }
        if (Utils.setStroke(g, borderColor, style = borderStyle, weight = borderWeight)) {
            Point2D spb;
            Point2D spe;
            bigSector = new Arc2D.Double(bigBounds, start, extent, 0);
            g.draw(bigSector);
            if (smallBounds.getWidth() == 0.0) {
                spb = spe = new Point2D.Double(bigBounds.getCenterX(), bigBounds.getCenterY());
            } else {
                smallSector = new Arc2D.Double(smallBounds, start, extent, 0);
                g.draw(smallSector);
                spb = smallSector.getStartPoint();
                spe = smallSector.getEndPoint();
            }
            Line2D.Double line = new Line2D.Double(spb, bigSector.getStartPoint());
            g.draw(line);
            line = new Line2D.Double(spe, bigSector.getEndPoint());
            g.draw(line);
        }
        return ring;
    }

    public static String replaceAll(String src, String sold, String snew) {
        return Sentence.replace(src, 0, sold, snew, 27);
    }

    public static String getHtmlLink(String link, Object data1, Object data2, String text, String legend) {
        if (!StringUtils.isValidString(link)) {
            return null;
        }
        if (data1 != null) {
            link = Utils.replaceAll(link, "@data1", data1.toString());
        }
        if (data2 != null) {
            link = Utils.replaceAll(link, "@data2", data2.toString());
        }
        if (StringUtils.isValidString(text)) {
            link = Utils.replaceAll(link, "@text", text);
        }
        if (StringUtils.isValidString(legend)) {
            link = Utils.replaceAll(link, "@legend", legend);
        }
        return link;
    }

    public static BufferedImage calcBarcodeImage(Text value, int index, Color fore, Color back) {
        int TRANSPARENT = 0xFFFFFF;
        int BLACK = -16777216;
        int WHITE = -1;
        int w = value.getWidth(index);
        int h = value.getHeight(index);
        if (w <= 0) {
            w = 40;
        }
        if (h <= 0) {
            h = 40;
        }
        int backColor = WHITE;
        int foreColor = BLACK;
        if (back != null) {
            backColor = back.getRGB();
        }
        if (fore != null) {
            foreColor = fore.getRGB();
        }
        if (value.barType == 256) {
            int minWH = w < h ? w : h;
            w = h = minWH + 30;
        } else if (value.dispText) {
            Rectangle rect = Utils.getTextRect(value, index);
            h -= rect.height + 10;
        }
        MultiFormatWriter multiFormatWriter = new MultiFormatWriter();
        HashMap<EncodeHintType, String> hints = new HashMap<EncodeHintType, String>();
        hints.put(EncodeHintType.CHARACTER_SET, value.charSet.toLowerCase());
        char errLevel = value.recError.charAt(0);
        ErrorCorrectionLevel ecl = errLevel == 'L' ? ErrorCorrectionLevel.L : (errLevel == 'M' ? ErrorCorrectionLevel.M : (errLevel == 'Q' ? ErrorCorrectionLevel.Q : ErrorCorrectionLevel.H));
        hints.put(EncodeHintType.ERROR_CORRECTION, (String)ecl);
        if (value.barType == 256) {
            hints.put(EncodeHintType.DATA_MATRIX_SHAPE, (String)SymbolShapeHint.FORCE_SQUARE);
        }
        try {
            BitMatrix bitMatrix;
            BarcodeFormat bf = Utils.convertBarcodeFormat(value.barType);
            if (Utils.isCode128ABC(value.barType)) {
                Code128ABC writer = new Code128ABC(value.barType);
                bitMatrix = writer.encode(value.getDispText(index), bf, w, h, hints);
            } else {
                bitMatrix = multiFormatWriter.encode(value.getDispText(index), bf, w, h, hints);
            }
            if (value.barType == 256) {
                return Utils.toBufferedQRImage(value, bitMatrix, foreColor, backColor);
            }
            return Utils.toBufferedImage(value, index, bitMatrix, foreColor, backColor);
        }
        catch (Exception x) {
            String val = value.toString();
            String upper = val.toUpperCase();
            boolean isUpper = upper.equals(val);
            if (value.barType == 2 && !isUpper) {
                throw new RQException("Only upper case characters were supported by Code39!");
            }
            throw new RQException(x.getMessage(), x);
        }
    }

    private static Point get417Margin(BitMatrix matrix) {
        Point p = new Point();
        int width = matrix.getWidth();
        int height = matrix.getHeight();
        int x = 0;
        while (x < width) {
            int y = 0;
            while (y < height) {
                if (matrix.get(x, y)) {
                    return new Point(x - 1, y - 1);
                }
                ++y;
            }
            ++x;
        }
        return p;
    }

    public static Rectangle getTextRect(Text value, int index) {
        Font font = new Font(value.textFont.stringValue(index), 0, value.textSize.intValue(index));
        Graphics2D g = new BufferedImage(1, 1, 1).createGraphics();
        FontMetrics fm = g.getFontMetrics(font);
        int txtHeight = fm.getHeight();
        g.dispose();
        return new Rectangle(0, 0, fm.stringWidth(value.getDispText(index)), txtHeight);
    }

    private static BufferedImage toBufferedImage(Text value, int index, BitMatrix matrix, int foreColor, int backColor) {
        int width = matrix.getWidth();
        int height = matrix.getHeight();
        int x1 = 0;
        int x2 = width;
        int y1 = 0;
        int y2 = height;
        if (value.barType == 25) {
            Point leftUpCorner = Utils.get417Margin(matrix);
            x1 = leftUpCorner.x;
            y1 = leftUpCorner.y;
            x2 = width - x1;
            y2 = height - y1;
        }
        int dw = x2 - x1;
        int dh = y2 - y1;
        Font font = new Font(value.textFont.stringValue(index), 0, value.textSize.intValue(index));
        if (value.dispText) {
            Rectangle rect = Utils.getTextRect(value, index);
            dh += rect.height;
        }
        BufferedImage image = new BufferedImage(dw, dh, 1);
        Graphics2D g = image.createGraphics();
        g.setBackground(new Color(backColor));
        g.clearRect(0, 0, dw, dh);
        FontMetrics fm = g.getFontMetrics(font);
        int txtHeight = 0;
        if (value.dispText) {
            boolean isSpaceEnough = txtHeight < dh - 10;
            int txtWidth = fm.stringWidth(value.getDispText(index));
            int x = (dw - txtWidth) / 2;
            boolean bl = isSpaceEnough = x >= 0;
            if (!isSpaceEnough) {
                throw new RQException("Barcode is too narrow to draw text on it.Please set smaller font size or hide text.");
            }
        }
        int x = x1;
        while (x < x2) {
            int y = y1;
            while (y < y2) {
                image.setRGB(x - x1, y - y1, matrix.get(x, y) ? foreColor : backColor);
                ++y;
            }
            ++x;
        }
        if (value.dispText) {
            g.setColor(new Color(foreColor));
            g.setFont(font);
            int txtWidth = fm.stringWidth(value.getDispText(index));
            txtHeight = fm.getHeight();
            int x3 = (dw - txtWidth) / 2;
            int y = dh - fm.getDescent();
            g.drawString(value.getDispText(index), x3, y);
        }
        g.dispose();
        return image;
    }

    public static BufferedImage toBufferedQRImage(Text text, BitMatrix matrix, int foreColor, int backColor) {
        int width = matrix.getWidth();
        int margin = Utils.getMarginIndex(matrix);
        int dataSize = width - margin * 2;
        int dataEnd = margin + dataSize;
        BufferedImage image = new BufferedImage(dataSize, dataSize, 1);
        int x = margin;
        while (x < dataEnd) {
            int y = margin;
            while (y < dataEnd) {
                image.setRGB(x - margin, y - margin, matrix.get(x, y) ? foreColor : backColor);
                ++y;
            }
            ++x;
        }
        int scale = (width - 30) * 100 / dataSize;
        image = Utils.scaleImage(image, scale);
        image = Utils.printLogo(image, text);
        return image;
    }

    private static int getMarginIndex(BitMatrix matrix) {
        int width = matrix.getWidth();
        int x = 0;
        while (x < width) {
            int y = 0;
            while (y < width) {
                if (matrix.get(x, y)) {
                    return x - 1;
                }
                ++y;
            }
            ++x;
        }
        return 0;
    }

    private static BufferedImage scaleImage(BufferedImage src, int scale) {
        if (scale == 100) {
            return src;
        }
        float width = src.getWidth();
        int scaleWidth = (int)((double)(width * (float)scale) * 0.01);
        Image image = src.getScaledInstance(scaleWidth, scaleWidth, 1);
        BufferedImage buffer = new BufferedImage(scaleWidth, scaleWidth, 2);
        Graphics2D g2 = buffer.createGraphics();
        g2.drawImage(image, 0, 0, null);
        g2.dispose();
        return buffer;
    }

    public static byte[] getFileBytes(Object fileValue) {
        Object imgVal = fileValue;
        byte[] imageBytes = null;
        if (imgVal instanceof byte[]) {
            imageBytes = (byte[])imgVal;
        } else if (imgVal instanceof String) {
            try {
                String path = (String)imgVal;
                FileObject fo = new FileObject(path, "s");
                int size = (int)fo.size();
                imageBytes = new byte[size];
                InputStream is = fo.getInputStream();
                is.read(imageBytes);
                is.close();
            }
            catch (Exception x) {
                throw new RQException(x.getMessage(), x);
            }
        } else if (imgVal != null) {
            throw new RQException(mm.getMessage("Utils.invalidfile", fileValue));
        }
        return imageBytes;
    }

    private static BufferedImage printLogo(BufferedImage src, Text value) {
        Para logoValue = value.logoValue;
        byte[] bytes = Utils.getFileBytes(logoValue.getValue());
        if (bytes == null) {
            return src;
        }
        ImageIcon icon = new ImageIcon(bytes);
        Image image = icon.getImage();
        int width = src.getWidth();
        double center = width / 2;
        double logoPercent = (float)value.logoSize / 100.0f;
        int size = (int)((double)width * logoPercent);
        if (size % 2 != 0) {
            ++size;
        }
        double shift = size / 2;
        image = image.getScaledInstance(size, size, 4);
        image = new ImageIcon(image).getImage();
        Graphics2D g2 = src.createGraphics();
        int x = (int)(center - shift);
        if (value.logoFrame) {
            g2.setColor(Color.white);
            int edge = 2;
            Rectangle rect = new Rectangle(x - edge, x - edge, size + edge * 2 - 1, size + edge * 2 - 1);
            g2.fill(rect);
            g2.setColor(Color.lightGray);
            g2.draw(rect);
        }
        boolean b = g2.drawImage(image, x, x, null);
        g2.dispose();
        return src;
    }

    public static boolean isCode128ABC(int raqType) {
        return raqType == 4 || raqType == 5 || raqType == 6;
    }

    private static BarcodeFormat convertBarcodeFormat(int raqType) {
        switch (raqType) {
            case 1: {
                return BarcodeFormat.CODABAR;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return BarcodeFormat.CODE_128;
            }
            case 2: {
                return BarcodeFormat.CODE_39;
            }
            case 7: {
                return BarcodeFormat.EAN_13;
            }
            case 8: {
                return BarcodeFormat.EAN_8;
            }
            case 23: {
                return BarcodeFormat.ITF;
            }
            case 25: {
                return BarcodeFormat.PDF_417;
            }
            case 9: {
                return BarcodeFormat.UPC_A;
            }
        }
        return BarcodeFormat.QR_CODE;
    }

    public static double calcLineY(Point2D.Double p1, Point2D.Double p2, double x) {
        double x1 = p1.x;
        double y1 = p1.y;
        double x2 = p2.x;
        double y2 = p2.y;
        double k = (y2 - y1) / (x2 - x1);
        double b = y1 - k * x1;
        double y = k * x + b;
        return y;
    }

    public static void main(String[] args) {
        IParam param = ParamParser.parse("a,b:c,d", null, null);
        ArrayList<Expression> al = new ArrayList<Expression>();
        param.getAllLeafExpression(al);
        int i = 0;
        while (i < al.size()) {
            System.out.println(((Object)al.get(i)).toString());
            ++i;
        }
    }
}

