/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.chart.edit;

import com.scudata.chart.edit.ElementInfo;
import com.scudata.chart.resources.ChartMessage;
import com.scudata.common.MessageManager;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;

public class ElementLib {
    private static ArrayList<String> groupList = new ArrayList(20);
    private static ArrayList<ArrayList<ElementInfo>> elementList = new ArrayList(20);
    private static MessageManager mm = ChartMessage.get();

    static {
        ElementLib.loadSystemElements();
    }

    private static int indexof(ArrayList<ElementInfo> al, String name) {
        int size = al.size();
        int i = 0;
        while (i < size) {
            ElementInfo ei = al.get(i);
            if (ei.getName().equalsIgnoreCase(name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static ArrayList<ElementInfo> getElementList(String group) {
        int size = groupList.size();
        int i = 0;
        while (i < size) {
            String groupTitle = groupList.get(i);
            if (groupTitle.equalsIgnoreCase(group)) {
                return elementList.get(i);
            }
            ++i;
        }
        ArrayList<ElementInfo> newElement = new ArrayList<ElementInfo>();
        groupList.add(group);
        elementList.add(newElement);
        return newElement;
    }

    public static ElementInfo getElementInfo(String name) {
        int i = 0;
        while (i < elementList.size()) {
            ArrayList<ElementInfo> al = elementList.get(i);
            ElementInfo ei = ElementLib.getElementInfo(al, name);
            if (ei != null) {
                return ei;
            }
            ++i;
        }
        throw new RuntimeException(mm.getMessage("ElementLib.badelement", name));
    }

    public static ElementInfo getElementInfo(ArrayList<ElementInfo> al, String name) {
        int i = ElementLib.indexof(al, name);
        if (i >= 0) {
            return al.get(i);
        }
        return null;
    }

    public static void addElement(String group, String name, String className) {
        try {
            String groupTitle = mm.getMessage(group);
            ArrayList<ElementInfo> al = ElementLib.getElementList(groupTitle);
            Class<?> elemClass = Class.forName(className);
            String title = mm.getMessage(name);
            ElementInfo ei = new ElementInfo(name, title, elemClass);
            int i = ElementLib.indexof(al, name);
            if (i >= 0) {
                al.add(i, ei);
            } else {
                al.add(ei);
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public static ArrayList<ArrayList<ElementInfo>> getElementInfoList() {
        return elementList;
    }

    public static ArrayList<String> getElementTitleList() {
        return groupList;
    }

    public static void loadSystemElements() {
        String group = "axis";
        ElementLib.addElement(group, "MapAxis", "com.scudata.chart.element.MapAxis");
        ElementLib.addElement(group, "NumericAxis", "com.scudata.chart.element.NumericAxis");
        ElementLib.addElement(group, "EnumAxis", "com.scudata.chart.element.EnumAxis");
        ElementLib.addElement(group, "DateAxis", "com.scudata.chart.element.DateAxis");
        ElementLib.addElement(group, "TimeAxis", "com.scudata.chart.element.TimeAxis");
        group = "element";
        ElementLib.addElement(group, "Dot", "com.scudata.chart.element.Dot");
        ElementLib.addElement(group, "Line", "com.scudata.chart.element.Line");
        ElementLib.addElement(group, "Column", "com.scudata.chart.element.Column");
        ElementLib.addElement(group, "Sector", "com.scudata.chart.element.Sector");
        ElementLib.addElement(group, "Text", "com.scudata.chart.element.Text");
        group = "Graph";
        ElementLib.addElement(group, "GraphColumn", "com.scudata.chart.graph.GraphColumn");
        ElementLib.addElement(group, "GraphLine", "com.scudata.chart.graph.GraphLine");
        ElementLib.addElement(group, "GraphPie", "com.scudata.chart.graph.GraphPie");
        ElementLib.addElement(group, "Graph2Axis", "com.scudata.chart.graph.Graph2Axis");
        group = "other";
        ElementLib.addElement(group, "BackGround", "com.scudata.chart.element.BackGround");
        ElementLib.addElement(group, "Legend", "com.scudata.chart.element.Legend");
    }

    public static void loadCustomElements(InputStream is) {
        try {
            Properties pt = new Properties();
            pt.load(is);
            boolean c = false;
            Enumeration<?> e = pt.propertyNames();
            while (e.hasMoreElements()) {
                Object key = e.nextElement();
                String value = (String)pt.get(key);
                value = new String(value.getBytes("ISO-8859-1"), "gbk");
                String[] items = value.split(",");
                int pos = value.indexOf(44);
                String type = items[0];
                String title = items[1];
                String string = items[2];
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

