/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.chart.element;

import com.scudata.chart.ChartColor;
import com.scudata.chart.Engine;
import com.scudata.chart.ObjectElement;
import com.scudata.chart.Para;
import com.scudata.chart.Utils;
import com.scudata.chart.edit.ParamInfo;
import com.scudata.chart.edit.ParamInfoList;
import com.scudata.common.ImageUtils;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.ArrayList;
import javax.swing.ImageIcon;

public class BackGround
extends ObjectElement {
    public ChartColor backColor = new ChartColor(Color.white);
    public float transparent = 1.0f;
    public boolean visible = true;
    public Para imageValue = new Para();
    public int imageMode = 0;
    protected transient Engine e;

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void beforeDraw() {
    }

    @Override
    public void draw() {
    }

    public int[] getOrginalWH() {
        Object imgVal = this.imageValue.getValue();
        byte[] imageBytes = Utils.getFileBytes(imgVal);
        if (imageBytes == null) {
            return null;
        }
        Image image = new ImageIcon(imageBytes).getImage();
        int iw = image.getWidth(null);
        int ih = image.getHeight(null);
        return new int[]{iw, ih};
    }

    @Override
    public void drawBack() {
        Object imgVal;
        byte[] imageBytes;
        if (!this.isVisible()) {
            return;
        }
        Graphics2D g = this.e.getGraphics();
        int w = this.e.getW();
        int h = this.e.getH();
        Rectangle rect = new Rectangle(0, 0, w, h);
        if (Utils.setPaint(g, 0.0, 0.0, w, h, this.backColor)) {
            Utils.fillPaint(g, rect, this.transparent);
        }
        if ((imageBytes = Utils.getFileBytes(imgVal = this.imageValue.getValue())) == null) {
            return;
        }
        Image image = new ImageIcon(imageBytes).getImage();
        switch (this.imageMode) {
            case 0: {
                ImageUtils.drawFixImage(g, image, 0, 0, w, h);
                break;
            }
            case 1: {
                g.drawImage(image, 0, 0, w, h, null);
                break;
            }
            case 2: {
                int iw = image.getWidth(null);
                int ih = image.getHeight(null);
                int x = 0;
                int y = 0;
                while (x < w) {
                    y = 0;
                    while (y < h) {
                        ImageUtils.drawFixImage(g, image, x, y, w, h);
                        y += ih;
                    }
                    x += iw;
                }
                break;
            }
        }
    }

    @Override
    public void drawFore() {
    }

    @Override
    public ParamInfoList getParamInfoList() {
        ParamInfoList paramInfos = new ParamInfoList();
        ParamInfo.setCurrent(BackGround.class, this);
        paramInfos.add(new ParamInfo("backColor", 12));
        paramInfos.add(new ParamInfo("transparent", 25));
        paramInfos.add(new ParamInfo("visible", 10));
        paramInfos.add(new ParamInfo("imageValue"));
        paramInfos.add(new ParamInfo("imageMode", 46));
        return paramInfos;
    }

    @Override
    public ArrayList<Shape> getShapes() {
        return null;
    }

    @Override
    public ArrayList<String> getLinks() {
        return null;
    }

    @Override
    public void setEngine(Engine e) {
        this.e = e;
        Utils.setParamsEngine(this);
    }

    @Override
    public Engine getEngine() {
        return this.e;
    }
}

