/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.chart.element;

import com.scudata.chart.DataElement;
import com.scudata.chart.Utils;
import com.scudata.chart.edit.ParamInfo;
import com.scudata.chart.edit.ParamInfoList;
import com.scudata.chart.element.Column;
import com.scudata.chart.element.TickAxis;
import com.scudata.dm.Sequence;
import com.scudata.util.Variant;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;

public class DateAxis
extends TickAxis {
    public boolean autoCalcValueRange = true;
    public Date endDate;
    public Date beginDate = this.endDate = GregorianCalendar.getInstance().getTime();
    public int scaleUnit = 3;
    public String format = "yyyy/MM/dd";
    private transient double t_maxDate = 0.0;
    private transient double t_minDate = 9.223372036854776E18;
    private transient int t_valueBaseLine = 0;

    @Override
    public ParamInfoList getParamInfoList() {
        ParamInfoList paramInfos = new ParamInfoList();
        ParamInfo.setCurrent(DateAxis.class, this);
        String group = "dateaxis";
        paramInfos.add(group, new ParamInfo("autoCalcValueRange", 10));
        paramInfos.add(group, new ParamInfo("endDate", 13));
        paramInfos.add(group, new ParamInfo("beginDate", 13));
        paramInfos.add(group, new ParamInfo("scaleUnit", 26));
        paramInfos.add(group, new ParamInfo("format"));
        paramInfos.addAll(super.getParamInfoList());
        return paramInfos;
    }

    public static double getDoubleDate(Object date) {
        if (date instanceof Number) {
            return ((Number)date).doubleValue();
        }
        if (date instanceof Date) {
            return ((Date)date).getTime();
        }
        Object obj = Variant.parseDate(date.toString());
        if (obj instanceof Date) {
            return ((Date)obj).getTime();
        }
        throw new RuntimeException("Wrong data: " + date + " on calculating on axis. ");
    }

    @Override
    double getValueLength(Object val, boolean isAbsolute) {
        double len = 0.0;
        double axisLen = this.getAxisLength();
        if (isAbsolute) {
            len = ((Number)val).doubleValue();
            long valMillSecs = (long)(len * 24.0 * 60.0 * 60.0 * 1000.0);
            len = axisLen * ((double)valMillSecs / (this.t_maxDate - this.t_minDate));
        } else {
            double tmp = DateAxis.getDoubleDate(val);
            len = axisLen * (tmp - this.t_minDate) / (this.t_maxDate - this.t_minDate);
        }
        return len;
    }

    public Point2D getRootPoint() {
        switch (this.location) {
            case 1: 
            case 3: {
                return new Point2D.Double(this.t_valueBaseLine, this.getBottomY());
            }
            case 2: {
                return new Point2D.Double(this.getLeftX(), this.t_valueBaseLine);
            }
        }
        return null;
    }

    public static double max(double v, Sequence d) {
        Sequence al = d;
        double max = DateAxis.getDoubleDate(al.max());
        if (v > max) {
            return v;
        }
        return max;
    }

    public static double min(double v, Sequence d) {
        Sequence al = d;
        double min = DateAxis.getDoubleDate(al.min());
        if (v < min) {
            return v;
        }
        return min;
    }

    @Override
    public void prepare(ArrayList<DataElement> dataElements) {
        super.prepare(dataElements);
        if (this.autoCalcValueRange) {
            int i = 0;
            while (i < dataElements.size()) {
                DataElement de = dataElements.get(i);
                if (!de.isPhysicalCoor()) {
                    Object one;
                    Column col;
                    Sequence data = de.getAxisData(this.name);
                    this.t_minDate = DateAxis.min(this.t_minDate, data);
                    this.t_maxDate = DateAxis.max(this.t_maxDate, data);
                    if (de instanceof Column && (data = (col = (Column)de).getData3()) != null && data.length() > 0 && (one = data.get(1)) instanceof Date) {
                        this.t_minDate = DateAxis.min(this.t_minDate, data);
                        this.t_maxDate = DateAxis.max(this.t_maxDate, data);
                    }
                }
                ++i;
            }
        } else {
            this.t_maxDate = Math.max(this.endDate.getTime(), this.beginDate.getTime());
            this.t_minDate = Math.min(this.endDate.getTime(), this.beginDate.getTime());
        }
        Date start = new Date((long)this.t_minDate);
        Date end = new Date((long)this.t_maxDate);
        this.createCoorValue(start, end, this.scaleUnit, this.displayStep, this.t_coorValue);
        this.displayStep = 1;
    }

    private void createCoorValue(Date start, Date end, int scale, int step, Sequence v) {
        if (step < 1) {
            step = 1;
        }
        GregorianCalendar gc = new GregorianCalendar();
        switch (scale) {
            case 1: {
                gc.setTime(end);
                int endY = gc.get(1);
                gc.setTime(start);
                int startY = gc.get(1);
                while (startY <= endY) {
                    Date d = gc.getTime();
                    v.add(d);
                    gc.add(1, step);
                    startY = gc.get(1);
                }
                break;
            }
            case 2: {
                gc.setTime(end);
                int endY = gc.get(1);
                int endM = gc.get(2);
                gc.setTime(start);
                int startY = gc.get(1);
                int startM = gc.get(2);
                while (startY < endY || startY == endY && startM <= endM) {
                    Date d = gc.getTime();
                    v.add(d);
                    gc.add(2, step);
                    startY = gc.get(1);
                    startM = gc.get(2);
                }
                break;
            }
            case 3: {
                gc.setTime(end);
                int endY = gc.get(1);
                int endM = gc.get(2);
                int endD = gc.get(5);
                gc.setTime(start);
                int startY = gc.get(1);
                int startM = gc.get(2);
                int startD = gc.get(5);
                while (startY < endY || startY == endY && (startM < endM || startM == endM && startD <= endD)) {
                    Date d = gc.getTime();
                    v.add(d);
                    gc.add(5, step);
                    startY = gc.get(1);
                    startM = gc.get(2);
                    startD = gc.get(5);
                }
                break;
            }
            case 4: {
                gc.setTime(end);
                int endY = gc.get(1);
                int endM = gc.get(2);
                int endD = gc.get(5);
                int endH = gc.get(11);
                gc.setTime(start);
                int startY = gc.get(1);
                int startM = gc.get(2);
                int startD = gc.get(5);
                int startH = gc.get(11);
                while (startY < endY || startY == endY && (startM < endM || startM == endM && (startD < endD || startD == endD && startH <= endH))) {
                    Date d = gc.getTime();
                    v.add(d);
                    gc.add(11, step);
                    startY = gc.get(1);
                    startM = gc.get(2);
                    startD = gc.get(5);
                    startH = gc.get(11);
                }
                break;
            }
            case 5: {
                gc.setTime(end);
                int endY = gc.get(1);
                int endM = gc.get(2);
                int endD = gc.get(5);
                int endH = gc.get(11);
                int endMM = gc.get(12);
                gc.setTime(start);
                int startY = gc.get(1);
                int startM = gc.get(2);
                int startD = gc.get(5);
                int startH = gc.get(11);
                int startMM = gc.get(12);
                while (startY < endY || startY == endY && (startM < endM || startM == endM && (startD < endD || startD == endD && startH < endH || startH == endH && startMM <= endMM))) {
                    Date d = gc.getTime();
                    v.add(d);
                    gc.add(12, step);
                    startY = gc.get(1);
                    startM = gc.get(2);
                    startD = gc.get(5);
                    startMM = gc.get(12);
                    startH = gc.get(11);
                }
                break;
            }
            case 6: {
                gc.setTime(end);
                int endY = gc.get(1);
                int endM = gc.get(2);
                int endD = gc.get(5);
                int endH = gc.get(11);
                int endMM = gc.get(12);
                int endS = gc.get(13);
                gc.setTime(start);
                int startY = gc.get(1);
                int startM = gc.get(2);
                int startD = gc.get(5);
                int startH = gc.get(11);
                int startMM = gc.get(12);
                int startS = gc.get(13);
                while (startY < endY || startY == endY && (startM < endM || startM == endM && (startD < endD || startD == endD && startH < endH || startH == endH && (startMM < endMM || startMM == endMM && startS <= endS)))) {
                    Date d = gc.getTime();
                    v.add(d);
                    gc.add(13, step);
                    startY = gc.get(1);
                    startM = gc.get(2);
                    startD = gc.get(5);
                    startMM = gc.get(12);
                    startH = gc.get(11);
                    startS = gc.get(13);
                }
                break;
            }
        }
    }

    @Override
    String getCoorText(Object coorValue) {
        Date coory = (Date)coorValue;
        return Utils.format(coory, this.format);
    }

    @Override
    public void beforeDraw() {
        switch (this.location) {
            case 1: 
            case 3: {
                this.t_valueBaseLine = (int)this.getLeftX();
                break;
            }
            case 2: {
                this.t_valueBaseLine = (int)this.getBottomY();
                break;
            }
        }
    }

    @Override
    public boolean isEnumAxis() {
        return false;
    }

    @Override
    public boolean isDateAxis() {
        return true;
    }

    @Override
    public boolean isNumericAxis() {
        return false;
    }

    @Override
    public void checkDataMatch(Sequence data) {
        if (data != null && data.length() > 1) {
            Object one = data.get(1);
            DateAxis.getDoubleDate(one);
        }
    }

    @Override
    public double animateDoubleValue(Object val) {
        return DateAxis.getDoubleDate(val);
    }
}

