/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.chart.element;

import com.scudata.chart.CartesianCoor;
import com.scudata.chart.ChartColor;
import com.scudata.chart.DataElement;
import com.scudata.chart.ICoor;
import com.scudata.chart.Para;
import com.scudata.chart.PolarCoor;
import com.scudata.chart.Utils;
import com.scudata.chart.edit.ParamInfo;
import com.scudata.chart.edit.ParamInfoList;
import com.scudata.chart.element.TickAxis;
import com.scudata.common.StringUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Point2D;

public class Dot
extends DataElement {
    public static String NOT_IN_DEFINE = "Data is not in defined.";
    public Para lineStyle = new Para(new Integer(1));
    public Para lineWeight = new Para(new Float(1.0f));
    public Para lineColor = new Para(1);
    public Para markerStyle = new Para(new Integer(1), 2);
    public Para markerColor = new Para(3);
    public Para markerWeight = new Para(0);
    public Para radius1 = new Para(0);
    public Para radius2 = new Para(0);
    public Para text = new Para(null);
    public Para textFont = new Para();
    public Para textStyle = new Para(new Integer(0));
    public Para textSize = new Para(new Integer(12));
    public Para textColor = new Para(Color.black);
    public float transparent = 1.0f;
    public boolean textOverlapping = true;
    public boolean shadow = false;

    @Override
    protected String getText(int index) {
        return this.text.stringValue(index);
    }

    @Override
    public ParamInfoList getParamInfoList() {
        ParamInfoList paramInfos = new ParamInfoList();
        ParamInfo.setCurrent(Dot.class, this);
        paramInfos.add(new ParamInfo("transparent", 25));
        paramInfos.add(new ParamInfo("textOverlapping", 10));
        paramInfos.add(new ParamInfo("shadow", 10));
        String group = "point";
        paramInfos.add(group, new ParamInfo("markerStyle", 7));
        paramInfos.add(group, new ParamInfo("lineStyle", 4));
        paramInfos.add(group, new ParamInfo("lineWeight", 25));
        paramInfos.add(group, new ParamInfo("lineColor", 3));
        paramInfos.add(group, new ParamInfo("markerColor", 12));
        paramInfos.add(group, new ParamInfo("markerWeight", 25));
        paramInfos.add(group, new ParamInfo("radius1", 25));
        paramInfos.add(group, new ParamInfo("radius2", 25));
        group = "text";
        paramInfos.add(group, new ParamInfo("text"));
        paramInfos.add(group, new ParamInfo("textFont", 5));
        paramInfos.add(group, new ParamInfo("textStyle", 8));
        paramInfos.add(group, new ParamInfo("textSize", 20));
        paramInfos.add(group, new ParamInfo("textColor", 3));
        paramInfos.addAll(super.getParamInfoList());
        return paramInfos;
    }

    @Override
    public void drawBack() {
        if (!this.isVisible() || !this.shadow) {
            return;
        }
        this.drawStep(1);
    }

    @Override
    public void draw() {
        if (!this.isVisible()) {
            return;
        }
        this.drawStep(2);
    }

    @Override
    public void drawFore() {
        if (!this.isVisible()) {
            return;
        }
        this.drawStep(3);
    }

    private void drawStep(int step) {
        int size = this.pointSize();
        int i = 1;
        while (i <= size) {
            block4: {
                try {
                    Point2D p = this.getNumericPoint(i, false);
                    Shape shape = this.drawADot(i, p, step);
                    if (shape != null) {
                        String title = this.getTipTitle(i);
                        this.addLink(shape, this.htmlLink.stringValue(i), title, this.linkTarget.stringValue(i));
                    }
                }
                catch (RuntimeException re) {
                    if (re.getMessage().startsWith(NOT_IN_DEFINE)) break block4;
                    throw re;
                }
            }
            ++i;
        }
    }

    protected Shape drawADot(int index, Point2D p, int step) {
        return this.drawADot(index, p, step, false);
    }

    protected Shape drawADot(int index, Point2D p, int step, boolean isScreenPoint) {
        ICoor coor = this.getCoor();
        Graphics2D g = this.e.getGraphics();
        int shape = this.markerStyle.intValue(index);
        Shape linkShape = null;
        if (this.isPhysicalCoor() || coor.isCartesianCoor()) {
            double radiusy;
            double radiusx;
            if (this.isPhysicalCoor()) {
                double val = this.radius1.doubleValue(index);
                radiusx = this.e.getXPixel(val);
                val = this.radius2.doubleValue(index);
                radiusy = this.e.getXPixel(val);
            } else {
                TickAxis ia;
                CartesianCoor cc = (CartesianCoor)coor;
                if (!isScreenPoint) {
                    p = cc.getScreenPoint(p);
                }
                if ((ia = cc.getXAxis()) == cc.getAxis1()) {
                    double val = this.radius1.doubleValue(index);
                    radiusx = ia.getValueRadius(val);
                    val = this.radius2.doubleValue(index);
                    radiusy = cc.getAxis2().getValueRadius(val);
                } else {
                    double val = this.radius1.doubleValue(index);
                    radiusy = ia.getValueRadius(val);
                    val = this.radius2.doubleValue(index);
                    radiusx = cc.getAxis2().getValueRadius(val);
                }
            }
            double rw = this.markerWeight.doubleValue(index);
            int style = this.lineStyle.intValue(index);
            float weight = this.lineWeight.floatValue(index);
            switch (step) {
                case 1: {
                    linkShape = Utils.drawCartesianPoint1(g, p, shape, radiusx, radiusy, rw, style, weight, this.transparent);
                    break;
                }
                case 2: {
                    ChartColor backColor = this.markerColor.chartColorValue(index);
                    Color foreColor = this.lineColor.colorValueNullAsDef(index);
                    Utils.drawCartesianPoint2(g, p, shape, radiusx, radiusy, rw, style, weight, backColor, foreColor, this.transparent);
                    break;
                }
                case 3: {
                    String txt = this.text.stringValue(index);
                    if (!StringUtils.isValidString(txt)) {
                        return null;
                    }
                    double x = p.getX();
                    double y = p.getY();
                    x = p.getX();
                    y = radiusy > 0.0 ? p.getY() - radiusy : p.getY() - rw;
                    String fontName = this.textFont.stringValue(index);
                    int fontStyle = this.textStyle.intValue(index);
                    int fontSize = this.textSize.intValue(index);
                    Font font = Utils.getFont(fontName, fontStyle, fontSize);
                    Color c = this.textColor.colorValue(index);
                    Utils.drawText(this.e, txt, x, y, font, c, fontStyle, 0, 34, this.textOverlapping);
                }
            }
        } else {
            double radiusA;
            double radiusR;
            PolarCoor pc = (PolarCoor)coor;
            TickAxis ia = pc.getPolarAxis();
            if (ia == pc.getAxis1()) {
                double val = this.radius1.doubleValue(index);
                radiusR = ia.getValueRadius(val);
                val = this.radius2.doubleValue(index);
                radiusA = pc.getAxis2().getValueRadius(val);
            } else {
                double val = this.radius1.doubleValue(index);
                radiusA = ia.getValueRadius(val);
                val = this.radius2.doubleValue(index);
                radiusR = pc.getAxis2().getValueRadius(val);
            }
            double rw = this.markerWeight.doubleValue(index);
            int style = this.lineStyle.intValue(index);
            float weight = this.lineWeight.floatValue(index);
            switch (step) {
                case 1: {
                    linkShape = Utils.drawPolarPoint1(g, p, shape, radiusR, radiusA, rw, style, weight, pc, this.transparent);
                    break;
                }
                case 2: {
                    ChartColor backColor = this.markerColor.chartColorValue(index);
                    Color foreColor = this.lineColor.colorValueNullAsDef(index);
                    Utils.drawPolarPoint2(g, p, shape, radiusR, radiusA, rw, style, weight, pc, backColor, foreColor, this.transparent);
                    break;
                }
                case 3: {
                    String txt = this.text.stringValue(index);
                    if (!StringUtils.isValidString(txt)) {
                        return null;
                    }
                    double angle = p.getY();
                    Point2D.Double txtP = new Point2D.Double(p.getX() + radiusR, angle);
                    String fontName = this.textFont.stringValue(index);
                    int fontStyle = this.textStyle.intValue(index);
                    int fontSize = this.textSize.intValue(index);
                    Color c = this.textColor.colorValue(index);
                    Utils.drawPolarPointText(this.e, txt, pc, txtP, fontName, fontStyle, fontSize, c, this.textOverlapping);
                }
            }
        }
        return linkShape;
    }

    @Override
    public boolean hasGradientColor() {
        return this.markerColor.hasGradientColor();
    }

    public void clone(Dot d) {
        super.clone(d);
        d.lineStyle = this.lineStyle;
        d.lineWeight = this.lineWeight;
        d.lineColor = this.lineColor;
        d.markerStyle = this.markerStyle;
        d.markerColor = this.markerColor;
        d.markerWeight = this.markerWeight;
        d.radius1 = this.radius1;
        d.radius2 = this.radius2;
        d.text = this.text;
        d.textFont = this.textFont;
        d.textStyle = this.textStyle;
        d.textSize = this.textSize;
        d.textColor = this.textColor;
        d.transparent = this.transparent;
        d.textOverlapping = this.textOverlapping;
        d.shadow = this.shadow;
    }

    @Override
    public Object deepClone() {
        Dot d = new Dot();
        this.clone(d);
        return d;
    }
}

