/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.chart.element;

import com.scudata.chart.CartesianCoor;
import com.scudata.chart.DataElement;
import com.scudata.chart.ICoor;
import com.scudata.chart.Para;
import com.scudata.chart.PolarCoor;
import com.scudata.chart.Utils;
import com.scudata.chart.edit.ParamInfo;
import com.scudata.chart.edit.ParamInfoList;
import com.scudata.chart.element.Column;
import com.scudata.chart.element.Line;
import com.scudata.chart.element.Sector;
import com.scudata.chart.element.TickAxis;
import com.scudata.common.RQException;
import com.scudata.common.StringUtils;
import com.scudata.dm.Sequence;
import com.scudata.util.Variant;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;

public class NumericAxis
extends TickAxis {
    public boolean autoCalcValueRange = true;
    public boolean autoRangeFromZero = true;
    public double maxValue = 10.0;
    public double minValue = 0.0;
    public int scaleNum = 5;
    public String format = "#.##";
    public String unitFont;
    public Color unitColor = Color.blue.darker();
    public int unitStyle;
    public int unitAngle = 0;
    public int unitSize = 12;
    public int transform = 0;
    public double scale = 1.0;
    public double logBase = 10.0;
    public double powerExponent = Math.E;
    public Para warnLineStyle = new Para(new Integer(2));
    public Para warnLineWeight = new Para(new Float(1.0f));
    public Para warnLineColor = new Para(Color.red);
    public Sequence warnLineData = null;
    private transient double t_maxValue = Double.MIN_VALUE;
    private transient double t_minValue = Double.MAX_VALUE;
    private transient double t_baseValue = 0.0;
    private transient int t_baseValueLine = 0;
    private transient String t_unitText = "";

    @Override
    public ParamInfoList getParamInfoList() {
        ParamInfoList paramInfos = new ParamInfoList();
        ParamInfo.setCurrent(NumericAxis.class, this);
        String group = "numericaxis";
        paramInfos.add(group, new ParamInfo("autoCalcValueRange", 10));
        paramInfos.add(group, new ParamInfo("autoRangeFromZero", 10));
        paramInfos.add(group, new ParamInfo("maxValue", 25));
        paramInfos.add(group, new ParamInfo("minValue", 25));
        paramInfos.add(group, new ParamInfo("scaleNum", 24));
        paramInfos.add(group, new ParamInfo("format"));
        group = "transform";
        paramInfos.add(group, new ParamInfo("transform", 27));
        paramInfos.add(group, new ParamInfo("scale", 25));
        paramInfos.add(group, new ParamInfo("logBase", 25));
        paramInfos.add(group, new ParamInfo("powerExponent", 25));
        group = "warnlines";
        paramInfos.add(group, new ParamInfo("warnLineStyle", 4));
        paramInfos.add(group, new ParamInfo("warnLineWeight", 25));
        paramInfos.add(group, new ParamInfo("warnLineColor", 3));
        paramInfos.add(group, new ParamInfo("warnLineData", 1));
        group = "unit";
        paramInfos.add(group, new ParamInfo("unitFont", 5));
        paramInfos.add(group, new ParamInfo("unitStyle", 8));
        paramInfos.add(group, new ParamInfo("unitSize", 20));
        paramInfos.add(group, new ParamInfo("unitAngle", 24));
        paramInfos.add(group, new ParamInfo("unitColor", 3));
        paramInfos.addAll(super.getParamInfoList());
        return paramInfos;
    }

    public double getNumber(Object val) {
        double tmp = val instanceof Number ? ((Number)val).doubleValue() : Double.parseDouble(val.toString());
        return tmp;
    }

    @Override
    double getValueLength(Object val, boolean isAbsolute) {
        double axisLen = this.getAxisLength();
        double tmp = this.getNumber(val);
        double len = 0.0;
        if (isAbsolute) {
            Double nMax = this.recoverTickValue(this.t_maxValue);
            Double nMin = this.recoverTickValue(this.t_minValue);
            len = axisLen * (tmp / (nMax - nMin));
        } else {
            tmp = this.transform(tmp);
            len = axisLen * (tmp - this.t_minValue) / (this.t_maxValue - this.t_minValue);
        }
        return len;
    }

    @Override
    protected double getTickPosition(Object tickVal) {
        double val = ((Number)tickVal).doubleValue();
        double axisLen = this.getAxisLength();
        double len = axisLen * (val - this.t_minValue) / (this.t_maxValue - this.t_minValue);
        double pos = 0.0;
        switch (this.location) {
            case 1: 
            case 3: {
                pos = this.getLeftX() + len;
                break;
            }
            case 2: {
                pos = this.getBottomY() - len;
                break;
            }
            case 4: {
                pos = this.startAngle + len;
            }
        }
        return pos;
    }

    public Point2D getBasePoint() {
        switch (this.location) {
            case 1: 
            case 3: {
                return new Point2D.Double(this.t_baseValueLine, this.getBottomY());
            }
            case 2: {
                return new Point2D.Double(this.getLeftX(), this.t_baseValueLine);
            }
        }
        return null;
    }

    public Shape getShape() {
        return null;
    }

    private double max(double v, Object d) {
        double max = Double.NEGATIVE_INFINITY;
        if (d instanceof Sequence) {
            Sequence al = (Sequence)d;
            max = ((Number)al.max()).doubleValue();
        } else {
            max = this.getNumber(d);
        }
        return Math.max(max, v);
    }

    private double min(ArrayList dataElements) {
        double minValue = Double.POSITIVE_INFINITY;
        int i = 0;
        while (i < dataElements.size()) {
            DataElement de = (DataElement)dataElements.get(i);
            if (!de.isPhysicalCoor()) {
                Column col;
                Sequence data3;
                Sequence data = de.getAxisData(this.name);
                minValue = Math.min(minValue, ((Number)data.min()).doubleValue());
                if (de instanceof Column && (data3 = (col = (Column)de).getData3()) != null) {
                    minValue = Math.min(minValue, ((Number)data3.min()).doubleValue());
                }
            }
            ++i;
        }
        return minValue;
    }

    @Override
    public void prepare(ArrayList<DataElement> dataElements) {
        DataElement de;
        super.prepare(dataElements);
        int stackType = 0;
        int i = 0;
        while (i < dataElements.size()) {
            de = dataElements.get(i);
            if (!de.isPhysicalCoor()) {
                int tmp;
                if (de instanceof Column && (tmp = ((Column)de).stackType) > stackType) {
                    stackType = tmp;
                }
                if (de instanceof Sector && (tmp = ((Sector)de).stackType) > stackType) {
                    stackType = tmp;
                }
                if (de instanceof Line && (tmp = ((Line)de).stackType) > stackType) {
                    stackType = tmp;
                }
                if (stackType >= 2) break;
            }
            ++i;
        }
        if (this.autoCalcValueRange) {
            this.maxValue = Double.NEGATIVE_INFINITY;
            i = 0;
            while (i < dataElements.size()) {
                de = dataElements.get(i);
                if (!de.isPhysicalCoor()) {
                    Comparable<Double> data;
                    de.parseNumericAxisData(this.name);
                    if (de instanceof Column) {
                        Column co = (Column)de;
                        co.stackType = stackType;
                        data = Column.getMaxValue(de, this.name);
                    } else if (de instanceof Line) {
                        Line li = (Line)de;
                        li.stackType = stackType;
                        data = Column.getMaxValue(de, this.name);
                    } else if (de instanceof Sector) {
                        Sector se = (Sector)de;
                        se.stackType = stackType;
                        data = Column.getMaxValue(de, this.name);
                    } else {
                        data = de.getAxisData(this.name);
                    }
                    this.maxValue = this.max(this.maxValue, data);
                }
                ++i;
            }
            if (stackType == 1 || this.autoRangeFromZero) {
                if (this.maxValue > 0.0) {
                    this.minValue = 0.0;
                } else {
                    this.maxValue = 0.0;
                    this.minValue = this.min(dataElements);
                }
            } else {
                this.minValue = this.min(dataElements);
            }
            this.t_maxValue = this.transform(Math.max(this.maxValue, this.minValue));
            this.t_minValue = this.transform(Math.min(this.maxValue, this.minValue));
            double absMax = Math.max(Math.abs(this.t_maxValue), Math.abs(this.t_minValue));
            double tmpScale = 1.0;
            while (absMax < (double)this.scaleNum) {
                tmpScale *= 0.1;
                absMax *= 10.0;
            }
            absMax = Math.ceil(absMax);
            if (this.scaleNum < 1) {
                int tmp = 5;
                double leave = absMax % (double)tmp;
                while (leave > 0.0) {
                    leave = absMax % (double)(--tmp);
                }
                this.scaleNum = tmp;
            }
            double delta = 0.0;
            if (stackType == 0) {
                delta = (this.t_maxValue - this.t_minValue) * 0.1;
            }
            if (this.t_minValue >= 0.0) {
                this.t_maxValue += delta;
                if (this.t_minValue > 0.0) {
                    this.t_minValue -= delta;
                }
            } else if (this.t_maxValue <= 0.0) {
                this.t_minValue -= delta;
                if (this.t_maxValue < 0.0) {
                    this.t_maxValue += delta;
                }
            } else {
                this.t_maxValue += delta;
                this.t_minValue -= delta;
            }
        } else {
            this.t_maxValue = this.transform(Math.max(this.maxValue, this.minValue));
            this.t_minValue = this.transform(Math.min(this.maxValue, this.minValue));
        }
        switch (this.transform) {
            case 1: {
                this.scale = Math.abs(this.scale);
                if (this.scale > 1.0) {
                    this.t_unitText = "1:" + Utils.format(this.scale, "#,###");
                    break;
                }
                this.t_unitText = "1:" + this.scale;
                break;
            }
            case 2: {
                break;
            }
        }
        if (!this.autoCalcValueRange && stackType <= 0) {
            this.t_baseValue = this.t_minValue;
        }
        this.createCoorValue();
    }

    public static double log(double base, double d) {
        if (base < 0.0 || d <= 0.0 || base == 1.0) {
            return 0.0;
        }
        return (double)Math.round(Math.log(d) / Math.log(base) * 1000000.0) / 1000000.0;
    }

    public static double power(double base, double exp) {
        if (base < 0.0 || exp < 0.0 || base == 1.0) {
            return 0.0;
        }
        return (double)Math.round(Math.exp(exp * Math.log(base)) * 1000000.0) / 1000000.0;
    }

    private double recoverTickValue(double value) {
        switch (this.transform) {
            case 2: {
                return NumericAxis.power(this.logBase, value);
            }
            case 3: {
                return NumericAxis.log(this.powerExponent, value);
            }
        }
        return value;
    }

    private double transform(double value) {
        switch (this.transform) {
            case 1: {
                return value / this.scale;
            }
            case 2: {
                return NumericAxis.log(this.logBase, value);
            }
            case 3: {
                return NumericAxis.power(this.powerExponent, value);
            }
        }
        return value;
    }

    private void createCoorValue() {
        if (this.t_minValue >= 0.0 || this.t_maxValue <= 0.0) {
            boolean isLeagalRange;
            double dCoor = (this.t_maxValue - this.t_minValue) / (double)this.scaleNum;
            double delta = Math.ceil(dCoor);
            double cha = delta - dCoor;
            boolean bl = isLeagalRange = cha <= dCoor * 0.2;
            if (this.autoCalcValueRange && isLeagalRange) {
                this.t_maxValue = Math.ceil(this.t_maxValue);
                this.t_minValue = Math.floor(this.t_minValue);
                delta = Math.ceil((this.t_maxValue - this.t_minValue) / (double)this.scaleNum);
                int i = 0;
                while (i <= this.scaleNum) {
                    double tmp = this.t_minValue + (double)i * delta;
                    this.t_coorValue.add(new Double(tmp));
                    ++i;
                }
                this.t_maxValue = this.t_minValue + (double)this.scaleNum * delta;
            } else {
                delta = (this.t_maxValue - this.t_minValue) / (double)this.scaleNum;
                int i = 0;
                while (i <= this.scaleNum) {
                    double tmp = this.t_minValue + (double)i * delta;
                    this.t_coorValue.add(new Double(tmp));
                    ++i;
                }
            }
        } else {
            double absMax = this.t_maxValue;
            double absMin = Math.abs(this.t_minValue);
            double delta = Math.max(absMax, absMin) / (double)this.scaleNum;
            this.t_coorValue.add(new Double(0.0));
            boolean positiveFull = false;
            boolean negativeFull = false;
            int i = 1;
            while (i <= this.scaleNum) {
                double tmp = (double)i * delta;
                if (!positiveFull) {
                    if (tmp <= absMax) {
                        this.t_coorValue.add(new Double(tmp));
                    } else {
                        this.t_maxValue = tmp;
                        positiveFull = true;
                        this.t_coorValue.add(new Double(tmp));
                    }
                }
                if (!negativeFull) {
                    if (tmp <= absMin) {
                        this.t_coorValue.add(new Double(-tmp));
                    } else {
                        this.t_minValue = -tmp;
                        negativeFull = true;
                        this.t_coorValue.add(new Double(-tmp));
                    }
                }
                ++i;
            }
            this.t_coorValue.sort("o");
        }
    }

    @Override
    String getCoorText(Object coorValue) {
        Number coory = (Number)coorValue;
        Double d = this.recoverTickValue(((Number)coorValue).doubleValue());
        return Utils.format(d, this.format);
    }

    public void setValueRange(double max, double min) {
        this.t_maxValue = max;
        this.t_minValue = min;
    }

    @Override
    public void beforeDraw() {
        double length = this.getAxisLength();
        double dLen = length * (this.t_baseValue - this.t_minValue) / (this.t_maxValue - this.t_minValue);
        switch (this.location) {
            case 1: 
            case 3: {
                double end = this.getLeftX();
                this.t_baseValueLine = (int)(end + dLen);
                break;
            }
            case 2: {
                double end = this.getBottomY();
                this.t_baseValueLine = (int)(end - dLen);
                break;
            }
        }
    }

    @Override
    public void drawFore() {
        if (!this.isVisible()) {
            return;
        }
        super.drawFore();
        if (!StringUtils.isValidString(this.t_unitText)) {
            return;
        }
        Font font = Utils.getFont(this.unitFont, this.unitStyle, this.unitSize);
        Graphics2D g = this.e.getGraphics();
        boolean locationType = false;
        switch (this.location) {
            case 1: 
            case 3: {
                double x = this.getRightX() + (double)this.labelIndent;
                double y = this.getBottomY();
                Utils.drawText(this.e, this.t_unitText, x, y, font, this.unitColor, this.unitStyle, this.unitAngle, 16, true);
                break;
            }
            case 2: {
                double x = this.getLeftX();
                double y = this.getTopY() - (double)this.labelIndent;
                Utils.drawText(this.e, this.t_unitText, x, y, font, this.unitColor, this.unitStyle, this.unitAngle, 34, true);
                break;
            }
        }
    }

    private Number warnLineData(int index) {
        Object val = this.warnLineData.get(index);
        if (val == null) {
            return new Double(0.0);
        }
        if (val instanceof Number) {
            return (Number)val;
        }
        Number n = Variant.parseNumber(val.toString());
        if (n == null) {
            throw new RQException("Warn line data: [ " + val + " ] is not a number!");
        }
        return n;
    }

    private void drawWarnLine(int index, Point2D p, double x1, double y1, double x2, double y2) {
        Line2D.Double line = new Line2D.Double(x1, y1, x2, y2);
        this.drawWarnShape(index, p, line, null);
    }

    private void drawWarnShape(int index, Point2D p, Shape shape, Point2D screenPoint) {
        Color wc = this.warnLineColor.colorValueNullAsDef(index);
        int ws = this.warnLineStyle.intValue(index);
        float ww = this.warnLineWeight.floatValue(index);
        Graphics2D g = this.e.getGraphics();
        if (Utils.setStroke(g, wc, ws, ww)) {
            double y;
            double x;
            g.draw(shape);
            String txt = this.getCoorText(this.warnLineData(index));
            int locationType = this.adjustLabelPosition(p);
            Font font = Utils.getFont(this.labelFont, this.labelStyle, this.labelSize);
            if (screenPoint == null) {
                x = p.getX();
                y = p.getY();
            } else {
                x = screenPoint.getX();
                y = screenPoint.getY();
            }
            Utils.drawText(this.e, txt, x, y, font, wc, this.labelStyle, this.labelAngle, locationType, this.labelOverlapping);
        }
    }

    @Override
    public void draw() {
        super.draw();
        if (this.warnLineData == null) {
            return;
        }
        ArrayList<ICoor> coorList = this.e.getCoorList();
        Graphics2D g = this.e.getGraphics();
        int tCount = this.warnLineData.length();
        switch (this.location) {
            case 1: {
                int i = 0;
                while (i < coorList.size()) {
                    CartesianCoor cc;
                    ICoor coor = coorList.get(i);
                    if (!coor.isPolarCoor() && (cc = (CartesianCoor)coor).getXAxis() == this) {
                        int coorShift = cc.get3DShift();
                        TickAxis yAxis = cc.getYAxis();
                        int t = 1;
                        while (t <= tCount) {
                            Number tickVal = this.warnLineData(t);
                            double x = this.getTickPosition(tickVal);
                            double y = this.getBottomY() + this.coorThick;
                            Point2D.Double p = new Point2D.Double(x, y);
                            this.drawWarnLine(t, p, x + (double)coorShift, yAxis.getBottomY() - (double)coorShift, x + (double)coorShift, yAxis.getTopY() - (double)coorShift);
                            ++t;
                        }
                    }
                    ++i;
                }
                break;
            }
            case 2: {
                int i = 0;
                while (i < coorList.size()) {
                    CartesianCoor cc;
                    ICoor coor = coorList.get(i);
                    if (!coor.isPolarCoor() && (cc = (CartesianCoor)coor).getYAxis() == this) {
                        int coorShift = cc.get3DShift();
                        TickAxis xAxis = cc.getXAxis();
                        int t = 1;
                        while (t <= tCount) {
                            Number tickVal = this.warnLineData(t);
                            double x = this.getLeftX() - this.coorThick;
                            double y = this.getTickPosition(tickVal);
                            Point2D.Double p = new Point2D.Double(x, y);
                            this.drawWarnLine(t, p, xAxis.getLeftX() + (double)coorShift, y - (double)coorShift, xAxis.getRightX() + (double)coorShift, y - (double)coorShift);
                            ++t;
                        }
                    }
                    ++i;
                }
                break;
            }
            case 3: {
                int i = 0;
                while (i < coorList.size()) {
                    PolarCoor pc;
                    ICoor coor = coorList.get(i);
                    if (!coor.isCartesianCoor() && (pc = (PolarCoor)coor).getPolarAxis() == this) {
                        TickAxis angleAxis = pc.getAngleAxis();
                        Point2D.Double orginalPoint = new Point2D.Double(this.getLeftX(), this.getBottomY());
                        int t = 1;
                        while (t <= tCount) {
                            Shape warnShape;
                            Number tickVal = this.warnLineData(t);
                            ArrayList<Point2D> points = new ArrayList<Point2D>();
                            double x = this.getTickPosition(tickVal);
                            double y = this.getBottomY() + this.coorThick;
                            Point2D.Double p = new Point2D.Double(x, y);
                            if (this.isPolygonalRegion) {
                                double polarLen = this.getTickPosition(tickVal) - this.getLeftX();
                                int n = 1;
                                while (n <= angleAxis.t_coorValue.length()) {
                                    Object angleTick = angleAxis.t_coorValue.get(n);
                                    double angle = angleAxis.getTickPosition(angleTick);
                                    Point2D.Double polarPoint = new Point2D.Double(polarLen, angle);
                                    points.add(pc.getScreenPoint(polarPoint));
                                    ++n;
                                }
                                warnShape = Utils.getPath2D(points, this.isCircleAngle());
                            } else {
                                double w;
                                double tmpLen = x - ((Point2D)orginalPoint).getX();
                                x = ((Point2D)orginalPoint).getX() - tmpLen;
                                y = ((Point2D)orginalPoint).getY() - tmpLen;
                                double h = w = tmpLen * 2.0;
                                warnShape = new Arc2D.Double(x, y, w, h, angleAxis.startAngle, angleAxis.endAngle - angleAxis.startAngle, 0);
                            }
                            this.drawWarnShape(t, p, warnShape, null);
                            ++t;
                        }
                    }
                    ++i;
                }
                break;
            }
            case 4: {
                int i = 0;
                while (i < coorList.size()) {
                    PolarCoor pc;
                    ICoor coor = coorList.get(i);
                    if (!coor.isCartesianCoor() && (pc = (PolarCoor)coor).getAngleAxis() == this) {
                        TickAxis polarAxis = pc.getPolarAxis();
                        Point2D.Double orginalPoint = new Point2D.Double(polarAxis.getLeftX(), polarAxis.getBottomY());
                        double polarLen = polarAxis.getAxisLength();
                        int t = 1;
                        while (t <= tCount) {
                            Number tickVal = this.warnLineData(t);
                            double angle = this.getValueLen(tickVal);
                            Point2D.Double p = new Point2D.Double(polarLen, angle);
                            Line2D.Double warnShape = new Line2D.Double(orginalPoint, pc.getScreenPoint(p));
                            this.drawWarnShape(t, p, warnShape, pc.getScreenPoint(p));
                            ++t;
                        }
                    }
                    ++i;
                }
                break;
            }
        }
    }

    @Override
    public boolean isEnumAxis() {
        return false;
    }

    @Override
    public boolean isDateAxis() {
        return false;
    }

    @Override
    public boolean isNumericAxis() {
        return true;
    }

    public static void main(String[] args) {
        double d = 1000.0;
        double tmp = NumericAxis.log(10.0, d);
        System.out.println("1:" + tmp);
        tmp = NumericAxis.power(10.0, tmp);
        System.out.println("2:" + tmp);
    }

    @Override
    public void checkDataMatch(Sequence data) {
        if (data != null && data.length() > 1) {
            Object one = data.get(1);
            this.getNumber(one);
        }
    }

    @Override
    public double animateDoubleValue(Object val) {
        return this.getNumber(val);
    }
}

