/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.chart.element;

import com.scudata.chart.ChartColor;
import com.scudata.chart.DataElement;
import com.scudata.chart.ICoor;
import com.scudata.chart.Para;
import com.scudata.chart.PolarCoor;
import com.scudata.chart.Utils;
import com.scudata.chart.edit.ParamInfo;
import com.scudata.chart.edit.ParamInfoList;
import com.scudata.chart.element.Column;
import com.scudata.chart.element.EnumAxis;
import com.scudata.chart.element.Line;
import com.scudata.chart.element.NumericAxis;
import com.scudata.chart.element.TickAxis;
import com.scudata.common.StringUtils;
import com.scudata.dm.Sequence;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public abstract class Ring
extends DataElement {
    public int stackType = 0;
    public float transparent = 1.0f;
    public Para borderStyle = new Para(new Integer(1));
    public Para borderWeight = new Para(new Integer(0));
    public Para borderColor = new Para(new Integer(Color.DARK_GRAY.getRGB()), 1);
    public Para fillColor = new Para(3);
    public Para text = new Para(null);
    public Para textFont = new Para();
    public Para textStyle = new Para(new Integer(0));
    public Para textSize = new Para(new Integer(12));
    public Para textColor = new Para(Color.black);
    public boolean textOverlapping = true;

    public boolean isStacked() {
        return this.stackType > 0;
    }

    public static Double getMaxValue(DataElement de, String numericAxis) {
        Sequence numData = de.getAxisData(numericAxis);
        Sequence enumData = de.getOppositeAxisData(numericAxis);
        double max = 0.0;
        int stackType = 0;
        if (de instanceof Ring) {
            stackType = ((Ring)de).stackType;
        }
        if (de instanceof Line) {
            stackType = ((Line)de).stackType;
        }
        if (stackType == 2) {
            int catSize = de.categories.length();
            int c = 1;
            while (c <= catSize) {
                String catName = (String)de.categories.get(c);
                double d = Utils.sumCategory(catName, enumData, numData);
                if (d > max) {
                    max = d;
                }
                ++c;
            }
        } else if (stackType == 1) {
            max = 1.0;
        } else {
            Column col;
            Sequence data3;
            max = ((Number)numData.max()).doubleValue();
            if (de instanceof Column && (data3 = (col = (Column)de).getData3()) != null) {
                double d = ((Number)data3.max()).doubleValue();
                max = Math.max(max, d);
            }
        }
        return new Double(max);
    }

    @Override
    protected String getText(int index) {
        return this.text.stringValue(index);
    }

    private void drawData(int index, double halfColWidth, int step, int seriesIndex) {
        String title = this.getTipTitle(index);
        if (this.isPhysicalCoor()) {
            Point2D.Double basePoint;
            Point2D p = this.getScreenPoint(index);
            if (this.getData3() == null) {
                basePoint = new Point2D.Double(0.0, 0.0);
            } else {
                Object val3 = this.getData3().get(index);
                double vx = ((Number)this.data1.get(index)).doubleValue();
                double vy = ((Number)val3).doubleValue();
                double px = this.e.getXPixel(vx);
                double py = this.e.getYPixel(vy);
                basePoint = new Point2D.Double(px, py);
            }
            Point2D.Double p1 = new Point2D.Double(p.getX() - halfColWidth, ((Point2D)basePoint).getY());
            Point2D.Double p2 = new Point2D.Double(p.getX() + halfColWidth, p.getY());
            Shape dataLinkShape = this.drawFreeColumn(index, p1, p2, step, true, seriesIndex);
            if (dataLinkShape != null) {
                this.addLink(dataLinkShape, this.htmlLink.stringValue(index), title, this.linkTarget.stringValue(index));
            }
            return;
        }
        Object val1 = this.data1.get(index);
        Object val2 = this.data2.get(index);
        String txt = this.text.stringValue(index);
        Shape dataLinkShape = null;
        if (this.stackType == 1) {
            if (val2 instanceof Number) {
                val2 = Ring.getPercentValue(val1, val2, this.data1, this.data2);
            } else {
                val1 = Ring.getPercentValue(val2, val1, this.data2, this.data1);
            }
        }
        ICoor coor = this.getCoor();
        TickAxis t1 = coor.getAxis1();
        if (coor.isCartesianCoor()) {
            Point2D.Double p2;
            Point2D.Double p1;
            Point2D basePoint;
            boolean isVerticalColumn;
            Point2D p = coor.getScreenPoint(val1, val2);
            boolean bl = isVerticalColumn = t1.getLocation() == 1;
            if (this.getData3() == null) {
                basePoint = t1.getBasePoint(coor);
            } else {
                Object val3 = this.getData3().get(index);
                basePoint = coor.getScreenPoint(val1, val3);
            }
            if (isVerticalColumn) {
                p1 = new Point2D.Double(p.getX() - halfColWidth, basePoint.getY());
                p2 = new Point2D.Double(p.getX() + halfColWidth, p.getY());
            } else {
                p1 = new Point2D.Double(basePoint.getX(), p.getY() + halfColWidth);
                p2 = new Point2D.Double(p.getX(), p.getY() - halfColWidth);
            }
            dataLinkShape = this.drawFreeColumn(index, p1, p2, step, isVerticalColumn, seriesIndex);
        } else {
            PolarCoor pc = (PolarCoor)coor;
            Point2D p = pc.getPolarPoint(val1, val2);
            Graphics2D g = this.e.getGraphics();
            TickAxis angleAxis = pc.getAngleAxis();
            Color bc = this.borderColor.colorValueNullAsDef(seriesIndex);
            int bs = this.borderStyle.intValue(seriesIndex);
            float bw = this.borderWeight.floatValue(seriesIndex);
            ChartColor fc = this.fillColor.chartColorValue(seriesIndex);
            if (t1.getLocation() == 3) {
                double extent;
                double start;
                if (this.getData3() == null) {
                    start = angleAxis.startAngle;
                    extent = p.getY();
                } else {
                    Object val3 = this.getData3().get(index);
                    double angle3 = angleAxis.getValueLen(val3);
                    start = angleAxis.startAngle + Math.min(p.getY(), angle3);
                    extent = Math.abs(p.getY() - angle3);
                }
                switch (step) {
                    case 1: {
                        Rectangle2D bigBounds = pc.getEllipseBounds(p.getX() + halfColWidth);
                        Rectangle2D smallBounds = pc.getEllipseBounds(p.getX() - halfColWidth);
                        dataLinkShape = Utils.draw2DRing(g, bigBounds, smallBounds, start, extent, bc, bs, bw, this.transparent, fc);
                        break;
                    }
                    case 2: {
                        if (!StringUtils.isValidString(txt)) {
                            return;
                        }
                        double angle = start + extent / 2.0;
                        Point2D.Double txtP = new Point2D.Double(p.getX(), angle);
                        String fontName = this.textFont.stringValue(index);
                        int fontStyle = this.textStyle.intValue(index);
                        int fontSize = this.textSize.intValue(index);
                        Color c = this.textColor.colorValue(index);
                        Utils.drawPolarPointText(this.e, txt, pc, txtP, fontName, fontStyle, fontSize, c, this.textOverlapping);
                    }
                }
            } else {
                TickAxis polarAxis = pc.getPolarAxis();
                double r3 = 0.0;
                if (this.getData3() != null) {
                    Object val3 = this.getData3().get(index);
                    r3 = polarAxis.getValueLen(val3);
                }
                Rectangle2D bigBounds = pc.getEllipseBounds(Math.max(p.getX(), r3));
                Rectangle2D smallBounds = pc.getEllipseBounds(Math.min(p.getX(), r3));
                double start = angleAxis.startAngle + p.getY() - halfColWidth;
                double extent = halfColWidth * 2.0;
                switch (step) {
                    case 1: {
                        dataLinkShape = Utils.draw2DRing(g, bigBounds, smallBounds, start, extent, bc, bs, bw, this.transparent, fc, this.isFillPie());
                        break;
                    }
                    case 2: {
                        if (!StringUtils.isValidString(txt)) {
                            return;
                        }
                        String fontName = this.textFont.stringValue(index);
                        int fontStyle = this.textStyle.intValue(index);
                        int fontSize = this.textSize.intValue(index);
                        Color c = this.textColor.colorValue(index);
                        Utils.drawPolarPointText(this.e, txt, pc, p, fontName, fontStyle, fontSize, c, this.textOverlapping, 18);
                    }
                }
            }
        }
        if (dataLinkShape != null) {
            this.addLink(dataLinkShape, this.htmlLink.stringValue(index), title, this.linkTarget.stringValue(index));
        }
    }

    public static Object discardSeries(Object val) {
        if (val instanceof Number) {
            return val;
        }
        return Utils.parseCategory(val);
    }

    public static Double getPercentValue(Object catName, Object numVal, Sequence enumData, Sequence numData) {
        double catSum = Utils.sumCategory(catName.toString(), enumData, numData);
        double val = ((Number)numVal).doubleValue() / catSum;
        return new Double(val);
    }

    private Point2D drawStackedData(int index, double halfColWidth, int step, int seriesIndex, Point2D lastPoint) {
        Object val1 = Ring.discardSeries(this.data1.get(index));
        Object val2 = Ring.discardSeries(this.data2.get(index));
        String title = this.getTipTitle(index);
        Shape linkShape = null;
        if (this.stackType == 1) {
            if (val2 instanceof Number) {
                val2 = Ring.getPercentValue(val1, val2, this.data1, this.data2);
            } else {
                val1 = Ring.getPercentValue(val2, val1, this.data2, this.data1);
            }
        }
        ICoor coor = this.getCoor();
        TickAxis ta1 = coor.getAxis1();
        Point2D.Double p2 = null;
        if (coor.isCartesianCoor()) {
            Point2D.Double p1;
            Point2D p = coor.getScreenPoint(val1, val2);
            double columnLength = 0.0;
            boolean isVerticalColumn = ta1.getLocation() == 1;
            Point2D basePoint = ta1.getBasePoint(coor);
            if (isVerticalColumn) {
                p1 = new Point2D.Double(p.getX() - halfColWidth, lastPoint.getY());
                columnLength = basePoint.getY() - p.getY();
                p2 = new Point2D.Double(p.getX() + halfColWidth, lastPoint.getY() - columnLength);
            } else {
                p1 = new Point2D.Double(lastPoint.getX(), p.getY() + halfColWidth);
                columnLength = p.getX() - basePoint.getX();
                p2 = new Point2D.Double(lastPoint.getX() + columnLength, p.getY() - halfColWidth);
            }
            linkShape = this.drawFreeColumn(index, p1, p2, step, isVerticalColumn, seriesIndex);
        } else {
            PolarCoor pc = (PolarCoor)coor;
            Point2D p = pc.getPolarPoint(val1, val2);
            Graphics2D g = this.e.getGraphics();
            TickAxis angleAxis = pc.getAngleAxis();
            Color bc = this.borderColor.colorValueNullAsDef(seriesIndex);
            int bs = this.borderStyle.intValue(seriesIndex);
            float bw = this.borderWeight.floatValue(seriesIndex);
            ChartColor fc = this.fillColor.chartColorValue(seriesIndex);
            if (ta1.getLocation() == 3) {
                double start = lastPoint == null ? angleAxis.startAngle : lastPoint.getY();
                double extent = p.getY();
                switch (step) {
                    case 1: {
                        Rectangle2D bigBounds = pc.getEllipseBounds(p.getX() + halfColWidth);
                        Rectangle2D smallBounds = pc.getEllipseBounds(p.getX() - halfColWidth);
                        linkShape = Utils.draw2DRing(g, bigBounds, smallBounds, start, extent, bc, bs, bw, this.transparent, fc, this.isFillPie());
                        break;
                    }
                    case 2: {
                        String txt = this.text.stringValue(index);
                        if (!StringUtils.isValidString(txt)) break;
                        double angle = start + extent / 2.0;
                        Point2D.Double txtP = new Point2D.Double(p.getX(), angle);
                        String fontName = this.textFont.stringValue(index);
                        int fontStyle = this.textStyle.intValue(index);
                        int fontSize = this.textSize.intValue(index);
                        Color c = this.textColor.colorValue(index);
                        Utils.drawPolarPointText(this.e, txt, pc, txtP, fontName, fontStyle, fontSize, c, this.textOverlapping, 18);
                    }
                }
                p2 = new Point2D.Double(p.getX(), start + extent);
            } else {
                double outerR;
                double innerR;
                if (lastPoint == null) {
                    innerR = 0.0;
                    outerR = p.getX();
                } else {
                    innerR = lastPoint.getX();
                    outerR = innerR + p.getX();
                }
                double start = angleAxis.startAngle + p.getY() - halfColWidth;
                double extent = halfColWidth * 2.0;
                switch (step) {
                    case 1: {
                        Rectangle2D bigBounds = pc.getEllipseBounds(outerR);
                        Rectangle2D smallBounds = pc.getEllipseBounds(innerR);
                        linkShape = Utils.draw2DRing(g, bigBounds, smallBounds, start, extent, bc, bs, bw, this.transparent, fc);
                        break;
                    }
                    case 2: {
                        String txt = this.text.stringValue(index);
                        if (!StringUtils.isValidString(txt)) break;
                        String fontName = this.textFont.stringValue(index);
                        int fontStyle = this.textStyle.intValue(index);
                        int fontSize = this.textSize.intValue(index);
                        Color c = this.textColor.colorValue(index);
                        Point2D.Double p1 = new Point2D.Double(innerR + p.getX() / 2.0, p.getY());
                        Utils.drawPolarPointText(this.e, txt, pc, p1, fontName, fontStyle, fontSize, c, this.textOverlapping, 18);
                    }
                }
                p2 = new Point2D.Double(outerR, p.getY());
            }
        }
        if (linkShape != null) {
            this.addLink(linkShape, this.htmlLink.stringValue(index), title, this.linkTarget.stringValue(index));
        }
        return p2;
    }

    public void drawStep(int step) {
        ICoor coor;
        if (!this.isVisible()) {
            return;
        }
        TickAxis ia1 = null;
        if (!this.isPhysicalCoor() && (ia1 = (coor = this.getCoor()).getAxis1()).isEnumAxis()) {
            this.drawEnumBasedRing(step);
            return;
        }
        int size = this.pointSize();
        Sequence sort = null;
        sort = this.data1.psort(null);
        int i = 1;
        while (i <= size) {
            int index = ((Number)sort.get(i)).intValue();
            double colWidth = this.getColumnWidth(ia1, index);
            double halfColWidth = colWidth / 2.0;
            this.drawData(index, halfColWidth, step, index);
            ++i;
        }
    }

    private void drawEnumBasedRing(int step) {
        ICoor coor = this.getCoor();
        EnumAxis ea = (EnumAxis)coor.getAxis1();
        Sequence enumData = this.data1;
        int catCount = this.categories.length();
        int c = 1;
        while (c <= catCount) {
            String catName = (String)this.categories.get(c);
            int index = 0;
            int serCount = this.series.length();
            if (serCount == 0) {
                index = Utils.indexOf(enumData, catName, null);
                if (index != 0) {
                    double colWidth = this.getColumnWidth(ea, index);
                    double halfColWidth = colWidth / 2.0;
                    this.drawData(index, halfColWidth, step, index);
                }
            } else if (this.isStacked()) {
                Point2D lastPoint = null;
                if (coor.isCartesianCoor()) {
                    lastPoint = ea.getBasePoint(coor);
                }
                int s = 1;
                while (s <= serCount) {
                    String serName = (String)this.series.get(s);
                    index = Utils.indexOf(enumData, catName, serName);
                    if (index != 0) {
                        double colWidth = this.getColumnWidth(ea, index);
                        double halfColWidth = colWidth / 2.0;
                        lastPoint = this.drawStackedData(index, halfColWidth, step, s, lastPoint);
                    }
                    ++s;
                }
            } else {
                int s = 1;
                while (s <= serCount) {
                    String serName = (String)this.series.get(s);
                    index = Utils.indexOf(enumData, catName, serName);
                    if (index != 0) {
                        double colWidth = this.getColumnWidth(ea, index);
                        double halfColWidth = colWidth / 2.0;
                        this.drawData(index, halfColWidth, step, s);
                    }
                    ++s;
                }
            }
            ++c;
        }
    }

    @Override
    public void drawBack() {
        this.drawStep(1);
    }

    @Override
    public void draw() {
    }

    @Override
    public void drawFore() {
        this.drawStep(2);
    }

    @Override
    public ParamInfoList getParamInfoList() {
        ParamInfoList paramInfos = new ParamInfoList();
        ParamInfo.setCurrent(Ring.class, this);
        paramInfos.add(new ParamInfo("stackType", 29));
        paramInfos.add(new ParamInfo("textOverlapping", 10));
        paramInfos.add(new ParamInfo("transparent", 25));
        String group = "appearance";
        paramInfos.add(group, new ParamInfo("borderStyle", 4));
        paramInfos.add(group, new ParamInfo("borderWeight", 24));
        paramInfos.add(group, new ParamInfo("borderColor", 3));
        paramInfos.add(group, new ParamInfo("fillColor", 12));
        group = "text";
        paramInfos.add(group, new ParamInfo("text"));
        paramInfos.add(group, new ParamInfo("textFont", 5));
        paramInfos.add(group, new ParamInfo("textStyle", 8));
        paramInfos.add(group, new ParamInfo("textSize", 20));
        paramInfos.add(group, new ParamInfo("textColor", 3));
        ParamInfoList superParams = super.getParamInfoList();
        superParams.delete("data", "axisTime");
        superParams.delete("data", "dataTime");
        paramInfos.addAll(superParams);
        return paramInfos;
    }

    @Override
    public void prepare() {
        super.prepare();
        Ring.checkStackProperties(this);
    }

    public static void checkStackProperties(DataElement de) {
        boolean isStacked = false;
        Sequence data3 = null;
        if (de instanceof Ring) {
            Ring r = (Ring)de;
            isStacked = r.isStacked();
            data3 = r.getData3();
        }
        if (de instanceof Line) {
            Line l = (Line)de;
            isStacked = l.isStacked();
        }
        if (isStacked) {
            if (de.isPhysicalCoor()) {
                throw new RuntimeException("Stacked graph does not support physical coordinates.");
            }
            ICoor coor = de.getCoor();
            if (!coor.isEnumBased()) {
                throw new RuntimeException("Stacked graph must be based on EnumAxis, and it must be spedified by 'axis1' property.");
            }
            if (data3 != null) {
                throw new RuntimeException("Floating column can not be stacked.");
            }
            NumericAxis na = coor.getNumericAxis();
            Sequence numData = de.getAxisData(na.getName());
            double min = ((Number)numData.min()).doubleValue();
            if (min < 0.0) {
                throw new RuntimeException("Stacked graph does not support netagive data:" + min);
            }
            if (na.transform == 3 || na.transform == 2) {
                throw new RuntimeException("Stacked graph does not support exponent or log transform.");
            }
        }
    }

    @Override
    public boolean hasGradientColor() {
        return this.fillColor.hasGradientColor();
    }

    protected Shape drawFreeColumn(int index, Point2D p1, Point2D p2, int step, boolean isVertical, int seriesIndex) {
        return null;
    }

    protected Sequence getData3() {
        return null;
    }

    protected boolean isFillPie() {
        return false;
    }

    public abstract double getColumnWidth(TickAxis var1, int var2);
}

