/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.chart.element;

import com.scudata.app.common.StringUtils2;
import com.scudata.chart.DataElement;
import com.scudata.chart.Para;
import com.scudata.chart.Utils;
import com.scudata.chart.edit.ParamInfo;
import com.scudata.chart.edit.ParamInfoList;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;

public class Text
extends DataElement {
    public Para width = new Para(new Double(0.0));
    public Para height = new Para(new Double(0.0));
    public Para text = new Para(null);
    public Para textFont = new Para("Dialog");
    public Para textStyle = new Para(new Integer(0));
    public Para textSize = new Para(new Integer(14));
    public Para textColor = new Para(Color.black);
    public Para backColor = new Para(null);
    public boolean isMulti = false;
    public int textAngle = 0;
    public int hAlign = 2;
    public int vAlign = 16;
    public int barType = 0;
    public String charSet = "UTF-8";
    public boolean dispText = false;
    public String recError = "M";
    public Para logoValue = new Para();
    public int logoSize = 15;
    public boolean logoFrame = true;

    public boolean isMulti() {
        return this.isMulti;
    }

    @Override
    public void beforeDraw() {
    }

    @Override
    public void draw() {
    }

    @Override
    public void drawBack() {
    }

    public int getWidth(int index) {
        return (int)this.e.getXPixel(this.width.doubleValue(index));
    }

    public int getHeight(int index) {
        return (int)this.e.getYPixel(this.height.doubleValue(index));
    }

    @Override
    public void drawFore() {
        if (!this.isVisible()) {
            return;
        }
        this.drawTexts();
    }

    private void drawTexts() {
        int size = this.pointSize();
        int i = 1;
        while (i <= size) {
            Point2D p = this.getScreenPoint(i);
            Shape shape = this.drawAText(i, p);
            if (shape != null) {
                String title = this.getTipTitle(i);
                this.addLink(shape, this.htmlLink.stringValue(i), title, this.linkTarget.stringValue(i));
            }
            ++i;
        }
    }

    private Shape drawAText(int index, Point2D p) {
        double px = p.getX();
        double py = p.getY();
        String tf = this.textFont.stringValue(index);
        int ts = this.textStyle.intValue(index);
        int tsize = this.textSize.intValue(index);
        Font font = Utils.getFont(tf, ts, tsize);
        Color c = this.textColor.colorValue(index);
        Color backC = this.backColor.colorValue(index);
        String aText = this.text.stringValue(index);
        if (this.barType == 0) {
            Rectangle shape;
            Graphics2D g = this.e.getGraphics();
            if (!this.isMulti) {
                Utils.drawText(this.e, aText, px, py, font, c, backC, ts, this.textAngle, this.hAlign + this.vAlign, true);
                shape = Utils.getTextSize(aText, (Graphics)g, ts, this.textAngle, font);
                shape.setLocation((int)px, (int)py);
            } else {
                FontMetrics fm = g.getFontMetrics(font);
                int ascent = fm.getAscent();
                int fheight = fm.getHeight();
                int w = this.getWidth(index);
                if (w < 1) {
                    w = 60;
                }
                ArrayList<String> wrapedString = StringUtils2.wrapString(aText, fm, w, false, -1);
                int h = this.getHeight(index);
                int lineH = StringUtils2.getTextRowHeight(fm);
                int lines = wrapedString.size();
                if (h < 1) {
                    h = lineH * lines;
                }
                shape = new Rectangle((int)px, (int)py, w, h);
                if (backC != null) {
                    g.setColor(backC);
                    g.fillRect((int)px, (int)py, w, h);
                }
                int yy = (int)py;
                if (this.vAlign == 16) {
                    yy = (int)py + (h - lineH * lines) / 2;
                } else if (this.vAlign == 32) {
                    yy = (int)py + h - lineH * lines;
                }
                if ((double)yy < py) {
                    yy = (int)py;
                }
                int i = 0;
                while (i < lines) {
                    if (i > 0 && (double)(yy + lineH) > py + (double)h) break;
                    String wrapedText = wrapedString.get(i);
                    int fw = Text.stringWidth(fm, wrapedText, g);
                    int x1 = (int)px;
                    if (this.hAlign == 2) {
                        x1 = (int)px + (w - fw) / 2;
                    } else if (this.hAlign == 4) {
                        x1 = (int)px + w - fw;
                    }
                    int y1 = yy + fheight - ascent;
                    Utils.drawText(this.e, wrapedText, x1, y1, font, c, null, ts, 0, 16, true);
                    yy += lineH;
                    ++i;
                }
            }
            return shape;
        }
        Graphics2D g = this.e.getGraphics();
        BufferedImage barcodeImg = Utils.calcBarcodeImage(this, index, c, backC);
        Rectangle posDesc = new Rectangle();
        posDesc.setBounds((int)px, (int)py, barcodeImg.getWidth(), barcodeImg.getHeight());
        Point drawPoint = Utils.getRealDrawPoint(posDesc, this.hAlign + this.vAlign, true);
        g.drawImage((Image)barcodeImg, drawPoint.x, drawPoint.y, null);
        return posDesc;
    }

    public static int stringWidth(FontMetrics fm, String text, Graphics g) {
        Graphics displayG = g;
        FontMetrics dispFm = displayG.getFontMetrics(fm.getFont());
        return dispFm.stringWidth(text);
    }

    @Override
    public ParamInfoList getParamInfoList() {
        ParamInfoList paramInfos = new ParamInfoList();
        ParamInfo.setCurrent(Text.class, this);
        paramInfos.add(new ParamInfo("text"));
        paramInfos.add(new ParamInfo("isMulti", 10));
        String group = "size";
        paramInfos.add(group, new ParamInfo("width", 25));
        paramInfos.add(group, new ParamInfo("height", 25));
        group = "text";
        paramInfos.add(group, new ParamInfo("textFont", 5));
        paramInfos.add(group, new ParamInfo("textStyle", 8));
        paramInfos.add(group, new ParamInfo("textSize", 20));
        paramInfos.add(group, new ParamInfo("textColor", 3));
        paramInfos.add(group, new ParamInfo("backColor", 3));
        paramInfos.add(group, new ParamInfo("textAngle", 24));
        group = "align";
        paramInfos.add(group, new ParamInfo("hAlign", 21));
        paramInfos.add(group, new ParamInfo("vAlign", 22));
        group = "barcode";
        paramInfos.add(group, new ParamInfo("barType", 60));
        paramInfos.add(group, new ParamInfo("charSet", 61));
        paramInfos.add(group, new ParamInfo("dispText", 10));
        paramInfos.add(group, new ParamInfo("recError", 62));
        paramInfos.add(group, new ParamInfo("logoValue"));
        paramInfos.add(group, new ParamInfo("logoSize", 24));
        paramInfos.add(group, new ParamInfo("logoFrame", 10));
        ParamInfoList superParams = super.getParamInfoList();
        superParams.delete("data", "axisTime");
        superParams.delete("data", "dataTime");
        paramInfos.addAll(superParams);
        return paramInfos;
    }

    public String getDispText(int index) {
        return this.text.stringValue(index);
    }

    @Override
    protected String getText(int index) {
        if (this.barType != 0) {
            return this.text.stringValue(index);
        }
        return null;
    }

    @Override
    public boolean hasGradientColor() {
        return false;
    }

    public void clone(Text t) {
        super.clone(t);
    }

    @Override
    public Object deepClone() {
        Text t = new Text();
        this.clone(t);
        return t;
    }
}

