/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.chart.element;

import com.scudata.chart.CartesianCoor;
import com.scudata.chart.ChartColor;
import com.scudata.chart.CubeColor;
import com.scudata.chart.DataElement;
import com.scudata.chart.Engine;
import com.scudata.chart.IAxis;
import com.scudata.chart.ICoor;
import com.scudata.chart.ObjectElement;
import com.scudata.chart.Para;
import com.scudata.chart.PolarCoor;
import com.scudata.chart.Utils;
import com.scudata.chart.edit.ParamInfo;
import com.scudata.chart.edit.ParamInfoList;
import com.scudata.common.StringUtils;
import com.scudata.dm.Sequence;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

public abstract class TickAxis
extends ObjectElement
implements IAxis {
    private static int ARROW_SHIFT = 8;
    public String name;
    public boolean visible = true;
    public int location = 1;
    public double xStart = 0.1;
    public double xEnd = 0.8;
    public double xPosition = 0.8;
    public double yStart = 0.8;
    public double yEnd = 0.1;
    public double yPosition = 0.1;
    public double polarX = 0.4;
    public double polarY = 0.5;
    public double polarLength = 0.3;
    public double startAngle = 0.0;
    public double endAngle = 360.0;
    public boolean is3D = false;
    public double threeDThickRatio = 0.38;
    public Color axisColor = Color.LIGHT_GRAY;
    public int axisLineStyle = 1;
    public int axisLineWeight = 1;
    public int axisArrow = 0;
    public String title;
    public String titleFont;
    public int titleStyle;
    public int titleSize = 16;
    public int titleIndent = 2;
    public Color titleColor = Color.black;
    public int titleAngle;
    public boolean allowLabels = true;
    public String labelFont;
    public int labelStyle;
    public int labelSize = 12;
    public int labelIndent = 2;
    public Color labelColor = Color.darkGray;
    public int labelStep = 0;
    public int labelAngle = 0;
    public boolean labelOverlapping = false;
    public int scalePosition = 1;
    public int scaleStyle = 1;
    public int scaleWeight = 1;
    public int scaleLength = 3;
    public int displayStep = 0;
    public boolean allowRegions = true;
    public int regionLineStyle = 1;
    public Color regionLineColor = Color.lightGray;
    public int regionLineWeight = 1;
    public Para regionColors = new Para(null);
    public float regionTransparent = 0.6f;
    public boolean isPolygonalRegion = false;
    transient Sequence t_coorValue = new Sequence();
    transient int t_coorWidth = 0;
    transient Engine e;
    transient double coorThick = 0.0;
    transient boolean useGradient = false;

    public TickAxis() {
        Sequence seq = new Sequence();
        ChartColor c1 = new ChartColor(Color.white);
        c1.setGradient(false);
        seq.add(c1);
        ChartColor c2 = new ChartColor(new Color(241, 243, 235));
        c2.setGradient(false);
        seq.add(c2);
        this.regionColors = new Para(seq);
    }

    @Override
    public ParamInfoList getParamInfoList() {
        ParamInfoList paramInfos = new ParamInfoList();
        ParamInfo.setCurrent(TickAxis.class, this);
        paramInfos.add(new ParamInfo("name"));
        paramInfos.add(new ParamInfo("visible", 10));
        paramInfos.add(new ParamInfo("location", 19));
        paramInfos.add(new ParamInfo("is3D", 10));
        paramInfos.add(new ParamInfo("threeDThickRatio", 25));
        String group = "xaxis";
        paramInfos.add(group, new ParamInfo("xStart", 25));
        paramInfos.add(group, new ParamInfo("xEnd", 25));
        paramInfos.add(group, new ParamInfo("xPosition", 25));
        group = "yaxis";
        paramInfos.add(group, new ParamInfo("yStart", 25));
        paramInfos.add(group, new ParamInfo("yEnd", 25));
        paramInfos.add(group, new ParamInfo("yPosition", 25));
        group = "polaraxis";
        paramInfos.add(group, new ParamInfo("polarX", 25));
        paramInfos.add(group, new ParamInfo("polarY", 25));
        paramInfos.add(group, new ParamInfo("polarLength", 25));
        group = "angleAxis";
        paramInfos.add(group, new ParamInfo("startAngle", 25));
        paramInfos.add(group, new ParamInfo("endAngle", 25));
        group = "axisLine";
        paramInfos.add(group, new ParamInfo("axisColor", 3));
        paramInfos.add(group, new ParamInfo("axisLineStyle", 4));
        paramInfos.add(group, new ParamInfo("axisLineWeight", 24));
        paramInfos.add(group, new ParamInfo("axisArrow", 14));
        group = "axisTitle";
        paramInfos.add(group, new ParamInfo("title"));
        paramInfos.add(group, new ParamInfo("titleFont", 5));
        paramInfos.add(group, new ParamInfo("titleStyle", 8));
        paramInfos.add(group, new ParamInfo("titleSize", 20));
        paramInfos.add(group, new ParamInfo("titleIndent", 24));
        paramInfos.add(group, new ParamInfo("titleColor", 3));
        paramInfos.add(group, new ParamInfo("titleAngle", 24));
        group = "labels";
        paramInfos.add(group, new ParamInfo("allowLabels", 10));
        paramInfos.add(group, new ParamInfo("labelFont", 5));
        paramInfos.add(group, new ParamInfo("labelStyle", 8));
        paramInfos.add(group, new ParamInfo("labelSize", 20));
        paramInfos.add(group, new ParamInfo("labelIndent", 24));
        paramInfos.add(group, new ParamInfo("labelColor", 3));
        paramInfos.add(group, new ParamInfo("labelStep", 24));
        paramInfos.add(group, new ParamInfo("labelAngle", 24));
        paramInfos.add(group, new ParamInfo("labelOverlapping", 10));
        group = "scaleLine";
        paramInfos.add(group, new ParamInfo("scalePosition", 15));
        paramInfos.add(group, new ParamInfo("scaleStyle", 4));
        paramInfos.add(group, new ParamInfo("scaleWeight", 24));
        paramInfos.add(group, new ParamInfo("scaleLength", 24));
        paramInfos.add(group, new ParamInfo("displayStep", 24));
        group = "region";
        paramInfos.add(group, new ParamInfo("allowRegions", 10));
        paramInfos.add(group, new ParamInfo("regionLineStyle", 4));
        paramInfos.add(group, new ParamInfo("regionLineColor", 3));
        paramInfos.add(group, new ParamInfo("regionLineWeight", 24));
        paramInfos.add(group, new ParamInfo("regionColors", 12));
        paramInfos.add(group, new ParamInfo("regionTransparent", 25));
        paramInfos.add(group, new ParamInfo("isPolygonalRegion", 10));
        return paramInfos;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getLocation() {
        return this.location;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void prepare(ArrayList<DataElement> dataElements) {
        this.startAngle = this.in360(this.startAngle);
        this.endAngle = this.in360(this.endAngle);
        if (this.startAngle > this.endAngle) {
            double d = this.startAngle;
            this.startAngle = this.endAngle;
            this.endAngle = d;
        }
        ++this.displayStep;
        ++this.labelStep;
        int i = 0;
        while (i < dataElements.size()) {
            DataElement de = dataElements.get(i);
            if (de.hasGradientColor()) {
                this.useGradient = true;
                break;
            }
            ++i;
        }
    }

    public boolean isCircleAngle() {
        double angleRange = this.endAngle - this.startAngle;
        return angleRange == 360.0;
    }

    public double getAxisLength() {
        Point2D p1 = this.getStartPoint();
        Point2D p2 = this.getEndPoint();
        switch (this.location) {
            case 1: 
            case 3: {
                return Math.abs(p2.getX() - p1.getX());
            }
            case 2: 
            case 4: {
                return Math.abs(p2.getY() - p1.getY());
            }
        }
        return 0.0;
    }

    double in360(double angle) {
        double d = angle;
        while (d < 0.0) {
            d += 360.0;
        }
        while (d > 360.0) {
            d -= 360.0;
        }
        return d;
    }

    private Point2D getPoint(boolean getStart) {
        double x = 0.0;
        double y = 0.0;
        switch (this.location) {
            case 1: {
                x = getStart ? this.e.getXPixel(this.xStart) : this.e.getXPixel(this.xEnd);
                y = this.e.getYPixel(this.xPosition);
                break;
            }
            case 2: {
                x = this.e.getXPixel(this.yPosition);
                if (getStart) {
                    y = this.e.getYPixel(this.yStart);
                    break;
                }
                y = this.e.getYPixel(this.yEnd);
                break;
            }
            case 3: {
                x = getStart ? this.e.getXPixel(this.polarX) : this.e.getXPixel(this.polarX) + this.e.getXPixel(this.polarLength);
                y = this.e.getYPixel(this.polarY);
                break;
            }
            case 4: {
                y = getStart ? this.startAngle : this.endAngle;
            }
        }
        return new Point2D.Double(x, y);
    }

    Point2D getStartPoint() {
        return this.getPoint(true);
    }

    Point2D getEndPoint() {
        return this.getPoint(false);
    }

    public double getTopY() {
        switch (this.location) {
            case 1: {
                return this.e.getYPixel(this.xPosition);
            }
            case 2: {
                return Math.min(this.e.getYPixel(this.yStart), this.e.getYPixel(this.yEnd));
            }
            case 3: {
                return this.e.getYPixel(this.polarY);
            }
            case 4: {
                return (int)this.endAngle;
            }
        }
        return 0.0;
    }

    public double getBottomY() {
        switch (this.location) {
            case 1: {
                return this.e.getYPixel(this.xPosition);
            }
            case 2: {
                return Math.max(this.e.getYPixel(this.yStart), this.e.getYPixel(this.yEnd));
            }
            case 3: {
                return this.e.getYPixel(this.polarY);
            }
            case 4: {
                return (int)this.startAngle;
            }
        }
        return 0.0;
    }

    public double getLeftX() {
        switch (this.location) {
            case 1: {
                return Math.min(this.e.getXPixel(this.xStart), this.e.getXPixel(this.xEnd));
            }
            case 2: {
                return this.e.getXPixel(this.yPosition);
            }
            case 3: {
                return this.e.getXPixel(this.polarX);
            }
        }
        return 0.0;
    }

    public double getRightX() {
        switch (this.location) {
            case 1: {
                return Math.max(this.e.getXPixel(this.xStart), this.e.getXPixel(this.xEnd));
            }
            case 2: {
                return this.e.getXPixel(this.yPosition);
            }
            case 3: {
                return this.e.getXPixel(this.polarX) + this.e.getXPixel(this.polarLength);
            }
        }
        return 0.0;
    }

    private void drawRegion(Shape regionShape, ChartColor regionColor, int step) {
        this.drawRegion(regionShape, regionColor, step, false);
    }

    private void drawRegion(Shape regionShape, ChartColor regionColor, int step, boolean doubleEdge) {
        Graphics2D g = this.e.getGraphics();
        Rectangle rect = regionShape.getBounds();
        if (step == 1) {
            boolean isSet = false;
            if (regionColor.isDazzle()) {
                CubeColor ccr = new CubeColor(regionColor.getColor1());
                ChartColor tmpcc = new ChartColor();
                tmpcc.setColor1(ccr.getF2());
                tmpcc.setColor2(ccr.getF1());
                tmpcc.setAngle(regionColor.getAngle());
                isSet = Utils.setPaint(g, rect.x, rect.y, rect.width, rect.height, tmpcc);
            } else {
                isSet = Utils.setPaint(g, rect.x, rect.y, rect.width, rect.height, regionColor);
            }
            if (isSet) {
                Utils.fillPaint(g, regionShape, this.regionTransparent);
            }
        } else if (step == 2 && Utils.setStroke(g, this.regionLineColor, this.regionLineStyle, this.regionLineWeight)) {
            if (this.location == 1) {
                int x = rect.x;
                int y = rect.y;
                g.drawLine(x + rect.width, y, x + rect.width, y + rect.height);
                if (doubleEdge) {
                    g.drawLine(x, y, x, y + rect.height);
                }
            } else if (this.location == 2) {
                int x = rect.x;
                int y = rect.y;
                g.drawLine(x, y, x + rect.width, y);
                if (doubleEdge) {
                    g.drawLine(x, y + rect.height, x + rect.width, y + rect.height);
                }
            } else {
                g.draw(regionShape);
            }
        }
    }

    private void addPolarPoint(Polygon polygon, PolarCoor pc, double polarLen, double angle) {
        Point2D p = new Point2D.Double(polarLen, angle);
        p = pc.getScreenPoint(p);
        polygon.addPoint((int)p.getX(), (int)p.getY());
    }

    @Override
    public void drawBack() {
        if (!this.isVisible()) {
            return;
        }
        this.drawRegionStep(1);
        this.drawRegionStep(2);
    }

    void drawAxisBorder() {
        block32: {
            ArrayList<ICoor> coorList;
            Graphics2D g;
            block31: {
                g = this.e.getGraphics();
                coorList = this.e.getCoorList();
                if (!Utils.setStroke(g, this.axisColor, this.axisLineStyle, this.axisLineWeight)) break block31;
                switch (this.location) {
                    case 1: 
                    case 3: {
                        Utils.setStroke(g, this.axisColor, this.axisLineStyle, this.axisLineWeight);
                        Utils.drawLine(g, this.getStartPoint(), this.getEndPoint());
                        double x = this.getRightX();
                        double y = this.getBottomY();
                        int style = Utils.getArrow(this.axisArrow);
                        if (style != 0) {
                            if (style == 1536) {
                                x = this.getLeftX();
                                Utils.drawLine(g, x, y, x - (double)ARROW_SHIFT, y);
                                Utils.drawLineArrow(g, x - (double)ARROW_SHIFT, y, 0.0, this.axisArrow);
                            } else {
                                Utils.drawLine(g, x, y, x + (double)ARROW_SHIFT, y);
                                Utils.drawLineArrow(g, x + (double)ARROW_SHIFT, y, 0.0, this.axisArrow);
                            }
                        }
                        if (this.location != 1) break block32;
                        int i = 0;
                        while (i < coorList.size()) {
                            CartesianCoor cc;
                            ICoor coor = coorList.get(i);
                            if (coor instanceof CartesianCoor && (cc = (CartesianCoor)coor).getXAxis() == this) {
                                int coorShift = cc.get3DShift();
                                TickAxis yAxis = cc.getYAxis();
                                x = this.getLeftX();
                                y = yAxis.getBottomY();
                                Utils.setStroke(g, this.axisColor, this.axisLineStyle, this.axisLineWeight);
                                double x2 = this.getRightX();
                                if (coorShift != 0) {
                                    Polygon polygon = new Polygon();
                                    polygon.addPoint((int)x, (int)y);
                                    polygon.addPoint((int)x + coorShift, (int)y - coorShift);
                                    polygon.addPoint((int)x2 + coorShift, (int)y - coorShift);
                                    polygon.addPoint((int)x2, (int)y);
                                    g.draw(polygon);
                                }
                            }
                            ++i;
                        }
                        break block32;
                    }
                    case 2: {
                        Utils.setStroke(g, this.axisColor, this.axisLineStyle, this.axisLineWeight);
                        Utils.drawLine(g, this.getStartPoint(), this.getEndPoint());
                        double x = this.getLeftX();
                        double y = this.getTopY();
                        int styl = Utils.getArrow(this.axisArrow);
                        if (styl != 0) {
                            if (styl == 1536) {
                                y = this.getBottomY();
                                Utils.drawLine(g, x, y, x, y + (double)ARROW_SHIFT);
                                Utils.drawLineArrow(g, x, y + (double)ARROW_SHIFT, -1.5707963267948966, this.axisArrow);
                            } else {
                                Utils.drawLine(g, x, y, x, y - (double)ARROW_SHIFT);
                                Utils.drawLineArrow(g, x, y - (double)ARROW_SHIFT, -1.5707963267948966, this.axisArrow);
                            }
                        }
                        int i = 0;
                        while (i < coorList.size()) {
                            CartesianCoor cc;
                            ICoor coor = coorList.get(i);
                            if (coor instanceof CartesianCoor && (cc = (CartesianCoor)coor).getYAxis() == this) {
                                int coorShift = cc.get3DShift();
                                Utils.setStroke(g, this.axisColor, this.axisLineStyle, this.axisLineWeight);
                                TickAxis xAxis = cc.getXAxis();
                                double x1 = xAxis.getLeftX();
                                double x2 = xAxis.getRightX();
                                double thisX = this.getLeftX();
                                double d1 = Math.abs(x1 - thisX);
                                double d2 = Math.abs(x2 - thisX);
                                x = d1 < d2 ? x1 : x2;
                                y = this.getBottomY();
                                double y2 = this.getTopY();
                                if (coorShift != 0) {
                                    Polygon polygon = new Polygon();
                                    polygon.addPoint((int)x, (int)y);
                                    polygon.addPoint((int)x, (int)y2);
                                    polygon.addPoint((int)x + coorShift, (int)y2 - coorShift);
                                    polygon.addPoint((int)x + coorShift, (int)y - coorShift);
                                    g.draw(polygon);
                                }
                            }
                            ++i;
                        }
                        break block32;
                    }
                    case 4: {
                        Point2D p1 = null;
                        int i = 0;
                        while (i < coorList.size()) {
                            PolarCoor pc;
                            ICoor coor = coorList.get(i);
                            if (coor instanceof PolarCoor && (pc = (PolarCoor)coor).getAngleAxis() == this) {
                                TickAxis polarAxis = pc.getPolarAxis();
                                double polarLen = polarAxis.getAxisLength();
                                if (this.isPolygonalRegion) {
                                    int tCount = this.t_coorValue.length();
                                    int t = 1;
                                    while (t <= tCount) {
                                        Object tickVal = this.t_coorValue.get(t);
                                        double angle = this.getTickPosition(tickVal);
                                        Point2D p2 = new Point2D.Double(polarLen, angle);
                                        p2 = pc.getScreenPoint(p2);
                                        Utils.drawLine(g, p1, p2);
                                        p1 = p2;
                                        if (this.isCircleAngle() && t == tCount) {
                                            p2 = new Point2D.Double(polarLen, 360.0);
                                            p2 = pc.getScreenPoint(p2);
                                            Utils.drawLine(g, p1, p2);
                                        }
                                        ++t;
                                    }
                                } else {
                                    double w;
                                    Point2D.Double orginalPoint = new Point2D.Double(polarAxis.getLeftX(), polarAxis.getBottomY());
                                    double x = ((Point2D)orginalPoint).getX() - polarLen;
                                    double y = ((Point2D)orginalPoint).getY() - polarLen;
                                    double h = w = polarLen * 2.0;
                                    Arc2D.Double axisArc = new Arc2D.Double(x, y, w, h, this.startAngle, this.endAngle - this.startAngle, 0);
                                    g.draw(axisArc);
                                }
                            }
                            ++i;
                        }
                        break block0;
                    }
                }
                break block32;
            }
            if (this.useGradient) {
                if (this.location == 1) {
                    int i = 0;
                    while (i < coorList.size()) {
                        int coorShift;
                        CartesianCoor cc;
                        ICoor coor = coorList.get(i);
                        if (coor instanceof CartesianCoor && (cc = (CartesianCoor)coor).getXAxis() == this && (coorShift = cc.get3DShift()) != 0) {
                            double h;
                            TickAxis yAxis = cc.getYAxis();
                            double x = (int)this.getLeftX();
                            double y = (int)yAxis.getBottomY();
                            double x2 = this.getRightX();
                            double w = (double)((int)x2) - x;
                            this.coorThick = h = Utils.getPlatformH(coorShift);
                            ChartColor fillColor = new ChartColor(this.axisColor);
                            Utils.draw3DRect(g, x, y, w, h, null, 0, 0.0f, false, false, 1.0f, fillColor, true, coorShift);
                        }
                        ++i;
                    }
                } else if (this.location == 2) {
                    int i = 0;
                    while (i < coorList.size()) {
                        int coorShift;
                        CartesianCoor cc;
                        ICoor coor = coorList.get(i);
                        if (coor instanceof CartesianCoor && (cc = (CartesianCoor)coor).getYAxis() == this && (coorShift = cc.get3DShift()) != 0) {
                            TickAxis xAxis = cc.getXAxis();
                            double x1 = xAxis.getLeftX();
                            double x2 = xAxis.getRightX();
                            double thisX = this.getLeftX();
                            double d1 = Math.abs(x1 - thisX);
                            double d2 = Math.abs(x2 - thisX);
                            double w = Utils.getPlatformH(coorShift);
                            double x = (int)((d1 < d2 ? x1 : x2) - w);
                            double y = (int)this.getTopY();
                            double h = (double)((int)this.getBottomY()) - y;
                            this.coorThick = w;
                            ChartColor fillColor = new ChartColor(this.axisColor);
                            Utils.draw3DRect(g, x, y, w, h, null, 0, 0.0f, false, false, 1.0f, fillColor, false, coorShift);
                        }
                        ++i;
                    }
                }
            }
        }
    }

    abstract double getValueLength(Object var1, boolean var2);

    public abstract double animateDoubleValue(Object var1);

    public double getValueRadius(double val) {
        return this.getValueLength(new Double(val), true);
    }

    public double getValueLen(Object val) {
        return this.getValueLength(val, false);
    }

    protected double getTickPosition(Object tickVal) {
        double len = this.getValueLength(tickVal, false);
        double pos = 0.0;
        switch (this.location) {
            case 1: 
            case 3: {
                pos = this.getLeftX() + len;
                break;
            }
            case 2: {
                pos = this.getBottomY() - len;
                break;
            }
            case 4: {
                pos = this.startAngle + len;
            }
        }
        return pos;
    }

    private void drawRegionStep(int step) {
        if (!this.allowRegions) {
            return;
        }
        boolean doubleEdge = true;
        ArrayList<ICoor> coorList = this.e.getCoorList();
        Graphics2D g = this.e.getGraphics();
        switch (this.location) {
            case 1: {
                int i = 0;
                while (i < coorList.size()) {
                    CartesianCoor cc;
                    ICoor coor = coorList.get(i);
                    if (!coor.isPolarCoor() && (cc = (CartesianCoor)coor).getXAxis() == this) {
                        int coorShift = cc.get3DShift();
                        TickAxis yAxis = cc.getYAxis();
                        Point2D.Double p1 = new Point2D.Double(this.getLeftX() + (double)coorShift, yAxis.getTopY() - (double)coorShift);
                        int tCount = this.t_coorValue.length();
                        int rc = 0;
                        int t = 1;
                        while (t <= tCount) {
                            if ((t - 1) % this.displayStep == 0) {
                                Object tickVal = this.t_coorValue.get(t);
                                double tickPosition = this.getTickPosition(tickVal);
                                if (t != 1 || tickPosition != this.getLeftX()) {
                                    if (Utils.setStroke(g, this.axisColor, this.scaleStyle, this.scaleWeight)) {
                                        Utils.drawLine(g, tickPosition, yAxis.getBottomY(), tickPosition + (double)coorShift, yAxis.getBottomY() - (double)coorShift);
                                    }
                                    Point2D.Double p2 = new Point2D.Double(tickPosition + (double)coorShift, yAxis.getTopY() - (double)coorShift);
                                    Rectangle2D.Double regionShape = new Rectangle2D.Double(((Point2D)p1).getX(), ((Point2D)p1).getY(), ((Point2D)p2).getX() - ((Point2D)p1).getX(), yAxis.getAxisLength());
                                    ChartColor tmpcc = this.regionColors.chartColorValue(++rc);
                                    this.drawRegion(regionShape, tmpcc, step, doubleEdge);
                                    doubleEdge = false;
                                    p1 = p2;
                                    if (t == tCount && tickPosition < this.getRightX()) {
                                        p2 = new Point2D.Double(this.getRightX() + (double)coorShift, 0.0);
                                        regionShape = new Rectangle2D.Double(((Point2D)p1).getX(), ((Point2D)p1).getY(), ((Point2D)p2).getX() - ((Point2D)p1).getX(), yAxis.getAxisLength());
                                        tmpcc = this.regionColors.chartColorValue(++rc);
                                        this.drawRegion(regionShape, tmpcc, step);
                                    }
                                }
                            }
                            ++t;
                        }
                    }
                    ++i;
                }
                break;
            }
            case 2: {
                int i = 0;
                while (i < coorList.size()) {
                    CartesianCoor cc;
                    ICoor coor = coorList.get(i);
                    if (!coor.isPolarCoor() && (cc = (CartesianCoor)coor).getYAxis() == this) {
                        int coorShift = cc.get3DShift();
                        TickAxis xAxis = cc.getXAxis();
                        Point2D.Double p1 = new Point2D.Double(xAxis.getLeftX() + (double)coorShift, this.getBottomY() - (double)coorShift);
                        int tCount = this.t_coorValue.length();
                        int rc = 0;
                        int t = 1;
                        while (t <= tCount) {
                            if ((t - 1) % this.displayStep == 0) {
                                Object tickVal = this.t_coorValue.get(t);
                                double tickPosition = this.getTickPosition(tickVal);
                                if (t != 1 || tickPosition != this.getBottomY()) {
                                    if (t != 1 && t != tCount && Utils.setStroke(g, this.axisColor, this.scaleStyle, this.scaleWeight)) {
                                        double d2;
                                        double x1 = xAxis.getLeftX();
                                        double x2 = xAxis.getRightX();
                                        double thisX = this.getLeftX();
                                        double d1 = Math.abs(x1 - thisX);
                                        double x = d1 < (d2 = Math.abs(x2 - thisX)) ? x1 : x2;
                                        Utils.drawLine(g, x, tickPosition, x + (double)coorShift, tickPosition - (double)coorShift);
                                    }
                                    Point2D.Double p2 = new Point2D.Double(((Point2D)p1).getX(), tickPosition - (double)coorShift);
                                    Rectangle2D.Double regionShape = new Rectangle2D.Double(((Point2D)p2).getX(), ((Point2D)p2).getY(), xAxis.getAxisLength(), ((Point2D)p1).getY() - ((Point2D)p2).getY());
                                    ChartColor tmpcc = this.regionColors.chartColorValue(++rc);
                                    this.drawRegion(regionShape, tmpcc, step, doubleEdge);
                                    doubleEdge = false;
                                    p1 = p2;
                                    if (t == tCount && tickPosition != this.getTopY()) {
                                        p2 = new Point2D.Double(((Point2D)p1).getX(), this.getTopY() - (double)coorShift);
                                        regionShape = new Rectangle2D.Double(((Point2D)p2).getX(), ((Point2D)p2).getY(), xAxis.getAxisLength(), ((Point2D)p1).getY() - ((Point2D)p2).getY());
                                        tmpcc = this.regionColors.chartColorValue(++rc);
                                        this.drawRegion(regionShape, tmpcc, step);
                                    }
                                }
                            }
                            ++t;
                        }
                    }
                    ++i;
                }
                break;
            }
            case 3: {
                int i = 0;
                while (i < coorList.size()) {
                    PolarCoor pc;
                    ICoor coor = coorList.get(i);
                    if (!coor.isCartesianCoor() && (pc = (PolarCoor)coor).getPolarAxis() == this) {
                        TickAxis angleAxis = pc.getAngleAxis();
                        Point2D.Double orginalPoint = new Point2D.Double(this.getLeftX(), this.getBottomY());
                        Area area1 = null;
                        int tCount = this.t_coorValue.length();
                        int rc = 0;
                        int t = 1;
                        while (t <= tCount) {
                            if ((t - 1) % this.displayStep == 0) {
                                Object tickVal = this.t_coorValue.get(t);
                                double tickPosition = this.getTickPosition(tickVal);
                                if (t != 1 || tickPosition != this.getLeftX()) {
                                    ChartColor tmpcc;
                                    Area regionShape;
                                    Area area2;
                                    if (this.isPolygonalRegion) {
                                        Point2D.Double polarPoint;
                                        double angle;
                                        Polygon polygon = new Polygon();
                                        double polarLen = this.getTickPosition(tickVal) - this.getLeftX();
                                        int n = 1;
                                        while (n <= angleAxis.t_coorValue.length()) {
                                            Object angleTick = angleAxis.t_coorValue.get(n);
                                            angle = angleAxis.getTickPosition(angleTick);
                                            polarPoint = new Point2D.Double(polarLen, angle);
                                            Point2D p = pc.getScreenPoint(polarPoint);
                                            polygon.addPoint((int)p.getX(), (int)p.getY());
                                            ++n;
                                        }
                                        if (!angleAxis.isCircleAngle()) {
                                            polygon.addPoint((int)((Point2D)orginalPoint).getX(), (int)((Point2D)orginalPoint).getY());
                                        }
                                        area2 = new Area(polygon);
                                        regionShape = new Area(area2);
                                        if (area1 != null) {
                                            regionShape.subtract(area1);
                                        }
                                        tmpcc = this.regionColors.chartColorValue(++rc);
                                        this.drawRegion(regionShape, tmpcc, step);
                                        area1 = area2;
                                        if (t == tCount && tickPosition != this.getRightX()) {
                                            polarLen = this.getAxisLength();
                                            polygon = new Polygon();
                                            n = 1;
                                            while (n <= angleAxis.t_coorValue.length()) {
                                                Object angleTick = angleAxis.t_coorValue.get(n);
                                                angle = angleAxis.getTickPosition(angleTick);
                                                polarPoint = new Point2D.Double(polarLen, angle);
                                                Point2D p = pc.getScreenPoint(polarPoint);
                                                polygon.addPoint((int)p.getX(), (int)p.getY());
                                                ++n;
                                            }
                                            if (!angleAxis.isCircleAngle()) {
                                                polygon.addPoint((int)((Point2D)orginalPoint).getX(), (int)((Point2D)orginalPoint).getY());
                                            }
                                            regionShape = new Area(polygon);
                                            regionShape.subtract(area1);
                                            tmpcc = this.regionColors.chartColorValue(++rc);
                                            this.drawRegion(regionShape, tmpcc, step);
                                        }
                                    } else {
                                        double w;
                                        double tmpLen = tickPosition - ((Point2D)orginalPoint).getX();
                                        double x = ((Point2D)orginalPoint).getX() - tmpLen;
                                        double y = ((Point2D)orginalPoint).getY() - tmpLen;
                                        double h = w = tmpLen * 2.0;
                                        Arc2D.Double sector = new Arc2D.Double(x, y, w, h, angleAxis.startAngle, angleAxis.endAngle - angleAxis.startAngle, 2);
                                        area2 = new Area(sector);
                                        regionShape = new Area(area2);
                                        if (area1 != null) {
                                            regionShape.subtract(area1);
                                        }
                                        tmpcc = this.regionColors.chartColorValue(++rc);
                                        this.drawRegion(regionShape, tmpcc, step);
                                        area1 = area2;
                                        if (t == tCount && tickPosition != this.getRightX()) {
                                            tmpLen = this.getRightX() - ((Point2D)orginalPoint).getX();
                                            x = ((Point2D)orginalPoint).getX() - tmpLen;
                                            y = ((Point2D)orginalPoint).getY() - tmpLen;
                                            h = w = tmpLen * 2.0;
                                            sector = new Arc2D.Double(x, y, w, h, angleAxis.startAngle, angleAxis.endAngle - angleAxis.startAngle, 2);
                                            regionShape = new Area(sector);
                                            if (area1 != null) {
                                                regionShape.subtract(area1);
                                            }
                                            tmpcc = this.regionColors.chartColorValue(++rc);
                                            this.drawRegion(regionShape, tmpcc, step);
                                        }
                                    }
                                }
                            }
                            ++t;
                        }
                    }
                    ++i;
                }
                break;
            }
            case 4: {
                int i = 0;
                while (i < coorList.size()) {
                    PolarCoor pc;
                    ICoor coor = coorList.get(i);
                    if (!coor.isCartesianCoor() && (pc = (PolarCoor)coor).getAngleAxis() == this) {
                        double w;
                        TickAxis polarAxis = pc.getPolarAxis();
                        Point2D.Double orginalPoint = new Point2D.Double(polarAxis.getLeftX(), polarAxis.getBottomY());
                        double angle1 = 0.0;
                        double polarLen = polarAxis.getAxisLength();
                        int tCount = this.t_coorValue.length();
                        double x = ((Point2D)orginalPoint).getX() - polarLen;
                        double y = ((Point2D)orginalPoint).getY() - polarLen;
                        double h = w = polarLen * 2.0;
                        int rc = 0;
                        int t = 1;
                        while (t <= tCount) {
                            Object tickVal = this.t_coorValue.get(t);
                            double tickPosition = this.getTickPosition(tickVal);
                            if (t == 1) {
                                angle1 = tickPosition;
                            } else {
                                ChartColor tmpcc;
                                Shape regionShape;
                                double angle2 = tickPosition;
                                if (this.isPolygonalRegion) {
                                    Polygon polygon = new Polygon();
                                    this.addPolarPoint(polygon, pc, polarLen, angle1);
                                    this.addPolarPoint(polygon, pc, polarLen, angle2);
                                    polygon.addPoint((int)((Point2D)orginalPoint).getX(), (int)((Point2D)orginalPoint).getY());
                                    regionShape = polygon;
                                    tmpcc = this.regionColors.chartColorValue(++rc);
                                    this.drawRegion(regionShape, tmpcc, step);
                                    angle1 = angle2;
                                    if (this.isCircleAngle() && t == tCount) {
                                        polygon = new Polygon();
                                        this.addPolarPoint(polygon, pc, polarLen, angle1);
                                        this.addPolarPoint(polygon, pc, polarLen, 360.0);
                                        polygon.addPoint((int)((Point2D)orginalPoint).getX(), (int)((Point2D)orginalPoint).getY());
                                        regionShape = polygon;
                                        tmpcc = this.regionColors.chartColorValue(++rc);
                                        this.drawRegion(regionShape, tmpcc, step);
                                    }
                                } else {
                                    Arc2D.Double sector = new Arc2D.Double(x, y, w, h, angle1, angle2 - angle1, 2);
                                    regionShape = new Area(sector);
                                    tmpcc = this.regionColors.chartColorValue(++rc);
                                    this.drawRegion(regionShape, tmpcc, step);
                                    angle1 = angle2;
                                    if (this.isCircleAngle() && t == tCount) {
                                        sector = new Arc2D.Double(x, y, w, h, angle1, 360.0 - angle1, 2);
                                        regionShape = new Area(sector);
                                        tmpcc = this.regionColors.chartColorValue(++rc);
                                        this.drawRegion(regionShape, tmpcc, step);
                                    }
                                }
                            }
                            ++t;
                        }
                    }
                    ++i;
                }
                break;
            }
        }
        Utils.setTransparent(g, 1.0f);
    }

    @Override
    public void draw() {
        if (!this.isVisible()) {
            return;
        }
        this.drawAxisBorder();
        int tickSize = this.t_coorValue.length();
        if (tickSize == 0) {
            return;
        }
        ArrayList<ICoor> coorList = this.e.getCoorList();
        Color tickColor = this.axisColor;
        Graphics2D g = this.e.getGraphics();
        if (Utils.setStroke(g, tickColor, this.scaleStyle, this.scaleWeight)) {
            switch (this.location) {
                case 1: 
                case 3: {
                    double y = this.getBottomY() + this.coorThick;
                    int t = 1;
                    while (t <= tickSize) {
                        if ((t - 1) % this.displayStep == 0) {
                            double x = this.getTickPosition(this.t_coorValue.get(t));
                            if (this.scalePosition == 0) {
                                Utils.drawLine(g, x, y - (double)this.scaleLength, x, y);
                            } else if (this.scalePosition == 1) {
                                Utils.drawLine(g, x, y, x, y + (double)this.scaleLength);
                            } else if (this.scalePosition == 2) {
                                Utils.drawLine(g, x, y - (double)(this.scaleLength / 2), x, y + (double)(this.scaleLength / 2));
                            }
                        }
                        ++t;
                    }
                    break;
                }
                case 2: {
                    double x = this.getLeftX() - this.coorThick;
                    int t = 1;
                    while (t <= tickSize) {
                        if ((t - 1) % this.displayStep == 0) {
                            double y = this.getTickPosition(this.t_coorValue.get(t));
                            if (this.scalePosition == 0) {
                                Utils.drawLine(g, x, y, x + (double)this.scaleLength, y);
                            } else if (this.scalePosition == 1) {
                                Utils.drawLine(g, x - (double)this.scaleLength, y, x, y);
                            } else if (this.scalePosition == 2) {
                                Utils.drawLine(g, x - (double)(this.scaleLength / 2), y, x + (double)(this.scaleLength / 2), y);
                            }
                        }
                        ++t;
                    }
                    break;
                }
                case 4: {
                    int i = 0;
                    while (i < coorList.size()) {
                        PolarCoor pc;
                        ICoor coor = coorList.get(i);
                        if (coor instanceof PolarCoor && (pc = (PolarCoor)coor).getAngleAxis() == this) {
                            TickAxis polarAxis = pc.getPolarAxis();
                            double polarLen = polarAxis.getAxisLength();
                            int tCount = this.t_coorValue.length();
                            int t = 1;
                            while (t <= tCount) {
                                if ((t - 1) % this.displayStep == 0) {
                                    Object tickVal = this.t_coorValue.get(t);
                                    double angle = this.getTickPosition(tickVal);
                                    Point2D b = null;
                                    Point2D e = null;
                                    if (this.scalePosition == 0) {
                                        b = new Point2D.Double(polarLen, angle);
                                        e = new Point2D.Double(polarLen + (double)this.scaleLength, angle);
                                    } else if (this.scalePosition == 1) {
                                        b = new Point2D.Double(polarLen - (double)this.scaleLength, angle);
                                        e = new Point2D.Double(polarLen, angle);
                                    } else if (this.scalePosition == 2) {
                                        b = new Point2D.Double(polarLen - (double)(this.scaleLength / 2), angle);
                                        e = new Point2D.Double(polarLen + (double)(this.scaleLength / 2), angle);
                                    }
                                    if (b != null) {
                                        b = pc.getScreenPoint(b);
                                        e = pc.getScreenPoint(e);
                                        Utils.drawLine(g, b, e);
                                    }
                                }
                                ++t;
                            }
                        }
                        ++i;
                    }
                    break;
                }
            }
        }
    }

    protected int adjustLabelPosition(Point2D p) {
        double x = p.getX();
        double y = p.getY();
        int locationType = 34;
        switch (this.location) {
            case 1: 
            case 3: {
                if (this.scalePosition == 0) {
                    y -= (double)this.scaleLength;
                    y -= (double)this.labelIndent;
                    locationType = 34;
                    break;
                }
                if (this.scalePosition == 1) {
                    y += (double)this.scaleLength;
                    y += (double)this.labelIndent;
                    locationType = 10;
                    break;
                }
                y += (double)(this.scaleLength / 2);
                y += (double)this.labelIndent;
                locationType = 10;
                break;
            }
            case 2: {
                if (this.scalePosition == 0) {
                    x += (double)this.scaleLength;
                    x += (double)this.labelIndent;
                    locationType = 16;
                    break;
                }
                if (this.scalePosition == 1) {
                    x -= (double)this.scaleLength;
                    x -= (double)this.labelIndent;
                    locationType = 20;
                    break;
                }
                x -= (double)(this.scaleLength / 2);
                x -= (double)this.labelIndent;
                locationType = 20;
                break;
            }
            case 4: {
                locationType = Utils.getAngleTextLocation(y);
            }
        }
        p.setLocation(x, y);
        return locationType;
    }

    @Override
    public void drawFore() {
        int locationType;
        double y;
        double x;
        Font font;
        Color c;
        if (!this.isVisible()) {
            return;
        }
        int tickSize = this.t_coorValue.length();
        if (tickSize == 0) {
            return;
        }
        double length = this.getAxisLength();
        ArrayList<ICoor> coorList = this.e.getCoorList();
        if (this.allowLabels) {
            c = this.labelColor == null ? this.axisColor : this.labelColor;
            font = Utils.getFont(this.labelFont, this.labelStyle, this.labelSize);
            switch (this.location) {
                case 1: 
                case 3: {
                    int t = 1;
                    while (t <= tickSize) {
                        if ((t - 1) % this.labelStep == 0) {
                            x = this.getTickPosition(this.t_coorValue.get(t));
                            y = this.getBottomY() + this.coorThick;
                            Point2D.Double p = new Point2D.Double(x, y);
                            locationType = this.adjustLabelPosition(p);
                            String txt = this.getCoorText(this.t_coorValue.get(t));
                            Utils.drawText(this.e, txt, ((Point2D)p).getX(), ((Point2D)p).getY(), font, c, this.labelStyle, this.labelAngle, locationType, this.labelOverlapping);
                        }
                        ++t;
                    }
                    break;
                }
                case 2: {
                    int t = 1;
                    while (t <= tickSize) {
                        if ((t - 1) % this.labelStep == 0) {
                            x = this.getLeftX() - this.coorThick;
                            y = this.getTickPosition(this.t_coorValue.get(t));
                            Point2D.Double p = new Point2D.Double(x, y);
                            locationType = this.adjustLabelPosition(p);
                            String txt = this.getCoorText(this.t_coorValue.get(t));
                            Utils.drawText(this.e, txt, ((Point2D)p).getX(), ((Point2D)p).getY(), font, c, this.labelStyle, this.labelAngle, locationType, this.labelOverlapping);
                        }
                        ++t;
                    }
                    break;
                }
                case 4: {
                    int i = 0;
                    while (i < coorList.size()) {
                        PolarCoor pc;
                        ICoor coor = coorList.get(i);
                        if (!coor.isCartesianCoor() && (pc = (PolarCoor)coor).getAngleAxis() == this) {
                            TickAxis polarAxis = pc.getPolarAxis();
                            double polarLen = polarAxis.getAxisLength();
                            int tCount = this.t_coorValue.length();
                            int t = 1;
                            while (t <= tCount) {
                                if ((t - 1) % this.labelStep == 0) {
                                    Object tickVal = this.t_coorValue.get(t);
                                    double angle = this.getTickPosition(tickVal);
                                    Point2D p = new Point2D.Double(polarLen, angle);
                                    locationType = this.adjustLabelPosition(p);
                                    p = pc.getScreenPoint(p);
                                    String txt = this.getCoorText(tickVal);
                                    Utils.drawText(this.e, txt, p.getX(), p.getY(), font, c, this.labelStyle, this.labelAngle, locationType, this.labelOverlapping);
                                }
                                ++t;
                            }
                        }
                        ++i;
                    }
                    break;
                }
            }
        }
        if (!StringUtils.isValidString(this.title)) {
            return;
        }
        font = Utils.getFont(this.titleFont, this.titleStyle, this.titleSize);
        c = this.titleColor == null ? this.axisColor : this.titleColor;
        switch (this.location) {
            case 1: 
            case 3: {
                x = this.getLeftX() + length / 2.0;
                double tmp = (double)this.maxLabelHeight() + this.coorThick;
                y = this.getBottomY();
                if (this.scalePosition == 0) {
                    y -= (double)this.scaleLength;
                    y -= (double)(this.labelIndent * 2);
                    y -= tmp;
                    y -= (double)this.titleIndent;
                    locationType = 34;
                } else if (this.scalePosition == 1) {
                    y += (double)this.scaleLength;
                    y += (double)(this.labelIndent * 2);
                    y += tmp;
                    y += (double)this.titleIndent;
                    locationType = 10;
                } else {
                    y += (double)(this.scaleLength / 2);
                    y += (double)(this.labelIndent * 2);
                    y += tmp;
                    y += (double)this.titleIndent;
                    locationType = 10;
                }
                Utils.drawText(this.e, this.title, x, y, font, c, this.titleStyle, this.titleAngle, locationType, true);
                break;
            }
            case 2: {
                double tmp = this.maxLabelWidth();
                x = this.getLeftX();
                y = this.getTopY() + length / 2.0;
                if (this.scalePosition == 0) {
                    x += (double)this.scaleLength;
                    x += (double)(this.labelIndent * 2);
                    x += tmp;
                    x += (double)this.titleIndent;
                    locationType = 16;
                } else if (this.scalePosition == 1) {
                    x -= (double)this.scaleLength;
                    x -= (double)(this.labelIndent * 2);
                    x -= tmp;
                    x -= (double)this.titleIndent;
                    locationType = 20;
                } else {
                    x -= (double)(this.scaleLength / 2);
                    x -= (double)(this.labelIndent * 2);
                    x -= tmp;
                    x -= (double)this.titleIndent;
                    locationType = 20;
                }
                Utils.drawText(this.e, this.title, x, y, font, c, this.titleStyle, this.titleAngle, locationType, true);
                break;
            }
        }
    }

    String getCoorText(Object coorValue) {
        return coorValue.toString();
    }

    private int maxLabelSize(boolean getHeight) {
        if (!this.allowLabels) {
            return 0;
        }
        int size = this.t_coorValue.length();
        Graphics2D g = this.e.getGraphics();
        int max = 0;
        int i = 1;
        while (i <= size) {
            Object coory = this.t_coorValue.get(i);
            if (coory != null) {
                String txt = this.getCoorText(coory);
                Font font = Utils.getFont(this.labelFont, this.labelStyle, this.labelSize);
                Rectangle rect = Utils.getTextSize(txt, (Graphics)g, this.labelStyle, this.labelAngle, font);
                if (getHeight) {
                    if (rect.height > max) {
                        max = rect.height;
                    }
                } else if (rect.width > max) {
                    max = rect.width;
                }
            }
            ++i;
        }
        return max;
    }

    public int maxLabelHeight() {
        return this.maxLabelSize(true);
    }

    public int maxLabelWidth() {
        return this.maxLabelSize(false);
    }

    @Override
    public Point2D getBasePoint(ICoor coor) {
        TickAxis otherAxis = coor.getAxis1() == this ? coor.getAxis2() : coor.getAxis1();
        switch (this.location) {
            case 1: {
                return new Point2D.Double(this.getLeftX(), otherAxis.getBottomY());
            }
            case 3: {
                return new Point2D.Double(this.getLeftX(), this.getBottomY());
            }
            case 2: {
                return new Point2D.Double(otherAxis.getLeftX(), this.getBottomY());
            }
        }
        return null;
    }

    @Override
    public void setEngine(Engine e) {
        this.e = e;
    }

    @Override
    public Engine getEngine() {
        return this.e;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        String otherName = ((IAxis)obj).getName();
        return otherName.equals(this.name);
    }

    @Override
    public ArrayList<Shape> getShapes() {
        return null;
    }

    @Override
    public ArrayList<String> getLinks() {
        return null;
    }

    public abstract boolean isEnumAxis();

    public abstract boolean isDateAxis();

    public abstract boolean isNumericAxis();

    public abstract void checkDataMatch(Sequence var1);
}

