/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.chart.element;

import com.scudata.chart.DataElement;
import com.scudata.chart.Engine;
import com.scudata.chart.IAxis;
import com.scudata.chart.ICoor;
import com.scudata.chart.ObjectElement;
import com.scudata.chart.Para;
import com.scudata.chart.Utils;
import com.scudata.chart.edit.ParamInfo;
import com.scudata.chart.edit.ParamInfoList;
import com.scudata.chart.element.DateAxis;
import com.scudata.chart.element.Text;
import com.scudata.common.StringUtils;
import com.scudata.dm.Sequence;
import com.scudata.util.Variant;
import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;

public class TimeAxis
extends ObjectElement
implements IAxis {
    public String name;
    public boolean autoCalcValueRange = true;
    public boolean keepTrack = true;
    public Object beginTime = 0;
    public Object endTime = 10;
    public boolean displayMark = true;
    public String textFont = "Dialog";
    public int textStyle = new Integer(0);
    public int textSize = new Integer(14);
    public Color textColor = Color.RED;
    public Color backColor = null;
    public double markX = 0.1;
    public double markY = 0.9;
    public String format = null;
    private transient double t_maxDate = 0.0;
    private transient double t_minDate = 9.223372036854776E18;
    private transient boolean isDateType = false;
    protected transient Engine e;

    @Override
    public ParamInfoList getParamInfoList() {
        ParamInfoList paramInfos = new ParamInfoList();
        ParamInfo.setCurrent(TimeAxis.class, this);
        paramInfos.add(new ParamInfo("name"));
        String group = "axisTime";
        paramInfos.add(group, new ParamInfo("autoCalcValueRange", 10));
        paramInfos.add(group, new ParamInfo("keepTrack", 10));
        paramInfos.add(group, new ParamInfo("beginTime"));
        paramInfos.add(group, new ParamInfo("endTime"));
        group = "marker";
        paramInfos.add(group, new ParamInfo("displayMark", 10));
        paramInfos.add(group, new ParamInfo("textFont", 5));
        paramInfos.add(group, new ParamInfo("textStyle", 8));
        paramInfos.add(group, new ParamInfo("textSize", 20));
        paramInfos.add(group, new ParamInfo("textColor", 3));
        paramInfos.add(group, new ParamInfo("backColor", 3));
        paramInfos.add(group, new ParamInfo("format"));
        paramInfos.add(group, new ParamInfo("markX", 25));
        paramInfos.add(group, new ParamInfo("markY", 25));
        return paramInfos;
    }

    @Override
    public void prepare(ArrayList<DataElement> dataElements) {
        if (this.autoCalcValueRange) {
            int i = 0;
            while (i < dataElements.size()) {
                DataElement de = dataElements.get(i);
                Sequence data = de.getAxisData(this.name);
                this.t_minDate = DateAxis.min(this.t_minDate, data);
                this.t_maxDate = DateAxis.max(this.t_maxDate, data);
                ++i;
            }
        } else {
            double begin = DateAxis.getDoubleDate(this.beginTime);
            double end = DateAxis.getDoubleDate(this.endTime);
            this.t_maxDate = Math.max(begin, end);
            this.t_minDate = Math.min(begin, end);
        }
        for (DataElement de : dataElements) {
            Sequence posIndex = de.dataTime.psort(null);
            de.dataTime = de.dataTime.get(posIndex);
            Object tmp = de.dataTime.get(1);
            if (tmp instanceof Date) {
                this.isDateType = true;
            } else {
                Object obj = Variant.parseDate(tmp.toString());
                if (obj instanceof Date) {
                    this.isDateType = true;
                }
            }
            de.data1 = de.data1.get(posIndex);
            de.data2 = de.data2.get(posIndex);
        }
    }

    public double getMaxDate() {
        return this.t_maxDate;
    }

    public double getMinDate() {
        return this.t_minDate;
    }

    public boolean isKeepTrack() {
        return this.keepTrack;
    }

    @Override
    public boolean isVisible() {
        return false;
    }

    @Override
    public void beforeDraw() {
    }

    @Override
    public void drawBack() {
    }

    @Override
    public void draw() {
    }

    @Override
    public void drawFore() {
    }

    @Override
    public ArrayList<Shape> getShapes() {
        return null;
    }

    @Override
    public ArrayList<String> getLinks() {
        return null;
    }

    @Override
    public Point2D getBasePoint(ICoor coor) {
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getLocation() {
        return 0;
    }

    @Override
    public void setEngine(Engine e) {
        this.e = e;
    }

    @Override
    public Engine getEngine() {
        return this.e;
    }

    public Text getMarkElement(double timeLocation) {
        Comparable<Double> obj;
        if (this.isDateType) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis((long)timeLocation);
            obj = calendar.getTime();
            if (!StringUtils.isValidString(this.format)) {
                this.format = "yyyy/MM/dd";
            }
        } else {
            obj = timeLocation;
            if (!StringUtils.isValidString(this.format)) {
                this.format = "###";
            }
        }
        String mark = Utils.format(obj, this.format);
        Text txt = new Text();
        txt.setEngine(this.e);
        txt.text = new Para(mark);
        txt.textFont = new Para(this.textFont);
        txt.textSize = new Para(this.textSize);
        txt.textStyle = new Para(this.textStyle);
        txt.textColor = new Para(this.textColor);
        txt.backColor = new Para(this.backColor);
        txt.data1 = new Sequence(new Double[]{this.markX});
        txt.data2 = new Sequence(new Double[]{this.markY});
        return txt;
    }

    public double animateDoubleValue(Object val) {
        return DateAxis.getDoubleDate(val);
    }
}

