/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.common;

import com.scudata.common.ByteArrayInputRecord;
import com.scudata.common.ByteArrayOutputRecord;
import com.scudata.common.ICloneable;
import com.scudata.common.IRecord;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class Area
implements ICloneable,
Externalizable,
Cloneable,
Comparable<Area>,
IRecord {
    private static final long serialVersionUID = 1L;
    private static byte version = (byte)2;
    private int r1 = -1;
    private int r2 = -1;
    private int c1 = -1;
    private int c2 = -1;

    public Area() {
    }

    public Area(int r1, int r2) {
        this.r1 = r1;
        this.r2 = r2;
    }

    public Area(int r1, int c1, int r2, int c2) {
        this.r1 = r1;
        this.r2 = r2;
        this.c1 = c1;
        this.c2 = c2;
    }

    public int getBeginRow() {
        return this.r1;
    }

    public void setBeginRow(int r) {
        this.r1 = r;
    }

    public int getEndRow() {
        return this.r2;
    }

    public void setEndRow(int r) {
        this.r2 = r;
    }

    public int getBeginCol() {
        return this.c1;
    }

    public void setBeginCol(int c) {
        this.c1 = c;
    }

    public int getEndCol() {
        return this.c2;
    }

    public void setEndCol(int c) {
        this.c2 = c;
    }

    public void setArea(int br, int bc, int er, int ec) {
        this.r1 = br;
        this.r2 = er;
        this.c1 = bc;
        this.c2 = ec;
    }

    @Override
    public int compareTo(Area other) {
        int x = this.r1 - other.r1;
        if (x != 0) {
            return x;
        }
        x = this.c1 - other.c1;
        if (x != 0) {
            return x;
        }
        x = this.r2 - other.r2;
        if (x != 0) {
            return x;
        }
        return this.c2 - other.c2;
    }

    public boolean contains(int row, int col) {
        return this.r1 <= row && this.r2 >= row && this.c1 <= col && this.c2 >= col;
    }

    public boolean contains(Area a) {
        return this.contains(a.getBeginRow(), a.getBeginCol()) && this.contains(a.getEndRow(), a.getEndCol()) && this.contains(a.getBeginRow(), a.getEndCol()) && this.contains(a.getEndRow(), a.getBeginCol());
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(version);
        out.writeInt(this.r1);
        out.writeInt(this.r2);
        out.writeInt(this.c1);
        out.writeInt(this.c2);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        in.readByte();
        this.r1 = in.readInt();
        this.r2 = in.readInt();
        this.c1 = in.readInt();
        this.c2 = in.readInt();
    }

    @Override
    public byte[] serialize() throws IOException {
        ByteArrayOutputRecord out = new ByteArrayOutputRecord();
        out.writeInt(this.r1);
        out.writeInt(this.r2);
        out.writeInt(this.c1);
        out.writeInt(this.c2);
        return out.toByteArray();
    }

    @Override
    public void fillRecord(byte[] buf) throws IOException, ClassNotFoundException {
        ByteArrayInputRecord in = new ByteArrayInputRecord(buf);
        this.r1 = in.readInt();
        this.r2 = in.readInt();
        this.c1 = in.readInt();
        this.c2 = in.readInt();
    }

    @Override
    public Object deepClone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Error when clone Area");
        }
    }
}

