/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.common;

import com.scudata.common.ByteArrayInputRecord;
import com.scudata.common.ByteArrayOutputRecord;
import com.scudata.common.IByteMap;
import com.scudata.common.ICloneable;
import com.scudata.common.IRecord;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class ByteMap
implements IByteMap,
ICloneable,
Externalizable,
IRecord {
    private static final long serialVersionUID = 1L;
    private transient byte[] keys;
    private transient Object[] objs;
    private transient short count;

    public ByteMap(short initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException();
        }
        this.keys = new byte[initialCapacity];
        this.objs = new Object[initialCapacity];
    }

    public ByteMap() {
        this(11);
    }

    @Override
    public void ensureCapacity(int minCapacity) {
        if (minCapacity > this.keys.length) {
            byte[] oldKeys = this.keys;
            Object[] oldObjs = this.objs;
            this.keys = new byte[minCapacity];
            this.objs = new Object[minCapacity];
            System.arraycopy(oldKeys, 0, this.keys, 0, this.count);
            System.arraycopy(oldObjs, 0, this.objs, 0, this.count);
        }
    }

    @Override
    public short size() {
        return this.count;
    }

    @Override
    public boolean isEmpty() {
        return this.count == 0;
    }

    @Override
    public void trimToSize() {
        if (this.count < this.keys.length) {
            byte[] oldKeys = this.keys;
            Object[] oldObjs = this.objs;
            this.keys = new byte[this.count];
            this.objs = new Object[this.count];
            System.arraycopy(oldKeys, 0, this.keys, 0, this.count);
            System.arraycopy(oldObjs, 0, this.objs, 0, this.count);
        }
    }

    @Override
    public boolean contains(Object value) {
        Object[] objs = this.objs;
        if (value != null) {
            int i = 0;
            while (i < this.count) {
                if (value.equals(objs[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    @Override
    public boolean containsKey(byte key) {
        byte[] keys = this.keys;
        int i = 0;
        while (i < this.count) {
            if (keys[i] == key) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public Object get(byte key) {
        byte[] keys = this.keys;
        int i = this.count - 1;
        while (i >= 0) {
            if (keys[i] == key) {
                return this.objs[i];
            }
            --i;
        }
        return null;
    }

    @Override
    public Object put(byte key, Object value) {
        byte[] keys = this.keys;
        Object[] objs = this.objs;
        int i = 0;
        while (i < this.count) {
            if (keys[i] == key) {
                Object o = objs[i];
                objs[i] = value;
                return o;
            }
            ++i;
        }
        if (this.count >= keys.length) {
            int len = (int)((double)this.count * 1.1) + 1;
            this.keys = new byte[len];
            this.objs = new Object[len];
            System.arraycopy(keys, 0, this.keys, 0, this.count);
            System.arraycopy(objs, 0, this.objs, 0, this.count);
        }
        this.keys[this.count] = key;
        this.objs[this.count] = value;
        this.count = (short)(this.count + 1);
        return null;
    }

    @Override
    public void putAll(IByteMap bm) {
        this.ensureCapacity(this.count + bm.size());
        int i = 0;
        while (i < bm.size()) {
            this.put(bm.getKey(i), bm.getValue(i));
            ++i;
        }
    }

    @Override
    public Object remove(byte key) {
        byte[] keys = this.keys;
        int i = 0;
        while (i < this.count) {
            if (keys[i] == key) {
                return this.removeEntry(i);
            }
            ++i;
        }
        return null;
    }

    @Override
    public void add(byte key, Object value) {
        byte[] keys = this.keys;
        Object[] objs = this.objs;
        if (this.count >= keys.length) {
            int len = (int)((double)this.count * 1.1) + 1;
            this.keys = new byte[len];
            this.objs = new Object[len];
            System.arraycopy(keys, 0, this.keys, 0, this.count);
            System.arraycopy(objs, 0, this.objs, 0, this.count);
        }
        this.keys[this.count] = key;
        this.objs[this.count] = value;
        this.count = (short)(this.count + 1);
    }

    @Override
    public void addAll(IByteMap bm) {
        this.ensureCapacity(this.count + bm.size());
        int i = 0;
        while (i < bm.size()) {
            this.add(bm.getKey(i), bm.getValue(i));
            ++i;
        }
    }

    @Override
    public Object removeEntry(int index) {
        byte[] keys = this.keys;
        Object[] objs = this.objs;
        Object o = objs[index];
        System.arraycopy(keys, index + 1, keys, index, this.count - index - 1);
        System.arraycopy(objs, index + 1, objs, index, this.count - index - 1);
        this.count = (short)(this.count - 1);
        objs[this.count] = null;
        return o;
    }

    @Override
    public byte getKey(int index) {
        return this.keys[index];
    }

    @Override
    public Object getValue(int index) {
        return this.objs[index];
    }

    @Override
    public int getIndex(byte key) {
        byte[] keys = this.keys;
        int i = this.count - 1;
        while (i >= 0) {
            if (keys[i] == key) {
                return i;
            }
            --i;
        }
        return -1;
    }

    @Override
    public void setValue(int index, Object value) {
        this.objs[index] = value;
    }

    @Override
    public void purgeDupKeys() {
        int x;
        short oldCount;
        byte[] keys = this.keys;
        Object[] objs = this.objs;
        short newCount = oldCount = this.count;
        int i = x = oldCount - 2;
        while (i >= 0) {
            int j = oldCount - 1;
            while (j > x) {
                if (keys[i] == keys[j]) {
                    newCount = (short)(newCount - 1);
                    break;
                }
                --j;
            }
            if (j == x) {
                keys[x] = keys[i];
                objs[x] = objs[i];
                --x;
            }
            --i;
        }
        x = oldCount - newCount;
        if (x != 0) {
            System.arraycopy(keys, x, keys, 0, newCount);
            System.arraycopy(objs, x, objs, 0, newCount);
        }
        this.count = newCount;
    }

    @Override
    public void purgeNullValues() {
        int x;
        short oldCount;
        byte[] keys = this.keys;
        Object[] objs = this.objs;
        short newCount = oldCount = this.count;
        int i = x = oldCount - 1;
        while (i >= 0) {
            if (objs[i] == null) {
                newCount = (short)(newCount - 1);
            } else {
                if (x != i) {
                    keys[x] = keys[i];
                    objs[x] = objs[i];
                }
                --x;
            }
            --i;
        }
        x = oldCount - newCount;
        if (x != 0) {
            System.arraycopy(keys, x, keys, 0, newCount);
            System.arraycopy(objs, x, objs, 0, newCount);
        }
        this.count = newCount;
    }

    @Override
    public void clear() {
        this.count = 0;
        int i = 0;
        while (i < this.objs.length) {
            this.objs[i] = null;
            ++i;
        }
    }

    @Override
    public Object deepClone() {
        short count = this.count;
        ByteMap t = new ByteMap(count);
        t.count = count;
        System.arraycopy(this.keys, 0, t.keys, 0, count);
        Object[] old1 = this.objs;
        Object[] new1 = t.objs;
        short i = 0;
        while (i < count) {
            Object o = old1[i];
            new1[i] = o instanceof ICloneable ? ((ICloneable)o).deepClone() : o;
            i = (short)(i + 1);
        }
        return t;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeShort(this.count);
        byte[] keys = this.keys;
        Object[] objs = this.objs;
        int i = 0;
        while (i < this.count) {
            out.writeByte(keys[i]);
            out.writeObject(objs[i]);
            ++i;
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.count = in.readShort();
        byte[] keys = new byte[this.count];
        Object[] objs = new Object[this.count];
        int i = 0;
        while (i < this.count) {
            keys[i] = in.readByte();
            objs[i] = in.readObject();
            ++i;
        }
        this.keys = keys;
        this.objs = objs;
    }

    @Override
    public byte[] serialize() throws IOException {
        ByteArrayOutputRecord out = new ByteArrayOutputRecord();
        out.writeShort(this.count);
        byte[] keys = this.keys;
        Object[] objs = this.objs;
        int i = 0;
        while (i < this.count) {
            out.writeByte(keys[i]);
            out.writeObject(objs[i], true);
            ++i;
        }
        return out.toByteArray();
    }

    @Override
    public void fillRecord(byte[] buf) throws IOException, ClassNotFoundException {
        ByteArrayInputRecord in = new ByteArrayInputRecord(buf);
        this.count = in.readShort();
        byte[] keys = new byte[this.count];
        Object[] objs = new Object[this.count];
        int i = 0;
        while (i < this.count) {
            keys[i] = in.readByte();
            objs[i] = in.readObject(true);
            ++i;
        }
        this.keys = keys;
        this.objs = objs;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append('{');
        byte[] keys = this.keys;
        Object[] objs = this.objs;
        int i = 0;
        while (i < this.count) {
            buf.append(keys[i]).append('=').append(objs[i]);
            if (i < this.count - 1) {
                buf.append(", ");
            }
            ++i;
        }
        buf.append('}');
        return buf.toString();
    }

    public byte[] getKeys() {
        return this.keys;
    }

    public static void main(String[] args) throws Exception {
        ByteMap ih = new ByteMap();
        ih.add((byte)1, "abc");
        ih.add((byte)2, null);
        ih.add((byte)3, "dfdf");
        ih.add((byte)1, null);
        ih.add((byte)2, "a bc");
        ih.add((byte)3, "ad");
        ih.purgeNullValues();
        System.out.println(ih);
    }
}

