/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.common;

import com.scudata.common.ByteArrayInputRecord;
import com.scudata.common.ByteArrayOutputRecord;
import com.scudata.common.IRecord;
import java.io.IOException;
import java.io.Serializable;

public class CellLocation
implements Serializable,
IRecord {
    private static final long serialVersionUID = 65537L;
    private static final int MAX_COLCHAR_COUNT = 6;
    private int row = -1;
    private int col = -1;

    public CellLocation() {
    }

    public CellLocation(String cellId) {
        CellLocation cl = CellLocation.parse(cellId);
        if (cl != null) {
            this.setRow(cl.getRow());
            this.setCol(cl.getCol());
        }
    }

    public CellLocation(CellLocation lct) {
        this.row = lct.row;
        this.col = lct.col;
    }

    public CellLocation(int r, int c) {
        this.row = r;
        this.col = c;
    }

    public int getRow() {
        return this.row;
    }

    public int getCol() {
        return this.col;
    }

    public void setRow(int row) {
        this.row = row;
    }

    public void setCol(int col) {
        this.col = col;
    }

    public void set(int row, int col) {
        this.row = row;
        this.col = col;
    }

    public int hashCode() {
        return (this.row << 8) + this.col;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o instanceof CellLocation && ((CellLocation)o).row == this.row && ((CellLocation)o).col == this.col;
    }

    /*
     * Unable to fully structure code
     */
    public static String toRow(int row) {
        block2: {
            ret = new char[12];
            j = 12;
            if (row < 0) {
                return null;
            }
            if (row != 0) ** GOTO lbl10
            ret[--j] = 48;
            break block2;
lbl-1000:
            // 1 sources

            {
                ret[--j] = (char)(48 + row % 10);
                row /= 10;
lbl10:
                // 2 sources

                ** while (row > 0)
            }
        }
        return new String(ret, j, 12 - j);
    }

    /*
     * Unable to fully structure code
     */
    public static String toCol(int col) {
        block2: {
            ret = new char[6];
            i = 6;
            if (col < 0) {
                return null;
            }
            if (col != 0) ** GOTO lbl10
            ret[--i] = 96;
            break block2;
lbl-1000:
            // 1 sources

            {
                ret[--i] = (char)(65 + (col - 1) % 26);
                col = (col - 1) / 26;
lbl10:
                // 2 sources

                ** while (col > 0)
            }
        }
        return new String(ret, i, 6 - i);
    }

    public static int parseCol(String id) {
        if (id == null) {
            return -1;
        }
        int len = id.length();
        if (len == 0) {
            return -1;
        }
        int col = 0;
        int i = 0;
        while (i < len) {
            char c = id.charAt(i);
            if (c < 'A' || c > 'Z') {
                return -1;
            }
            col = col * 26 + (c - 65) + 1;
            ++i;
        }
        return col;
    }

    public static int parseRow(String id) {
        if (id == null) {
            return -1;
        }
        int len = id.length();
        if (len == 0) {
            return -1;
        }
        int row = 0;
        int i = 0;
        while (i < len) {
            char c = id.charAt(i);
            if (c < '0' || c > '9') {
                return -1;
            }
            row = row * 10 + (c - 48);
            ++i;
        }
        return row;
    }

    public static CellLocation parse(String id) {
        if (id == null) {
            return null;
        }
        int length = id.length();
        if (length < 2) {
            return null;
        }
        long rowSize = Integer.MAX_VALUE;
        int colSize = Short.MAX_VALUE;
        int i = 0;
        long row = 0L;
        int col = 0;
        int c = 0;
        boolean flag = false;
        i = 0;
        while (i < length) {
            c = id.charAt(i);
            if (c < 65 || c > 90) break;
            if ((col = col * 26 + (c - 65) + 1) > colSize) {
                return null;
            }
            flag = true;
            ++i;
        }
        if (c == 96 && i == 0) {
            flag = true;
            ++i;
        }
        if (!flag) {
            return null;
        }
        flag = false;
        while (i < length) {
            c = id.charAt(i);
            if (c < 48 || c > 57) {
                return null;
            }
            if ((row = row * 10L + (long)(c - 48)) > rowSize) {
                return null;
            }
            flag = true;
            ++i;
        }
        if (!flag) {
            return null;
        }
        return new CellLocation((int)row, col);
    }

    public String toString() {
        return CellLocation.getCellId(this.row, this.col);
    }

    /*
     * Unable to fully structure code
     */
    public static String getCellId(int row, int col) {
        block5: {
            block4: {
                ret = new char[16];
                i = 8;
                j = 16;
                if (col < 0) {
                    return null;
                }
                if (col != 0) ** GOTO lbl11
                ret[--i] = 96;
                break block4;
lbl-1000:
                // 1 sources

                {
                    ret[--i] = (char)(65 + (col - 1) % 26);
                    col = (col - 1) / 26;
lbl11:
                    // 2 sources

                    ** while (col > 0)
                }
            }
            if (row < 0) {
                return null;
            }
            if (row != 0) ** GOTO lbl20
            ret[--j] = 48;
            break block5;
lbl-1000:
            // 1 sources

            {
                ret[--j] = (char)(48 + row % 10);
                row /= 10;
lbl20:
                // 2 sources

                ** while (row > 0)
            }
        }
        System.arraycopy(ret, j, ret, 8, 16 - j);
        return new String(ret, i, 8 - i + 16 - j);
    }

    @Override
    public byte[] serialize() throws IOException {
        ByteArrayOutputRecord out = new ByteArrayOutputRecord();
        out.writeInt(this.row);
        out.writeInt(this.col);
        return out.toByteArray();
    }

    @Override
    public void fillRecord(byte[] buf) throws IOException {
        ByteArrayInputRecord in = new ByteArrayInputRecord(buf);
        this.row = in.readInt();
        this.col = in.readInt();
    }
}

