/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.common;

import com.scudata.common.DBInfo;
import com.scudata.common.DBSessionFactory;
import com.scudata.common.ISessionFactory;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Properties;

public class DBConfig
extends DBInfo
implements Cloneable,
Externalizable {
    private String driver;
    private String url;
    private String user;
    private String password;
    private String extend;
    private boolean useSchema;
    private boolean caseSentence;
    private boolean isAddTilde = false;
    private Properties info;
    private static final long serialVersionUID = 10001101L;

    public DBConfig() {
    }

    public DBConfig(int dbType) {
        super(dbType);
    }

    public DBConfig(DBConfig other) {
        super(other);
        this.driver = other.driver;
        this.url = other.url;
        this.user = other.user;
        this.password = other.password;
        this.extend = other.extend;
        this.useSchema = other.useSchema;
        this.caseSentence = other.caseSentence;
        this.isAddTilde = other.isAddTilde;
        if (other.info != null) {
            this.info = (Properties)other.info.clone();
        }
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public String getDriver() {
        return this.driver;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getUser() {
        return this.user;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public void setUseSchema(boolean useSchema) {
        this.useSchema = useSchema;
    }

    public void setInfo(Properties info) {
        this.info = info;
    }

    public Properties getInfo() {
        return this.info;
    }

    public void setCaseSentence(boolean bcase) {
        this.caseSentence = bcase;
    }

    public boolean isCaseSentence() {
        return this.caseSentence;
    }

    public boolean isUseSchema() {
        return this.useSchema;
    }

    public boolean isAddTilde() {
        return this.isAddTilde;
    }

    public void setAddTilde(boolean b) {
        this.isAddTilde = b;
    }

    public void setExtend(String extend) {
        this.extend = extend;
    }

    public String getExtend() {
        return this.extend;
    }

    @Override
    public ISessionFactory createSessionFactory() throws Exception {
        return new DBSessionFactory(this);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeByte(1);
        out.writeObject(this.driver);
        out.writeObject(this.url);
        out.writeObject(this.user);
        out.writeObject(this.password);
        out.writeObject(this.extend);
        out.writeBoolean(this.useSchema);
        out.writeBoolean(this.caseSentence);
        out.writeBoolean(this.isAddTilde);
        out.writeObject(this.info);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        in.readByte();
        this.driver = (String)in.readObject();
        this.url = (String)in.readObject();
        this.user = (String)in.readObject();
        this.password = (String)in.readObject();
        this.extend = (String)in.readObject();
        this.useSchema = in.readBoolean();
        this.caseSentence = in.readBoolean();
        this.isAddTilde = in.readBoolean();
        this.info = (Properties)in.readObject();
    }
}

