/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.common;

public class DBTypes {
    public static final int UNKNOWN = 0;
    public static final int ORACLE = 1;
    public static final int SQLSVR = 2;
    public static final int SYBASE = 3;
    public static final int SQLANY = 4;
    public static final int INFMIX = 5;
    public static final int FOXPRO = 6;
    public static final int ACCESS = 7;
    public static final int FOXBAS = 8;
    public static final int DB2 = 9;
    public static final int MYSQL = 10;
    public static final int KINGBASE = 11;
    public static final int DERBY = 12;
    public static final int HSQL = 13;
    public static final int TERADATA = 14;
    public static final int POSTGRES = 15;
    public static final int DATALOGIC = 16;
    public static final int IMPALA = 17;
    public static final int HIVE = 18;
    public static final int GREENPLUM = 19;
    public static final int DBONE = 20;
    public static final int ESPROC = 21;
    public static final int DAMENG = 22;
    public static final int ESPROC_SQL = 23;
    public static final int ESSBASE = 101;

    public static int[] listSupportedDBTypes() {
        return new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 101};
    }

    public static String[] listSupportedRDBNames() {
        return new String[]{"ORACLE", "SQLSVR", "SYBASE", "SQLANY", "INFMIX", "FOXPRO", "ACCESS", "FOXBAS", "DB2", "MYSQL", "KINGBASE", "DERBY", "HSQL", "TERADATA", "POSTGRES", "DATALOGIC", "IMPALA", "HIVE", "GREENPLUM", "DBONE", "ESPROC", "DAMENG", "ESPROC_SQL"};
    }

    public static String[] listSupportedMDBNames() {
        return new String[]{"ESSBASE"};
    }

    public static String[] listSupportedDBNames() {
        return new String[]{"ORACLE", "SQLSVR", "SYBASE", "SQLANY", "INFMIX", "FOXPRO", "ACCESS", "FOXBAS", "DB2", "MYSQL", "KINGBASE", "DERBY", "HSQL", "TERADATA", "POSTGRES", "DATALOGIC", "IMPALA", "HIVE", "GREENPLUM", "DBONE", "ESPROC", "DAMENG", "ESPROC_SQL", "ESSBASE"};
    }

    public static int getDBType(String dbTypeName) {
        if (dbTypeName == null) {
            return 0;
        }
        String[] dbNames = DBTypes.listSupportedDBNames();
        int[] dbTypes = DBTypes.listSupportedDBTypes();
        String dtn = dbTypeName.trim();
        int i = 0;
        while (i < dbNames.length) {
            if (dbNames[i].equalsIgnoreCase(dtn)) {
                return dbTypes[i];
            }
            ++i;
        }
        return 0;
    }

    public static String getDBTypeName(int dbType) {
        int[] dbTypes = DBTypes.listSupportedDBTypes();
        String[] dbNames = DBTypes.listSupportedDBNames();
        int i = 0;
        while (i < dbTypes.length) {
            if (dbType == dbTypes[i]) {
                return dbNames[i];
            }
            ++i;
        }
        return "UNKNOWN";
    }

    public static char getQuotation(int dbType) {
        return (char)(dbType == 5 || dbType == 6 || dbType == 7 || dbType == 8 ? 34 : 39);
    }

    public static String addQuotation(int dbType, String value) {
        if (value == null || value.length() == 0) {
            return "null";
        }
        char quote = '\'';
        if (dbType == 5 || dbType == 6 || dbType == 8) {
            quote = '\"';
        }
        int len = value.length();
        StringBuffer sb = new StringBuffer(len + 10);
        sb.append(quote);
        int i = 0;
        while (i < len) {
            char ch = value.charAt(i);
            if (ch == quote) {
                sb.append(ch);
            }
            sb.append(ch);
            ++i;
        }
        sb.append(quote);
        return sb.toString();
    }

    public static String getLeftTilde(int dbType) {
        if (dbType == 2 || dbType == 7) {
            return "[";
        }
        if (dbType == 10) {
            return "`";
        }
        if (dbType == 5) {
            return "'";
        }
        return "\"";
    }

    public static String getRightTilde(int dbType) {
        if (dbType == 2 || dbType == 7) {
            return "]";
        }
        if (dbType == 10) {
            return "`";
        }
        if (dbType == 5) {
            return "'";
        }
        return "\"";
    }
}

