/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.common;

import com.scudata.common.DBInfo;
import com.scudata.common.DBSession;
import com.scudata.common.ISessionFactory;
import com.scudata.dm.Env;
import javax.sql.DataSource;

public class DataSourceSessionFactory
implements ISessionFactory {
    private DataSource ds;
    private int dbType = 0;
    private DBInfo dbInfo;

    public DataSourceSessionFactory(DataSource ds, Integer type) {
        this.ds = ds;
        if (type != null) {
            this.dbType = type;
        }
        this.dbInfo = new DBInfo(this.dbType);
    }

    @Override
    public DBSession getSession() throws Exception {
        return new DBSession(this.ds.getConnection(), this.dbInfo);
    }

    public static ISessionFactory create(String name, DataSource dataSource, int type) {
        DataSourceSessionFactory sf = new DataSourceSessionFactory(dataSource, type);
        Env.setDBSessionFactory(name, sf);
        return sf;
    }
}

