/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.common;

import com.scudata.common.DateFormatFactory;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Calendar;
import java.util.Date;

public class DateFactory {
    public static final int[] DAYS = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    public static final int[] LEEPYEARDAYS = new int[]{31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final int WEEK_START_YEAR = 1900;
    private static final int WEEK_END_YEAR = 2100;
    private static final int[] WEEKS = new int[]{2, 3, 4, 5, 6, 1, 2, 3, 4, 6, 7, 1, 2, 4, 5, 6, 7, 2, 3, 4, 5, 7, 1, 2, 3, 5, 6, 7, 1, 3, 4, 5, 6, 1, 2, 3, 4, 6, 7, 1, 2, 4, 5, 6, 7, 2, 3, 4, 5, 7, 1, 2, 3, 5, 6, 7, 1, 3, 4, 5, 6, 1, 2, 3, 4, 6, 7, 1, 2, 4, 5, 6, 7, 2, 3, 4, 5, 7, 1, 2, 3, 5, 6, 7, 1, 3, 4, 5, 6, 1, 2, 3, 4, 6, 7, 1, 2, 4, 5, 6, 7, 2, 3, 4, 5, 7, 1, 2, 3, 5, 6, 7, 1, 3, 4, 5, 6, 1, 2, 3, 4, 6, 7, 1, 2, 4, 5, 6, 7, 2, 3, 4, 5, 7, 1, 2, 3, 5, 6, 7, 1, 3, 4, 5, 6, 1, 2, 3, 4, 6, 7, 1, 2, 4, 5, 6, 7, 2, 3, 4, 5, 7, 1, 2, 3, 5, 6, 7, 1, 3, 4, 5, 6, 1, 2, 3, 4, 6, 7, 1, 2, 4, 5, 6, 7, 2, 3, 4, 5, 7, 1, 2, 3, 5, 6, 7, 1, 3, 4, 5, 6};
    private static ThreadLocal<DateFactory> local = new ThreadLocal<DateFactory>(){

        @Override
        protected synchronized DateFactory initialValue() {
            return new DateFactory(null);
        }
    };
    private Calendar calendar = Calendar.getInstance();

    public static DateFactory get() {
        return local.get();
    }

    private DateFactory() {
    }

    public Calendar getCalendar() {
        this.calendar.clear();
        return this.calendar;
    }

    public Calendar calendar() {
        return this.calendar;
    }

    public Date toDate(Date date) {
        Calendar gc = this.getCalendar();
        gc.setTime(date);
        gc.set(11, 0);
        gc.set(12, 0);
        gc.set(13, 0);
        gc.set(14, 0);
        return new java.sql.Date(gc.getTimeInMillis());
    }

    public Date toDate(long date) {
        Calendar gc = this.getCalendar();
        if (date <= 99991231L && date >= 101L) {
            int n = (int)date;
            int d = n % 100;
            int m = n / 100 % 100;
            if (d <= 31 && m <= 12) {
                int y = n / 10000;
                if (y < 100) {
                    y += 2000;
                }
                gc.set(y, m - 1, d, 0, 0, 0);
                return new java.sql.Date(gc.getTimeInMillis());
            }
        }
        gc.setTimeInMillis(date);
        gc.set(11, 0);
        gc.set(12, 0);
        gc.set(13, 0);
        gc.set(14, 0);
        return new java.sql.Date(gc.getTimeInMillis());
    }

    public Date toTime(Date date) {
        Calendar gc = this.getCalendar();
        gc.setTime(date);
        gc.set(1, 1970);
        gc.set(2, 0);
        gc.set(5, 1);
        gc.set(14, 0);
        return new Time(gc.getTimeInMillis());
    }

    public Date weekBegin(Date date) {
        Calendar gc = this.getCalendar();
        gc.setFirstDayOfWeek(1);
        gc.setTime(date);
        gc.set(7, 1);
        gc.set(11, 0);
        gc.set(12, 0);
        gc.set(13, 0);
        gc.set(14, 0);
        return new java.sql.Date(gc.getTimeInMillis());
    }

    public Date weekBegin1(Date date) {
        Calendar gc = this.getCalendar();
        gc.setFirstDayOfWeek(2);
        gc.setTime(date);
        gc.set(7, 2);
        gc.set(11, 0);
        gc.set(12, 0);
        gc.set(13, 0);
        gc.set(14, 0);
        return new java.sql.Date(gc.getTimeInMillis());
    }

    public Date weekEnd(Date date) {
        Calendar gc = this.getCalendar();
        gc.setFirstDayOfWeek(1);
        gc.setTime(date);
        gc.set(7, 7);
        gc.set(11, 0);
        gc.set(12, 0);
        gc.set(13, 0);
        gc.set(14, 0);
        return new java.sql.Date(gc.getTimeInMillis());
    }

    public Date weekEnd1(Date date) {
        Calendar gc = this.getCalendar();
        gc.setFirstDayOfWeek(2);
        gc.setTime(date);
        gc.set(7, 1);
        gc.set(11, 0);
        gc.set(12, 0);
        gc.set(13, 0);
        gc.set(14, 0);
        return new java.sql.Date(gc.getTimeInMillis());
    }

    public Date monthBegin(Date date) {
        Calendar gc = this.getCalendar();
        gc.setTime(date);
        gc.set(5, 1);
        gc.set(11, 0);
        gc.set(12, 0);
        gc.set(13, 0);
        gc.set(14, 0);
        return new java.sql.Date(gc.getTimeInMillis());
    }

    public Date monthEnd(Date date) {
        Calendar gc = this.getCalendar();
        gc.setTime(date);
        gc.set(5, gc.getActualMaximum(5));
        gc.set(11, 0);
        gc.set(12, 0);
        gc.set(13, 0);
        gc.set(14, 0);
        return new java.sql.Date(gc.getTimeInMillis());
    }

    public Date quaterBegin(Date date) {
        Calendar gc = this.getCalendar();
        gc.setTime(date);
        int month = gc.get(2) / 3 * 3;
        gc.set(5, 1);
        gc.set(2, month);
        gc.set(11, 0);
        gc.set(12, 0);
        gc.set(13, 0);
        gc.set(14, 0);
        return new java.sql.Date(gc.getTimeInMillis());
    }

    public Date quaterEnd(Date date) {
        Calendar gc = this.getCalendar();
        gc.setTime(date);
        int month = gc.get(2) / 3 * 3 + 2;
        gc.set(5, 1);
        gc.set(2, month);
        gc.set(5, gc.getActualMaximum(5));
        gc.set(11, 0);
        gc.set(12, 0);
        gc.set(13, 0);
        gc.set(14, 0);
        return new java.sql.Date(gc.getTimeInMillis());
    }

    public Date yearBegin(Date date) {
        Calendar gc = this.getCalendar();
        gc.setTime(date);
        gc.set(2, 0);
        gc.set(5, 1);
        gc.set(11, 0);
        gc.set(12, 0);
        gc.set(13, 0);
        gc.set(14, 0);
        return new java.sql.Date(gc.getTimeInMillis());
    }

    public Date yearEnd(Date date) {
        Calendar gc = this.getCalendar();
        gc.setTime(date);
        gc.set(2, 11);
        gc.set(5, 31);
        gc.set(11, 0);
        gc.set(12, 0);
        gc.set(13, 0);
        gc.set(14, 0);
        return new java.sql.Date(gc.getTimeInMillis());
    }

    public Date lastMonth(Date date) {
        Calendar gc = this.getCalendar();
        gc.setTime(date);
        gc.add(2, -1);
        gc.set(11, 0);
        gc.set(12, 0);
        gc.set(13, 0);
        gc.set(14, 0);
        return new java.sql.Date(gc.getTimeInMillis());
    }

    public Date lastYear(Date date) {
        Calendar gc = this.getCalendar();
        gc.setTime(date);
        gc.add(1, -1);
        gc.set(11, 0);
        gc.set(12, 0);
        gc.set(13, 0);
        gc.set(14, 0);
        return new java.sql.Date(gc.getTimeInMillis());
    }

    public Date lastDay(Date date) {
        Calendar gc = this.getCalendar();
        gc.setTime(date);
        gc.add(5, -1);
        gc.set(11, 0);
        gc.set(12, 0);
        gc.set(13, 0);
        gc.set(14, 0);
        return new java.sql.Date(gc.getTimeInMillis());
    }

    public int year(Date date) {
        this.calendar.setTime(date);
        return this.calendar.get(1);
    }

    public int month(Date date) {
        this.calendar.setTime(date);
        return this.calendar.get(2) + 1;
    }

    public int day(Date date) {
        this.calendar.setTime(date);
        return this.calendar.get(5);
    }

    public int hour(Date date) {
        Calendar gc = this.getCalendar();
        gc.setTime(date);
        return gc.get(11);
    }

    public int minute(Date date) {
        Calendar gc = this.getCalendar();
        gc.setTime(date);
        return gc.get(12);
    }

    public int second(Date date) {
        Calendar gc = this.getCalendar();
        gc.setTime(date);
        return gc.get(13);
    }

    public int millisecond(Date date) {
        Calendar gc = this.getCalendar();
        gc.setTime(date);
        return gc.get(14);
    }

    public int week(Date date) {
        this.calendar.setTime(date);
        return this.calendar.get(7);
    }

    public int daysInMonth(Date date) {
        this.calendar.setTime(date);
        return this.calendar.getActualMaximum(5);
    }

    public int daysInYear(Date date) {
        this.calendar.setTime(date);
        return this.calendar.getActualMaximum(6);
    }

    public int daysInYear(int year) {
        Calendar gc = this.getCalendar();
        gc.set(6, 1);
        gc.set(1, year);
        return gc.getActualMaximum(6);
    }

    public static Date parseDate(String data, int beginIndex) throws ParseException {
        if (data == null) {
            return null;
        }
        return new java.sql.Date(DateFormatFactory.get().getDateFormat().parse(data, new ParsePosition(beginIndex)).getTime());
    }

    public static Date parseDate(String data) throws ParseException {
        if (data == null) {
            return null;
        }
        return new java.sql.Date(DateFormatFactory.get().getDateFormat().parse(data).getTime());
    }

    public static Date parseTime(String data, int beginIndex) throws ParseException {
        if (data == null) {
            return null;
        }
        return new Time(DateFormatFactory.get().getTimeFormat().parse(data, new ParsePosition(beginIndex)).getTime());
    }

    public static Date parseTime(String data) throws ParseException {
        if (data == null) {
            return null;
        }
        return new Time(DateFormatFactory.get().getTimeFormat().parse(data).getTime());
    }

    public static Date parseDateTime(String data, int beginIndex) throws ParseException {
        if (data == null) {
            return null;
        }
        return new Timestamp(DateFormatFactory.get().getDateTimeFormat().parse(data, new ParsePosition(beginIndex)).getTime());
    }

    public static Date parseDateTime(String data) throws ParseException {
        if (data == null) {
            return null;
        }
        return new Timestamp(DateFormatFactory.get().getDateTimeFormat().parse(data).getTime());
    }

    public static int toDays(Date date) {
        Calendar calendar = DateFactory.get().calendar;
        calendar.setTime(date);
        int y = calendar.get(1) - 1970;
        int ym = y * 12 + calendar.get(2);
        return ym * 32 + calendar.get(5);
    }

    public static int toDays(int y, int m, int d) {
        return ((y - 1970) * 12 + m) * 32 + d;
    }

    public static Date toDate(int days) {
        if (days < 0) {
            int y = days / 384 + 1969;
            int m = days / 32 % 12 + 11;
            int d = days % 32 + 32;
            Calendar calendar = DateFactory.get().calendar;
            calendar.set(y, m, d, 0, 0, 0);
            calendar.set(14, 0);
            return new java.sql.Date(calendar.getTimeInMillis());
        }
        int y = days / 384 + 1970;
        int m = days / 32 % 12;
        int d = days % 32;
        Calendar calendar = DateFactory.get().calendar;
        calendar.set(y, m, d, 0, 0, 0);
        calendar.set(14, 0);
        return new java.sql.Date(calendar.getTimeInMillis());
    }

    public static int toYear(int days) {
        if (days < 0) {
            return days / 384 + 1969;
        }
        return days / 384 + 1970;
    }

    public static int toMonth(int days) {
        if (days < 0) {
            return days / 32 % 12 + 12;
        }
        return days / 32 % 12 + 1;
    }

    public static int toYearMonth(int days) {
        if (days < 0) {
            int y = days / 384 + 1969;
            int m = days / 32 % 12 + 12;
            return y * 100 + m;
        }
        int ym = days / 32;
        int y = ym / 12 + 1970;
        return y * 100 + ym % 12 + 1;
    }

    public static int toDay(int days) {
        if (days < 0) {
            return days % 32 + 32;
        }
        return days % 32;
    }

    public int week(int days) {
        int d;
        int m;
        int y;
        if (days < 0) {
            y = days / 384 + 1969;
            m = days / 32 % 12 + 11;
            d = days % 32 + 32;
        } else {
            y = days / 384 + 1970;
            m = days / 32 % 12;
            d = days % 32;
        }
        if (y < 1900 || y > 2100) {
            this.calendar.set(y, m, d);
            return this.calendar.get(7);
        }
        if (m == 0) {
            int w = WEEKS[y - 1900] + (d - 1) % 7;
            if (w > 7) {
                return w - 7;
            }
            return w;
        }
        if (y % 400 == 0 || y % 4 == 0 && y % 100 != 0) {
            int w = WEEKS[y - 1900];
            days = 31;
            int i = 1;
            while (i < m) {
                days += LEEPYEARDAYS[i];
                ++i;
            }
            if ((w += (days + d - 1) % 7) > 7) {
                return w - 7;
            }
            return w;
        }
        int w = WEEKS[y - 1900];
        days = 31;
        int i = 1;
        while (i < m) {
            days += DAYS[i];
            ++i;
        }
        if ((w += (days + d - 1) % 7) > 7) {
            return w - 7;
        }
        return w;
    }

    private int weekBign(int y, int m, int d) {
        if (y < 1900 || y > 2100) {
            Calendar gc = this.getCalendar();
            gc.setFirstDayOfWeek(1);
            gc.set(y, m, d, 0, 0, 0);
            gc.set(14, 0);
            gc.getTimeInMillis();
            gc.set(7, 1);
            y = this.calendar.get(1);
            m = this.calendar.get(2);
            d = this.calendar.get(5);
        } else if (m == 0) {
            int w = WEEKS[y - 1900] + (d - 1) % 7;
            d = w > 7 ? (d -= w - 8) : (d -= w - 1);
            if (d < 1) {
                --y;
                m = 11;
                d += 31;
            }
        } else if (y % 400 == 0 || y % 4 == 0 && y % 100 != 0) {
            int w = WEEKS[y - 1900];
            int days = 31;
            int i = 1;
            while (i < m) {
                days += LEEPYEARDAYS[i];
                ++i;
            }
            d = (w += (days + d - 1) % 7) > 7 ? (d -= w - 8) : (d -= w - 1);
            if (d < 1) {
                d = LEEPYEARDAYS[--m] + d;
            }
        } else {
            int w = WEEKS[y - 1900];
            int days = 31;
            int i = 1;
            while (i < m) {
                days += DAYS[i];
                ++i;
            }
            d = (w += (days + d - 1) % 7) > 7 ? (d -= w - 8) : (d -= w - 1);
            if (d < 1) {
                d = DAYS[--m] + d;
            }
        }
        return DateFactory.toDays(y, m, d);
    }

    private int weekEnd(int y, int m, int d) {
        if (y < 1900 || y > 2100) {
            Calendar gc = this.getCalendar();
            gc.setFirstDayOfWeek(1);
            gc.set(y, m, d, 0, 0, 0);
            gc.set(14, 0);
            gc.getTimeInMillis();
            gc.set(7, 7);
            y = this.calendar.get(1);
            m = this.calendar.get(2);
            d = this.calendar.get(5);
        } else if (y % 400 == 0 || y % 4 == 0 && y % 100 != 0) {
            int w = WEEKS[y - 1900];
            int days = 0;
            int i = 0;
            while (i < m) {
                days += LEEPYEARDAYS[i];
                ++i;
            }
            d = (w += (days + d - 1) % 7) > 7 ? (d += 14 - w) : (d += 7 - w);
            if (d > LEEPYEARDAYS[m]) {
                d -= LEEPYEARDAYS[m];
                ++m;
            }
        } else {
            int w = WEEKS[y - 1900];
            int days = 0;
            int i = 0;
            while (i < m) {
                days += DAYS[i];
                ++i;
            }
            d = (w += (days + d - 1) % 7) > 7 ? (d += 14 - w) : (d += 7 - w);
            if (d > DAYS[m]) {
                d -= DAYS[m];
                ++m;
            }
        }
        return DateFactory.toDays(y, m, d);
    }

    private int weekBign1(int y, int m, int d) {
        if (y < 1900 || y > 2100) {
            Calendar gc = this.getCalendar();
            gc.setFirstDayOfWeek(2);
            gc.set(y, m, d, 0, 0, 0);
            gc.set(14, 0);
            gc.getTimeInMillis();
            gc.set(7, 2);
            y = this.calendar.get(1);
            m = this.calendar.get(2);
            d = this.calendar.get(5);
        } else if (m == 0) {
            int w = WEEKS[y - 1900] - 1;
            if (w == 0) {
                w = 7;
            }
            d = (w += (d - 1) % 7) > 7 ? (d -= w - 8) : (d -= w - 1);
            if (d < 1) {
                --y;
                m = 11;
                d += 31;
            }
        } else if (y % 400 == 0 || y % 4 == 0 && y % 100 != 0) {
            int w = WEEKS[y - 1900] - 1;
            if (w == 0) {
                w = 7;
            }
            int days = 31;
            int i = 1;
            while (i < m) {
                days += LEEPYEARDAYS[i];
                ++i;
            }
            d = (w += (days + d - 1) % 7) > 7 ? (d -= w - 8) : (d -= w - 1);
            if (d < 1) {
                d = LEEPYEARDAYS[--m] + d;
            }
        } else {
            int w = WEEKS[y - 1900] - 1;
            if (w == 0) {
                w = 7;
            }
            int days = 31;
            int i = 1;
            while (i < m) {
                days += DAYS[i];
                ++i;
            }
            d = (w += (days + d - 1) % 7) > 7 ? (d -= w - 8) : (d -= w - 1);
            if (d < 1) {
                d = DAYS[--m] + d;
            }
        }
        return DateFactory.toDays(y, m, d);
    }

    private int weekEnd1(int y, int m, int d) {
        if (y < 1900 || y > 2100) {
            Calendar gc = this.getCalendar();
            gc.setFirstDayOfWeek(2);
            gc.set(y, m, d, 0, 0, 0);
            gc.set(14, 0);
            gc.getTimeInMillis();
            gc.set(7, 1);
            y = this.calendar.get(1);
            m = this.calendar.get(2);
            d = this.calendar.get(5);
        } else if (y % 400 == 0 || y % 4 == 0 && y % 100 != 0) {
            int w = WEEKS[y - 1900] - 1;
            if (w == 0) {
                w = 7;
            }
            int days = 0;
            int i = 0;
            while (i < m) {
                days += LEEPYEARDAYS[i];
                ++i;
            }
            d = (w += (days + d - 1) % 7) > 7 ? (d += 14 - w) : (d += 7 - w);
            if (d > LEEPYEARDAYS[m]) {
                d -= LEEPYEARDAYS[m];
                ++m;
            }
        } else {
            int w = WEEKS[y - 1900] - 1;
            if (w == 0) {
                w = 7;
            }
            int days = 0;
            int i = 0;
            while (i < m) {
                days += DAYS[i];
                ++i;
            }
            d = (w += (days + d - 1) % 7) > 7 ? (d += 14 - w) : (d += 7 - w);
            if (d > DAYS[m]) {
                d -= DAYS[m];
                ++m;
            }
        }
        return DateFactory.toDays(y, m, d);
    }

    public int weekBegin(int days) {
        if (days < 0) {
            return this.weekBign(days / 384 + 1969, days / 32 % 12 + 11, days % 32 + 32);
        }
        return this.weekBign(days / 384 + 1970, days / 32 % 12, days % 32);
    }

    public int weekBegin1(int days) {
        if (days < 0) {
            return this.weekBign1(days / 384 + 1969, days / 32 % 12 + 11, days % 32 + 32);
        }
        return this.weekBign1(days / 384 + 1970, days / 32 % 12, days % 32);
    }

    public int weekEnd(int days) {
        if (days < 0) {
            return this.weekEnd(days / 384 + 1969, days / 32 % 12 + 11, days % 32 + 32);
        }
        return this.weekEnd(days / 384 + 1970, days / 32 % 12, days % 32);
    }

    public int weekEnd1(int days) {
        if (days < 0) {
            return this.weekEnd1(days / 384 + 1969, days / 32 % 12 + 11, days % 32 + 32);
        }
        return this.weekEnd1(days / 384 + 1970, days / 32 % 12, days % 32);
    }

    public int monthBegin(int days) {
        if (days < 0) {
            return DateFactory.toDays(days / 384 + 1969, days / 32 % 12 + 11, 1);
        }
        return DateFactory.toDays(days / 384 + 1970, days / 32 % 12, 1);
    }

    public int monthEnd(int days) {
        if (days < 0) {
            int y = days / 384 + 1969;
            int m = days / 32 % 12 + 11;
            if (y % 400 == 0 || y % 4 == 0 && y % 100 != 0) {
                return DateFactory.toDays(y, m, LEEPYEARDAYS[m]);
            }
            return DateFactory.toDays(y, m, DAYS[m]);
        }
        int y = days / 384 + 1970;
        int m = days / 32 % 12;
        if (y % 400 == 0 || y % 4 == 0 && y % 100 != 0) {
            return DateFactory.toDays(y, m, LEEPYEARDAYS[m]);
        }
        return DateFactory.toDays(y, m, DAYS[m]);
    }

    public int quaterBegin(int days) {
        if (days < 0) {
            int m = (days / 32 % 12 + 11) / 3 * 3;
            return DateFactory.toDays(days / 384 + 1969, m, 1);
        }
        int m = days / 32 % 12 / 3 * 3;
        return DateFactory.toDays(days / 384 + 1970, m, 1);
    }

    public int quaterEnd(int days) {
        if (days < 0) {
            int y = days / 384 + 1969;
            int m = (days / 32 % 12 + 11) / 3 * 3 + 2;
            if (y % 400 == 0 || y % 4 == 0 && y % 100 != 0) {
                return DateFactory.toDays(y, m, LEEPYEARDAYS[m]);
            }
            return DateFactory.toDays(y, m, DAYS[m]);
        }
        int y = days / 384 + 1970;
        int m = days / 32 % 12 / 3 * 3 + 2;
        if (y % 400 == 0 || y % 4 == 0 && y % 100 != 0) {
            return DateFactory.toDays(y, m, LEEPYEARDAYS[m]);
        }
        return DateFactory.toDays(y, m, DAYS[m]);
    }

    public int yearBegin(int days) {
        if (days < 0) {
            return DateFactory.toDays(days / 384 + 1969, 0, 1);
        }
        return DateFactory.toDays(days / 384 + 1970, 0, 1);
    }

    public int yearEnd(int days) {
        if (days < 0) {
            return DateFactory.toDays(days / 384 + 1969, 11, 31);
        }
        return DateFactory.toDays(days / 384 + 1970, 11, 31);
    }

    /* synthetic */ DateFactory(DateFactory dateFactory) {
        this();
    }
}

