/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.common;

import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class DateFormatX
extends SimpleDateFormat {
    static final long serialVersionUID = 1L;
    private static final int TAG_QUOTE_CHARS = 101;
    private static final String patternChars = "yMdHmsS";
    private static final int[] PATTERN_INDEX_TO_CALENDAR_FIELD = new int[]{1, 2, 5, 11, 12, 13, 14};
    private char[] compiledPattern;

    public DateFormatX() {
    }

    public DateFormatX(String pattern) {
        this(pattern, Locale.getDefault());
    }

    public DateFormatX(String pattern, Locale locale) {
        super(pattern, locale);
        this.compiledPattern = DateFormatX.compile(pattern);
    }

    public DateFormatX(String pattern, DateFormatSymbols formatSymbols) {
        super(pattern, formatSymbols);
        this.compiledPattern = DateFormatX.compile(pattern);
    }

    private static boolean encode(int tag, int length, StringBuilder buffer) {
        if (tag == 0 ? length != 4 : tag >= 1 && tag <= 6 && length != 2) {
            return false;
        }
        buffer.append((char)PATTERN_INDEX_TO_CALENDAR_FIELD[tag]);
        return true;
    }

    private static char[] compile(String pattern) {
        int length = pattern.length();
        StringBuilder compiledPattern = new StringBuilder(length * 2);
        int count = 0;
        int lastTag = -1;
        boolean hasQuote = false;
        int i = 0;
        while (i < length) {
            char c = pattern.charAt(i);
            if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z')) {
                if (count != 0) {
                    if (!DateFormatX.encode(lastTag, count, compiledPattern)) {
                        return null;
                    }
                    lastTag = -1;
                    count = 0;
                }
                compiledPattern.append('e');
                compiledPattern.append(c);
                hasQuote = true;
            } else {
                int tag = patternChars.indexOf(c);
                if (tag == -1) {
                    return null;
                }
                if (lastTag == -1 || lastTag == tag) {
                    lastTag = tag;
                    ++count;
                } else {
                    if (!DateFormatX.encode(lastTag, count, compiledPattern)) {
                        return null;
                    }
                    lastTag = tag;
                    count = 1;
                }
            }
            ++i;
        }
        if (!hasQuote) {
            return null;
        }
        if (count != 0 && !DateFormatX.encode(lastTag, count, compiledPattern)) {
            return null;
        }
        int len = compiledPattern.length();
        char[] r = new char[len];
        compiledPattern.getChars(0, len, r, 0);
        return r;
    }

    @Override
    public Date parse(String text) {
        char[] compiledPattern = this.compiledPattern;
        if (compiledPattern == null) {
            ParsePosition pos = new ParsePosition(0);
            Date date = this.parse(text, pos);
            if (date == null) {
                return null;
            }
            int textLength = text.length();
            int i = pos.getIndex();
            while (i < textLength) {
                if (!Character.isWhitespace(text.charAt(i))) {
                    return null;
                }
                ++i;
            }
            return date;
        }
        int start = 0;
        int textLength = text.length();
        this.calendar.clear();
        int i = 0;
        while (i < compiledPattern.length) {
            char tag;
            if ((tag = compiledPattern[i++]) == 'e') {
                if (start >= textLength || text.charAt(start) != compiledPattern[i++]) {
                    return null;
                }
                ++start;
                continue;
            }
            if ((start = this.subParse(text, start, tag)) >= 0) continue;
            ParsePosition pos = new ParsePosition(0);
            Date date = this.parse(text, pos);
            if (date == null) {
                return null;
            }
            i = pos.getIndex();
            while (i < textLength) {
                if (!Character.isWhitespace(text.charAt(i))) {
                    return null;
                }
                ++i;
            }
            return date;
        }
        while (start < textLength) {
            if (!Character.isWhitespace(text.charAt(start))) {
                return null;
            }
            ++start;
        }
        try {
            return this.calendar.getTime();
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private int subParse(String text, int start, int field) {
        int value = 0;
        int end = start;
        int len = text.length();
        while (end < len) {
            char c = text.charAt(end);
            if (c < '0' || c > '9') break;
            value = value * 10 + (c - 48);
            ++end;
        }
        if (end == start) {
            return -1;
        }
        if (field == 2) {
            this.calendar.set(field, value - 1);
        } else {
            this.calendar.set(field, value);
        }
        return end;
    }

    @Override
    public void applyPattern(String pattern) {
        super.applyPattern(pattern);
        this.compiledPattern = DateFormatX.compile(pattern);
    }

    @Override
    public void applyLocalizedPattern(String pattern) {
        super.applyLocalizedPattern(pattern);
        this.compiledPattern = DateFormatX.compile(pattern);
    }

    public static void test(int count) throws ParseException {
        DateFormatX df = new DateFormatX("yyyy-MM-dd");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String date = "2018-12-21";
        long time1 = System.currentTimeMillis();
        int i = 0;
        while (i < count) {
            df.parse(date);
            ++i;
        }
        long time2 = System.currentTimeMillis();
        int i2 = 0;
        while (i2 < count) {
            sdf.parse(date);
            ++i2;
        }
        long time3 = System.currentTimeMillis();
        System.out.println(time2 - time1);
        System.out.println(time3 - time2);
    }
}

