/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.common;

public final class Escape {
    public static String add(String str) {
        return Escape.add(str, '\\');
    }

    public static String add(String str, char escapeChar) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        char[] sb = new char[2 * len + 2];
        int j = 0;
        int i = 0;
        while (i < len) {
            char ch = str.charAt(i);
            switch (ch) {
                case '\t': {
                    sb[j++] = escapeChar;
                    sb[j++] = 116;
                    break;
                }
                case '\r': {
                    sb[j++] = escapeChar;
                    sb[j++] = 114;
                    break;
                }
                case '\n': {
                    sb[j++] = escapeChar;
                    sb[j++] = 110;
                    break;
                }
                case '\'': {
                    sb[j++] = escapeChar;
                    sb[j++] = 39;
                    break;
                }
                case '\"': {
                    sb[j++] = escapeChar;
                    sb[j++] = 34;
                    break;
                }
                default: {
                    if (ch == escapeChar) {
                        sb[j++] = escapeChar;
                    }
                    sb[j++] = ch;
                }
            }
            ++i;
        }
        return new String(sb, 0, j);
    }

    public static String add(String str, String escapedChars) {
        return Escape.add(str, escapedChars, '\\');
    }

    public static String add(String str, String escapedChars, char escapeChar) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        char[] sb = new char[2 * len + 2];
        int j = 0;
        int i = 0;
        while (i < len) {
            char ch = str.charAt(i);
            switch (ch) {
                case '\t': {
                    sb[j++] = escapeChar;
                    sb[j++] = 116;
                    break;
                }
                case '\r': {
                    sb[j++] = escapeChar;
                    sb[j++] = 114;
                    break;
                }
                case '\n': {
                    sb[j++] = escapeChar;
                    sb[j++] = 110;
                    break;
                }
                case '\'': {
                    sb[j++] = escapeChar;
                    sb[j++] = 39;
                    break;
                }
                case '\"': {
                    sb[j++] = escapeChar;
                    sb[j++] = 34;
                    break;
                }
                default: {
                    if (ch == escapeChar || escapedChars != null && escapedChars.indexOf(ch) >= 0) {
                        sb[j++] = escapeChar;
                    }
                    sb[j++] = ch;
                }
            }
            ++i;
        }
        return new String(sb, 0, j);
    }

    public static String addEscAndQuote(String str, String escapedChars, char escapeChar) {
        return Escape.addEscAndQuote(str, true, escapedChars, escapeChar);
    }

    public static String addEscAndQuote(String str, boolean ifDblQuote, String escapedChars, char escapeChar) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        char[] sb = new char[2 * len + 2];
        sb[0] = ifDblQuote ? 34 : 39;
        int j = 1;
        int i = 0;
        while (i < len) {
            char ch = str.charAt(i);
            switch (ch) {
                case '\t': {
                    sb[j++] = escapeChar;
                    sb[j++] = 116;
                    break;
                }
                case '\r': {
                    sb[j++] = escapeChar;
                    sb[j++] = 114;
                    break;
                }
                case '\n': {
                    sb[j++] = escapeChar;
                    sb[j++] = 110;
                    break;
                }
                case '\'': {
                    if (!ifDblQuote) {
                        sb[j++] = escapeChar;
                    }
                    sb[j++] = 39;
                    break;
                }
                case '\"': {
                    if (ifDblQuote) {
                        sb[j++] = escapeChar;
                    }
                    sb[j++] = 34;
                    break;
                }
                default: {
                    if (ch == escapeChar || escapedChars != null && escapedChars.indexOf(ch) >= 0) {
                        sb[j++] = escapeChar;
                    }
                    sb[j++] = ch;
                }
            }
            ++i;
        }
        sb[j++] = ifDblQuote ? 34 : 39;
        return new String(sb, 0, j);
    }

    public static String remove(String str) {
        return Escape.remove(str, '\\');
    }

    public static String remove(String str, char escapeChar) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        if (len == 0) {
            return str;
        }
        char[] sb = new char[len];
        int i = 0;
        int j = 0;
        char ch = str.charAt(i);
        while (i < len) {
            ch = str.charAt(i);
            if (ch == escapeChar) {
                if (++i == len) break;
                ch = str.charAt(i);
                switch (ch) {
                    case 't': {
                        sb[j++] = 9;
                        break;
                    }
                    case 'r': {
                        sb[j++] = 13;
                        break;
                    }
                    case 'n': {
                        sb[j++] = 10;
                        break;
                    }
                    default: {
                        sb[j++] = ch;
                        break;
                    }
                }
            } else {
                sb[j++] = ch;
            }
            ++i;
        }
        return new String(sb, 0, j);
    }

    public static String change(String str, char oldEscapeChar, char newEscapeChar) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        if (len == 0) {
            return str;
        }
        char[] sb = new char[len];
        int i = 0;
        while (i < len) {
            if (str.charAt(i) == oldEscapeChar) {
                sb[i++] = newEscapeChar;
                if (i < len) {
                    sb[i] = str.charAt(i);
                }
            } else {
                sb[i] = str.charAt(i);
            }
            ++i;
        }
        return new String(sb);
    }

    public static String addEscAndQuote(String str) {
        return Escape.addEscAndQuote(str, true, '\\');
    }

    public static String addEscAndQuote(String str, boolean ifDblQuote) {
        return Escape.addEscAndQuote(str, ifDblQuote, '\\');
    }

    public static String addEscAndQuote(String str, char escapeChar) {
        return Escape.addEscAndQuote(str, true, escapeChar);
    }

    public static String addEscAndQuote(String str, boolean ifDblQuote, char escapeChar) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        char[] sb = new char[2 * len + 2];
        sb[0] = ifDblQuote ? 34 : 39;
        int j = 1;
        int i = 0;
        while (i < len) {
            char ch = str.charAt(i);
            switch (ch) {
                case '\t': {
                    sb[j++] = escapeChar;
                    sb[j++] = 116;
                    break;
                }
                case '\r': {
                    sb[j++] = escapeChar;
                    sb[j++] = 114;
                    break;
                }
                case '\n': {
                    sb[j++] = escapeChar;
                    sb[j++] = 110;
                    break;
                }
                case '\'': {
                    if (!ifDblQuote) {
                        sb[j++] = escapeChar;
                    }
                    sb[j++] = 39;
                    break;
                }
                case '\"': {
                    if (ifDblQuote) {
                        sb[j++] = escapeChar;
                    }
                    sb[j++] = 34;
                    break;
                }
                default: {
                    if (ch == escapeChar) {
                        sb[j++] = escapeChar;
                    }
                    sb[j++] = ch;
                }
            }
            ++i;
        }
        sb[j++] = ifDblQuote ? 34 : 39;
        return new String(sb, 0, j);
    }

    public static String addExcelQuote(String str) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        char[] sb = new char[2 * len + 2];
        sb[0] = 34;
        int j = 1;
        int i = 0;
        while (i < len) {
            char ch = str.charAt(i);
            if (ch == '\"') {
                sb[j++] = 34;
                sb[j++] = 34;
            } else {
                sb[j++] = ch;
            }
            ++i;
        }
        sb[j++] = 34;
        return new String(sb, 0, j);
    }

    public static String removeEscAndQuote(String str) {
        return Escape.removeEscAndQuote(str, '\\');
    }

    public static String removeEscAndQuote(String str, char escapeChar) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        if (len == 0) {
            return str;
        }
        char[] sb = new char[len];
        int i = 0;
        int j = 0;
        char ch = str.charAt(i);
        if ((ch == '\"' || ch == '\'') && str.charAt(len - 1) == ch) {
            ++i;
            --len;
        }
        while (i < len) {
            ch = str.charAt(i);
            if (ch == escapeChar) {
                if (++i == len) break;
                ch = str.charAt(i);
                switch (ch) {
                    case 't': {
                        sb[j++] = 9;
                        break;
                    }
                    case 'r': {
                        sb[j++] = 13;
                        break;
                    }
                    case 'n': {
                        sb[j++] = 10;
                        break;
                    }
                    default: {
                        sb[j++] = ch;
                        break;
                    }
                }
            } else {
                sb[j++] = ch;
            }
            ++i;
        }
        return new String(sb, 0, j);
    }

    public static void main(String[] args) {
        String s = "a=\"(1+1)\";b=\"\uff08salary\uff09+1\"";
        s = Escape.add(s, "()[]{}");
        System.out.println(s);
        s = Escape.remove(s);
        System.out.println(s);
        s = "\"'abc'\"+5";
        System.out.println(Escape.addEscAndQuote(s));
    }
}

