/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.common;

import com.scudata.dm.FileObject;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class FileUtils {
    public static final String FORMAT_GIF = "gif";
    public static final String FORMAT_JPG = "jpg";
    public static final String FORMAT_PNG = "png";
    public static final String FORMAT_PDF = "pdf";
    public static final String FORMAT_XLS = "xls";
    public static final String FORMAT_XLSX = "xlsx";
    public static final String FORMAT_DOC = "doc";
    public static final String FORMAT_DOCX = "docx";
    public static final String FORMAT_XLS_DOC = "doc/xls";
    public static final String FORMAT_XLSX_DOCX = "docx/xlsx";
    public static final String FORMAT_TXT = "txt";
    private static final byte[] JPGID = new byte[]{-1, -40};
    private static final byte[] PNGID = new byte[]{-119, 80, 78, 71};
    private static final byte[] PDFID = new byte[]{37, 80, 68, 70, 45, 49, 46};
    private static final byte[] XLS_DOCID = new byte[]{-48, -49, 17, -32};
    private static final byte[] XLSX_DOCXID = new byte[]{80, 75, 3, 4};
    private static final byte[] DOCID512;
    private static final byte[] RTFID;

    static {
        byte[] byArray = new byte[4];
        byArray[0] = -20;
        byArray[1] = -91;
        byArray[2] = -63;
        DOCID512 = byArray;
        RTFID = new byte[]{123, 92, 114, 116, 102};
    }

    public static String getPicFormat(byte[] data) {
        if (data[0] == 71 && data[1] == 73 && data[2] == 70) {
            return FORMAT_GIF;
        }
        if (FileUtils.check(data, JPGID)) {
            return FORMAT_JPG;
        }
        if (data[1] == PNGID[1] && data[2] == PNGID[2] && data[3] == PNGID[3]) {
            return FORMAT_PNG;
        }
        return null;
    }

    private static boolean check(byte[] data, byte[] id) {
        int len = id.length;
        if (data.length < len) {
            return false;
        }
        int i = 0;
        while (i < len) {
            if (data[i] != id[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static String getDocxType(byte[] data) {
        block18: {
            ZipInputStream zis = new ZipInputStream(new ByteArrayInputStream(data));
            try {
                ZipEntry ze;
                do {
                    if ((ze = zis.getNextEntry()) == null) {
                        break block18;
                    }
                    if (!ze.getName().startsWith("word")) continue;
                    return FORMAT_DOCX;
                } while (!ze.getName().contains("xl"));
                return FORMAT_XLSX;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    zis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    private static String getDocType(byte[] fdata) {
        int bigBlockSize = 512;
        if (fdata[30] == 12) {
            bigBlockSize = 4096;
        }
        int propertyStart = FileUtils.getInt(fdata, 48);
        int propertyCount = bigBlockSize / 128;
        int offset = bigBlockSize * (propertyStart + 1);
        int i = 0;
        while (i < propertyCount) {
            if (fdata[offset + 66] == 2) {
                short nameSize = FileUtils.getShort(fdata, offset + 64);
                int nameLen = nameSize / 2 - 1;
                char[] buf = new char[nameLen];
                int k = 0;
                while (k < nameLen) {
                    buf[k] = (char)FileUtils.getShort(fdata, offset + k * 2);
                    ++k;
                }
                String name = new String(buf);
                if (name.equalsIgnoreCase("Workbook")) {
                    return FORMAT_XLS;
                }
                if (name.equalsIgnoreCase("WordDocument")) {
                    return FORMAT_DOC;
                }
                if (name.equalsIgnoreCase("PowerPoint Document")) {
                    return "ppt";
                }
            }
            offset += 128;
            ++i;
        }
        return null;
    }

    public static String getFileFormat(byte[] data) {
        if (data[0] == 71 && data[1] == 73 && data[2] == 70) {
            return FORMAT_GIF;
        }
        if (FileUtils.check(data, JPGID)) {
            return FORMAT_JPG;
        }
        if (data[1] == PNGID[1] && data[2] == PNGID[2] && data[3] == PNGID[3]) {
            return FORMAT_PNG;
        }
        if (FileUtils.check(data, RTFID)) {
            return FORMAT_DOC;
        }
        if (FileUtils.check(data, PDFID)) {
            return FORMAT_PDF;
        }
        if (FileUtils.check(data, XLS_DOCID)) {
            return FileUtils.getDocType(data);
        }
        if (FileUtils.check(data, XLSX_DOCXID)) {
            return FileUtils.getDocxType(data);
        }
        return FORMAT_TXT;
    }

    private static long getNumber(byte[] data, int offset, int size) {
        long result = 0L;
        int j = offset + size - 1;
        while (j >= offset) {
            result <<= 8;
            result |= (long)(0xFF & data[j]);
            --j;
        }
        return result;
    }

    private static int getInt(byte[] data, int offset) {
        return (int)FileUtils.getNumber(data, offset, 4);
    }

    private static short getShort(byte[] data, int offset) {
        return (short)FileUtils.getNumber(data, offset, 2);
    }

    public static void main(String[] arg) {
        String filepath = "D:/files/test.docx";
        try {
            FileObject fo = new FileObject(filepath);
            byte[] bytes = (byte[])fo.read(0L, -1L, "b");
            String type = FileUtils.getFileFormat(bytes);
            System.out.println(type);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

