/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.common;

import com.scudata.common.GifEncoder;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.PixelGrabber;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;

public class ImageUtils {
    public static boolean hasAlpha(Image image) {
        if (image instanceof BufferedImage) {
            BufferedImage bimage = (BufferedImage)image;
            return bimage.getColorModel().hasAlpha();
        }
        PixelGrabber pg = new PixelGrabber(image, 0, 0, 1, 1, false);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        ColorModel cm = pg.getColorModel();
        return cm.hasAlpha();
    }

    public static BufferedImage toBufferedImage(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        image = new ImageIcon(image).getImage();
        boolean hasAlpha = ImageUtils.hasAlpha(image);
        int type = 1;
        if (hasAlpha) {
            type = 2;
        }
        BufferedImage bimage = new BufferedImage(image.getWidth(null), image.getHeight(null), type);
        Graphics2D g = bimage.createGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return bimage;
    }

    public static Image cutImage(Image image, int cutW, int cutH) {
        image = new ImageIcon(image).getImage();
        boolean hasAlpha = ImageUtils.hasAlpha(image);
        int type = 1;
        if (hasAlpha) {
            type = 2;
        }
        BufferedImage bimage = new BufferedImage(cutW, cutH, type);
        Graphics2D g = bimage.createGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return bimage;
    }

    public static void drawFixedImage(Graphics g, Image srcImg, int x, int y, int fixW, int fixH) {
        ImageUtils.drawFixedImage(g, srcImg, (byte)0, x, y, fixW, fixH);
    }

    public static void drawFixedImage(Graphics g, Image srcImg, byte mode, int x, int y, int fixW, int fixH) {
        Shape oldClip = g.getClip();
        switch (mode) {
            case 1: {
                g.drawImage(srcImg, x, y, fixW, fixH, null);
                break;
            }
            case 0: {
                ImageUtils.drawFixImage(g, srcImg, x, y, x + fixW, y + fixH);
                break;
            }
            case 2: {
                int x1 = x;
                int y1 = y;
                int x2 = x + fixW;
                int y2 = y + fixH;
                int iw = srcImg.getWidth(null);
                int ih = srcImg.getHeight(null);
                while (x1 < x2) {
                    y1 = y;
                    while (y1 < y2) {
                        int clipx = Math.max(x, x1);
                        int clipy = Math.max(y, y1);
                        g.setClip(clipx, clipy, Math.min(iw, x2 - clipx), Math.min(ih, y2 - clipy));
                        g.drawImage(srcImg, x1, y1, iw, ih, null);
                        y1 += ih;
                    }
                    x1 += iw;
                }
                break;
            }
        }
        g.setClip(oldClip);
    }

    public static boolean drawFixImage(Graphics g, Image img, int x, int y, int sideRight, int sideBottom) {
        if (x > sideRight) {
            return false;
        }
        if (y > sideBottom) {
            return false;
        }
        boolean needCut = false;
        int width = img.getWidth(null);
        int height = img.getHeight(null);
        int reserveW = width;
        if (x + width > sideRight) {
            reserveW = sideRight - x;
            needCut = true;
        }
        int reserveH = height;
        if (y + height > sideBottom) {
            reserveH = sideBottom - y;
            needCut = true;
        }
        if (needCut) {
            img = ImageUtils.cutImage(img, reserveW, reserveH);
        }
        g.drawImage(img, x, y, reserveW, reserveH, null);
        return true;
    }

    public static BufferedImage toBufferedImage(RenderedImage image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        boolean hasAlpha = image.getColorModel().hasAlpha();
        int type = 1;
        if (hasAlpha) {
            type = 2;
        }
        BufferedImage bimage = new BufferedImage(image.getWidth(), image.getHeight(), type);
        Graphics2D g = bimage.createGraphics();
        g.drawRenderedImage(image, new AffineTransform());
        g.dispose();
        return bimage;
    }

    public static void writeGIF(RenderedImage img, OutputStream out) throws IOException {
        ImageIO.write(img, "gif", out);
    }

    public static void writeGIF(Image img, OutputStream out) throws IOException {
        GifEncoder enc = new GifEncoder(img, out);
        enc.encode();
    }

    public static byte[] writeGIF(Image img) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(2048);
        ImageUtils.writeGIF(img, (OutputStream)out);
        return out.toByteArray();
    }

    public static void writePNG(RenderedImage img, OutputStream out) throws IOException {
        ImageIO.write(img, "png", out);
    }

    public static byte[] writePNG(RenderedImage img) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(2048);
        ImageUtils.writePNG(img, out);
        return out.toByteArray();
    }

    public static void writeJPEG(RenderedImage img, OutputStream out) throws IOException {
        ImageIO.write(img, "jpeg", out);
    }

    public static byte[] writeJPEG(RenderedImage img) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(2048);
        ImageUtils.writeJPEG(img, out);
        return out.toByteArray();
    }

    public static void writeBMP(RenderedImage img, OutputStream out) throws IOException {
        ImageIO.write(img, "bmp", out);
    }

    public static byte[] writeBMP(RenderedImage img) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(2048);
        ImageUtils.writeBMP(img, out);
        return out.toByteArray();
    }

    public static void writeTIFF(RenderedImage img, OutputStream out) throws IOException {
        ImageIO.write(img, "tiff", out);
    }

    public static byte[] writeTIFF(RenderedImage img) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(2048);
        ImageUtils.writeTIFF(img, out);
        return out.toByteArray();
    }
}

