/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.common;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractList;

public class IntArrayList
extends AbstractList<Integer>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient int[] _data = null;
    private int _size = 0;

    public IntArrayList() {
        this(8);
    }

    public IntArrayList(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("capacity " + capacity);
        }
        this._data = new int[capacity];
    }

    public int capacity() {
        return this._data.length;
    }

    @Override
    public int size() {
        return this._size;
    }

    public void setSize(int size) {
        this._size = size;
    }

    public int[] toIntArray() {
        int[] tmp = new int[this._size];
        System.arraycopy(this._data, 0, tmp, 0, this._size);
        return tmp;
    }

    public int getInt(int index) {
        return this._data[index];
    }

    public boolean containsInt(int value) {
        return -1 != this.indexOfInt(value);
    }

    public int indexOfInt(int value) {
        int i = 0;
        while (i < this._size) {
            if (value == this._data[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int lastIndexOfInt(int value) {
        int i = this._size - 1;
        while (i >= 0) {
            if (value == this._data[i]) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public int setInt(int index, int value) {
        this.checkRange(index);
        int old = this._data[index];
        this._data[index] = value;
        return old;
    }

    public boolean addInt(int value) {
        this.ensureCapacity(this._size + 1);
        this._data[this._size++] = value;
        return true;
    }

    public boolean addAll(int[] vals) {
        if (vals == null) {
            return false;
        }
        int len = vals.length;
        this.ensureCapacity(this._size + len);
        int i = 0;
        while (i < len) {
            this._data[this._size++] = vals[i];
            ++i;
        }
        return true;
    }

    public void addInt(int index, int value) {
        this.checkRangeIncludingEndpoint(index);
        this.ensureCapacity(this._size + 1);
        int numtomove = this._size - index;
        System.arraycopy(this._data, index, this._data, index + 1, numtomove);
        this._data[index] = value;
        ++this._size;
    }

    @Override
    public void clear() {
        ++this.modCount;
        this._size = 0;
    }

    public int removeIntAt(int index) {
        this.checkRange(index);
        ++this.modCount;
        int oldval = this._data[index];
        int numtomove = this._size - index - 1;
        if (numtomove > 0) {
            System.arraycopy(this._data, index + 1, this._data, index, numtomove);
        }
        --this._size;
        return oldval;
    }

    public boolean removeInt(int value) {
        int index = this.indexOfInt(value);
        if (-1 == index) {
            return false;
        }
        this.removeIntAt(index);
        return true;
    }

    public void ensureCapacity(int mincap) {
        ++this.modCount;
        if (mincap > this._data.length) {
            int newcap = this._data.length * 3 / 2 + 1;
            int[] olddata = this._data;
            this._data = new int[newcap < mincap ? mincap : newcap];
            System.arraycopy(olddata, 0, this._data, 0, this._size);
        }
    }

    public void trimToSize() {
        ++this.modCount;
        if (this._size < this._data.length) {
            int[] olddata = this._data;
            this._data = new int[this._size];
            System.arraycopy(olddata, 0, this._data, 0, this._size);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(this._data.length);
        int i = 0;
        while (i < this._size) {
            out.writeInt(this._data[i]);
            ++i;
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this._data = new int[in.readInt()];
        int i = 0;
        while (i < this._size) {
            this._data[i] = in.readInt();
            ++i;
        }
    }

    private final void checkRange(int index) {
        if (index < 0 || index >= this._size) {
            throw new IndexOutOfBoundsException("Should be at least 0 and less than " + this._size + ", found " + index);
        }
    }

    private final void checkRangeIncludingEndpoint(int index) {
        if (index < 0 || index > this._size) {
            throw new IndexOutOfBoundsException("Should be at least 0 and at most " + this._size + ", found " + index);
        }
    }

    @Override
    public Integer get(int index) {
        return new Integer(this.getInt(index));
    }

    @Override
    public boolean contains(Object value) {
        return this.containsInt((Integer)value);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int binarySearch(int key) {
        int low = 0;
        int high = this._size - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int midVal = this._data[mid];
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public int binarySearch(int key, int low, int high) {
        while (low <= high) {
            int mid = low + high >>> 1;
            int midVal = this._data[mid];
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    @Override
    public int indexOf(Object value) {
        return this.indexOfInt((Integer)value);
    }

    @Override
    public int lastIndexOf(Object value) {
        return this.lastIndexOfInt((Integer)value);
    }

    @Override
    public Integer set(int index, Integer value) {
        return new Integer(this.setInt(index, value));
    }

    @Override
    public boolean add(Integer value) {
        return this.addInt(value);
    }

    @Override
    public void add(int index, Integer value) {
        this.addInt(index, value);
    }

    @Override
    public Integer remove(int index) {
        return new Integer(this.removeIntAt(index));
    }

    @Override
    public boolean remove(Object value) {
        return this.removeInt((Integer)value);
    }
}

