/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.common;

import com.scudata.app.common.AppUtil;
import com.scudata.common.ScudataLogger;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.Properties;

public class Logger {
    public static String OFF = ScudataLogger.OFF;
    public static String SEVERE = ScudataLogger.SEVERE;
    public static String WARNING = ScudataLogger.WARNING;
    public static String INFO = ScudataLogger.INFO;
    public static String DEBUG = ScudataLogger.DEBUG;
    public static int iDOLOG = ScudataLogger.iDOLOG;
    public static int iOFF = ScudataLogger.iOFF;
    public static int iSEVERE = ScudataLogger.iSEVERE;
    public static int iWARNING = ScudataLogger.iWARNING;
    public static int iINFO = ScudataLogger.iINFO;
    public static int iDEBUG = ScudataLogger.iDEBUG;
    private static String logType = "default";

    public static boolean isUseSLF4J() {
        if (logType.equals("default")) {
            return false;
        }
        try {
            Class<?> cls = Class.forName("org.slf4j.LoggerFactory");
            return true;
        }
        catch (Exception x) {
            return false;
        }
    }

    private static void slf4jLog(int level, String msg) {
        try {
            Class<?> factoryClazz = Class.forName("org.slf4j.LoggerFactory");
            Method getLogger = factoryClazz.getMethod("getLogger", String.class);
            Object logger = getLogger.invoke(null, "ScudataLogger");
            String method = "debug";
            if (level == iINFO) {
                method = "info";
            } else if (level == iWARNING) {
                method = "warn";
            } else if (level == iSEVERE) {
                method = "error";
            }
            AppUtil.invokeMethod(logger, method, new Object[]{msg});
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    public static String[] listLevelNames() {
        return ScudataLogger.listLevelNames();
    }

    public static int getLevel(String level) {
        return ScudataLogger.getLevel(level);
    }

    public static String getLevelName(int level) {
        return ScudataLogger.getLevelName(level);
    }

    private static String toString(Object obj, Throwable t) {
        StringBuffer sb = new StringBuffer();
        if (obj != null) {
            if (obj instanceof Throwable) {
                Throwable th = (Throwable)obj;
                sb.append(th.getMessage());
            } else {
                sb.append(obj);
            }
            sb.append(ScudataLogger.lineSeparator);
        }
        if (t != null) {
            try {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                t.printStackTrace(pw);
                pw.close();
                sb.append(sw.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return sb.toString();
    }

    public static void error(Object msg) {
        Logger.severe(msg);
    }

    public static void error(Object msg, Throwable t) {
        Logger.severe(msg, t);
    }

    public static void severe(Object msg) {
        if (msg instanceof Throwable) {
            Logger.severe(msg, (Throwable)msg);
        } else {
            Logger.severe(msg, null);
        }
    }

    public static void severe(Object msg, Throwable t) {
        if (Logger.isUseSLF4J()) {
            Logger.slf4jLog(iSEVERE, Logger.toString(msg, t));
        } else {
            ScudataLogger.severe(msg, t);
        }
    }

    public static void warn(Object msg) {
        Logger.warning(msg);
    }

    public static void warn(Object msg, Throwable t) {
        if (msg instanceof Throwable) {
            Logger.warning(msg, (Throwable)msg);
        } else {
            Logger.warning(msg, null);
        }
    }

    public static void warning(Object msg) {
        Logger.warning(msg, null);
    }

    public static void warning(Object msg, Throwable t) {
        if (Logger.isUseSLF4J()) {
            Logger.slf4jLog(iWARNING, Logger.toString(msg, t));
        } else {
            ScudataLogger.warning(msg, t);
        }
    }

    public static void info(Object msg, Throwable t) {
        if (Logger.isUseSLF4J()) {
            Logger.slf4jLog(iINFO, Logger.toString(msg, t));
        } else {
            ScudataLogger.info(msg, t);
        }
    }

    public static void info(Object msg) {
        if (msg instanceof Throwable) {
            Logger.info(msg, (Throwable)msg);
        } else {
            Logger.info(msg, null);
        }
    }

    public static void debug(Object msg, Throwable t) {
        if (Logger.isUseSLF4J()) {
            Logger.slf4jLog(iDEBUG, Logger.toString(msg, t));
        } else {
            ScudataLogger.debug(msg, t);
        }
    }

    public static void debug(Object msg) {
        if (msg instanceof Throwable) {
            Logger.debug(msg, (Throwable)msg);
        } else {
            Logger.debug(msg, null);
        }
    }

    public static void doLog(Object msg) {
        ScudataLogger.doLog(msg);
    }

    public static void doLog(Object msg, Throwable t) {
        ScudataLogger.doLog(msg, t);
    }

    public static boolean isDebugLevel() {
        return ScudataLogger.isDebugLevel();
    }

    public static boolean isAllLevel() {
        return Logger.isDebugLevel();
    }

    public static void setLevel(String level) {
        ScudataLogger.setLevel(level);
    }

    public static void setLogType(String type) {
        logType = type;
    }

    public static int getLevel() {
        return ScudataLogger.getLevel();
    }

    public static void setPropertyConfig(Properties p) throws Exception {
        ScudataLogger.setPropertyConfig(p);
    }
}

