/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.common;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class Matrix
implements Externalizable {
    private static final long serialVersionUID = -3689348814741910324L;
    private Object[] data;
    private int rowSize;
    private int colSize;

    public Matrix(Object[] rows) {
        this.data = rows;
        this.rowSize = rows.length;
        this.colSize = ((Object[])rows[0]).length;
    }

    public Matrix(int rowSize, int colSize) {
        if (rowSize <= 0 || colSize <= 0) {
            throw new RuntimeException();
        }
        this.rowSize = rowSize;
        this.colSize = colSize;
        Object[] tmp = new Object[rowSize];
        this.data = tmp;
        int i = rowSize - 1;
        while (i >= 0) {
            tmp[i] = new Object[colSize];
            --i;
        }
    }

    public Matrix() {
        this(20, 10);
    }

    public void setRowSize(int size) {
        if (size <= 0) {
            throw new RuntimeException();
        }
        Object[] data = this.data;
        int rows = this.rowSize;
        if (rows > size) {
            Object[] tmp = new Object[size];
            System.arraycopy(data, 0, tmp, 0, size);
            this.data = tmp;
        } else if (rows < size) {
            Object[] tmp = new Object[size];
            int cols = this.colSize;
            System.arraycopy(data, 0, tmp, 0, rows);
            int i = rows;
            while (i < size) {
                tmp[i] = new Object[cols];
                ++i;
            }
            this.data = tmp;
        }
        this.rowSize = size;
    }

    public void setColSize(int size) {
        if (size <= 0) {
            throw new RuntimeException();
        }
        Object[] data = this.data;
        int cols = this.colSize;
        if (cols != size) {
            int min = cols > size ? size : cols;
            int rows = this.rowSize;
            int i = rows - 1;
            while (i >= 0) {
                Object[] tmp = new Object[size];
                System.arraycopy(data[i], 0, tmp, 0, min);
                data[i] = tmp;
                --i;
            }
        }
        this.colSize = size;
    }

    public void setSize(int rowSize, int colSize) {
        this.setRowSize(rowSize);
        this.setColSize(colSize);
    }

    public int getRowSize() {
        return this.rowSize;
    }

    public int getColSize() {
        return this.colSize;
    }

    public void set(int row, int col, Object value) {
        Object[] tmp = (Object[])this.data[row];
        tmp[col] = value;
    }

    public Object get(int row, int col) {
        Object[] tmp = (Object[])this.data[row];
        return tmp[col];
    }

    public Object[] getRow(int row) {
        return (Object[])this.data[row];
    }

    public void setRow(int row, Object[] rowObjs) {
        this.data[row] = rowObjs;
    }

    public void insertRow(int index) {
        Object[] data = this.data;
        int rows = this.rowSize;
        int cols = this.colSize;
        Object[] tmp = new Object[rows + 1];
        System.arraycopy(data, 0, tmp, 0, index);
        int moved = rows - index;
        if (moved > 0) {
            System.arraycopy(data, index, tmp, index + 1, moved);
        }
        tmp[index] = new Object[cols];
        this.data = tmp;
        ++this.rowSize;
    }

    public void insertCol(int index) {
        Object[] data = this.data;
        int rows = this.rowSize;
        int cols = this.colSize;
        int moved = cols - index;
        int i = rows - 1;
        while (i >= 0) {
            Object[] tmp = new Object[cols + 1];
            System.arraycopy(data[i], 0, tmp, 0, index);
            if (moved > 0) {
                System.arraycopy(data[i], index, tmp, index + 1, moved);
            }
            data[i] = tmp;
            --i;
        }
        ++this.colSize;
    }

    public void addRow() {
        int rows = this.rowSize++;
        Object[] tmp = new Object[rows + 1];
        System.arraycopy(this.data, 0, tmp, 0, rows);
        tmp[rows] = new Object[this.colSize];
        this.data = tmp;
    }

    public void addCol() {
        Object[] data = this.data;
        int cols = this.colSize;
        int i = this.rowSize - 1;
        while (i >= 0) {
            Object[] tmp = new Object[cols + 1];
            System.arraycopy((Object[])data[i], 0, tmp, 0, cols);
            data[i] = tmp;
            --i;
        }
        ++this.colSize;
    }

    public void addRows(int count) {
        if (count < 1) {
            return;
        }
        Object[] data = this.data;
        int rows = this.rowSize;
        int cols = this.colSize;
        Object[] tmp = new Object[rows + count];
        System.arraycopy(data, 0, tmp, 0, rows);
        int i = rows + count - 1;
        while (i >= rows) {
            tmp[i] = new Object[cols];
            --i;
        }
        this.data = tmp;
        this.rowSize += count;
    }

    public void addCols(int count) {
        if (count < 1) {
            return;
        }
        Object[] data = this.data;
        int cols = this.colSize;
        int i = this.rowSize - 1;
        while (i >= 0) {
            Object[] tmp = new Object[cols + count];
            System.arraycopy((Object[])data[i], 0, tmp, 0, cols);
            data[i] = tmp;
            --i;
        }
        this.colSize += count;
    }

    public void insertRows(int index, int count) {
        if (count < 1) {
            return;
        }
        Object[] data = this.data;
        int rows = this.rowSize;
        int cols = this.colSize;
        Object[] tmp = new Object[rows + count];
        System.arraycopy(data, 0, tmp, 0, index);
        int moved = rows - index;
        if (moved > 0) {
            System.arraycopy(data, index, tmp, index + count, moved);
        }
        int i = index + count - 1;
        while (i >= index) {
            tmp[i] = new Object[cols];
            --i;
        }
        this.data = tmp;
        this.rowSize += count;
    }

    public void insertCols(int index, int count) {
        if (count < 1) {
            return;
        }
        Object[] data = this.data;
        int rows = this.rowSize;
        int cols = this.colSize;
        int moved = cols - index;
        int i = rows - 1;
        while (i >= 0) {
            Object[] tmp = new Object[cols + count];
            System.arraycopy(data[i], 0, tmp, 0, index);
            if (moved > 0) {
                System.arraycopy(data[i], index, tmp, index + count, moved);
            }
            data[i] = tmp;
            --i;
        }
        this.colSize += count;
    }

    public void insertCols(int index, int count, int beginRow, int endRow) {
        this.insertCols(index, count, beginRow, endRow, true);
    }

    public void insertCols(int index, int count, int beginRow, int endRow, boolean alignColHead) {
        if (count < 1) {
            return;
        }
        Object[] data = this.data;
        int rows = this.rowSize;
        int cols = this.colSize;
        int moved = cols - index;
        int i = rows - 1;
        while (i >= 0) {
            Object[] tmp = new Object[cols + count];
            if (i >= beginRow && i <= endRow) {
                System.arraycopy(data[i], 0, tmp, 0, index);
                if (moved > 0) {
                    System.arraycopy(data[i], index, tmp, index + count, moved);
                }
            } else if (i == 0) {
                if (alignColHead) {
                    System.arraycopy(data[0], 0, tmp, 0, index);
                    if (moved > 0) {
                        System.arraycopy(data[i], index, tmp, index + count, moved);
                    }
                } else {
                    System.arraycopy(data[0], 0, tmp, 0, cols);
                }
            } else {
                System.arraycopy(data[i], 0, tmp, 0, cols);
            }
            data[i] = tmp;
            --i;
        }
        this.colSize += count;
    }

    public void deleteRow(int index) {
        Object[] data = this.data;
        int rows = this.rowSize;
        Object[] tmp = new Object[rows - 1];
        System.arraycopy(data, 0, tmp, 0, index);
        int moved = rows - index - 1;
        if (moved > 0) {
            System.arraycopy(data, index + 1, tmp, index, moved);
        }
        this.data = tmp;
        --this.rowSize;
    }

    public void deleteCol(int index) {
        Object[] data = this.data;
        int rows = this.rowSize;
        int cols = this.colSize;
        int moved = cols - index - 1;
        int i = rows - 1;
        while (i >= 0) {
            Object[] tmp = new Object[cols - 1];
            System.arraycopy(data[i], 0, tmp, 0, index);
            if (moved > 0) {
                System.arraycopy(data[i], index + 1, tmp, index, moved);
            }
            data[i] = tmp;
            --i;
        }
        --this.colSize;
    }

    public void deleteRows(int index, int count) {
        Object[] data = this.data;
        int rows = data.length;
        Object[] tmp = new Object[rows - count];
        System.arraycopy(data, 0, tmp, 0, index);
        int moved = rows - index - count;
        if (moved > 0) {
            System.arraycopy(data, index + count, tmp, index, moved);
        }
        this.data = tmp;
        this.rowSize -= count;
    }

    public void deleteCols(int index, int count) {
        Object[] data = this.data;
        int rows = data.length;
        int cols = ((Object[])data[0]).length;
        int moved = cols - index - count;
        int i = rows - 1;
        while (i >= 0) {
            Object[] tmp = new Object[cols - count];
            System.arraycopy(data[i], 0, tmp, 0, index);
            if (moved > 0) {
                System.arraycopy(data[i], index + count, tmp, index, moved);
            }
            data[i] = tmp;
            --i;
        }
        this.colSize -= count;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(1);
        out.writeInt(this.rowSize);
        out.writeInt(this.colSize);
        Object[] dt = this.data;
        int i = 0;
        while (i < this.rowSize) {
            Object[] row = (Object[])dt[i];
            int j = 0;
            while (j < this.colSize) {
                out.writeObject(row[j]);
                ++j;
            }
            ++i;
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        byte version = in.readByte();
        this.rowSize = in.readInt();
        this.colSize = in.readInt();
        Object[] row = new Object[this.rowSize];
        int i = 0;
        while (i < this.rowSize) {
            Object[] col = new Object[this.colSize];
            int j = 0;
            while (j < this.colSize) {
                col[j] = in.readObject();
                ++j;
            }
            row[i] = col;
            ++i;
        }
        this.data = row;
    }

    public void changeRowOrder(int[] rowSeqs) {
        Object[] tmp = new Object[this.rowSize];
        Object[] old = this.data;
        int i = this.rowSize - 1;
        while (i >= 0) {
            tmp[i] = old[rowSeqs[i]];
            --i;
        }
        this.data = tmp;
    }

    public void deleteRows(int[] rowSeqs) {
        if (rowSeqs == null || rowSeqs.length == 0) {
            return;
        }
        int delCount = rowSeqs.length;
        int newSize = this.rowSize - delCount;
        Object[] newData = new Object[newSize];
        Object[] data = this.data;
        int copyCount = 0;
        int prev = 0;
        int i = 0;
        while (i < delCount) {
            int curCount = rowSeqs[i] - prev;
            System.arraycopy(data, prev, newData, copyCount, curCount);
            prev = rowSeqs[i] + 1;
            copyCount += curCount;
            ++i;
        }
        System.arraycopy(data, prev, newData, copyCount, this.rowSize - prev);
        this.data = newData;
        this.rowSize = newSize;
    }

    public void insertRows(int[] rowSeqs) {
        if (rowSeqs == null || rowSeqs.length == 0) {
            return;
        }
        int addCount = rowSeqs.length;
        int newSize = this.rowSize + addCount;
        Object[] newData = new Object[newSize];
        Object[] data = this.data;
        int colSize = this.colSize;
        int copyCount = 0;
        int prev = 0;
        int i = 0;
        while (i < addCount) {
            int curCount = rowSeqs[i] - prev;
            System.arraycopy(data, prev, newData, copyCount, curCount);
            prev = rowSeqs[i];
            newData[copyCount += curCount] = new Object[colSize];
            ++copyCount;
            ++i;
        }
        System.arraycopy(data, prev, newData, copyCount, this.rowSize - prev);
        this.data = newData;
        this.rowSize = newSize;
    }

    public void exchangeArea(int startRow1, int endRow1, int startRow2, int endRow2) {
        int totalLen = endRow2 - startRow1 + 1;
        Object[] tmps = new Object[totalLen];
        int len2 = endRow2 - startRow2 + 1;
        System.arraycopy(this.data, startRow2, tmps, 0, len2);
        int midLen = startRow2 - endRow1 - 1;
        if (midLen > 0) {
            System.arraycopy(this.data, endRow1 + 1, tmps, len2, midLen);
        }
        System.arraycopy(this.data, startRow1, tmps, len2 + midLen, endRow1 - startRow1 + 1);
        System.arraycopy(tmps, 0, this.data, startRow1, totalLen);
    }

    public void moveRows(int start, int end, int targetRow) {
        int count = end - start + 1;
        Object[][] rows = new Object[count][];
        System.arraycopy(this.data, start, rows, 0, count);
        if (start > targetRow) {
            System.arraycopy(this.data, targetRow, this.data, targetRow + count, start - targetRow);
            System.arraycopy(rows, 0, this.data, targetRow, count);
        } else {
            System.arraycopy(this.data, end + 1, this.data, start, targetRow - end - 1);
            System.arraycopy(rows, 0, this.data, targetRow - count, count);
        }
    }

    public void replace(int start, int end, Object[][] rows) {
        if (rows == null || rows.length == 0) {
            this.deleteRows(start, end - start + 1);
            return;
        }
        int delCount = end - start + 1;
        int addCount = rows.length;
        int newSize = this.rowSize + addCount - delCount;
        Object[] tmp = new Object[newSize];
        System.arraycopy(this.data, 0, tmp, 0, start);
        System.arraycopy(rows, 0, tmp, start, addCount);
        System.arraycopy(this.data, end + 1, tmp, start + addCount, this.rowSize - end - 1);
        this.data = tmp;
        this.rowSize = newSize;
    }

    public void exchangeCol(int c1, int c2) {
        Object[] data = this.data;
        int i = 0;
        int len = data.length;
        while (i < len) {
            Object[] row = (Object[])data[i];
            Object obj = row[c1];
            row[c1] = row[c2];
            row[c2] = obj;
            ++i;
        }
    }
}

