/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.common;

public final class ObjectCache {
    private static final int MAX_INTEGER = 65535;
    private static final Integer[] integers = new Integer[65536];
    private static final String[] strings = new String[128];

    static {
        int i = 0;
        int len = integers.length;
        while (i < len) {
            ObjectCache.integers[i] = new Integer(i);
            ++i;
        }
        char[] buf = new char[1];
        int i2 = 0;
        int len2 = strings.length;
        while (i2 < len2) {
            buf[0] = (char)i2;
            ObjectCache.strings[i2] = new String(buf);
            ++i2;
        }
    }

    public static Integer getInteger(int i) {
        if (i >= 0 && i <= 65535) {
            return integers[i];
        }
        return new Integer(i);
    }

    public static String getString(char[] buf) {
        if (buf[0] > '\u007f') {
            return new String(buf, 0, 1);
        }
        return strings[buf[0]];
    }

    public static String getString(byte b) {
        return strings[b];
    }
}

