/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.common;

import java.io.ByteArrayInputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;

public class SQLTool {
    public static String getProcedureColumnTypeName(int columnType) {
        switch (columnType) {
            case 1: {
                return "in";
            }
            case 2: {
                return "inout";
            }
            case 4: {
                return "out";
            }
            case 3: {
                return "result";
            }
            case 5: {
                return "return";
            }
            case 0: {
                return "unknown";
            }
        }
        return "error_type";
    }

    public static String getTypeName(int type) {
        switch (type) {
            case 2003: {
                return "array";
            }
            case -5: {
                return "bigint";
            }
            case -2: {
                return "binary";
            }
            case -7: {
                return "bit";
            }
            case 2004: {
                return "blob";
            }
            case 1: {
                return "char";
            }
            case 2005: {
                return "clob";
            }
            case 91: {
                return "date";
            }
            case 3: {
                return "decimal";
            }
            case 2001: {
                return "distinct";
            }
            case 8: {
                return "double";
            }
            case 6: {
                return "float";
            }
            case 4: {
                return "integer";
            }
            case 2000: {
                return "java_object";
            }
            case -4: {
                return "longvarbinary";
            }
            case -1: {
                return "longvarchar";
            }
            case 0: {
                return "null";
            }
            case 2: {
                return "numeric";
            }
            case 1111: {
                return "other";
            }
            case 7: {
                return "real";
            }
            case 2006: {
                return "ref";
            }
            case 5: {
                return "smallint";
            }
            case 2002: {
                return "struct";
            }
            case 92: {
                return "time";
            }
            case 93: {
                return "timestamp";
            }
            case -6: {
                return "tinyint";
            }
            case -3: {
                return "varbinary";
            }
            case 12: {
                return "varchar";
            }
        }
        return "errortype";
    }

    public static int sqlType2RQType(int type) {
        switch (type) {
            case -5: {
                return 4;
            }
            case 16: {
                return 12;
            }
            case -1: 
            case 1: 
            case 12: {
                return 11;
            }
            case 91: {
                return 8;
            }
            case 3: {
                return 7;
            }
            case 2: 
            case 7: 
            case 8: {
                return 6;
            }
            case 6: {
                return 5;
            }
            case 4: {
                return 1;
            }
            case -6: 
            case 5: {
                return 3;
            }
            case 92: {
                return 9;
            }
            case 93: {
                return 10;
            }
        }
        return 11;
    }

    public static void setObject(int dbType, PreparedStatement pst, int index, Object obj, String dbCharset, String clientCharset) throws SQLException, UnsupportedEncodingException {
        if (obj instanceof String && dbCharset != null && clientCharset != null) {
            obj = new String(((String)obj).getBytes(clientCharset), dbCharset);
        }
        if (dbType == 1 && obj != null && ((String)obj).length() > 512) {
            String s = (String)obj;
            StringReader r = new StringReader(s);
            pst.setCharacterStream(index, (Reader)r, s.length());
        } else {
            pst.setObject(index, obj);
        }
    }

    public static void setObject(int dbType, PreparedStatement pst, int index, Object o, int type) throws SQLException {
        if (o == null) {
            switch (type) {
                case 11: 
                case 61: {
                    pst.setNull(index, 12);
                    break;
                }
                case 6: 
                case 56: {
                    pst.setNull(index, 8);
                    break;
                }
                case 1: 
                case 51: {
                    pst.setNull(index, 4);
                    break;
                }
                case 62: {
                    pst.setNull(index, -2);
                    break;
                }
                case 8: {
                    pst.setNull(index, 91);
                    break;
                }
                case 9: {
                    pst.setNull(index, 92);
                    break;
                }
                case 10: {
                    pst.setNull(index, 93);
                    break;
                }
                case 7: {
                    pst.setNull(index, 3);
                    break;
                }
                default: {
                    pst.setNull(index, 12);
                    break;
                }
            }
        } else if (o instanceof BigDecimal) {
            pst.setBigDecimal(index, (BigDecimal)o);
        } else if (o instanceof Blob) {
            pst.setBlob(index, (Blob)o);
        } else if (o instanceof Boolean) {
            pst.setBoolean(index, (Boolean)o);
        } else if (o instanceof Byte) {
            pst.setByte(index, (Byte)o);
        } else if (o instanceof byte[]) {
            pst.setBytes(index, (byte[])o);
        } else if (o instanceof Clob) {
            pst.setClob(index, (Clob)o);
        } else if (o instanceof Date) {
            pst.setDate(index, (Date)o);
        } else if (o instanceof Double) {
            pst.setDouble(index, (Double)o);
        } else if (o instanceof Float) {
            pst.setFloat(index, ((Float)o).floatValue());
        } else if (o instanceof Integer) {
            pst.setInt(index, (Integer)o);
        } else if (o instanceof Long) {
            pst.setLong(index, (Long)o);
        } else if (o instanceof Ref) {
            pst.setRef(index, (Ref)o);
        } else if (o instanceof Short) {
            pst.setShort(index, (Short)o);
        } else if (o instanceof String) {
            String s = (String)o;
            if (dbType == 1 && s.length() > 512) {
                StringReader r = new StringReader(s);
                pst.setCharacterStream(index, (Reader)r, s.length());
            } else {
                pst.setString(index, s);
            }
        } else if (o instanceof Time) {
            pst.setTime(index, (Time)o);
        } else if (o instanceof Timestamp) {
            pst.setTimestamp(index, (Timestamp)o);
        } else if (o instanceof byte[]) {
            ByteArrayInputStream is = new ByteArrayInputStream((byte[])o);
            pst.setBinaryStream(index, is);
        } else {
            pst.setObject(index, o);
        }
    }

    public static Object getObject(ResultSet rs, int index, String dbCharset, String clientCharset) throws SQLException, UnsupportedEncodingException {
        Object obj = rs.getObject(index);
        if (obj instanceof String && dbCharset != null && clientCharset != null) {
            obj = new String(((String)obj).getBytes(dbCharset), clientCharset);
        }
        return obj;
    }

    public static Object getObject(ResultSet rs, int index, boolean needTranContent, String dbCharset, String clientCharset) throws SQLException, UnsupportedEncodingException {
        Object obj = rs.getObject(index);
        if (obj instanceof String && needTranContent && dbCharset != null && dbCharset.trim().length() > 0 && clientCharset != null && clientCharset.trim().length() > 0) {
            obj = new String(((String)obj).getBytes(dbCharset), clientCharset);
        }
        return obj;
    }
}

