/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.common;

import com.scudata.parallel.XmlUtil;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SplServerConfig {
    public String tempTimeOut;
    public String interval;
    public String backlog;
    public String proxyTimeOut;
    public String splConfig;
    public String logPath;
    public String splHome;
    public String JVMArgs;

    public static SplServerConfig getCfg(InputStream is) throws Exception {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        Document xmlDocument = docBuilder.parse(is);
        NodeList nl = xmlDocument.getChildNodes();
        Node root = null;
        int i = 0;
        while (i < nl.getLength()) {
            Node n = nl.item(i);
            if (n.getNodeName().equalsIgnoreCase("SERVER")) {
                root = n;
            }
            ++i;
        }
        if (root == null) {
            throw new Exception("Invalid config file.");
        }
        SplServerConfig ssc = new SplServerConfig();
        Node subNode = XmlUtil.findSonNode(root, "splHome");
        if (subNode == null) {
            throw new Exception("splHome is not specified.");
        }
        ssc.splHome = XmlUtil.getNodeValue(subNode);
        subNode = XmlUtil.findSonNode(root, "JVMArgs");
        if (subNode != null) {
            ssc.JVMArgs = XmlUtil.getNodeValue(subNode);
        }
        if ((subNode = XmlUtil.findSonNode(root, "TempTimeOut")) != null) {
            ssc.tempTimeOut = XmlUtil.getNodeValue(subNode);
        }
        if ((subNode = XmlUtil.findSonNode(root, "ProxyTimeOut")) != null) {
            ssc.proxyTimeOut = XmlUtil.getNodeValue(subNode);
        }
        if ((subNode = XmlUtil.findSonNode(root, "Interval")) != null) {
            ssc.interval = XmlUtil.getNodeValue(subNode);
        }
        if ((subNode = XmlUtil.findSonNode(root, "Backlog")) != null) {
            ssc.backlog = XmlUtil.getNodeValue(subNode);
        }
        if ((subNode = XmlUtil.findSonNode(root, "LogPath")) != null) {
            ssc.logPath = XmlUtil.getNodeValue(subNode);
        }
        if ((subNode = XmlUtil.findSonNode(root, "SplConfig")) != null) {
            ssc.splConfig = XmlUtil.getNodeValue(subNode);
        }
        return ssc;
    }
}

