/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.common;

import com.scudata.common.DBInfo;
import com.scudata.common.DBSession;
import com.scudata.common.ISessionFactory;
import com.scudata.common.ImportSpringBeanFactory;
import com.scudata.common.Logger;
import com.scudata.dm.Env;
import javax.sql.DataSource;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.jdbc.datasource.lookup.BeanFactoryDataSourceLookup;

public class SpringDBSessionFactory
implements ISessionFactory {
    private DataSource ds;
    private int dbType = 0;
    private DBInfo dbInfo;

    public SpringDBSessionFactory(DataSource ds, Integer type) {
        this.ds = ds;
        if (type != null) {
            this.dbType = type;
        }
        this.dbInfo = new DBInfo(this.dbType);
    }

    @Override
    public DBSession getSession() throws Exception {
        return new DBSession(this.ds.getConnection(), this.dbInfo);
    }

    public static ISessionFactory create(String springDataSourceId, int type) {
        BeanFactoryDataSourceLookup lookup;
        BeanFactoryDataSourceLookup curr = lookup = new BeanFactoryDataSourceLookup();
        try {
            assert (ImportSpringBeanFactory.beanFactory != null);
        }
        catch (Exception e) {
            Logger.debug("please scan com.scudata.common.ImportSpringBeanFactory");
            return null;
        }
        BeanFactory beanFactory = ImportSpringBeanFactory.beanFactory;
        curr.setBeanFactory(beanFactory);
        DataSource dataSource = lookup.getDataSource(springDataSourceId);
        SpringDBSessionFactory sf = new SpringDBSessionFactory(dataSource, type);
        Env.setDBSessionFactory(springDataSourceId, sf);
        return sf;
    }

    public DataSource getDataSource() {
        return this.ds;
    }
}

