/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.common;

import com.scudata.common.ArgumentTokenizer;
import com.scudata.common.Escape;
import com.scudata.common.Sentence;
import java.awt.FontMetrics;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Vector;

public class StringUtils {
    private static char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static String[] excelLabels = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};
    static final char[] c1Digit = new char[]{'\u96f6', '\u58f9', '\u8d30', '\u53c1', '\u8086', '\u4f0d', '\u9646', '\u67d2', '\u634c', '\u7396'};
    static final char[] c2Digit = new char[]{'\u96f6', '\u4e00', '\u4e8c', '\u4e09', '\u56db', '\u4e94', '\u516d', '\u4e03', '\u516b', '\u4e5d'};
    static final char[] c1Unit = new char[]{'\u62fe', '\u4f70', '\u4edf'};
    static final char[] c2Unit = new char[]{'\u5341', '\u767e', '\u5343'};
    static final String[] chinaUnit = new String[]{"\u4e07", "\u4ebf", "\u4ebf\u4e07"};
    private static final String[] provinces;
    private static final int[] wi;
    private static final char[] codes;

    static {
        String[] stringArray = new String[92];
        stringArray[11] = "\u5317\u4eac";
        stringArray[12] = "\u5929\u6d25";
        stringArray[13] = "\u6cb3\u5317";
        stringArray[14] = "\u5c71\u897f";
        stringArray[15] = "\u5185\u8499\u53e4";
        stringArray[21] = "\u8fbd\u5b81";
        stringArray[22] = "\u5409\u6797";
        stringArray[23] = "\u9ed1\u9f99\u6c5f";
        stringArray[31] = "\u4e0a\u6d77";
        stringArray[32] = "\u6c5f\u82cf";
        stringArray[33] = "\u6d59\u6c5f";
        stringArray[34] = "\u5b89\u5fae";
        stringArray[35] = "\u798f\u5efa";
        stringArray[36] = "\u6c5f\u897f";
        stringArray[37] = "\u5c71\u4e1c";
        stringArray[41] = "\u6cb3\u5357";
        stringArray[42] = "\u6e56\u5317";
        stringArray[43] = "\u6e56\u5357";
        stringArray[44] = "\u5e7f\u4e1c";
        stringArray[45] = "\u5e7f\u897f";
        stringArray[46] = "\u6d77\u5357";
        stringArray[50] = "\u91cd\u5e86";
        stringArray[51] = "\u56db\u5ddd";
        stringArray[52] = "\u8d35\u5dde";
        stringArray[53] = "\u4e91\u5357";
        stringArray[54] = "\u897f\u85cf";
        stringArray[61] = "\u9655\u897f";
        stringArray[62] = "\u7518\u8083";
        stringArray[63] = "\u9752\u6d77";
        stringArray[64] = "\u5b81\u590f";
        stringArray[65] = "\u65b0\u7586";
        stringArray[71] = "\u53f0\u6e7e";
        stringArray[81] = "\u9999\u6e2f";
        stringArray[82] = "\u6fb3\u95e8";
        stringArray[91] = "\u56fd\u5916";
        provinces = stringArray;
        wi = new int[]{7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2, 1};
        codes = new char[]{'1', '0', 'X', '9', '8', '7', '6', '5', '4', '3', '2'};
    }

    private static String toExcel(int index) {
        if (index < 26) {
            return excelLabels[index];
        }
        int shang = index / 26;
        int yu = index % 26;
        return String.valueOf(StringUtils.toExcel(shang - 1)) + excelLabels[yu];
    }

    public static String toExcelLabel(int index) {
        return StringUtils.toExcel(index - 1);
    }

    public static final boolean isSpaceString(String s) {
        if (s == null) {
            return true;
        }
        int i = 0;
        int len = s.length();
        while (i < len) {
            char c = s.charAt(i);
            if (!Character.isWhitespace(c)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static final String toHexString(long l, int byteNum) {
        StringBuffer sb = new StringBuffer(16);
        StringUtils.appendHexString(sb, l, byteNum);
        return sb.toString();
    }

    public static final void appendHexString(StringBuffer sb, long l, int byteNum) {
        int i = byteNum * 2 - 1;
        while (i >= 0) {
            long x = l >> i * 4 & 0xFL;
            sb.append(hexDigits[(int)x]);
            --i;
        }
    }

    public static final StringBuffer deunicode(String s, StringBuffer sb, String specialChars) {
        int len = s.length();
        if (sb == null) {
            sb = new StringBuffer(len * 2);
        }
        int i = 0;
        while (i < len) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\\': {
                    sb.append('\\').append('\\');
                    break;
                }
                case '\t': {
                    sb.append('\\').append('t');
                    break;
                }
                case '\n': {
                    sb.append('\\').append('n');
                    break;
                }
                case '\r': {
                    sb.append('\\').append('r');
                    break;
                }
                case '\f': {
                    sb.append('\\').append('f');
                    break;
                }
                default: {
                    if (ch < ' ' || ch > '~') {
                        sb.append('\\').append('u');
                        sb.append(hexDigits[ch >> 12 & 0xF]);
                        sb.append(hexDigits[ch >> 8 & 0xF]);
                        sb.append(hexDigits[ch >> 4 & 0xF]);
                        sb.append(hexDigits[ch & 0xF]);
                        break;
                    }
                    if (specialChars != null && specialChars.indexOf(ch) != -1) {
                        sb.append('\\');
                    }
                    sb.append(ch);
                }
            }
            ++i;
        }
        return sb;
    }

    public static final StringBuffer deunicode(String s, StringBuffer sb) {
        return StringUtils.deunicode(s, sb, null);
    }

    public static final String deunicode(String s, String specialChars) {
        return StringUtils.deunicode(s, null, specialChars).toString();
    }

    public static final String deunicode(String s) {
        return StringUtils.deunicode(s, null, null).toString();
    }

    public static ArrayList<String> wrapString(String text, FontMetrics fm, float w) {
        w = (float)Math.ceil(w) - 1.01f;
        ArrayList<String> al = new ArrayList<String>();
        ArgumentTokenizer at = new ArgumentTokenizer(text, '\n', true, true, true);
        while (at.hasNext()) {
            String line = at.next();
            if (at.hasNext()) {
                line = String.valueOf(line) + "\n";
            }
            int len = line.length();
            String tmp = "";
            int i = 0;
            while (i < len) {
                char c = line.charAt(i);
                if ((float)fm.stringWidth(tmp = String.valueOf(tmp) + String.valueOf(c)) > w) {
                    int cut = StringUtils.cutLine(tmp, c);
                    al.add(tmp.substring(0, cut));
                    tmp = tmp.substring(cut);
                }
                ++i;
            }
            al.add(tmp);
        }
        return al;
    }

    private static int cutLine(String s, char c) {
        int len = s.length() - 1;
        if (c == '\u0000') {
            c = s.charAt(len);
        }
        boolean canBeHead = StringUtils.canBeHead(c);
        boolean isEnglishChar = StringUtils.isEnglishChar(c);
        if (!canBeHead && isEnglishChar) {
            int seek = len - 1;
            int loc = 0;
            boolean hasHead = StringUtils.canBeHead(c);
            boolean letterbreak = false;
            while (seek >= 0 && loc == 0) {
                char seekChar = s.charAt(seek);
                if (!StringUtils.isEnglishChar(seekChar)) {
                    letterbreak = true;
                    if (!hasHead) {
                        if (StringUtils.canBeHead(seekChar)) {
                            hasHead = true;
                        }
                        --seek;
                        continue;
                    }
                    if (StringUtils.canBeFoot(seekChar)) {
                        loc = seek + 1;
                        continue;
                    }
                    hasHead = StringUtils.canBeHead(seekChar);
                    --seek;
                    continue;
                }
                if (letterbreak) {
                    loc = seek + 1;
                    continue;
                }
                hasHead = StringUtils.canBeHead(seekChar);
                --seek;
            }
            if (loc > 0) {
                return loc;
            }
            return len;
        }
        if (!canBeHead) {
            int seek = len - 1;
            int loc = 0;
            boolean hasHead = false;
            while (seek >= 0 && loc == 0) {
                char seekChar = s.charAt(seek);
                if (!hasHead) {
                    if (StringUtils.canBeHead(seekChar)) {
                        hasHead = true;
                    }
                    --seek;
                    continue;
                }
                if (StringUtils.isEnglishChar(seekChar)) {
                    int eseek = seek;
                    boolean eng = true;
                    while (eng && seek > 0) {
                        eng = StringUtils.isEnglishChar(s.charAt(--seek));
                    }
                    if (seek != 0) continue;
                    loc = eseek + 1;
                    continue;
                }
                if (StringUtils.canBeFoot(seekChar)) {
                    loc = seek + 1;
                    continue;
                }
                --seek;
            }
            if (loc > 0) {
                return loc;
            }
            return len;
        }
        if (isEnglishChar) {
            int seek = len - 1;
            int loc = 0;
            boolean hasHead = StringUtils.canBeHead(c);
            boolean letterbreak = false;
            while (seek >= 0 && loc == 0) {
                char seekChar = s.charAt(seek);
                if (!StringUtils.isEnglishChar(seekChar)) {
                    letterbreak = true;
                    if (!hasHead) {
                        if (StringUtils.canBeHead(seekChar)) {
                            hasHead = true;
                        }
                        --seek;
                        continue;
                    }
                    if (StringUtils.canBeFoot(seekChar)) {
                        loc = seek + 1;
                        continue;
                    }
                    hasHead = StringUtils.canBeHead(seekChar);
                    --seek;
                    continue;
                }
                if (letterbreak) {
                    loc = seek + 1;
                    continue;
                }
                hasHead = StringUtils.canBeHead(seekChar);
                --seek;
            }
            if (loc > 0) {
                return loc;
            }
            return len;
        }
        return StringUtils.seekCanBeFoot(s.substring(0, len), len);
    }

    private static int seekCanBeFoot(String s, int len) {
        if (len == -1) {
            len = s.length();
        }
        if (len <= 1) {
            return len;
        }
        int seek = len - 1;
        int loc = 0;
        while (seek >= 0 && loc == 0) {
            char seekChar = s.charAt(seek);
            if (StringUtils.canBeFoot(seekChar)) {
                loc = seek + 1;
                continue;
            }
            --seek;
        }
        if (loc > 0) {
            return loc;
        }
        return len;
    }

    private static boolean canBeFoot(char c) {
        String cannotFoot = "([{\u00b7\u2018\u201c\u3008\u300a\u300c\u300e\u3010\u3014\u3016\uff08\uff0e\uff3b\uff5b\uffe1\uffe5";
        return cannotFoot.indexOf(c) < 0;
    }

    private static boolean canBeHead(char c) {
        String cannotHead = "!),.:;?]}\u00a8\u00b7\u02c7\u02c9\u2015\u2016\u2019\u201d\u2026\u2236\u3001\u3002\u3003\u3005\u3009\u300b\u300d\u300f\u3011\u3015\u3017\uff01\uff02\uff07\uff09\uff0c\uff0e\uff1a\uff1b\uff1f\uff3d\uff40\uff5c\uff5d\uff5e\uffe0";
        return cannotHead.indexOf(c) < 0;
    }

    private static boolean isEnglishChar(char c) {
        return c <= '~' && c > ' ';
    }

    public static final StringBuffer unicode(String s, StringBuffer sb) {
        int len = s.length();
        if (sb == null) {
            sb = new StringBuffer(len);
        }
        int i = 0;
        while (i < len) {
            char ch;
            if ((ch = s.charAt(i++)) != '\\') {
                sb.append(ch);
                continue;
            }
            if ((ch = s.charAt(i++)) == 'u') {
                int value = 0;
                int j = 0;
                while (j < 4) {
                    ch = s.charAt(i++);
                    switch (ch) {
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            value = (value << 4) + ch - 48;
                            break;
                        }
                        case 'a': 
                        case 'b': 
                        case 'c': 
                        case 'd': 
                        case 'e': 
                        case 'f': {
                            value = (value << 4) + 10 + ch - 97;
                            break;
                        }
                        case 'A': 
                        case 'B': 
                        case 'C': 
                        case 'D': 
                        case 'E': 
                        case 'F': {
                            value = (value << 4) + 10 + ch - 65;
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("\u4e0d\u5408\u6cd5\u7684\\uxxxx\u7f16\u7801");
                        }
                    }
                    ++j;
                }
                sb.append((char)value);
                continue;
            }
            switch (ch) {
                case 't': {
                    ch = '\t';
                    break;
                }
                case 'r': {
                    ch = '\r';
                    break;
                }
                case 'n': {
                    ch = '\n';
                    break;
                }
                case 'f': {
                    ch = '\f';
                }
            }
            sb.append(ch);
        }
        return sb;
    }

    public static final String unicode(String s) {
        return StringUtils.unicode(s, null).toString();
    }

    public static final String unicode2String(String theString) {
        int len = theString.length();
        StringBuffer outBuffer = new StringBuffer(len);
        int x = 0;
        while (x < len) {
            char aChar;
            if ((aChar = theString.charAt(x++)) == '\\') {
                if ((aChar = theString.charAt(x++)) != 'u') continue;
                int value = 0;
                int i = 0;
                while (i < 4) {
                    aChar = theString.charAt(x++);
                    switch (aChar) {
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            value = (value << 4) + aChar - 48;
                            break;
                        }
                        case 'a': 
                        case 'b': 
                        case 'c': 
                        case 'd': 
                        case 'e': 
                        case 'f': {
                            value = (value << 4) + 10 + aChar - 97;
                            break;
                        }
                        case 'A': 
                        case 'B': 
                        case 'C': 
                        case 'D': 
                        case 'E': 
                        case 'F': {
                            value = (value << 4) + 10 + aChar - 65;
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                        }
                    }
                    ++i;
                }
                outBuffer.append((char)value);
                continue;
            }
            outBuffer.append(aChar);
        }
        return outBuffer.toString();
    }

    private static final StringBuffer toRMB2(long l, char[] cDigit, char[] cUnit) {
        int unit = 0;
        int bit = 0;
        boolean hasZero = false;
        boolean sf = false;
        StringBuffer sb = new StringBuffer(64);
        while (l > 0L) {
            int d;
            if (bit == 4) {
                if (unit > 2) {
                    throw new IllegalArgumentException("\u5927\u5199\u4e0d\u652f\u6301\u5927\u4e8e\u4e00\u4e07\u4e07\u4ebf\u7684\u6570");
                }
                if (sf) {
                    if (hasZero || l % 10L == 0L) {
                        sb.append(cDigit[0]);
                        hasZero = false;
                    }
                } else {
                    int len = sb.length();
                    if (len > 0) {
                        sb.deleteCharAt(len - 1);
                    }
                }
                sb.append(chinaUnit[unit]);
                ++unit;
                bit = 0;
                sf = false;
            }
            if ((d = (int)(l % 10L)) > 0) {
                sf = true;
                if (hasZero) {
                    sb.append(cDigit[0]);
                    hasZero = false;
                }
                if (bit != 0) {
                    sb.append(cUnit[bit - 1]);
                }
                sb.append(cDigit[d]);
            } else if (sf) {
                hasZero = true;
            }
            ++bit;
            l /= 10L;
        }
        return sb.reverse();
    }

    public static final String toRMB(double money) {
        return StringUtils.toRMB(money, true, true);
    }

    public static final String toRMB(double money, boolean abbreviate, boolean uppercase) {
        long yuan;
        char[] cDigit = uppercase ? c1Digit : c2Digit;
        char[] cUnit = uppercase ? c1Unit : c2Unit;
        StringBuffer sb = new StringBuffer(64);
        if (money < 0.0) {
            sb.append("\u8d1f");
            money = -money;
        }
        if ((yuan = (long)money) == 0L) {
            sb.append("\u96f6");
        } else {
            sb.append(StringUtils.toRMB2(yuan, cDigit, cUnit));
        }
        sb.append('\u5143');
        int jaoFeng = (int)((money + 0.001 - (double)((long)money)) * 100.0) % 100;
        int jao = jaoFeng / 10;
        int feng = jaoFeng % 10;
        if (jao > 0) {
            sb.append(cDigit[jao]);
            sb.append('\u89d2');
        }
        if (feng > 0) {
            if (jao == 0) {
                sb.append('\u96f6');
            }
            sb.append(cDigit[feng]);
            sb.append('\u5206');
        } else {
            sb.append('\u6574');
        }
        return sb.toString();
    }

    public static final String toChinese(long l, boolean abbreviate, boolean uppercase) {
        char[] cUnit;
        String fu = "";
        if (l == 0L) {
            return "\u96f6";
        }
        if (l < 0L) {
            fu = "\u8d1f";
            l = -l;
        }
        char[] cDigit = uppercase ? c1Digit : c2Digit;
        char[] cArray = cUnit = uppercase ? c1Unit : c2Unit;
        if (abbreviate) {
            return String.valueOf(fu) + StringUtils.toRMB2(l, cDigit, cUnit).toString();
        }
        StringBuffer sb = new StringBuffer(64);
        while (l > 0L) {
            int digit = (int)l % 10;
            sb.append(cDigit[digit]);
            l /= 10L;
        }
        sb = sb.reverse();
        return String.valueOf(fu) + sb.toString();
    }

    private static final boolean matches(String src, int pos1, String fmt, int pos2) {
        int len1 = src.length();
        int len2 = fmt.length();
        boolean any = false;
        block0: while (pos2 < len2) {
            char c;
            char ch = fmt.charAt(pos2);
            if (ch == '*') {
                ++pos2;
                any = true;
                continue;
            }
            if (ch == '?') {
                if (++pos1 > len1) {
                    return false;
                }
                ++pos2;
                continue;
            }
            if (any) {
                if (ch == '\\' && pos2 + 1 < len2 && ((c = fmt.charAt(pos2 + 1)) == '*' || c == '?')) {
                    ch = c;
                    ++pos2;
                }
                while (pos1 < len1) {
                    if (src.charAt(pos1++) != ch || !StringUtils.matches(src, pos1, fmt, pos2 + 1)) continue;
                    return true;
                }
                return false;
            }
            if (ch == '\\' && pos2 + 1 < len2 && ((c = fmt.charAt(pos2 + 1)) == '*' || c == '?')) {
                ch = c;
                ++pos2;
            }
            if (pos1 == len1 || src.charAt(pos1++) != ch) {
                return false;
            }
            ++pos2;
            while (pos2 < len2) {
                ch = fmt.charAt(pos2);
                if (ch == '*') {
                    any = true;
                    ++pos2;
                    continue block0;
                }
                if (ch == '?') {
                    if (++pos1 > len1) {
                        return false;
                    }
                    ++pos2;
                    continue;
                }
                if (ch == '\\' && pos2 + 1 < len2 && ((c = fmt.charAt(pos2 + 1)) == '*' || c == '?')) {
                    ch = c;
                    ++pos2;
                }
                if (pos1 == len1 || src.charAt(pos1++) != ch) {
                    return false;
                }
                ++pos2;
            }
        }
        return any || pos1 == len1;
    }

    private static final boolean matchesIgnoreCase(String src, int pos1, String fmt, int pos2) {
        int len1 = src.length();
        int len2 = fmt.length();
        boolean any = false;
        block0: while (pos2 < len2) {
            char c;
            char ch = fmt.charAt(pos2);
            if (ch == '*') {
                ++pos2;
                any = true;
                continue;
            }
            if (ch == '?') {
                if (++pos1 > len1) {
                    return false;
                }
                ++pos2;
                continue;
            }
            if (any) {
                if (ch == '\\' && pos2 + 1 < len2 && ((c = fmt.charAt(pos2 + 1)) == '*' || c == '?')) {
                    ch = c;
                    ++pos2;
                }
                while (pos1 < len1) {
                    if (Character.toUpperCase(src.charAt(pos1++)) != Character.toUpperCase(ch) || !StringUtils.matchesIgnoreCase(src, pos1, fmt, pos2 + 1)) continue;
                    return true;
                }
                return false;
            }
            if (ch == '\\' && pos2 + 1 < len2 && ((c = fmt.charAt(pos2 + 1)) == '*' || c == '?')) {
                ch = c;
                ++pos2;
            }
            if (pos1 == len1 || Character.toUpperCase(src.charAt(pos1++)) != Character.toUpperCase(ch)) {
                return false;
            }
            ++pos2;
            while (pos2 < len2) {
                ch = fmt.charAt(pos2);
                if (ch == '*') {
                    any = true;
                    ++pos2;
                    continue block0;
                }
                if (ch == '?') {
                    if (++pos1 > len1) {
                        return false;
                    }
                    ++pos2;
                    continue;
                }
                if (ch == '\\' && pos2 + 1 < len2 && ((c = fmt.charAt(pos2 + 1)) == '*' || c == '?')) {
                    ch = c;
                    ++pos2;
                }
                if (pos1 == len1 || Character.toUpperCase(src.charAt(pos1++)) != Character.toUpperCase(ch)) {
                    return false;
                }
                ++pos2;
            }
        }
        return any || pos1 == len1;
    }

    public static final boolean matches(String value, String fmt, boolean ignoreCase) {
        if (value == null || fmt == null) {
            return false;
        }
        if (ignoreCase) {
            return StringUtils.matchesIgnoreCase(value, 0, fmt, 0);
        }
        return StringUtils.matches(value, 0, fmt, 0);
    }

    private static boolean like(String src, int pos1, String fmt, int pos2) {
        int len1 = src.length();
        int len2 = fmt.length();
        boolean any = false;
        block0: while (pos2 < len2) {
            char c;
            char ch = fmt.charAt(pos2);
            if (ch == '%') {
                ++pos2;
                any = true;
                continue;
            }
            if (ch == '_') {
                if (++pos1 > len1) {
                    return false;
                }
                ++pos2;
                continue;
            }
            if (any) {
                if (ch == '\\' && pos2 + 1 < len2 && ((c = fmt.charAt(pos2 + 1)) == '%' || c == '_')) {
                    ch = c;
                    ++pos2;
                }
                while (pos1 < len1) {
                    if (src.charAt(pos1++) != ch || !StringUtils.like(src, pos1, fmt, pos2 + 1)) continue;
                    return true;
                }
                return false;
            }
            if (ch == '\\' && pos2 + 1 < len2 && ((c = fmt.charAt(pos2 + 1)) == '%' || c == '_')) {
                ch = c;
                ++pos2;
            }
            if (pos1 == len1 || src.charAt(pos1++) != ch) {
                return false;
            }
            ++pos2;
            while (pos2 < len2) {
                ch = fmt.charAt(pos2);
                if (ch == '%') {
                    any = true;
                    ++pos2;
                    continue block0;
                }
                if (ch == '_') {
                    if (++pos1 > len1) {
                        return false;
                    }
                    ++pos2;
                    continue;
                }
                if (ch == '\\' && pos2 + 1 < len2 && ((c = fmt.charAt(pos2 + 1)) == '%' || c == '_')) {
                    ch = c;
                    ++pos2;
                }
                if (pos1 == len1 || src.charAt(pos1++) != ch) {
                    return false;
                }
                ++pos2;
            }
        }
        return any || pos1 == len1;
    }

    public static boolean like(String src, String fmt) {
        if (src == null) {
            return false;
        }
        return StringUtils.like(src, 0, fmt, 0);
    }

    public static final boolean identify(String ident) {
        if (ident == null) {
            return false;
        }
        int len = ident.length();
        if (len != 15 && len != 18) {
            return false;
        }
        int i = 0;
        while (i < (len == 15 ? 15 : 17)) {
            char ch = ident.charAt(i);
            if (ch < '0' || ch > '9') {
                return false;
            }
            ++i;
        }
        int p = (ident.charAt(0) - 48) * 10 + (ident.charAt(1) - 48);
        if (p >= provinces.length || provinces[p] == null) {
            return false;
        }
        int year = 0;
        int month = 0;
        int day = 0;
        if (len == 15) {
            year = 1900 + (ident.charAt(6) - 48) * 10 + (ident.charAt(7) - 48);
            month = (ident.charAt(8) - 48) * 10 + (ident.charAt(9) - 48);
            day = (ident.charAt(10) - 48) * 10 + (ident.charAt(11) - 48);
        } else {
            year = (ident.charAt(6) - 48) * 1000 + (ident.charAt(7) - 48) * 100 + (ident.charAt(8) - 48) * 10 + (ident.charAt(9) - 48);
            month = (ident.charAt(10) - 48) * 10 + (ident.charAt(11) - 48);
            day = (ident.charAt(12) - 48) * 10 + (ident.charAt(13) - 48);
        }
        if (month == 2) {
            if (year % 4 == 0 && (year % 100 != 0 || year % 400 == 0) ? day > 29 : day > 28) {
                return false;
            }
        } else if (month == 4 || month == 6 || month == 9 || month == 11) {
            if (day > 30) {
                return false;
            }
        } else if (month <= 12) {
            if (day > 31) {
                return false;
            }
        } else {
            return false;
        }
        if (len == 18) {
            int[] w = wi;
            int mod = 0;
            int i2 = 0;
            while (i2 < 17) {
                mod += (ident.charAt(i2) - 48) * w[i2];
                ++i2;
            }
            if (ident.charAt(17) != codes[mod %= 11]) {
                return false;
            }
        }
        return true;
    }

    public static String replace(String src, String findString, String replaceString) {
        int i;
        int pos;
        if (src == null || findString == null) {
            return src;
        }
        int len = src.length();
        if (len == 0) {
            return src;
        }
        int len1 = findString.length();
        if (len1 == 0) {
            return src;
        }
        if (replaceString == null) {
            return src;
        }
        int start = 0;
        StringBuffer sb = null;
        while ((pos = src.indexOf(findString, start)) >= 0) {
            if (sb == null) {
                sb = new StringBuffer(len + 100);
            }
            i = start;
            while (i < pos) {
                sb.append(src.charAt(i));
                ++i;
            }
            sb.append(replaceString);
            start = pos + len1;
        }
        if (sb != null) {
            i = start;
            while (i < len) {
                sb.append(src.charAt(i));
                ++i;
            }
        }
        if (sb != null) {
            return sb.toString();
        }
        return src;
    }

    public static boolean isValidString(Object str) {
        if (!(str instanceof String)) {
            return false;
        }
        return !StringUtils.isSpaceString((String)str);
    }

    public static boolean isValidExpression(String str) {
        if (!StringUtils.isValidString(str)) {
            return true;
        }
        int len = str.length();
        int index = 0;
        while (index < len) {
            int tmp;
            char ch = str.charAt(index);
            if (ch == '\\') {
                index += 2;
                continue;
            }
            if (ch == '\"' || ch == '\'') {
                tmp = Sentence.scanQuotation(str, index);
                if (tmp < 0) {
                    return false;
                }
                index = tmp + 1;
                continue;
            }
            if (ch == '(') {
                tmp = Sentence.scanParenthesis(str, index);
                if (tmp < 0) {
                    return false;
                }
                index = tmp + 1;
                continue;
            }
            if (ch == '[') {
                tmp = Sentence.scanBracket(str, index);
                if (tmp < 0) {
                    return false;
                }
                index = tmp + 1;
                continue;
            }
            if (ch == '{') {
                tmp = Sentence.scanBrace(str, index);
                if (tmp < 0) {
                    return false;
                }
                index = tmp + 1;
                continue;
            }
            ++index;
        }
        return true;
    }

    public static int indexOf(String[] keys, String compare) {
        int i = 0;
        while (i < keys.length) {
            if (keys[i].equals(compare)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static Vector string2Vector(String str) {
        return StringUtils.string2Vector(str, ',', false);
    }

    public static Vector string2Vector(String str, char delim) {
        return StringUtils.string2Vector(str, delim, false);
    }

    public static Vector string2Vector(String str, char delim, boolean removeEsc) {
        Vector<String> v = new Vector<String>();
        if (str == null) {
            return v;
        }
        ArgumentTokenizer st = new ArgumentTokenizer(str, delim);
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (removeEsc) {
                s = Escape.removeEscAndQuote(s);
            }
            if (!StringUtils.isValidString(s)) {
                s = null;
            }
            v.add(s);
        }
        return v;
    }

    public static String[] toStringArray(ArrayList list) {
        int c = list.size();
        if (c == 0) {
            return null;
        }
        String[] array = new String[c];
        int i = 0;
        while (i < c) {
            Object o = list.get(i);
            if (o != null) {
                array[i] = o.toString();
            }
            ++i;
        }
        return array;
    }

    public static boolean checkHosts(String hosts) {
        String host = null;
        try {
            host = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            return false;
        }
        if (!StringUtils.isValidString(hosts)) {
            return true;
        }
        String thisIp = host;
        boolean found = false;
        ArgumentTokenizer at = new ArgumentTokenizer(hosts, ',');
        while (at.hasMoreTokens()) {
            String tmpIp = at.nextToken().trim();
            if (!thisIp.equals(tmpIp)) continue;
            found = true;
            break;
        }
        return found;
    }

    public static int getScaledFontSize(int fontSize, float scale) {
        int size = fontSize;
        return (int)((float)size * scale + 0.3f);
    }

    private static boolean startsWithIgnoreCase(String source, String target) {
        int targetCount = target.length();
        if (targetCount == 0) {
            return true;
        }
        int sourceCount = source.length();
        if (sourceCount < targetCount) {
            return false;
        }
        int j = 0;
        int k = 0;
        while (k < targetCount) {
            if (source.charAt(j) != target.charAt(k) && Character.toUpperCase(source.charAt(j)) != Character.toUpperCase(target.charAt(k))) {
                return false;
            }
            ++j;
            ++k;
        }
        return true;
    }

    private static boolean endsWithIgnoreCase(String source, String target) {
        int targetCount = target.length();
        if (targetCount == 0) {
            return true;
        }
        int sourceCount = source.length();
        if (sourceCount < targetCount) {
            return false;
        }
        int j = sourceCount - targetCount;
        int k = 0;
        while (k < targetCount) {
            if (source.charAt(j) != target.charAt(k) && Character.toUpperCase(source.charAt(j)) != Character.toUpperCase(target.charAt(k))) {
                return false;
            }
            ++j;
            ++k;
        }
        return true;
    }

    public static int pos(String source, String target, int fromIndex, boolean ignoreCase, boolean headOnly, boolean isLast, boolean skipQuotation) {
        if (ignoreCase) {
            if (headOnly) {
                if (isLast) {
                    if (StringUtils.endsWithIgnoreCase(source, target)) {
                        return source.length() - target.length();
                    }
                    return -1;
                }
                if (StringUtils.startsWithIgnoreCase(source, target)) {
                    return 0;
                }
                return -1;
            }
            if (skipQuotation) {
                if (isLast) {
                    return StringUtils.lastIndexOf(source, target, fromIndex, true, true);
                }
                return StringUtils.indexOf(source, target, fromIndex, true, true);
            }
            if (isLast) {
                return StringUtils.lastIndexOf(source, target, fromIndex, true, false);
            }
            return StringUtils.indexOf(source, target, fromIndex, true, false);
        }
        if (skipQuotation) {
            if (isLast) {
                if (headOnly) {
                    int index = source.length() - target.length();
                    if (source.startsWith(target, index)) {
                        return index;
                    }
                    return -1;
                }
                return StringUtils.lastIndexOf(source, target, fromIndex, false, true);
            }
            if (headOnly) {
                if (source.startsWith(target, 0)) {
                    return 0;
                }
                return -1;
            }
            return StringUtils.indexOf(source, target, fromIndex, false, true);
        }
        if (isLast) {
            if (headOnly) {
                int index = source.length() - target.length();
                if (source.startsWith(target, index)) {
                    return index;
                }
                return -1;
            }
            return source.lastIndexOf(target, fromIndex);
        }
        if (headOnly) {
            if (source.startsWith(target, 0)) {
                return 0;
            }
            return -1;
        }
        return source.indexOf(target, fromIndex);
    }

    public static int wholePos(String source, String target, int fromIndex, boolean ignoreCase, boolean headOnly, boolean isLast, boolean skipQuotation) {
        if (ignoreCase) {
            source = source.toUpperCase();
            target = target.toUpperCase();
        }
        if (headOnly) {
            if (isLast) {
                int index = source.length() - target.length();
                if (source.startsWith(target, index)) {
                    if (index == 0 || !Character.isJavaIdentifierPart(source.charAt(index - 1))) {
                        return index;
                    }
                    return -1;
                }
                return -1;
            }
            if (source.startsWith(target, 0)) {
                int len = target.length();
                if (source.length() == len || !Character.isJavaIdentifierPart(source.charAt(len))) {
                    return 0;
                }
                return -1;
            }
            return -1;
        }
        int srcLen = source.length();
        int len = target.length();
        if (skipQuotation) {
            if (isLast) {
                while (true) {
                    int pos;
                    if ((pos = StringUtils.lastIndexOf(source, target, fromIndex, false, true)) == -1) {
                        return -1;
                    }
                    if (!(pos != 0 && Character.isJavaIdentifierPart(source.charAt(pos - 1)) || pos + len != srcLen && Character.isJavaIdentifierPart(source.charAt(pos + len)))) {
                        return pos;
                    }
                    fromIndex -= len;
                }
            }
            while (true) {
                int pos;
                if ((pos = StringUtils.indexOf(source, target, fromIndex, false, true)) == -1) {
                    return -1;
                }
                if (!(pos != 0 && Character.isJavaIdentifierPart(source.charAt(pos - 1)) || pos + len != srcLen && Character.isJavaIdentifierPart(source.charAt(pos + len)))) {
                    return pos;
                }
                fromIndex += len;
            }
        }
        if (isLast) {
            while (true) {
                int pos;
                if ((pos = source.lastIndexOf(target, fromIndex)) == -1) {
                    return -1;
                }
                if (!(pos != 0 && Character.isJavaIdentifierPart(source.charAt(pos - 1)) || pos + len != srcLen && Character.isJavaIdentifierPart(source.charAt(pos + len)))) {
                    return pos;
                }
                fromIndex -= len;
            }
        }
        int pos;
        while ((pos = source.indexOf(target, fromIndex)) != -1) {
            if (!(pos != 0 && Character.isJavaIdentifierPart(source.charAt(pos - 1)) || pos + len != srcLen && Character.isJavaIdentifierPart(source.charAt(pos + len)))) {
                return pos;
            }
            fromIndex += len;
        }
        return -1;
    }

    /*
     * Unable to fully structure code
     */
    private static int indexOf(String source, String target, int fromIndex, boolean ignoreCase, boolean skipQuotation) {
        block24: {
            sourceCount = source.length();
            targetCount = target.length();
            if (fromIndex >= sourceCount) {
                return targetCount == 0 ? sourceCount : -1;
            }
            if (fromIndex < 0) {
                fromIndex = 0;
            }
            if (targetCount == 0) {
                return fromIndex;
            }
            first = target.charAt(0);
            max = sourceCount - targetCount;
            if (!ignoreCase) break block24;
            upFirst = Character.toUpperCase(first);
            if (skipQuotation) {
                i = fromIndex;
                while (i <= max) {
                    block21: {
                        while ((c = source.charAt(i)) != first && Character.toUpperCase(c) != upFirst) {
                            if (c == '\"' || c == '\'') {
                                if ((i = source.indexOf(c, i + 1)) == -1) {
                                    return -1;
                                }
                                if (++i <= max) continue;
                                return -1;
                            }
                            if (++i <= max) continue;
                            return -1;
                        }
                        j = i + 1;
                        k = 1;
                        while (k < targetCount) {
                            if (source.charAt(j) == target.charAt(k) || Character.toUpperCase(source.charAt(j)) == Character.toUpperCase(target.charAt(k))) {
                                ++j;
                                ++k;
                                continue;
                            }
                            break block21;
                        }
                        return i;
                    }
                    ++i;
                }
                return -1;
            }
            i = fromIndex;
            ** GOTO lbl54
            {
                if (++i > max) {
                    return -1;
                }
                do {
                    block22: {
                        if (source.charAt(i) != first && Character.toUpperCase(source.charAt(i)) != upFirst) continue block3;
                        j = i + 1;
                        k = 1;
                        while (k < targetCount) {
                            if (source.charAt(j) == target.charAt(k) || Character.toUpperCase(source.charAt(j)) == Character.toUpperCase(target.charAt(k))) {
                                ++j;
                                ++k;
                                continue;
                            }
                            break block22;
                        }
                        return i;
                    }
                    ++i;
lbl54:
                    // 2 sources

                } while (i <= max);
            }
            return -1;
        }
        i = fromIndex;
        while (i <= max) {
            block23: {
                while ((c = source.charAt(i)) != first) {
                    if (c == '\"' || c == '\'') {
                        if ((i = source.indexOf(c, i + 1)) == -1) {
                            return -1;
                        }
                        if (++i <= max) continue;
                        return -1;
                    }
                    if (++i <= max) continue;
                    return -1;
                }
                j = i + 1;
                k = 1;
                while (k < targetCount) {
                    if (source.charAt(j) == target.charAt(k)) {
                        ++j;
                        ++k;
                        continue;
                    }
                    break block23;
                }
                return i;
            }
            ++i;
        }
        return -1;
    }

    /*
     * Unable to fully structure code
     */
    public static int lastIndexOf(String source, String target, int fromIndex, boolean ignoreCase, boolean skipQuotation) {
        if (fromIndex < 0) {
            return -1;
        }
        targetCount = target.length();
        sourceCount = source.length();
        rightIndex = sourceCount - targetCount;
        if (fromIndex > rightIndex) {
            fromIndex = rightIndex;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        lastIndex = targetCount - 1;
        lastChar = target.charAt(lastIndex);
        if (!ignoreCase) ** GOTO lbl60
        upLast = Character.toUpperCase(lastChar);
        if (!skipQuotation) ** GOTO lbl41
        block0: for (i = lastIndex + fromIndex; i >= lastIndex; --i) {
            while ((c = source.charAt(i)) != lastChar && Character.toUpperCase(c) != upLast) {
                if (c == '\"' || c == '\'') {
                    if ((i = source.lastIndexOf(c, i - 1)) == -1) {
                        return -1;
                    }
                    if (--i >= lastIndex) continue;
                    return -1;
                }
                if (--i >= lastIndex) continue;
                return -1;
            }
            j = i;
            k = lastIndex;
            while (k > 0) {
                if ((s = source.charAt(--j)) == (t = target.charAt(--k)) || Character.toUpperCase(s) == Character.toUpperCase(t)) continue;
                continue block0;
            }
            return j;
        }
        return -1;
lbl-1000:
        // 2 sources

        {
            block16: {
                if ((c = source.charAt(i)) != lastChar && Character.toUpperCase(c) != upLast) {
                    if (--i >= lastIndex) continue;
                    return -1;
                }
                j = i;
                k = lastIndex;
                while (k > 0) {
                    if ((s = source.charAt(--j)) == (t = target.charAt(--k)) || Character.toUpperCase(s) == Character.toUpperCase(t)) continue;
                    --i;
                    break block16;
                }
                return j;
            }
            if (i < lastIndex) break;
            ** while (true)
        }
        return -1;
lbl-1000:
        // 3 sources

        {
            block17: {
                if ((c = source.charAt(i)) != lastChar) {
                    if (c == '\"' || c == '\'') {
                        if ((i = source.lastIndexOf(c, i - 1)) == -1) {
                            return -1;
                        }
                        if (--i >= lastIndex) continue;
                        return -1;
                    }
                    if (--i >= lastIndex) continue;
                    return -1;
                }
                j = i;
                k = lastIndex;
                while (k > 0) {
                    if (source.charAt(--j) == target.charAt(--k)) continue;
                    --i;
                    break block17;
                }
                return j;
            }
            if (i < lastIndex) break;
            ** while (true)
        }
        return -1;
    }

    /*
     * Unable to fully structure code
     */
    public static int indexOfIgnoreCase(String source, String target, int fromIndex) {
        sourceCount = source.length();
        targetCount = target.length();
        if (fromIndex >= sourceCount) {
            return targetCount == 0 ? sourceCount : -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        first = target.charAt(0);
        upFirst = Character.toUpperCase(first);
        max = sourceCount - targetCount;
        i = fromIndex;
        ** GOTO lbl29
        {
            if (++i > max) {
                return -1;
            }
            do {
                block8: {
                    if (source.charAt(i) != first && Character.toUpperCase(source.charAt(i)) != upFirst) continue block0;
                    j = i + 1;
                    k = 1;
                    while (k < targetCount) {
                        if (source.charAt(j) == target.charAt(k) || Character.toUpperCase(source.charAt(j)) == Character.toUpperCase(target.charAt(k))) {
                            ++j;
                            ++k;
                            continue;
                        }
                        break block8;
                    }
                    return i;
                }
                ++i;
lbl29:
                // 2 sources

            } while (i <= max);
        }
        return -1;
    }

    public static String getNewName(String pre, String[] existsNames) {
        ArrayList<String> names = new ArrayList<String>();
        if (existsNames != null) {
            int size = existsNames.length;
            int i = 0;
            while (i < size) {
                names.add(existsNames[i]);
                ++i;
            }
        }
        return StringUtils.getNewName(pre, names);
    }

    public static String getNewName(String pre, ArrayList<String> names) {
        if (names == null) {
            names = new ArrayList();
        }
        if (!names.contains(pre)) {
            return pre;
        }
        int index = 1;
        while (names.contains(String.valueOf(pre) + index)) {
            ++index;
        }
        return String.valueOf(pre) + index;
    }

    public static final boolean matches(byte[] value, int pos1, int len1, byte[] fmt) {
        if (value == null || fmt == null) {
            return false;
        }
        return StringUtils.matches(value, pos1, len1, fmt, 0);
    }

    public static final boolean matches_fast(byte[] value, int pos1, int len1, byte[] fmt) {
        if (value == null || fmt == null) {
            return false;
        }
        return StringUtils.matches_fast(value, pos1, len1, fmt, 0);
    }

    private static final boolean matches_fast(byte[] src, int pos1, int len1, byte[] fmt, int pos2) {
        int len2 = fmt.length;
        boolean any = false;
        block0: while (pos2 < len2) {
            byte ch = fmt[pos2];
            if (ch == 42) {
                ++pos2;
                any = true;
                continue;
            }
            if (any) {
                while (pos1 < len1) {
                    if (src[pos1++] != ch || !StringUtils.matches_fast(src, pos1, len1, fmt, pos2 + 1)) continue;
                    return true;
                }
                return false;
            }
            if (pos1 == len1 || src[pos1++] != ch) {
                return false;
            }
            ++pos2;
            while (pos2 < len2) {
                ch = fmt[pos2];
                if (ch == 42) {
                    any = true;
                    ++pos2;
                    continue block0;
                }
                if (pos1 == len1 || src[pos1++] != ch) {
                    return false;
                }
                ++pos2;
            }
        }
        return any || pos1 == len1;
    }

    private static final boolean matches(byte[] src, int pos1, int len1, byte[] fmt, int pos2) {
        int len2 = fmt.length;
        boolean any = false;
        block0: while (pos2 < len2) {
            byte c;
            byte ch = fmt[pos2];
            if (ch == 42) {
                ++pos2;
                any = true;
                continue;
            }
            if (ch == 63) {
                if (++pos1 > len1) {
                    return false;
                }
                ++pos2;
                continue;
            }
            if (any) {
                if (ch == 92 && pos2 + 1 < len2 && ((c = fmt[pos2 + 1]) == 42 || c == 63)) {
                    ch = c;
                    ++pos2;
                }
                while (pos1 < len1) {
                    if (src[pos1++] != ch || !StringUtils.matches(src, pos1, len1, fmt, pos2 + 1)) continue;
                    return true;
                }
                return false;
            }
            if (ch == 92 && pos2 + 1 < len2 && ((c = fmt[pos2 + 1]) == 42 || c == 63)) {
                ch = c;
                ++pos2;
            }
            if (pos1 == len1 || src[pos1++] != ch) {
                return false;
            }
            ++pos2;
            while (pos2 < len2) {
                ch = fmt[pos2];
                if (ch == 42) {
                    any = true;
                    ++pos2;
                    continue block0;
                }
                if (ch == 63) {
                    if (++pos1 > len1) {
                        return false;
                    }
                    ++pos2;
                    continue;
                }
                if (ch == 92 && pos2 + 1 < len2 && ((c = fmt[pos2 + 1]) == 42 || c == 63)) {
                    ch = c;
                    ++pos2;
                }
                if (pos1 == len1 || src[pos1++] != ch) {
                    return false;
                }
                ++pos2;
            }
        }
        return any || pos1 == len1;
    }

    public static boolean isAssicString(String str) {
        if (str == null) {
            return true;
        }
        int len = str.length();
        if (len == 0) {
            return true;
        }
        int i = 0;
        while (i < len) {
            char ch = str.charAt(i);
            if (ch < '\u0000' || ch >= '\u0080') {
                return false;
            }
            ++i;
        }
        return true;
    }
}

